;~ mise  jour : lun 29 oct 2012
;~ ajout de la fonction _Remplace pour grer les fichiers de messages
;~ ajout des messages internes par dfaut

#include-once

#region PARAMETRES_INTERNES_PAR_DEFAUT

;~ ************************************************************************
;~ Valeurs internes par defaut
;~ ************************************************************************

$fichier_ini = @ScriptDir & "\infosquota.ini"
$int_seuil = 90
$int_temps_affichage = 5
$int_aff_quota_0 = 1
$int_aff_delai = 1
$int_emplacement_quota = @ScriptDir & "\quotas.txt"
$int_aff_stockage = 1
$int_aff_alertes = 0

#endregion



#region MESSAGES_PAR_DEFAUT

;~ ************************************************************************
;~ Messages par defaut
;~ ************************************************************************

;~ utilise les chaines :
;~ [%USER%] : login de l'utilisateur
;~ [%MB_LIMIT%] : quota disque de l'utilisateur
;~ [%MB_USED%] : espace utilis
;~ [%MB_SYMB%] : symbole (Mo ou MB)
;~ [%DELAY%] : dlai disponible

$int_TITRE = "Informations quota"

$int_MSG_MEGA = "Mo"

$int_MSG_NORMAL = "Utilisateur :"&@TAB&"[%USER%]"&@CRLF&@CRLF&"Quota disque :"&@TAB&"[%MB_LIMIT%] [%MB_SYMB%]"&@CRLF&"Espace utilis :"&@TAB&"[%MB_USED%] [%MB_SYMB%] ([%POURCENT%] %)"
$int_MSG_SEUIL_ATTEINT = "Utilisateur :"&@TAB&"[%USER%]"&@CRLF&@CRLF&"Quota disque :"&@TAB&"[%MB_LIMIT%] [%MB_SYMB%]"&@CRLF&"Espace utilis :"&@TAB&"[%MB_USED%] [%MB_SYMB%] ([%POURCENT%] %)"&@CRLF&@CRLF&"Vous risquez de ne bientt plus pouvoir enregistrer vos donnes, ou mme utiliser certains logiciels..."&@CRLF&@CRLF&"Pensez  faire le mnage dans vos fichiers !"
$int_MSG_DEPASSEMENT = "Utilisateur :"&@TAB&"[%USER%]"&@CRLF&@CRLF&"Quota disque :"&@TAB&"[%MB_LIMIT%] [%MB_SYMB%]"&@CRLF&"Espace utilis :"&@TAB&"[%MB_USED%] [%MB_SYMB%]"&@CRLF&@CRLF&"Vous devez imprativement faire du mnage dans vos fichiers ! Les logiciels ne vont plus fonctionner !"
$int_MSG_ERREUR_LECTURE = "Utilisateur :"&@TAB&"[%USER%]"&@CRLF&@CRLF&"Lecture de votre quota actuellement indisponible."
$int_MSG_QUOTA0 = "Utilisateur :"&@TAB&"[%USER%]"&@CRLF&@CRLF &"Espace utilis :"&@TAB&"[%MB_USED%] [%MB_SYMB%]"

$int_DELAI_AUCUN = @CRLF&@CRLF&"Dlai restant : AUCUN !"
$int_1jour = @CRLF&@CRLF&"Dlai restant : 1 jour avant blocage !!!"
$int_2jours = @CRLF&@CRLF&"Dlai restant : 2 jours avant blocage !"
$int_3jours = @CRLF&@CRLF&"Dlai restant : 3 jours avant blocage !"
$int_4jours = @CRLF&@CRLF&"Dlai restant : 4 jours avant blocage !"
$int_5jours = @CRLF&@CRLF&"Dlai restant : 5 jours avant blocage !"
$int_6jours = @CRLF&@CRLF&"Dlai restant : 6 jours avant blocage !"
$int_7jours = @CRLF&@CRLF&"Dlai restant : 7 jours avant blocage !"
$int_DELAI_INCONNU = @CRLF&@CRLF&"Dlai restant indisponible"
$int_DELAI_AVEC_TEMPS = @CRLF&@CRLF&"Dlai restant : [%DELAY%]   --> DEPECHEZ-VOUS !!!"

#endregion

#region FONCTION__REMPLACE

;~ ************************************************************************
;~ Fonction _Remplace
;~ remplace dans les messages les chaines de caractres par leur valeur
;~ ************************************************************************

func _Remplace($chaine, $user, $symb = "Mo", $used = "", $limit = "", $pourcent = "", $delai = "")
	$chaine = StringReplace ( $chaine, '[%USER%]', $user)
	$chaine = StringReplace ( $chaine, '[%MB_SYMB%]', $symb)
	$chaine = StringReplace ( $chaine, '[%MB_USED%]', $used)
	$chaine = StringReplace ( $chaine, '[%MB_LIMIT%]', $limit)
	$chaine = StringReplace ( $chaine, '[%POURCENT%]', $pourcent)
	$chaine = StringReplace ( $chaine, '[%DELAY%]', $delai)
	Return $chaine
EndFunc

#endregion

#region FONCTION__TEMPS_VALIDE

;~ ************************************************************************
;~ Fonction _TempsValide
;~ utilise pour un dlai <  48 heures
;~ * 0 si la chaine n'est pas valide
;~ * un tableau [ 2 ; hh ; mm ] si la chaine est correcte
;~ ************************************************************************

Func _TempsValide($string_temps)
;~ renvoie 0 si la chaine est incorrecte
;~ renvoie un tableau [ 2 ; hh ; mm ] si la chaine est correcte

;~ 	chaine  5 caracteres
	If StringLen($string_temps) <> 5 Then Return 0

;~ chaine en 2 parties, sparees par un :
	$decoupe = StringSplit($string_temps, ":")
	If $decoupe[0] <> 2 Then Return 0

;~ 	chaine composee uniquement de chiffres
	if ((StringIsDigit($decoupe[1]) = 0) Or (StringIsDigit($decoupe[2]) = 0)) Then Return 0

;~ 	heures < 48
	If $decoupe[1] > 48 Then Return 0
;~ 	minutes < 60
	If $decoupe[2] > 59 Then Return 0

	Return $decoupe

EndFunc   ;==>_TempsValide

#endregion

#region FONCTIONS_MESSAGES

Func _alerte_pas_quota($_temps = $int_temps_affichage, $_alertes = $int_aff_alertes)
	Local $message = _Remplace($int_MSG_ERREUR_LECTURE, @UserName)
	If $_alertes = 1 Then MsgBox(0x40030, $int_TITRE, $message, $_temps)
	Return 0
EndFunc   ;==>_alerte_pas_quota

Func _Message_quota_0($_param, $_temps = $int_temps_affichage)
	Local $message = _Remplace ( $int_MSG_QUOTA0, @UserName, $int_MSG_MEGA, Ceiling($_param[2] / 1024) )
	MsgBox(0x40040, $int_TITRE, $message, $_temps)
EndFunc

Func _Message_quota_OK($_param, $_temps = $int_temps_affichage)
	Local $message = _Remplace ( $int_MSG_NORMAL , @UserName , $int_MSG_MEGA , Ceiling($_param[2] / 1024) , Round($_param[3] / 1024, 0) , Ceiling($_param[2] * 100 / $_param[3]) )
	MsgBox(0x40040, $int_TITRE, $message, $_temps) ;~ *** MESSAGE *** OK, affichage de l'espace utilis ; fermeture automatique
EndFunc

Func _Message_quota_seuil($_param )
	Local $message = _Remplace ( $int_MSG_SEUIL_ATTEINT , @UserName , $int_MSG_MEGA , Ceiling($_param[2] / 1024) , Round($_param[3] / 1024, 0) , Ceiling($_param[2] * 100 / $_param[3]) )
	MsgBox(0x40030, $int_TITRE , $message) ;~ *** MESSAGE *** dpassement du seuil ; validation par l'utilisateur ncessaire
EndFunc

Func _Message_quota_depasse($_param, $_aff_delai = $int_aff_delai)
	Local $message = _Remplace ( $int_MSG_DEPASSEMENT , @UserName , $int_MSG_MEGA , Ceiling($_param[2] / 1024) , Round($_param[3] / 1024, 0) , "" )
	If $_aff_delai = 1 Then $message &= _MessageDelai($_param[5]) ;~ complt avec le dlai disponible
	MsgBox(0x40010, $int_TITRE , $message) ;~ *** MESSAGE *** dpassement du quota ; validation par l'utilisateur ncessaire
EndFunc

Func _MessageDelai($string_delai)
	if ($string_delai <> "") Then
		Switch $string_delai
			Case "none", "aucun"
				Return $int_DELAI_AUCUN
			Case "1day", "1days"
				Return $int_1jour
			Case "2days", "2day"
				Return $int_2jours
			Case "3days", "3day"
				Return $int_3jours
			Case "4days", "4day"
				Return $int_4jours
			Case "5days", "5day"
				Return $int_5jours
			Case "6days", "6day"
				Return $int_6jours
			Case "7days", "7day"
				Return $int_7jours
			Case Else
				$temps_lu = _TempsValide($string_delai)
				If $temps_lu <> 0 Then
					Return StringReplace ( $int_DELAI_AVEC_TEMPS , "[%DELAY%]" , $temps_lu[1] & "h " & $temps_lu[2] & "min" )
				Else
					Return $int_DELAI_INCONNU
				EndIf
		EndSwitch
	Else
		Return $int_DELAI_INCONNU
	EndIf
EndFunc   ;==>_MessageDelai

#endregion