<?php

if (file_exists('./config/config.inc.php')) require_once ('./config/config.inc.php'); 
global $LDAP_CONNECTION;
global $fgdebug;
$fgdebug=false;

function connecteLDAP() {
    global $LDAP_HOST;
    global $LDAP_PORT;
    global $LDAP_USER;
    global $LDAP_PASSWORD;
    global $LDAP_TLS;
    global $LDAP_CONNECTION;

    if(!$LDAP_CONNECTION){
        $ldapConn = ldap_connect($LDAP_HOST, $LDAP_PORT);
        ldap_set_option($ldapConn, LDAP_OPT_PROTOCOL_VERSION, 3);
        ldap_set_option($ldapConn, LDAP_OPT_REFERRALS, 0);
        if($LDAP_TLS) ldap_start_tls($ldapConn);

        if(ldap_bind( $ldapConn, $LDAP_USER, $LDAP_PASSWORD)){
            $LDAP_CONNECTION = $ldapConn;
        }
    }

    if(!$LDAP_CONNECTION) {
        echo "Erreur à la connexion à votre annuaire";
        return false;
    }
    return true;
}

function recupInfosUserLDAP($login, $infosComplementaires=false) {
    global $LDAP_USERUID;
    global $LDAP_GROUPMEMBER;

    debug("<b>RECHERCHE ANNUAIRE POUR</b>");
    debug("login = $login");
    debug("");

    // Construction du tableau d'attributs ldap à retourner
    $champs=array('sn','givenname','dn','homedirectory','divcod','objectclass','mail');
	if (is_array($infosComplementaires)) {
		foreach ($infosComplementaires as $info) {
			$champs[]=$info;
		}
    }
    debug("<b>Recherche des attributs</b>");
    debug($champs);
    debug("");

    // Recherche de l'utilisateur connecté
    $ldapuser=search("$LDAP_USERUID=$login",$champs);
    debug("<b>Valeurs trouvées</b>");
    debug($ldapuser);
    
    // Définition de son profil
    if($login=="admin")
        $profiluser="administrateur";
    else if (stristr($ldapuser[0]['dn'],'ou=personnels')!==false) {
		if (is_array($ldapuser[0]['objectclass']) && in_array("administratif",$ldapuser[0]['objectclass'])) {
			$profiluser="administratif";
		} else {
			$profiluser="professeur";
		}
	} else if (stristr($ldapuser[0]['dn'],'ou=eleves')!==false) {
		$profiluser="eleve";
	} else if (stristr($ldapuser[0]['dn'],'ou=responsables')!==false) {
		$profiluser="responsable";
	} else {
		$profiluser="autre";
    }
    debug("Profil = $profiluser");
    debug("");
    
    // Recherche des groupes de l'utilisateur
    debug("<b>Recherche des groupes</b>");
    if($LDAP_GROUPMEMBER=="member") {
        debug("($LDAP_GROUPMEMBER=".$ldapuser[0]["dn"].")");
        $ldapgroups=search("($LDAP_GROUPMEMBER=".$ldapuser[0]["dn"].")",['cn','dn','type']);
    }
    else {
        debug("($LDAP_GROUPMEMBER=".$login.")");
        $ldapgroups=search("($LDAP_GROUPMEMBER=".$login.")",['cn','dn','type']);	
    }
    debug("");
    debug("<b>Valeurs trouvées</b>");
    debug($ldapgroups);

	$tGrp=array();
	if(is_array($ldapgroups)) {
        foreach ($ldapgroups as $_tGrp) {
		    if ($_tGrp['type']=="") $_tGrp['type']="general";
            $tGrp[$_tGrp['type']][]=$_tGrp['cn'];
        }
    }
    
    $return = [
        'nom'=>strtoupper($ldapuser[0]['sn']),
        'prenom'=>ucfirst(strtolower($ldapuser[0]['givenname'])),
        'profil'=>$profiluser,
        'div'=>$ldapuser[0]['divcod'],
        'home'=>$ldapuser[0]['homedirectory'],
        'groupes'=>$tGrp
    ];

    debug("");
    debug("<b>Valeurs retournées</b>");
    debug($return);   
    debug("");
    debug("<b>FIN LDAP</b>");
    debug(""); 

    return $return;
}

function search($filter, $attributes = array()) {
    global $LDAP_BASEDN;
    global $LDAP_CONNECTION;
    if(!$LDAP_CONNECTION) connecteLDAP();

    $result = ldap_search($LDAP_CONNECTION, $LDAP_BASEDN, $filter, $attributes,0,0,0);
    if(!$result) {
        ldapError();
    }
    return resultToArray($result);
}

function resultToArray($result){
    global $LDAP_CONNECTION;
    if(!$LDAP_CONNECTION) connecteLDAP();

    $resultArray = array();
    if($result){
        $entry = ldap_first_entry($LDAP_CONNECTION, $result);
        while ($entry){
            $row = array();
            $attr = ldap_first_attribute($LDAP_CONNECTION, $entry);
            while ($attr){
                $val = ldap_get_values_len($LDAP_CONNECTION, $entry, $attr);
                if(array_key_exists('count', $val) AND $val['count'] == 1){
                    $row[strtolower($attr)] = $val[0];
                } else {
                    $row[strtolower($attr)] = $val;
                }
                $attr = ldap_next_attribute($LDAP_CONNECTION, $entry);
            }

            $dn = ldap_get_dn($LDAP_CONNECTION, $entry);  
            $row["dn"]=$dn;

            $resultArray[] = $row;
            $entry = ldap_next_entry($LDAP_CONNECTION, $entry);
        }
    }

    return $resultArray;
}

function ldapError(){
    global $LDAP_CONNECTION;
    throw new Exception(
        'Error: ('. ldap_errno($LDAP_CONNECTION) .') '. ldap_error($LDAP_CONNECTION)
    );
}

function recupDataLDAP2($choixLDAP, $choixDN, $champs, $filtre="(objectClass=*)") {
	global $cnxLDAP;
	
	$tabData=false;
	if ($choixDN!="") $choixDN.=","; 
	if (!$cnxLDAP[$choixLDAP]['etat']) { //si pas encore connect�
		if ((connecteLDAP($choixLDAP))===false) {
			die($cnxLDAP['message']);
		} //else echo "Connexion LDAP $choixLDAP OK !".BRCR;
	}
	$sr=$count=$info=NULL;
	//if (trim($filtre)=='') $filtre='(objectClass=*)';
	//echo "<br>dn:".$choixDN.$cnxLDAP[$choixLDAP]['baseDN']."<br>\n".$filtre."<br>\n";
	$sr=ldap_search($cnxLDAP[$choixLDAP]['ds'],$choixDN.$cnxLDAP[$choixLDAP]['baseDN'], $filtre, $champs);
	
	if($sr)	$info=ldap_get_entries($cnxLDAP[$choixLDAP]['ds'], $sr);
	
	for ($i=0; $i<$info["count"]; $i++) {
		if (is_array($champs)) foreach ($champs as $valC) {
			if ($valC=="dn") {
				$tabData[$i][$valC]=$info[$i]['dn'];
			} else {
				if (count($info[$i][$valC])>2) {
					foreach ($info[$i][$valC] as $_idx => $_val) {
						if ( is_numeric($_idx)) {
							$tabData[$i][$valC][$_idx]=$_val;
						}
					}
				}	else {
					$tabData[$i][$valC]=$info[$i][$valC][0];
				} 
			}
		}		
	}

	return $tabData;
}

function debug($debug) {
    global $fgdebug;
    if($fgdebug) {
        if(is_array($debug)) {
            foreach($debug as $key =>  $value) {
                if(is_array($value)) {
                    if($key>0) echo "<br>";
                    echo "Entry $key<br>";
                    foreach($value as $k =>  $v) {
                        if(is_array($v)) {
                            echo $k." = ";
                            foreach($v as $sk =>  $sv) {
                                if($sk>0) echo " - ";
                                echo $sv;
                            }
                            echo "<br>";
                        }
                        else echo "$k = $v<br>";
                    }
                }
                else echo "$key = $value<br>";
            }
        }   
        else
            echo $debug."<br>";

    }
}


?>