<?php
/*---------------------------------------------------------------
		quota.php
-----------------------------------------------------------------
	Affichage de l'état des quotas
-----------------------------------------------------------------
	auteur : Olivier HACQUARD - Académie de Besançon   
---------------------------------------------------------------*/
include ('./inc/f_session_scribe.inc.php');
include ('./inc/f_ldap_scribe.inc.php');

//initialisation de la Session et recup de l'uid
recupUid();

include ('./inc/f_scribe.inc.php');
//verifie si l'utilisateur connecté est du login ou du groupe mis dans la liste (ELEVES, PROFS, etc...)
//verifAccesPage("admin");
verifAccesPage($comptesAutorises);


$titrePage="Evaluation des Quotas utilisateurs de Scribe";
$filtreCompte=array("root","admin.profil","gestion","raip","proftest","www-data","ftp","mail","scribe");

//------------------- Controler ----------------------
if (isset($_GET['limQuota']) && is_numeric($_GET['limQuota']))	$limiteQuota=intval($_GET['limQuota']); 
else 
//limite d'affichage des quotas (en Mo)
	$limiteQuota=1000; 

$limiteQuota*=1000; //on le ramène en ko
//---------------------------------- Module ---------------------------------------------------
$cumulQuota=$cumulP=$cumulE=$cumulF=$cumulQuotaLimite=0;

$page=$pageE=$pageP=$pageA=$pageF="";

$tabH_A=new tableau_HTML(5,2);
$tabH_E=new tableau_HTML(5,2);
$tabH_P=new tableau_HTML(5,2);
$tabH_F=new tableau_HTML(5,2);
 
$tab=array("login","espace<br/>utilisé","quota autorisé<br/>(délai restant)","détails","liste des fichiers<br/>en dehors du perso"); 
$tabH_A->ajoute1Ligne($tab);
$tabH_E->ajoute1Ligne($tab);
$tabH_P->ajoute1Ligne($tab);
$tabH_F->ajoute1Ligne($tab);


//fichier contenant les infos sur les quotas
$fichier="./__inutile/quotas.txt";
if (!file_exists($fichier)) $fichier="/home/netlogon/infosquota/quotas.txt";

//vérification de la présence du fichier des quotas (normalement dans netlogon/infosquota
if (file_exists($fichier)) $prePage="<div id=\"indicFichier\">Le fichier quotas existe... créé le <b>". date ("d/m/Y à H:i:s", filemtime($fichier))."</b></div>";
else { //fichier des quotas introuvables
	include('ficInexistant.html');
	exit();
	$prePage="ERREUR ! : Le fichier des quotas est introuvable...";
}

//lecture du fichier et récup des informations utilisateurs
$fd = fopen($fichier, 'r' ); 
while (($buffer = fgets($fd)) !== false) {
	list($login,$quota,$qMax,$qMax2,$delai)=explode(',',$buffer);
	$leDelai="";
	if (strpos($delai,'days')!==false) $leDelai="reste ".intval($delai)." jours";
	else if (strpos($delai,':')!==false) {
		if ($delai[0]=='0') $delai=substr($delai,1);
		if ($delai[0]=='0') $leDelai="reste ".substr($delai,2)."mn";
		else $leDelai="reste ".str_replace(':','h',$delai);
	}
	else if (strpos($delai,'none')!==false) $leDelai='délai dépassé';
	$quotaN=intval($quota);
	$qMaxN=intval($qMax);
	$_tUser=recupInfosUserLDAP($login); //recup des infos de l'utilisateur dans le ldap
	//print_r($_tUser);
	//calcul des cumuls de quota
	$cumulQuota+=$quotaN;
	if ($_tUser['profil']=="professeur") $cumulP+=$quotaN;
	else if ($_tUser['profil']=="administratif") $cumulF+=$quotaN;
	else if ($_tUser['profil']=="eleve") $cumulE+=$quotaN;
	//pour les quotas supérieurs à la limite
	if ($quotaN>$limiteQuota && !in_array($login,$filtreCompte) && $login[0]!='#') {	
		$tDetails[$login]=$_tUser; //mémorise les infos de l'utilisateur
		$tQuota[$login]=$quotaN; //mémorise le quota
		$tQMax[$login]=$qMaxN; //mémorise le quota max
		$tDelai[$login]=$leDelai;
		$cumulQuotaLimite+=$quotaN; //cumul du quota limité
	}
}
fclose( $fd ); 

if (is_array($tQuota) && count($tQuota)>0) { //si on a bien un tableau avec des valeurs...
	arsort($tQuota); //trie les quotas dans l'ordre décroissant
	
	//fabrication de l'affichage par catégorie
	$idxL_E=$idxL_P=$idxL_A=$idxL_F=2;
	foreach ($tQuota as $_login=>$_quotaN)  {

        $_ficLog=$cheminLogs.'/'.$_login.'.log';
		//echo $_ficLog." - ";
		if (file_exists($_ficLog)) $lienFicData='<i><a href="./afficheFic.php?type=logQuota&login='.$_login.'" target="_blank">voir la liste</a></i>';
		else $lienFicData="<i>non trouvé</i>"; //$_ficLog;
		//eleves
		if (($tQMax[$_login]>0) && ($tQMax[$_login]<$_quotaN)) $_style="color:red"; else $_style="";
		if ($tQMax[$_login]==0) $qMax="<i>pas de limite définie</i>"; else $qMax="<i>".number_format($tQMax[$_login]/1024,0,',',' ')."Mo</i>";
		if (in_array($_login,array("admin","gestion","admin.profil","raip","proftest"))) $tDetails[$_login]['profil']="autres";
		if ($tDelai[$_login]!="") $_delai='<br/>(<i>'.$tDelai[$_login].'</i>)'; 
		else $_delai="";
		switch ($tDetails[$_login]['profil']) {
			case "eleve" : 
				$_ident=$tDetails[$_login]['nom']." ".$tDetails[$_login]['prenom']." - ".$tDetails[$_login]['profil']." / ".$tDetails[$_login]['div'];
				/*
				$pageE.="*<span style=\"$_style\">$_login : <b>".number_format($_quotaN/1024,0,',',' ')."Mo</b> ($qMax) (".$_ident.")</span> ".$lienFicData.BRCR;// / $_homedir".BRCR;
				*/
				if ($_style!="") $tabH_E->formatLigne($idxL_E,'style',$_style);
				$tabH_E->ajoute1Ligne(array($_login,"<b>".number_format($_quotaN/1024,0,',',' ')."Mo</b>",$qMax.$_delai,$_ident,$lienFicData));
				$pageE='1';
				$idxL_E++;
				break;
			case "professeur": 
				$_ident=$tDetails[$_login]['nom']." ".$tDetails[$_login]['prenom']." - ".$tDetails[$_login]['profil'];
				/*
				$pageP.="*<span style=\"$_style\">$_login : <b>".number_format($_quotaN/1024,0,',',' ')."Mo</b> ($qMax) (".$tDetails[$_login]['nom']." ".$tDetails[$_login]['prenom']." - ".$tDetails[$_login]['groupep'].")</span> ".$lienFicData.BRCR;// / $_homedir".BRCR;
				*/
				if ($_style!="") $tabH_P->formatLigne($idxL_P,'style',$_style);
				$tabH_P->ajoute1Ligne(array($_login,"<b>".number_format($_quotaN/1024,0,',',' ')."Mo</b>",$qMax.$_delai,$_ident,$lienFicData));
				$pageP='1';
				$idxL_P++;
				break;
			case "administratif": 
				$_ident=$tDetails[$_login]['nom']." ".$tDetails[$_login]['prenom']." - ".$tDetails[$_login]['profil'];
				/*
				$pageF.="*<span style=\"$_style\">$_login : <b>".number_format($_quotaN/1024,0,',',' ')."Mo</b> ($qMax) (".$_ident.")</span> ".$lienFicData.BRCR;// / $_homedir".BRCR;
				*/
				if ($_style!="") $tabH_F->formatLigne($idxL_F,'style',$_style);
				$tabH_F->ajoute1Ligne(array($_login,"<b>".number_format($_quotaN/1024,0,',',' ')."Mo</b>",$qMax.$_delai,$_ident,$lienFicData));
				$pageF='1';
				$idxL_F++;
				break;
			default :
				if (trim($tDetails[$_login]['nom'])=="") $_ident="<i>utilisateur inconnu</i>";
				else $_ident=$tDetails[$_login]['nom']." ".$tDetails[$_login]['prenom']." - ".$tDetails[$_login]['profil'];
				/*
				$pageA.="*<span style=\"$_style\">$_login : <b>".number_format($_quotaN/1024,0,',',' ')."Mo</b> ($qMax) (".$_ident.")</span> ".$lienFicData.BRCR;// / $_homedir".BRCR;
				*/
				if ($_style!="") $tabH_A->formatLigne($idxL_A,'style',$_style);
				$tabH_A->ajoute1Ligne(array($_login,"<b>".number_format($_quotaN/1024,0,',',' ')."Mo</b>",$qMax.$_delai,$_ident,$lienFicData));
				$pageA='1';
				$idxL_A++;
	
		}
		
	}
}

$tabH_A->appliqueStyle();
$tabH_P->appliqueStyle();
$tabH_E->appliqueStyle();
$tabH_F->appliqueStyle();
$tabH_A->formatTableau("align","center");

//bilan
$page.="<b>Total</b> : ".number_format($cumulQuota/(1024*1024),1,',',' ')."Go | <b>Profs</b> : ".number_format($cumulP/(1024*1024),1,',',' ')."Go | <b>Eleves</b> : ".number_format($cumulE/(1024*1024),1,',',' ')."Go | <b>Au dessus de la limite</b> : ".number_format($cumulQuotaLimite/(1024*1024),1,',',' ')."Go".BRCR;


//------------------- View -------------------------
headerPage();
enteteHTML($titrePage,[
    "./jquery/js/jquery-1.7.1.min.js",
    "./jquery/js/jquery-ui-1.8.17.custom.min.js",
    "./jquery/css/custom-theme2/jquery-ui-1.8.17.custom.css",
    "./bootstrap/css/bootstrap.min.css",
    "./bootstrap/js/bootstrap.min.js",
    "./inc/scribe.css",
    "./inc/tabHTML.css",
    "./images/pFavicon.ico.png"
    ]);

//$nomUser=$_SESSION['_user_']['prenom']." ".$_SESSION['_user_']['nom'];
?>
<div id="contGlobal">
<?php
echo $prePage.CR;
?>
<script language="JavaScript">
	$(function() {
		var togCredit=false;
		var hautCredit=$( "#credit" ).height();
		var decalCredit=hautCredit-$( "#contCredit" ).outerHeight();
		var coulCredit=$( "#clickCredit" ).css("color");
		//alert($( "#credit" ).height()+" - "+$( "#credit" ).outerHeight());
		$( "#tabs" ).tabs();
		$( "input:submit", "*" ).button();
		$( "#credit" ).animate({ top: (-hautCredit+15)+"px" }, 200 );
		$( "#credit" ).click(function(){
			if (!togCredit) $( "#credit" ).animate({ top: (-decalCredit+10)+"px" }, 200 );
			else $( "#credit" ).animate({ top: (-hautCredit+15)+"px" }, 200 );
			togCredit=!togCredit;	
		});
		$( "#credit" ).hover(
		function() {
			$( "#clickCredit" ).css({'font-weight':'bold','color':'black'});
		}, function() {
			$( "#clickCredit" ).css({'font-weight':'normal','color':coulCredit});
		});
		//if (togCredit) $( "#credit" ).delay(1500).animate({ top: "-25px" }, 200 );	
	});//ui-widget-content 
</script>

<div id="contOutil" class="card p-3">

<?php
echo cadreLoginDeconnexion($uid, 3, 5);
?>

<br/>
<h1>Evaluation des quotas utilisateurs de Scribe</h1>
<form action="" method="GET" id="fLimiteQ">
    <div class="alert alert-success" role="alert">
        Afficher les utilisteurs occupant au moins <input type="text" name="limQuota" style="width:60px" value="<?php echo $limiteQuota/1000; ?>" /> Mo 
        <button type="submit" class="btn-primary btn-lg" style="margin-left:10px" >Valider</button>
    </div>
</form>

<?php
if ($limiteQuota<1000000) $valLimite=number_format($limiteQuota/1000,0,',',' ')." Mo";
else $valLimite=number_format($limiteQuota/1000000,1,',',' ')." Go";
echo "<div class=\"indicOutil\">liste des <b>".count($tQMax)."</b> utilisateurs dont l'espace utilisé dépasse <b>".$valLimite."</b></div>".BRCR;
$noLimitQuota="<center>-- Aucun utilisateur ne dépasse la limite de <b>$valLimite</b>...</center>";
?>
    <p style="text-align:left">
        <button class="btn btn-primary" type="button" onClick="$('.collapse').hide();$('#collapsetab1').show();">
            Quotas globaux
        </button>
        <button class="btn btn-primary" type="button" onClick="$('.collapse').hide();$('#collapsetab2').show();">
            Quotas Elèves
        </button>        
        <button class="btn btn-primary" type="button" onClick="$('.collapse').hide();$('#collapsetab3').show();">
            Quotas Profs
        </button>
        <button class="btn btn-primary" type="button" onClick="$('.collapse').hide();$('#collapsetab4').show();">
            Quotas Administratifs
        </button>
        <button class="btn btn-primary" type="button" onClick="$('.collapse').hide();$('#collapsetab5').show();">
            Quotas Autres
        </button>                
    </p>

    <div id="collapsetab1" class="collapse card p-2 bg-light" style="text-align:left">
        <?php
        echo "<h3>Quotas globaux</h3>"; 
        if ($page!="") {
            echo $page;
            echo '<br/>
            <div id="commentTotaux">
            <b>Total</b> correspond à la totalité de données utilisateurs, y compris les comptes systèmes, non affichés dans les tableaux.<br/>
            <b>Au dessus de la limite</b> représente le cumul de l\'espace utilisé par les <b>'.count($tQMax).'</b> utilisateurs affichés dans les tableaux et dont l\'usage disque dépasse <b>'.$valLimite.'</b>.
            </div>';
        }
        else echo "-- Aucun utilisateur en dépassement de quota...";
        ?>
    </div>

    <div id="collapsetab2" class="collapse card p-2 bg-light" style="text-align:left">
        <?php
        echo "<h3>Quotas des Elèves</h3>";
        if ($pageE!="") echo "<center>".CR.$tabH_E->rendu()."</center>".CR;  
        else echo $noLimitQuota;
        ?>
    </div>    


    <div id="collapsetab3" class="collapse card p-2 bg-light" style="text-align:left">
        <?php
        echo "<h3>Quotas des Profs</h3>";
        if ($pageP!="") echo "<center>".CR.$tabH_P->rendu()."</center>".CR;  
        else echo $noLimitQuota;
        ?>
    </div> 


    <div id="collapsetab4" class="collapse card p-2 bg-light" style="text-align:left">
        <?php
        echo "<h3>Quotas des Administratifs</h3>";
        if ($pageF!="") echo "<center>".CR.$tabH_F->rendu()."</center>".CR;  
        else echo $noLimitQuota;
        ?>
    </div> 


    <div id="collapsetab5" class="collapse card p-2 bg-light" style="text-align:left">
        <?php
        echo "<h3>Quotas des Autres</h3>";
        if ($pageA!="") echo "<center>".CR.$tabH_A->rendu()."</center>".CR;  
        else echo $noLimitQuota;
        ?>
    </div> 
</div>

	<?php
	
function versionInfosQuotas() {
	$ficVersion='/home/netlogon/infosquota/version.txt';
	$laVersion='?';
	if (file_exists($ficVersion))  if ($_laVersion=file_get_contents($ficVersion)) $laVersion=$_laVersion;
	return $laVersion;
}

	?>

	<div id="credit" class="ui-corner-all fondRayeBleu">
		<div id="contCredit" style="position:absolute;bottom:10px;width:100%">
	    	<br/>Développé par <a href="mailto:olivier.hacquard@ac-besancon.fr?subject=Quotas%20Scribe%20PHP">Olivier HACQUARD</a> et 
		    <a href="mailto:jerome.labriet@ac-besancon.fr">Jérôme Labriet</a> (Académie de Besançon), en étroite collaboration avec<br/> <a href="mailto:bruno.debeve@ac-bordeaux.fr">Bruno Debeve</a>
		    (Académie de Bordeaux), <a href="mailto:frederic.poyet@ac-dijon.fr">Frédéric Poyet</a> (Académie de Dijon) et		   
		    <a href="mailto:pierre.mariot@ac-besancon.fr">Pierre MARIOT</a> (Académie de Besançon)<br/>
		    <center>
                <table cellpadding="0" cellspacing="0" style="margin:0 0 5px 0;padding:0;"><tr><td>dans le cadre du projet</td><td>&nbsp;&nbsp;<a href="http://eole.orion.education.fr/" target="_blank"><image src="./images/pt_logo_eole.png" title="Projet EOLE - Ensemble Ouvert Libre Evolutif" border="0"/></a></td></tr></table>
            </center>
		</div>
		<div id="leCredit" style="margin:0;position:absolute;bottom:0px;width:100%"><i><?php if ($_version_!="") echo "version interface HTML $_version_ | version moteur infosQuotas ".versionInfosQuotas()." | "; ?></i> <span id="clickCredit">Crédit</span></div>
	</div>
</div>

<script language="JavaScript">$("#tabs").tabs('select', 2);/*document.getElementById('leCredit').innerHTML+=$( "#credit" ).height()+" - "+$( "#contCredit" ).outerHeight()+" - "*/</script>
<?php

finHTML();
//Outil développé par <a href="mailto:olivier.hacquard@ac-besancon.fr">Olivier HACQUARD</a> (Académie de Besançon) d'après le travail sur les quotas de <a href="mailto:bruno.debeve@ac-bordeaux.fr">Bruno DEBEVE</a> (Académie de Bordeaux)<br/>
//<center><table cellpadding="0" cellspacing="0" style="margin:0;padding:0;height:20px;background-color:#789;"><tr><td>dans le cadre du projet</td><td>&nbsp;&nbsp;<a href="http://eole.orion.education.fr/"><image src="pt_logo_eole.png" title="Projet EOLE - Ensemble Ouvert Libre Evolutif"/></a></td></tr></table></center>

?>