#region ;**** Directives created by AutoIt3Wrapper_GUI ****
#AutoIt3Wrapper_Icon=./harddisc-icon.ico
#AutoIt3Wrapper_Res_Description=Affichage du quota disponible sous Scribe
#AutoIt3Wrapper_Res_Fileversion=4.1.3.0
#AutoIt3Wrapper_Res_LegalCopyright=2013 B.DEBEVE
#AutoIt3Wrapper_Res_Language=1036
#AutoIt3Wrapper_Res_Field=ProductName|Infosquota
#AutoIt3Wrapper_Res_Field=HomePage|www.debeve.net/infosquota
#AutoIt3Wrapper_Res_Field=ProductVersion|4.1
#AutoIt3Wrapper_Res_Field=Auteur|B.DEBEVE
#AutoIt3Wrapper_Res_Field=Description|Utilitaire pour afficher l'espace dispo et les quotas dans un environnement Scribe
#AutoIt3Wrapper_Run_Au3check=n
#AutoIt3Wrapper_Run_Tidy=y
#Tidy_Parameters=/kv 0
#endregion ;**** Directives created by AutoIt3Wrapper_GUI ****

#include "internes.au3"

;~ #####################################################################################
;~ #
;~ # Infosquota 4.1.3
;~ # Script de notification de l'espace utilis sous Scribe
;~ #
;~ # Bruno DEBEVE - fevrier 2013
;~ # Plus d'infos : http://www.debeve.net/infosquota
;~ #
;~ #####################################################################################

;~ #####################################################################################
;~ #
;~ # Licence CeCILL * voir Licence_CeCILL_V2-fr.txt
;~ # plus d'infos : http://www.cecill.info/
;~ #
;~ # Icone : http://www.iconarchive.com/show/hardware-icons-by-rokey/harddisc-icon.html
;~ # Auteur : Rokey * Gratuit pour une utilisation non commerciale
;~ #
;~ #####################################################################################

;~ #####################################################################################
;~ #
;~ # Fonctionnement et mise en place
;~ # ---------------
;~ # Un fichier " /home/netlogon/infosquota/quotas.txt " est cr/actualis par le serveur Scribe
;~ # Les donnes sont sous la forme : " login, espace utilis, limite souple, limite dure, (delai) "
;~ #
;~ # Placer le script compil infosquota.exe dans /home/netlogon/infosquota/
;~ # Crer (ou modifier) le fichier  /home/netlogon/scripts/groups/DomainUsers.txt   et rajouter les lignes suivantes:
;~ #    %%NetUse%%
;~ #    cmd,%%LOGONSERVER%%\netlogon\infquota\infquota.exe
;~ #
;~ # NON COMPATIBLE AVEC WINDOWS 9x / Me
;~ # voir : http://www.debeve.net/infosquota
;~ # voir la documentation de Scribe pour une mise en place uniquement sous Win2k, XP, Vista, Seven
;~ #
;~ #####################################################################################

;~ #####################################################################################
;~ # Historique et modifications
;~ # ---------------------------
;~ #
;~ # Fonctions hrites des versions prcdentes :
;~ # - valeurs par dfaut en interne
;~ # - distinction des cas possibles dans l'tat du quota
;~ # - affichage de l'espace utilis
;~ # - paramtrage du logiciel par un fichier de configuration
;~ # - affichage du dlai restant avant blocage
;~ # - tests d'intgrit du fichier de configuration
;~ # - tests d'intgrit du fichier quotas.txt
;~ #
;~ # v 4.0.0 :
;~ # ---------
;~ # - mise en forme pour la diffusion Eole : renommage et fichier de version
;~ # - utilisation d'une licence Cecill
;~ # - suppression de l'analyse des lignes dbutant par # (utilisateurs fantme)
;~ # - nom de variable : quota_pc --> seuil
;~ #
;~ # v 4.1 :
;~ # -------
;~ # - prise en charge de diffrentes langues
;~ # - suppression dans le INI de la ligne fichier
;~ # - si l'emplacement du fichier est crit, c'est dans la section [ini]
;~ #
;~ # v4.1.1. :
;~ # ---------
;~ # - travail sur le code : suppression du test sur #, suppos effectu par la tche
;~ # - travail sur le code : mise  part des valeurs internes par dfaut
;~ # - travail sur le code : mise  part des messages
;~ #
;~ # v4.1.2. :
;~ # ---------
;~ # - affichage : mauvaise indentation dues aux tab
;~ #
;~ # v4.1.3. :
;~ # ---------
;~ # - utilisation de chaines texte pour les messages, avec remplacement par les valeurs lues
;~ # - fonctions mises--jour, mais n'utilisent que des textes internes
;~ # - prvoir la possibilit d'utiliser un fichier lang.ini
;~ # - finalement, fin des textes multilangues inclus par dfaut
;~ #
;~ #
;~ #
;~ #####################################################################################



;~ #####################################################################################
;~ En cours

;~ tester le codage du fichier  l'ouverture ?
;~ --> NON, Autoit gre tout seul

;~ Maintenir ou non la prsence obligatoire des valeurs pour toutes les lignes ou que pour l'user
;~ --> vrification si la ligne est en 5 parties
;~ --> si oui, vrification si utilisateur en 1
;~ ----> vrification si espace en 2
;~ ----> vrification si quota en 3

;~ Accepter un nombre minimum de paramtres  3 (vieux code) ou en exiger 5
;~ Si 5 paramtres, analyser en consquence les valeurs lues pour valider l'intgrit du fichier
;~ Utiliser un tableau avec chaque message pour faciliter la conversion FR/EN/FR+EN pour LFKL
;~ Prsence d'un dossier log et test d'accs au dossier
;~ Rduire les oprations de construction des messages
;~ #####################################################################################


#region ATTENTE_OS

;~ @OSVersion : "WIN_2008R2", "WIN_7", "WIN_8", "WIN_2008", "WIN_VISTA", "WIN_2003", "WIN_XP", "WIN_XPe", "WIN_2000".

$int_delai_demarrage = 0
$delai = IniRead($fichier_ini, "OSDelay", @OSVersion, $int_delai_demarrage)
ConsoleWrite("@OSVersion = " & @OSVersion & " ; Dlai ini : " & $delai & @CRLF)
If ((StringIsDigit($delai) = 0) Or ($delai > 60)) Then
	$delai = $int_delai_demarrage
Else
	$delai = Number($delai)
EndIf
Sleep($delai * 1000)






;~ Switch @OSVersion
;~ @OSVersion Returns one of the following: "WIN_2008R2", "WIN_7", "WIN_8", "WIN_2008", "WIN_VISTA", "WIN_2003", "WIN_XP", "WIN_XPe", "WIN_2000".
;~ 	Case "WIN_XP"
;~ 		$delai = IniRead($fichier_ini, "OSDelay", "Win_XP", $int_delai_WinXP)
;~ 		If ((StringIsDigit($delai) = 0) Or ($delai > 30) ) Then
;~ 			$delai = $int_delai_WinXP
;~ 		Else
;~ 			$delai = Number($delai)
;~ 		EndIf
;~ 		Sleep ( $delai )
;~
;~ 	Case "WIN_VISTA"
;~ 		Sleep(20000)
;~ 	Case "WIN_7"
;~ 		Sleep(20000)
;~ 	Case Else
;~ EndSwitch



#endregion ATTENTE_OS



#region PARAMETRES_BASIQUES

;~ prsence du fichier de configuration

If FileExists($fichier_ini) Then ;~ fichier de configuration prsent -> analyser la configuration

;~ Lectures et vrifications de l'intgrit des paramtres fourni dans le INI
;~ Si les valeurs lues correspondent aux critres attendues, conversion en nombre
;~ Sinon, chargement des valeurs par dfaut







	$seuil = IniRead($fichier_ini, "ini", "seuil", $int_seuil) ;~ Seuil d'alerte
	If ((StringIsDigit($seuil) = 0) Or ($seuil > 99) Or ($seuil = 0)) Then
		$seuil = $int_seuil
	Else
		$seuil = Number($seuil)
	EndIf

	$temps_affichage = IniRead($fichier_ini, "ini", "temps_affichage", $int_temps_affichage) ;~ Temps d'affichage des messages
	If ((StringIsDigit($temps_affichage) = 0) Or ($temps_affichage > 60) Or ($temps_affichage = 0)) Then
		$temps_affichage = $int_temps_affichage
	Else
		$temps_affichage = Number($temps_affichage)
	EndIf

	$aff_stockage = IniRead($fichier_ini, "ini", "aff_stockage", $int_aff_stockage) ;~ Affichage de l'espace utilis
	If ($aff_stockage <> "0" And $aff_stockage <> "1") Then
		$aff_stockage = $int_aff_stockage
	Else
		$aff_stockage = Number($aff_stockage)
	EndIf

	$aff_quota_0 = IniRead($fichier_ini, "ini", "aff_quota_0", $int_aff_quota_0) ;~ Affichage de l'espace utilis pour les utilisateurs sans quota
	If ($aff_quota_0 <> "0" And $aff_quota_0 <> "1") Then
		$aff_quota_0 = $int_aff_quota_0
	Else
		$aff_quota_0 = Number($aff_quota_0)
	EndIf

	$aff_delai = IniRead($fichier_ini, "ini", "aff_delai", $int_aff_delai) ;~ Affichage du temps restant avant blocage
	If ($aff_delai <> "0" And $aff_delai <> "1") Then
		$aff_delai = $int_aff_delai
	Else
		$aff_delai = Number($aff_delai)
	EndIf

	$aff_alertes = IniRead($fichier_ini, "ini", "aff_alertes", $int_aff_alertes) ;~ Affichage des alertes de fonctionnement
	If ($aff_alertes <> "0" And $aff_alertes <> "1") Then
		$aff_alertes = $int_aff_alertes
	Else
		$aff_alertes = Number($aff_alertes)
	EndIf

;~ Emplacement du fichier quotas  analyser
;~ *** Paramtre sorti du fichier de configuration, maintenu pour dbug ***
;~ *** Dans le fichier ini, le chemin doit tre le chemin absolu ***
;~ *** ex : \\scribe\netlogon\infosquota\mes_quotas.txt
	$emplacement_quota = IniRead($fichier_ini, "ini", "fichier", $int_emplacement_quota)
	If FileExists($emplacement_quota) = 0 Then $emplacement_quota = $int_emplacement_quota ; si le fichier spcifi est absent, utiliser le fichier par dfaut

Else ; fichier de configuration absent -> charger la config par dfaut

;~ 	Chargement des paramtres par dfaut

	$seuil = $int_seuil
	$temps_affichage = $int_temps_affichage
	$aff_stockage = $int_aff_stockage
	$aff_quota_0 = $int_aff_quota_0
	$aff_delai = $int_aff_delai
	$aff_alertes = $int_aff_alertes
	$emplacement_quota = $int_emplacement_quota

EndIf

#endregion PARAMETRES_BASIQUES

#region PROGRAMME

$user_traite = False ;~ dfinition d'une variable, pour savoir si l'utilisateur a t trait

$file = FileOpen($emplacement_quota, 0) ;~ Acces au fichier des quotas

If $file = -1 Then ;~ Impossible d'accder au fichier quotas
	_alerte_pas_quota($temps_affichage, $aff_alertes)
	Exit
EndIf

While 1 ;~ traitement du fichier ligne par ligne (boucle jusqu' la fin du fichier)

	$line = FileReadLine($file) ;~ lecture d'une ligne du fichier
	If (@error = -1 Or @error = 1) Then ExitLoop ;~ fin du fichier atteinte (sans avoir trouv l'utilisateur) ou erreur de lecture

	$param = StringSplit($line, ",") ;~ la ligne est lue, sparation de la ligne en tableau

;~ 	Rglage d'aprs la tache dans le crontab :
;~ 	0: nombre de chaines en retour
;~  1: nom d'un user
;~  2: occupation disque actuelle
;~  3: limite souple
;~  4: limite dure
;~  5: dlai disponible (en cas de dpassement) / nombre d'inodes utiliss

	If $param[0] <> 5 Then ContinueLoop ;~ On teste si la ligne a bien 5 paramtres, sinon on passe  la suivante (erreur dans le fichier quotas)
	If $param[1] <> @UserName Then ContinueLoop ;~ On teste si on est bien sur l'utilisateur connect, sinon on passe  la ligne suivante

;~ #####################################################################################
;~ a ce stade, on a une ligne avec 5 paramtres et c'est celle de l'utilisateur connect
;~ #####################################################################################

	FileClose($file) ;~ Fermeture du fichier
	$user_traite = True ;~ on considre que l'utilisateur est trait

	If (($param[2] = "") Or (StringIsDigit($param[2]) = 0)) Then ;~ on n'a pas l'espace utilis (ou ce n'est pas un nombre)
		_alerte_pas_quota($temps_affichage, $aff_alertes)
		Exit
	EndIf

	If (($param[3] = "") Or (StringIsDigit($param[3]) = 0)) Then ;~ on n'a pas la limite souple (ou ce n'est pas un nombre)
		_alerte_pas_quota($temps_affichage, $aff_alertes)
		Exit
	EndIf

	$param[2] = Number($param[2])
	$param[3] = Number($param[3])

	If ($param[3] <> 0) Then ;~ test si on n'a pas de quota illimit

		If $param[2] >= $param[3] Then ;~ test de dpassement de quota

			_Message_quota_depasse($param, $aff_delai)

			Exit ;~ fin du programme

		Else
;~ 			quota non dpass ; on vrifie si l'espace ne dpasse pas un certain % du quota, en prvention
;~ 			calcul du quota utilis en % (arrondi au % suprieur)
			$pourcent = Ceiling($param[2] * 100 / $param[3])

;~ 			test sur le pourcentage calcul
			If $pourcent >= $seuil Then

;~ 				% dpass, il faut prvenir
				_Message_quota_seuil($param)
				Exit ;~ fin du programme

			Else
				; % non dpass, affichage de l'espace utilis (selon paramtrage)
				If $aff_stockage = 1 Then

					_Message_quota_OK($param, $temps_affichage)
					Exit ;~ fin du programme

				EndIf

			EndIf
		EndIf
	Else ; utilisateur sans quota (quota=0), afficher l'espace utilis (selon paramtrage)

		If $aff_quota_0 = 1 Then
			_Message_quota_0($param, $temps_affichage)
			Exit ;~ fin du programme

		EndIf

	EndIf
	ExitLoop

WEnd

;~ #####################################################################################
;~ Le fichier entier a t parcouru, mais l'utilisateur n'a pas t trouv
;~ #####################################################################################

If Not $user_traite Then ; si rien n'a t affich (user non trouv), afficher un message (selon paramtrage)
	FileClose($file)
	_alerte_pas_quota($temps_affichage, $aff_alertes)
	Exit ;~ fin du programme
EndIf


#endregion PROGRAMME

;~ ######################################################################
