#!/bin/bash

set -e -u

die() { echo -e "$@" >&2; exit 1; }

test -x "$(type -p gpg)" || die "No GPG program in PATH."
test -x "$(type -p sha512sum)" || die "No SHA512sum program in PATH."

function clean() {
    set +e
    test -w "${TEMP_SUMS}" && rm -f "${TEMP_SUMS}"
}

trap clean EXIT

KEYRINGS='keyrings/*.gpg'
SUMS='sha512sums.txt'
TEMP_SUMS=$(mktemp --tmpdir "${SUMS}-XXXXXX.tmp")

echo "${TEMP_SUMS}"

sha512sum ${KEYRINGS} > "${TEMP_SUMS}" || die "Can not create checksums file."
gpg --clearsign -o "${SUMS}" "${TEMP_SUMS}" || die "Can not sign checksums file."
