# -*- coding: utf-8 -*-

def toCidr(ip,mask=False):
    """ Convert to CIDR notation
        ip can be like this : 192.168.5.100/255.255.255.0
        or you can provide the ip and the mask
    """
    from IPy import IP
    try:
        if mask:
            data="{0}/{1}".format(ip,mask)
        else:
            data=ip
        return str(IP(data))
    except:
        return data

def readPass(encoder,reader):
    try:
        mypwdreader=open(reader, "r").readline().rstrip()
        if encoder == "":
            return mypwdreader
        elif encoder == "base64":
            import base64
            return base64.b64encode(mypwdreader)

    except:
        return "mot de passe inconnu"

def getSSOFilters():
    """ Convert former eole-sso filters to LemonLDAP filters
    """
    import glob
    from configparser import ConfigParser

    try:
       filters = { 'uid': "uid", "mail": "mail" }
       filterDirectory = "/usr/share/sso/app_filters/"
       filterExtention = ".ini"
       filterSection = "utilisateur"
       filterFiles = glob.glob("{0}/*{1}".format(filterDirectory, filterExtention))
       toClean = [ "__name__" ]
       if len(filterFiles) != 0:
           for fi in filterFiles:
               # Don't parse "applications.ini"
               config = ConfigParser()
               config.read(fi)
               if filterSection in config._sections:
                   filters.update(config._sections[filterSection].items())
           for key in toClean:
               if key in filters.keys():
                   del(filters[key])
       res = {}
       index=0
       size=len(filters)
       return(filters.items())
       """
       for k,v in filters.items():
           res[k] "        \"{0}\": \"{1}\"".format(k,v)
           index += 1
           if index != size:
               res += ",\n"
       return(res)
       """
    except:
        return "Error Generating Filters"

