# eole-lemonldap

LemonLDAP::NG EOLE integration

## Howto

### Configure LemonLDAP in GenConfig

* Enable lemonldap in "Services" tab

Gen_Config -> Services ->  Activer LemonLDAP::NG -> "Oui"

* Fill LemonLDAP configuration

#### On Scribe

* LemonLDAP::NG is configured to use the local LDAP service
* We register the supplementary host names to the AD DNS
* We add the supplementary host names to the `ssl_subjectalt_names`

#### Manual configuration

##### Nginx Web case

By default NGINX is configured to serve "web" application, in this case the lemonLDAP::NG application will
not be served properly, so we need to disable this function

GenConfig -> Services -> Activer la publication d’applications web par Nginx -> "Non'

##### Configuration DNS

* GenConfig -> Lemonldap -> Nom DNS du manager LemonLDAP-NG
* GenConfig -> Lemonldap -> Nom DNS du service d'authentification LemonLDAP-NG

##### Configuration LDAP

* GenConfig -> Lemonldap -> Protocole LDAP à utiliser
* GenConfig -> Lemonldap -> Adresse du Serveur LDAP utilisé par LemonLDAP::NG
* GenConfig -> Lemonldap -> Port d'écoute du LDAP utilisé par LemonLDAP::NG
* GenConfig -> Lemonldap -> Base DN des utilisateurs dans l'annuaire
* GenConfig -> Lemonldap -> Utilisateur de connection à l'annuaire (DN ex: cn=reader,o=gouv,c=fr)
* GenConfig -> Lemonldap -> Mot de passe de l'utilisateur de connection à l'annuaire (file like /root/.reader or the clear password)

##### Configuration CAS

Add your CAS attributes mapping ( uid = uid and mail = mail are created by default)

* GenConfig -> Lemonldap -> Nom de l'attribut CAS
* GenConfig -> Lemonldap -> Attribut LDAP équivalent

##### SSL issues

If you use "autosign" certificates you need to add the "manager" and "auth" service names to the alternative names.
You also need to include "reload" service name (available in GenConfig -> Mode Expert -> Lemonldap -> Nom DNS du service Reload de LemonLDAP-NG)

* GenConfig -> Mode Expert -> Certificats ssl -> Nom Alternatif de la machine (SubjectAltName)

If you use "manual" certificates make sure this names are covered by your SSL Certificate

If you use "letsencrypt" mode you also need to add this names to the let'sencrypt request:

* GenConfig -> Mode Expert -> Certificat ssl -> Nom de domaines supplémentaires
