#!/usr/bin/env python
"""Module mysql"""
from pyeole.process import system_code
from eolesql.db_cmd import dump_sql_file
import sys
from glob import glob
sys.path.append('/usr/share/eole/sbin')
from mysql_pwd import mysql_root_passwd, gen_random_passwds
from pyeole.bacularestore import bacula_restore_one_file, exit_if_running_jobs

mysqlsavdir = "/home/backup/sql/"

def execute(option, opt_str, value, parser, jobid, test_jobs=True):
    """ldap helper"""
    if len(parser.rargs) > 0:
        option = parser.rargs[0]
        if option == 'pre':
            pre()
        elif option == 'post':
            post()
    else:
        if test_jobs:
            exit_if_running_jobs()
        job(jobid)

def pre():
    print "pre mysql"

def post():
    print "post mysql"
    password = gen_random_passwds()[0]
    for files in glob("{0}/*.sql".format(mysqlsavdir)):
        print "restauration de {0}".format(files)
        mysql_root_passwd(password)
        dump_sql_file(password, files)

def job(jobid):
    print "restauration mysql"
    bacula_restore_one_file(mysqlsavdir, jobid)


priority=30
