#!/bin/bash
##########################################
# Sauvegarde EOLE
# - Hâpy -
##########################################

. /usr/lib/eole/ihm.sh
. /etc/eole/one_backup_env.conf

Lock="sauvegarde"
Excl="maj"

day=`date +%d-%m-%Y`
backup_dir=/var/lib/hapy_backups
tmp_backup=$backup_dir/$day

if [ ! -d $backup_dir ]
then
	mkdir $backup_dir
fi
rm -rf $tmp_backup
mkdir $tmp_backup

echo -e
EchoCyan "Sauvegarde en cours, patientez ..."

EchoGras "Sauvegarde système"
echo -e " - clés de connexion"
# /root/.ssh
cd /root
tar -cpf $tmp_backup/root_ssh.tar .ssh >/dev/null

echo -e " - configuration eole"
# configuration EOLE et certificats générés
tar -cpf $tmp_backup/conf_eole.tar /etc/eole/config.eol \
/usr/share/eole/creole/dicos/local /usr/share/eole/creole/patch \
/etc/ssl >/dev/null 2>/dev/null

# sauvegarde des bases de données ONE
EchoGras "Sauvegarde ONE"
echo -e " - base ONE"
onedb backup --$DB_BACKEND /var/lib/one/one.db "$tmp_backup/one.db" >/dev/null 2>/dev/null
echo -e "#$DB_BACKEND\n$(cat $tmp_backup/one.db)" > "$tmp_backup/one.db"

echo -e " - secrets"

tar -cpf "$tmp_backup/var_lib_one_one.tar" /var/lib/one/.one >/dev/null 2>/dev/null

# création du fichier de sauvegarde compressé
EchoCyan "Compression de l’archive…"
cd $backup_dir
rm -f $day.tar.gz
tar -czf $day.tar.gz $day

# test des éléments de l’archive compressée
tar tf $day.tar.gz $day/{one.db,var_lib_one_one.tar,conf_eole.tar,root_ssh.tar} 2>/dev/null >/dev/null
if [ $? -ne 0 ]
then
    EchoRouge "Archive incomplète"
fi
echo -e

EchoVert "Archive créée : $backup_dir/$day.tar.gz"
echo -e

# suppression du répertoire temporaire
rm -rf $tmp_backup
# retour au répertoire d'origine
popd >/dev/null 2>&1
