#!/bin/bash

. /usr/lib/eole/ihm.sh

function synchro_files() {
# Synchronisation des fichiers
# Params :
# 1: "maitre"/"esclave"
# 2: nom_machine_locale
# 3: ip_noeud_local
# 4: nom_machine_distante
# 5: ip_noeud_distant

    tcpcheck 3 $5:22 | grep -q alive
    if [ $? -ne 0 ]
    then
        distant="maitre"
        [ "$1" = maitre ] && distant="esclave"
        EchoOrange "    ERREUR : Noeud $distant injoignable !"
        EchoOrange "             Relancer synchro-nodes.sh quand les 2 serveurs seront instanciés !!!"
        [ -e /etc/ha.d/.hdinitialized ] && rm -f /etc/ha.d/.hdinitialized
        echo
        exit 0
    fi
    if [ ! -e /etc/ha.d/.hdinitialized ]
    then
        echo "Envoi de la clé RSA sur $4 --> $5"
        ssh-copy-id -i /root/.ssh/id_rsa.pub root@$5
        touch /etc/ha.d/.hdinitialized
    fi

    # On envoie la liste des resources service sur l'esclave
    [ "$1" = "maitre" ] &&
        /usr/bin/rsync -e ssh --owner --group --recursive --links --perms --times --delete /etc/ha.d/.rsc_list $5:/etc/ha.d/
    # On ne synchronise que si le node est actif
    ip route | grep default | grep -q src
    if [ $? -eq 0 ]
    then
        for fichier in $(CreoleGet synchro_fichiers)
        do
            if [ -d $fichier ]
            then
                # Synchro d'un répertoire
                echo "Synchronisation du répertoire $fichier"
                repertoire=`dirname $fichier`/`basename $fichier`/
                /usr/bin/rsync -e ssh --owner --group --recursive --links --perms --times --delete $repertoire $5:$repertoire
            elif [ -f $fichier ]
            then
                # Synchro d'un fichier
                echo "Synchronisation du fichier $fichier"
                repertoire=`dirname $fichier`/
                /usr/bin/rsync -e ssh --owner --group --recursive --links --perms --times --delete $fichier $5:$repertoire
            else
                echo "$fichier inexistant sur le node $1 !!!!"
            fi
        done
    fi
}

echo "Synchronisation des nodes ...."
echo

activer_haute_dispo="$(CreoleGet activer_haute_dispo)"
nom_machine_locale="$(CreoleGet nom_machine)"

if [ "$activer_haute_dispo" = "maitre" ]
then
    nom_machine_distante="$(CreoleGet nom_machine_esclave)"
    ip_machine_distante="$(CreoleGet ip_machine_esclave)"
fi

if [ "$activer_haute_dispo" = "esclave" ]
then
    nom_machine_distante="$(CreoleGet nom_machine_maitre)"
    ip_machine_distante="$(CreoleGet ip_machine_maitre)"
fi

if [ "$activer_haute_dispo" != "non" ]
then
    ip_machine_locale="$(CreoleGet "adresse_ip_$(CreoleGet corosync_dial_if)")"
    synchro_files $activer_haute_dispo $nom_machine_locale $ip_machine_locale $nom_machine_distante $ip_machine_distante
fi
