# -*- coding: utf-8 -*-

import autopath

from pyeole.password import Password
from pyeole.password import EolePassword
from pyeole.password import EoleShadow
from pyeole.password import User


######################################################################
# General
######################################################################

def test_gen_salt():
    user = "fake"
    obj = EolePassword(user)
    saltA = obj.gen_salt()

def test_gen_rand_password():
    user = "fake"
    obj = EolePassword(user)
    password = obj.gen_rand_pass()


######################################################################
# Shadow
######################################################################

def test_shadow_crypt():
    user = 'fake'
    password = 'monpass'
    obj = EoleShadow(user)
    secret = obj.shadowcrypt(password)
    if secret == password:
        raises("Crypt Error")

def test_get_user_info():
    user = 'bin'
    obj = EoleShadow(user)
    obj.get_user_info()
    print obj.user

def test_gen_new_password():
    user = 'bin'
    obj = EoleShadow(user)
    obj.gen_new_password('auto')


######################################################################
# User
######################################################################

def test_password_factory():
    user = {}
    user.__setitem__('user', 'bin')
    user.__setitem__('host', None)
    user.__setitem__('type', 'system')
    user.__setitem__('mode', 'auto')
    user.__setitem__('to_change', None)

    obj = User(user)
    obj.password_factory()

def test_add_task():
    result = [{'file': '/tmp/monfichier1', 'pattern': 'password='},
              {'file': '/tmp/monfichier2', 'pattern': 'password='},
              {'file': '/tmp/monfichier3', 'pattern': 'password='},
              {'file': '/tmp/monfichier4', 'pattern': 'password='}]
    task1 = {}
    task1.__setitem__('user', 'bin')
    task1.__setitem__('host', None)
    task1.__setitem__('type', 'system')
    task1.__setitem__('mode', 'auto')
    task1.__setitem__('to_change', [{'file': '/tmp/monfichier1', 
                                     'pattern': 'password='},
                                    {'file': '/tmp/monfichier2', 
                                     'pattern': 'password='}])

    task2 = {}
    task2.__setitem__('user', 'bin')
    task2.__setitem__('host', None)
    task2.__setitem__('type', 'system')
    task2.__setitem__('mode', 'auto')
    task2.__setitem__('to_change', [{'file': '/tmp/monfichier3', 
                                     'pattern': 'password='},
                                    {'file': '/tmp/monfichier4', 
                                     'pattern': 'password='}])

    obj = User(task1)
    obj.add_task(task2)
    assert obj.to_change == result
