<?php
/**
 * @package info.ajaxplorer
 *
 * Copyright 2007-2009 David PERRIN
 * This program is published under the LGPL Gnu Lesser General Public License.
 * You should have received a copy of the license along with AjaXplorer.
 *
 * The main conditions are as follow :
 * You must conspicuously and appropriately publish on each copy distributed
 * an appropriate copyright notice and disclaimer of warranty and keep intact
 * all the notices that refer to this License and to the absence of any warranty;
 * and give any other recipients of the Program a copy of the GNU Lesser General
 * Public License along with the Program.
 *
 * If you modify your copy or copies of the library or any portion of it, you may
 * distribute the resulting library provided you do so under the GNU Lesser
 * General Public License. However, programs that link to the library may be
 * licensed under terms of your choice, so long as the library itself can be changed.
 * Any translation of the GNU Lesser General Public License must be accompanied by the
 * GNU Lesser General Public License.
 *
 * If you copy or distribute the program, you must accompany it with the complete
 * corresponding machine-readable source code or with a written offer, valid for at
 * least three years, to furnish the complete corresponding machine-readable source code.
 *
 * Any of the above conditions can be waived if you get permission from the copyright holder.
 * AjaXplorer is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 * without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * Description : Abstract representation of an access to an authentication system (ajxp, ldap, etc).
 */

/* get globals we me need */
require_once('CAS/eoleCAS.php');
require_once('configCAS/cas.inc.php');
require_once(INSTALL_PATH.'/plugins/auth.cas/config.php');

require_once(INSTALL_PATH."/server/classes/class.AbstractAuthDriver.php");

class casAuthDriver extends AbstractAuthDriver {

	var $usersSerFile;
	var $logger;
	var $connect_url;

	function init($options){
		parent::init($options);
		$this->usersSerFile = $options["USERS_FILEPATH"];
	}
	function preLogUser($sessionid){
		$auth = $this->auth($_GET);
		if ($auth){
			$data_array = $this->pgt($_GET);
		}else{
			exit();
		}
		$user = $data_array[0];
		$pgt = $data_array[1];
		if ($pgt == null){
			AJXP_Logger::logAction('Cas Server connexion could NOT be established');
		}else{
			$this->login($user,$pgt);
		}
	}
	function set_connect_url ($url){
		$this->connect_url = $url;
	}
	function get_connect_url(){
		return $this->connect_url;
	}
	function auth ($GET) {
	/*
		Renvoie l'authentification vers le serveur CAS
	 */
		$auth=false;
		if (__CAS_DEBUG){
			EolephpCAS::setDebug(__LOG_FILE);
		}
		session_start();
		EolephpCAS::proxy(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_URL, false);
		if (method_exists("phpCAS", 'setNoCasServerValidation')){
			EolephpCAS::setNoCasServerValidation();
		}
		if (method_exists("phpCAS", 'setFixedServiceURL')){
			casAuthDriver::set_connect_url($_SERVER['SCRIPT_URI']);
			EolephpCAS::setFixedServiceURL(casAuthDriver::get_connect_url());
		}
		// Authentification web
		$auth = EolephpCAS::isAuthenticated();

		if ( ! $auth )  {
			if ( ! __GATEWAY)  {
				EolephpCAS::forceAuthentication();
			}else{
				if (! isset($GET['ticket'])){
					EolephpCAS::checkAuthentication();
				}
			}
		}
		if ($auth){
			return true;
		}else{
			return false;
		}
	}
	function pgt ($GET) {
		// Place le PGT (global ticket) dans la session
		if (method_exists("phpCAS", 'setFixedServiceURL')){
			EolephpCAS::setFixedServiceURL(__FTP_SERVICE);
		}
		$CAS = $GLOBALS['PHPCAS_CLIENT'];
		// Procédure pour obtenir un PGT depuis un ticket
		// ou pour enregistrer le PGT si on le reçoit
		if( ! empty($GET['ticket']) ||	! empty($GET['pgtIou'])) {
			if( ! empty($_SESSION['PGT'])) {
				session_unset();
				$GET['ticket']='';
			}
			if(EolephpCAS::hasPGT()) {
                $PT = EolephpCAS::retrievePT(__FTP_SERVICE, $err_code, $err_msg);
                $_SESSION['PT']=$PT;
			//	$PGT=$CAS->getPGT();
			//	$_SESSION['PGT']=$PGT;
			}
		}else{
            $PT=EolephpCAS::retrievePT(__FTP_SERVICE, $err_code, $err_msg);
            $_SESSION['PT']=$PT;
			//$PGT=$CAS->getPGT();
			//$_SESSION['PGT']=$PGT;
		}
		return Array(EolephpCAS::getUser(), $PT);
	}
	function login($user,$pass){
		if (! $this->userExists($user)){
			$this->createUser($user,$pass);
		}
		AuthService::logUser($user, "", true, true);
		$userObj = AuthService::getLoggedUser();
		AuthService::updateAdminRights($userObj);
		$_SESSION['username'] = $user;
	}
	function get_logout_url () {
		EolephpCAS::proxy(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_URL, false);
		if (method_exists("phpCAS", "setNoCasServerValidation")){
			EolephpCAS::setNoCasServerValidation();
		}
		$cas_url = EolephpCAS::getServerLogoutURL();
		$paramSeparator = '?';
		$url = str_replace('content.php', '', $_SERVER['SCRIPT_URI']);
		$cas_url = $cas_url . $paramSeparator . "url=" . urlencode($url);
		#FIXME :
		#$paramSeparator = '&';
		#$cas_url = $cas_url . $paramSeparator . "service=" . urlencode(__FTP_SERVICE);
		#$this->debug('Cas logout(2) : ' . $cas_url);
		return $cas_url;
	}
	function listUsers(){
		return Utils::loadSerialFile($this->usersSerFile);
	}
	function userExists($login){
		$users = $this->listUsers();
		if(!is_array($users) || !array_key_exists($login, $users)) return false;
		return true;
	}
	function checkPassword($login, $pass, $seed){
		$userStoredPass = $this->getUserPass($login);
		if(!$userStoredPass) return false;
		if($seed == "-1"){ // Seed = -1 means that password is not encoded.
			return ($userStoredPass == $pass);
		}else{
			return (md5($userStoredPass.$seed) == $pass);
		}
	}
	function createCookieString($login){
		$userPass = $this->getUserPass($login);
		return md5($login.":".$userPass.":ajxp");
	}
	function usersEditable(){
		return true;
	}
	function passwordsEditable(){
		return false;
	}
	function getLoginRedirect(){
		if ($this->slaveMode) {
			if (!empty($_SESSION["AJXP_USER"])) return false;
			return $this->urls[0];
		}
		return false;
	}
	function getLogoutRedirect(){
		session_unset();
		session_destroy();
		return "<![CDATA[" . $this->get_logout_url() . "]]>";
	}
	function createUser($login, $passwd){
		$users = $this->listUsers();
		if(!is_array($users)) $users = array();
		if(array_key_exists($login, $users)) return "exists";
		if($this->getOption("TRANSMIT_CLEAR_PASS") === true){
			$users[$login] = $passwd;
		}else{
			$users[$login] = md5($passwd);
		}
		Utils::saveSerialFile($this->usersSerFile, $users);
	}
	function changePassword($login, $newPass){
		$users = $this->listUsers();
		if(!is_array($users) || !array_key_exists($login, $users)) return ;
		if($this->getOption("TRANSMIT_CLEAR_PASS") === true){
			$users[$login] = $newPass;
		}else{
			$users[$login] = md5($newPass);
		}
		Utils::saveSerialFile($this->usersSerFile, $users);
	}
	function deleteUser($login){
		$users = $this->listUsers();
		if(is_array($users) && array_key_exists($login, $users))
		{
			unset($users[$login]);
			Utils::saveSerialFile($this->usersSerFile, $users);
		}
	}
	function replaceAjxpXmlKeywords($xml){
		$xml = str_replace("AJXP_REMOTE_AUTH", "true", $xml);
		$xml = str_replace("AJXP_NOT_REMOTE_AUTH", "false", $xml);
		$xml = parent::replaceAjxpXmlKeywords($xml);
		return $xml;
	}
}
?>
