<?php
# *********************** LICENSE ******************************************************#
#	This file is part of CAS plugin.						#
#											#
#	CAS plugin is free software; you can redistribute it and/or modify		#
#	it under the terms of the GNU General Public License as published by		#
#	the Free Software Foundation; either version 2 of the License, or		#
#	(at your option) any later version.						#
#											#
#	CAS plugin is distributed in the hope that it will be useful,			#
#	but WITHOUT ANY WARRANTY; without even the implied warranty of			#
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			#
#	GNU General Public License for more details.					#
#											#
#	You should have received a copy of the GNU General Public License		#
#	along with Foobar; if not, write to the Free Software				#
#	Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA	#
# **************************************************************************************#


/************************************************
 *	CAS TOOLS				*
 *	file: plugcas_tools.php			*
 *	version: 2.10				*
 *	date: 03/06/2008			*
 *	author: Jean-francois Rey		*
 *	email: jean-francois.rey@univ-avignon.fr*
 ************************************************/


/* FUNCTION RANDOM_NUMBER : return a string of number sequence, size teter between 8 and 12
 */
function random_number()
{
    $size = 8 + rand(0,4);
    $num = "";
    for($i=0 ; $i<$size ;$i++) $num .= rand(0,9);
    return $num;
}
function cas_return(){
    /*
     * construit l'url sur laquelle on renvoie
     * (gère le protocole)
     */
    $a = preg_split('/:/',$_SERVER['SCRIPT_URI'],2);
    $protocol = $a[0];
    $return_url = $protocol."://".__CAS_RETURN;
    return $return_url;
}
function setLang(){
    /*
     * Définit la langue du client phpCAS
     */
    if(__LANG=="fr"){
        EolephpCAS::setLang(PHPCAS_LANG_FRENCH);
    }else{
        EolephpCAS::setLang(PHPCAS_LANG_ENGLISH);
    }
}
function setNoCasServerValidation(){
    /*
     * Enlève la validation du certificat
     * permet le fonctionnement avec les certificat auto-signé ...
     */
    /// TEST AVEC CA DU SERVEUR LOCAL
    EolephpCAS::setCasServerCACert('/etc/ssl/certs/ca.crt');
    // if (method_exists("EolephpCAS", "setNoCasServerValidation")){
    //    EolephpCAS::setNoCasServerValidation();
    // }
}
function eoleLogout(){
    /*
     * Teste la requête (si il s'agit d'une requête de logout du serveur sso)
     */
    if (method_exists("EolephpCAS", "EoleLogoutRequests")){
        EolephpCAS::EoleLogoutRequests(false); // Ne teste pas le serveur appelant le logout
    }
}
function initCasProxy(){
    /*
     * Initialise le client cas en mode proxy
     * pour permettre la récupération de ticket proxy
     */
    EolephpCAS::proxy(__CAS_VERSION,__CAS_SERVER,__CAS_PORT,__CAS_FOLDER,false);
    setLang();
    setNoCasServerValidation();
    if (__CAS_LOGOUT){
        eoleLogout();
    }
}
function setLogoutHook(){
    /*
     * Définit le hook javascript pour les logouts d'application
     */
    if (is_file('/var/www/html/posh/includes/plugins/plugin_eolecas/logout.inc.php')){
        include('logout.inc.php');
    };
    echo "<script>";
    echo "var logout_urls=new Array();";
    foreach($LOGOUT_URLS as $logout_url){
        echo "logout_urls.push('". $logout_url . "');";
    }
    echo "</script>";
    echo "<script type='text/javascript' src='../includes/plugins/plugin_eolecas/scripts/logout.js'></script>";
}
function setAvatarLibHook(){
    /*
     * Insère le javascript utilisé pour le peuplement de l'avatar Eole
     */
    echo "<script type='text/javascript' src='../includes/plugins/plugin_eolecas/scripts/avatar.js'></script>";
}
function setChangeUserHook(){
    /*
     * Écrase la fonction de changement de user
     * pour la rendre compatible eolecas
     */
    echo "<script type='text/javascript'>";
    $link = cas_return() ."/scr_authentif.php?act=logout&from=change";
    echo "$" . "p.network.changeProfile = new Function(\"" . "$" . "p.navigator.openLink('" . $link . "');\");";
    echo "</script>";
}
function setLoginRedirectHook(){
    /*
     * Redirige vers la page de login
     */
    echo "<script type='text/javascript'>";
    echo "$"."p.navigator.openLink('".login_link() . "');";
    echo "</script>";
}
function login_link(){
    /*
     * Renvoie l'url de renvoie vers le formulaire de connexion CAS
     */
    define('__LOGIN_PAGE', __CAS_PROTO . "://" . __CAS_SERVER . ":" . __CAS_PORT . __CAS_FOLDER . "/login");
    return __LOGIN_PAGE . "?service=" . cas_return() ."/login.php";
}
?>
