<?php

/**
 **  cas_auth/setup.php
 **
 **  Copyright (c) 2008 Eole (eole@ac-dijon.fr)
 **  Licensed under the GNU GPL. For full terms see the file COPYING.
 **
 **  Authentication through EolephpCAS
 **
 **/


function squirrelmail_plugin_init_cas_auth() {
    global $squirrelmail_plugin_hooks;
    $squirrelmail_plugin_hooks['login_cookie']['cas_auth'] = 'cas_auth_get_pt';
    $squirrelmail_plugin_hooks['logout']['cas_auth'] = 'cas_auth_logout';
}

define('__CAS_URL', "");

function cas_auth_get_pt () {

    /* get globals we need */
    sqGetGlobalVar('login_username', $login_username);
    sqGetGlobalVar('secretkey', $secretkey);

    include(SM_PATH . 'plugins/cas_auth/config.php');
    include_once('CAS/eoleCAS.php');
    include_once('configCAS/cas.inc.php');
    EolephpCAS::proxy(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_URL, false);
    if (method_exists(EolephpCAS, 'setNoCasServerValidation')){
        EolephpCAS::setNoCasServerValidation();
    }
    EolephpCAS::setNoClearTicketsFromUrl();
    EolephpCAS::forceAuthentication();
     if (method_exists(EolephpCAS, 'setFixedServiceURL')){
        EolephpCAS::setFixedServiceURL($imap_service);
    }
    $pt = EolephpCAS::retrievePT($imap_service, $err_code, $output);
    $_SESSION['login_username'] = EolephpCAS::getUser();
    $_SESSION['secretkey'] = $pt;
    header('Location: redirect.php');
}

function cas_auth_logout () {
    include_once('configCAS/cas.inc.php');
    include_once('CAS/eoleCAS.php');
    $base_uri = sqm_baseuri();
    session_unset();
    EolephpCAS::proxy(__CAS_VERSION, __CAS_SERVER, __CAS_PORT, __CAS_URL, false);
    if (method_exists(EolephpCAS, "setNoCasServerValidation")){
        EolephpCAS::setNoCasServerValidation();
    }
    EolephpCAS::logout(array("url"=>'http://'.$_SERVER['HTTP_HOST'].$base_uri.'index.php'));
}
