<?php
include_once(dirname(__FILE__).'/CAS/Client.php');
include_once(dirname(__FILE__).'/eoleCASConfig.php');

require_once __DIR__ . '/CAS/Autoload.php';

// Configuration pour la base de données
define('TICKET_BDD_PATH', '/var/lib/phpcas/');
define('TICKET_BDD', TICKET_BDD_PATH.'ticket-cache');
define('TICKET_TABLE', 'ticket');
#FIXME : création des répertoires de bdd en postinst + droits

class EoleCASClient extends CAS_Client
{
    /*
     * FONCTIONS EOLE
     */

    /*
     * Constructeur de la classe
     */
    public function EoleCASClient($server_version,
        $proxy,
        $server_hostname,
        $server_port,
        $server_uri,
        $changeSessionID = true,
        \SessionHandlerInterface $sessionHandler = null)    
        {
            if (!$this->_isLogoutRequest() && !empty($_GET['ticket'])){
                $session_id = session_id();
                $ticket = $_GET['ticket'];
                phpCAS::LOG("La session numéro : " . $session_id . " est associée au ticket : " . $ticket);
                $this->store_session_id($ticket, $session_id);
            }

            $this->start_session=$changeSessionID;
            parent::__construct($server_version, $proxy, $server_hostname, $server_port, $server_uri, $changeSessionID, $sessionHandler);
        }
    /*
     * Pour compatibilité : fonction de récupération des attributs utilisateur
     * getDetails
     */
    public function getDetails(){
        if ( empty($_SESSION['phpCAS']['attributes'])) {
            phpCAS::error('this method (getDetails) should be used only after '.__CLASS__.'::forceAuthentication() or '.__CLASS__.'::isAuthenticated()');
        }
        return $_SESSION['phpCAS']['attributes'];
    }
    public function validatePT(&$validate_url,&$text_response,&$tree_response) {
        return $this->validateCAS20($validate_url,$text_response,$tree_response);
    }
    public function validateST(&$validate_url,&$text_response,&$tree_response) {
        return $this->validateCAS20($validate_url,$text_response,$tree_response);
    }
    public function getPT() {
        return $this-> getTicket();
    }
    public function setPT($ticket) {
        $this-> setTicket($ticket);
    }

    /*
     * Fonctions de gestion des ids de session pour la déconnexion centralisée sauce "Eole"
     */
    private function store_session_id($ticket, $session_id){
        /*
         * Stocke le lien ticket<->session_id dans une bdd pour le logout
         */
        phpCAS::traceBegin();
        phpCAS::log(" # Enregistrement d'un ticket et de l'id de session #");
        if (!is_dir(TICKET_BDD_PATH)){
            phpCAS::log("!!!! Le répertoire pour la bdd de gestion des tickets n'existe pas !!!!");
            phpCAS::traceEnd();
            return;
        }
        if (!$db = new SQLite3(TICKET_BDD)){
            phpCAS::log("!!!! Impossible d'ouvrir la base de données pour la gestion du logout !!!!");
            phpCAS::traceEnd();
            return;
        }
        phpCAS::log("  + Initialisation de la table dans la base de données");
        $sql = 'CREATE TABLE IF NOT EXISTS '.TICKET_TABLE.' (';
        $sql .= 'ticket VARCHAR(70) DEFAULT NULL,';
        $sql .= 'session_id VARCHAR(70) DEFAULT NULL,';
        $sql .= 'dv TIMESTAMP DEFAULT NULL';
        $sql .= ')';
        phpCAS::log($sql);
        $db->query($sql);

        $now = time();
        $dv=strftime('%Y-%m-%d %H:%M:%S', $now);
        $sql = "INSERT INTO " . TICKET_TABLE ." (ticket, session_id, dv)";
        $sql .= " VALUES ('" . sqlite3::escapeString($ticket) . "', '" . sqlite3::escapeString($session_id) . "', '" . sqlite3::escapeString($dv) . "')";
        phpCAS::log("  + Insertion du ticket dans la table");
        phpCAS::log($sql);
        if ($db->query($sql)){
            phpCAS::log("Le ticket '" . $ticket . "' a été enregistré avec comme id de session '" . $session_id . "' à '" . $dv . "'.");
            phpCAS::traceEnd();
        }else{
            phpCAS::log("Erreur à l'enregistrement du ticket dans la base de données.");
            phpCAS::traceEnd();
        };
    }
    private function retrieve_session($ticket){
        /*
         * Renvoie l'id de session associé au ticket
         */
        phpCAS::log("# Récupération de la session associée au ticket : '" . $ticket ."'.");
        if (!$db = new SQLite3(TICKET_BDD)){
            phpCAS::log("!!!! Impossible d'ouvrir la base de données pour la gestion du logout !!!!");
            return;
        }
        $sql = "SELECT session_id from " . TICKET_TABLE . " WHERE ticket='" . sqlite3::escapeString($ticket) ."';";
        phpCAS::log($sql);
        $result = $db->querySingle($sql);
        if ($result != null){
            phpCAS::log(" + On a retrouvé l'id de session dans la base de donnée");
            return $result;
        }else{
            phpCAS::log(" - Impossible de retrouvrer l'id de session");
            exit();
        }
    }
    private function remove_stored_session_id($ticket, $session_id){
        /*
         * Supprime l'enregistrement d'une session
         */
        if (!$db = new SQLite3(TICKET_BDD)){
            phpCAS::log("!!!! Impossible d'ouvrir la base de données pour la gestion du logout !!!!");
            return;
        }
        $sql = "DELETE FROM " . TICKET_TABLE . " WHERE ticket='" . sqlite3::escapeString($ticket) . "' AND session_id='" . sqlite3::escapeString($session_id). "';";
        if ($db->query($sql)){
            phpCAS::log(" + L'id de session a été supprimé de la base de données.");
        }
    }
    private function del_session($ticket){
        /*
         * Fonction de suppression de la session associée au ticket $ticket
         */
        $session_id = $this->retrieve_session($ticket);
        if($this->start_session) {
			phpCAS::log("  + L'id du ticket associée : " . $ticket);
			$fname = str_replace(".","",session_save_path()."/sess_" . $ticket);
		}
		else {
			phpCAS::log("  + L'id de la session associée : " . $session_id);
			$fname = str_replace(".","",session_save_path()."/sess_" . $session_id);
		}

        if (file_exists($fname)){
            phpCAS::log("  + Suppression du fichier de session " . $fname);
            if (unlink($fname)){
                phpCAS::log("  => La session a bien été supprimée");
                printf("Disconnected!");
            }else{
                phpCAS::log("  - !! Erreur à la suppression de la session !! ");
            }
        }else{
           phpCAS::log("  Fichier de session non existant - La session a déjà été supprimée ?! - ".$fname);
        }
        $this->remove_stored_session_id($ticket, $session_id);
    }
    function EoleLogoutRequests($check_client=true, $allowed_clients=false){
        /*
         * Fonction gérant les requêtes de logout centralisées provenant du serveur sso
         * @check_client : should the cas server be checked
         * @allowed_clients : array of trusted clients
         */
        phpCAS::traceBegin();
        if (!$this->_isLogoutRequest()) {
            phpCAS::log("Not a logout request");
            phpCAS::traceEnd();
            return;
        }
        phpCAS::log("Logout requested");
        phpCAS::log("SAML REQUEST: ".$_POST['logoutRequest']);
        if ($check_client) {
            if (!$allowed_clients) {
                $allowed_clients = array( $this->_getServerHostname() );
                array_push($allowed_clients,__CAS_IP);
            }
            $client_ip = $_SERVER['REMOTE_ADDR'];
            $client = gethostbyaddr($client_ip);
            phpCAS::log("Client: ".$client);
            $allowed = false;
            foreach ($allowed_clients as $allowed_client) {
                if ($client == $allowed_client) {
                    phpCAS::log("Allowed client '".$allowed_client."' matches, logout request is allowed");
                    $allowed = true;
                    break;
                } else {
                    phpCAS::log("Allowed client '".$allowed_client."' does not match");
                }
            }
            if (!$allowed) {
                phpCAS::error("Unauthorized logout request from client '".$client."'");
                printf("Unauthorized!");
                phpCAS::traceExit();
                exit();
            }
        } else {
            phpCAS::log("No access control set");
        }
        // Récupération du ticket dans la requête SAML
        preg_match("|<samlp:SessionIndex>(.*)</samlp:SessionIndex>|", $_POST['logoutRequest'], $tick, PREG_OFFSET_CAPTURE, 3);
        $wrappedSamlSessionIndex = preg_replace('|<samlp:SessionIndex>|','',$tick[0][0]);
        $ticket2logout = preg_replace('|</samlp:SessionIndex>|','',$wrappedSamlSessionIndex);
        if (! preg_match('/^[SP]T-/',$ticket2logout) ) {
            phpCAS::log("Doesn't look like a ticket." );
            exit();
        }else{
            phpCAS::log("Ticket to logout: ".$ticket2logout);
        }
        $this->del_session($ticket2logout);
        phpCAS::traceExit();
        exit();
    }

    /*
     * Fonction de diffusion des attrubut sous forme
     * du XML envoyé par le serveur CAS.
     * On reconstitue un XML équivalent pour éviter d'avoir
     * à écraser une partie des fonctions de la classe parente
     * */
    public function getCasXML(){
        if ( empty($this->casxml)){
            phpCAS::error('this method (getCasXML) should be used only after '.__CLASS__.'::forceAuthentication() or '.__CLASS__.'::isAuthenticated()');
        }
        return $this->casxml;
    }

    /*
     * FONCTIONS ÉCRASÉES
     */
    public function retrievePT($target_service,&$err_code,&$err_msg) {
        return parent::retrievePT($target_service,$err_code,$err_msg);
    }
    public function hasPGT() {
        return parent::_hasPGT();
    }
    public function getPGT() {
        return parent::_getPGT();
    }
    protected function _readExtraAttributesCas20($success_elements)
    {
        phpCAS::traceBegin();
        phpCas :: trace("Testing for eole style attributes");
        $extra_attributes = array();
        // EOLE
        // Eole Style additional attributes
        // same as jasig style, but attributes can be dispatched
        // in arbitrary subnodes (not only 'attributes').
        // $dom = $success_elements->item(0);
        foreach($success_elements->item(0)->childNodes as $section)
        {
            if ($section->hasChildNodes()) {
                // si la section a des enfants
                switch ($section->localName) {
                    case 'user':
                    case 'proxies':
                    case 'proxyGrantingTicket':
                        continue;
                    default:
                        $subdetails = array();
                        // on traite les sous-sections
                        foreach($section->childNodes as $node) {

                            if ( $node->localName != "" ) {
                                if (! isset($subdetails[$node->localName])){
                                    $subdetails[$node->localName] = Array($node->nodeValue);
                                }else{
                                    $subdetails[$node->localName][] = $node->nodeValue;
                                }
                                if (sizeof($subdetails) == 0){
                                    $subdetails = $section->nodeValue;
                                }

                                if ($section->localName != ""){
                                    $extra_attributes[$section->localName] = $subdetails;
                                }
                            }
                        }
                    }
            // FIN EOLE
            } else {
                // "RubyCAS Style" attributes
                //
                //  <cas:serviceResponse xmlns:cas='http://www.yale.edu/tp/cas'>
                //      <cas:authenticationSuccess>
                //          <cas:user>jsmith</cas:user>
                //
                //          <cas:attraStyle>RubyCAS</cas:attraStyle>
                //          <cas:surname>Smith</cas:surname>
                //          <cas:givenName>John</cas:givenName>
                //          <cas:memberOf>CN=Staff,OU=Groups,DC=example,DC=edu</cas:memberOf>
                //          <cas:memberOf>CN=Spanish Department,OU=Departments,OU=Groups,DC=example,DC=edu</cas:memberOf>
                //
                //          <cas:proxyGrantingTicket>PGTIOU-84678-8a9d2sfa23casd</cas:proxyGrantingTicket>
                //      </cas:authenticationSuccess>
                //  </cas:serviceResponse>
                //
                phpCas :: trace("Testing for rubycas style attributes");
                $childnodes = $section->childNodes;
                foreach ($childnodes as $attr_node) {
                    switch ($attr_node->localName) {
                    case 'user':
                    case 'proxies':
                    case 'proxyGrantingTicket':
                        continue;
                    default:
                        if (strlen(trim($attr_node->nodeValue))) {
                            phpCas :: trace("Attribute [".$attr_node->localName."] = ".$attr_node->nodeValue);
                            $this->_addAttributeToArray($extra_attributes, $attr_node->localName, $attr_node->nodeValue);
                        }
                    }
                }
            }
        }
        // "Name-Value" attributes.
        //
        // Attribute format from these mailing list thread:
        // http://jasig.275507.n4.nabble.com/CAS-attributes-and-how-they-appear-in-the-CAS-response-td264272.html
        // Note: This is a less widely used format, but in use by at least two institutions.
        //
        //  <cas:serviceResponse xmlns:cas='http://www.yale.edu/tp/cas'>
        //      <cas:authenticationSuccess>
        //          <cas:user>jsmith</cas:user>
        //
        //          <cas:attribute name='attraStyle' value='Name-Value' />
        //          <cas:attribute name='surname' value='Smith' />
        //          <cas:attribute name='givenName' value='John' />
        //          <cas:attribute name='memberOf' value='CN=Staff,OU=Groups,DC=example,DC=edu' />
        //          <cas:attribute name='memberOf' value='CN=Spanish Department,OU=Departments,OU=Groups,DC=example,DC=edu' />
        //
        //          <cas:proxyGrantingTicket>PGTIOU-84678-8a9d2sfa23casd</cas:proxyGrantingTicket>
        //      </cas:authenticationSuccess>
        //  </cas:serviceResponse>
        //
        if (!count($extra_attributes) && $success_elements->item(0)->getElementsByTagName("attribute")->length != 0) {
            $attr_nodes = $success_elements->item(0)->getElementsByTagName("attribute");
            $firstAttr = $attr_nodes->item(0);
            if (!$firstAttr->hasChildNodes() && $firstAttr->hasAttribute('name') && $firstAttr->hasAttribute('value')) {
                phpCas :: trace("Found Name-Value style attributes");
                // Nested Attributes
                foreach ($attr_nodes as $attr_node) {
                    if ($attr_node->hasAttribute('name') && $attr_node->hasAttribute('value')) {
                        phpCas :: trace("Attribute [".$attr_node->getAttribute('name')."] = ".$attr_node->getAttribute('value'));
                        $this->_addAttributeToArray($extra_attributes, $attr_node->getAttribute('name'), $attr_node->getAttribute('value'));
                    }
                }
            }
        }
        $this->setAttributes($extra_attributes);
        phpCAS::traceEnd();
        return true;
    }


}
