#!/bin/bash
#################################################
# enregistrement_domaine.sh
#################################################
set -e
. /usr/lib/eole/ihm.sh

TYPE_AUTH=$(CreoleGet type_squid_auth aucun)

if [ "$TYPE_AUTH" != 'NTLM/KERBEROS' -a "$TYPE_AUTH" != 'NTLM/SMB' ]; then
    EchoRouge "L'authentification du proxy n'est pas de type NTLM"
    exit 1
fi

if [ "$TYPE_AUTH" == 'NTLM/KERBEROS' ];then
    nom_domaine=$(CreoleGet nom_domaine_windows)
else
    nom_domaine=$(CreoleGet nom_domaine_smb)
fi

question() {
    echo "Le serveur est déjà intégré à un domaine."
    CreoleRun "/usr/bin/wbinfo -t -D $nom_domaine" proxy
    QUESTION="Relancer l'intégration ?"
    Question_ouinon "$QUESTION" True non warn || exit 0
}

CreoleRun "/usr/bin/wbinfo -t" proxy &>/dev/null && question || true

#redemarrage de samba
echo "*** Redémarrage des services pour l'enregistrement au domaine ***"
CreoleService winbind stop -c proxy
CreoleService smbd restart -c proxy
CreoleService nmbd restart -c proxy
ret=$(CreoleService winbind start -c proxy) && echo -e $ret || true

if [ $TYPE_AUTH = 'NTLM/KERBEROS' ]; then
    ip_serveur=$(CreoleGet ip_serveur_krb)
    nom_serveur="$(CreoleGet nom_serveur_krb).$(CreoleGet nom_domaine_krb)"
    type_serveur="ads"
elif [ "$TYPE_AUTH" = 'NTLM/SMB' ]; then
    ip_serveur=$(CreoleGet ip_serveur_smb)
    nom_serveur=$(CreoleGet nom_serveur_smb)
    type_serveur="rpc"
fi

iterator=1
tentative=""
max=5

while true; do
    echo
    echo -n "Nom de l'administrateur du contrôleur de domaine (${tentative}annule si vide) : "
    read user_admin
    if [ -z $user_admin ]; then
        echo "Annulation"
        exit 0
    fi
    echo -n "Mot de passe de l'administrateur du contrôleur de domaine : "
    read -s mdp_admin
    echo
    cmd="/usr/bin/net $type_serveur join -I $ip_serveur -U $user_admin%'${mdp_admin}' -S $nom_serveur"
    #inscription de la station dans un domaine
    CreoleRun "$cmd" proxy && break || true
    if [ $iterator = $max ]; then
        echo "Impossible de joindre le domaine"
        exit 1
    fi
    iterator=$((iterator+1))
    tentative="$iterator/$max "
done
echo

#redemarrage de samba
echo "*** Redémarrage des services pour confirmer l'enregistrement au domaine ***"
CreoleService winbind stop -c proxy
CreoleService smbd restart -c proxy
CreoleService nmbd restart -c proxy
CreoleService winbind start -c proxy || true
echo

#test de l'intégration
CreoleRun "/usr/bin/wbinfo -t -D $nom_domaine" proxy
if [ $? -eq 1 ]; then
    echo
    EchoRouge "L'intégration au domaine $nom_domaine a échoué"
    exit 1
else
    echo
    EchoVert "L'intégration au domaine $nom_domaine a réussi"
fi

exit 0
