# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Eole-register
#
# Ce logiciel permet de déterminer la configuration matérielle d'une machine
# afin d'alimenter une base de données de matériel compatible.
#
###########################################################################
"""Utilitaire de parsing de l'entree XML,
cree des objets à partir du fichier XML
"""
from lshwobjects import Computer, Network, Processor, Multimedia, Memory, \
Disk, Diskcard
from utils import get_sett, get_node, get_text, get_myname

def inst_network(tree):
    """instanciation des objets networks
    """
    # liste des vendors de networks déjà rencontrés
    products = []
    networks = []
    for node in tree.getiterator('node'):
        nod = node.get('id')
        if nod.startswith('network'):
            product = get_text(node, 'product')
            vendor = get_text(node, 'vendor')
            # on ajoute le vendor à la liste dejà parsée
            if product not in products:
                products.append(product)
                # instanciation de l'objet network
                networks.append(Network(product, vendor))
    return networks

def inst_processor(tree):
    """instanciation de l'objet processor
    """
    for node in tree.getiterator('node'):
        nd_class = node.get('class')
        if nd_class == 'processor':
            cpu = node
            product = get_text(cpu, 'product')
            vendor = get_text(cpu, 'vendor')
            width = get_text(cpu, 'width')
            break
    return Processor(product, vendor, width)

def inst_multimedia(tree):
    """instanciation de l'objet multimedia
    """
    node = get_node(tree,'multimedia')
    product = get_text(node, 'product')
    vendor = get_text(node, 'vendor')
    return Multimedia(product, vendor)

def inst_memory(tree):
    """instanciation de l'objet memory
    """
    node = get_node(tree,'memory')
    size = get_text(node, 'size')
    return Memory(size)

def inst_disk(tree):
    """instanciation de l'objet disk
    """
    # liste des products de disk déjà rencontrés
    products = []
    disks = []
    for node in tree.getiterator('node'):
        nod = node.get('id')
        if nod.startswith("disk"):
            product = get_text(node, 'product')
            vendor = get_text(node, 'vendor')
            # on ajoute le product à la liste dejà parsée
            if product not in products:
                products.append(product)
                disks.append(Disk(product, vendor))
    return disks

def inst_diskcard(tree):
    """instanciation de l'objet carte controleur de disque
    """
    # liste des products de diskcard déjà rencontrés
    products = []
    diskcards = []
    for node in tree.getiterator('node'):
        nod = node.get('class')
        if nod.startswith("storage"):
            product = get_text(node, 'product')
            vendor = get_text(node, 'vendor')
            driver = get_sett(node, 'driver')
            # on ajoute le product à la liste dejà parsée
            if product not in products:
                products.append(product)
                diskcards.append(Diskcard(product, vendor, driver))
    return diskcards

def inst_computer(tree):
    """instanciation de l'objet computer
    "celui-ci contient tous les autres objets
    """
    node = get_node(tree, get_myname())
    try:
        product_cpt = str(get_text(node, 'product'))
    except:
        product_cpt = '---'
    try:
        vendor_cpt = str(get_text(node, 'vendor'))
    except:
        vendor_cpt = '---'
    cpter = Computer(product = product_cpt, vendor = vendor_cpt,
                     disks = inst_disk(tree), diskcards = inst_diskcard(tree),
                     processor = inst_processor(tree),
                     multimedia = inst_multimedia(tree),
                     memory = inst_memory(tree),networks = inst_network(tree))
    return cpter
