# -*- coding: utf-8 -*-
"""module de configuration
"""
from configobj import ConfigObj
import os.path

# Serveur Eole a joindre
SERVEREOLE = "http://cpt-eole.ac-dijon.fr:5050"
# Port sur lequel écouter
PORTSERVER = "7080"
# Nom et version du module
if os.path.isfile('/etc/eole/release'):
    config = ConfigObj("/etc/eole/release")
    if config.has_key("EOLE_MODULE"):
        module = config['EOLE_MODULE']
    else:
        raise Exception('Pas de nom du module dans /etc/eole/release')
    if config.has_key("EOLE_VERSION"):
        version = config['EOLE_VERSION']
    else:
        raise Exception('Pas de version du module dans /etc/eole/release')
else:
    raise Exception('Pas de fichier /etc/eole/release')

EOLEMODULE = "%s-%s"%(module, version)
# Hôte hébergeant la base de données
HOSTSQL = "localhost"
# Nom d'utilisateur pour la base MySQL
LOGINSQL = "root"
# Mot de passe de connexion à la base MySQL
PASSSQL = "Eole21"
# Nom de la table contenant les infos. Shéma disponible dans le fichier doc/database.sql
DBSQL = "materiel"
