# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Eole-register
#
# Ce logiciel permet de déterminer la configuration matérielle d'une machine
# afin d'alimenter une base de données de matériel compatible.
#
###########################################################################
"""contient les objets utilises dans le script principal
"""
from twisted.python import log
try:
    import MySQLdb
except:
    pass
from utils import query_select, server_exist, insert_server
from config import HOSTSQL, LOGINSQL, PASSSQL, DBSQL
from creole.client import CreoleClient

class Network:
    """Objet reseau, contient le fabricant et le modele de la carte
    """
    def __init__(self, product="", vendor=""):
        """definition des attributs de l'objet
        """
        self.vendor = vendor
        self.product = product

    def todict(self):
        """renvoie un dictionnaire contenant les informations"""
        return dict(vendor=self.vendor, product=self.product)

    def fromdict(self, dct):
        """transforme le dictionnaire en objet"""
        self.__dict__.update(dct)
        return self

    def insert_sql(self):
        """insere l'objet simplement dans la bdd
        """
        try:
            return query_select('network', 'product', self.product)
        except:
            log.msg('----Insertion de la carte réseau')
            db = MySQLdb.connect(host=HOSTSQL, user=LOGINSQL, \
                                 passwd=PASSSQL, db=DBSQL)
            cursor = db.cursor()
            cursor.execute("INSERT INTO network SET product=\"%s\", \
                            vendor = \"%s\""%(self.product, self.vendor))
            return cursor.lastrowid

    def link_insert_sql(self, server_id):
        """inseres dans la bdd
        en liant dans la table de jonction prévue à cet effet
        """
        try:
            id_periph = query_select('network', 'product', self.product)
        except:
            log.msg('----Insertion de la carte reseau')
            db = MySQLdb.connect(host=HOSTSQL, user=LOGINSQL, \
                                 passwd=PASSSQL, db=DBSQL)
            cursor = db.cursor()
            cursor.execute("INSERT INTO network SET product='%s', \
                            vendor = '%s'"%(self.product, self.vendor))
            id_periph = cursor.lastrowid
        log.msg('----Création des liens configuration')
        db = MySQLdb.connect(host=HOSTSQL, user=LOGINSQL, \
                             passwd=PASSSQL, db=DBSQL)
        cursor = db.cursor()
        cursor.execute("REPLACE INTO server_network SET server_id=\"%s\", \
                        network_id = \"%s\""%(server_id, id_periph))

class Processor:
    """Objet processeur, contient le fabricant, la largeur de bus
    et le modèle du processeur
    """
    def __init__(self, product = "", vendor = "", width = ""):
        """definition des attributs de l'objet
        """
        self.vendor = vendor
        self.product = product
        self.width = width

    def todict(self):
        "renvoie un dictionnaire"
        return dict(vendor = self.vendor, product = self.product,
                    width = self.width)

    def fromdict(self, dct):
        """transforme le dictionnaire en objet"""
        self.__dict__.update(dct)
        return self

    def insert_sql(self):
        """insere ou met a jour la bdd avec les informations de l'objet
        """
        try:
            return query_select('cpu', 'product', self.product)
        except:
            log.msg('----Insertion du processeur')
            db = MySQLdb.connect(host=HOSTSQL, user=LOGINSQL, \
                                 passwd=PASSSQL, db=DBSQL)
            cursor = db.cursor()
            cursor.execute("INSERT INTO cpu SET product=\"%s\", \
                            vendor = \"%s\", width = \"%s\""%(self.product, \
                            self.vendor, self.width))
            return cursor.lastrowid

class Multimedia:
    """Objet multimedia, contient le fabricant et le modele de la carte son
    """
    def __init__(self, product = "", vendor = ""):
        """définition des attributs de l'objet
        """
        self.product = product
        self.vendor = vendor

    def todict(self):
        "renvoie un dictionnaire"
        return dict(product = self.product, vendor = self.vendor)

    def fromdict(self, dct):
        """transforme le dictionnaire en objet"""
        self.__dict__.update(dct)
        return self

    def insert_sql(self):
        """insere ou update la bdd avec les informations de l'objet
        """
        try:
            return query_select('multimedia', 'product', self.product)
        except:
            log.msg('----Insertion de la carte son')
            db = MySQLdb.connect(host=HOSTSQL, user=LOGINSQL, \
                                 passwd=PASSSQL, db=DBSQL)
            cursor = db.cursor()
            cursor.execute("INSERT INTO multimedia SET product=\"%s\", \
                            vendor = \"%s\""%(self.product, self.vendor))
            return cursor.lastrowid

class Memory:
    """Objet memoire, contient la taille de la memoire
    """
    def __init__(self, size = ""):
        """definition des attributs de l'objet
        """
        self.size = size

    def todict(self):
        "renvoie un dictionnaire"
        return dict(size = self.size)

    def fromdict(self, dct):
        """transforme le dictionnaire en objet"""
        self.__dict__.update(dct)
        return self

    def insert_sql(self):
        """insere ou update la bdd avec les informations de l'objet
        """
        try:
            return query_select('memory', 'size', self.size)
        except:
            log.msg('----Insertion de la mémoire')
            db = MySQLdb.connect(host=HOSTSQL, user=LOGINSQL, \
                                 passwd=PASSSQL, db=DBSQL)
            cursor = db.cursor()
            cursor.execute("INSERT INTO memory SET size=\"%s\""%(self.size))
            return cursor.lastrowid

class Disk:
    """Objet disque, contient le fabricant et le modele du disque dur
    """
    def __init__(self, product = "", vendor = ""):
        """definition des attributs de l'objet
        """
        self.product = product
        self.vendor = vendor

    def todict(self):
        "renvoie un dictionnaire"
        return dict(vendor = self.vendor, product = self.product)

    def fromdict(self, dct):
        """transforme le dictionnaire en objet"""
        self.__dict__.update(dct)
        return self

    def insert_sql(self):
        """insere ou update la bdd avec les informations de l'objet
        """
        try:
            return query_select('ide', 'product', self.product)
        except:
            log.msg('----Insertion des disques durs')
            db = MySQLdb.connect(host=HOSTSQL, user=LOGINSQL, \
                                 passwd=PASSSQL, db=DBSQL)
            cursor = db.cursor()
            cursor.execute("INSERT INTO ide SET product=\"%s\", \
                            vendor = \"%s\""%(self.product, self.vendor))
            return cursor.lastrowid

    def link_insert_sql(self, server_id):
        """insere dans la bdd
        en liant dans la table prevue a cet effet
        """
        try:
            id_periph = query_select('ide', 'product', self.product)
        except:
            log.msg('----Insertion des disques durs')
            db = MySQLdb.connect(host=HOSTSQL, user=LOGINSQL, \
                                 passwd=PASSSQL, db=DBSQL)
            cursor = db.cursor()
            cursor.execute("INSERT INTO ide SET product=\"%s\", \
                            vendor = \"%s\""%(self.product, self.vendor))
            id_periph = cursor.lastrowid
        log.msg('----Création des liens configuration')
        db = MySQLdb.connect(host=HOSTSQL, user=LOGINSQL, \
                             passwd=PASSSQL, db=DBSQL)
        cursor = db.cursor()
        cursor.execute("REPLACE INTO server_ide SET server_id=\"%s\", \
                        ide_id = \"%s\""%(server_id, id_periph))

class Diskcard:
    """Objet carte controleur, contient le fabricant, le driver et
    le modele de la carte
    """
    def __init__(self, product = "", vendor = "", driver = ""):
        """definition des attributs de l'objet
        """
        self.product = product
        self.vendor = vendor
        self.driver = driver

    def todict(self):
        "renvoie un dictionnaire"
        return dict(product=self.product, vendor=self.vendor, \
                    driver=self.driver)

    def fromdict(self, dct):
        """transforme le dictionnaire en objet"""
        self.__dict__.update(dct)
        return self

    def insert_sql(self):
        """insere ou update la bdd avec les informations de l'objet
        """
        try:
            return query_select('card', 'product', self.product)
        except:
            log.msg('----Insertion des cartes controleur')
            db = MySQLdb.connect(host=HOSTSQL, user=LOGINSQL, \
                                 passwd=PASSSQL, db=DBSQL)
            cursor = db.cursor()
            cursor.execute("INSERT INTO card SET product=\"%s\", \
                            vendor = \"%s\", driver = \"%s\""%(self.product, \
                            self.vendor, self.driver))
            return cursor.lastrowid

    def link_insert_sql(self, server_id):
        """inseres dans la bdd
        en liant dans la table prevue a cet effet
        """
        try:
            id_periph = query_select('card', 'product', self.product)
        except:
            log.msg('----Insertion des cartes controleur')
            db = MySQLdb.connect(host=HOSTSQL, user=LOGINSQL, \
                                 passwd=PASSSQL, db=DBSQL)
            cursor = db.cursor()
            cursor.execute("INSERT INTO card SET product=\"%s\", \
                            vendor = \"%s\", driver = \"%s\""%(self.product, \
                            self.vendor, self.driver))
            id_periph = cursor.lastrowid
        log.msg('----Création des liens configuration')
        db = MySQLdb.connect(host=HOSTSQL, user=LOGINSQL, \
                             passwd=PASSSQL, db=DBSQL)
        cursor = db.cursor()
        cursor.execute("REPLACE INTO server_card SET server_id=\"%s\", \
                         card_id = \"%s\""%(server_id, id_periph))

class Computer:
    """definition de l'objet Computer
    - celui-ci contient tous les autres objets
    - les methodes objet <-> dictionnaire
    - et les fonctions d'insertion dans la base de donnees
    """
    def __init__(self, product = "", vendor = "", disks = [], diskcards = [],
                 processor = "", multimedia = "", memory = "", networks = []):
        """definition des attributs de la classe
        """
        self.product = product
        self.vendor = vendor
        self.disks = disks
        self.diskcards = diskcards
        self.processor = processor
        self.multimedia = multimedia
        self.memory = memory
        self.networks = networks

    def todict(self):
        """construit un dictionnaire a partir des objets
        """
        departement = CreoleClient().get_creole('numero_etab', 'erreur')
        return dict(product = self.product, vendor = self.vendor,
                    departement=departement,
                    disks = [disk.todict() for disk in self.disks],
                    diskcards = [diskcard.todict() for diskcard
                    in self.diskcards], processor = self.processor.todict(),
                    multimedia = self.multimedia.todict(),
                    memory = self.memory.todict(),
                    networks = [network.todict() for network in self.networks])

    def fromdict(self, dct):
        """reconstruit des objets a partir du dictionnaire fourni
        """
        self.product = dct['product']
        self.vendor = dct['vendor']
        self.processor = Processor().fromdict(dct['processor'])
        self.multimedia = Multimedia().fromdict(dct['multimedia'])
        self.memory = Memory().fromdict(dct['memory'])
        self.disks = [Disk().fromdict(d) for d in dct['disks']]
        self.networks = [Network().fromdict(n) for n in dct['networks']]
        self.diskcards = [Diskcard().fromdict(c) for c in dct['diskcards']]
        self.departement = dct['departement']
        return self

    def insertsql(self):
        """verifie l'existence de la config materielle dans la base
        - si present : inseres simplement les peripheriques
        - si absent : inseres périph, puis serveur, puis periph multiples
        """
        #on vérifie existence machine
        try:
            server_exist(self.product)
        except :
            #cette machine n'existe pas : on l'insère avec les liens
            id_cpu = self.processor.insert_sql()
            id_memory = self.memory.insert_sql()
            id_son = self.multimedia.insert_sql()
            id_server = insert_server(id_cpu, id_memory, id_son,
                                      self.product, self.vendor)
            [d.link_insert_sql(id_server) for d in self.disks]
            [dc.link_insert_sql(id_server) for dc in self.diskcards]
            [n.link_insert_sql(id_server) for n in self.networks]
            return
        #si elle existe, on insère simplement les périphériques
        self.processor.insert_sql()
        self.memory.insert_sql()
        self.multimedia.insert_sql()
        [d.insert_sql() for d in self.disks]
        [dc.insert_sql() for dc in self.diskcards]
        [n.insert_sql() for n in self.networks]
