#!/usr/bin/python
# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# Eole-register
#
# Ce logiciel permet de déterminer la configuration matérielle d'une machine
# afin d'alimenter une base de données de matériel compatible.
#
###########################################################################
"""Script principal, lance le parsing et la connexion au serveur
"""
from lshw_parser import inst_computer
import os.path
from os import unlink
import xmlrpclib
import commands
from xml.etree.ElementTree import fromstring
from config import SERVEREOLE, EOLEMODULE
import pickle
import eoleproxy

def initialize():
    """
    Teste avec fonction *ping* si le serveur est disponible, si non quitte
    vérifie :
    - si materiel (empreinte du matériel) existe,
    - si non le crée et lance le parsing

    - si oui, vérifie la chaine contenue en la comparant avec un md5 de lswh.xml
    - si identique (aucun changement matériel) **ne fait rien**
    - si différent (chanchement matériel) **refait le fichier materiel
      et renvoie la nouvelle conf (parsing de lshw)**
    """
    # Gestion du proxy éventuel
    proxy = eoleproxy.get_proxy()
    try:
        if proxy != '':
            try:
                print "Connexion au serveur matériel via le proxy %s..." % proxy
                trans = eoleproxy.my_proxy(proxy)
                server = xmlrpclib.Server(SERVEREOLE, transport=trans)
                ping = server.ping()
            except :
                print "Erreur : test sans le proxy..."
                server = xmlrpclib.Server(SERVEREOLE)
                ping = server.ping()
        else:
            print "Connexion au serveur materiel..."
            server = xmlrpclib.Server(SERVEREOLE)
            ping = server.ping()

        if ping == '1':
            print ' -> Ping du serveur réussi'
    except:
        print ' -> Impossible de contacter le serveur...'
        return

    if os.path.exists('materiel'):

        try:
            fichier = open('materiel', 'r')
            old = pickle.load(fichier)
            fichier.close()
        except:
            # la base materiel a ete mal serialisee - reinitialisation
            unlink('materiel')
            old = None
        try:
            tree = execute_lshw()
        except:

            print "Problème de serialisation du XML"
            return
        computer = inst_computer(tree)
        resultat = computer.todict()
        if old == resultat:
            print '----Aucun changement matériel détecté'
            print '----Mise à jour des informations de connexion...'
            dico_compt = {}
            dico_compt['id'] = check_id()
            dico_compt['version'] = EOLEMODULE
            dico_compt['departement'] = resultat['departement']
            server.compt(dico_compt)
            return
        else:
            # premier enregistrement ou dump du materiel defectueux
            print '----Changement matériel détecté, détection automatique'
            fichier = open('materiel','w')
            pickle.dump(resultat, fichier)
            try:
                tree = execute_lshw()
            except:
                print "Problème de sérialisation du XML"
                unlink('materiel')
                return
            computer = inst_computer(tree)
            resultat = computer.todict()
            resultat['id'] = check_id()
            resultat['version'] = EOLEMODULE
            try:
                server.recover(resultat)
            except:
                print "Erreur d'enregistrement"
                return
    else:
        print '----Nouvelle installation détectée'
        fichier = open('materiel','w')
        try:
            tree = execute_lshw()
        except:
            print "Problème de sérialisation du XML"
            return
        computer = inst_computer(tree)
        resultat = computer.todict()
        pickle.dump(resultat, fichier)
        resultat['id'] = check_id()
        resultat['version'] = EOLEMODULE

        try:
            server.recover(resultat)
        except:
            print "Erreur d'enregistrement"
            return
        print "----Opération terminée avec succès"

def get_md5sum():
    """renvoie l'empreinte materielle
    n'est utilise qu'une seule fois pour generer l'empreinte unique
    """
    os.system('lshw -xml > lshw.xml')
    md5_result = commands.getoutput('md5sum lshw.xml')
    md5 = md5_result.split()
    md5_chain = md5[0]
    os.remove('lshw.xml')
    return md5_chain

def check_id():
    """cree un fichier unique identifiant a partir du lshw si non existant,
    sinon lit simplement le contenu et le renvoie
    """
    if not os.path.exists('id'):
        id_unique = get_md5sum()
        fichier = open('id', 'w').write(id_unique)
        return id_unique
    else:
        try:
            fichier = open('id')
            id_unique = fichier.readline()
            return id_unique
        except:
            raise Exception, "Problème de lecture de l'identifiant"

#utilitaire de récupération de la sortie lshw
def execute_lshw():
    """execute la commande lshw et renvoie l'arbre correspondant
    """
    temp = commands.getoutput("lshw -xml 2>/dev/null")
    try:
        tree = fromstring(temp)
    except:
        raise Exception, 'XML malformé'
    return tree

if __name__ == '__main__':
    initialize()
