#!/usr/bin/env python
# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# Eole-register
#  
# Ce logiciel permet de déterminer la configuration matérielle d'une machine
# afin d'alimenter une base de données de matériel compatible.
#       
###########################################################################

import autopath
import os.path as osp
from xml.etree.ElementTree import fromstring
from lshw_parser import *

HERE = osp.join(osp.dirname(__file__))
DATADIR = osp.join(HERE, 'data')
fichier = osp.join(DATADIR,'lshw.xml')
temp = open(fichier).read()
tree = fromstring(temp)

###########################################

#Zone de tests
def test_inst_computer():
    """teste le computer: parse correct ?
    """
    comp = inst_computer(tree)
    assert comp.product == 'SCENIC P / SCENICO P'
    assert comp.vendor == 'FUJITSU SIEMENS'
    assert isinstance(comp,Computer) == True

def test_inst_processor():
    """parsing du processeur
    """
    proc = inst_processor(tree)
    assert proc.product == "Intel(R) Celeron(R) CPU 2.66GHz"
    assert proc.vendor == "Intel Corp."
    assert proc.width == "32"
    assert isinstance(proc,Processor) == True

def test_inst_multimedia():
    """parsing du multimedia
    """
    multi = inst_multimedia(tree)
    assert multi.product == "AC'97 Sound Controller"
    assert multi.vendor == "Silicon Integrated Systems [SiS]"
    assert isinstance(multi, Multimedia) == True

def test_inst_memory():
    """parsing de la mémoire
    """
    mem = inst_memory(tree)
    assert mem.size == "1073741824"
    assert isinstance(mem,Memory) == True

def test_inst_disks():
    """parsing des disques
    """
    disk = inst_disk(tree)
    assert disk[0].product == "WDC WD800BB-55JKA0"
    assert disk[0].vendor == "Western Digital"
    assert isinstance(disk[0],Disk) == True

def test_inst_network():
    """parsing des cartes réseaux
    """
    net = inst_network(tree)
    assert net[0].product == "NC100 Network Everywhere Fast Ethernet 10/100"
    assert net[0].vendor == "ADMtek"
    assert isinstance(net[0],Network) == True

def test_inst_diskcard():
    """parsing de la carte controlleur
    """
    diskcard = inst_diskcard(tree)
    assert diskcard[0].product == "5513 [IDE]"
    assert diskcard[0].vendor == "Silicon Integrated Systems [SiS]"
    assert diskcard[0].driver == "SIS_IDE"
    assert isinstance(diskcard[0],Diskcard) == True
