# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007  
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr 
#  
# Eole-register
#  
# Ce logiciel permet de déterminer la configuration matérielle d'une machine
# afin d'alimenter une base de données de matériel compatible.
#       
###########################################################################
"""librairie contenant diverses méthodes
- petits utilitaires de parsing XML
- utilitaires mysql
"""
from config import HOSTSQL, LOGINSQL, PASSSQL, DBSQL
import commands

##utilitaires MySQL

def fetch_all(table_name, query_variable):
    """permet de récupérer les informations d'un peripherique donne 
    depuis une table donnee.
    table_name : nom de la table mysql
    query_variable : quel parametre a recuperer depuis la table mysql ?
    """
    import MySQLdb
    db = MySQLdb.connect(host=HOSTSQL, user=LOGINSQL, passwd=PASSSQL, db=DBSQL)
    cursor = db.cursor()
    cursor.execute("SELECT cle,%s FROM %s" %(query_variable, table_name))
    return cursor.fetchall()

def query_select(table_name, query_variable, select):
    """
    query : quel parametre a extraire de la table sql, soit 
    - product
    - size
    select : quel attribut personnel doit être utilise pour la comparaison ?
    - product
    - size
    size n'est utilise que pour la memoire, mais cela permet d'ecrire une
    fonction plus souple
    """
    import MySQLdb
    queryres = fetch_all(table_name, query_variable)
    for res in queryres:
        if res[1] == select:
            return res[0]
    raise Exception, "Aucun résultat trouvé."

def server_exist(select):
    """permet de verifier si un serveur existe
    """
    queryres = fetch_all('server','product')
    for res in queryres:
        if res[1] == select:
            return res[0]
    raise Exception, "Aucune machine de ce type dans la base."

def insert_server(id_cpu, id_memory, id_son, product, vendor):
    """insertion d'un serveur dans la base de donnees
    les identifiants permettent de lier les configurations
    """
    db = MySQLdb.connect(host=HOSTSQL, user=LOGINSQL, passwd=PASSSQL, db=DBSQL)
    cursor = db.cursor()
    cursor.execute("INSERT INTO `server` (`product`, `vendor`, `cpu`, \
                    `memory`, `multimedia`) VALUES ('%s','%s','%s','%s','%s')\
                    "%(product, vendor, id_cpu, id_memory, id_son))
    return cursor.lastrowid

##utilitaires de parsing XML

def get_sett(node, node_id):
    """:return: setting d'attribut id donne """
    for sett in node.getiterator('setting'):
        if sett.get('id') == node_id:
            driver = sett.get('value')
            return driver
    return 'erreur'

def get_node(tree, node_id):
    """:return: node d'attribut id donne """
    for node in tree.getiterator('node'):
        nod = node.get('id')
        if nod == node_id:
            return node
    return 'erreur'

def get_text(node, name):
    """renvoie le texte d'un attribut 'name' dans un node donne"""
    try:
        return node.find(name).text
    except:
        return "---"

def get_myname():
    """permet de récupérer le nom de la machine pour la marque du pc
    """
    monnom = commands.getoutput('uname -n 2>/dev/null')
    return monnom
