\r spip
SET character_set_client = utf8;

DELIMITER |
DROP PROCEDURE IF EXISTS do_spip_update|
CREATE PROCEDURE do_spip_update()
BEGIN
	-- On va regarder la version de la base qui est installée
	-- Si elle est inférieure à 19268 alors on va procéder à une maj de la base
	IF((SELECT `valeur` FROM `spip_meta` WHERE `nom`='version_installee') < 19268) THEN
		-- Table spip_articles
		ALTER TABLE `spip_articles`
		DROP `extra`,
		DROP `id_version`,
		ADD `virtuel` varchar(255) NOT NULL default '';

		-- Table spip_auteurs
		ALTER TABLE `spip_auteurs`
		ADD `webmestre` varchar(3) NOT NULL default 'non',
		DROP `imessage`,
		DROP `messagerie`,
		DROP `extra`;

		-- Table spip_auteurs_articles
		DROP TABLE IF EXISTS `spip_auteurs_articles`;
		
		-- Table spip_auteurs_messages (devient spip_auteurs_liens)
		ALTER TABLE `spip_auteurs_messages` RENAME TO `spip_auteurs_liens`;
		ALTER TABLE `spip_auteurs_liens`
		CHANGE `id_message` `id_objet` bigint(21) NOT NULL default '0',
		ADD `objet` varchar(25) NOT NULL default '',
		MODIFY `vu` varchar(6) NOT NULL default 'non',
		DROP PRIMARY KEY,
		DROP KEY `id_message`,
		ADD PRIMARY KEY  (`id_auteur`,`id_objet`,`objet`),
		ADD KEY `id_auteur` (`id_auteur`),
		ADD KEY `id_objet` (`id_objet`),
 		ADD KEY `objet` (`objet`);

		-- Table spip_auteurs_rubriques
		DROP TABLE IF EXISTS `spip_auteurs_rubriques`;

		-- Table spip_breves
		ALTER TABLE `spip_breves`
		DROP `extra`;

		-- Table spip_depots
		CREATE TABLE IF NOT EXISTS `spip_depots` (
		`id_depot` bigint(21) NOT NULL auto_increment,
		`titre` text NOT NULL,
		`descriptif` text NOT NULL,
		`type` varchar(10) NOT NULL default '',
		`url_serveur` varchar(255) NOT NULL default '',
		`url_brouteur` varchar(255) NOT NULL default '',
		`url_archives` varchar(255) NOT NULL default '',
		`url_commits` varchar(255) NOT NULL default '',
		`xml_paquets` varchar(255) NOT NULL default '',
		`sha_paquets` varchar(40) NOT NULL default '',
		`nbr_paquets` int(11) NOT NULL default '0',
		`nbr_plugins` int(11) NOT NULL default '0',
		`nbr_autres` int(11) NOT NULL default '0',
		`maj` timestamp NOT NULL default CURRENT_TIMESTAMP on update CURRENT_TIMESTAMP,
		PRIMARY KEY  (`id_depot`))
		ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=2 ;

		INSERT INTO `spip_depots` (`id_depot`, `titre`, `descriptif`, `type`, `url_serveur`, `url_brouteur`, `url_archives`, `url_commits`, `xml_paquets`, `sha_paquets`, `nbr_paquets`, `nbr_plugins`, `nbr_autres`, `maj`) VALUES
		(1, 'SPIP-Zone - Plugins', 'Outil communautaire sous SVN pour d�velopper des squelettes, des scripts, des plugins, des outils... autour de SPIP. Ce d�p�t ne contient que les plugins !', 'svn', 'svn://zone.spip.org/spip-zone', 'http://zone.spip.org/trac/spip-zone/browser', 'http://files.spip.org/spip-zone', 'http://zone.spip.org/trac/spip-zone/log/@src_archive@?format=rss&limit=10&mode=stop_on_copy', 'http://plugins.spip.net/depots/principal.xml', '282ff208f47e7c5f0d4e136f21a3c86bd3ba3dbd', 366, 352, 0, '2012-09-04 14:02:46');


		--  Table spip_depots_plugins
		CREATE TABLE IF NOT EXISTS `spip_depots_plugins` (
		  `id_depot` bigint(21) NOT NULL,
		  `id_plugin` bigint(21) NOT NULL,
		  PRIMARY KEY  (`id_depot`,`id_plugin`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8;

		INSERT INTO `spip_depots_plugins` (`id_depot`, `id_plugin`) VALUES
		(1, 24),
		(1, 25),
		(1, 26),
		(1, 27),
		(1, 28),
		(1, 29),
		(1, 30),
		(1, 31),
		(1, 32),
		(1, 33),
		(1, 34),
		(1, 35),
		(1, 36),
		(1, 37),
		(1, 38),
		(1, 39),
		(1, 40),
		(1, 41),
		(1, 42),
		(1, 43),
		(1, 44),
		(1, 45),
		(1, 46),
		(1, 47),
		(1, 48),
		(1, 49),
		(1, 50),
		(1, 51),
		(1, 52),
		(1, 53),
		(1, 54),
		(1, 55),
		(1, 56),
		(1, 57),
		(1, 58),
		(1, 59),
		(1, 60),
		(1, 61),
		(1, 62),
		(1, 63),
		(1, 64),
		(1, 65),
		(1, 66),
		(1, 67),
		(1, 68),
		(1, 69),
		(1, 70),
		(1, 71),
		(1, 72),
		(1, 73),
		(1, 74),
		(1, 75),
		(1, 76),
		(1, 77),
		(1, 78),
		(1, 79),
		(1, 80),
		(1, 81),
		(1, 82),
		(1, 83),	
		(1, 84),
		(1, 85),
		(1, 86),
		(1, 87),
		(1, 88),
		(1, 89),
		(1, 90),
		(1, 91),
		(1, 92),
		(1, 93),
		(1, 94),
		(1, 95),
		(1, 96),
		(1, 97),
		(1, 98),
		(1, 99),
		(1, 100),
		(1, 101),
		(1, 102),
		(1, 103),
		(1, 104),
		(1, 105),
		(1, 106),
		(1, 107),
		(1, 108),
		(1, 109),
		(1, 110),
		(1, 111),
		(1, 112),
		(1, 113),
		(1, 114),
		(1, 115),
		(1, 116),
		(1, 117),
		(1, 118),
		(1, 119),
		(1, 120),
		(1, 121),
		(1, 122),
		(1, 123),
		(1, 124),
		(1, 125),
		(1, 126),
		(1, 127),
		(1, 128),
		(1, 129),
		(1, 130),
		(1, 131),
		(1, 132),
		(1, 133),
		(1, 134),
		(1, 135),
		(1, 136),
		(1, 137),
		(1, 138),
		(1, 139),
		(1, 140),
		(1, 141),
		(1, 142),
		(1, 143),
		(1, 144),
		(1, 145),
		(1, 146),
		(1, 147),
		(1, 148),
		(1, 149),
		(1, 150),
		(1, 151),
		(1, 152),
		(1, 153),
		(1, 154),
		(1, 155),
		(1, 156),
		(1, 157),
		(1, 158),
		(1, 159),
		(1, 160),
		(1, 161),
		(1, 162),
		(1, 163),
		(1, 164),
		(1, 165),
		(1, 166),
		(1, 167),
		(1, 168),
		(1, 169),
		(1, 170),
		(1, 171),
		(1, 172),
		(1, 173),
		(1, 174),
		(1, 175),
		(1, 176),
		(1, 177),
		(1, 178),
		(1, 179),
		(1, 180),
		(1, 181),
		(1, 182),
		(1, 183),
		(1, 184),
		(1, 185),
		(1, 186),
		(1, 187),
		(1, 188),
		(1, 189),
		(1, 190),
		(1, 191),
		(1, 192),
		(1, 193),
		(1, 194),
		(1, 195),
		(1, 196),
		(1, 197),
		(1, 198),
		(1, 199),
		(1, 200),
		(1, 201),
		(1, 202),
		(1, 203),
		(1, 204),
		(1, 205),
		(1, 206),
		(1, 207),
		(1, 208),
		(1, 209),
		(1, 210),
		(1, 211),
		(1, 212),
		(1, 213),
		(1, 214),
		(1, 215),
		(1, 216),
		(1, 217),
		(1, 218),
		(1, 219),
		(1, 220),
		(1, 221),
		(1, 222),
		(1, 223),
		(1, 224),
		(1, 225),
		(1, 226),
		(1, 227),
		(1, 228),	
		(1, 229),
		(1, 230),
		(1, 231),
		(1, 232),
		(1, 233),
		(1, 234),
		(1, 235),
		(1, 236),
		(1, 237),
		(1, 238),
		(1, 239),
		(1, 240),
		(1, 241),
		(1, 242),
		(1, 243),
		(1, 244),
		(1, 245),
		(1, 246),
		(1, 247),
		(1, 248),
		(1, 249),
		(1, 250),
		(1, 251),
		(1, 252),
		(1, 253),
		(1, 254),
		(1, 255),
		(1, 256),
		(1, 257),
		(1, 258),
		(1, 259),
		(1, 260),
		(1, 261),
		(1, 262),
		(1, 263),
		(1, 264),
		(1, 265),
		(1, 266),
		(1, 267),
		(1, 268),
		(1, 269),
		(1, 270),
		(1, 271),
		(1, 272),
		(1, 273),
		(1, 274),
		(1, 275),
		(1, 276),
		(1, 277),
		(1, 278),
		(1, 279),
		(1, 280),
		(1, 281),
		(1, 282),
		(1, 283),
		(1, 284),
		(1, 285),
		(1, 286),
		(1, 287),
		(1, 288),
		(1, 289),
		(1, 290),
		(1, 291),
		(1, 292),
		(1, 293),
		(1, 294),
		(1, 295),
		(1, 296),
		(1, 297),
		(1, 298),
		(1, 299),
		(1, 300),
		(1, 301),
		(1, 302),
		(1, 303),
		(1, 304),
		(1, 305),
		(1, 306),
		(1, 307),
		(1, 308),
		(1, 309),
		(1, 310),
		(1, 311),
		(1, 312),
		(1, 313),
		(1, 314),
		(1, 315),
		(1, 316),
		(1, 317),
		(1, 318),
		(1, 319),
		(1, 320),
		(1, 321),
		(1, 322),
		(1, 323),
		(1, 324),
		(1, 325),
		(1, 326),
		(1, 327),
		(1, 328),
		(1, 329),
		(1, 330),
		(1, 331),
		(1, 332),
		(1, 333),
		(1, 334),
		(1, 335),
		(1, 336),
		(1, 337),
		(1, 338),
		(1, 339),
		(1, 340),
		(1, 341),
		(1, 342),
		(1, 343),
		(1, 344),
		(1, 345),
		(1, 346),
		(1, 347),
		(1, 348),
		(1, 349),
		(1, 350),
		(1, 351),
		(1, 352),
		(1, 353),
		(1, 354),
		(1, 355),
		(1, 356),
		(1, 357),
		(1, 358),
		(1, 359),
		(1, 360),
		(1, 361),
		(1, 362),
		(1, 363),
		(1, 364),
		(1, 365),
		(1, 366),
		(1, 367),
		(1, 368),
		(1, 369),
		(1, 370),
		(1, 371),
		(1, 372),	
		(1, 373),
		(1, 374),
		(1, 375);

		-- Table spip_documents
		ALTER TABLE `spip_documents`
		MODIFY `fichier` text NOT NULL,
		MODIFY `taille` bigint(20) default NULL,
		ADD `media` varchar(10) NOT NULL default 'file',
		MODIFY `mode` varchar(10) NOT NULL default 'document',
		ADD `statut` varchar(10) NOT NULL default '0',
		ADD `credits` varchar(255) NOT NULL default '',
		ADD `date_publication` datetime NOT NULL default '0000-00-00 00:00:00',
		ADD `brise` tinyint(4) default '0';

		-- Table spip_documents_liens
		ALTER TABLE `spip_documents_liens`
		ADD KEY `id_objet` (`id_objet`),
		ADD KEY `objet` (`objet`);

                -- TABLE spip_forum
		ALTER TABLE `spip_forum`
		ADD `id_objet` bigint(21) NOT NULL default '0',
		ADD `objet` varchar(25) NOT NULL default '',
		DROP KEY `optimal`,
		DROP `id_rubrique`,
		DROP `id_article`,
		DROP `id_breve`,
		DROP `id_message`,
		DROP `id_syndic`,
		ADD KEY `optimal` (`statut`,`id_parent`,`id_objet`,`objet`,`date_heure`);


		-- Table spip_jobs
		CREATE TABLE IF NOT EXISTS `spip_jobs` (
		  `id_job` bigint(21) NOT NULL auto_increment,
		  `descriptif` text NOT NULL,
		  `fonction` varchar(255) NOT NULL,
		  `args` longblob NOT NULL,
		  `md5args` char(32) NOT NULL default '',
		  `inclure` varchar(255) NOT NULL,
		  `priorite` smallint(6) NOT NULL default '0',
		  `date` datetime NOT NULL default '0000-00-00 00:00:00',
		  `status` tinyint(4) NOT NULL default '1',
		  PRIMARY KEY  (`id_job`),
		  KEY `date` (`date`),
		  KEY `status` (`status`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=20 ;

		INSERT INTO `spip_jobs` (`id_job`, `descriptif`, `fonction`, `args`, `md5args`, `inclure`, `priorite`, `date`, `status`) VALUES
		(1, 'Tache CRON queue_watch (toutes les 86400 s)', 'queue_watch', 0x613a313a7b693a303b643a313334363637383431303b7d, '50e194d6c917431fe7e00a3a057b2948', 'genie/', 0, '2012-09-04 15:20:10', 1),
		(2, 'Tache CRON optimiser (toutes les 172800 s)', 'optimiser', 0x613a313a7b693a303b643a313334363632363431393b7d, 'd466e7436b84a556475fbbeb653bd7c9', 'genie/', 0, '2012-09-05 00:53:39', 1),
		(18, 'Tache CRON invalideur (toutes les 600 s)', 'invalideur', 0x613a313a7b693a303b693a313334363736333031333b7d, 'f1b02edd88c5aeca85142104e13bdbd1', 'genie/', 0, '2012-09-04 15:00:13', 1),
		(4, 'Tache CRON maintenance (toutes les 7200 s)', 'maintenance', 0x613a313a7b693a303b643a313334363735363739303b7d, '8b2935b28bf10b070ac1002c07a2deb2', 'genie/', 0, '2012-09-04 15:06:30', 1),
		(5, 'Tache CRON mise_a_jour (toutes les 259200 s)', 'mise_a_jour', 0x613a313a7b693a303b643a313334363534373031333b7d, '4bc55cacc9909e3951b7858e1d6d356f', 'genie/', 0, '2012-09-05 02:50:13', 1),
		(9, 'Tache CRON svp_actualiser_depots (toutes les 21600 s)', 'svp_actualiser_depots', 0x613a313a7b693a303b693a313334363736303136363b7d, 'b25bfee95432fe4f9ea74b1f4908dd8e', 'genie/', 0, '2012-09-04 20:02:46', 1),
		(19, 'Tache CRON syndic (toutes les 90 s)', 'syndic', 0x613a313a7b693a303b693a313334363736333133303b7d, '8ff63362fef9275e4e1db37a58f1c199', 'genie/', 0, '2012-09-04 14:53:40', 1);

                
		-- Table spip_jobs_liens
		CREATE TABLE IF NOT EXISTS `spip_jobs_liens` (
		  `id_job` bigint(21) NOT NULL default '0',
		  `id_objet` bigint(21) NOT NULL default '0',
		  `objet` varchar(25) NOT NULL default '',
		  PRIMARY KEY  (`id_job`,`id_objet`,`objet`),
		  KEY `id_job` (`id_job`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8;


		-- Table spip_message
		ALTER TABLE `spip_messages`
		MODIFY `id_auteur` bigint(21) NOT NULL default '0',
		ADD `destinataires` text NOT NULL;

		
		-- Table spip_meta
		DELETE FROM `spip_meta` WHERE `nom`='plugin';
		DELETE FROM `spip_meta` WHERE `nom`='plugin_header';
		DELETE FROM `spip_meta` WHERE `nom`='plugin_installes';
		DELETE FROM `spip_meta` WHERE `nom`='plugins_interessants';
		DELETE FROM `spip_meta` WHERE `nom`='info_maj_spip';
		INSERT INTO `spip_meta` (`nom`, `valeur`, `impt`, `maj`) VALUES 
		('plugin_installes', 'a:16:{i:0;s:9:"compagnon";i:1;s:14:"couteau_suisse";i:2;s:5:"forum";i:3;s:6:"medias";i:4;s:4:"mots";i:5;s:10:"organiseur";i:6;s:9:"petitions";i:7;s:9:"revisions";i:8;s:5:"sites";i:9;s:12:"statistiques";i:10;s:3:"svp";i:11;s:13:"urls_etendues";i:12;s:25:"auto/lecteur_multimedia-2";i:13;s:32:"auto/eva_habillage_pour_spip_3_0";i:14;s:23:"auto/accesrestreint_3_5";i:15;s:6:"breves";}', 'non', '2012-09-19 10:40:59'),
		('plugins_interessants', 'a:40:{s:8:"auto/cfg";i:20;s:12:"auto/eolecas";i:20;s:19:"auto/couteau_suisse";i:20;s:17:"auto/spip-bonux-3";i:20;s:9:"vertebres";i:30;s:9:"textwheel";i:30;s:13:"urls_etendues";i:30;s:3:"svp";i:30;s:9:"revisions";i:30;s:8:"safehtml";i:30;s:5:"sites";i:30;s:23:"squelettes_par_rubrique";i:30;s:12:"statistiques";i:30;s:6:"medias";i:30;s:4:"mots";i:30;s:11:"msie_compat";i:30;s:10:"organiseur";i:30;s:9:"petitions";i:30;s:11:"porte_plume";i:30;s:8:"mediabox";i:30;s:4:"dump";i:30;s:14:"filtres_images";i:30;s:5:"forum";i:30;s:9:"jquery_ui";i:30;s:11:"compresseur";i:30;s:6:"breves";i:30;s:9:"compagnon";i:30;s:25:"auto/lecteur_multimedia-2";i:21;s:31:"auto/eva_mentions_pour_spip_3_0";i:22;s:33:"auto/eva_squelettes_pour_spip_3_0";i:23;s:33:"auto/eva_calendrier_pour_spip_3_0";i:24;s:32:"auto/eva_habillage_pour_spip_3_0";i:25;s:23:"auto/accesrestreint_3_5";i:26;s:29:"auto/eva_agenda_pour_spip_3_0";i:27;s:30:"auto/eva_install_pour_spip_3_0";i:28;s:28:"auto/eva_bonus_pour_spip_3_0";i:29;s:44:"_squelettes_/eva-web/4_2/eva_mini_calendrier";i:30;s:7:"eolecas";i:30;s:14:"couteau_suisse";i:30;s:3:"cfg";i:30;}', 'oui', '2012-09-19 10:40:56'),
		('plugin', 'a:39:{s:4:"SPIP";a:5:{s:3:"nom";s:4:"SPIP";s:4:"etat";s:6:"stable";s:7:"version";s:5:"3.0.4";s:8:"dir_type";s:14:"_DIR_RESTREINT";s:3:"dir";s:0:"";}s:3:"CFG";a:5:{s:3:"nom";s:3:"CFG";s:4:"etat";s:6:"stable";s:7:"version";s:5:"3.0.0";s:3:"dir";s:3:"cfg";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:9:"COMPAGNON";a:5:{s:3:"nom";s:9:"Compagnon";s:4:"etat";s:6:"stable";s:7:"version";s:5:"1.4.0";s:3:"dir";s:9:"compagnon";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:14:"COUTEAU_SUISSE";a:5:{s:3:"nom";s:333:"<multi>[en]Swiss Knife[fr]Le Couteau Suisse[ca]El Ganivet Su�s[ar]���� �����[nl]Het Zwitserland Mes[gl]A navalla su�za[es]La Navaja Suiza[de]Schweizer Taschenmesser[tr]�svi�re �ak�s�[br]Ar Gontell Suis[pt_br]Canivete Su��o[ast]La Navaya Suiza[gl]A navalla su�za[ro]Cu�itul Elve�ian[it]Coltellino Svizzero</multi>";s:4:"etat";s:6:"stable";s:7:"version";s:6:"1.8.98";s:3:"dir";s:14:"couteau_suisse";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:4:"DUMP";a:5:{s:3:"nom";s:4:"Dump";s:4:"etat";s:6:"stable";s:7:"version";s:5:"1.6.7";s:3:"dir";s:4:"dump";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:7:"EOLECAS";a:5:{s:3:"nom";s:7:"EoleCas";s:4:"etat";s:6:"stable";s:7:"version";s:3:"1.0";s:3:"dir";s:7:"eolecas";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:6:"IMAGES";a:5:{s:3:"nom";s:6:"Images";s:4:"etat";s:6:"stable";s:7:"version";s:5:"1.1.1";s:3:"dir";s:14:"filtres_images";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:5:"FORUM";a:5:{s:3:"nom";s:5:"Forum";s:4:"etat";s:6:"stable";s:7:"version";s:6:"1.8.16";s:3:"dir";s:5:"forum";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:8:"JQUERYUI";a:5:{s:3:"nom";s:9:"jQuery UI";s:4:"etat";s:6:"stable";s:7:"version";s:6:"1.8.21";s:3:"dir";s:9:"jquery_ui";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:8:"MEDIABOX";a:5:{s:3:"nom";s:8:"MediaBox";s:4:"etat";s:6:"stable";s:7:"version";s:5:"0.8.1";s:3:"dir";s:8:"mediabox";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:6:"MEDIAS";a:5:{s:3:"nom";s:6:"Medias";s:4:"etat";s:6:"stable";s:7:"version";s:6:"2.7.32";s:3:"dir";s:6:"medias";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:4:"MOTS";a:5:{s:3:"nom";s:4:"Mots";s:4:"etat";s:6:"stable";s:7:"version";s:5:"2.4.8";s:3:"dir";s:4:"mots";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:11:"MSIE_COMPAT";a:5:{s:3:"nom";s:25:"Support vieux navigateurs";s:4:"etat";s:6:"stable";s:7:"version";s:5:"1.2.0";s:3:"dir";s:11:"msie_compat";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:10:"ORGANISEUR";a:5:{s:3:"nom";s:10:"Organiseur";s:4:"etat";s:6:"stable";s:7:"version";s:5:"0.8.6";s:3:"dir";s:10:"organiseur";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:9:"PETITIONS";a:5:{s:3:"nom";s:10:"P�titions";s:4:"etat";s:6:"stable";s:7:"version";s:5:"1.4.3";s:3:"dir";s:9:"petitions";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:11:"PORTE_PLUME";a:5:{s:3:"nom";s:11:"Porte plume";s:4:"etat";s:6:"stable";s:7:"version";s:6:"1.11.6";s:3:"dir";s:11:"porte_plume";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:9:"REVISIONS";a:5:{s:3:"nom";s:10:"R�visions";s:4:"etat";s:6:"stable";s:7:"version";s:5:"1.7.0";s:3:"dir";s:9:"revisions";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:8:"SAFEHTML";a:5:{s:3:"nom";s:8:"SafeHTML";s:4:"etat";s:6:"stable";s:7:"version";s:5:"1.4.0";s:3:"dir";s:8:"safehtml";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:5:"SITES";a:5:{s:3:"nom";s:5:"Sites";s:4:"etat";s:6:"stable";s:7:"version";s:5:"1.7.6";s:3:"dir";s:5:"sites";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:23:"SQUELETTES_PAR_RUBRIQUE";a:5:{s:3:"nom";s:23:"Squelettes par Rubrique";s:4:"etat";s:6:"stable";s:7:"version";s:5:"1.1.0";s:3:"dir";s:23:"squelettes_par_rubrique";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:5:"STATS";a:5:{s:3:"nom";s:12:"Statistiques";s:4:"etat";s:6:"stable";s:7:"version";s:5:"0.4.9";s:3:"dir";s:12:"statistiques";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:3:"SVP";a:5:{s:3:"nom";s:3:"SVP";s:4:"etat";s:6:"stable";s:7:"version";s:6:"0.80.1";s:3:"dir";s:3:"svp";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:2:"TW";a:5:{s:3:"nom";s:19:"TextWheel pour SPIP";s:4:"etat";s:6:"stable";s:7:"version";s:6:"0.8.14";s:3:"dir";s:9:"textwheel";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:4:"URLS";a:5:{s:3:"nom";s:13:"Urls Etendues";s:4:"etat";s:6:"stable";s:7:"version";s:6:"1.4.13";s:3:"dir";s:13:"urls_etendues";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:9:"VERTEBRES";a:5:{s:3:"nom";s:10:"Vert�bres";s:4:"etat";s:6:"stable";s:7:"version";s:5:"1.2.1";s:3:"dir";s:9:"vertebres";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:10:"SPIP_BONUX";a:5:{s:3:"nom";s:10:"SPIP Bonux";s:4:"etat";s:6:"stable";s:7:"version";s:5:"3.0.2";s:3:"dir";s:17:"auto/spip-bonux-3";s:8:"dir_type";s:12:"_DIR_PLUGINS";}s:6:"PLAYER";a:5:{s:3:"nom";s:19:"Lecteur Multim�dia";s:4:"etat";s:6:"stable";s:7:"version";s:5:"2.1.1";s:3:"dir";s:25:"auto/lecteur_multimedia-2";s:8:"dir_type";s:12:"_DIR_PLUGINS";}s:11:"EVAMENTIONS";a:5:{s:3:"nom";s:29:"Gestion des mentions l�gales";s:4:"etat";s:6:"stable";s:7:"version";s:5:"4.2.0";s:3:"dir";s:31:"auto/eva_mentions_pour_spip_3_0";s:8:"dir_type";s:12:"_DIR_PLUGINS";}s:13:"EVASQUELETTES";a:5:{s:3:"nom";s:11:"EVA-WEB 4.2";s:4:"etat";s:6:"stable";s:7:"version";s:3:"4.2";s:3:"dir";s:33:"auto/eva_squelettes_pour_spip_3_0";s:8:"dir_type";s:12:"_DIR_PLUGINS";}s:14:"EVA_CALENDRIER";a:5:{s:3:"nom";s:32:"Rubrique calendrier pour EVA-web";s:4:"etat";s:6:"stable";s:7:"version";s:5:"4.2.1";s:3:"dir";s:33:"auto/eva_calendrier_pour_spip_3_0";s:8:"dir_type";s:12:"_DIR_PLUGINS";}s:13:"EVA_HABILLAGE";a:5:{s:3:"nom";s:39:"Gestion des habillages pour EVA-Web 4.2";s:4:"etat";s:6:"stable";s:7:"version";s:3:"4.2";s:3:"dir";s:32:"auto/eva_habillage_pour_spip_3_0";s:8:"dir_type";s:12:"_DIR_PLUGINS";}s:14:"ACCESRESTREINT";a:5:{s:3:"nom";s:15:"Acces Restreint";s:4:"etat";s:6:"stable";s:7:"version";s:5:"3.6.2";s:3:"dir";s:23:"auto/accesrestreint_3_5";s:8:"dir_type";s:12:"_DIR_PLUGINS";}s:10:"EVA_AGENDA";a:5:{s:3:"nom";s:49:"Affichage d�une rubrique sous forme d�agenda.";s:4:"etat";s:6:"stable";s:7:"version";s:5:"4.2.1";s:3:"dir";s:29:"auto/eva_agenda_pour_spip_3_0";s:8:"dir_type";s:12:"_DIR_PLUGINS";}s:11:"EVA_INSTALL";a:5:{s:3:"nom";s:36:"Cr�ation des mots cl�s d�eva-web";s:4:"etat";s:6:"stable";s:7:"version";s:3:"4.2";s:3:"dir";s:30:"auto/eva_install_pour_spip_3_0";s:8:"dir_type";s:12:"_DIR_PLUGINS";}s:8:"EVABONUS";a:5:{s:3:"nom";s:41:"EVA-bonus pour EVA-web 4.2, version alpha";s:4:"etat";s:6:"stable";s:7:"version";s:3:"4.2";s:3:"dir";s:28:"auto/eva_bonus_pour_spip_3_0";s:8:"dir_type";s:12:"_DIR_PLUGINS";}s:10:"ITERATEURS";a:5:{s:3:"nom";s:10:"iterateurs";s:7:"version";s:5:"0.6.1";s:4:"etat";s:1:"?";s:8:"dir_type";s:14:"_DIR_RESTREINT";s:3:"dir";s:0:"";}s:5:"QUEUE";a:5:{s:3:"nom";s:5:"queue";s:7:"version";s:5:"0.6.6";s:4:"etat";s:1:"?";s:8:"dir_type";s:14:"_DIR_RESTREINT";s:3:"dir";s:0:"";}s:6:"BREVES";a:5:{s:3:"nom";s:7:"Br�ves";s:4:"etat";s:6:"stable";s:7:"version";s:5:"1.3.3";s:3:"dir";s:6:"breves";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}s:11:"COMPRESSEUR";a:5:{s:3:"nom";s:11:"Compresseur";s:4:"etat";s:6:"stable";s:7:"version";s:5:"1.6.7";s:3:"dir";s:11:"compresseur";s:8:"dir_type";s:17:"_DIR_PLUGINS_DIST";}}', 'non', '2012-09-28 10:24:35'),
		('plugin_header', 'spip(3.0.4),compagnon(1.4.0),dump(1.6.7),images(1.1.1),forum(1.8.16),jqueryui(1.8.21),mediabox(0.8.1),medias(2.7.32),mots(2.4.8),msie_compat(1.2.0),organiseur(0.8.6),petitions(1.4.3),porte_plume(1.11.6),revisions(1.7.0),safehtml(1.4.0),sites(1.7.6),squelettes_par_rubrique(1.1.0),stats(0.4.9),svp(0.80.1),tw(0.8.14),urls(1.4.13),vertebres(1.2.1),cfg(3.0.0),couteau_suisse(1.8.98),eolecas(1.0),spip_bonux(3.0.2),player(2.1.1),evamentions(4.2.0),evasquelettes(4.2),eva_calendrier(4.2.1),eva_habillage(4.2),accesrestreint(3.6.2),eva_agenda(4.2.1),eva_install(4.2),evabonus(4.2),iterateurs(0.6.1),queue(0.6.6),breves(1.3.3),compresseur(1.6.7)', 'non', '2012-09-19 10:40:56'),
	('info_maj_spip', '3.0.4|<a class=''info_maj_spip'' href=''http://files.spip.org/spip'' title=''3.0.5''>nouvelles versions</a>', 'oui', '2012-09-19 10:38:59');
		UPDATE `spip_meta` SET `valeur`='0.4.1' WHERE `nom`='accesrestreint_base_version';
		UPDATE `spip_meta` SET `valeur`='0.2.4' WHERE `nom`='player_base_version';	
		UPDATE `spip_meta` SET `valeur`='1.8' WHERE `nom`='couteau_suisse_base_version';
		UPDATE `spip_meta` SET `valeur`='a:31:{s:11:"set_options";a:1:{s:5:"actif";i:0;}s:12:"suivi_forums";a:1:{s:5:"actif";i:0;}s:10:"guillemets";a:1:{s:5:"actif";i:1;}s:7:"pucesli";a:1:{s:5:"actif";i:1;}s:14:"typo_exposants";a:2:{s:5:"actif";i:1;s:7:"contrib";i:1564;}s:10:"insertions";a:1:{s:5:"actif";i:1;}s:9:"mailcrypt";a:2:{s:5:"actif";i:1;s:7:"contrib";i:2443;}s:8:"sommaire";a:2:{s:5:"actif";i:1;s:7:"contrib";i:2378;}s:10:"SPIP_liens";a:2:{s:5:"actif";i:1;s:7:"contrib";i:2443;}s:16:"supprimer_numero";a:1:{s:5:"actif";i:0;}s:16:"previsualisation";a:2:{s:5:"actif";i:0;s:11:"maj_distant";i:1;}s:14:"boites_privees";a:1:{s:7:"contrib";i:2564;}s:7:"decoupe";a:1:{s:7:"contrib";i:2135;}s:19:"visiteurs_connectes";a:1:{s:7:"contrib";i:3412;}s:10:"decoration";a:1:{s:7:"contrib";i:2427;}s:8:"couleurs";a:1:{s:7:"contrib";i:2427;}s:15:"liens_orphelins";a:1:{s:7:"contrib";i:2443;}s:10:"filets_sep";a:1:{s:7:"contrib";i:1563;}s:7:"smileys";a:1:{s:7:"contrib";i:1561;}s:9:"glossaire";a:1:{s:7:"contrib";i:2206;}s:14:"liens_en_clair";a:1:{s:7:"contrib";i:2443;}s:7:"jcorner";a:2:{s:7:"contrib";i:2987;s:11:"maj_distant";i:1;}s:12:"titre_parent";a:1:{s:7:"contrib";i:2900;}s:15:"trousse_balises";a:1:{s:7:"contrib";i:3005;}s:7:"horloge";a:1:{s:7:"contrib";i:2998;}s:8:"maj_auto";a:2:{s:7:"contrib";i:3223;s:11:"maj_distant";i:1;}s:17:"sessions_anonymes";a:1:{s:5:"actif";i:0;}s:5:"blocs";a:1:{s:7:"contrib";i:2583;}s:8:"devdebug";a:1:{s:7:"contrib";i:3572;}s:14:"ecran_securite";a:1:{s:11:"maj_distant";i:1;}s:7:"masquer";a:1:{s:11:"maj_distant";i:1;}}' WHERE `nom`='tweaks_actifs';
		UPDATE `spip_meta` SET `valeur`='a:10:{s:8:"_chaines";a:58:{i:0;s:18:"dossier_squelettes";i:1;s:10:"webmestres";i:2;s:18:"suite_introduction";i:3;s:18:"radio_set_options4";i:4;s:11:"mot_masquer";i:5;s:19:"radio_suivi_forums3";i:6;s:9:"spam_mots";i:7;s:8:"spam_ips";i:8;s:7:"dir_log";i:9;s:8:"file_log";i:10;s:15:"file_log_suffix";i:11;s:15:"message_travaux";i:12;s:9:"i_couleur";i:13;s:8:"i_police";i:14;s:22:"url_glossaire_externe2";i:15;s:17:"decoration_styles";i:16;s:14:"couleurs_perso";i:17;s:17:"glossaire_groupes";i:18;s:18:"fonds_demailcrypt2";i:19;s:15:"jcorner_classes";i:20;s:10:"insertions";i:21;s:10:"spip_ecran";i:22;s:14:"alerte_message";i:23;s:12:"tri_articles";i:24;s:9:"tri_perso";i:25;s:11:"tri_groupes";i:26;s:17:"tri_perso_groupes";i:27;s:7:"bloc_h4";i:28;s:11:"blocs_slide";i:29;s:7:"style_p";i:30;s:7:"style_h";i:31;s:7:"racc_hr";i:32;s:7:"racc_h1";i:33;s:7:"racc_h2";i:34;s:7:"racc_i1";i:35;s:7:"racc_i2";i:36;s:7:"racc_g1";i:37;s:7:"racc_g2";i:38;s:9:"ouvre_ref";i:39;s:9:"ferme_ref";i:40;s:10:"ouvre_note";i:41;s:10:"ferme_note";i:42;s:4:"puce";i:43;s:15:"devdebug_espace";i:44;s:15:"devdebug_niveau";i:45;s:16:"radio_type_urls3";i:46;s:11:"spip_script";i:47;s:21:"terminaison_urls_page";i:48;s:20:"separateur_urls_page";i:49;s:15:"url_arbo_sep_id";i:50;s:21:"terminaison_urls_arbo";i:51;s:24:"terminaison_urls_propres";i:52;s:18:"debut_urls_propres";i:53;s:19:"debut_urls_propres2";i:54;s:23:"terminaison_urls_libres";i:55;s:17:"debut_urls_libres";i:56;s:27:"terminaison_urls_propres_qs";i:57;s:18:"urls_id_sauf_liste";}s:8:"_nombres";a:120:{i:0;s:6:"alinea";i:1;s:7:"alinea2";i:2;s:11:"paragrapher";i:3;s:16:"lgr_introduction";i:4;s:17:"lien_introduction";i:5;s:25:"radio_filtrer_javascript3";i:6;s:13:"forum_lgrmaxi";i:7;s:9:"logo_Hmax";i:8;s:9:"logo_Wmax";i:9;s:9:"logo_Smax";i:10;s:8:"img_Hmax";i:11;s:8:"img_Wmax";i:12;s:8:"img_Smax";i:13;s:8:"doc_Smax";i:14;s:9:"img_GDmax";i:15;s:10:"img_GDqual";i:16;s:10:"copie_Smax";i:17;s:16:"auteur_forum_nom";i:18;s:18:"auteur_forum_email";i:19;s:17:"auteur_forum_deux";i:20;s:11:"ecran_actif";i:21;s:10:"ecran_load";i:22;s:18:"log_couteau_suisse";i:23;s:15:"spip_options_on";i:24;s:11:"distant_off";i:25;s:18:"distant_outils_off";i:26;s:14:"filtre_gravite";i:27;s:20:"filtre_gravite_trace";i:28;s:8:"log_brut";i:29;s:7:"max_log";i:30;s:12:"log_fileline";i:31;s:15:"taille_des_logs";i:32;s:14:"nombre_de_logs";i:33;s:13:"prive_travaux";i:34;s:13:"admin_travaux";i:35;s:15:"avertir_travaux";i:36;s:13:"titre_travaux";i:37;s:13:"cache_travaux";i:38;s:14:"bp_tri_auteurs";i:39;s:15:"bp_urls_propres";i:40;s:6:"cs_rss";i:41;s:11:"format_spip";i:42;s:12:"stat_auteurs";i:43;s:14:"qui_webmasters";i:44;s:16:"max_auteurs_page";i:45;s:9:"auteurs_0";i:46;s:9:"auteurs_1";i:47;s:9:"auteurs_5";i:48;s:9:"auteurs_6";i:49;s:9:"auteurs_n";i:50;s:17:"auteurs_tout_voir";i:51;s:14:"balise_decoupe";i:52;s:13:"prof_sommaire";i:53;s:12:"lgr_sommaire";i:54;s:13:"auto_sommaire";i:55;s:13:"jolies_ancres";i:56;s:15:"balise_sommaire";i:57;s:9:"i_padding";i:58;s:9:"i_hauteur";i:59;s:9:"i_largeur";i:60;s:8:"i_taille";i:61;s:19:"radio_target_blank3";i:62;s:15:"enveloppe_mails";i:63;s:8:"tout_rub";i:64;s:8:"tout_aut";i:65;s:8:"puceSPIP";i:66;s:14:"couleurs_fonds";i:67;s:12:"set_couleurs";i:68;s:11:"expo_bofbof";i:69;s:19:"liens_interrogation";i:70;s:15:"liens_orphelins";i:71;s:8:"long_url";i:72;s:9:"coupe_url";i:73;s:16:"glossaire_limite";i:74;s:12:"glossaire_js";i:75;s:14:"glossaire_abbr";i:76;s:12:"balise_email";i:77;s:17:"fonds_demailcrypt";i:78;s:8:"scrollTo";i:79;s:11:"LocalScroll";i:80;s:14:"jcorner_plugin";i:81;s:16:"moderation_admin";i:82;s:16:"moderation_redac";i:83;s:16:"moderation_visit";i:84;s:14:"titres_etendus";i:85;s:18:"arret_optimisation";i:86;s:17:"rubrique_brouteur";i:87;s:17:"select_mots_clefs";i:88;s:18:"select_min_auteurs";i:89;s:18:"select_max_auteurs";i:90;s:13:"meme_rubrique";i:91;s:11:"bloc_unique";i:92;s:12:"blocs_cookie";i:93;s:14:"blocs_millisec";i:94;s:13:"devdebug_mode";i:95;s:22:"radio_desactive_cache3";i:96;s:22:"radio_desactive_cache4";i:97;s:11:"duree_cache";i:98;s:16:"duree_cache_mutu";i:99;s:11:"quota_cache";i:100;s:23:"derniere_modif_invalide";i:101;s:13:"compacte_tout";i:102;s:14:"compacte_prive";i:103;s:12:"compacte_css";i:104;s:11:"compacte_js";i:105;s:19:"url_arbo_minuscules";i:106;s:19:"urls_arbo_sans_type";i:107;s:12:"url_max_arbo";i:108;s:15:"url_max_propres";i:109;s:22:"marqueurs_urls_propres";i:110;s:16:"url_max_propres2";i:111;s:23:"marqueurs_urls_propres2";i:112;s:14:"url_max_libres";i:113;s:18:"url_max_propres_qs";i:114;s:25:"marqueurs_urls_propres_qs";i:115;s:15:"urls_minuscules";i:116;s:12:"urls_avec_id";i:117;s:13:"urls_avec_id2";i:118;s:18:"urls_id_3_chiffres";i:119;s:22:"urls_id_sauf_rubriques";}s:13:"prof_sommaire";i:1;s:12:"lgr_sommaire";i:50;s:13:"jolies_ancres";i:0;s:13:"auto_sommaire";i:0;s:15:"balise_sommaire";i:0;s:19:"radio_target_blank3";i:1;s:22:"url_glossaire_externe2";s:0:"";s:15:"enveloppe_mails";i:-1;}' WHERE `nom`='tweaks_variables';
	INSERT INTO `spip_meta` (`nom`, `valeur`, `impt`, `maj`) VALUES
('player', 'a:2:{s:10:"player_mp3";s:9:"eraplayer";s:14:"insertion_auto";a:1:{i:0;s:11:"inline_mini";}}', 'oui', '2012-09-26 15:04:51');


		-- Table spip_mots_articles
		DROP TABLE IF EXISTS `spip_mots_articles`;

	
		-- Table spip_mots_breves
		DROP TABLE IF EXISTS `spip_mots_breves`;


		-- Table spip_mots_documents
		DROP TABLE IF EXISTS `spip_mots_documents`;


		-- Table spiip_mots_forum
		DROP TABLE IF EXISTS `spip_mots_forum`;


		-- Table spip_mots_rubiruqes
		ALTER  TABLE `spip_mots_rubriques` RENAME TO `spip_mots_liens`;
		ALTER TABLE `spip_mots_liens`
		DROP PRIMARY KEY,
		DROP KEY `id_mot`,
		CHANGE `id_rubrique` `id_objet` bigint(21) NOT NULL default '0',
		ADD `objet` varchar(25) NOT NULL default '',
		ADD PRIMARY KEY  (`id_mot`,`id_objet`,`objet`),
		ADD KEY `id_mot` (`id_mot`),
		ADD KEY `id_objet` (`id_objet`),
		ADD KEY `objet` (`objet`);


		-- Table spip_mots_syndic
		DROP TABLE IF EXISTS `spip_mots_syndic`;


		-- Table spip_paquets
		CREATE TABLE IF NOT EXISTS `spip_paquets` (
		  `id_paquet` bigint(21) NOT NULL auto_increment,
		  `id_plugin` bigint(21) NOT NULL,
		  `prefixe` varchar(30) NOT NULL default '',
		  `logo` varchar(255) NOT NULL default '',
		  `version` varchar(24) NOT NULL default '',
		  `version_base` varchar(24) NOT NULL default '',
		  `compatibilite_spip` varchar(24) NOT NULL default '',
		  `branches_spip` varchar(255) NOT NULL default '',
		  `description` text NOT NULL,
		  `auteur` text NOT NULL,
		  `credit` text NOT NULL,
		  `licence` text NOT NULL,
		  `copyright` text NOT NULL,
		  `lien_doc` text NOT NULL,
		  `lien_demo` text NOT NULL,
		  `lien_dev` text NOT NULL,
		  `etat` varchar(16) NOT NULL default '',
		  `etatnum` int(1) NOT NULL default '0',
		  `dependances` text NOT NULL,
		  `date_crea` datetime NOT NULL default '0000-00-00 00:00:00',
		  `date_modif` datetime NOT NULL default '0000-00-00 00:00:00',
		  `id_depot` bigint(21) NOT NULL default '0',
		  `nom_archive` varchar(255) NOT NULL default '',
		  `nbo_archive` int(11) NOT NULL default '0',
		  `maj_archive` datetime NOT NULL default '0000-00-00 00:00:00',
		  `src_archive` varchar(255) NOT NULL default '',
		  `traductions` text NOT NULL,
		  `actif` varchar(3) NOT NULL default 'non',
		  `installe` varchar(3) NOT NULL default 'non',
		  `recent` int(2) NOT NULL default '0',
		  `maj_version` varchar(255) NOT NULL default '',
		  `superieur` varchar(3) NOT NULL default 'non',
		  `obsolete` varchar(3) NOT NULL default 'non',
		  `attente` varchar(3) NOT NULL default 'non',
		  `constante` varchar(30) NOT NULL default '',
		  `signature` varchar(32) NOT NULL default '',
		  PRIMARY KEY  (`id_paquet`),
		  KEY `id_plugin` (`id_plugin`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=442 ;

              INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(412, 398, 'VERTEBRES', 'images/vertebres-32.png', '001.002.001', '', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿªÿ⿿ÿ¯ÿ⿦ ÿ¥ÿ¶ÿ§ÿÿ© ÿ§ÿ⿿ÿÿ⿿ÿ±ÿ§ÿª ÿ˿ÿ³ÿŠÿ⿿ÿ© ÿ¹ÿ±ÿ¶ ÿ¬ÿ¯ÿ§ÿ˿ÿ⿿ SQL ÿÿŠ ÿ⿿ÿ§ÿ¹ÿ¯ÿ© ÿ§ÿ⿿ÿ¨ÿŠÿ§ÿ⿠ÿ§ÿª ÿ˿ÿ°ÿ⿿ÿƿ ÿ¨ÿ¥ÿ¯ÿ®ÿ§ÿ⿿ ÿ⿦ÿªÿºÿŠÿ± ÿÿŠ ÿ¹ÿ⿠ÿ˿ÿ§ÿ⿠ ÿ§ÿ⿿ÿµÿÿ­ÿ© ÿŠÿ­ÿ¯ÿ¯ ÿ§ÿ⿿ÿ¬ÿ¯ÿ˿ÿ⿿ ÿ§ÿ⿿ÿ⿦ÿ·ÿ⿿ÿ˿ÿ¨ ÿ¹ÿ±ÿ¶ÿ⿡ ÿªÿ³ÿ¨ÿ⿿ÿ⿡ ÿ¹ÿ¨ÿ§ÿ±ÿ© &quot;table:&quot;ÿſ ÿ⿦ÿ«ÿ⿿ÿ§ÿ⿹:\n<code>ecrire/?exec=vertebres&table=spip_articles</code>[de]Das Plugin Wirbels�¤ule erm�¶glicht SQL Tabellen zu lesen, indem im URL der Parameter &quot;table:&quot; angegeben wird. Beispiel: <code>ecrire/?exec=vertebres&table=spip_articles</code>[en]Vertebrae provides a way to read a SQL table indicating\n as an argument of the page the database table to read, preceded of\n"table", for example: <code>ecrire/?exec=vertebres&table=spip_articles</code>[es]V�rtebras propone una forma de leer una tabla SQL indicando como argumento de p�¡gina el nombre de la tabla a leer precedido de &quot;table:&quot;, por ejemplo : <code>ecrire/?exec=vertebres&table=spip_articles</code>[fa]ÿÿ⿿ÿ±ÿ§ÿª ÿ±ÿ˿ÿ´ÿŠ ÿ¨ÿ±ÿ§ÿŠ ÿ®ÿ˿ÿ§ÿ⿠ÿ¯ÿ⿠ ÿŠÿƿ ÿ¬ÿ¯ÿ˿ÿ⿿ ÿ§ÿ³.ÿƿÿŠÿ˿.ÿ§ÿ⿿ ÿƿÿ⿡ ÿ¨ÿ⿡ ÿŠÿƿ ÿ¢ÿ±ÿ¯ÿ˿ÿ⿦ÿ§ÿ⿠ ÿµÿÿ­ÿ⿡â⿬ſÿŠ ÿ¬ÿ¯ÿ˿ÿ⿿ ÿ¾ÿ§ÿŠÿ¯ÿ§ÿ⿡ ÿ¯ÿ§ÿ¯ÿ⿡â⿬ſÿ©ÿ§ ÿ¯ÿ⿿ÿ§ÿ⿿ÿª ÿ¯ÿ§ÿ±ÿ¯ÿſ ÿ§ÿ±ÿ§ÿŠÿ⿡ ÿ⿦ÿŠâ⿬ſÿƿÿ⿠ÿ¯ÿſ ÿ¾ÿŠÿ´ ÿ§ÿ² ÿ«ÿ¬ÿ¯ÿ˿ÿ⿿ÿ»ÿſ ÿ¨ÿ⿡ ÿ¹ÿ⿠ÿ˿ÿ§ÿ⿠ ÿ⿠ÿ⿦ÿ˿ÿ⿠ÿ⿡:\n<code>ecrire/?exec=vertebres&table=spip_articles</code>[fr]Vert�bres propose un moyen de lire une table SQL en indiquant comme argument de page la table �  lire, pr�c�d� de &quot;table:&quot;, par exemple : <code>ecrire/?exec=vertebres&table=spip_articles</code>[it]Vert�bres offre un modo per leggere una tabella SQL passata come parametro, preceduta da  &quot;table:&quot;, per esempio : <code>ecrire/?exec=vertebres&table=spip_articles</code>[ru]Ð­ÿ⿿Ð¾ Ð¿Ð»Ð°Ð³Ð¸Ð½ (Vert�bres) Ð¿Ð¾Ð·Ð²Ð¾Ð»ÿÐµÿ⿿ Ð¿Ð¾Ð»ÿƿÿ⿡Ð°ÿ⿿ÿſ Ð¸Ð½ÿ⿿Ð¾ÿ⿬Ð¼Ð°ÿ⿠Ð¸ÿŽ Ð¸Ð· ÿ⿿Ð°Ð±Ð»Ð¸ÿ⿠ Ð±Ð°Ð·ÿ⿹ Ð´Ð°Ð½Ð½ÿ⿹ÿ⿦ (SQL) Ð¿Ðµÿ⿬ÐµÐ´Ð°Ð²Ð°ÿ Ð² Ð°Ð´ÿ⿬ÐµÿÐ½Ð¾Ð¹ ÿÿ⿿ÿ⿬Ð¾ÐºÐµ Ð½Ð°Ð·Ð²Ð°Ð½Ð¸Ðµ ÿ⿿Ð°Ð±Ð»Ð¸ÿ⿠ÿ⿹, Ð½Ð°Ð¿ÿ⿬Ð¸Ð¼Ðµÿ⿬ : <code>ecrire/?exec=vertebres&table=spip_articles</code>[sk]Vertebres pon�ºka sp�´sob na ÿ�­tanie tabuÿ¾ky SQL ako parameter, ktor�½ poÿ¾aduje od str�¡nky, aby preÿ�­tala tabuÿ¾ku, pred ktorou je "table:", napr�­klad: <code>ecrire/?exec=vertebres&table=spip_articles</code></multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:19:"FatCow pour l''icone";s:3:"url";s:33:"http://www.fatcow.com/free-icons/";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'vertebres', '', 'oui', 'non', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', 'b1a61e7ca5092f3bf64650d4d51332cc'),
(410, 396, 'TW', 'textwheel-32.png', '000.008.014', '', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ¯ÿ⿦ÿ¬ TextWheel ÿÿŠ SPIP[de]Integration von TextWheel in SPIP[en]Integrate TextWheel in SPIP[es]Integrar TextWheel en SPIP[fa]ÿ§ÿ¯ÿºÿ§ÿ⿦ ÿ⿠ÿ±ÿ®â⿬ſÿ⿠ÿ˿ÿŠÿ³ (TextWheel) ÿ¯ÿ± ÿ§ÿ³ÿ¾ÿŠÿ¾[fr]Int�grer TextWheel dans SPIP[it]Integra TextWheel in SPIP[ru]Ð˿Ð½ÿ⿿ÐµÐ³ÿ⿬Ð¸ÿ⿬Ð¾Ð²Ð°ÿ⿿ÿſ TextWheel Ð² SPIP[sk]Integrovaÿ¥ TextWheel do SPIPu</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:8:"GNU/LGPL";s:3:"url";s:37:"http://www.gnu.org/licenses/lgpl.html";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:4:"yaml";a:2:{s:3:"nom";s:4:"yaml";s:13:"compatibilite";s:6:"[1.3;[";}s:11:"memoization";a:2:{s:3:"nom";s:11:"memoization";s:13:"compatibilite";s:6:"[0.9;[";}}}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'textwheel', '', 'oui', 'non', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '3f63a18af334c0955186cbf272b74a4a'),
(411, 397, 'URLS', 'prive/themes/spip/images/url-32.png', '001.004.013', '1.1.3', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ¥ÿ¯ÿ§ÿ±ÿ© ÿªÿ⿠ÿ˿ÿ¹ÿ§ÿª ÿ¹ÿ⿠ÿ§ÿ˿ÿŠÿ⿠ URL ÿ°ÿ§ÿª ÿ§ÿ⿿ÿ⿦ÿ¹ÿ⿠ÿ⿰ ÿ§ÿ⿦ ÿ⿿ÿ§[de]Verwaltung von URL-Varianten[en]Management of the URL variants, meaningful or not[fa]ÿ⿦ÿ¯ÿŠÿ±ÿŠÿª ÿªÿ⿠ÿ˿ÿ¹ ÿŠÿ˿.ÿ¢ÿ±.ÿ§ÿ⿿â⿬ſÿ⿡ÿ§ÿŠ ÿ⿦ÿ⿡ÿ⿦ ÿŠÿ§ ÿºÿŠÿ±ÿ⿦ÿ⿡ÿ⿦[fr]Gestion des variantes d\'URL signifiantes ou non[it]Gestione delle varianti significative URL, o non[pt_br]Gerenciamento das variantes de URLs significantes ou n�£o[ru]SEO-friendly URLs (Ð§ÐŸÐ£ ÿÿÿ⿹Ð»ÐºÐ¸)[sk]Riadenie variantov URL, ÿi uÿ¾ s�mantick�½ch, alebo nie</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'urls_etendues', '', 'oui', 'oui', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', 'e5fbec5f06242049132098130bdc4019'),
(409, 395, 'SVP', 'svp-64.png', '000.080.001', '0.4.0', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿŠÿ⿿ÿ¯ÿ⿦ ÿ⿡ÿ°ÿ§ ÿ§ÿ⿿ÿ⿦ÿ⿿ÿ­ÿ⿿ÿſ ÿ⿦ÿ⿠ ÿ¬ÿ⿡ÿ©ÿſ ÿ¯ÿ§ÿ±ÿ© ÿªÿªÿŠÿ­ ÿªÿ⿠ÿÿŠÿ° ÿ¨ÿ­ÿ« ÿ⿦ÿªÿ¹ÿ¯ÿ¯ ÿ§ÿ⿿ÿ⿦ÿ¹ÿ§ÿŠÿŠÿ± ÿ­ÿ˿ÿ⿿ ÿ§ÿ⿿ÿ⿦ÿ⿿ÿ­ÿ⿿ÿ§ÿª ÿ˿ÿªÿ¬ÿ⿦ÿŠÿ¹ ÿ⿦ÿ¹ÿ⿿ÿ˿ÿ⿦ÿ§ÿª ÿ¹ÿ⿠ÿ⿡ÿ§ (ÿ⿠ÿ⿦ÿ§ÿ°ÿ¬ ÿ˿ÿ¸ÿŠÿÿŠÿ©ÿſ ÿ⿠ÿ⿦ÿ§ÿ°ÿ¬ ÿªÿµÿ§ÿ⿦ÿŠÿ⿦ÿ⿠ ÿµÿÿ­ÿ§ÿª ÿ⿠ÿ⿦ÿ˿ÿ°ÿ¬ÿŠÿ©) ÿ˿ÿ⿦ÿ⿠ ÿ¬ÿ⿡ÿ© ÿ£ÿ®ÿ±ÿ⿰ÿſ ÿŠÿ⿿ÿ¯ÿ⿦ ÿ˿ÿ§ÿ¬ÿ⿡ÿ© ÿ⿿ÿ¥ÿ¯ÿ§ÿ±ÿ© ÿ§ÿ⿿ÿ⿦ÿ⿿ÿ­ÿ⿿ÿ§ÿª ÿ˿ÿ§ÿ⿿ÿ¹ÿ⿿ÿ§ÿ⿿ÿ§ÿª ÿ¨ÿŠÿ⿠ÿ⿡ÿ§.[de]SVP stellt ein API bereit, mit dem SPIP-Plugins (Zusatzfunktionen, Themen und  Skelette) nach mehreren Kriterien gesucht  und ausgew�¤hlt werden k�¶nnen, und bietet eine Oberfl�¤che zur Verwaltung der  Plugins sowie ihrer Abh�¤ngigkeiten.[en]On one hand, this plugin provides an API to perform multi-criteria searches, to collect and present information on SPIP plugins (functional modules, themes, and skeletons) and on the other hand, proposes a new administration interface to manage the dependencies between plugins.[es]Este plugin proporciona, por un lado, una API que permite efectuar b�ºsquedas multi-criterio, recopilar y presentar informaci�³n sobre los plugins (m�³dulos funcionales, temas y esqueletos) y, por otro lado, una nueva interfaz de administraci�³n de los plugins que gestiona las dependencias entre ellos.[fa]ÿ§ÿŠÿ⿠ ÿ¾ÿ⿿ÿ§ÿ¯ÿŠÿ⿠ÿ⿠ÿſâ⿬ſ ÿ§ÿ² ÿŠÿƿ ÿ·ÿ±ÿ ÿŠÿƿ ÿ¢ÿŠ.ÿ¾ÿŠ.ÿŠÿŠ ÿ¨ÿ±ÿ§ÿŠ ÿ¬ÿ³ÿªÿ¬ÿ˿â⿬ſâ⿬ſÿ⿡ÿ§ÿŠ ÿ⿠ÿ⿠ÿ¯ ÿ⿦ÿ¹ÿŠÿ§ÿ±ÿ⿡  ÿ¨ÿ±ÿ§ÿŠ ÿ¯ÿ±ÿ¯ÿ¢ÿ˿ÿ±ÿŠ ÿ˿ ÿ§ÿ±ÿ§ÿŠÿ⿡â⿬ſÿŠ ÿ§ÿ·ÿ⿿ÿ§ÿ¹ÿ§ÿª ÿ¯ÿ± ÿ⿦ÿ˿ÿ±ÿ¯ ÿ¾ÿ⿿ÿ§ÿ¯ÿŠÿ⿠â⿬ſÿ⿡ÿ§ÿŠ ÿ§ÿ³ÿ¾ÿŠÿ¾ (ÿ⿦ÿ§ÿ¯ÿ˿ÿ˿ÿ⿿â⿬ſÿ⿡ÿ§ÿŠ ÿƿÿ§ÿ±ÿƿÿ±ÿ¯ÿŠÿſ ÿªÿ⿦â⿬ſÿ⿡ÿ§ ÿ˿ ÿ§ÿ³ÿƿÿ⿿ÿ«â⿬ſÿ⿡ÿ§) ÿ¯ÿ± ÿ§ÿ®ÿªÿŠÿ§ÿ± ÿ⿦ÿŠâ⿬ſÿ¯ÿ°ÿ§ÿ±ÿ¯ÿſ ÿ˿ ÿ§ÿ² ÿ·ÿ±ÿ ÿ¯ÿŠÿ¯ÿ±ÿſ ÿŠÿƿ ÿ˿ÿ§ÿ³ÿ· ÿ⿦ÿ¯ÿŠÿ±ÿŠÿªÿŠ ÿ¬ÿ¯ÿŠÿ¯ ÿ¨ÿ±ÿ§ÿŠ ÿ⿦ÿ¯ÿŠÿ±ÿŠÿª ÿ˿ÿ§ÿ¨ÿ³ÿªÿ¯ÿŠâ⿬ſÿ⿡ÿ§ÿŠ ÿ¨ÿŠÿ⿠ ÿ¾ÿ⿿ÿ§ÿ¯ÿŠÿ⿠â⿬ſÿ⿡ÿ§ ÿ±ÿ§ ÿ¾ÿŠÿ´ÿ⿠ÿ⿡ÿ§ÿ¯ ÿ⿦ÿŠâ⿬ſÿƿÿ⿠ÿ¯.[fr]Ce plugin fournit, d\'une part,  une API permettant d\'effectuer des recherches multi-crit�res, de collecter, et de pr�senter les informations sur les plugins SPIP (modules fonctionnels, th�mes et squelettes) et d\'autre part, une nouvelle interface d\'administration des plugins g�rant les d�pendances entre plugins.[it]Da un lato, questo plugin fornisce un''API per eseguire ricerche multi-criteri, per raccogliere e presentare informazioni su SPIP plugin (moduli funzionali, temi e scheletri) e, dall''altro, propone una nuova interfaccia di amministrazione per gestire le dipendenze tra i plugin.[ru]Ð­ÿ⿿Ð¾ÿ⿿ Ð¼Ð¾Ð´ÿƿÐ»ÿſ Ð¿ÿ⿬ÐµÐ´Ð¾ÿÿ⿿Ð°Ð²Ð»ÿÐµÿ⿿ API Ð¸ Ð¸Ð½ÿ⿿Ðµÿ⿬ÿ⿿ÐµÐ¹ÿ Ð´Ð»ÿ ÿƿÐ¿ÿ⿬Ð°Ð²Ð»ÐµÐ½Ð¸ÿ Ð¿Ð»Ð°Ð³Ð¸Ð½Ð°Ð¼Ð¸ SPIP.[sk]Tento z�¡suvn�½ modul poskytuje, po prv�, aplik�¡ciu umoÿ¾ÿ˿uj�ºcu vykon�¡vaÿ¥ vyhÿ¾ad�¡vania na z�¡klade viacer�½ch krit�ri�­, vyhÿ¾adaÿ¥ aÿ zobraziÿ¥ inform�¡cie oÿ z�¡suvn�½ch moduloch SPIPu (funkÿn�½ch moduloch, farebn�½ch mot�­voch iÿ ÿ¡abl�³nach) aÿ po druh�, nov� rozhranie nastaven�­ z�¡suvn�½ch modulov riadi z�¡vislosti medzi z�¡suvn�½mi modulmi.</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:14:"Eric Lupinacci";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://blog.smellup.net/spip.php?rubrique1', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'svp', '', 'oui', 'oui', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '3477671e0a1aa3f1cd40499f1c42d322'),
(404, 390, 'REVISIONS', 'prive/themes/spip/images/revision-32.png', '001.007.000', '1.1.2', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ⿦ÿªÿ§ÿ¨ÿ¹ÿ© ÿ§ÿ⿿ÿªÿºÿŠÿŠÿ±ÿ§ÿª ÿÿŠ ÿ§ÿ⿿ÿ¹ÿ⿠ÿ§ÿµÿ± ÿ§ÿ⿿ÿªÿ­ÿ±ÿŠÿ±ÿŠÿ©[de]�⿿nderungen von redaktionellen Inhalten nachvollziehen[en]Tracking changes of editorial objects[es]Seguimiento de las modificaciones de los objetos editoriales[fa]ÿ¾ÿŠÿ¯ÿŠÿ±ÿŠ ÿ§ÿµÿ⿿ÿ§ÿ­ÿ§ÿª ÿ⿦ÿ˿ÿ¶ÿ˿ÿ¹â⿬ſÿ⿡ÿ§ÿŠ ÿ³ÿ±ÿ¯ÿ¨ÿŠÿ±ÿŠ[fr]Suivi des modifications des objets �ditoriaux[it]Il rilevamento delle revisioni sugli oggetti editoriali[pt_br]Acompanhamento das altera�§�µes dos objetos editoriais[ru]Ð˿ÿÿ⿿Ð¾ÿ⿬Ð¸ÿ Ð¸Ð·Ð¼ÐµÐ½ÐµÐ½Ð¸Ð¹[sk]Sledujte zmeny redakÿn�½ch objektov</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'revisions', '', 'oui', 'oui', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', 'bb69a20a8989aec87533c8a25a839d3d'),
(405, 391, 'SAFEHTML', 'images/safehtml-32.png', '001.004.000', '', '[3.0.0;3.0.*]', '3.0', '<multi>[fr]Protection des forums contre les attaques de type cross-site scripting</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:3:{i:1;a:2:{s:3:"nom";s:12:"Roman Ivanov";s:3:"url";s:0:"";}i:2;a:2:{s:3:"nom";s:10:"Pixel-Apes";s:3:"url";s:0:"";}i:3;a:2:{s:3:"nom";s:8:"JetStyle";s:3:"url";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.ohloh.net/p/safehtml', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'safehtml', '', 'oui', 'non', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '89fa0cff1f9036f58debad390717efc0'),
(406, 392, 'SITES', 'prive/themes/spip/images/site-32.png', '001.007.006', '1.0.0', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ⿦ÿ˿ÿ§ÿ⿿ÿ¹ ÿ˿ÿªÿ±ÿ®ÿŠÿµ ÿÿŠ SPIP (ÿ®ÿ§ÿµ ÿ˿ÿ¹ÿ⿦ÿ˿ÿ⿦ÿŠ)[de]Verwaltung verlinkter und syndizierter Websites mit  SPIP (im �¶ffentlichen und Redaktionsbereich)[en]Sites and syndication in SPIP (private and public)[es]Sitios y sindicaci�³n en SPIP (privado y p�ºblico)[fa]ÿ³ÿ§ÿŠÿªâ⿬ſÿ⿡ÿ§ ÿ˿ ÿ⿦ÿ´ÿªÿ±ÿƿâ⿬ſÿ³ÿ§ÿ²ÿŠâ⿬ſÿ⿡ÿ§ ÿ¯ÿ± ÿ§ÿ³ÿ¾ÿ³ÿ¾ (ÿ®ÿµÿ˿ÿµÿŠ ÿ˿ ÿ⿡ÿ⿦ÿ¯ÿ§ÿ⿠ÿŠ)[fr]Sites et syndication dans SPIP (priv� et public)[it]Siti e syndication in SPIP (privato e pubblica)[pt_br]Sites e sindica�§�£o do SPIP (privado e p�ºblico)[ru]ÐŸÐ¾Ð´ÐºÐ»ÿŽÿ⿡ÐµÐ½Ð¸Ðµ Ð´ÿ⿬ÿƿÐ³Ð¸ÿ⿦ ÿÐ°Ð¹ÿ⿿Ð¾Ð² Ð¿Ð¾ RSS[sk]Str�¡nky aÿ syndik�¡cia vÿ SPIPe (s�ºkromn�¡ ajÿ verejn�¡)</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'sites', '', 'oui', 'oui', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '646f3bd1d3f8baf504b8fde7bc412ad7'),
(407, 393, 'SQUELETTES_PAR_RUBRIQUE', 'squelettes_par_rubrique-32.png', '001.001.000', '', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ¯ÿ¹ÿ⿦ ÿ§ÿ⿿ÿµÿÿ­ÿ§ÿª ÿ§ÿ⿿ÿ⿠ÿ⿦ÿ˿ÿ°ÿ¬ÿŠÿ© ÿ§ÿ⿿ÿªÿŠ ÿªÿ⿦ÿ⿿ÿƿ ÿ⿿ÿ§ÿ­ÿ⿿ÿ© ÿ±ÿ⿿ÿ⿦ÿŠÿ© ÿ˿/ÿ§ÿ˿ ÿ⿿ÿ§ÿ­ÿ⿿ÿ© ÿ±ÿ⿦ÿ² ÿ⿿ÿºÿ©[de]Unterst�¼tzung der Skelette mit Rubriknummer und/oder Sprachcode als Namenszusatz: (-23.html, =23.html, et .en.html)[en]Support of suffixed templates by section number and/or by language code : (-23.html, =23.html, and .en.html)[fa]ÿ¾ÿ´ÿªÿŠÿ¨ÿ§ÿ⿠ ÿ§ÿ³ÿƿÿ⿿ÿªâ⿬ſÿ⿡ÿ§ÿŠ ÿ¾ÿ³ÿ˿ÿ⿠ÿ¯ÿŠ ÿªÿ˿ÿ³ÿ· ÿªÿ¹ÿ¯ÿ§ÿ¯ÿŠ ÿ¨ÿ®ÿ´ ÿ˿/ÿŠÿ§ ÿªÿ˿ÿ³ÿ· ÿƿÿ¯ÿ± ÿ²ÿ¨ÿ§ÿ⿠ :  (-23.html, =23.html, et .en.html)[fr]Support des squelettes suffix�s par num�ro de rubrique et/ou par code de langue : (-23.html, =23.html, et .en.html)[it]Supporto dei modelli con suffisso numero di sezione e/o il codice della lingua: (-23.html, =23.html, et .en.html)[pt_br]Suporte aos gabaritos com sufixo do n�ºmeor da se�§�£o e/ou por c�³digo de idioma: (-23.html, =23.html, et .en.html)[ru]ÐŸÐ¾Ð·Ð²Ð¾Ð»ÿÐµÿ⿿ Ð·Ð°Ð´Ð°Ð²Ð°ÿ⿿ÿſ Ð¾ÿ⿿Ð´ÐµÐ»ÿſÐ½ÿ⿹Ðµ ÿ˿Ð°Ð±Ð»Ð¾Ð½ÿ⿹ Ð¿Ð¾ Ð½Ð¾Ð¼Ðµÿ⿬ÿƿ ÿ⿬Ð°Ð·Ð´ÐµÐ»Ð°, ÿÿ⿿Ð°ÿ⿿ÿſÐ¸, Ð° ÿ⿿Ð°Ðº Ð¶Ðµ ÿÐ·ÿ⿹ÐºÐ¾Ð²Ð¾Ð¹ Ð²Ðµÿ⿬ÿÐ¸Ð¸ : (-23.html, =23.html, Ð¸ .en.html)[sk]Podpora ÿ¡abl�³n pripojen�½ch voÿ forme pr�­pony podÿ¾a ÿ�­sla rubriky a/lebo k�³du jazyka: (-23.html, =23.html a .en.html)</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'squelettes_par_rubrique', '', 'oui', 'non', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '8aed3179ae24f879b7f962ded3fe3485'),
(408, 394, 'STATS', 'prive/themes/spip/images/statistique-32.png', '000.004.009', '1.0.0', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ¥ÿ­ÿµÿ§ÿ¡ÿ§ÿª SPIP[de]Estad�­sticas de SPIP[en]Statistics of SPIP[es]Estad�­sticas de SPIP[fa]ÿ¢ÿ⿦ÿ§ÿ±ÿ⿡ÿ§ÿŠ ÿ§ÿ³ÿ¾ÿŠÿ¾[fr]Statistiques de SPIP[it]Statistiche di SPIP[pt_br]Estat�­sticas do SPIP[ru]Ð¡ÿ⿿Ð°ÿ⿿Ð¸ÿÿ⿿Ð¸ÐºÐ° Ð¿Ð¾ÿÐµÿ⿰ÐµÐ½Ð¸Ð¹ ÿÐ°Ð¹ÿ⿿Ð°[sk]ÿ tatistiky SPIPu</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'statistiques', '', 'oui', 'oui', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', 'd2fd5967f21beef105f412737ea41b98'),
(398, 384, 'MEDIAS', 'prive/themes/spip/images/portfolio-32.png', '002.007.032', '1.2.1', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ£ÿ¯ÿ§ÿ±ÿ© ÿ§ÿ⿿ÿ˿ÿ³ÿ§ÿ¦ÿ· ÿ§ÿ⿿ÿ⿦ÿªÿ¹ÿ¯ÿ¯ÿ© ÿÿŠ SPIP[de]Medienverwaltung in  SPIP[en]SPIP''s media management[fa]ÿ⿦ÿ¯ÿŠÿ±ÿŠÿª ÿ±ÿ³ÿ§ÿ⿠ÿ⿡â⿬ſâ⿬ſÿ⿡ÿ§ÿŠ ÿ§ÿ³ÿ¾ÿŠÿ¾[fr]Gestion des m�dias de SPIP[it]Gestione dei media di SPIP[pt_br]Gerenciamento de m�­dias do SPIP[ru]Ð£Ð¿ÿ⿬Ð°Ð²Ð»ÐµÐ½Ð¸Ðµ Ð¼ÐµÐ´Ð¸Ð° ÿ⿿Ð°Ð¹Ð»Ð°Ð¼Ð¸[sk]Spr�¡va multim�di�­ v SPIPe</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:57:"C�dric Morin, Romy Duhem-Verdi�re pour la m�diath�que";s:3:"url";s:0:"";}}', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:1:"z";a:2:{s:3:"nom";s:1:"Z";s:13:"compatibilite";s:8:"[1.2.1;[";}s:8:"mediabox";a:2:{s:3:"nom";s:8:"mediabox";s:13:"compatibilite";s:8:"[0.5.0;[";}}}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'medias', '', 'oui', 'oui', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '4a316ec6bfeb8588042e368038c02d3e'),
(399, 385, 'MOTS', 'prive/themes/spip/images/mot-32.png', '002.004.008', '2.1.0', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ§ÿ⿿ÿ⿦ÿÿ§ÿªÿŠÿ­ ÿ˿ÿ⿦ÿ¬ÿ⿦ÿ˿ÿ¹ÿ§ÿª ÿ§ÿ⿿ÿ⿦ÿÿ§ÿªÿŠÿ­[de]Schlagworte und Schlagwortgruppen[en]Keywords and keywords groups[es]Palabras clave y grupos de palabras clave[fa]ÿ˿ÿ§ÿ˿ÿ⿡â⿬ſÿ⿡ÿ§ ÿ˿ ÿ¯ÿ±ÿ˿ÿ⿡â⿬ſ ÿ˿ÿ§ÿ˿ÿ⿡â⿬ſÿ⿡ÿ§[fr]Mots et Groupes de mots[it]Parole e Gruppi di parole[pt_br]Palavras-chave e seus grupos[ru]ÐšÐ»ÿŽÿ⿡Ð¸ Ð¸ Ð³ÿ⿬ÿƿÐ¿Ð¿ÿ⿹ ÐºÐ»ÿŽÿ⿡ÐµÐ¹[sk]Kÿ¾�ºÿov� slov�¡ a skupiny kÿ¾�ºÿov�½ch slov</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'mots', '', 'oui', 'oui', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '906ced64b5616b4d0e2bda7a04ef6930'),
(400, 386, 'MSIE_COMPAT', 'images/msiecompat-32.png', '001.002.000', '', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿŠÿªÿŠÿ­ ÿ§ÿ®ÿªÿŠÿ§ÿ± ÿ˿ÿ³ÿ§ÿ¦ÿ⿿ ÿ⿦ÿªÿ⿠ÿ˿ÿ¹ÿ©\n\n-* ÿ⿿ÿªÿ£ÿ⿦ÿŠÿ⿠ ÿ³ÿ⿿ÿ§ÿ⿦ÿ© ÿ¹ÿ±ÿ¶ ÿ⿦ÿ⿿ÿÿ§ÿª PNG ÿ§ÿ⿿ÿ´ÿÿ§ÿÿ© ÿÿŠ ÿ¥ÿ⿠ÿªÿ±ÿ⿠ÿª ÿ¥ÿƿÿ³ÿ¨ÿ⿿ÿ˿ÿ±ÿ± ÿ¦\n\n-* ÿ˿/ÿ§ÿ˿ ÿªÿÿ¹ÿŠÿ⿿ ÿ¹ÿ⿿ÿ§ÿ⿦ÿ§ÿª ÿ£ÿ˿ÿ±ÿ§ÿ⿿ ÿ§ÿ⿿ÿ£ÿ⿠ÿ⿦ÿ§ÿ· ÿÿŠ ÿ¥ÿ⿠ÿªÿ±ÿ⿠ÿª ÿ¥ÿƿÿ³ÿ¨ÿ⿿ÿ˿ÿ±ÿ± ÿ¦ ÿ˿ÿ§[de]Bietet verschiedene Methoden f�¼r:\n\n-* transparente PNG Dateien unter MSIE~6 \n\n-* und /oder diverse CSS Selektoren f�¼r MSIE~6 und~7.[en]Offers different javascript methods to add support for:\n-* transparent PNG files to MSIE~6 \n-* and/or various CSS selectors to MSIE~6 and~7.[es]Permite seleccionar diferentes m�todos \n\n-* para garantizar la visualizaci�³n de archivos PNG transparentes en MSIE 6 ~\n\n-* y/o activar algunos selectores CSS en MSIE~6 y ~7.[fa]ÿ⿦ÿ¬ÿ˿ÿ² ÿ¯ÿ²ÿŠÿ⿠ÿ´ ÿ±ÿ˿ÿ´â⿬ſÿ⿡ÿ§ÿŠ ÿ⿦ÿ®ÿªÿ⿿ÿ\n\n-* ÿ¨ÿ±ÿ§ÿŠ ÿ§ÿ·ÿ⿦ÿŠÿ⿠ÿ§ÿ⿠ ÿ§ÿ² ÿ⿠ÿ⿦ÿ§ÿŠÿ´ ÿ¾ÿ±ÿ˿ÿ⿠ÿ¯ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ ÿ¾ÿŠ.ÿ§ÿ⿠.ÿ¯ÿŠ ÿ¾ÿ´ÿÿ§ÿ¨â⿬ſ ÿ¯ÿ± ÿ§ÿ⿦.ÿ§ÿ³.ÿ¢ÿŠ.ÿ§ÿŠ~ 6\n\n-*ÿ˿/ÿŠÿ§ ÿÿ¹ÿ§ÿ⿿ ÿƿÿ±ÿ¯ÿ⿠ ÿ¨ÿ¹ÿ¶ÿŠ ÿ§ÿ² ÿ¯ÿ²ÿŠÿ⿠ÿ´ÿ¯ÿ±â⿬ſÿ⿡ÿ§ÿŠ ÿ§ÿ³.ÿ§ÿ³.ÿ³ÿŠ ÿ¯ÿ± ÿ§ÿ⿦.ÿ§ÿ³.ÿ¢ÿŠ.ÿ§ÿŠ~ 6 ÿ˿ ~7[fr]Permet de s�lectionner diff�rentes m�thodes \n\n-* pour assurer l''affichage des fichiers PNG transparents sous MSIE~6 \n\n-* et/ou activer certains s�lecteurs CSS dans MSIE~6 et~7.[it]Offre diversi metodi javasciprt per aggoiungere il supporto per \n-* immagini PNG trasparenti per  MSIE~6 \n-* e/o attivare alcuni selettori CSS per MSIE~6 e ~7.[pt_br]Permite selecionar m�todos diferentes\n\n-* para garantir a exibi�§�£o de arquivos PNG transparentes em MSIE~6 \n\n-* e/ou ativar certos seletores CSS em MSIE~6 et~7.[ru]ÐÐµÿÐºÐ¾Ð»ÿſÐºÐ¾ ÿ⿬Ð°Ð·Ð½ÿ⿹ÿ⿦ javascript Ð±Ð¸Ð±Ð»Ð¸Ð¾ÿ⿿ÐµÐº, ÐºÐ¾ÿ⿿Ð¾ÿ⿬ÿ⿹Ðµ Ð¾Ð±ÐµÿÐ¿Ðµÿ⿡Ð¸Ð²Ð°ÿŽÿ⿿:\n\n-* Ð¿Ð¾Ð´Ð´Ðµÿ⿬Ð¶Ðºÿƿ Ð¿ÿ⿬Ð¾Ð·ÿ⿬Ð°ÿ⿡Ð½Ð¾ÿÿ⿿Ð¸ PNG  Ð´Ð»ÿ MSIE~6 \n\n-* Ð¿Ð¾Ð´Ð´Ðµÿ⿬Ð¶Ðºÿƿ ÿ⿬ÿÐ´Ð° CSS ÿÐµÐ»ÐµÐºÿ⿿Ð¾ÿ⿬Ð¾Ð² Ð´Ð»ÿ MSIE~6 et~7.[sk]Umoÿ¾ÿ˿uje v�¡m zvoliÿ¥ si in� met�³dy:\n\n-* na zabezpeÿenie zobrazenia priehÿ¾adn�½ch s�ºborov PNG na MSIE~6,\n\n-* a/lebo aktivovaÿ¥ urÿit� voliÿe CSS v~MSIE~6 a~7.</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:2:{i:1;a:2:{s:3:"nom";s:27:"Kush M. (jquery.ifixpng.js)";s:3:"url";s:26:"http://jquery.khurshid.com";}i:2;a:2:{s:3:"nom";s:27:"Dean Edwards et al (IE7.js)";s:3:"url";s:32:"http://code.google.com/p/ie7-js/";}}', 'a:2:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}i:2;a:2:{s:3:"nom";s:3:"MIT";s:3:"url";s:46:"http://opensource.org/licenses/mit-license.php";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'msie_compat', '', 'oui', 'non', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '842b42ff628e0ec13b905217c40fdeb5'),
(401, 387, 'ORGANISEUR', 'prive/themes/spip/images/calendrier-32.png', '000.008.006', '1.1.1', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ£ÿ¯ÿ˿ÿ§ÿª ÿ¹ÿ⿦ÿ⿿ ÿªÿ­ÿ±ÿŠÿ±ÿŠ ÿ¬ÿ⿦ÿ§ÿ¹ÿŠ[de]Werkzeuge f�¼r eine Online-Redaktion[en]Collaborative editorial working tools[es]Herramientas de trabajo editorial en grupo[fa]ÿ§ÿ¨ÿ²ÿ§ÿ±ÿ⿡ÿ§ÿŠ ÿ¯ÿ±ÿ˿ÿ⿡ ÿ³ÿ±ÿ¯ÿ¨ÿŠÿ±ÿŠ[fr]Outils de travail �ditorial en groupe[it]Strumenti per il lavoro editoriale in gruppo[ru]Ðžÿ⿬Ð³Ð°Ð½Ð¸Ð·Ð°ÿ⿠Ð¸ÿ ÿÐ¾Ð²Ð¼Ðµÿÿ⿿Ð½Ð¾Ð¹ ÿ⿬Ð°Ð±Ð¾ÿ⿿ÿ⿹[sk]N�¡stroje na redakÿn�º pr�¡cu vÿ skupine</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:24:"Adam Shaw (FullCalendar)";s:3:"url";s:31:"http://arshaw.com/fullcalendar/";}}', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'organiseur', '', 'oui', 'oui', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '0602abe3e88bc967e99e2783831c4567'),
(402, 388, 'PETITIONS', 'prive/themes/spip/images/petition-32.png', '001.004.003', '1.1.6', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ§ÿ⿿ÿ¹ÿ±ÿ§ÿ¦ÿ¶ ÿÿŠ SPIP[de]Petitionen mit SPIP[en]Petitions in SPIP[es]Peticiones en SPIP[fa]ÿ·ÿ˿ÿ⿦ÿ§ÿ±ÿ⿡ÿ§ ÿ¯ÿ± ÿ§ÿ³ÿ¾ÿŠÿ¾[fr]P�titions dans SPIP[it]Petizioni di SPIP[pt_br]Peti�§�µes do SPIP[sk]Pet�­cie v SPIPe</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'petitions', '', 'oui', 'oui', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '4962c7ec835fbc436e6b616ded434213'),
(403, 389, 'PORTE_PLUME', 'images/porte-plume-32.png', '001.011.006', '', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ§ÿ⿿ÿ±ÿŠÿ´ÿ© ÿ⿡ÿŠ ÿ´ÿ±ÿŠÿ· ÿ£ÿ¯ÿ˿ÿ§ÿª ÿ⿦ÿ˿ÿ³ÿ¹ ÿ⿿ÿ⿠ÿ¸ÿ§ÿ⿦ SPIP ÿŠÿ³ÿªÿ®ÿ¯ÿ⿦ ÿ⿦ÿƿÿªÿ¨ÿ© ÿ¬ÿ§ÿÿ§ÿ³ÿƿÿ±ÿŠÿ¨ÿª [MarkItUp-&gt;http://markitup.jaysalvat.com/home/][de]Der Federhalter ist eine erweiterbare Werkzeugleiste f�¼r SPIP auf Grundlage der Javascript-Bibiliothek [MarkItUp->http://markitup.jaysalvat.com/home/][en]The Quill is a SPIP extensible toolbar which uses the [MarkItUp->http://markitup.jaysalvat.com/home/] javascript library.[fa]ÿ⿠ÿ˿ÿ¨ ÿ⿿ÿ⿿ÿ⿦ ÿŠÿƿ ÿ⿠ÿ˿ÿ§ÿ± ÿ§ÿ¨ÿ²ÿ§ÿ± ÿ⿿ÿ§ÿ¨ÿ⿿ ÿ¯ÿ³ÿªÿ±ÿ´ ÿ¨ÿ±ÿ§ÿŠ ÿ§ÿ³ÿ¾ÿŠÿ¾ ÿ§ÿ³ÿª ÿƿÿ⿡ ÿ¢ÿ±ÿ´ÿŠÿ˿ ÿ¬ÿ§ÿ˿ÿ§ ÿ§ÿ³ÿƿÿ±ÿŠÿ¾ÿª [MarkItUp->http://markitup.jaysalvat.com/home/] ÿ±ÿ§ ÿ⿦ÿ˿ÿ±ÿ¯ ÿ§ÿ³ÿªÿÿ§ÿ¯ÿ⿡ ÿ⿿ÿ±ÿ§ÿ± ÿ⿦ÿŠâ⿬ſÿ¯ÿ⿡ÿ¯.[fr]Porte plume est une barre d\'outil extensible pour SPIP qui utilise la librairie javascript [MarkItUp->http://markitup.jaysalvat.com/home/][it]Portapenne � una barra degli strumenti estensibile per SPIP che utilizza la libreria javascript [MarkItUp->http://markitup.jaysalvat.com/home/][ru]Porte plume - ÿ⿬Ð°ÿÿ˿Ð¸ÿ⿬ÐµÐ½Ð¸Ðµ Ð²Ð¾Ð·Ð¼Ð¾Ð¶Ð½Ð¾ÿÿ⿿ÐµÐ¹ ÿÿ⿿Ð°Ð½Ð´Ð°ÿ⿬ÿ⿿Ð½Ð¾Ð³Ð¾ ÿ⿿ÐµÐºÿÿ⿿Ð¾Ð²Ð¾Ð³Ð¾ ÿ⿬ÐµÐ´Ð°Ðºÿ⿿Ð¾ÿ⿬Ð° SPIP. Ð˿ÿÐ¿Ð¾Ð»ÿſÐ·ÿƿÐµÿ⿿ javascript Ð±Ð¸Ð±Ð»Ð¸Ð¾ÿ⿿ÐµÐºÿƿ  [MarkItUp->http://markitup.jaysalvat.com/home/].[sk]Porte plume je rozÿ¡�­riteÿ¾n�½ panel sÿ n�¡strojmi pre SPIP, ktor�½ vyuÿ¾�­va javascriptov�º kniÿ¾nicu [MarkItUp->http://markitup.jaysalvat.com/home/]</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:2:{i:1;a:2:{s:3:"nom";s:21:"Jay Salvat (MarkitUp)";s:3:"url";s:30:"http://markitup.jaysalvat.com/";}i:2;a:2:{s:3:"nom";s:18:"FamFamFam (Icones)";s:3:"url";s:25:"http://www.famfamfam.com/";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Porte-plume,3117', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'porte_plume', '', 'oui', 'non', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '0775a50be29bc5d5844e405c6fee2044'),
(397, 383, 'MEDIABOX', 'prive/themes/spip/images/mediabox-32.png', '000.008.001', '', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ§ÿÿªÿ±ÿ§ÿ¶ÿŠÿ§ÿ⿹ÿſ ÿŠÿªÿ⿦ ÿ¥ÿ¶ÿÿ§ÿ¡ ÿµÿ⿠ÿ¯ÿ˿ÿ⿿ ÿ§ÿ⿿ÿÿ±ÿ¬ÿ© ÿ¹ÿ⿿ÿ⿰ ÿƿÿ⿿ ÿ§ÿ⿿ÿ˿ÿµÿ⿿ÿ§ÿª ÿ§ÿ⿿ÿ⿰ ÿ§ÿ⿿ÿµÿ˿ÿ± (ÿ⿿ÿ⿡ÿ§ ÿ⿠ÿ˿ÿ¹ ÿ®ÿ§ÿµÿŠÿ© ÿŠÿµÿ mime/type ÿ§ÿ⿿ÿµÿ˿ÿ±ÿ©) ÿ¥ÿ¶ÿ§ÿÿ© ÿ§ÿ⿿ÿ⿰ ÿ§ÿ⿿ÿ˿ÿµÿ⿿ÿ§ÿª ÿ§ÿ⿿ÿ⿦ÿ²ÿ˿ÿ¯ÿ© ÿ¨ÿ⿠ÿ⿦ÿ· &lt;code&gt;.mediabox&lt;/code&gt;.\n\n\n\nÿ⿦ÿ⿠ ÿ§ÿ⿿ÿ⿦ÿ⿦ÿƿÿ⿠ ÿ¥ÿ¹ÿ¯ÿ§ÿ¯ ÿƿÿ⿿ ÿ˿ÿµÿ⿿ÿ© ÿ¹ÿ⿿ÿ⿰ ÿ­ÿ¯ÿ© ÿ⿦ÿ⿠ ÿ®ÿ⿿ÿ§ÿ⿿ ÿ£ÿ⿠ÿ⿦ÿ§ÿ· ÿ¥ÿ¶ÿ§ÿÿŠÿ©:\n\n-* ÿŠÿªÿŠÿ­ &lt;code&gt;boxIframe&lt;/code&gt;  ÿÿªÿ­ ÿ§ÿ⿿ÿ˿ÿµÿ⿿ÿ© ÿÿŠ ÿ¥ÿ·ÿ§ÿ± iframe\n\n-* ÿŠÿªÿŠÿ¬ &lt;code&gt;boxWidth-350px&lt;/code&gt; ÿªÿ­ÿ¯ÿŠÿ¯ ÿ¹ÿ±ÿ¶ ÿ£ÿ¥ÿ  ÿ⿠ÿ⿿ÿ·ÿ© ÿ⿿ÿ⿿ÿ¥ÿ·ÿ§ÿ±\n\n-* ÿŠÿªÿŠÿ­ &lt;code&gt;boxHeight-90pc&lt;/code&gt; ÿªÿ­ÿ¯ÿŠÿ¯ ÿ§ÿ±ÿªÿÿ§ÿ¹ ÿ©ÿ ÿª ÿ⿿ÿ⿿ÿ¥ÿ·ÿ§ÿ±\n\n\n\nÿ˿ÿªÿªÿŠÿ­ ÿ⿿ÿ˿ÿ­ÿ© ÿªÿ­ÿƿÿ⿦ ÿªÿ¹ÿ¯ÿŠÿ⿿ ÿ§ÿ⿿ÿ¥ÿ¹ÿ¯ÿ§ÿ¯ÿ§ÿª ÿ§ÿ⿿ÿ¹ÿ§ÿ⿦ÿ© ÿ­ÿ³ÿ¨ ÿ§ÿ⿿ÿ±ÿºÿ¨ÿ© ÿƿÿ⿦ÿ§ ÿªÿªÿŠÿ­ ÿ§ÿ®ÿªÿŠÿ§ÿ± ÿ´ÿƿÿ⿿ ÿ§ÿ⿿ÿµÿ⿠ÿ¯ÿ˿ÿ⿿ ÿ⿦ÿ⿠ ÿ¨ÿŠÿ⿠ ÿ§ÿ⿿ÿ£ÿ´ÿƿÿ§ÿ⿿ ÿ§ÿ⿿ÿ⿦ÿªÿ§ÿ­ÿ©.\n\nÿŠÿ¹ÿ⿦ÿ⿿ ÿ⿡ÿ°ÿ§ ÿ§ÿ⿿ÿ⿦ÿ⿿ÿ­ÿ⿿ ÿÿŠ ÿ§ÿ⿿ÿµÿÿ­ÿ§ÿª ÿ§ÿ⿿ÿ⿠ÿ⿦ÿ˿ÿ°ÿ¬ÿŠÿ© ÿ§ÿ⿿ÿªÿŠ ÿªÿ­ÿªÿ˿ÿŠ ÿ¹ÿ⿿ÿ⿰ ÿ¹ÿ⿿ÿ§ÿ⿦ÿ© <code>#INSERT_HEAD</code>[de]Alle Links zu Bildern (mit einem mime/type f�¼r Bilder) sowie Links mit der Klasse <code>.mediabox</code>werden in einer Multimedia-Box angezeigt.\n\nJeder Link kann einzeln um folgende Klassen erg�¤nzt werden:\n\n-* <code>boxIframe</code> �¶ffnet den Link als iFrame in einer Box;\n\n-* <code>boxWidth-350px</code>�¶ffnet eine 350px breite Box;\n\n-* <code>boxHeight-90pc</code> �¶ffnet eine 90% hohe Box;\n\nSie k�¶nnen die Voreinstellungen in einem Konfigurationsdialog einstellen, und das Standarddesign der Boxen ausw�¤hlen.\n\nDieses Plugin ben�¶tigt den Tag <code>#INSERT_HEAD</code> im Kopf des Skeletts.[en]By default, all links to pictures (with a type attribute describing the mime/type of the picture) and\nlinks with the CSS class <code>.mediabox</code> are enriched by multimedia box.\n\nYou can configure each link on a case by case basis with additional classes:\n-* <code>boxIframe</code> enables to open link in iframe box; \n-* <code>boxWidth-350px</code> enables to specify a width of 350px for the box;\n-* <code>boxHeight-90pc</code> enables to specify a height of 90% for the box\n\nA configuration panel lets you edit the general settings to your liking, and the appearance of the box among the available skins.\n\nThis plugin works on skeletons which have the <code>#INSERT_HEAD</code> tag.[es]Por defecto, todos los enlaces definidos sobre im�¡genes (con un atributo tipo que describa el mime/type de la imafen) as�­ como los enlaces con la clase <code>.mediabox</code> son enriquecidos por la caja multimedia.\n	\nEs posible configurar cada enlace, caso por caso, con clases adicionales:\n\n-* <code>boxIframe</code> permite abrir el enlace en una caja en un iframe ;\n\n-* <code>boxWidth-350px</code> permite definir un ancho de 350px para la caja;\n\n-* <code>boxHeight-90pc</code> perite definir un alto de 90% para la caja.\n\nUn panel de configuraci�³n permite modificar tanto las especificaciones generales como el aspecto de la caja, a partir de un conjunto de opciones disponibles. \n	\nEste plugin funciona en los esqueletos que incluyen la baliza <code>#INSERT_HEAD</code>[fa]Par d�faut, tous les liens vers des images (avec un attribut type d�crivant le mime/type de l''image) ainsi que les liens avec la classe <code>.mediabox</code> sont enrichis par la bo�®te multim�dia.\n	\n	Il est possible de configurer chaque lien au cas par cas avec des classes suppl�mentaires :\n\n-* <code>boxIframe</code> permet de demander �  ouvrir le lien dans une bo�®te en iframe ;\n\n-* <code>boxWidth-350px</code> permet de sp�cifier une largeur de 350px pour la bo�®te ;\n\n-* <code>boxHeight-90pc</code> permet de sp�cifier une hauteur de 90% pour la bo�®te.\n\n	Un panneau de configuration vous permet de modifier les r�glages g�n�raux �  votre convenance, ainsi que l''aspect de la bo�®te parmi les habillages disponibles.\n	\n	Ce plugin fonctionne sur les squelettes disposant de la balise <code>#INSERT_HEAD</code>[fr]Par d�faut, tous les liens vers des images (avec un attribut type d�crivant le mime/type de l''image) ainsi que les liens avec la classe <code>.mediabox</code> sont enrichis par la bo�®te multim�dia.\n	\n	Il est possible de configurer chaque lien au cas par cas avec des classes suppl�mentaires :\n\n-* <code>boxIframe</code> permet de demander �  ouvrir le lien dans une bo�®te en iframe ;\n\n-* <code>boxWidth-350px</code> permet de sp�cifier une largeur de 350px pour la bo�®te ;\n\n-* <code>boxHeight-90pc</code> permet de sp�cifier une hauteur de 90% pour la bo�®te.\n\n	Un panneau de configuration vous permet de modifier les r�glages g�n�raux �  votre convenance, ainsi que l''aspect de la bo�®te parmi les habillages disponibles.\n	\n	Ce plugin fonctionne sur les squelettes disposant de la balise <code>#INSERT_HEAD</code>[it]Per impostazione predefinita, tutti i collegamenti alle immagini (con un attributo che descrive il tipo mime/tipo di foto) e\ncollegamenti con il <code> classe CSS. mediabox </ code> sono arricchite da box multimediale.\n	\n�˿ possibile configurare ogni collegamento in una caso per caso con le classi aggiuntive:\n- * <code> BoxIframe </ code> permette di aprire il collegamento nella casella iframe;\n- * <code> Boxwidth-350 pixel </ code> consente di specificare una larghezza di 350 pixel per il box;\n- * <code> BoxHeight-90pc </ code> consente di specificare una altezza di 90% per il box\n\nUn pannello di configurazione permette di modificare le impostazioni generali a proprio piacimento, e l''aspetto tra le skin disponibili.\n\nQuesto plugin funziona su scheletri che hanno la <code> INSERT_HEAD # </ code> tag.[ru]Par d�faut, tous les liens vers des images (avec un attribut type d�crivant le mime/type de l''image) ainsi que les liens avec la classe <code>.mediabox</code> sont enrichis par la bo�®te multim�dia.\n	\n	Il est possible de configurer chaque lien au cas par cas avec des classes suppl�mentaires :\n\n-* <code>boxIframe</code> permet de demander �  ouvrir le lien dans une bo�®te en iframe ;\n\n-* <code>boxWidth-350px</code> permet de sp�cifier une largeur de 350px pour la bo�®te ;\n\n-* <code>boxHeight-90pc</code> permet de sp�cifier une hauteur de 90% pour la bo�®te.\n\n	Un panneau de configuration vous permet de modifier les r�glages g�n�raux �  votre convenance, ainsi que l''aspect de la bo�®te parmi les habillages disponibles.\n	\n	Ce plugin fonctionne sur les squelettes disposant de la balise <code>#INSERT_HEAD</code>[sk]Podÿ¾a predvolen�½ch nastaven�­ vÿ¡etky odkazy kÿ obr�¡zkom (sÿ typom vÿ parametre, ktor�½ uv�¡dza mime/typ obr�¡zka) aÿ odkazy vÿ triede <code>.mediabox</code> obohacuje multimedi�¡lny box.\n\nKaÿ¾d�½ odkaz m�´ÿ¾ete osobitne nastaviÿ¥ pomocou doplnkov�½ch tried:\n\n-* <code>boxIframe</code> umoÿ¾ÿ˿uje otv�¡raÿ¥ odkaz v r�¡me iframe,\n\n-* <code>boxWidth-350px</code> umoÿ¾ÿ˿uje definovaÿ¥ ÿ¡�­rku poÿ¾a 350px,\n\n-* <code>boxHeight-90pc</code> umoÿ¾ÿ˿uje zadaÿ¥ v�½ÿ¡ku poÿ¾a 90%.\n\nOvl�¡dac�­ panel v�¡m umoÿ¾ÿ˿uje vÿ¡eobecn� nastavenia podÿ¾a vaÿ¡ich ÿ¾elan�­ vybraÿ¥ dizajn boxu zÿ dostupn�½ch vzhÿ¾adov.\n\nTento z�¡suvn�½ modul spolupracuje soÿ ÿ¡abl�³nami, ktor� obsahuj�º tag <code>#INSERT_HEAD</code></multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:12:"ColorPowered";s:3:"url";s:33:"http://colorpowered.com/colorbox/";}}', '', '', 'http://www.spip-contrib.net/MediaBox', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'mediabox', '', 'oui', 'non', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', 'd5cb3a5f897776b4a4983560f62ecbd5');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(393, 379, 'DUMP', 'prive/themes/spip/images/base-backup-32.png', '001.006.007', '', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ⿠ÿ³ÿ® ÿ§ÿ­ÿªÿŠÿ§ÿ·ÿŠ ÿ⿿ÿ⿿ÿ§ÿ¹ÿ¯ÿ© ÿ§ÿ⿿ÿ¨ÿŠÿ§ÿ⿠ÿ§ÿª ÿ¨ÿªÿ⿠ÿ³ÿŠÿ⿿ SQLite ÿ˿ÿ§ÿ³ÿªÿ±ÿ¬ÿ§ÿ¹ÿ⿡ÿ§[de]Sicherung und Wiederherstellung der Datenbank im SQLite-Format[en]Backup and restoration of the database in SQLite format[es]Copia de seguridad en SQLite y recuperaci�³n[fa]ÿ¨ÿƿâ⿬ſÿ¢ÿ¾ ÿ˿ ÿ°ÿ®ÿŠÿ±ÿ⿡â⿬ſÿ³ÿ§ÿ²ÿŠ ÿ¾ÿ§ÿŠÿ¯ÿ§ÿ⿡ ÿ¯ÿ§ÿ¯ÿ⿡â⿬ſÿ⿡ÿ§ ÿ¯ÿ± ÿÿ±ÿ⿦ÿª ÿ§ÿ³.ÿƿÿŠÿ˿.ÿ⿿ÿ§ÿŠÿª[fr]Sauvegarde de la base en SQLite et restauration[it]Backup e ripristino della base dati SQLite[pt_br]C�³pia de seguran�§a da base em SQLite e restauro[ru]Ð ÐµÐ·Ðµÿ⿬Ð²Ð½Ð°ÿ ÐºÐ¾Ð¿Ð¸ÿ Ð² SQLite[sk]Z�¡loha datab�¡zy v SQLite a jej obnovenie</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'dump', '', 'oui', 'non', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', 'e17a82653cbc340e44b98e58eaf269ad'),
(394, 380, 'IMAGES', 'images/image_filtre-32.png', '001.001.001', '', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ⿦ÿ±ÿ´ÿ­ÿ§ÿª ÿ⿦ÿ¹ÿ§ÿ⿿ÿ¬ÿ© ÿ§ÿ⿿ÿµÿ˿ÿ± ÿ˿ÿ§ÿ⿿ÿ£ÿ⿿ÿ˿ÿ§ÿ⿠[de]Bild- und Farbfilter[en]Images processing and colors filters[fa]ÿÿŠÿ⿿ÿªÿ±â⿬ſÿ⿡ÿ§ÿŠ ÿ¾ÿ±ÿ¯ÿ§ÿ²ÿ´ ÿªÿµÿ˿ÿŠÿ±â⿬ſÿ⿡ÿ§ ÿ˿ ÿ±ÿ⿠ÿ¯â⿬ſÿ⿡ÿ§[fr]Filtres de transformation d\'images et de couleurs[it]Filtri di trasformazione delle immagini e dei colori[pt_br]Filtros de transforma�§�£o de imagens e de cores[ru]ÐÐ°Ð±Ð¾ÿ⿬ ÿ⿿Ð¸Ð»ÿſÿ⿿ÿ⿬Ð¾Ð² Ð¿Ð¾ ÿ⿬Ð°Ð±Ð¾ÿ⿿Ðµ ÿ Ð¸Ð·Ð¾Ð±ÿ⿬Ð°Ð¶ÐµÐ½Ð¸ÿÐ¼Ð¸[sk]Filtre na transform�¡ciu obr�¡zkov a farieb</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'filtres_images', '', 'oui', 'non', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '26a3809182b33857c4c3835a2748c2c1'),
(395, 381, 'FORUM', 'prive/themes/spip/images/forum-32.png', '001.008.016', '1.2.1', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ⿦ÿ⿠ÿªÿ¯ÿ⿰ SPIP (ÿ§ÿ⿿ÿ®ÿ§ÿµ ÿ˿ÿ§ÿ⿿ÿ¹ÿ⿦ÿ˿ÿ⿦ÿŠ)[de]Foren in SPIP (Redaktionsbereich und �¶ffentliche Website)[en]SPIP''s forum (private and public)[es]Foros de SPIP (privado y p�ºblico)[fa]ÿ³ÿ®ÿ⿠ÿ¯ÿ§ÿ⿡ ÿ§ÿ³ÿ¾ÿŠÿ¾ (ÿ®ÿµÿ˿ÿµÿŠ ÿ⿡ÿ⿦ÿ¯ÿ§ÿ⿠ÿŠ)ÿŸ[fr]Forum de SPIP (priv� et public)[it]Forum di SPIP (privati e pubblici)[pt_br]F�³rum do SPIP (privado e p�ºblico)[ru]Ð¤Ð¾ÿ⿬ÿƿÐ¼ÿ⿹ Ð¸ ÐºÐ¾Ð¼Ð¼ÐµÐ½ÿ⿿Ð°ÿ⿬Ð¸Ð¸ Ð² SPIP[sk]Diskusn� f�³ra SPIPu (s�ºkromn� a verejn�)</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'forum', '', 'oui', 'oui', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '3486174a22acd1f09029b722dd1e85ee'),
(396, 382, 'JQUERYUI', 'images/jqueryui-128.png', '001.008.021', '', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿŠÿ«ÿ¨ÿª ÿ⿡ÿ°ÿ§ ÿ§ÿ⿿ÿ⿦ÿ⿿ÿ­ÿ⿿ ÿ⿦ÿƿÿªÿ¨ÿ© jQuery UI ÿÿŠ SPIP ÿ⿦ÿ⿦ÿ§ ÿŠÿªÿŠÿ­ ÿ¥ÿ⿠ÿ´ÿ§ÿ¡ ÿ⿦ÿƿÿ˿ÿ⿠ÿ§ÿª ÿ±ÿ³ÿ˿ÿ⿦ÿŠÿ© ÿ¯ÿŠÿ⿠ÿ§ÿ⿦ÿŠÿƿÿŠÿ©: ÿ£ÿ⿿ÿ³ÿ⿠ÿ© ÿµÿÿ­ÿ§ÿªÿſ ÿ§ÿ⿿ÿ³ÿ­ÿ¨ ÿ˿ÿ§ÿ⿿ÿ±ÿ⿦ÿŠÿſ ÿ´ÿ±ÿŠÿ· ÿ³ÿŠÿ± ÿªÿ⿠ÿÿŠÿ° ÿ§ÿ⿿ÿ¹ÿ⿦ÿ⿿ÿŠÿ§ÿª ÿ§ÿ⿿ÿ®.\nÿ˿ÿªÿ⿠ÿ⿿ÿ³ÿ⿦ ÿ˿ÿ¸ÿ§ÿ¦ÿ ÿ⿡ÿ°ÿ⿡ ÿ§ÿ⿿ÿ⿦ÿƿÿªÿ¨ÿ© ÿ§ÿ⿿ÿ⿰ ÿ«ÿ⿿ÿ§ÿ« ÿÿ¦ÿ§ÿª:\n\n-* {{ÿ§ÿ⿿ÿªÿÿ§ÿ¹ÿ⿿ÿŠÿ©}}: ÿªÿªÿŠÿ­ ÿ¥ÿ¶ÿÿ§ÿ¡ ÿ®ÿµÿ§ÿ¦ÿµ ÿ´ÿŠÿ⿿ÿ© ÿ¹ÿ⿿ÿ⿰ ÿ¹ÿ⿠ÿ§ÿµÿ± HTML ÿƿÿ¥ÿ⿦ÿƿÿ§ÿ⿠ ÿ⿦ÿ³ÿƿÿ⿡ÿ§ ÿ˿ÿ⿠ÿ⿿ÿ⿿ÿ⿡ÿ§ ÿ⿦ÿ⿠ ÿ⿦ÿƿÿ§ÿ⿠ ÿ§ÿ⿿ÿ⿰ ÿ¢ÿ®ÿ± ÿ¨ÿ˿ÿ§ÿ³ÿ·ÿ© ÿ§ÿ⿿ÿÿ£ÿ±ÿ© (ÿ§ÿ⿿ÿ³ÿ­ÿ¨ ÿ˿ÿ§ÿ⿿ÿ±ÿ⿦ÿŠ) ÿ§ÿ˿ ÿªÿºÿŠÿŠÿ± ÿ£ÿ­ÿ¬ÿ§ÿ⿦ÿ⿡ÿ§ ÿƿÿ§ÿ⿿ÿ¥ÿ·ÿ§ÿ±ÿ§ÿª ÿ˿ÿ§ÿ⿿ÿ⿠ÿ˿ÿ§ÿÿ° ÿ§ÿ˿ ÿ­ÿªÿ⿰ ÿ§ÿ®ÿªÿŠÿ§ÿ±ÿ⿡ÿ§ ÿƿÿ£ÿŠÿ⿿ÿ˿ÿ⿠ÿ§ÿª ÿªÿ˿ÿ¶ÿ¹ ÿ¹ÿ⿿ÿ⿰ ÿ³ÿ·ÿ­ ÿ⿦ÿƿÿªÿ¨ ÿ⿠ÿ¸ÿ§ÿ⿦ ÿ§ÿ⿿ÿªÿ´ÿºÿŠÿ⿿.\n-* {{ÿ§ÿ⿿ÿ£ÿ¯ÿ˿ÿ§ÿª}}: ÿ§ÿ⿠ÿ⿡ÿ§ ÿ¹ÿ⿠ÿ§ÿµÿ± ÿ⿿ÿ§ÿ¦ÿ⿦ÿ© ÿ¨ÿ⿠ÿÿ³ÿ⿡ÿ§ ÿªÿ⿿ÿ¯ÿ⿦ ÿ˿ÿ¸ÿ§ÿ¦ÿ ÿ⿦ÿªÿ·ÿ˿ÿ±ÿ© ÿ⿦ÿ«ÿ⿿ ÿ⿦ÿ⿠ÿªÿ⿿ÿŠ ÿ§ÿ⿿ÿªÿ˿ÿ§ÿ±ÿŠÿ® (DatePicker) ÿ§ÿ⿿ÿ°ÿŠ ÿŠÿ¹ÿ±ÿ¶ ÿ±ÿ˿ÿ²ÿ⿠ÿ§ÿ⿦ÿ© ÿ⿿ÿ§ÿ®ÿªÿŠÿ§ÿ± ÿªÿ§ÿ±ÿŠÿ® ÿ⿦ÿ⿠ÿ⿡ÿ§.\n-* {{ÿ§ÿ⿿ÿ⿦ÿ¤ÿ«ÿ±ÿ§ÿª}}: ÿªÿ£ÿªÿŠ ÿ⿿ÿ¥ÿºÿ⿠ÿ§ÿ¡ ÿ§ÿ⿿ÿ⿦ÿ¤ÿ«ÿ±ÿ§ÿª ÿ§ÿ⿿ÿ⿿ÿŠÿ§ÿ³ÿŠÿ© ÿ§ÿ⿿ÿªÿŠ ÿŠÿ˿ÿÿ±ÿ⿡ÿ§ jQuery (ÿƿÿ§ÿ⿿ÿªÿ⿿ÿ§ÿ´ÿŠ ÿ˿ÿ§ÿ⿿ÿ¥ÿ²ÿ§ÿ­ÿ© ÿ§ÿ⿿ÿ⿰ ÿ§ÿ⿿ÿ£ÿ¹ÿ⿿ÿ⿰ ÿ§ÿ˿ ÿ§ÿ⿿ÿ£ÿ³ÿÿ⿿...). ÿ˿ÿ¨ÿÿ¶ÿ⿿ jQuery UIÿſ ÿŠÿµÿ¨ÿ­ ÿ⿦ÿ⿠ ÿ§ÿ⿿ÿ⿦ÿ⿦ÿƿÿ⿠ ÿ⿦ÿ«ÿ⿿ÿ§ÿ⿹ ÿ¥ÿ¶ÿÿ§ÿ¡ ÿ§ÿ⿿ÿ­ÿ±ÿƿÿ© ÿ¹ÿ⿿ÿ⿰ ÿ®ÿµÿ§ÿ¦ÿµ ÿ§ÿ⿿ÿ£ÿ⿠ÿ⿦ÿ§ÿ· (CSS) ÿ⿦ÿ«ÿ⿿ ÿ⿿ÿ˿ÿ⿠ ÿ§ÿ⿿ÿ®ÿ⿿ÿÿŠÿ© ÿ⿦ÿ⿠ ÿ®ÿ⿿ÿ§ÿ⿿ ÿ®ÿ§ÿµÿŠÿ© ().animate ÿ§ÿ˿ ÿ¥ÿ¶ÿ§ÿÿ© ÿ⿦ÿ¤ÿ«ÿ±ÿ§ÿª ÿ§ÿ⿠ÿªÿ⿿ÿ§ÿ⿿ ÿÿŠ ÿ®ÿµÿ§ÿ¦ÿµ addClass ÿ˿removeClass...[de]Dieses Plugin implementiert die Bibliothel jQuery UI in SPIP und erm�¶glicht so die Nutzung dynamischer Grafiken f�¼r Reiter, Ziehen und Ablegen, Fortschrittsbalken, u.v.m.\n	Die Bibliothek enth�¤lt drei Kategorien von Funktionen:\n\n	-* {{Interaktionen}} erm�¶glichen HTML-Elementen mit zus�¤tzlichen Eigenschaften auszustatten, etwa dem Verschieben mit der Maus, der Gr�¶�Ÿen�¤nderung von Fenstern oder einer Auswahl wie bei Desktop-Icons.\n	-* {{Widgets}} sind gebrauchsfertige komplexe Objekte wie z.B. der DatePicker, welcher einen Kalender zur Datumsauswahl einblendet.\n	-* {{Effekte}} erweitern die Standardeffekte (fadeIn, slideUp...) von jQuery. Mit jQuery UI kann z.B. die Eigenschaft CSS background-color mit .animate() dynamisiert werden, oder �ſberg�¤nge bei addClass/removeClass eingef�¼gt werden.[en]This plugin implements the jQuery UI library in SPIP allowing the creation of dynamic graphical components: tabs, drag & drop, progress bars...\n\nThe features of this library are divided into three categories:\n-* {{The interactions}}. They can provide very interesting properties to HTML elements, such as being able to be grabbed and moved with the mouse (drag & drop), to be resized as a window, or to be selected as icons on the desktop of your OS.\n-* {{The Widgets}}. They are "turnkey" objects offering high-level features such as DatePicker for example, which displays a calendar to select a date.\n-* {{The effects}}. They enrich the effects offered by default by jQuery (fadeIn, slideUp...). Thanks to jQuery UI, it''s possible for example to animate the CSS property background-color with .animate() or to add transitions for the actions addClass/removeClass...[fr]Ce plugin impl�mente dans SPIP la librairie compl�mentaire jQuery UI autorisant la cr�ation de composants graphiques dynamiques : onglets, drag & drop, barres de progression...\n	Les fonctionnalit�s de cette librairie se divisent en 3 cat�gories :\n\n	-* {{Les interactions}}. Elles permettent de donner des propri�t�s tr�s int�ressantes �  des �l�ments HTML, comme le fait de pouvoir �ªtre attrap� et d�plac� avec la souris (drag & drop), d''�tre redimensionn� comme une fen�ªtre, ou encore d''�tre s�lectionn� comme des ic�nes sur le bureau de votre OS.\n	-* {{Les Widgets}}. Ce sont des objets ÿ« cl� en main ÿ» qui proposent des fonctionnalit�s de haut niveau comme le DatePicker par exemple, qui affiche un calendrier permettant de s�lectionner une date.\n    -* {{Les effects}}. Ils enrichissement les effets par d�faut propos�s par jQuery (fadeIn, slideUp...). Gr�¢ce �  jQuery UI, il est par exemple possible d\'animer la propri�t� CSS background-color avec .animate() ou encore d\'ajouter des transitions lors des addClass/removeClass...[it]Questo plugin implementa la libreria jQuery UI all''interno di SPIP consentendo la creazione di componenti grafiche dinamiche: tab, drag & drop, barre di progresso ...\n\nLe funzionalit�  di questa libreria sono divise in tre categorie:\n\n-* {{Le interazioni}}. Queste aggiungono interessanti propriet�  agli elementi HTML, come la possibilit�  di essere prese e trascinate con il mouse (drag & drop), di essere ridimensionate come una finestra, oppure di essere selezionate come le icone del desktop del vostro sistema operativo.\n-* {{I Widgets}}. Questi sono oggetti che offrono caratteristiche di alto livello come il DatePicker per esempio, che mostra un calendario per selezionare le date.\n-* {{Gli Effetti}}. Questi arrichiscono gli effetti gi�  offerti da jQuery (fadeIn, slideUp). Grazie a jQuery UI, � possibile per esempio animare la propriety CSS background-color con .animate() oppure aggiungere una transizione per l''azione addClass/removeClass...[sk]Tento z�¡suvn�½ modul do SPIPu zav�¡dza doplnkov�º kniÿ¾nicu  jQuery UI umoÿ¾ÿ˿uj�ºcu vytv�¡ranie dynamick�½ch grafick�½ch prvkov: tabul�¡tory, drag & drop, grafy zobrazuj�ºce postup priÿ dokonÿen�­ nieÿoho atÿ.\n	Funkcie tejto kniÿ¾nice sa rozdeÿ¾uj�º do 3 kateg�³ri�­:\n\n	-* {{Interakcie:}} d�¡vaj�º vaÿ¡im HTML objektom zauj�­mav� vlastnosti, napr�­klad m�´ÿ¾ete na objekty klikn�ºÿ¥ myÿ¡ou, aÿ tak ich pres�ºvaÿ¥ (drag&drop), d�¡ sa meniÿ¥ ich veÿ¾kosÿ¥ tak ako veÿ¾kosÿ¥ okna, alebo si ich m�´ÿ¾ete zvoliÿ¥ ako ikony na pracovn�º plochu svojho operaÿn�ho syst�mu.\n	-* {{Widgety:}} to s�º objekty sÿ "prep�­naÿmi", ktor� pon�ºkaj�º funkcie vysokej �ºrovne, ako napr�­klad DatePicker, ktor�½ zobraz�­ kalend�¡r umoÿ¾ÿ˿uj�ºci zadanie d�¡tumu.\n    -* {{Efekty:}} obohacuj�º predvolen� efekty, ktor� pon�ºka jQuery (fadeIn, slideUp...). Napr�­klad vÿaka jQuery UI je moÿ¾n� doplniÿ¥ vlastnosÿ¥ CSS background-color oÿ .animate() alebo pridaÿ¥ prechody kÿ addClass/removeClass, atÿ.</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:14:"jQuery UI Team";s:3:"url";s:25:"http://jqueryui.com/about";}}', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'jquery_ui', '', 'oui', 'non', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '269696a02527dfe2beb7b869b06c68db'),
(392, 378, 'COMPRESSEUR', 'images/compresseur-32.png', '001.006.007', '', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ¶ÿºÿ· ÿ£ÿ˿ÿ±ÿ§ÿ⿿ ÿ§ÿ⿿ÿ£ÿ⿠ÿ⿦ÿ§ÿ· ÿ˿ÿ±ÿ⿦ÿ˿ÿ² ÿ¬ÿ§ÿÿ§ÿ³ÿƿÿ±ÿŠÿ¨ÿª ÿÿŠ ÿªÿ±ÿ˿ÿŠÿ³ÿ© ÿ§ÿ⿿ÿµÿÿ­ÿ§ÿª ÿÿŠ <code>ecrire/</code> ÿ˿/ÿ§ÿ˿ ÿ§ÿ⿿ÿ⿦ÿ˿ÿ⿿ÿ¹ ÿ§ÿ⿿ÿ¹ÿ⿦ÿ˿ÿ⿦ÿŠ[de]Kompression von CSS und Javascript-Code im Kopf der Seiten unter <code>ecrire/</code> und/oder auf der �¶ffentlichen Website[en]Compression of css and javascript in the header of the HTML pages of <code>ecrire/</code> and/or of the public site[es]Compresi�³n de css y javascript en los encabezados de las p�¡ginas HTML de <code>ecrire/</code> y/o del sitio p�ºblico[fa]ÿ˿/ÿŠÿ§ ÿ³ÿ§ÿŠÿª ÿ⿡ÿ⿦ÿ¯ÿ§ÿ⿠ÿŠ <code>ecrire/</code> ÿÿ´ÿ±ÿ¯ÿ⿡â⿬ſÿ³ÿ§ÿ²ÿŠ ÿ³ÿŠ.ÿ§ÿ³.ÿ§ÿ³â⿬ſÿ⿡ÿ§ ÿ˿ ÿ¬ÿ§ÿ˿ÿ§ ÿ§ÿ³ÿƿÿ±ÿŠÿ¾ÿª ÿ¯ÿ± ÿ³ÿ±ÿµÿÿ­ÿ⿡â⿬ſÿŠ ÿµÿÿ­ÿ§ÿª ÿ§ÿ⿠.ÿªÿŠ.ÿ§ÿ⿦.ÿ§ÿ⿿â⿬ſ[fr]Compression des css et javascript dans l''en-t�ªte des pages html de <code>ecrire/</code> et/ou du site public[it]Compressione di CSS e javascript \nnell''intestazione delle pagine html di <code>ecrire/</code> e/o del sito pubblico pubblico.[pt_br]Compress�£o dos css e javascript nos cabe�§alhos das p�¡ginas html de <code>ecrire/</code> e/ou do site p�ºblico[ru]Ð¡Ð¶Ð¸Ð¼Ð°Ðµÿ⿿ css Ð¸ javascript ÿ⿿Ð°Ð¹Ð»ÿ⿹ Ð´Ð»ÿ ÿƿÐ¼ÐµÐ½ÿſÿ˿ÐµÐ½Ð¸ÿ Ð²ÿ⿬ÐµÐ¼ÐµÐ½Ð¸ Ð·Ð°Ð³ÿ⿬ÿƿÐ·ÐºÐ¸. Ð˿ÿÐ¿Ð¾Ð»ÿſÐ·ÿƿÐµÿ⿿ÿÿ ÐºÐ°Ðº Ð½Ð° Ð¾ÿÐ½Ð¾Ð²Ð½Ð¾Ð¼ ÿÐ°Ð¹ÿ⿿Ðµ, ÿ⿿Ð°Ðº Ð¸ Ð² ÐµÐ³Ð¾ Ð°Ð´Ð¼Ð¸Ð½Ð¸ÿÿ⿿ÿ⿬Ð°ÿ⿿Ð¾ÿ⿬ÿÐºÐ¾Ð¹ ÿ⿡Ð°ÿÿ⿿Ð¸ <code>ecrire/</code>[sk]Kompresia css a javascriptu v hlaviÿke html str�¡nok <code>ecrire/</code> a/lebo na verejne pr�­stupnej str�¡nke</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:11:"porte_plume";a:2:{s:3:"nom";s:11:"porte_plume";s:13:"compatibilite";s:8:"[1.6.3;[";}}}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'compresseur', '', 'oui', 'non', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', 'aa4d6910f020ccb2825486902d9a40dd'),
(390, 376, 'BREVES', 'prive/themes/spip/images/breve-32.png', '001.003.003', '1.0.0', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿ§ÿ⿿ÿ£ÿ®ÿ¨ÿ§ÿ± ÿ⿡ÿŠ ÿ⿦ÿ¹ÿ⿿ÿ˿ÿ⿦ÿ§ÿª ÿ⿿ÿµÿŠÿ±ÿ© ÿ¨ÿ¯ÿ˿ÿ⿠ ÿ⿦ÿ¤ÿ⿿ÿ.[de]Meldungen sind kurze Informationen, deren Autor nicht gespeichert wird.[en]News items are short informations, without authors.[es]Las breves son informaciones cortas sin autor.[fa]ÿ§ÿŠÿ⿠ ÿ®ÿ¨ÿ±ÿ⿡ÿ§ ÿ§ÿ·ÿ⿿ÿ§ÿ¹ÿ§ÿª ÿƿÿ˿ÿªÿ§ÿ⿡ ÿ˿ ÿ¨ÿ¯ÿ˿ÿ⿠ ÿ⿦ÿ¤ÿ⿿ÿ ÿ⿡ÿ³ÿªÿ⿠ÿ¯[fr]Les br�ves sont des informations courtes, sans auteur.[fr_tu]Les br�ves sont des informations courtes, sans auteur.[it]Le brevi sono piccole fonti di informazioni, senza autori.[pt_br]As notas s�£o informa�§�µes curtas, sem autor.[ru]ÐÐ¾Ð²Ð¾ÿÿ⿿ÿſ - ÿÿ⿿Ð¾ Ðºÿ⿬Ð°ÿ⿿ÐºÐ°ÿ ÿÿ⿿Ð°ÿ⿿ÿſÿ Ð±ÐµÐ· ÿƿÐºÐ°Ð·Ð°Ð½Ð¸ÿ Ð°Ð²ÿ⿿Ð¾ÿ⿬Ð°.[sk]Novinky s�º kr�¡tke inform�¡cie bez autora.</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:4:"mots";a:1:{s:3:"nom";s:4:"mots";}}}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'breves', '', 'oui', 'oui', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '77a0641877a03a8b173c7ee1fcc18846'),
(391, 377, 'COMPAGNON', 'prive/themes/spip/images/compagnon-32.png', '001.004.000', '1.0.0', '[3.0.0;3.0.*]', '3.0', '<multi>[ar]ÿŠÿ⿿ÿ¯ÿ⿦ ÿ§ÿ⿿ÿ±ÿÿŠÿ⿿ ÿ⿦ÿ³ÿ§ÿ¹ÿ¯ÿ© ÿ⿿ÿ⿿ÿ⿦ÿ³ÿªÿ®ÿ¯ÿ⿦ÿŠÿ⿠\n		ÿ⿿ÿ¯ÿ⿰ ÿ£ÿ˿ÿ⿿ ÿ²ÿŠÿ§ÿ±ÿ© ÿ⿿ÿ⿡ÿ⿦ ÿ§ÿ⿿ÿ⿰ ÿ§ÿ⿿ÿ⿦ÿ¬ÿ§ÿ⿿ ÿ§ÿ⿿ÿ®ÿ§ÿµ ÿÿŠ SPIP.[de]Der Begleiter hilft neuen Benutzern bei ihren ersten Schritten im SPIP Redaktionssystem.[en]The companion provides assistance to users\nduring their first visit to the backoffice of SPIP.[es]El compa�±ero ofrece ayuda a los usuarios durante su primera visita al espacio privado de SPIP.[fa]ÿ⿡ÿ⿦ÿ±ÿ§ÿ⿡ ÿ¨ÿ⿡ ÿƿÿ§ÿ±ÿ¨ÿ±ÿ§ÿ⿠ ÿ¯ÿ± ÿ¬ÿ±ÿŠÿ§ÿ⿠ ÿ⿠ÿ®ÿ³ÿªÿŠÿ⿠ ÿ§ÿ²ÿ¯ÿŠÿ¯ÿ´ÿ§ÿ⿠ ÿ§ÿ² ÿ⿿ÿ³ÿ⿦ÿª ÿ®ÿµÿ˿ÿµÿŠ ÿ§ÿ³ÿ¾ÿŠÿ¾ ÿƿÿ⿦ÿƿ ÿ§ÿ±ÿ§ÿŠÿ⿡ ÿ⿦ÿŠâ⿬ſÿƿÿ⿠ÿ¯.[fr]Le compagnon offre une aide aux utilisateurs\n		lors de leur premi�re visite dans l''espace priv� de SPIP.[it]L''assistente fornisce una guida agli utenti durante la loro prima visita all''area riservata di SPIP.[pt_br]O Companheiro oferece ajuda aos usu�¡rios, na primeira visita �  �¡rea privada do SPIP.[ru]ÐŸÐ»Ð°Ð³Ð¸Ð½ Ð²ÿ⿹Ð²Ð¾Ð´Ð¸ÿ⿿ ÿÐ¿ÿ⿬Ð°Ð²Ðºÿƿ Ð¾ ÿÐ¸ÿÿ⿿ÐµÐ¼Ðµ ÿƿÐ¿ÿ⿬Ð°Ð²Ð»ÐµÐ½Ð¸ÿ Ð¿ÿ⿬Ð¸ Ð¿Ðµÿ⿬Ð²Ð¾Ð¼ Ð²ÿ⿦Ð¾Ð´Ðµ Ð¿Ð¾Ð»ÿſÐ·Ð¾Ð²Ð°ÿ⿿ÐµÐ»ÿ Ð² Ð°Ð´Ð¼Ð¸Ð½Ðºÿƿ.[sk]Compagnon pon�ºka pomoc pouÿ¾�­vateÿ¾om \n		pri ich prvej n�¡vÿ¡teve vÿ s�ºkromnej z�³ne SPIPu.</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:20:"http://magraine.net/";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:26:"Paul Viluda (Logo, icones)";s:3:"url";s:52:"http://www.cruzine.com/2010/10/06/animals-icon-sets/";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'compagnon', '', 'oui', 'oui', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '39836550d848335ac70aa4ac372d53fc'),
(24, 24, 'A2A', 'http://files.spip.org/spip-zone/a2a.png', '000.005.003', '0.4.0', '[3.0.0-dev;3.0.*]', '3.0', '<multi>\n[en]This plugin allows you to link items in a timely manner without having to use keywords of SPIP. It can be used to set up links such as "See also".\n[fr]Ce plugin permet de lier des articles de fa�§on ponctuelle sans avoir �  utiliser les mots-cl�s de SPIP. Il peut �ªtre utilis� pour mettre en place des liens de type ÿ« Lire aussi ÿ».\n[sk]Tento z�¡suvn�½ modul v�¡m umoÿ¾n�­ vytvoriÿ¥ odkazy na ÿl�¡nky vÿ chronologickom porad�­ bezÿ toho, aby ste museli pouÿ¾iÿ¥ kÿ¾�ºÿov� slov�¡ SPIPu. M�´ÿ¾ete ho vyuÿ¾�­vaÿ¥ na vytv�¡ranie odkazov typu "Pozri aj".\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:6:"GPL v3";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/a2a', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-31 00:00:09', '2012-08-31 00:00:09', 1, 'a2a.zip', 25216, '2012-08-31 00:00:10', '_plugins_/a2a/trunk', 'a:2:{s:3:"a2a";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:10:"paquet-a2a";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '01c52fd522f6f2d511dd730dc507e5a0'),
(25, 24, 'A2A', 'http://files.spip.org/spip-zone/a2a_1_0.png', '001.003.006', '0.9.0', '[3.0.0-dev;3.0.*]', '3.0', '<multi>\n[en]This plugin allows you to link items in a timely manner without having to use keywords of SPIP. It can be used to set up links such as "See also".\n[fr]Ce plugin permet de lier des articles de fa�§on ponctuelle sans avoir �  utiliser les mots-cl�s de SPIP. Il peut �ªtre utilis� pour mettre en place des liens de type ÿ« Lire aussi ÿ».\n[sk]Tento z�¡suvn�½ modul v�¡m umoÿ¾n�­ vytvoriÿ¥ odkazy na ÿl�¡nky vÿ chronologickom porad�­ bezÿ toho, aby ste museli pouÿ¾iÿ¥ kÿ¾�ºÿov� slov�¡ SPIPu. M�´ÿ¾ete ho vyuÿ¾�­vaÿ¥ na vytv�¡ranie odkazov typu "Pozri aj".\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:6:"GPL v3";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/a2a', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-01 21:00:23', '2012-09-01 21:00:23', 1, 'a2a_1_0.zip', 38525, '2012-09-01 21:00:24', '_plugins_/a2a/branches/type', 'a:2:{s:3:"a2a";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:10:"paquet-a2a";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '0f170dd5ebbc6cde769b68748c922d52'),
(490, 492, 'Z5', 'http://files.spip.org/spip-zone/zpip_html5_spip3.png', '002.000.000', '', '[3.0-dev;]', '3.0,3.1', '<multi>\n			[fr]Squelettes HTML5 par d�faut pour SPIP 3 + Z-core : modulaires et exemplaires.\n			[en]HTML5 default skeleton for SPIP 3 + Z-core : modular and flexible\n		</multi>', 'a:6:{i:0;a:3:{s:3:"nom";s:12:"Loiseau2nuit";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:5:"davux";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:13:"C�dric Morin";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:4;a:3:{s:3:"nom";s:11:"Romy Têtue";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:5;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Zpip-dist-en-HTML5', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{i:0;a:4:{s:2:"id";s:5:"Zcore";s:3:"nom";s:5:"Zcore";s:7:"version";s:8:"[2.0.0;]";s:13:"compatibilite";s:8:"[2.0.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-17 12:00:07', '2012-09-17 12:00:07', 1, 'zpip_html5_spip3.zip', 95207, '2012-09-17 12:00:08', '_plugins_/zpip_html5/branches/v2', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '871ab18b68427f50eeca4bc96613958c'),
(497, 496, 'AGENDA', 'http://files.spip.org/spip-zone/agenda_3_5.png', '003.009.003', '0.25.0', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en]Events agenda\n[fr]Agenda Ev�nementiel\n[sk]Kalend�r udalost�\n</multi>', 'a:4:{i:1;a:3:{s:3:"nom";s:12:"Cedric MORIN";s:3:"url";s:22:"http://www.yterium.net";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:31:"http://www.spip-contrib.net/b_b";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:14:"romy.tetue.net";s:3:"url";s:21:"http://romy.tetue.net";s:4:"mail";s:0:"";}i:4;a:3:{s:3:"nom";s:14:"Julien Tessier";s:3:"url";s:20:"http://www.cahri.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2006-2012";}', 'http://www.spip-contrib.net/article2858', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:14:"calendriermini";a:2:{s:3:"nom";s:14:"calendriermini";s:13:"compatibilite";s:8:"[2.0.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:8:"Fulltext";a:2:{s:3:"nom";s:8:"Fulltext";s:13:"compatibilite";s:6:"[0.2;[";}s:4:"mots";a:2:{s:3:"nom";s:4:"mots";s:13:"compatibilite";s:8:"[2.0.0;[";}}}}', '2012-09-27 10:00:11', '2012-09-27 10:00:11', 1, 'agenda_3_5.zip', 142967, '2012-09-27 10:00:12', '_plugins_/agenda/trunk', 'a:4:{s:6:"agenda";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"de";a:1:{i:0;a:2:{s:3:"nom";s:14:"Rainer M�ller";s:4:"lien";s:41:"http://trad.spip.net/auteur/rainer-muller";}}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:13:"paquet-agenda";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:16:"configureragenda";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}s:12:"migreragenda";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '02fa70806a7dd9b95a4c2ed7b8dfb161'),
(498, 34, 'ALBUMS', 'http://files.spip.org/spip-zone/albums_dev.png', '002.000.009', '0.0.3', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]<ins>ATTENTION, VERSION EN DEVELOPPEMENT !</ins>. \n	Veillez � consulter <a href=''http://contrib.spip.net/Albums-v2-DEV''>la documentation provisoire</a> avant installation ou mise � jour.\n\n	Ce plugin ajoute un nouvel objet ''album'' que l''on peut lier � n''importe quel autre objet �ditorial.\n	Les albums sont des conteneurs pour documents, ils vous permettent par exemple de s�parer\n	les documents d\'un articles en plusieurs groupes, de les ins�rer au fil du texte,\n	ou ind�pendamment dans vos squelettes.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:14:"romy.tetue.net";s:3:"url";s:21:"http://romy.tetue.net";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:14:"Charles Razack";s:3:"url";s:27:"http://razack.wordpress.com";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:40:"Tiheum (icone tir�e du th�me "Faenza")";s:3:"url";s:55:"http://tiheum.deviantart.com/art/Faenza-Icons-173323228";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:10:"GPL - 2011";s:3:"url";s:0:"";}}', '', 'http://contrib.spip.net/Albums-v2-DEV', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.21.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:15:"inserer_modeles";a:2:{s:3:"nom";s:15:"inserer_modeles";s:13:"compatibilite";s:8:"[1.0.0;]";}s:8:"mediabox";a:2:{s:3:"nom";s:8:"mediabox";s:13:"compatibilite";s:8:"[0.5.0;[";}}}}', '2012-09-25 20:00:02', '2012-09-25 20:00:02', 1, 'albums_dev.zip', 232464, '2012-09-25 20:00:02', '_plugins_/albums/trunk', 'a:1:{s:5:"album";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '17967ca783e5968cb4d9798d7b9c1904'),
(27, 26, 'ACCESRESTREINT', 'http://files.spip.org/spip-zone/accesrestreint_3_5.png', '003.006.002', '0.4.1', '[3.0.0;3.0.*]', '3.0', '<multi>\n[de]_ Jeder Bereich enth�¤lt Rubriken.\r\n_ Einzelnen Autoren k�¶nnen Zugangsrechte f�¼r Bereiche zugeordnet werden.\r\n_ ALle Standardschleifen (Abfragen) von SPIP werden �¼berladen, und um die �ſberpr�¼fung der Rechte des jeweiligen Sitebesuchers erg�¤nzt.\n[en]_ Each area contains sections.\r\n_ Authors can be associated with these areas to gain access to them.\r\n_ All SPIP''s loops are loaded with the necessary tools to filter the results according to the visitors'' access priviliges.\n[es]_ Cada zona contiene secciones.\r\n_ Los autores podr�¡n ser asociados a ciertas zonas restringidas para tener derechos de acceso a ellas.\r\n_ Todos los bucles nativos de SPIP quedan modificados para filtrar los resultados en funci�³n de los derechos del visitante.\n[fr]_ Chaque zone contient des rubriques.\r\n\r\n_ Les auteurs peuvent etre associ�s �  des zones pour avoir le droit d\'y acc�der.\r\n\r\n_ Toutes les boucles natives de SPIP sont surcharg�es pour en filtrer les r�sultats en fonction des droits du visiteur.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"Cedric Morin";s:3:"url";s:22:"http://www.yterium.net";s:4:"mail";s:27:"cedric.morin AT yterium.com";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2007-2008";}', 'http://www.spip-contrib.net/Acces-Restreint-3-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:06:55', '2012-07-26 13:06:55', 1, 'accesrestreint_3_5.zip', 86976, '2012-07-26 13:06:56', '_plugins_/acces_restreint/trunk', 'a:1:{s:14:"accesrestreint";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:16:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/ÿ¬ÿ˿ÿ±ÿ¬-ÿ⿿ÿ⿠ÿ¯ÿ⿿ÿÿª";}}s:3:"ast";a:1:{i:0;a:2:{s:3:"nom";s:5:"Xuacu";s:4:"lien";s:33:"http://trad.spip.net/auteur/xuacu";}}s:2:"br";a:0:{}s:2:"ca";a:0:{}s:2:"de";a:1:{i:0;a:2:{s:3:"nom";s:7:"klaus++";s:4:"lien";s:33:"http://trad.spip.net/auteur/klaus";}}s:2:"en";a:2:{i:0;a:2:{s:3:"nom";s:6:"sQuonk";s:4:"lien";s:34:"http://trad.spip.net/auteur/squonk";}i:1;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:5:"fr_tu";a:2:{i:0;a:2:{s:3:"nom";s:8:"beatnick";s:4:"lien";s:36:"http://trad.spip.net/auteur/beatnick";}i:1;a:2:{s:3:"nom";s:7:"orlammd";s:4:"lien";s:35:"http://trad.spip.net/auteur/orlammd";}}s:2:"gl";a:0:{}s:2:"nl";a:2:{i:0;a:2:{s:3:"nom";s:7:"mpossoz";s:4:"lien";s:35:"http://trad.spip.net/auteur/mpossoz";}i:1;a:2:{s:3:"nom";s:5:"Suske";s:4:"lien";s:33:"http://trad.spip.net/auteur/suske";}}s:5:"pt_br";a:1:{i:0;a:2:{s:3:"nom";s:13:"Ricardo Porto";s:4:"lien";s:41:"http://trad.spip.net/auteur/ricardo-porto";}}s:2:"ro";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}s:2:"tr";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '6899144889f623fae7621f2cd1859c64'),
(28, 27, 'ACS', 'http://files.spip.org/spip-zone/acs_v3.gif', '003.000.000', '', '[3.0.0;*]', '', '', 'a:1:{i:1;a:3:{s:3:"nom";s:13:"Daniel FAIVRE";s:3:"url";s:26:"http://acs.geomaticien.org";s:4:"mail";s:26:"contact AT geomaticien.com";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', 'a:1:{i:1;s:13:"Daniel FAIVRE";}', 'http://acs.geomaticien.org', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-05 07:00:03', '2012-08-05 07:00:03', 1, 'acs_v3.zip', 1007244, '2012-08-05 07:00:04', '_plugins_/acs/trunk', 'a:4:{s:10:"acs_ecrire";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}s:3:"acs";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}s:10:"acs_upload";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}s:13:"acs_variables";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '3bab35c79d6d31bfde823966750f7911'),
(29, 28, 'ACTIVITE_EDITORIALE', 'http://files.spip.org/spip-zone/activite_editoriale.png', '002.000.001', '0.1', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin a pour objectif de compl�ter les fonctionnalit�s de suivi de l''activit� �ditoriale de SPIP.\r\n\r\nSont d�j�  propos�s :\r\n-* l''ajout de deux champs aux rubriques pour indiquer un d�lai en jour au del�  duquel elle doivent �ªtre aliment�es, ainsi que les personnes �  pr�venir\r\n-* des alertes par e-mail selon ces deux param�tres\r\n-* un tableau de bord pr�sentant les m�ªmes informations\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:30:"St�phanie Caron de Clever Age";s:3:"url";s:26:"http://www.clever-age.com/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:33:"Ma�¯eul ROUQUETTE (am�lioration)";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Activite-editoriale', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"cextras";a:2:{s:3:"nom";s:7:"cextras";s:13:"compatibilite";s:8:"[3.0.6;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-05-23 17:01:27', '2012-05-23 17:01:27', 1, 'activite_editoriale.zip', 12221, '2012-05-23 17:01:28', '_plugins_/activite_editoriale/trunk', 'a:1:{s:19:"activite_editoriale";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c368d20b17d18ff8c1196e0fee8f0ee9'),
(30, 29, 'JABBERID', 'http://files.spip.org/spip-zone/adresse_jabber_spip_3_0.png', '002.000.000', '0.1.0', '[3.0.0-dev;3.0.*]', '3.0', '<multi>\n[fr]Permet de disposer d\'un champ "JID" (adresse Jabber) sur les auteurs de SPIP.\n\nJabber est un syst�me de messagerie instantan�e (�  la mani�re de MSN) et d�centralis� (comme les mails).\nIl est bas� sur le protocole ouvert XMPP.\n\nSi vous ne connaissez pas encore ce r�seau de messagerie, vous pourrez trouver des informations sur le\nsite francophone [JabberFR->http://jabberfr.org/].\n\nCe plugin fournit un champ suppl�mentaire dans le formulaire d''�dition des informations d\'un auteur. La\nbalise correspondante est <code>#JID</code> (appellation standard de l''identifiant Jabber).\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"davux";s:3:"url";s:20:"http://da.weeno.net/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Adresse-Jabber', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"cextras";a:2:{s:3:"nom";s:7:"cextras";s:13:"compatibilite";s:12:"[2.0.0-dev;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-11-25 21:00:02', '2011-11-25 21:00:02', 1, 'adresse_jabber_spip_3_0.zip', 7734, '2011-11-25 21:00:10', '_plugins_/adresse_jabber/trunk', 'a:1:{s:8:"jabberid";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"es";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '6a7e136f3aa23a7cffafcd6aed015d38'),
(31, 30, 'ADXMENU', 'http://files.spip.org/spip-zone/ADXmenu.png', '001.023.002', '', '[2.0;[', '2.0,2.1,3.0,3.1', '<multi>\n[en]{{Multilevel opening menu type ''fly-out'' in CSS/Javacript}}\n\nThe plugin adds the new tag <code>#ADXMENU{options}</code> and the "{{adxmenu.html}}" model for your SPIP skeletons, which brings up an elegant menu type ''{fly-out}''. The generated menu style is customizable using CSS through class "{adxm adxmenu}" usable outside the model.\n\nAn internal documentation page is available if the plugin is enabled : [->../?page=adxmenu_documentation].\n[fr]{{Menu ouvrant multi-niveaux type ''fly-out'' en CSS/javascript}}\n\nCe plugin ajoute la balise <code>#ADXMENU{options}</code> et le mod�le "{{adxmenu.html}}" pour vos squelettes SPIP, qui fait appara�®tre un menu �l�gant type ''{fly-out}''. Le style du menu g�n�r� est personnalisable par CSS, via la classe "{adxm adxmenu}" utilisable en dehors du mod�le.\n\nUne documentation interne est disponible lorsque le plugin est actif sur la page publique [adxmenu_documentation->../?page=adxmenu_documentation].\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:16:"Aleksandar Vacic";s:3:"url";s:24:"http://aplus.rs/adxmenu/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:12:"Piero Wbmstr";s:3:"url";s:39:"http://www.spip-contrib.net/PieroWbmstr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:35:"Creative Commons BY 3.0 Attribution";s:3:"url";s:43:"http://creativecommons.org/licenses/by/3.0/";}}', '', 'http://www.spip-contrib.net/?article3566', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:3:"cfg";a:2:{s:3:"nom";s:3:"cfg";s:13:"compatibilite";s:6:"[1.0;[";}}}}', '2012-09-02 12:00:18', '2012-09-02 12:00:18', 1, 'ADXmenu.zip', 31455, '2012-09-02 12:00:18', '_plugins_/adx_menu/spip_3', 'a:1:{s:7:"adxmenu";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd1085497f078c22c4355422b6519c06d'),
(32, 31, 'COMMHTML', 'http://files.spip.org/spip-zone/afficher_commentaires_html.png', '001.000.000', '', '[2.1.0;3.0.99]', '2.1,3.0', '<multi>\n[fr]Ce plugin permet d\'afficher dans l''espace priv� les commentaires HTML saisis dans le texte des objets �ditoriaux (les articles par exemple). Enfin, un bouton est ajout� au porte-plume pour ins�rer facilement un commentaire.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:34:"http://www.spip-contrib.net/Joseph";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article4184', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-27 18:00:03', '2012-06-27 18:00:03', 1, 'afficher_commentaires_html.zip', 6210, '2012-06-27 18:00:04', '_plugins_/porte_plume_extras/afficher_commentaires_html', 'a:1:{s:8:"commhtml";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'f9ffb58189039b38cf38ebcba30bb814'),
(33, 32, 'PB_PAGERANK', '', '000.002.000', '', '[3.0.0-dev;3.0.*]', '3.0', 'Ce plugin affiche le PageRank Google de votre site sur la page ÿ«A suivreÿ».', 'a:1:{i:0;a:3:{s:3:"nom";s:5:"ARNO*";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Afficher-Pagerank', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-03-01 19:00:10', '2012-03-01 19:00:10', 1, 'afficher_pagerank-spip3.zip', 14953, '2012-03-01 19:00:12', '_plugins_/afficher_pagerank/trunk', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '629f2aac1d9d75b2d3ede6f84289efad'),
(35, 34, 'ALBUMS', 'http://files.spip.org/spip-zone/albums.png', '001.001.000', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', 'Afficher une ou liste de documents, au fil du texte, dans les articles et ailleurs, pr�sent�s en galerie d\'images ou en liste.', 'a:1:{i:0;a:3:{s:3:"nom";s:14:"romy.tetue.net";s:3:"url";s:21:"http://romy.tetue.net";s:4:"mail";s:0:"";}}', '', 'a:2:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}i:1;a:2:{s:3:"nom";s:4:"2011";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/?article3971', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-03-01 01:00:02', '2012-03-01 01:00:02', 1, 'albums.zip', 60470, '2012-03-01 01:00:02', '_plugins_/albums/branches/v1', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '03f4f9b362573c61c741184560655673');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(528, 523, 'ZCORE', 'http://files.spip.org/spip-zone/z-core.png', '002.000.000', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en]Z framework for SPIP (Zpip)\n[fr]Z Framework pour SPIP (Zpip)\n</multi>', 'a:4:{i:1;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:13:"C�dric Morin";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:10:"Romy Tetue";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:4;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.yterium.net/108', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-27 04:00:22', '2012-09-27 04:00:22', 1, 'z-core.zip', 154721, '2012-09-27 04:00:22', '_plugins_/z-core', 'a:1:{s:4:"zpip";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:10:{s:2:"ar";a:0:{}s:2:"de";a:0:{}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"nl";a:1:{i:0;a:2:{s:3:"nom";s:7:"mpossoz";s:4:"lien";s:35:"http://trad.spip.net/auteur/mpossoz";}}s:2:"pt";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}s:2:"sv";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '37665e0b2e986153dade9766ee132b57'),
(37, 35, 'ALIAS', 'http://files.spip.org/spip-zone/alias_article.png', '000.001.001', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', '<multi>\n[en]It is quite common to want to display a same content in multiple locations in a tree. While this practice is not desirable, and if it must always lead us to question the relevance of our sectioning, it is nonetheless necessary in some cases. This plugin makes it possible to quickly create aliases, to display the same content in multiple locations in a tree.\n[fr]Il est assez fr�quent de vouloir afficher une contenu identique en plusieurs endroits d\'une arborescence. M�ªme si ce genre de pratique n\'est pas souhaitable, et si elle doit toujours nous amener �  nous poser la question de la pertinence de notre rubriquage, elle n\'en demeure pas moins n�cessaire dans certains cas. Ce plugin permet donc de cr�er rapidement des Alias d\'article, pour afficher un contenu identique en plusieurs endroits d\'une arborescence.\n[ru]ÐŸÐ¾Ð·Ð²Ð¾Ð»ÿÐµÿ⿿ ÿÐ¾Ð·Ð´Ð°Ð²Ð°ÿ⿿ÿſ ÿÿÿ⿹Ð»ÐºÐ¸ Ð¸Ð»Ð¸ ÿÿ⿬Ð»ÿ⿹ÐºÐ¸ Ð½Ð° ÿÿ⿿Ð°ÿ⿿ÿſÐ¸\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"Cedric Morin";s:3:"url";s:0:"";s:4:"mail";s:27:"cedric.morin AT yterium.com";}}', '', '', '', 'http://www.spip-contrib.net/Alias-d-Article,2854', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-03-24 17:00:01', '2012-03-24 17:00:01', 1, 'alias_article.zip', 12157, '2012-03-24 17:00:04', '_plugins_/alias', 'a:1:{s:5:"alias";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"ru";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'e32d73cf65fd53f5b238b72122babf69'),
(38, 36, 'AMIS', 'http://files.spip.org/spip-zone/amis.png', '000.001.000', '0.10', '[2.0.0;3.0.99]', '2.0,2.1,3.0', 'Gestion des amis', 'a:1:{i:0;a:3:{s:3:"nom";s:12:"Cedric Morin";s:3:"url";s:22:"http://www.yterium.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:0;s:4:"2008";}', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-02 18:00:09', '2012-08-02 18:00:09', 1, 'amis.zip', 23882, '2012-08-02 18:00:10', '_plugins_/amis', 'a:1:{s:4:"amis";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'a6bcd5aef3b64c2e32c931d3bff2370e'),
(39, 37, 'ANCRESDOUCES', 'http://files.spip.org/spip-zone/ancres_douces.png', '001.004.002', '', '[3.0.0-dev;3.0.*]', '3.0', '<multi>\n[en]This plugin allows a continuous scrolling of the page when the visitor clicks on a link to an anchor of the same page.\n[fa]ÿ§ÿŠÿ⿠ ÿ¾ÿ⿿ÿ§ÿ¯ÿŠÿ⿠ ÿ§ÿ¬ÿ§ÿ²ÿ⿡â⿬ſÿŠ ÿªÿ¯ÿ§ÿ˿ÿ⿦ ÿµÿÿ­ÿ⿡ ÿ¨ÿ⿡ ÿµÿ˿ÿ±ÿª ÿ·ÿ˿ÿ⿦ÿ§ÿ±ÿŠ ÿ±ÿ§ ÿ˿ÿ⿿ÿªÿŠ ÿŠÿƿ ÿ¨ÿ§ÿ²ÿ¯ÿŠÿ¯â⿬ſÿƿÿ⿠ÿ⿠ÿ¯ÿ⿡ ÿ¾ÿŠÿ˿ÿ⿠ÿ¯ ÿ¨ÿ⿡ ÿŠÿƿ ÿ⿦ÿ⿿ÿ§ÿ⿿ÿ⿡â⿬ſÿŠ ÿ®ÿ˿ÿ§ÿ⿠ÿ¯ÿ⿡ ÿ´ÿ¯ÿ⿡ ÿ±ÿ§ ÿƿÿ⿿ÿƿ ÿƿÿ⿠ÿ¯ ÿ⿦ÿŠâ⿬ſÿ¯ÿ⿡ÿ¯\n[fr]Ce plugin permet un d�filement continu de la page lorsque le visiteur clique sur un lien pointant vers une ancre de l''article en cours de lecture.\n[nl]Deze plugin maakt een zachte en continu scrol in de  pagina als de bezoeker op een link naar een anker van het artikel klikt.\n[sk]Tento z�¡suvn�½ modul umoÿ¾ÿ˿uje nepretrÿ¾it� pos�ºvanie str�¡nky, keÿ n�¡vÿ¡tevn�­k klikne na odkaz na kotvu na rovnakej str�¡nke.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Eric Lupinacci";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:8:"GNU/LGPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Ancres-douces', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-30 22:00:02', '2012-08-30 22:00:02', 1, 'ancres_douces.zip', 16481, '2012-08-30 22:00:02', '_plugins_/ancres_douces', 'a:1:{s:19:"paquet-ancresdouces";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"nl";a:1:{i:0;a:2:{s:3:"nom";s:5:"Suske";s:4:"lien";s:33:"http://trad.spip.net/auteur/suske";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd66b97006e7e1678c7753985158937bc'),
(40, 38, 'AP', '', '001.003.000', '0.2', '[2.0.0;3.0.99]', '2.0,2.1,3.0', 'Ce plugin d�fini une boucle (ANNONCES) permettant d\'afficher les annonces\n	�  afficher dans le calendrier et publi�es de la messagerie de l''espace priv�\n	d\'un site dans sa partie publique.', 'a:1:{i:0;a:3:{s:3:"nom";s:5:"James";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Annonces-Publiques', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-05-12 14:00:11', '2012-05-12 14:00:11', 1, 'annonces_publiques.zip', 13346, '2012-05-12 14:00:12', '_plugins_/annonces_publiques', 'a:1:{s:2:"ap";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'b3b9fac93ff9ad3fc924208f2aee7bed'),
(41, 39, 'APROPOS', 'http://files.spip.org/spip-zone/apropos_3.png', '000.003.007', '', '[3.0.0-rc;3.0.*]', '3.0', '<multi>\n[en]Lists the active plugins and displays a brief description of them.\n\n	It is used to display a page of type \\"about the site\\" with a summary of actives plugins, including the icon of these.\n\n	<br />\n\n	You can use the new balise #APROPOS into your templates. This balise has 4 parameters:<br />\n\n	- if you wrote: <code>#APROPOS{liste}</code>, you get the list of the actives plugins,\n\n	- if you wrote: <code>#APROPOS{nombre}</code>, you get the number of all the actives plugins AND locked plugins.\n\n	- if you wrote: <code>#APROPOS{plugins}</code>, you get the number of the actives plugins.\n\n	- if you wrote: <code>#APROPOS{extensions}</code>, you get the number of the actives locked plugins.\n\n	- if you wrote: <code>#APROPOS{adisposition}</code>, you get the number of plugins in the folder plugins.\n\n	- if you wrote: <code>#APROPOS{disponible}</code>, you get the total number of locked plugins and plugins of your configuration.\n\n	\n\n	To personalize the informations which are displayed before and after the list, modify the file modeles/apropos_liste.html after copying it into your folder squelettes/modeles. \n\n	<br />To view the list in an article, you must write <code><apropos|liste></code>. \n\n	To display the number of actives plugins AND locked plugins, write <code><apropos|nombre></code>.\n\n    To display the number of actives plugins, write <code><apropos|plugins></code>.\n\n    To display the number of actives locked plugins, write <code><apropos|extensions></code>.<br />\n	\n	To display the number of plugins in the folder plugins, write <code><apropos|adisposition></code>.\n\n	To display the total number of locked plugins and plugins of your configuration, write <code><apropos|disponible></code>.\n\n	If you want to display the full description of a specific plugin, use this: <code><apropos|prefixe=the prefixe of the plugin></code>. For example, to display the description of this plugin, write: <code><apropos|prefixe=apropos></code>.\n\n\n[fr]Liste les plugins actifs et affiche une description sommaire de ceux-ci.\n\n    \n\n    Il sert �  afficher sur une page de type ÿ«ÿ �  propos du siteÿ ÿ» un r�capitulatif des plugins actifs, y compris l''icone de ceux-ci.\n\n    <br />\n\n	Vous pouvez utiliser la nouvelle balise #APROPOS dans vos squelettes. Cette balise a diff�rents param�tres : <br />\n\n	<code>#APROPOS{liste}</code> pour retourner la liste des plugins, <br />\n\n	<code>#APROPOS{nombre}</code> pour n''afficher que le nombre de plugins ET de plugins verrouill�s actifs.<br />\n\n	<code>#APROPOS{plugins}</code> pour n''afficher que le nombre de plugins actifs.<br />\n\n	<code>#APROPOS{extensions}</code> pour n''afficher que le nombre de plugins verrouill�s actifs.<br />\n\n	<code>#APROPOS{adisposition}</code> pour afficher le nombre de plugins dans le dossier plugins.<br />\n\n	<code>#APROPOS{disponible}</code> pour afficher le nombre total de plugins verrouill�s et de plugins de votre configuration.<br />\n\n	Pour personnaliser ce qui est affich� avant et apr�s la liste des plugins actifs, modifiez le fichier modeles/apropos_liste.html que vous aurez pr�alablement copi� dans le dossier squelettes/modeles.\n\n	<br />\nDans un article, �crivez :<br>\n\n	<code><apropos|liste></code> pour afficher la liste des plugins et plugins verrouill�s actifs ;<br />\n\n	<code><apropos|nombre></code> pour n''afficher que le nombre de plugins ET de plugins verrouill�s actifs ;<br />\n\n	<code><apropos|plugins></code> pour n''afficher que le nombre de plugins actifs ;<br />\n\n	<code><apropos|extensions></code> pour n''afficher que le nombre de plugins verrouill�s actifs ; <br />\n	\n	<code><apropos|adisposition></code> pour n''afficher que le nombre de plugins dans le dossier plugins ;<br />\n	\n	<code><apropos|disponible></code> pour n''afficher que le nombre total de plugins verrouill�s et de plugins de votre configuration.<br />\n\n	<code><apropos|prefixe=le prefixe du plugin></code> si vous souhaitez afficher la description compl�te d\'un plugin sp�cifique, �crivez <code><apropos|prefixe=le prefixe du plugin></code>. Ainsi, par exemple, pour afficher dans un article la description compl�te de ce plugin, utilisez <code><apropos|prefixe=apropos></code>.<hr />\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:21:"Jean-Philippe Guihard";s:3:"url";s:26:"http://www.jp.guihard.net/";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/A-propos-des-plugins-actifs', 'http://www.jp.guihard.net/spip.php?article92', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-13 21:01:44', '2012-06-13 21:01:44', 1, 'apropos_3.zip', 19797, '2012-06-13 21:01:44', '_plugins_/apropos/trunk', 'a:1:{s:7:"apropos";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '2f7ab5ce27245e261ba7730de9b45f88'),
(42, 40, 'ARTICLE_ACCUEIL', 'http://files.spip.org/spip-zone/article_accueil.png', '001.001.000', '0.1.0', '[3.0.0-dev;3.0.99]', '3.0', '<multi>\n[en]This plugin allows you to assign an article as home of a section. Field "id_article_accueil" can then be used by the skeletons.\n[es]Este plugin te permite atribuir un art�­culo de inicio a las secciones. De ah�­, se puede usar el campo id_article_accueil en los esqueletos.\n[fr]Ce plugin vous permet de d\'attribuer un article d\'accueil aux rubriques. Le champ id_article_accueil peut ensuite �ªtre utilis� par les squelettes.\n[ru]ÐŸÐ»Ð°Ð³Ð¸Ð½ Ð¿Ð¾Ð·Ð²Ð¾Ð»ÿÐµÿ⿿ ÿÐ´ÐµÐ»Ð°ÿ⿿ÿſ ÿÿ⿿Ð°ÿ⿿ÿſÿŽ Ð³Ð»Ð°Ð²Ð½Ð¾Ð¹ Ð² ÿ⿬Ð°Ð·Ð´ÐµÐ»Ðµ. Ðšÿ⿬Ð¸ÿ⿿Ðµÿ⿬Ð¸Ð¹ "id_article_accueil" Ð¼Ð¾Ð¶Ð½Ð¾ Ð¸ÿÐ¿Ð¾Ð»ÿſÐ·Ð¾Ð²Ð°ÿ⿿ÿſ Ð² squelettes.\n[sk]Tento z�¡suvn�½ modul v�¡m umoÿ¾ÿ˿uje urÿiÿ¥, ktor�½ ÿl�¡nok bude tituln�½ ÿl�¡nok rubriky. Pole id_article_accueil potom m�´ÿ¾ete pouÿ¾iÿ¥ vÿ ÿ¡abl�³nach.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:12:"Cedric Morin";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:34:"http://www.spip-contrib.net/Joseph";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article3776', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:07:38', '2012-07-26 13:07:38', 1, 'article_accueil.zip', 15372, '2012-07-26 13:07:38', '_plugins_/article_accueil/trunk', 'a:2:{s:15:"article_accueil";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:0:{}s:2:"es";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:22:"paquet-article_accueil";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"en";a:0:{}s:2:"es";a:0:{}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:5:"nazar";s:4:"lien";s:33:"http://trad.spip.net/auteur/nazar";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd94ad0ccebbebb30892861c5995fbc03'),
(43, 41, 'ARTICLE_PDF', 'http://files.spip.org/spip-zone/article_pdf_2_0.png', '000.004.005', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[fr]Conversion d\'un article au format pdf pour t�l�chargement. N�cessite GD2 sur votre serveur et le t�l�chargement et installation de la librairie FPDF dans le r�pertoire lib\r\n\r\nIns�rez la balise <code>#ARTICLE_PDF</code> dans votre squelette pour avoir un lien de t�l�chargement de l''article au format PDF\r\n		[de]Konvertierung eines Artikels in das PDF Format zum herunterladen. Ben�¶tigt GD2 auf Ihrem Server\r\n\r\nF�¼gen Sie den Tag <code>#ARTICLE_PDF</code> in Ihr Skelett ein um �¼ber einen Link zum Herunterladen des Artikels im PDF Format zu verf�¼gen\r\n		</multi>', 'a:4:{i:0;a:3:{s:3:"nom";s:4:"chag";s:3:"url";s:34:"http://www.spip-contrib.net/_chag_";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:12:"Paul Sanches";s:3:"url";s:42:"http://www.spip-contrib.net/_Paul-Sanches_";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:9:"Aquinatus";s:3:"url";s:39:"http://www.spip-contrib.net/_Aquinatus_";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:13:"C�dric Morin";s:3:"url";s:26:"http://www.notre-ville.net";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/article2226.html', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:1:{i:0;a:1:{i:0;a:3:{s:3:"nom";s:16:"h5c1accba-fpdf17";s:2:"id";s:16:"h5c1accba-fpdf17";s:4:"lien";s:42:"http://www.fpdf.org/fr/download/fpdf17.zip";}}}s:7:"utilise";a:0:{}}', '2011-12-21 19:00:54', '2011-12-21 19:00:54', 1, 'article_pdf_2_0.zip', 149792, '2011-12-21 19:00:54', '_plugins_/article_pdf', 'a:1:{s:10:"articlepdf";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:3:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"nl";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '2d68d68d94e6252a5bf3e19fb30c8f15'),
(44, 42, 'ARTICLES_VERS_RUBRIQUES', 'http://files.spip.org/spip-zone/articles_vers_rubriques.png', '000.000.002', '', '[2.1.0;]', '2.1,3.0,3.1', 'Transforme les articles d\'un site en rubriques, les range dans une rubrique, fait suivre les logos et les documents, et convertit les liens raccourcis, permet d\'assurer la redirection vis-� -vis des moteurs de recherche.', 'a:2:{i:0;a:3:{s:3:"nom";s:20:"mmmx adapt du Didier";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:4:"JLuc";s:3:"url";s:21:"http://www.ouhpla.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:7:"GNU/GLP";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/4164', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-01 16:01:03', '2012-06-01 16:01:03', 1, 'articles_vers_rubriques.zip', 134426, '2012-06-01 16:01:08', '_plugins_/articles_vers_rubriques', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '7b6d3759cbc8e9e8c32b44008110cdb4'),
(45, 43, 'AUTEURS_SYNDIC', '', '000.002.000', '0.2.0', '[3.0.0;3.0.99]', '3.0', '<multi>\n[en]Adds the ability to add authors to syndicated sites\n[es]A�±ade la posibilidad de agregar autores a los sitios sindicados\n[fr]Ajoute la possibilit� d\'ajouter des auteurs aux sites syndiqu�s\n[sk]Umoÿ¾ÿ˿uje kÿ syndikovan�½m str�¡nkam prid�¡vaÿ¥ autorov\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"kent1";s:3:"url";s:21:"http://www.kent1.info";s:4:"mail";s:22:"kent1 AT arscenic.info";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:5:"sites";a:2:{s:3:"nom";s:5:"sites";s:13:"compatibilite";s:8:"[1.7.6;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-15 04:01:36', '2012-08-15 04:01:36', 1, 'auteurs_syndic.zip', 7090, '2012-08-15 04:01:38', '_plugins_/auteurs_syndic/trunk', 'a:1:{s:21:"paquet-auteurs_syndic";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:0:{}s:2:"es";a:1:{i:0;a:2:{s:3:"nom";s:4:"dani";s:4:"lien";s:32:"http://trad.spip.net/auteur/dani";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '6af50a2fda11a833e9e2cbfc66e721d6'),
(46, 44, 'OPENID', 'http://files.spip.org/spip-zone/openid.png', '001.001.011', '0.2', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\n[fr]Un utilisateur qui souhaite utiliser son OpenID pour acc�der au site doit l''entrer comme adresse de son site web dans son profil. Ensuite, au lieu de mettre son login ou adresse email, il suffit d\'entrer son OpenID pour se logguer.\n[en]A user wishing to authenticate with her OpenID should enter it as her web site address in her profile. Then, instead of entering her login or email address in the authentication page, she should enter her OpenID.\n		</multi>', 'a:4:{i:0;a:3:{s:3:"nom";s:16:"Edouard Lafargue";s:3:"url";s:0:"";s:4:"mail";s:28:"mailto:edouard@lafargue.name";}i:1;a:3:{s:3:"nom";s:18:"Mathieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:12:"Cedric Morin";s:3:"url";s:18:"http://yterium.net";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:2:{i:0;a:2:{s:3:"nom";s:12:"ÿ© 2007-2009";s:3:"url";s:0:"";}i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Plugin-d-authentification-OpenID', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:1:{i:0;a:1:{i:0;a:3:{s:3:"nom";s:25:"openid-php-openid-782224d";s:2:"id";s:25:"openid-php-openid-782224d";s:4:"lien";s:74:"http://www.spip-contrib.net/IMG/zip/openid-php-openid-2.2.2-0-ga287b2d.zip";}}}s:7:"utilise";a:0:{}}', '2012-07-26 13:18:39', '2012-07-26 13:18:39', 1, 'openid.zip', 43410, '2012-07-26 13:18:40', '_plugins_/openid', 'a:1:{s:6:"openid";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c824b3dd5fe29cdef4ae732d42f9f229'),
(48, 46, 'BADGE_DON', 'http://files.spip.org/spip-zone/badge_don.png', '000.001.002', '', '[2.0;3.0.99]', '2.0,2.1,3.0', 'Ce plugin permet d\'afficher un badge dans les pages publiques de votre site pour inciter les visiteurs �  faire des dons.\n_ Cr�dit ic�´ne : izo.\n_ Image du badge par d�faut : CC-BY Les petits d�brouillards Bretagne.', 'a:1:{i:0;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/4072', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-16 23:00:02', '2012-08-16 23:00:02', 1, 'badge_don.zip', 17688, '2012-08-16 23:00:06', '_plugins_/badge_don', 'a:1:{s:9:"badge_don";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd95e760150849ebb74f2687cf65c51bd'),
(49, 47, 'BASICONE', 'http://files.spip.org/spip-zone/basicone.png', '000.000.091', '', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[fr]Un jeu d\'ic�´nes sobres en noir et transparence pour s''int�grer �  toutes les couleurs de l''interface priv�e, voir plus encore...\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:9:"chankalan";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/basicone-icones-du-theme-prive', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-08 18:00:03', '2012-08-08 18:00:03', 1, 'basicone.zip', 131758, '2012-08-08 18:00:04', '_plugins_/basicone', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '00a2226324e3e6ce2f5371cfc3b7c140'),
(50, 48, 'BELLESPUCES', 'http://files.spip.org/spip-zone/bellespuces.png', '000.001.001', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', 'Ce plugin traite le raccourci SPIP ÿ«ÿ <code>-</code>ÿ ÿ» comme ÿ«ÿ <code>-*</code>ÿ ÿ», g�n�rant de vraies listes (<code>ul/li</code>) dans les deux cas.', 'a:1:{i:0;a:3:{s:3:"nom";s:15:"J�r�´me Combaz";s:3:"url";s:60:"http://conseil-recherche-innovation.net/le-cri/jerome-combaz";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/3724', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-11-10 12:00:03', '2011-11-10 12:00:03', 1, 'bellespuces.zip', 3079, '2011-11-10 12:00:04', '_plugins_/bellespuces', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ba60c7f2d3d406e9bf439359eef436d0'),
(51, 49, 'BISOUS', 'http://files.spip.org/spip-zone/bisous_SPIP3.png', '000.002.001', '0.2', '[3.0.0-dev;3.0.99]', '3.0', 'Vous �ªtes en col�re ? Il vous faut des bisous ! Vous �ªtes content ? Il vous faut des bisous !', 'a:1:{i:0;a:3:{s:3:"nom";s:13:"RastaPopoulos";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-03-19 16:00:41', '2012-03-19 16:00:41', 1, 'bisous_SPIP3.zip', 16429, '2012-03-19 16:00:42', '_plugins_/bisous/trunk', 'a:1:{s:6:"bisous";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'eb95f89101050b5eb123732ee488a0ca'),
(52, 50, 'BOLO', 'http://files.spip.org/spip-zone/bolo.png', '000.002.002', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', '<multi>\n[en]This plugin allows to easily insert fake text with an ajustable number of characters, into SPIP articles or into SPIP templates.\r\nIt can be used directy in templates  via the code <code>[(#BOLO|couper{800})]</code> or in the #TEXT fields of the articles via this code : <code><bolo800/></code>.\r\n\r\nThis version inserts text in latin language only, a future version could offer the choice between latin or French language texts.\n[fr]Ce plugin permet d\'ins�rer tr�s facilement du faux texte dans les articles ou dans les squelettes, en sp�cifiant le nombre de caract�res souhait�s.\r\nOn l''emploie soit directement dans les squelettes en utilisant le code <code>[(#BOLO|couper{800})]</code>, soit dans les champs #TEXTE des articles gr�¢ce au mod�le <code><bolo800></code>.\r\n\r\nLa version actuelle permet seulement d\'ins�rer du texte latin; une future version pourrait permettre d\'ins�rer du texte latin ou fran�§ais accentu�.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:26:"Cyril MARION, Ateliers CYM";s:3:"url";s:17:"http://www.cym.fr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:4:"2010";}', 'http://www.spip-contrib.net/Balise-BOLO', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-11-01 21:06:53', '2011-11-01 21:06:53', 1, 'bolo.zip', 34888, '2011-11-01 22:00:02', '_plugins_/bolo', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '17508caa53e6dc6f2a6780cf509fb830'),
(53, 51, 'BOUSSOLE', 'http://files.spip.org/spip-zone/boussole_v0.png', '000.006.005', '0.1', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\n[en]Install this plugin on your site and you will have access, in your skeletons, to all the sites of the SPIP Galaxy using \nmodels, noisettes or the Z page provided.\n_ For DIYers, you can also use this plugin to display your own list of sites and design your own displays.\n[fr]Installez ce plugin sur votre site et vous aurez acc�s, dans vos squelettes, �  l''ensemble des sites de la Galaxie SPIP en utilisant\nles mod�les, les noisettes ou la page Z propos�s.\n_ Pour les bricoleurs, vous pouvez aussi utiliser ce plugin pour afficher votre propre liste de sites et concevoir vos propres affichages.\n[sk]Nainÿ¡talujte si tento z�¡suvn�½ modul na svoju str�¡nku aÿ voÿ svojich ÿ¡abl�³nach budete maÿ¥ pr�­stup na vÿ¡etky str�¡nky Galaxie SPIPu pomocou  modelov ÿ¡abl�³n, orieÿ¡kov alebo navrhovanej str�¡nky Z.\n_ Sami m�´ÿ¾ete tento z�¡suvn�½ modul pouÿ¾�­vaÿ¥ na zobrazenie svojho vlastn�ho zoznamu str�¡nok aÿ vytvoriÿ¥ svoje vlastn� zobrazenia.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Eric Lupinacci";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Boussole,3688', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-01 23:00:12', '2012-06-01 23:00:12', 1, 'boussole_v0.zip', 565185, '2012-06-01 23:00:14', '_plugins_/boussole/branches/v0', 'a:2:{s:8:"boussole";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.org/auteur/jaro";}}}}s:15:"paquet-boussole";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.org/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '8c5d0fd1523d6c4868d29ca3ed1d8bb8'),
(54, 51, 'BOUSSOLE', 'http://files.spip.org/spip-zone/boussole.png', '001.000.001', '0.1', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en]Install this plugin on your site and you will have access, in your skeletons, to all the sites of the SPIP Galaxy using \nmodels, noisettes or the Z page provided.\n_ For DIYers, you can also use this plugin to display your own list of sites and design your own displays.\n[fr]Installez ce plugin sur votre site et vous aurez acc�s, dans vos squelettes, �  l''ensemble des sites de la Galaxie SPIP en utilisant\nles mod�les, les noisettes ou la page Z propos�s.\n_ Pour les bricoleurs, vous pouvez aussi utiliser ce plugin pour afficher votre propre liste de sites et concevoir vos propres affichages.\n[sk]Nainÿ¡talujte si tento z�¡suvn�½ modul na svoju str�¡nku aÿ voÿ svojich ÿ¡abl�³nach budete maÿ¥ pr�­stup na vÿ¡etky str�¡nky Galaxie SPIPu pomocou  modelov ÿ¡abl�³n, orieÿ¡kov alebo navrhovanej str�¡nky Z.\n_ Sami m�´ÿ¾ete tento z�¡suvn�½ modul pouÿ¾�­vaÿ¥ na zobrazenie svojho vlastn�ho zoznamu str�¡nok aÿ vytvoriÿ¥ svoje vlastn� zobrazenia.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Eric Lupinacci";s:3:"url";s:24:"http://blog.smellup.net/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Boussole,3688', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:08:16', '2012-07-26 13:08:16', 1, 'boussole.zip', 560723, '2012-07-26 13:08:16', '_plugins_/boussole/trunk', 'a:2:{s:8:"boussole";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:15:"paquet-boussole";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '85dc5ece6341c8e71c9ac284a66a49ed'),
(55, 52, 'BOUTONSTEXTE', 'http://files.spip.org/spip-zone/boutonstexte-v2.png', '002.000.000', '', '[3.0.0-dev;3.0.*]', '3.0', '<multi>\n[ar]ÿŠÿ¶ÿŠÿ ÿ£ÿ²ÿ±ÿ§ÿ± ÿªÿƿÿ¨ÿŠÿ± ÿ˿ÿªÿµÿºÿŠÿ± ÿ§ÿ⿿ÿ®ÿ· ÿÿŠ ÿ⿠ÿµ ÿ§ÿ⿿ÿ⿦ÿ⿿ÿ§ÿ⿿. ÿªÿ¸ÿ⿡ÿ± ÿ§ÿ⿿ÿ£ÿ²ÿ±ÿ§ÿ± ÿ⿿ÿ¨ÿ⿿ ÿƿÿ⿿ ÿ¹ÿ⿿ÿ§ÿ⿦ÿ© div ÿ⿦ÿ⿠ ÿµÿ⿠ÿ texte ÿÿŠ ÿ§ÿ⿿ÿ⿠ÿµ ÿ§ÿ°ÿ§ ÿ⿿ÿ⿦ ÿªÿƿÿ⿠ ÿ⿦ÿ˿ÿ¬ÿ˿ÿ¯ÿ© ÿ³ÿ§ÿ¨ÿ⿿ÿ§ÿ⿹ (ÿµÿ˿ÿ± ÿ⿦ÿ⿠ ÿµÿ⿠ÿ textsizeup ÿ˿textsizedown ÿ˿textonly ÿ⿿ÿ⿿ÿ⿠ÿµ ÿÿ⿿ÿ·)\n\nÿŠÿ⿦ÿƿÿ⿠ ÿªÿ⿠ÿÿŠÿ° ÿ§ÿ⿿ÿ¥ÿ¹ÿ¯ÿ§ÿ¯ ÿ§ÿ⿿ÿ§ÿ®ÿªÿŠÿ§ÿ±ÿŠ ÿ¨ÿªÿ«ÿ¨ÿŠÿª ÿ§ÿ⿿ÿ⿦ÿ⿿ÿ­ÿ⿿ cfg. ÿŠÿ⿦ÿƿÿ⿠ ÿÿ±ÿ¶ ÿ¨ÿ¹ÿ¶ ÿ§ÿ⿿ÿ¹ÿ⿠ÿ§ÿµÿ± ÿ¨ÿ˿ÿ§ÿ³ÿ·ÿ© ÿ¬ÿ§ÿÿ§ÿ³ÿƿÿ±ÿŠÿ¨ÿª.\n[de]F�¼gt Schaltfl�¤chen zum Vergr�¶�Ÿern und Verkleinern von Text hinzu. Die Schaltfl�¤chen werden vor jedes div der Klasse texte des Inhalts eingef�¼gt, au�Ÿer wenn sie bereits in der Seite vorhanden sind (Bilder der Klassen textsizeup, textsizedown oder textonly).\n\n�ſber das Plugin CFG wird eine Oberfl�¤che zur Konfiguration bereitgestellt. Manche Elemente k�¶nnen per Javascript manipuliert werden.\n[en]Adds buttons to display text such as enlarge/reduce font point size. Buttons are added before each texte class div of the content if they are not already on the page (images under textsizeup, textsizedown or textonly classes)\n		\nOptional configuration could be achieved by installing the cfg plugin. Some elements can be forced through javascript\n[fa]ÿ§ÿÿ²ÿ˿ÿ¯ÿ⿠ ÿ¯ÿƿÿ⿦ÿ⿡â⿬ſÿ⿡ÿ§ ÿ¨ÿ±ÿ§ÿŠ ÿ⿠ÿ⿦ÿ§ÿŠÿ´ ÿ⿦ÿªÿ⿠ ÿ⿦ÿ§ÿ⿠ÿ⿠ÿ¯ ÿ¨ÿ²ÿ±ÿ¯/ÿƿÿ˿ÿ⿠ÿƿ ÿƿÿ±ÿ¯ÿ⿠ ÿ⿿ÿ⿿ÿ⿦. ÿ¯ÿƿÿ⿦ÿ⿡â⿬ſÿ⿡ÿ§ÿſ ÿ§ÿ¯ÿ± ÿ§ÿ² ÿ⿿ÿ¨ÿ⿿ ÿ¯ÿ± ÿ⿦ÿªÿ⿠ ÿ⿠ÿ¨ÿ§ÿ´ÿ⿠ÿ¯ (ÿªÿµÿ§ÿ˿ÿŠÿ± ÿªÿ­ÿª ÿƿÿ⿿ÿ§ÿ³ ÿ§ÿ⿠ÿ¯ÿ§ÿ²ÿ⿡â⿬ſ ÿ⿦ÿªÿ⿠ ÿ¨ÿ§ÿ⿿ÿ§ÿſ ÿ§ÿ⿠ÿ¯ÿ§ÿ²ÿ⿡ ÿ⿦ÿªÿ⿠ ÿ¾ÿ§ÿŠÿ¦ÿ⿠ ÿŠÿ§ ÿÿ⿿ÿ·  ÿ¾ÿŠÿ´ ÿ§ÿ² ÿ⿡ÿ±ÿ⿦ÿªÿ⿠) ÿ¾ÿŠÿ´ ÿ§ÿ² ÿ⿡ÿ± div ÿƿÿ⿿ÿ§ÿ³ ÿ⿦ÿªÿ⿠ ÿ§ÿÿ²ÿ˿ÿ¯ÿ⿡ ÿ⿦ÿŠâ⿬ſÿ´ÿ˿ÿ⿠ÿ¯.\n\nÿ¾ÿŠÿƿÿ±ÿ¨ÿ⿠ÿ¯ÿŠ ÿ¯ÿ²ÿŠÿ⿠ÿ´ÿŠ ÿ⿦ÿŠâ⿬ſÿªÿ˿ÿ§ÿ⿠ÿ¯ ÿ¶ÿ⿦ÿ⿠ ÿ⿠ÿµÿ¨ ÿ¾ÿ⿿ÿ§ÿ¯ÿŠÿ⿠ ÿ³ÿŠ.ÿ§ÿ.ÿ¬ÿŠ ÿ§ ÿ§ÿ⿠ÿ¬ÿ§ÿ⿦ ÿ´ÿ˿ÿ¯. ÿ¨ÿ¹ÿ¶ÿŠ ÿ§ÿ² ÿ¹ÿ⿠ÿ§ÿµÿ± ÿ⿦ÿŠâ⿬ſÿªÿ˿ÿ§ÿ⿠ÿ⿠ÿ¯ ÿ§ÿ² ÿ·ÿ±ÿŠÿ⿿ ÿ¬ÿ§ÿ˿ÿ§ ÿ§ÿ³ÿƿÿ±ÿŠÿ¾ÿª ÿ§ÿ⿿ÿ²ÿ§ÿ⿦ÿŠ ÿ´ÿ˿ÿ⿠ÿ¯.\n[fr]Rajoute des boutons pour l''affichage des textes comme augmenter/diminuer police. Les boutons sont rajout�s avant chaque div de classe texte du contenu si ils ne sont pas d�j�  pr�sents dans la page (images de classe textsizeup, textsizedown ou textonly)\n\nLa configuration optionnelle peut se faire en installant le plugin cfg. Certains �l�ments peuvent �ªtre forc�s par javascript.\n[sk]Prid�¡ tlaÿidl�¡ na zv�¤ÿÿ¡enie/zmenÿ¡enie veÿ¾kosti p�­sma. Tlaÿidl�¡ bud�º pridan� pred kaÿ¾d�½ text oznaÿen�½ ako trieda div za predpokladu, ÿ¾e sa eÿ¡te nenach�¡dzaj�º na str�¡nke (obr�¡zky triedy textsizeup, textsizedown alebo textonly)\n\nVoliteÿ¾n� nastavenia m�´ÿ¾ete pridaÿ¥, ak nainÿ¡talujete z�¡suvn�½ modul cfg. Niektor� prvky m�´ÿ¾u na svoje fungovanie potrebovaÿ¥ javascript.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:15:"Bertrand Gugger";s:3:"url";s:17:"http://toggg.com/";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/?article1474', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:08:29', '2012-07-26 13:08:29', 1, 'boutonstexte-v2.zip', 26848, '2012-07-26 13:08:30', '_plugins_/boutonstexte/trunk', 'a:2:{s:12:"boutonstexte";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:6:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/ÿ¬ÿ˿ÿ±ÿ¬-ÿ⿿ÿ⿠ÿ¯ÿ⿿ÿÿª";}}s:2:"de";a:1:{i:0;a:2:{s:3:"nom";s:7:"klaus++";s:4:"lien";s:33:"http://trad.spip.net/auteur/klaus";}}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:19:"paquet-boutonstexte";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:6:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/ÿ¬ÿ˿ÿ±ÿ¬-ÿ⿿ÿ⿠ÿ¯ÿ⿿ÿÿª";}}s:2:"de";a:1:{i:0;a:2:{s:3:"nom";s:7:"klaus++";s:4:"lien";s:33:"http://trad.spip.net/auteur/klaus";}}s:2:"en";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'e0c7996d95669019aa606095c4073f4f'),
(56, 53, 'BREVES_VERS_ARTICLES', 'http://files.spip.org/spip-zone/breves_vers_articles.png', '001.003.000', '', '[2.1.0;3.0.99]', '2.1,3.0', 'Transforme les br�ves d\'un site en articles, les range dans une rubrique, leur attribue un auteur, fait suivre les logos et les forums, et convertit les liens raccourcis, permet d\'assurer la redirection vis-� -vis des moteurs de recherche.', 'a:2:{i:0;a:3:{s:3:"nom";s:6:"Didier";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:4:"JLuc";s:3:"url";s:21:"http://www.ouhpla.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:7:"GNU/GLP";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/3835', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-01-06 16:00:02', '2012-01-06 16:00:02', 1, 'breves_vers_articles.zip', 13512, '2012-01-06 16:00:04', '_plugins_/breves_vers_articles', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '3622e85cbf6a12aa539768b5f9918c3e'),
(57, 54, 'CACHE_COOL', 'http://files.spip.org/spip-zone/cache_cool.png', '000.002.005', '', '[2.1.0;3.0.99]', '2.1,3.0', 'Servir le cache froid pour aller plus vite, et calculer en diff�r� en t�¢che de fond', 'a:1:{i:0;a:3:{s:3:"nom";s:6:"Cedric";s:3:"url";s:22:"http://www.yterium.net";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Cache-Cool', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{i:0;a:4:{s:2:"id";s:5:"queue";s:3:"nom";s:5:"queue";s:7:"version";s:8:"[0.2.1;]";s:13:"compatibilite";s:8:"[0.2.1;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-21 10:00:19', '2012-06-21 10:00:19', 1, 'cache_cool.zip', 59769, '2012-06-21 10:00:22', '_plugins_/cache_cool', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'dcd81caedbbe4df573b9cdc50639abfd'),
(58, 55, 'CALENDRIERMINI', 'http://files.spip.org/spip-zone/calendrier_mini-v0.5.png', '000.005.001', '', '[3.0.0-beta;3.0.99]', '3.0', '<multi>\n[en]Allow to use a #CALENDRIER_MINI tag.\n_ This tag displays a calendar designed as dotclear''s one and therefore compatible with the styles from this blog system.\n_ Other tools are added, such as tags, criteria, models...\n_ Icon from [Tempest->http://tempest.deviantart.com/] under CC BY-NC-ND license.\n[fr]Permet l''utilisation d\'une balise #CALENDRIER_MINI.\n_ Cette balise affiche un calendrier au design issu de dotclear et donc compatible avec les styles issus de ce syst�me de blog.\n_ Lui sont adjoints d\'autre �l�ments, tels que balises, crit�res, mod�les...\n_ Icone de [Tempest->http://tempest.deviantart.com/] sous licence CC BY-NC-ND.\n[sk]Umoÿ¾ÿ˿uje pouÿ¾�­vaÿ¥ tag #CALENDRIER_MINI.\n_ Tento tag zobraz�­ vzhÿ¾ad kalend�¡ra bezÿ bodiek, aÿ preto je kompatibiln�½ soÿ ÿ¡t�½lmi zÿ tohto blogovacieho syst�mu.\n_ Pom�¡ha ÿalÿ¡�­m prvkom, ako s�º tagy, krit�ri�¡, ÿ¡abl�³ny aÿ i.\n_ Ikona [Tempest->http://tempest.deviantart.com/] pod licenciou CC BY-NC-ND.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"James";s:3:"url";s:0:"";s:4:"mail";s:17:"james AT rezo.net";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2006-2012";}', '', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-04-02 17:00:22', '2012-04-02 17:00:22', 1, 'calendrier_mini-v0.5.zip', 22798, '2012-04-02 17:00:22', '_plugins_/calendrier_mini/branches/v0.5', 'a:2:{s:7:"minical";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:8:{s:2:"ar";a:0:{}s:2:"ca";a:0:{}s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"es";a:0:{}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.org/auteur/jaro";}}}}s:21:"paquet-calendriermini";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.org/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.org/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '82cb776f4214a023d7ba6c2d8375502f'),
(499, 55, 'CALENDRIERMINI', 'http://files.spip.org/spip-zone/calendrier_mini-2.0.png', '002.003.003', '', '[3.0.0-beta;3.0.99]', '3.0', '<multi>\n[en]#CALENDRIER_MINI displays a calendar designed as dotclear''s one and therefore compatible with the styles from this blog system.\n_ Other tools are added, such as tags, criteria, models...\n[fr]#CALENDRIER_MINI affiche un calendrier au design issu de dotclear et donc compatible avec les styles issus de ce syst�me de blog.\n_ Lui sont adjoints d\'autre �l�ments, tels que balises, crit�res, mod�les...\n[sk]#CALENDRIER_MINI zobraz� kalend�r s dizajnom od dotclear, a preto je kompatibiln� so �t�lmi tohto  publika�n�ho syst�mu pre blogy.\n_ S�m pom�ha in�m objektom, ako s� tagy, krit�ri�, �abl�ny at�.\n.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"James";s:3:"url";s:0:"";s:4:"mail";s:17:"james AT rezo.net";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:46:"Tempest pour l''icone sous licence CC BY-NC-ND.";s:3:"url";s:30:"http://tempest.deviantart.com/";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2006-2012";}', 'http://www.spip-contrib.net/Calendrier-Mini-2-0', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-27 10:00:04', '2012-09-27 10:00:04', 1, 'calendrier_mini-2.0.zip', 35649, '2012-09-27 10:00:06', '_plugins_/calendrier_mini/trunk', 'a:2:{s:7:"minical";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:21:"paquet-calendriermini";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '60068862d63ea5a3b4fb0bfc44c85aa9');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(500, 497, 'CEXTRAS', 'http://files.spip.org/spip-zone/champs_extras3.png', '003.002.002', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[de]Offre une API simple permettant de cr�er de nouveaux champs dans les objets �ditoriaux.\n					Il est donc le socle pour d\'autres plugins notamment pour �Champs Extras Interface� qui donne\n					une interface graphique de gestion de ces nouveaux champs.\n[en]Provides a simple API to create new fields on the editorial objects.\nIt is the base for other plugins including "Extras Fields Interface" which provides\na graphical interface to manage these new fields.\n[es]Offre une API simple permettant de cr�er de nouveaux champs dans les objets �ditoriaux.\n					Il est donc le socle pour d\'autres plugins notamment pour �Champs Extras Interface� qui donne\n					une interface graphique de gestion de ces nouveaux champs.\n[fr]Offre une API simple permettant de cr�er de nouveaux champs dans les objets �ditoriaux.\n					Il est donc le socle pour d\'autres plugins notamment pour �Champs Extras Interface� qui donne\n					une interface graphique de gestion de ces nouveaux champs.\n[it] Offre une API simple permettant de cr�er de nouveaux champs dans les objets �ditoriaux.\n					Il est donc le socle pour d\'autres plugins notamment pour �Champs Extras Interface� qui donne\n					une interface graphique de gestion de ces nouveaux champs.\n[sk]Pon�ka jednoduch� aplik�ciu, ktor� umo��uje vytv�ra� nov� polia v�redak�n�ch objektoch.\n					Je z�kladom pre in� z�suvn� moduly, vr�tane  "Rozhrania doplnkov�ch pol�", ktor� poskytuje\n					grafick� rozhranie na riadenie t�chto nov�ch pol�.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/?article4068', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.21.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:8:"verifier";a:2:{s:3:"nom";s:8:"verifier";s:13:"compatibilite";s:9:"[0.1.12;]";}}}}', '2012-09-22 19:00:03', '2012-09-22 19:00:03', 1, 'champs_extras3.zip', 28607, '2012-09-22 19:00:10', '_plugins_/champs_extras/core/trunk', 'a:2:{s:7:"cextras";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:6:{s:2:"ar";a:0:{}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:14:"paquet-cextras";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:6:{s:2:"de";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"it";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"sk";a:2:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}i:1;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '86fb32a9d1bc932baf3943e9f98be228'),
(60, 56, 'PB_CESURE', '', '001.001.000', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', 'Ce plugin permet d\'ins�rer les indications de c�sure optionnelle dans les textes trait�s par SPIP.\r\n		\r\n		Il faut modifier ainsi les squelettes aux endroits o�¹ l''on d�sire utiliser cette fonction:\r\n		<code>[(#TEXTE|cesure{#LANG})]</code>\r\n		\r\n		Il est actif pour l''allemand, l''anglais et le fran�§ais.', 'a:2:{i:0;a:3:{s:3:"nom";s:5:"ARNO*";s:3:"url";s:0:"";s:4:"mail";s:13:"arno@rezo.net";}i:1;a:3:{s:3:"nom";s:12:"Yellow Green";s:3:"url";s:33:"http://yellowgreen.de/hyphenation";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:22:"Creative Commons by-sa";s:3:"url";s:0:"";}}', '', 'http://www.paris-beyrouth.org/tutoriaux-spip/article/le-plugin-de-cesure-html', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-10-19 14:10:46', '2011-10-19 14:10:46', 1, 'cesure.zip', 65386, '2011-10-19 15:00:06', '_plugins_/cesure', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '065403b3b04c497fa72b30a047a805de'),
(61, 57, 'CFG', 'http://files.spip.org/spip-zone/cfg-spip3.png', '003.000.000', '', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[fr]\n		Augmente les possibilit�s de gestion de configuration pour d\'autres plugins\n		en fournissant un mode de stockage PHP.\n\n		Attention : une partie du fonctionnement de CFG pour SPIP 2 a �t� int�gr�e dans SPIP 3 de fa�§on\n		l�g�rement diff�rente. Il est n�cessaire de migrer les plugins qui utilisaient CFG pour SPIP 2.\n		La plupart n''auront plus besoin de ce plugin pour g�rer leur configurations.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:15:"Bertrand Gugger";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2008-2011";}', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-12-21 19:00:46', '2011-12-21 19:00:46', 1, 'cfg-spip3.zip', 33921, '2011-12-21 19:00:48', '_plugins_/cfg/trunk', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '4747366c90eeea2901f959288e6ea2bc'),
(62, 58, 'CITE', 'http://files.spip.org/spip-zone/cite.png', '000.005.001', '', '[2.1.0;3.0.*]', '2.1,3.0', '<multi>\n[fr]Le plugin Cite fournit des mod�les permettant de citer proprement des r�f�rences bibliographiques dans vos articles tout en offrant un export dans des formats bibliographiques courants.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:34:"http://www.spip-contrib.net/Joseph";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/spip.php?article3698', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:8:"verifier";a:2:{s:3:"nom";s:8:"verifier";s:13:"compatibilite";s:8:"[0.1.8;[";}s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.25.4;]";}}}}', '2012-07-19 17:00:04', '2012-07-19 17:00:04', 1, 'cite.zip', 59883, '2012-07-19 17:00:10', '_plugins_/cite', 'a:1:{s:4:"cite";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '0b5056dc2637a9ec057064d6026a9d7d'),
(63, 59, 'CRUD', '', '000.004.000', '', '[2.1.0;3.0.*]', '2.1,3.0', '<multi>\n[en]C(r)UD Interface for SPIP that can be used via an action defined by its URL or calling it directly.\n[fr]Une interface C(r)UD pour SPIP qui peut s''utiliser par l''interm�diaire d\'une action d�finie par son url ou par appel direct.\n[sk]Rozhranie C(r)UD pre SPIP, ktor� m�´ÿ¾ete vyuÿ¾�­vaÿ¥ prostredn�­ctvom akcie, ktor�¡ je definovan�¡ cezÿ svoju url alebo priamo prostredn�­ctvom dial�³gov�ho okna.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:13:"C�dric Morin";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:11:36', '2012-07-26 13:11:36', 1, 'crud.zip', 14663, '2012-07-26 13:11:36', '_plugins_/crud', 'a:2:{s:4:"crud";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:11:"paquet-crud";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '0faf9bb4161175a4250f6b07adcf3c4a'),
(487, 489, 'TRAD_RUB', 'http://files.spip.org/spip-zone/traduction_rubriques_autrement_1.png', '001.002.002', '', '[3.0.0-alpha2;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin, d�stin� pour les sites mutlilingues avec [un secteur par langue->http://www.spip-contrib.net/Un-exemple-de-site-multilingue], vous offre une approche similaire au niveau de la navigation et de la gestion de traductions des rubriques à celle du plugin [Traduction articles autrement->http://files.spip.org/spip-zone/traduction_articles_autrement.zip] dont l''installation est recommand�. Comme spip ne propose pas nativement la traduction des rubriques l''installation du plugin [Traduction entre rubrique->http://files.spip.org/spip-zone/tradrub.zip] est n�cessaire.\n[sk]Tento zásuvný modul, ktorý bol vytvorený pre viacjazyčn� stránky [so sektormi podľa jazyka->http://www.spip-contrib.net/Un-exemple-de-site-multilingue], vám pokiaľ ide o navigáciu a riadenie prekladov rubrík ponúka podobný prístup ako zásuvný modul [Preklad článkov inak,->http://files.spip.org/spip-zone/traduction_articles_autrement.zip] ktor�ho inštalácia sa odporúča. Keďže spip v predvolených nastaveniach neponúka preklad rubrík, treba si nainštalovať zásuvný modul [Preklad medzi rubrikami.->http://files.spip.org/spip-zone/tradrub.zip]\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Rainer Müller";s:3:"url";s:23:"http://www.mychacra.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://contrib.spip.net/Traductions-de-rubriques-autrement-3', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:7:"tradrub";a:2:{s:3:"nom";s:7:"tradrub";s:13:"compatibilite";s:8:"[3.0.0;[";}s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.25.2;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:3:"taa";a:2:{s:3:"nom";s:3:"taa";s:13:"compatibilite";s:8:"[1.0.0;[";}}}}', '2012-09-14 13:00:16', '2012-09-14 13:00:16', 1, 'traduction_rubriques_autrement_1.zip', 27500, '2012-09-14 13:00:18', '_plugins_/traduction_rubriques_autrement/branches/1', 'a:2:{s:15:"paquet-trad_rub";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:3:"tra";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:11:{s:3:"ast";a:1:{i:0;a:2:{s:3:"nom";s:5:"Xuacu";s:4:"lien";s:33:"http://trad.spip.net/auteur/xuacu";}}s:2:"ca";a:1:{i:0;a:2:{s:3:"nom";s:5:"merce";s:4:"lien";s:33:"http://trad.spip.net/auteur/merce";}}s:2:"de";a:1:{i:0;a:2:{s:3:"nom";s:14:"Rainer Müller";s:4:"lien";s:41:"http://trad.spip.net/auteur/rainer-muller";}}s:2:"en";a:2:{i:0;a:2:{s:3:"nom";s:4:"Mark";s:4:"lien";s:32:"http://trad.spip.net/auteur/mark";}i:1;a:2:{s:3:"nom";s:7:"abelass";s:4:"lien";s:35:"http://trad.spip.net/auteur/abelass";}}s:2:"es";a:1:{i:0;a:2:{s:3:"nom";s:7:"abelass";s:4:"lien";s:35:"http://trad.spip.net/auteur/abelass";}}s:2:"eu";a:1:{i:0;a:2:{s:3:"nom";s:7:"otalazt";s:4:"lien";s:35:"http://trad.spip.net/auteur/otalazt";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:5:"fr_tu";a:2:{i:0;a:2:{s:3:"nom";s:8:"beatnick";s:4:"lien";s:36:"http://trad.spip.net/auteur/beatnick";}i:1;a:2:{s:3:"nom";s:7:"abelass";s:4:"lien";s:35:"http://trad.spip.net/auteur/abelass";}}s:5:"pt_br";a:1:{i:0;a:2:{s:3:"nom";s:13:"Ricardo Porto";s:4:"lien";s:41:"http://trad.spip.net/auteur/ricardo-porto";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '3673b210348f4f671649904cda925559'),
(486, 488, 'TRADRUB', 'http://files.spip.org/spip-zone/tradrub_dev.png', '003.001.000', '1.0.0', '[3.0.0-alpha2;[', '3.0,3.1', '<multi>\n[en]This plugin adds a system inspired by the translations of articles: it adds a field <code>id_trad</code> to the sections database table and then links the translations of the sections.\n[fr]Ce plugin rajoute un syst�me inspir� par celui des traductions des articles : il ajoute un champ id_trad à la table rubriques et lie ainsi les traductions des rubriques.\n[nl]Deze plugin voegt een vertaling systeem toe die gelijkaardig is met die van de artikels: het brengt een id_trad veld in de "rubriques" tabel en linkt hierdoor de vertalingen van de rubrieken.\n[ru]плагин ѿеализѿеѿ ѿакие возможносѿи по оѿганизаѿии пеѿеводов сѿаѿей как и аналогиѿнѿй всѿѿоеннѿй ѿѿнкѿионал для сѿаѿей. пн добавляеѿ поле <code>id_trad<code> в ѿаблиѿѿ ѿазделов в базе даннѿѿ сайѿа.\n[sk]Tento zásuvný modul pridáva syst�m inšpirovaný prekladom článkov: pridáva pole id_trad do tabuľky rubriky a odkazy, ako aj preklady rubrík.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:20:"http://magraine.net/";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:30:"Logo de Jakub ''jimmac'' Steiner";s:3:"url";s:51:"http://people.freedesktop.org/~jimmac/icons/#oxygen";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', '', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-09 12:00:03', '2012-09-09 12:00:03', 1, 'tradrub_dev.zip', 9881, '2012-09-09 12:00:04', '_plugins_/tradrub/trunk', 'a:1:{s:14:"paquet-tradrub";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"nl";a:1:{i:0;a:2:{s:3:"nom";s:5:"Suske";s:4:"lien";s:33:"http://trad.spip.net/auteur/suske";}}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '3fa9b68c8ca9d181db91eed8f2510663'),
(66, 62, 'CHANGESTATUT', 'http://files.spip.org/spip-zone/change_statut.png', '000.003.000', '0.1', '[2.1.0;3.0.99]', '2.1,3.0', '<multi>\n[fr]Changer temporairement et d\'un clic son statut de webmestre en administrateur ou r�dacteur. Puis revenir �  la situation originale.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"Yffic";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Change-Statut', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-02-08 17:00:14', '2012-02-08 17:00:14', 1, 'change_statut.zip', 12662, '2012-02-08 17:00:16', '_plugins_/change_statut', 'a:1:{s:12:"changestatut";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '0b8d984152ad4451e77d56285c55d99e'),
(67, 63, 'CHANTS', 'http://files.spip.org/spip-zone/chants.png', '000.009', '0.7.6', '[3.0.0-dev;[', '3.0,3.1', '<multi>\n[fr]Ce plugin permet de r�f�rencer des chants (paroles, auteurs, tempo, etc.) sur la m�ªme structure qu''<a href=''http://www.opensong.org/''>OpenSong</a>.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:11:"Teddy Payet";s:3:"url";s:26:"http://www.teddypayet.com/";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:15:"The NounProject";s:3:"url";s:48:"http://thenounproject.com/noun/music/#icon-No928";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Plugin-Chants', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.23.0;]";}s:7:"zippeur";a:2:{s:3:"nom";s:7:"zippeur";s:13:"compatibilite";s:8:"[1.5.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-03-13 22:00:49', '2012-03-13 22:00:49', 1, 'chants.zip', 52839, '2012-03-13 22:00:54', '_plugins_/chants/branches/v_0_9/trunk_tmp', 'a:1:{s:5:"chant";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '73fb8e2ea9d188951ca30d45df8a85db'),
(68, 64, 'CHESS', 'http://files.spip.org/spip-zone/chess.png', '000.009.004', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', '<multi>\n[en]This plugin allows to read chess games on line with their PGN file.\n  To insert the widget you have just to write in your article the tag <chessXX> where XX is the number of the article, then upload the PGN files.\n[fr]Ce plugin est destin� �  lire en ligne des parties d''�checs gr�¢ce �  des fichiers PGN.  \n  Il suffit d\'ins�rer dans un article la balise <chessXX> o�¹ XX est le num�ro de l''article et de t�l�charger les documents PGN.\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:18:"S�bastien Boureux";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:16:"Jacques Bouthier";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:20:"Patrice Vanneufville";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:60:"script original de Alf Magne Kalleland owner of DHTMLGoodies";s:3:"url";s:27:"http://www.dhtmlgoodies.com";}}', '', '', 'http://www.spip-contrib.net/Plugin-Chess', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:3:"cfg";a:2:{s:3:"nom";s:3:"cfg";s:13:"compatibilite";s:8:"[1.0.6;]";}}}}', '2012-08-27 05:00:02', '2012-08-27 05:00:02', 1, 'chess.zip', 358142, '2012-08-27 05:00:04', '_plugins_/chess', 'a:1:{s:5:"chess";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"es";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '52df235b2b6a84e8ca408e336f380e5e'),
(69, 65, 'CHOSEN', 'http://files.spip.org/spip-zone/chosen.png', '001.000.004', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en][Chosen->http://harvesthq.github.com/chosen/] is a JavaScript library that enhances the user experience of selectors in HTML forms.\n\nThe CSS class <code>chosen</code> on a <code><select></code> automatically load Chosen above.\n[fr][Chosen->http://harvesthq.github.com/chosen/] est une librairie JavaScript qui am�liore l''exp�rience utilisateur des s�lecteurs dans les formulaires HTML.\n\nLa classe CSS <code>chosen</code> sur un <code><select></code> chargera automatiquement Chosen dessus.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:19:"Marcillaud Matthieu";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:2:{i:1;a:2:{s:3:"nom";s:16:"IconBlock (logo)";s:3:"url";s:21:"http://iconblock.com/";}i:2;a:2:{s:3:"nom";s:23:"Patrick Filler (Chosen)";s:3:"url";s:35:"http://harvesthq.github.com/chosen/";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-25 00:00:44', '2012-08-25 00:00:44', 1, 'chosen.zip', 45896, '2012-08-25 00:00:44', '_plugins_/chosen', 'a:2:{s:6:"chosen";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:13:"paquet-chosen";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '09e538669dce641f65c41f5067835f08'),
(70, 66, 'CLOUDZOOM', 'http://files.spip.org/spip-zone/cloudzoom.png', '002.000.001', '', '[2.0.9;3.0.*]', '2.0,2.1,3.0', '', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"Yves Costiou";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:15:"Professor Cloud";s:3:"url";s:26:"http://professorcloud.com/";}}', '', '', 'http://www.spip-contrib.net/cloudzoom', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-04-14 11:00:03', '2012-04-14 11:00:03', 1, 'cloudzoom.zip', 46120, '2012-04-14 11:00:04', '_plugins_/cloudzoom', 'a:1:{s:9:"cloudzoom";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '82b1dae12e58faede2fbb559ab880102'),
(71, 67, 'COLORATION_CODE', 'http://files.spip.org/spip-zone/coloration_code_pour_spip_2_0.png', '000.006.006', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\n[en]You just have to put it between the tags:\n_ {{&lt;code class="language"&gt;...&lt;/code&gt;}}\n_ or with a frame\n_ {{&lt;cadre class="langage"&gt;...&lt;/cadre&gt;}}.\n\nThe possible languages are the ones supported by [->http://sourceforge.net/projects/geshi/] with an extra class: "spip".\n\n\nBy default, when the highlighted code has more than one line, il will be put in cache as text and proposed to upload. This feature may be controlled globaly through the constant PLUGIN_COLORATION_CODE_TELECHARGE default true. It may also be forced locally by adding a class "sans_telechargement" in a way or "chargement" in the other as\n_ {{&lt;code class="php sans_telechargement"&gt;}}\n\nYou may also use {coloration_code_color} as a filter in a squelette as \n_ <code>#TEXTE**|coloration_code_color{spip,code}</code>: highlights #TEXTE with langage "spip" in format code (without frame), see example lecode.html. From article url would be <code>#URL_SITE_SPIP/spip.php?page=lecode&id_article=#ENV{id_article}</code>\n[fr]Il suffit de mettre le code entre\n_ {{&lt;code class="langage"&gt;...&lt;/code&gt;}}\n_ ou avec un cadre\n_ {{&lt;cadre class="langage"&gt;...&lt;/cadre&gt;}}.\n\nLes langages support�s sont ceux fournis par [->http://sourceforge.net/projects/geshi/] avec une classe supplementaire: "spip".\n\n\nPar d�faut, si le code mis en surbrillance fait plus d\'une ligne, il est mis en cache sous forme textuelle et propos� au t�l�chargement. Ce fonctionnement est control� globalement par une constante PLUGIN_COLORATION_CODE_TELECHARGE d�faut true. Il peut �ªtre forc� localement en rajoutant la classe "sans_telechargement" dans un sens ou "chargement" dans l''autre comme\n_ {{&lt;code class="php sans_telechargement"&gt;}}\n\nVous pouvez aussi utiliser le filtre {coloration_code_color} dans un squelette comme\n_ <code>#TEXTE**|coloration_code_color{spip,code}</code> : colore #TEXTE avec le language spip en format code (sans cadre), voir exemple lecode.html. L''url depuis l''article serait <code>#URL_SITE_SPIP/spip.php?page=lecode&id_article=#ENV{id_article}</code>\n[it]Dovete solo utilizzare il segnaposto:\n_ {{&lt;code class="linguaggio"&gt;...&lt;/code&gt;}}\n_ o con riquadro\n_ {{&lt;cadre class="linguaggio"&gt;...&lt;/cadre&gt;}}\n\nSono supportati tutti i linguaggi di [->http://sourceforge.net/projects/geshi/] ed in aggiunta la classe "spip".\n\nIn maniera predefinita, Se il codice da colorare ha pi�¹ di una linea, sar�  salvato in cache sotto forma di testo semplice e disponibile per lo scaricamento. Questa impostazione pu�² essere modificata globalmente grazie alla costante PLUGIN_COLORATION_CODE_TELECHARGE, che normalmente � impostata a true. Quest''ultima pu�² anche essere modificata localmente aggiugendo la classe "sans_telechargement" o "chargement", es:\n_ {{&lt;code class="php sans_telechargement"&gt;}}\n\n_ Potete utilizzare {coloration_code_color} anche come un filtro in scheletro in questo modo: \n_ <code>#TEXTE**|coloration_code_color{spip,code}</code>: colora #TEXTE con le regole del linguaggio "spip" in formato code (senza il riquadro), vedi l''esempio lecode.html. L''url per vedere il codice dell''articolo dalla sua stessa pagina sar�¡: <code>#URL_SITE_SPIP/spip.php?page=lecode&id_article=#ENV{id_article}</code>\n[sk]Jednoducho dajte k�³d do\n_ {{&lt;code class="langage"&gt;...&lt;/code&gt;}}\n_ alebo do r�¡mu\n_ {{&lt;cadre class="langage"&gt;...&lt;/cadre&gt;}}.\n\nPodporovan� jazyky s�º tie, ktor� pon�ºka [->http://sourceforge.net/projects/geshi/] sÿ doplnkovou triedou: "spip".\n\n\nAk je podÿ¾a predvolen�½ch nastaven�­ k�³d zv�½raznen�½ viac ako jednou ÿiarou, je keÿ¡ovan�½ voÿ forme textu aÿ je kÿ dispoz�­cii na stiahnutie.  Cel�º t�ºto oper�¡ciu glob�¡lne ovl�¡da  konÿ¡tanta PLUGIN_COLORATION_CODE_TELECHARGE vÿ predvolen�½ch nastaveniach nastaven�¡ na hodnotu "true". Zv�½raznenie m�´ÿ¾e byÿ¥ lok�¡lne vyn�ºten� pridan�­m triedy "sans_telechargement" (= bezÿ stiahnutia) na jednej strane alebo pre "nahr�¡vanie" na strane druhej\n_ {{&lt;code class="php sans_telechargement"&gt;}}\n\nM�´ÿ¾ete tieÿ¾ vyuÿ¾iÿ¥ filter {coloration_code_color} vÿ ÿ¡abl�³ne, ako\n_ <code>#TEXTE**|coloration_code_color{spip,code}</code>:  colore #TEXTE s jazykom spip voÿ form�¡te k�³du (bezÿ r�¡mu), pozrite si pr�­klad lecode.html. Internetov�¡ adresa pre ÿl�¡nok by bola <code>#URL_SITE_SPIP/spip.php?page=lecode&id_article=#ENV{id_article}</code>\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:25:"Pierre Andrews (Mortimer)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"ARNO*";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Coloration-Code,2938', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-12 21:01:04', '2012-08-12 21:01:04', 1, 'coloration_code_pour_spip_2_0.zip', 807658, '2012-08-12 21:01:04', '_plugins_/coloration_code/branches/v0.6', 'a:1:{s:22:"paquet-coloration_code";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.org/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'a3e93f91d97f57f6f422b0586d937573'),
(72, 68, 'COLORIAGEDIST', 'http://files.spip.org/spip-zone/coloriage_dist.png', '000.005.001', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', 'Permet de modifier les couleurs de l''habillage par d�faut (squelette dist) du site SPIP via une interface graphique sans avoir �  �diter le code', 'a:2:{i:0;a:3:{s:3:"nom";s:9:"erational";s:3:"url";s:24:"http://www.erational.org";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:48:"le module de choix de couleur par Steven Wittens";s:3:"url";s:30:"http://acko.net/dev/farbtastic";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Plugin-pour-colorier-la-dist', '', '', 'experimental', 1, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-12-19 11:00:06', '2011-12-19 11:00:06', 1, 'coloriage_dist.zip', 26163, '2011-12-19 11:00:08', '_plugins_/coloriage_dist', 'a:1:{s:13:"coloriagedist";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"it";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '594270f8c7d98faba763c326d3efec86'),
(73, 69, 'COLORSCOPE', 'http://files.spip.org/spip-zone/colorscope.png', '000.004.002', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[fr]Remplace les codes hexa des couleurs dans un texte SPIP, par un bloc de la dite couleur, en conservant son code �  l''int�rieur.\r\n		[en]Replaces hexadecimal color codes in a SPIP text, with a bloc with the relevant color in background, mentionning its hexa code.\r\n		</multi>', 'a:1:{i:0;a:3:{s:3:"nom";s:27:"Cyril MARION (Ateliers CYM)";s:3:"url";s:17:"http://www.cym.fr";s:4:"mail";s:0:"";}}', '', 'a:2:{i:0;a:2:{s:3:"nom";s:12:"ÿ© 2010-2011";s:3:"url";s:0:"";}i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Colorscope', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-12-22 14:00:03', '2011-12-22 14:00:03', 1, 'colorscope.zip', 14872, '2011-12-22 14:00:04', '_plugins_/colorscope', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '53296b58dd983292c453b7fdb4e1462d'),
(501, 498, 'COMMENTS', 'http://files.spip.org/spip-zone/comments-300.png', '003.002.000', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]ATTENTION, VERSION EN DEVELOPPEMENT, POUR SPIP�3�!<br />Affichage des messages en liste, fa�on commentaires de blog, avec formulaire simplifi�. Commentaires microformat�s, nomenclature homog�ne.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"romy.tetue.net";s:3:"url";s:21:"http://romy.tetue.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:0:"";}}', 'a:1:{i:1;s:9:"2009-2012";}', 'http://contrib.spip.net/3860', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:5:"forum";a:2:{s:3:"nom";s:5:"forum";s:13:"compatibilite";s:8:"[1.7.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:3:{s:13:"notifications";a:2:{s:3:"nom";s:13:"notifications";s:13:"compatibilite";s:8:"[2.2.1;]";}s:4:"Zpip";a:2:{s:3:"nom";s:4:"Zpip";s:13:"compatibilite";s:3:"[;]";}s:1:"Z";a:2:{s:3:"nom";s:1:"Z";s:13:"compatibilite";s:3:"[;]";}}}}', '2012-09-20 16:00:09', '2012-09-20 16:00:09', 1, 'comments-300.zip', 47168, '2012-09-20 16:00:16', '_plugins_/comments/trunk', 'a:1:{s:8:"comments";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:11:{s:3:"ast";a:1:{i:0;a:1:{s:3:"nom";s:5:"xuacu";}}s:2:"ca";a:0:{}s:2:"de";a:0:{}s:2:"en";a:1:{i:0;a:1:{s:3:"nom";s:6:"paolo2";}}s:2:"es";a:0:{}s:2:"fa";a:0:{}s:5:"fr_tu";a:1:{i:0;a:1:{s:3:"nom";s:8:"beatnick";}}s:2:"it";a:0:{}s:2:"pt";a:0:{}s:5:"pt_br";a:1:{i:0;a:1:{s:3:"nom";s:6:"rporto";}}s:2:"sk";a:1:{i:0;a:1:{s:3:"nom";s:4:"jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd9df7aae47689be10a4574d9f175b5c6'),
(502, 499, 'COMPOSITIONS', 'http://files.spip.org/spip-zone/compositions_v3.png', '003.003.000', '0.5.0', '[3.0.0-dev;3.0.*]', '3.0', '<multi>\n[en]This plugin allows you to define several variants of compositions for each kind of SPIP objects (article, sections, etc..) and to easily apply them, case by case, from the private area.\n[fr]Ce plugin vous permet de d�finir plusieurs variantes de compositions pour chaque type objet SPIP (article, rubrique, etc.) et de les appliquer simplement, cas par cas, depuis l''espace priv�.\n[ru]���� ������ ��������� ��� �������� ������������ ������ ������ ��� ����������� �������, ������ � �.�. \n[sk]Tento z�suvn� modul v�m umo��uje definova� nieko�ko variantov rozmiestnenia pre ka�d� typ objektu SPIPu (�l�nok, rubrika, at�.) a�jednoducho ho rad radom pou�i� zo�s�kromnej z�ny.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"Cedric Morin";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2007-2012";}', 'http://www.spip-contrib.net/?article3777', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:3:{s:1:"Z";a:2:{s:3:"nom";s:1:"Z";s:13:"compatibilite";s:9:"[1.7.10;[";}s:5:"Zcore";a:2:{s:3:"nom";s:5:"Zcore";s:13:"compatibilite";s:12:"[2.0.0-dev;[";}s:4:"Zpip";a:2:{s:3:"nom";s:4:"Zpip";s:13:"compatibilite";s:12:"[2.0.0-dev;[";}}}}', '2012-09-22 21:00:03', '2012-09-22 21:00:03', 1, 'compositions_v3.zip', 38858, '2012-09-22 21:00:08', '_plugins_/compositions/trunk', 'a:2:{s:12:"compositions";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:19:"paquet-compositions";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '3ebc6e73c0d2b270b5972640848af471'),
(485, 487, 'TIPAFRIEND', 'http://files.spip.org/spip-zone/tipafriend_s3.png', '001.006.002', '', '[3.0.0-beta;[', '3.0,3.1', '<multi>\n[fr]Ce plugin propose un formulaire complet pour envoyer une page d\'un site SPIP ({n''importe laquelle}) à une liste d\'adresses e-mail.\n\nIl s''utilise en plaçant la balise {{#TIPAFRIEND}} dans vos squelettes ; le formulaire apparaît en fenêtre popup par d�faut, mais peut être int�gr� en div type {{thickbox}} ({plugin SPIP}) via le panneau de configuration accessible depuis la partie priv�e de SPIP.\n\nUne documentation interne est disponible lorsque le plugin est actif sur la page publique [tipafriend_documentation->../?page=tipafriend_documentation].\n\nLogo et certaines images du plugin : [->http://pixel-mixer.com/]\n[sk]Tento zásuvný modul ponúka kompletný formulár na poslanie ({akejkoľvek}) stránky v SPIPe priateľom, ktorých máte v zozname e-mailových adries.\n\nPoužíva sa tak, že do svojich šablón umiestnite tag  {{#TIPAFRIEND;}} podľa predvolených nastavení sa formulár zobrazí vo vyskakovacom okne, ale m�žete ho dať do divu typu {{thickbox}} ({zásuvn�ho modulu SPIPu}) cez Ovládací panel, na ktorý sa dostanete zo zásuvn�ho modulu {{[CFG: nastavovacieho nástroja->http://www.spip-contrib.net/?rubrique575]}} ({nepovinn�}).\n\nInterná dokumentácia vám bude k dispozícii, ak zásuvný modul aktivujete na verejne prístupnej stránke [tipafriend_documentation->../?page=tipafriend_documentation].\n\nLogo a niekoľko obrázkov zásuvn�ho modulu: [->http://pixel-mixer.com/]\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"Piero Wbmstr";s:3:"url";s:39:"http://www.spip-contrib.net/PieroWbmstr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article3638', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:7:"facteur";a:2:{s:3:"nom";s:7:"facteur";s:13:"compatibilite";s:6:"[1.5;[";}}}}', '2012-09-15 04:01:04', '2012-09-15 04:01:04', 1, 'tipafriend_s3.zip', 96052, '2012-09-15 04:01:04', '_plugins_/tipafriend/spip_3', 'a:2:{s:17:"paquet-tipafriend";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:10:"tipafriend";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:4:{i:0;a:2:{s:3:"nom";s:4:"Mark";s:4:"lien";s:32:"http://trad.spip.net/auteur/mark";}i:1;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}i:2;a:2:{s:3:"nom";s:11:"PieroWbmstr";s:4:"lien";s:39:"http://trad.spip.net/auteur/pierowbmstr";}i:3;a:2:{s:3:"nom";s:8:"SuperYMS";s:4:"lien";s:36:"http://trad.spip.net/auteur/superyms";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ea48bddac07a0391532bfb33a830dd45'),
(527, 522, 'TAA', 'http://files.spip.org/spip-zone/traduction_articles_autrement_1_0.png', '001.003.004', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Modification de l''interface priv�e de spip afin de donner � l''utilisateur une autre approche de la traductions des articles tout en maintenant le syst�me de traduction original de spip. Pour pouvoir utiliser l''affichage compact des listes d\'articles (option disponible via cfg), il faut installer le plugin [afficher_objets->http://files.spip.org/spip-zone/afficher_objets.zip].\n	 \n	 Les listes compactes fonctionnent maintenant �galement sur un site avec du multilinguisme par section. Il faut pour cela installer le plugin [Traduction entre rubrique->http://files.spip.org/spip-zone/tradrub.zip]\n	 \n	 Et pour pour pouvoir profiter d\'un syst�me de traduction dans le sens du pr�sent plugin, installez en plus le plugin [Traductions rubriques autrement->http://files.spip.org/spip-zone/traduction_rubriques_autrement.zip]. Les boutons de traduction seront affich�s en haut de la rubrique avec la possibilit� de cr�er les traductions manquantes en cliquant sur l''onglet en gris. Le plugin essayera de chercher la rubrique correspondante dans le secteur de la langue, si la rubrique parente est bien traduite.\n[sk]�prava rozhrania s�kromnej z�ny spipu, aby mohol pou��vate� zmeni� pr�stup k�prekladom �l�nkov a�s�asne si ponecha� p�vodn� syst�m spipu na preklad. Na to, aby ste mohli vyu��va� kompaktn� zobrazenie zoznamov �l�nkov (t�to mo�nos� je k�dispoz�cii prostredn�ctvom cfg), mus�te si nai�talova� z�suvn� modul [afficher_objets.->http://files.spip.org/spip-zone/afficher_objets.zip]\n	 \n	 Kompaktn� zoznamy teraz funguj� aj�na str�nke s�viacjazy�n�mi rubrikami. V�tom pr�pade si treba nain�talova� z�suvn� modul [Preklad medzi rubrikami.->http://files.spip.org/spip-zone/tradrub.zip]\n	 \n	 A�aby ste mohli vyu��va� syst�m na preklad, ktor� pon�ka tento z�suvn� modul, nain�talujte si z�suvn� modul [In� preklad rubr�k.->http://files.spip.org/spip-zone/traduction_rubriques_autrement.zip] Tla�idl� prekladu sa zobrazia v�hornej �asti rubriky s�mo�nos�ou vytvori� ch�baj�ce preklady kliknut�m na siv� kartu. Z�suvn� modul sa pok�si n�js� pr�slu�n� rubriku v�sektore pre dan� jazyk, ak je prelo�en� nadraden� rubrika.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Rainer M�ller";s:3:"url";s:23:"http://www.mychacra.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Traductions-d-articles-autrement-3', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-26 16:00:03', '2012-09-26 16:00:03', 1, 'traduction_articles_autrement_1_0.zip', 40268, '2012-09-26 16:00:04', '_plugins_/traduction_articles_autrement/branches/1.0', 'a:2:{s:10:"paquet-taa";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:3:"taa";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:10:{s:3:"ast";a:1:{i:0;a:2:{s:3:"nom";s:5:"Xuacu";s:4:"lien";s:33:"http://trad.spip.net/auteur/xuacu";}}s:2:"ca";a:1:{i:0;a:2:{s:3:"nom";s:5:"merce";s:4:"lien";s:33:"http://trad.spip.net/auteur/merce";}}s:2:"de";a:2:{i:0;a:2:{s:3:"nom";s:14:"Rainer M�ller";s:4:"lien";s:41:"http://trad.spip.net/auteur/rainer-muller";}i:1;a:2:{s:3:"nom";s:7:"abelass";s:4:"lien";s:35:"http://trad.spip.net/auteur/abelass";}}s:2:"en";a:3:{i:0;a:2:{s:3:"nom";s:4:"Mark";s:4:"lien";s:32:"http://trad.spip.net/auteur/mark";}i:1;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}i:2;a:2:{s:3:"nom";s:7:"abelass";s:4:"lien";s:35:"http://trad.spip.net/auteur/abelass";}}s:2:"es";a:1:{i:0;a:2:{s:3:"nom";s:7:"abelass";s:4:"lien";s:35:"http://trad.spip.net/auteur/abelass";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:5:"fr_tu";a:1:{i:0;a:2:{s:3:"nom";s:8:"beatnick";s:4:"lien";s:36:"http://trad.spip.net/auteur/beatnick";}}s:5:"pt_br";a:1:{i:0;a:2:{s:3:"nom";s:13:"Ricardo Porto";s:4:"lien";s:41:"http://trad.spip.net/auteur/ricardo-porto";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ffc4d2aab8d7eefbe88e6c17322a236f'),
(78, 74, 'CONVERTISSEUR', 'http://files.spip.org/spip-zone/convertisseur.png', '000.004.003', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\n[en]Converts various formats (wiki, phpBB) into SPIP format\n[fr]Convertit les formats de type wiki, phpBB, quark xpress tags en format SPIP et vice versa ; int�gre au besoin les textes convertis dans des articles ; on peut uploader plusieurs textes en un seul coup en les zippant au pr�alable\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:9:"erational";s:3:"url";s:24:"http://www.erational.org";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:20:"http://zzz.rezo.net/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Plugin-Convertisseur', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-02-24 03:00:02', '2012-02-24 03:00:02', 1, 'convertisseur.zip', 49672, '2012-02-24 03:00:04', '_plugins_/convertisseur/branches/v1', 'a:1:{s:13:"convertisseur";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'eb64544aa3ab07ad1c45754512baa520'),
(79, 75, 'SPIPIRIS', 'http://files.spip.org/spip-zone/cooliris_spip3.png', '002.000.000', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin permet d\'afficher les images d\'un article avec Cooliris, un mur 3D en flash\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:4:"Phil";s:3:"url";s:7:"http://";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2012-2013";}', 'http://www.spip-contrib.net/Cooliris-pour-SPIP', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-21 19:00:14', '2012-07-21 19:00:14', 1, 'cooliris_spip3.zip', 9913, '2012-07-21 19:00:14', '_plugins_/cooliris/V2', 'a:1:{s:8:"cooliris";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'b9399d6c67597322e66fcbe947984117'),
(80, 76, 'CORBEILLE', 'http://files.spip.org/spip-zone/corbeille_3_0.png', '003.000.001', '', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin permet de d�roger au comportement standard de SPIP qui efface automatiquement certains objets de la base de donn�es (articles, br�ves... �  la poubelle), avec un d�lai d\'un jour ou deux.\r\n\r\nAvec ce plugin, plus aucun objet n\'est supprim� automatiquement. La poubelle garde tous les articles ou autres objets que vous y avez mis, et vous pouvez toujours revenir en arri�re.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:25:"Matthieu Onfray (Japanim)";s:3:"url";s:23:"http://www.japanim.net/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:51:"adapt� en plugin avec tendresse par la communaut�";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2005-2008";}', 'http://www.spip-contrib.net/Corbeille,2855', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-11-04 11:44:04', '2011-11-04 11:44:04', 1, 'corbeille_3_0.zip', 34259, '2011-11-04 12:00:08', '_plugins_/corbeille/trunk', 'a:1:{s:9:"corbeille";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:5:{s:2:"ar";a:0:{}s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"es";a:0:{}s:2:"it";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '353259b52b877919f35f2b725b7d6e0a'),
(82, 78, 'COULEURS_SPIP', 'http://files.spip.org/spip-zone/couleurs_spip3.png', '003.000.000', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin permet de modifier l''apparence de parties de texte. Pour mettre certains mots en couleur ou modifier leur taille ou toute autre caract�ristique typographique, il suffit d\'entourer ceux-ci de balises de type <<code>cs_rouge</code>><cs_rouge>mon texte rouge</cs><<code>/cs</code>>. \r\n	En ajoutant des styles dans le fichier css/couleurs_spip.css - le recopier dans ce cas dans le dossier squelettes utilis� -, on peut ajouter autant de balise qu''on le d�sire.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:17:"Dominique Wojylac";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/spip.php?article3180', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-11 14:00:02', '2012-07-11 14:00:02', 1, 'couleurs_spip3.zip', 5613, '2012-07-11 14:00:04', '_plugins_/couleurs_spip/trunk', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '46d0758147614e76292dc7eaa8d347cc'),
(83, 79, 'COURTCIRCUIT', 'http://files.spip.org/spip-zone/court-circuit2.png', '002.003.003', '', '[2.1.0;3.0.99]', '2.1,3.0', '<multi>\n[en]Allows to redirect certain sections to a specific article. You can configure in the private area, the redirection rules to apply.\n[fr]Permet de rediriger certaines rubriques vers un article particulier. Vous pouvez configurer, dans l''espace priv�, les r�gles de redirection � ÿ appliquer.\n[sk]Umoÿ¾ÿ˿uje v�¡m presmerovaÿ¥ niektor� rubriky kÿ urÿit�mu ÿl�¡nku. Vÿ s�ºkromnej z�³ne m�´ÿ¾ete nastaviÿ¥ pravidl�¡ na presmerovanie, ktor� chcete pouÿ¾iÿ¥.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:14:"romy.tetue.net";s:3:"url";s:21:"http://romy.tetue.net";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:34:"http://www.spip-contrib.net/Joseph";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/?article3831', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:1:"Z";a:1:{s:3:"nom";s:1:"Z";}s:12:"compositions";a:1:{s:3:"nom";s:12:"compositions";}}}}', '2012-07-26 13:10:37', '2012-07-26 13:10:37', 1, 'court-circuit2.zip', 42592, '2012-07-26 13:10:38', '_plugins_/court-circuit/trunk', 'a:2:{s:12:"courtcircuit";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:19:"paquet-courtcircuit";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '7168611a4682c351c89dcf65e35aa87b');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(84, 80, 'CK', 'http://files.spip.org/spip-zone/couteau-kiss.png', '001.001.009', '', '[2.0.0;3.0.*]', '2.0,2.1,3.0', '<multi>\n[ast]Simplicit�, efficacit�, l�g�ret�.\n_ Un couteau qui tient vraiment dans la poche en\nune unique page de configuration pour les r�glages cach�s de SPIP.\n[br]Simplicit�, efficacit�, l�g�ret�.\n_ Un couteau qui tient vraiment dans la poche en\nune unique page de configuration pour les r�glages cach�s de SPIP.\n[ca]Simplicit�, efficacit�, l�g�ret�.\n_ Un couteau qui tient vraiment dans la poche en\nune unique page de configuration pour les r�glages cach�s de SPIP.\n[de]Simplicit�, efficacit�, l�g�ret�.\n_ Un couteau qui tient vraiment dans la poche en\nune unique page de configuration pour les r�glages cach�s de SPIP.\n[en]Simplicit�, efficacit�, l�g�ret�.\n_ Un couteau qui tient vraiment dans la poche en\nune unique page de configuration pour les r�glages cach�s de SPIP.\n[es]Simplicit�, efficacit�, l�g�ret�.\n_ Un couteau qui tient vraiment dans la poche en\nune unique page de configuration pour les r�glages cach�s de SPIP.\n[fr]Simplicit�, efficacit�, l�g�ret�.\n_ Un couteau qui tient vraiment dans la poche en\nune unique page de configuration pour les r�glages cach�s de SPIP.\n[gl]Simplicit�, efficacit�, l�g�ret�.\n_ Un couteau qui tient vraiment dans la poche en\nune unique page de configuration pour les r�glages cach�s de SPIP.\n[it]Simplicit�, efficacit�, l�g�ret�.\n_ Un couteau qui tient vraiment dans la poche en\nune unique page de configuration pour les r�glages cach�s de SPIP.\n[nl]Eenvoudigheid, effici�«ntie, lichtheid.\n_ Een mes dat echt in de zak kan met een eenkel configuratie pagina om de verborgen afstellingen van SPIP te beheren.\n[pt_br]Simplicit�, efficacit�, l�g�ret�.\n_ Un couteau qui tient vraiment dans la poche en\nune unique page de configuration pour les r�glages cach�s de SPIP.\n[sk]Jednoduchosÿ¥, efekt�­vnosÿ¥ ÿ¾ahkosÿ¥.\n_ Noÿ¾�­k, ktor�½ je naozaj vo vrecku v unik�¡tnej skrytej str�¡nke s konfigur�¡ciou pre nastavenia SPIPu.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:13:"C�dric MORIN";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Couteau-KISS', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-17 04:01:03', '2012-08-17 04:01:03', 1, 'couteau-kiss.zip', 104847, '2012-08-17 04:01:04', '_plugins_/couteau-kiss', 'a:2:{s:2:"ck";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:9:"paquet-ck";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:12:{s:3:"ast";a:0:{}s:2:"br";a:0:{}s:2:"ca";a:0:{}s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"es";a:0:{}s:2:"fr";a:0:{}s:2:"gl";a:0:{}s:2:"it";a:0:{}s:2:"nl";a:1:{i:0;a:2:{s:3:"nom";s:5:"Suske";s:4:"lien";s:33:"http://trad.spip.net/auteur/suske";}}s:5:"pt_br";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '758ecba1a77257c1d83a0d6e2dfff92c'),
(523, 518, 'SJCYCLE', 'http://files.spip.org/spip-zone/sjcycle_v2.png', '002.002.003', '0.5', '[3.0.0;3.1.*]', '3.0,3.1', '<multi>\n[en]Configurable slideshow for Spip based on [jQuery Cycle->http://malsup.com/jquery/cycle/] plugin. The slide show can be inserted in the text of your articles. The plugin also provides models for example to add a random slide show of images or a slideshow of the syndicated sites in the skeleton ...\n[fr]Diaporama param�trable pour Spip bas� sur le plugin [jQuery Cycle->http://malsup.com/jquery/cycle/]. Le diaporama peut s''ins�rer dans le texte de vos articles. Le plugin fournit �galement des mod�les permettant par exemple d\'ajouter un diaporama al�atoire d\'images ou un diaporama des sites syndiqu�s dans un squelette...\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:11:"Minimalteck";s:3:"url";s:26:"http://www.minimalteck.fr/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"Yffic";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Plugin-Spip-jQuery-Cycle-2', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:8:"[1.9.0;[";}s:4:"YAML";a:2:{s:3:"nom";s:4:"YAML";s:13:"compatibilite";s:8:"[1.4.1;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:7:"aveline";a:2:{s:3:"nom";s:7:"aveline";s:13:"compatibilite";s:8:"[1.7.0;[";}s:7:"palette";a:2:{s:3:"nom";s:7:"palette";s:13:"compatibilite";s:8:"[1.2.2;[";}}}}', '2012-09-25 14:00:54', '2012-09-25 14:00:54', 1, 'sjcycle_v2.zip', 80836, '2012-09-25 14:01:00', '_plugins_/sjcycle/trunk', 'a:2:{s:11:"faq-sjcycle";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}s:7:"sjcycle";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '59faa0f6f777cf4a527f798ec2045b12'),
(524, 519, 'SPIPICIOUS', 'http://files.spip.org/spip-zone/spipicious_jquery.png', '001.001.000', '0.6.2', '[3.0.0;3.0.99]', '3.0', '<multi>\n[en]Help authenticated users to add keywords/tags to objects from the public area.\n_ Keywords are added to a group we can configure (''{{- tags -}}'' by default)\n_ Icon from [Pawel Kadysz->http://oneseventyseven.com/]\n[fr]Permet aux visiteurs authentifi�s d\'ajouter des tags (mots-cl�s) aux diff�rents objets.\n_ Les mots-cl�s sont ajout�s dans un groupe configurable (par d�faut ''{{- tags -}}'')\n_ Icone de [Pawel Kadysz->http://oneseventyseven.com/]\n[sk]Prihl�sen�m n�v�tevn�kom umo��uje prid�va� zna�ky (k��ov� slov�) k�r�znym objektom.\n_ K��ov� slov� sa prid�vaj� do skupiny, ktor� sa d� upravova� (pod�a predvolen�ch nastaven� {{"- tags -"}})\n_ Ikonu vytvoril [Pawel Kadysz->http://oneseventyseven.com/]\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:5:"kent1";s:3:"url";s:21:"http://www.kent1.info";s:4:"mail";s:22:"kent1 AT arscenic.info";}i:2;a:3:{s:3:"nom";s:9:"erational";s:3:"url";s:24:"http://www.erational.org";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2007-2012";}', 'http://kent1.sklunk.net/spip.php?article97', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:3:{s:18:"selecteurgenerique";a:2:{s:3:"nom";s:18:"selecteurgenerique";s:13:"compatibilite";s:8:"[0.8.0;[";}s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:6:"[1.1;[";}s:5:"nuage";a:2:{s:3:"nom";s:5:"nuage";s:13:"compatibilite";s:8:"[3.2.1;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-25 14:00:04', '2012-09-25 14:00:04', 1, 'spipicious_jquery.zip', 50991, '2012-09-25 14:00:04', '_plugins_/spipicious_jquery/trunk', 'a:2:{s:17:"paquet-spipicious";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:10:"spipicious";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:8:{s:3:"ast";a:1:{i:0;a:2:{s:3:"nom";s:5:"Xuacu";s:4:"lien";s:33:"http://trad.spip.net/auteur/xuacu";}}s:2:"ca";a:0:{}s:2:"de";a:0:{}s:2:"en";a:2:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}i:1;a:2:{s:3:"nom";s:4:"Mark";s:4:"lien";s:32:"http://trad.spip.net/auteur/mark";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:5:"fr_tu";a:1:{i:0;a:2:{s:3:"nom";s:8:"beatnick";s:4:"lien";s:36:"http://trad.spip.net/auteur/beatnick";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '9dea9a0addabf226b9fd5b61e61048f3'),
(525, 520, 'GEOPORTAIL', 'http://files.spip.org/spip-zone/spip_geoportail.gif', '002.000', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', 'Ce plugin permet, en utilisant l''API G�oportail (Openlayers), le g�or�f�rencement des objets SPIP et leur affichage dans des cartes G�oportail, OpenStreetMap, Google Maps, Yahoo!...\r\n-* cr�ation d\'une table de GEOPOSITIONS de position pour les objets SPIP\r\n-* formulaire pour la saisie du geopositionnement des objets SPIP (articles, auteurs, etc.)\r\n-* int�gration de geoservices WMS,WFS,...\r\n-* crit�re geoposition pour jointure avec les tables SPIP\r\n\r\nPour visualiser des exemples d\'affichage de carte Geoportail, OSM, Google Maps, Yahoo! ou Bing veuillez vous rendre � l''adresse suivante : [->http://grafreex.free.fr/?-Geoportail-].', 'a:1:{i:0;a:3:{s:3:"nom";s:17:"Jean-Marc Viglino";s:3:"url";s:47:"http://www.spip-contrib.net/_Viglino-Jean-Marc_";s:4:"mail";s:0:"";}}', '', 'a:2:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}i:1;a:2:{s:3:"nom";s:3:"BSD";s:3:"url";s:45:"http://www.freebsd.org/copyright/license.html";}}', '', 'http://www.spip-contrib.net/Plugin-SPIP-Geoportail', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-23 14:00:05', '2012-09-23 14:00:05', 1, 'spip_geoportail.zip', 288125, '2012-09-23 14:00:06', '_plugins_/spip_geoportail', 'a:1:{s:10:"geoportail";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'b79288e3fe87db4101b5dbeced167bef'),
(526, 521, 'THUMBSITES', 'http://files.spip.org/spip-zone/thumbsites.png', '001.000.000', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Thumbsites fournit un syst�me de capture d''�cran de site g�n�r�e par des serveurs d�di�s. Le plugin propose des balises, des filtres et des mod�les pour afficher la vignette d\'un site donn�. Ce plugin g�re aussi un cache qui permet de pallier les indisponibilit�s fr�quentes des serveurs et d\'acc�l�rer les affichages. Une configuration est disponible dans l''espace priv�.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:15:"Camille Lafitte";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:14:"Eric Lupinacci";s:3:"url";s:23:"http://blog.smellup.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2008-2012";}', 'http://www.spip-contrib.net/?article2584', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-24 04:00:33', '2012-09-24 04:00:33', 1, 'thumbsites.zip', 37310, '2012-09-24 04:00:38', '_plugins_/thumbsites/trunk', 'a:1:{s:10:"thumbsites";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:9:{s:3:"ast";a:1:{i:0;a:2:{s:3:"nom";s:5:"Xuacu";s:4:"lien";s:33:"http://trad.spip.net/auteur/xuacu";}}s:2:"ca";a:0:{}s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:5:"fr_tu";a:0:{}s:5:"pt_br";a:1:{i:0;a:2:{s:3:"nom";s:13:"Ricardo Porto";s:4:"lien";s:41:"http://trad.spip.net/auteur/ricardo-porto";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c5f889932caa4cc0c40670b14776fb6f'),
(86, 82, 'CRAYONS', 'http://files.spip.org/spip-zone/crayons.png', '001.013.008', '', '[1.9.0;*]', '', '<multi>\n[ar]ÿ⿡ÿ°ÿ§ ÿ§ÿ⿿ÿ⿦ÿ⿿ÿ­ÿ⿿ÿſ {{ÿ§ÿ⿿ÿ⿦ÿªÿ˿ÿ§ÿÿ± ÿ⿿ÿ⿿ÿ§ÿµÿ¯ÿ§ÿ± ÿ¡.ÿ©.ÿ¢ ÿÿ⿿ÿ·}} ÿŠÿ⿿ÿ¯ÿ⿦ ÿ˿ÿ¸ÿ§ÿ¦ÿ ÿªÿ­ÿ±ÿŠÿ± ÿ³ÿ±ÿŠÿ¹ÿ© ÿ⿦ÿ⿠ ÿÿŠ ÿµÿÿ­ÿ§ÿª ÿ§ÿ⿿ÿ⿦ÿ˿ÿ⿿ÿ¹ ÿ§ÿ⿿ÿ¹ÿ⿦ÿ˿ÿ⿦ÿŠ. ÿ⿿ÿ⿿ÿ§ÿ³ÿªÿÿ§ÿ¯ÿ© ÿ⿦ÿ⿠ÿ⿡ ÿŠÿ¬ÿ¨ ÿ§ÿ⿠ÿ´ÿ§ÿ¡ ÿµÿÿ­ÿ§ÿª ÿ⿠ÿ⿦ÿ˿ÿ°ÿ¬ÿŠÿ© ÿ⿦ÿªÿ˿ÿ§ÿÿ⿿ÿ© ÿ⿦ÿ¹ÿ⿡.\n\nÿƿÿ⿦ÿ§ ÿÿŠ ÿµÿÿ­ÿ§ÿª ÿ§ÿ⿿ÿ§ÿµÿ¯ÿ§ÿ± 1.9.2 ÿ§ÿ⿿ÿ⿠ÿ⿦ÿ˿ÿ°ÿ¬ÿŠÿ© ÿŠÿƿÿÿŠ ÿ§ÿ¯ÿ®ÿ§ÿ⿿ ÿ¹ÿ⿿ÿ§ÿ⿦ÿ© {#EDIT} ÿÿŠ ÿƿÿ⿿ ÿ⿦ÿƿÿ§ÿ⿠ ÿ⿠ÿ±ÿŠÿ¯ ÿªÿ­ÿ±ÿŠÿ±ÿ⿡. ÿ⿦ÿ«ÿ⿿ÿ§ÿ⿹ÿſ ÿ⿿ÿŠÿµÿ¨ÿ­ ÿ§ÿ⿿ÿ¹ÿ⿠ÿ˿ÿ§ÿ⿠ ÿ⿿ÿ§ÿ¨ÿ⿿ ÿ⿿ÿ⿿ÿªÿ­ÿ±ÿŠÿ±:\n_ <code><h1 class="#EDIT{titre} ÿ¹ÿ⿿ÿ§ÿ⿦ÿ§ÿª ÿ§ÿ®ÿ±ÿ⿰">#TITRE</h1></code>.\n[de]�⿿nderungen in �¶ffentlichen Seiten direkt erledigen, Vorausetzung f�¼r Wikis mit SPIP\n[en]Quick editing from the public pages of the site.\n[fr]�⿰dition rapide depuis les pages publiques du site.\n[it]Modifica rapida dalle pagine pubbliche del sito.\n[nl]Snel bewerken van de publieke pagina''s van de site.\n[ru]ÐŸÐ¾Ð·Ð²Ð¾Ð»ÿÐµÿ⿿ ÿ⿬ÐµÐ´Ð°Ðºÿ⿿Ð¸ÿ⿬Ð¾Ð²Ð°ÿ⿿ÿſ Ð¸Ð½ÿ⿿Ð¾ÿ⿬Ð¼Ð°ÿ⿠Ð¸ÿŽ Ð¿ÿ⿬ÿÐ¼Ð¾ Ð½Ð° ÿÐ°Ð¹ÿ⿿Ðµ, Ð½Ðµ Ð·Ð°ÿ⿦Ð¾Ð´ÿ Ð² Ð°Ð´Ð¼Ð¸Ð½Ð¸ÿÿ⿿ÿ⿬Ð°ÿ⿿Ð¸Ð²Ð½ÿƿÿŽ ÿ⿡Ð°ÿÿ⿿ÿſ.\n[sk]R�½chle �ºpravy zÿ verejne pr�­stupnej str�¡nky.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"toggg";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Les-Crayons', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-17 04:01:14', '2012-08-17 04:01:14', 1, 'crayons.zip', 218183, '2012-08-17 04:01:14', '_plugins_/crayons', 'a:2:{s:7:"crayons";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:13:{s:3:"ast";a:1:{i:0;a:2:{s:3:"nom";s:5:"Xuacu";s:4:"lien";s:33:"http://trad.spip.net/auteur/xuacu";}}s:2:"ca";a:0:{}s:2:"de";a:0:{}s:2:"en";a:2:{i:0;a:2:{s:3:"nom";s:5:"Paolo";s:4:"lien";s:33:"http://trad.spip.net/auteur/paolo";}i:1;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:1:{i:0;a:2:{s:3:"nom";s:6:"severo";s:4:"lien";s:34:"http://trad.spip.net/auteur/severo";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:5:"fr_tu";a:1:{i:0;a:2:{s:3:"nom";s:8:"beatnick";s:4:"lien";s:36:"http://trad.spip.net/auteur/beatnick";}}s:2:"it";a:1:{i:0;a:2:{s:3:"nom";s:3:"Fil";s:4:"lien";s:31:"http://trad.spip.net/auteur/fil";}}s:2:"nl";a:2:{i:0;a:2:{s:3:"nom";s:7:"mpossoz";s:4:"lien";s:35:"http://trad.spip.net/auteur/mpossoz";}i:1;a:2:{s:3:"nom";s:5:"Suske";s:4:"lien";s:33:"http://trad.spip.net/auteur/suske";}}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}s:2:"zh";a:0:{}}}s:14:"paquet-crayons";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:8:{s:2:"ar";a:0:{}s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"nl";a:1:{i:0;a:2:{s:3:"nom";s:5:"Suske";s:4:"lien";s:33:"http://trad.spip.net/auteur/suske";}}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'fc8e8f1a0bd6ec24cb3d70a5c6f4cf20'),
(87, 83, 'CRITERE_MOTS', 'http://files.spip.org/spip-zone/critere_mots2.png', '002.000.000', '', '[3.0.0-dev;3.0.99]', '3.0', '<multi>\n[fr]Permet d\'afficher les �l�ments qui ont plusieurs mots cl�s en communs, via la variable $mots[] pass�e dans l''environnement\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:17:"Ma�¯eul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:20:"RealET (Formulaires)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:4:"2009";}', 'http://www.spip-contrib.net/Critere-mots', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-01 14:00:11', '2012-08-01 14:00:11', 1, 'critere_mots2.zip', 9319, '2012-08-01 14:00:14', '_plugins_/critere_mots/trunk', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '963a8c36c62792ffbd9862a44995bd2f'),
(88, 84, 'SUIVANT_PRECEDENT', 'http://files.spip.org/spip-zone/criteres_suivant_precedent.png', '001.003.002', '', '[2.1;3.0.99]', '2.1,3.0', '<multi>\n[en]This plugin is an experiment allowing to find in a given loop, the next or previous item. This usage is primarily useful when creating navigation by category or by topic (keywords).\n[fr]Ce plugin est une exp�rimentation permettant de trouver, dans une boucle donn�e, l\'�l�ment suivant ou l\'�l�ment pr�c�dent. Cet usage est principalement utile pour cr�er des navigations par rubrique ou par th�me (mots-cl�s).\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Criteres-precedent-et-suivant', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-27 04:00:17', '2012-08-27 04:00:17', 1, 'criteres_suivant_precedent.zip', 73719, '2012-08-27 04:00:18', '_plugins_/criteres_suivant_precedent', 'a:1:{s:17:"suivant_precedent";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/ÿ¬ÿ˿ÿ±ÿ¬-ÿ⿿ÿ⿠ÿ¯ÿ⿿ÿÿª";}}s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '34fa2637f0dff5ea31ad36a96e872b55'),
(89, 85, 'CSS_IMBRIQUES', '', '003.000.001', '', '[3.0.0;3.*]', '', '', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"ARNO*";s:3:"url";s:29:"http://www.paris-beyrouth.org";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:8:"GNU/LGPL";s:3:"url";s:37:"http://www.gnu.org/licenses/lgpl.html";}}', '', 'http://www.paris-beyrouth.org/tutoriaux-spip/article/plugin-spip-pre-processeur-de-css', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-22 13:00:03', '2012-08-22 13:00:03', 1, 'css_imbriques.zip', 22353, '2012-08-22 13:00:04', '_plugins_/css_imbriques', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '5116035b10f08bc4573834db386e0f70'),
(482, 485, 'BIBLE', 'http://files.spip.org/spip-zone/spip-bible.jpg', '004.000.000', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Le plugin Spip-Bible permet de citer rapidement des extraits de la Bible dans le texte d⿿un article. Sous SPIP 2.0 avec SPIP-Bonux, propose un "presse-papier" biblique à c�t� des formulaires d''�ditions. Vous pouvez aussi utilisez un mod�le, mais cette m�thode est d�su�te et d�conseill�e.\r\n\r\nEx : <code><bible|passage=Gn1,2-2,1></code> citera la Gen�se du chapitre 1, verset 2 au chapitre 2, verset 1 inclu.\r\n\r\nOn peut passer des options au mod�le. La valeur des options est "non" ou "oui", sauf pour traduction.\r\n\r\nCes options sont :\r\n-* numeros : Pour afficher les num�ros de versets et de chapitre dans le corps de texte.\r\n-* retour : Pour faire des retours chariots entre les versets\r\n-* ref : Pour afficher les r�f�rences à la suite du passage\r\n-* traduction : Pour choisir la traduction.\r\n\r\nLa liste des traductions disponibles est sur [Spip-Contrib->http://www.spip-contrib.net/Spip-Bible-traductions-disponibles]\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:17:"Maïeul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:29:"Teddy Payet (Auteur associ�)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:31:"Cerdic (Id�e du presse-papier)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Spip-Bible,1125', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:9:"querypath";a:1:{s:3:"nom";s:9:"querypath";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-07 11:00:16', '2012-09-07 11:00:16', 1, 'spip-bible.zip', 237928, '2012-09-07 11:00:26', '_plugins_/spip-bible/trunk', 'a:1:{s:5:"bible";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '90992d3f8a310547225cf28787f3d2f0'),
(483, 234, 'SPIP_BONUX', 'http://files.spip.org/spip-zone/spip-bonux-3.png', '003.000.003', '', '[3.0.0-dev;3.1.*]', '3.0,3.1', '<multi>\n[ar]اٿٿٿحٿ اٿذٿ ٿجعٿ SPIP أٿثر بٿاضاٿ ٿٿ SPIPؿ ٿٿٿدٿ ٿداٿا ٿٿتعة!\nجداٿٿؿ عداداتؿ اٿخ.\n[en]The plugin that make SPIP better than SPIP, with nice gifts inside !\n	arrays, counter, etc.\n[fr]Le plugin qui lave plus SPIP que SPIP, avec des chouettes cadeaux dedans !\n	Tableaux, compteur, etc.\n[ru]SPIP Bonux необѿодим для ѿабоѿѿ многиѿ дѿѿгиѿ плагинов. пн сѿѿесѿвенно ѿасѿиѿяеѿ возможносѿи SPIP, делая его лѿѿѿе ѿем SPIP :)))\n[sk]Zásuvný modul, ktorý prečistí SPIP ako SPIP s peknými darčekmi vnútri!\n	Tabuľky, počítadlo, a i.\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:12:"Cedric Morin";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:14:"romy.tetue.net";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2008-2011";}', 'http://www.spip-contrib.net/SPIP-Bonux', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-06 12:00:43', '2012-09-06 12:00:43', 1, 'spip-bonux-3.zip', 99510, '2012-09-06 12:00:44', '_plugins_/spip-bonux-3', 'a:2:{s:17:"paquet-spip_bonux";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/جٿرج-ٿٿدٿفت";}}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:6:"Gilles";s:4:"lien";s:34:"http://trad.spip.net/auteur/gilles";}}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:10:"spip_bonux";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"ar";a:0:{}s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'a43fdf4315267a6ea0d575db093840dc'),
(91, 87, 'DATE_INSCRIPTION', '', '000.001.001', '0.1', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\n	[fr] Un champ suppl�mentaire pour la table auteurs : date_inscription\n	[en] An additional field on authors table: date_inscription (registration date)\n	[es] Un nuevo campo en la table de autores: date_inscription (fecha de inscripci�³n)\n	</multi>', 'a:1:{i:0;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Date-d-inscription', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-27 12:00:02', '2012-07-27 12:00:02', 1, 'date_inscription.zip', 3874, '2012-07-27 12:00:04', '_plugins_/date_inscription', 'a:1:{s:16:"date_inscription";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"es";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'b278dd619711fbd9fa81b350c41d1e8b'),
(92, 88, 'DEBUT_FIN', '', '001.000', '0.1.0', '[2.1.0;]', '2.1,3.0,3.1', 'Ajoute deux champs aux articles: #AGENDA (0 ou 1), #DATE_DEBUT et #DATE_FIN.', 'a:1:{i:0;a:3:{s:3:"nom";s:5:"ARNO*";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-01-12 05:00:02', '2012-01-12 05:00:02', 1, 'debut_fin.zip', 24685, '2012-01-12 05:00:04', '_plugins_/debut_fin', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'b5cb362ee448655e53dd2058544706b7'),
(94, 90, 'DIDA', '', '002.009.001', '', '', '', 'Ce plugin sert �  int�grer facilement un projet didapages dans un article spip. Il n�cessite le plugin [cfg->http://www.spip-contrib.net/Config-cfg]. Ce plugin fonctionne avec spip 2.\r\n	\r\nCe que permet le plugin Didaspip : \r\n-* importer et supprimer des projets r�alis�s avec didapages 1\r\n-* afficher les projets dans les articles\r\n\r\nDans l''interface de gestion le menu �dition vous permettra d\'acc�der �  la gestion des projets didapages qui auront pr�alablement �t� compress� au format zip. L''installation des projets se fait dans le r�pertoire IMG/didapages/monprojet du site.\r\n\r\nPour cr�er le lien vers un projet didapages dans votre article, il suffit de mettre ensuite le code suivant : {{didapages}}{{@monprojet}}{{@}}.\r\n_ Le plugin ["thickbox"->http://www.spip-contrib.net/Plugin-Thickbox] n''est pas obligatoire mais peut-�ªtre utilis� selon l''affichage choisi.', 'a:1:{i:0;a:3:{s:3:"nom";s:15:"Mo�¯se Maindron";s:3:"url";s:0:"";s:4:"mail";s:34:"mailto:moise.maindron@ac-nantes.fr";}}', '', '', '', 'http://www.spip-contrib.net/Didaspip', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{i:0;a:4:{s:2:"id";s:3:"CFG";s:3:"nom";s:3:"CFG";s:7:"version";s:6:"[1.0;]";s:13:"compatibilite";s:6:"[1.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-18 12:00:03', '2012-06-18 12:00:03', 1, 'didaspip.zip', 174811, '2012-06-18 12:00:06', '_plugins_/didaspip', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'a827b07de52fd651ec0cc5c64e978a12'),
(95, 91, 'DOCUMENTATION', 'http://files.spip.org/spip-zone/documentation_2.png', '002.000.000', '1.2.0', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[en]Documentation template\n[fr]Squelette {{Documentation}}\n[sk]ÿ abl�³na {{Dokument�¡cia}}\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:4:{s:7:"cextras";a:2:{s:3:"nom";s:7:"cextras";s:13:"compatibilite";s:8:"[3.0.0;[";}s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:6:"[1.1;[";}s:1:"Z";a:2:{s:3:"nom";s:1:"Z";s:13:"compatibilite";s:8:"[1.7.0;[";}s:17:"suivant_precedent";a:2:{s:3:"nom";s:17:"suivant_precedent";s:13:"compatibilite";s:6:"[1.1;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:8:{s:11:"porte_plume";a:1:{s:3:"nom";s:11:"porte_plume";}s:7:"tickets";a:2:{s:3:"nom";s:7:"tickets";s:13:"compatibilite";s:7:"[1.62;[";}s:6:"nospam";a:2:{s:3:"nom";s:6:"nospam";s:13:"compatibilite";s:6:"[0.6;[";}s:15:"coloration_code";a:2:{s:3:"nom";s:15:"coloration_code";s:13:"compatibilite";s:8:"[0.5.4;[";}s:5:"pages";a:1:{s:3:"nom";s:5:"pages";}s:8:"comments";a:1:{s:3:"nom";s:8:"comments";}s:8:"polyhier";a:1:{s:3:"nom";s:8:"polyhier";}s:7:"tradrub";a:2:{s:3:"nom";s:7:"tradrub";s:13:"compatibilite";s:6:"[1.2;[";}}}}', '2012-02-17 11:00:07', '2012-02-17 11:00:07', 1, 'documentation_2.zip', 361535, '2012-02-17 11:00:20', '_galaxie_/programmer.spip.org/plugin_documentation/branches/v2', 'a:2:{s:13:"documentation";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.org/auteur/jaro";}}}}s:20:"paquet-documentation";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.org/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd1640be77033bc6a44bb8606a43034f9'),
(96, 91, 'DOCUMENTATION', 'http://files.spip.org/spip-zone/documentation.png', '003.000.002', '1.2.0', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[en]Documentation template\n[fr]Squelette {{Documentation}}\n[sk]ÿ abl�³na {{Dokument�¡cia}}\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:1:{i:0;a:4:{s:7:"cextras";a:2:{s:3:"nom";s:7:"cextras";s:13:"compatibilite";s:8:"[3.0.0;[";}s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:6:"[1.1;[";}s:4:"Zpip";a:2:{s:3:"nom";s:4:"Zpip";s:13:"compatibilite";s:8:"[2.0.3;[";}s:17:"suivant_precedent";a:2:{s:3:"nom";s:17:"suivant_precedent";s:13:"compatibilite";s:6:"[1.1;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:8:{s:11:"porte_plume";a:1:{s:3:"nom";s:11:"porte_plume";}s:7:"tickets";a:2:{s:3:"nom";s:7:"tickets";s:13:"compatibilite";s:6:"[2.0;[";}s:6:"nospam";a:2:{s:3:"nom";s:6:"nospam";s:13:"compatibilite";s:6:"[0.6;[";}s:15:"coloration_code";a:2:{s:3:"nom";s:15:"coloration_code";s:13:"compatibilite";s:8:"[0.5.4;[";}s:5:"pages";a:1:{s:3:"nom";s:5:"pages";}s:8:"comments";a:1:{s:3:"nom";s:8:"comments";}s:8:"polyhier";a:1:{s:3:"nom";s:8:"polyhier";}s:7:"tradrub";a:2:{s:3:"nom";s:7:"tradrub";s:13:"compatibilite";s:8:"[3.0.0;[";}}}}', '2012-08-13 15:00:03', '2012-08-13 15:00:03', 1, 'documentation.zip', 370964, '2012-08-13 15:00:04', '_galaxie_/programmer.spip.org/plugin_documentation/trunk', 'a:2:{s:13:"documentation";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:20:"paquet-documentation";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'eeb5c9fdb233f547395f82f1becddabd'),
(97, 92, 'DOCUMENTATION2LATEX', 'http://files.spip.org/spip-zone/documentation2latex.png', '001.000.000', '', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[fr]Sert �  traduire programmer.spip.org en LaTeX. On fait une compilation LaTeX local.\n		Pour la conversion des niveaux de titres :\n			- Une section de lang = 1 livre (on choisit la langue du livre qu''on fait cr�er)\n			- Une partie (introduction, Ecriture des squelettes etc) =  \\part\n			- Un chapitre (boucles, balises etc)					 = \\chapter\n			- 1 article 											 = \\section \n			- 1 intertitre (le cas �ch�ant)							 = \\subsection\n			\n		On verra pour les d�tails plus tard\n		\n		Pour compiler : xelatex -shell-escape\n		\n		N�c�ssite pygmentize en locale afin d\'avoir la coloration code\n		\n		Reste aussi �  voir : gestion de l''indexation. �⿬ discuter avec Marcimat\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:17:"Ma�¯eul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Livre-avec-SPIP', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:3:{s:10:"latexwheel";a:2:{s:3:"nom";s:10:"latexwheel";s:13:"compatibilite";s:8:"[1.0.0;[";}s:13:"documentation";a:2:{s:3:"nom";s:13:"documentation";s:13:"compatibilite";s:13:"[2.0.0;3.0.*]";}s:7:"zippeur";a:2:{s:3:"nom";s:7:"zippeur";s:13:"compatibilite";s:8:"[2.0.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-04-02 00:00:02', '2012-04-02 00:00:02', 1, 'documentation2latex.zip', 45076, '2012-04-02 00:00:02', '_galaxie_/programmer.spip.org/plugin_latex/trunk', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd25bda42567effdb25728bb810132835'),
(98, 93, 'DUPLICATOR', 'http://files.spip.org/spip-zone/duplicator_spip3.png', '000.002.000', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin permet de dupliquer une rubrique et son contenu depuis l''espace priv� en ajoutant un bouton dans la navigation de gauche dans l''espace priv� des rubriques.\r\n\r\nLa duplication reprend :\r\n-*  les logos\r\n-*  les articles (leur contenu, leur statut, leurs mots clefs et logos)\r\n-*  les sous-rubriques (n niveaux), les mots clefs li�s, ses articles (contenu + statut + mots clefs) et ses logos\r\n\r\nLa nouvelle rubrique est cr��e au m�ªme niveau que la rubrique copi�e.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:7:"Apsulis";s:3:"url";s:23:"http://demo.apsulis.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:4:"2010";}', 'http://www.spip-contrib.net/Plugin-Duplicator', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-19 03:00:46', '2012-07-19 03:00:46', 1, 'duplicator_spip3.zip', 16774, '2012-07-19 03:00:56', '_plugins_/duplicator/V2', 'a:1:{s:10:"duplicator";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '1d537513a896de7b658c89120c90a62a'),
(480, 484, 'SEO', 'http://files.spip.org/spip-zone/seo.png', '001.007.002', '1.1.0', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\n[en]SEO is a plugin who add the possibility to insert in the head of your website: meta tags, canoical URL, Google webmaster tools Meta Code and Google Analytics javascript code. It is fully configurable in the SPIP configuration page and in each article or rubrique page for meta tags.\n[fr]SEO est un plugin qui ajoute la possibilit� d\'ins�rer dans la partie head de votre site web : meta tags, URL canonique, Google webmaster tools Meta Code et Google Analytics javascript. Il est configurable dans la page de configuration de SPIP ainsi que dans chaque rubrique et article pour les meta tags.\n[sk]SEO je zásuvný modul, ktorý ponúka možnosť vložiť do hlavičky stránky meta tagy, kanonickú podobu internetových adries, meta kód nástrojov pre webmasterov od spoločnosti Google a javaskript z Google Analytics. Meta tagy sa dajú nastaviť na stránke s nastaveniami SPIPu, ako aj v každej rubrike a v každom článku.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Pierre ROUSSET";s:3:"url";s:0:"";s:4:"mail";s:22:"p.rousset AT gmail.com";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 2";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-2.0.html";}}', 'a:1:{i:1;s:9:"2009-2012";}', 'http://www.spip-contrib.net/?rubrique1248', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-10 21:00:02', '2012-09-10 21:00:02', 1, 'seo.zip', 50560, '2012-09-10 21:00:06', '_plugins_/seo', 'a:2:{s:10:"paquet-seo";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:3:"seo";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '8f62303cd26247cdb3ffe5b6b4e2e450'),
(481, 485, 'BIBLE', 'http://files.spip.org/spip-zone/spip-bible3.jpg', '003.001.000', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Le plugin Spip-Bible permet de citer rapidement des extraits de la Bible dans le texte d⿿un article. Sous SPIP 2.0 avec SPIP-Bonux, propose un "presse-papier" biblique à c�t� des formulaires d''�ditions. Vous pouvez aussi utilisez un mod�le, mais cette m�thode est d�su�te et d�conseill�e.\r\n\r\nEx : <code><bible|passage=Gn1,2-2,1></code> citera la Gen�se du chapitre 1, verset 2 au chapitre 2, verset 1 inclu.\r\n\r\nOn peut passer des options au mod�le. La valeur des options est "non" ou "oui", sauf pour traduction.\r\n\r\nCes options sont :\r\n-* numeros : Pour afficher les num�ros de versets et de chapitre dans le corps de texte.\r\n-* retour : Pour faire des retours chariots entre les versets\r\n-* ref : Pour afficher les r�f�rences à la suite du passage\r\n-* traduction : Pour choisir la traduction.\r\n\r\nLa liste des traductions disponibles est sur [Spip-Contrib->http://www.spip-contrib.net/Spip-Bible-traductions-disponibles]\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:17:"Maïeul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:29:"Teddy Payet (Auteur associ�)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:31:"Cerdic (Id�e du presse-papier)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Spip-Bible,1125', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-07 11:00:16', '2012-09-07 11:00:16', 1, 'spip-bible3.zip', 235930, '2012-09-07 11:00:22', '_plugins_/spip-bible/branches/spip-bible3', 'a:1:{s:5:"bible";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '369f363189714bacf0842783243574f9'),
(100, 95, 'ENTRAVAUX', 'http://files.spip.org/spip-zone/en_travaux_v3.png', '003.001.007', '0.2.0', '[3.0.0-dev;3.0.*]', '3.0', '<multi>\n[en]Displays a defined page during maintenance period on all your public pages.\n[fr]�⿬ activer avant une phase de maintenance, ce plugin affiche aussit�´t une page d\'avertissement, {{�  la place}} du site public. Attention : seul le webmestre acc�de encore �  l''espace priv� et au site public.\n[it]Consente di visualizzare un messaggio personalizzabile durante una sessione di manutenzione su tutte le pagine del sito pubblico.\n[sk]Ak ju aktivujete pred f�¡zou �ºdrÿ¾by, tento z�¡suvn�½ modul {{namiesto}} verejne pr�­stupnej str�¡nky okamÿ¾ite zobraz�­ str�¡nku sÿ upozornen�­m. Pozor: Iba webmaster sa m�´ÿ¾e dostaÿ¥ do s�ºkromnej z�³ny aÿ na verejne pr�­stupn�º str�¡nku.\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:13:"Arnaud Ventre";s:3:"url";s:0:"";s:4:"mail";s:20:"ventrea AT gmail.com";}i:2;a:3:{s:3:"nom";s:13:"C�dric Morin";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:9:"2006-2012";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'www.spip-contrib.net/?rubrique516', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:12:04', '2012-07-26 13:12:04', 1, 'en_travaux_v3.zip', 50127, '2012-07-26 13:12:04', '_plugins_/en_travaux/trunk', 'a:2:{s:9:"entravaux";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:7:{s:2:"de";a:0:{}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:16:"paquet-entravaux";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '07037c098b43edebf17f9d16f2988d92'),
(101, 96, 'EUDOCK', 'http://files.spip.org/spip-zone/euDock.png', '001.022.000', '', '[2.0;[', '2.0,2.1,3.0,3.1', '<multi>\n[fr]{{Effet ''Dock'' �  la mode ''Apple'' en javascript}}\n\nCe plugin ajoute une biblioth�que javascript permettant de cr�er un effet ''Dock'' sur une liste d\'objets images ({documents ou logos du site}).\n\nUne documentation interne est disponible lorsque le plugin est actif sur la page publique [eudock_documentation->../?page=eudock_documentation].\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:24:"Parodi (Pier...) Eugenio";s:3:"url";s:22:"http://eudock.jules.it";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:12:"Piero Wbmstr";s:3:"url";s:39:"http://www.spip-contrib.net/PieroWbmstr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article3567', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-05-08 10:00:16', '2012-05-08 10:00:16', 1, 'euDock.zip', 363353, '2012-05-08 10:00:18', '_plugins_/eudock/spip_3', 'a:1:{s:6:"eudock";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'e8044e340f7978d297f7b7cbd6e36938'),
(102, 97, 'EXCLURE_SECT', 'http://files.spip.org/spip-zone/exclure_secteur_2.jpg', '002.000.004', '', '[3.0.0-beta;3.0.99]', '3.0', '<multi>\n[fr]Ce plugin exclut automatiquement les secteurs s�l�ctionn�s des boucles ARTICLES / SITES / RUBRIQUES / BREVES / FORUMS (suivant la r�gle de SPIP, qui ne prend en compte que les forums li�s �  des articles).\r\n\r\nAttention, pour le moment, ne le fait pas sur les jointures (par exemple, n''exclura pas les forums qui appartiennent �  un article du secteur).\r\n\r\nOn peut faire une exception avec le crit�re <code>{tout_secteur}</code>. \r\nSi on pr�cise le secteur explicitement, par <code>{id_secteur=x}</code>, <code>{id_secteur==x}</code> ou <code>{id_secteur IN X}</code>, le r�glage ne sera pas pris en compte.\r\n\r\nPossibilit� aussi de configurer le plugin pour que <code>{tout}</code> soit �quivalent �  <code>{tout_voir}</code>.\r\n\r\nOn peut aussi configurer pour que que si l''id principal du nom de boucle est pass�e via <code>{id_boucle}</code> ou <code>{id_boucle==X}</code> ou <code>{id_boucle=X}</code> ou <code>{id_boucle IN X}</code>, cela fait sauter l''exclusion des secteurs. (Depuis la 1.2)\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:17:"Ma�¯eul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Plugin-Exclure-secteur', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-13 01:00:04', '2012-07-13 01:00:04', 1, 'exclure_secteur_2.zip', 12870, '2012-07-13 01:00:06', '_plugins_/exclure_secteur/branches/exclure_secteur_2', 'a:1:{s:12:"exclure_sect";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '1e2f18d281f23d14bc08db918ec1963a'),
(105, 100, 'FACD', 'http://files.spip.org/spip-zone/facd.png', '000.001.002', '0.0.1', '[3.0.0;3.0.99]', '3.0', '<multi>\n[en]Conversion queue management for documents.\n[fr]Gestion de file d\'attente pour la conversion de documents.\n[sk]Riadenie radu dokumentov, ktor� ÿakaj�º na konverziu.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"kent1";s:3:"url";s:21:"http://www.kent1.info";s:4:"mail";s:22:"kent1 AT arscenic.info";}}', '', '', '', '', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:1:{i:0;a:1:{s:4:"flot";a:2:{s:3:"nom";s:4:"flot";s:4:"lien";s:45:"http://flot.googlecode.com/files/flot-0.7.zip";}}}s:7:"utilise";a:0:{}}', '2012-08-16 12:00:23', '2012-08-16 12:00:23', 1, 'facd.zip', 27737, '2012-08-16 12:00:32', '_plugins_/facd', 'a:2:{s:4:"facd";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:11:"paquet-facd";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'f8371346614f6948a2018d5c37181b9a');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(503, 500, 'CONTACT_LIBRE', 'http://files.spip.org/spip-zone/contact_libre.png', '000.001.004', '', '[2.0.6;3.0.99]', '2.0,2.1,3.0', 'Formulaire de contact libre auquel on peut passer directement une adresse mail et une url de r�f�rence (ic�ne de http://www.androidicons.com/).', 'a:1:{i:0;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Formulaire-de-contact-libre', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:6:"nospam";s:2:"id";s:6:"nospam";s:7:"version";s:6:"[0.6;]";s:13:"compatibilite";s:6:"[0.6;]";}}}}', '2012-09-19 13:00:28', '2012-09-19 13:00:28', 1, 'contact_libre.zip', 9688, '2012-09-19 13:00:32', '_plugins_/contact_libre', 'a:1:{s:13:"contact_libre";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '382cc8456426cffa8abbb5dc9c23cc08'),
(504, 501, 'CONTACTS', 'http://files.spip.org/spip-zone/C_et_O_SPIP_3.png', '002.001.002', '1.7.1', '[3.0.0-dev;3.0.*]', '3.0', '<multi>\n[en]Enhances SPIP with the functionnalities of a contact management system. Makes a difference between companies (organisations) and persons (contacts) while keeping all the SPIP author''s attributes. Allows to give access rights to accounts with unique password. Allows to extend unique fields (such as frist name, date of birth...) together with multiple fields (phone numbers, mail addresses...).\n\nThis plugin has been developped inside the [SPIPMINE->http://www.spip-contrib.net/Plugin-Spipmine] and [Catalogue->http://www.spip-contrib.net/Plugin-Catalogue] projects.\n[fr]Ajoute � SPIP les fonctionnalit�s d\'un gestionnaire de contacts.\nDistingue les personnes pysiques (contacts) des personnes morales (organisations) en conservant tous les attributs des auteurs SPIP.\n_ Permet d\'attribuer des droits d\'acc�s � des organisations avec un mot de passe unique et d''�tendre � la fois les champs unitaires (pr�nom, date de naissance...) et les champs multipes (num�ros de t�l�phone, adresses mail...).\n\nPlugin d�velopp� dans le cadre du gestionnaire de projets [SPIPMINE->http://www.spip-contrib.net/Plugin-Spipmine] et du plugin [Catalogue->http://www.spip-contrib.net/Plugin-Catalogue].\n</multi>', 'a:4:{i:1;a:3:{s:3:"nom";s:12:"Cyril MARION";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:12:"Ateliers CYM";s:3:"url";s:17:"http://www.cym.fr";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:19:"http://magraine.net";s:4:"mail";s:0:"";}i:4;a:3:{s:3:"nom";s:28:"Les D�veloppements Durables";s:3:"url";s:17:"http://www.ldd.fr";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Plugin-Contacts-Organisations', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:3:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.15.3;[";}s:6:"medias";a:2:{s:3:"nom";s:6:"medias";s:13:"compatibilite";s:6:"[1.6;[";}s:20:"editer_liens_simples";a:2:{s:3:"nom";s:20:"editer_liens_simples";s:13:"compatibilite";s:6:"[1.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:11:"coordonnees";a:2:{s:3:"nom";s:11:"coordonnees";s:13:"compatibilite";s:8:"[1.2.0;[";}s:7:"crayons";a:2:{s:3:"nom";s:7:"crayons";s:13:"compatibilite";s:9:"[1.10.0;[";}}}}', '2012-09-23 23:00:18', '2012-09-23 23:00:18', 1, 'C_et_O_SPIP_3.zip', 111422, '2012-09-23 23:00:20', '_plugins_/contacts_et_organisations/trunk', 'a:1:{s:8:"contacts";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:2:{i:0;a:2:{s:3:"nom";s:13:"RastaPopoulos";s:4:"lien";s:41:"http://trad.spip.net/auteur/rastapopoulos";}i:1;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'cf0a1ce5815dd54c213b9a8e2d6759e8'),
(107, 102, 'FEEDBURNER', 'http://files.spip.org/spip-zone/feedburner.png', '001.000.000', '', '[2.0.0;3.0.*]', '2.0,2.1,3.0', '<multi>\n[fr]Utilisez [FeedBurner->http://www.feedburner.com] sur votre site ! Proposez �  vos internautes de {{s''abonner par mail et/ou flux RSS}}, �  leur choix, simplement, pour recevoir les derniers articles du site, proprement.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"romy.tetue.net";s:3:"url";s:21:"http://romy.tetue.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2009-2011";}', 'http://www.spip-contrib.net/feedburner', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-11-10 11:56:38', '2011-11-10 11:56:38', 1, 'feedburner.zip', 24280, '2011-11-10 12:00:40', '_plugins_/feedburner', 'a:1:{s:10:"feedburner";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '9e22b18a34f8d90348f5284d48966eb6'),
(108, 103, 'FLATTR', 'http://files.spip.org/spip-zone/flattr.png', '000.002.003', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\n			[fr]Int�gration des microdons Flattr\n			[en]Integration of the Flattr micro gifts\n		</multi>', 'a:1:{i:0;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:0;s:4:"2010";}', 'http://zzz.rezo.net/Plugin-Flattr-pour-SPIP.html', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:3:"cfg";s:2:"id";s:3:"cfg";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}}}}', '2012-03-05 18:00:02', '2012-03-05 18:00:02', 1, 'flattr.zip', 21599, '2012-03-05 18:00:02', '_plugins_/flattr', 'a:1:{s:6:"flattr";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '406b30ebf4f2e010f20ffd5b715af091'),
(109, 104, 'FONCTIONS_IMAGES', 'http://files.spip.org/spip-zone/fonctions_images_trunk.png', '000.006.001', '', '[3.0.0;3.0.99]', '3.0', '<multi>\n[en]Provides image processing filters, mainly\r\nextracted from the website [Paris-Beyrouth->http://www.paris-beyrouth.org/].\r\n\r\n{{Proposed filters :}}\r\n-* couleur_chroma\r\n-* couleur_saturer\r\n-* couleur_teinter\r\n-* couleur_inverserluminosite\r\n-* couleur_foncerluminosite\r\n-* couleur_eclaircirluminosite\r\n-* image_contour_alpha\r\n-* image_courbe\r\n-* image_dispersion\r\n-* image_estampage_alpha\r\n-* image_float\r\n-* image_niveaux_gris_auto\r\n-* image_podpod\r\n-* image_saturer\n[fr]Fournit des filtres pour le traitement des images, essentiellement extraits du site [Paris-Beyrouth->http://www.paris-beyrouth.org/].\r\n\r\n{{Filtres propos�s :}}\r\n-* couleur_chroma\r\n-* couleur_saturer\r\n-* couleur_teinter\r\n-* couleur_inverserluminosite\r\n-* couleur_foncerluminosite\r\n-* couleur_eclaircirluminosite\r\n-* image_contour_alpha\r\n-* image_courbe\r\n-* image_dispersion\r\n-* image_estampage_alpha\r\n-* image_float\r\n-* image_niveaux_gris_auto\r\n-* image_podpod\r\n-* image_saturer\r\n-* image_merge\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:13:"Arnaud Martin";s:3:"url";s:36:"http://www.paris-beyrouth.org/-SPIP-";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:36:"Matthieu Marcillaud (mise en plugin)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2007-2012";}', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-25 09:00:16', '2012-06-25 09:00:16', 1, 'fonctions_images_trunk.zip', 94491, '2012-06-25 09:00:30', '_plugins_/fonctions_images/trunk', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'b365b7782603324a954c1da36f83f965'),
(110, 105, 'FMP3', 'http://files.spip.org/spip-zone/fond_mp3.png', '003.000.000', '', '[3.0.0-alpha2;[', '3.0,3.1', '', '', '', '', '', 'http://www.quesaco.org/Illustration-sonore-mp3', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-07 19:00:14', '2012-08-07 19:00:14', 1, 'fond_mp3.zip', 75162, '2012-08-07 19:00:20', '_plugins_/fond_mp3', 'a:1:{s:4:"fmp3";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '23b6a4661b1005774acc6ee3d24ec99c'),
(112, 107, 'FORUMSECTORISE', 'http://files.spip.org/spip-zone/forum_sectorise.png', '000.006.000', '0.3', '[2.1.0;3.0.99]', '2.1,3.0', '<multi>\n[fr]Ce plugin permet d\'activer les forums publics uniquement sur un secteur du site. Tous les nouveaux articles cr��s dans ce secteur se verront attribuer le type de forum d�fini dans la configuration du plugin. Evidemment ce plugin n''a un int�r�t que si les forums sont d�sactiv�s dans la configuration g�n�rale du site.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"Yffic";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Forum-sectorise', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:8:"[1.9.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-04-15 16:00:01', '2012-04-15 16:00:01', 1, 'forum_sectorise.zip', 14469, '2012-04-15 16:00:02', '_plugins_/forum_sectorise', 'a:1:{s:14:"forumsectorise";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c8b1bd40df5ee033c0a6dcc57429b60d'),
(113, 108, 'FPDF', 'http://files.spip.org/spip-zone/fpdf.png', '000.000.002', '', '', '', 'Ce plugin sert �  g�n�rer des pdfs via la librairie fpdf pour n''importe quelle table.\n		Adapter le en vous servant des tutoriaux du dossier demo.', 'a:2:{i:0;a:3:{s:3:"nom";s:11:"Pierre KUHN";s:3:"url";s:26:"http://www.pierre-kuhn.org";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:15:"Olivier PLATHEY";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:27:"Apache licence, version 2.0";s:3:"url";s:42:"http://www.apache.org/licenses/LICENSE-2.0";}}', 'a:1:{i:0;s:9:"2004-2011";}', 'http://contrib.spip.net/?article4185', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-28 15:00:09', '2012-07-28 15:00:09', 1, 'fpdf.zip', 212421, '2012-07-28 15:00:10', '_plugins_/fpdf', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'e703b01e245f22930f5ea53060a687c4'),
(114, 109, 'FRIMOUSSES', 'http://files.spip.org/spip-zone/frimousses.png', '001.002.002', '', '[1.9.2;3.0.99]', '1.9,2.0,2.1,3.0', 'Remplace les codes ASCII pour les frimousses par des petites images.', 'a:2:{i:0;a:3:{s:3:"nom";s:25:"Pierre Andrews (Mortimer)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:6:"Bionet";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-12-23 15:00:26', '2011-12-23 15:00:26', 1, 'frimousses.zip', 25854, '2011-12-23 15:00:28', '_plugins_/frimousses', 'a:1:{s:7:"smileys";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '9017dceb73922b7c1c91bc27e612ea86'),
(115, 110, 'FULLTEXT', 'http://files.spip.org/spip-zone/fulltext.png', '000.007.000', '0.2', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\n[en]This plugin allows on one hand to use the FULLTEXT search mode  of MySQL and thereby greatly improve the search engine compared to the native search engine of SPIP, and on the other hand to index the contents of some documents.\n_ For an optimum use, you need to install additional programs on the server and setting up  their use in <code>mes_options.php</code> or via the plugin control panel.\n_ See the plugin documentation for more details.\n[fr]Ce plugin permet d\'une part d\'exploiter le mode de recherche FULLTEXT de MySQL et d\'am�liorer ainsi �norm�ment les recherches par rapport au fonctionnement natif de SPIP, et d\'autre part d\'indexer le contenu de certains documents.\n_ Pour un fonctionnement optimal, certains programmes compl�mentaires sont n�cessaires sur le serveur et doivent �ªtre param�tr�s dans <code>mes_options.php</code> ou via le panneau de configuration.\n_ Voir la documentation du plugin pour plus de d�tails.\n[sk]Tento poskytuje pomoc pri  FULLTEXTOVOM vyhÿ¾ad�¡van�­  MySQL aÿ veÿ¾mi vylepÿ¡uje vyhÿ¾ad�¡vanie voÿ vzÿ¥ahu kÿ fungovaniu SPIPu ako tak�ho aÿ po druh� pri indexovan�­ obsahu niektor�½ch s�ºborov. \n_ Na optim�¡lne fungovanie potrebujete na serveri niektor� ÿalÿ¡ie programy aÿ tie musia byÿ¥ nastaven� vÿ s�ºbore <code>mes_options.php</code> alebo cezÿ ovl�¡dac�­ panel.\n _ Viac podrobnost�­ n�¡jdete vÿ dokument�¡cii kÿ z�¡suvn�mu modulu.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:13:"Gael Chareyre";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2009-2012";}', 'http://www.spip-contrib.net/Fulltext', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-27 04:00:18', '2012-07-27 04:00:18', 1, 'fulltext.zip', 129873, '2012-07-27 04:00:20', '_plugins_/fulltext', 'a:2:{s:8:"fulltext";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:24:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/ÿ¬ÿ˿ÿ±ÿ¬-ÿ⿿ÿ⿠ÿ¯ÿ⿿ÿÿª";}}s:3:"ast";a:1:{i:0;a:2:{s:3:"nom";s:5:"Xuacu";s:4:"lien";s:33:"http://trad.spip.net/auteur/xuacu";}}s:2:"ca";a:0:{}s:2:"cs";a:0:{}s:2:"da";a:0:{}s:2:"de";a:0:{}s:2:"el";a:0:{}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"et";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:5:"fr_tu";a:0:{}s:2:"id";a:0:{}s:2:"it";a:0:{}s:2:"lv";a:0:{}s:2:"nl";a:0:{}s:2:"no";a:0:{}s:2:"pl";a:0:{}s:2:"pt";a:0:{}s:2:"ro";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}s:2:"tr";a:0:{}s:2:"uk";a:0:{}}}s:15:"paquet-fulltext";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:2:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}i:1;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '483b528ec9dd78a1456fb6de3f16b49e'),
(116, 111, 'FUSIONMOTS', 'http://files.spip.org/spip-zone/fusion_mots_v1.png', '001.000.000', '', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[fr]Permet aux administrateurs de remplacer en s�rie des mots-cl�s par d\'autres, pour en diminuer le nombre et �liminer les redondances.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:17:"Ma�¯eul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:4:"JLuc";s:3:"url";s:17:"http://ouhpla.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Fusion-de-mots-clef', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-11-19 11:34:40', '2011-11-19 11:34:40', 1, 'fusion_mots_v1.zip', 36882, '2011-11-19 12:00:10', '_plugins_/fusion_mots/branches/v1', 'a:1:{s:10:"fusionmots";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '0a410a7c0d101cf7babced4fef878140'),
(118, 113, 'GALCARO', 'http://files.spip.org/spip-zone/galcaro.png', '001.000.000', '', '[2.0.0;]', '2.0,2.1,3.0,3.1', 'Galerie d\'images carr�es, avec attribut longdesc.', 'a:2:{i:0;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:14:"romy.tetue.net";s:3:"url";s:21:"http://romy.tetue.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-02-29 04:00:21', '2012-02-29 04:00:21', 1, 'galcaro.zip', 9880, '2012-02-29 04:00:26', '_plugins_/galcaro', 'a:1:{s:7:"galcaro";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '6bc5126048121e53da4ee2a2e56337fd'),
(119, 114, 'GCALENDAR', 'http://files.spip.org/spip-zone/gcalendar.gif', '001.000.010', '', '[1.9.2;3.1.99]', '1.9,2.0,2.1,3.0,3.1', '<multi>\r\n			[fr]Ce plugin int�gre Google Calendar �  SPIP.\r\n			[en]This plugin integrates Google Calendar to SPIP.\r\n			[ar]ÿŠÿ¯ÿ⿦ÿ¬ ÿ⿡ÿ°ÿ§ ÿ§ÿ⿿ÿ¨ÿ±ÿ⿠ÿ§ÿ⿦ÿ¬ ÿ§ÿ⿿ÿ⿦ÿ³ÿ§ÿ¹ÿ¯ Google Calendar ÿ⿿ SPIP.\r\n		</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:14:"Gilles Quiniou";s:3:"url";s:0:"";s:4:"mail";s:25:"mailto:gilles@quiniou.net";}i:1;a:3:{s:3:"nom";s:24:"Mehdi Cherifi (Superyms)";s:3:"url";s:0:"";s:4:"mail";s:25:"mailto:superyms@gmail.com";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Plugin-Agenda-Google-pour-SPIP', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{i:0;a:4:{s:2:"id";s:3:"cfg";s:3:"nom";s:3:"cfg";s:7:"version";s:6:"[1.4;]";s:13:"compatibilite";s:6:"[1.4;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-26 09:00:12', '2012-06-26 09:00:12', 1, 'gcalendar.zip', 16254, '2012-06-26 09:00:12', '_plugins_/gcalendar', 'a:1:{s:9:"gcalendar";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"ar";a:0:{}s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'a494326c15425c5d665e38b6e9afb208'),
(120, 115, 'GDATA', 'http://files.spip.org/spip-zone/gdata.png', '000.001', '', '[2.1.0;]', '2.1,3.0,3.1', 'Faire des boucles sur des donn�es google (google documents)', 'a:1:{i:0;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:2:{i:0;a:2:{s:3:"nom";s:7:"ÿ© 2012";s:3:"url";s:0:"";}i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/4044', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-01-15 17:00:49', '2012-01-15 17:00:49', 1, 'gdata.zip', 32324, '2012-01-15 17:00:50', '_plugins_/gdata', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '06e4a69bf6e7c4667b06539e75e18835'),
(121, 116, 'GEOGRAPHIE', 'http://files.spip.org/spip-zone/geographie.png', '000.003.000', '0.2.0', '[2.1.0;]', '2.1,3.0,3.1', 'Bases g�ographiques Pays, et pour la France : R�gion, d�partement, communes g�olocalis�es', 'a:1:{i:0;a:3:{s:3:"nom";s:11:"yterium.net";s:3:"url";s:22:"http://www.yterium.net";s:4:"mail";s:0:"";}}', '', '', '', 'http://contrib.spip.net/Geographie', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-04 11:00:09', '2012-09-04 11:00:09', 1, 'geographie.zip', 1179396, '2012-09-04 11:00:18', '_plugins_/geographie', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '6dae32d006aa234acf1fcbf0d8b35c04'),
(122, 117, 'GESTIONML', 'http://files.spip.org/spip-zone/gestion_ml.png', '001.000.000', '0.2', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin permet de d�l�guer la gestion de mailing lists �  certains administrateurs du site. L''interface avec les ML chez votre h�bergeur se fait gr�¢ce au protocole SOAP. Il ne fonctionne actuellement qu\'avec les listes ezmlm de l\'h�bergeur OVH.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"Yffic";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Gestion-ML-avec-Soap', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:8:"[1.9.0;[";}s:4:"YAML";a:2:{s:3:"nom";s:4:"YAML";s:13:"compatibilite";s:6:"[1.5;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-23 13:00:10', '2012-07-23 13:00:10', 1, 'gestion_ml.zip', 30636, '2012-07-23 13:00:10', '_plugins_/gestion_ml/trunk', 'a:1:{s:9:"gestionml";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '5cfc0c6b7c03bb39c85637fa96753842'),
(123, 118, 'GETID3', 'http://files.spip.org/spip-zone/getID3_3.png', '001.002.001', '0.4.0', '[3.0.2;3.0.99]', '3.0', '<multi>\n[en]Read and write audio tags to audio documents\n_ [->http://getid3.sourceforge.net/]\n[fr]Lire et �crire les tags audio sur les documents de type audio\n_ [->http://getid3.sourceforge.net/]\n[sk]ÿſ�­tanie a z�¡pis audio znaÿiek do zvukov�½ch s�ºborov\n_ [->http://getid3.sourceforge.net/]\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:4:"BoOz";s:3:"url";s:0:"";s:4:"mail";s:16:"booz AT rezo.net";}i:2;a:3:{s:3:"nom";s:5:"kent1";s:3:"url";s:21:"http://www.kent1.info";s:4:"mail";s:22:"kent1 AT arscenic.info";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2008-2012";}', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:6:"medias";a:2:{s:3:"nom";s:6:"medias";s:13:"compatibilite";s:9:"[2.7.30;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:7:"licence";a:1:{s:3:"nom";s:7:"licence";}}}}', '2012-08-16 18:00:16', '2012-08-16 18:00:16', 1, 'getID3_3.zip', 382478, '2012-08-16 18:00:16', '_plugins_/getID3/trunk', 'a:2:{s:6:"getid3";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:2:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}i:1;a:2:{s:3:"nom";s:6:"Nathan";s:4:"lien";s:34:"http://trad.spip.net/auteur/nathan";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:13:"paquet-getid3";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'cc0df7c1f682675939d24be1fee114cf'),
(477, 481, 'PAGES_MOBILES', 'http://files.spip.org/spip-zone/pages_mobiles.png', '001.000.001', '', '[3.0.4;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin est d�riv� du plugin [{cimobile}->http://contrib.spip.net/cimobile-plugin-detection-et-aiguillage-des-telephones] de d�tection et aiguillage des t�l�phones mobiles.\r\n\r\nIl en reprend le but: {{orienter les visiteurs vers les bonnes pages selon leur p�riph�rique de navigation}}.\r\n\r\nLe plugin reprend le m�canisme de d�tection des mobiles de {cimobile}. Cependant, l''aiguillage se fait avec une philosophie diff�rente sur deux aspects: \r\n\r\n-# Avec {Pages pour mobiles}, vous n''avez pas besoin d\'avoir d�velopp� toutes les pages pour mobile, le plugin aiguillera vers les pages mobiles, si elles sont pr�sentes. Sinon vers les pages du site normal.\r\n-# {Pages pour mobiles} ne n�cessite pas  de placer les squelettes mobiles dans un r�pertoire squelettes diff�rent, juste dans un sous r�pertoire \\"{mobile}\\" du dossier squelette courant (notez que comme dans {cimobile}, il est possible d\'avoir des pages d�clin�es sp�cifiquement pour certains p�riph�riques, et qui pourront être trouv�es dans un r�pertoire d�di�. Par ex. <code>/squelettes/ipad/article.html</code>).\r\n\r\nLe logo du plugin est issu de nounproject: http://thenounproject.com/noun/application/#icon-No3038 il est CC-BY Kyle Klitch.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:31:"C. Imberti, B. Marne, JM. Labat";s:3:"url";s:29:"http://contrib.spip.net/Beurt";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:25:"Creative commons BY-NC-SA";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/4235', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-16 17:00:02', '2012-09-16 17:00:02', 1, 'pages_mobiles.zip', 46159, '2012-09-16 17:00:02', '_plugins_/pages_mobiles', 'a:1:{s:13:"pages_mobiles";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '8f81c0ce6591949cfed91a5720fd80ad'),
(478, 482, 'PLUGONET', 'http://files.spip.org/spip-zone/plugonet.png', '000.006.009', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en]This plugin allows to generate the new paquet.xml file from the plugin.xml file. Check options are available for pre-cleaning some tags of the original file. \nIn addition, PlugOnet allows to validates manually generated paquet.xml files and provides\nassistance for each tag of the new DTD.\n[fr]Ce plugin permet de produire le nouveau fichier paquet.xml à partir du fichier\nplugin.xml. Des options de v�rification sont disponibles pour nettoyer au pr�alable\ncertaines balises du fichier d\'origine.\n\nEn outre, PlugOnet permet de valider des fichiers paquet.xml �crits manuellement et fournit\nune aide sur chaque balise de la nouvelle DTD.\n[sk]Tento zásuvný modul vytvorí nový súbor zo súboru paquet.xml zo začiatku súboru plugin.xml. V prvom rade máte k dispozícii možnosti overenia vymazať niektor� tagy z p�vodn�ho súboru.\n\nOkrem toho PlugOnet umožſuje overiť manuálne napísan� súbory paquet.xml a poskytuje pomoc ku každ�mu tagu nov�ho DTD.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:14:"Eric Lupinacci";s:3:"url";s:23:"http://blog.smellup.net";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:20:"Emmanuel Saint-James";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://blog.smellup.net/spip.php?article7', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:8:"langonet";a:2:{s:3:"nom";s:8:"langonet";s:13:"compatibilite";s:8:"[0.6.3;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-15 12:00:19', '2012-09-15 12:00:19', 1, 'plugonet.zip', 54159, '2012-09-15 12:00:22', '_plugins_/plugonet', 'a:2:{s:15:"paquet-plugonet";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:8:"plugonet";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'f4d6876ec4178d22bfdaa08cef60a431'),
(126, 120, 'GLOSSAIRE', '', '001.000.000', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', 'Votre site utilise un vocabulaire technique sp�cialis�, vous avez une tendance maladive �  jargonner sans vous en rendre compte, voici une solution pour que votre prose reste n�anmoins accessible au commun des mortels.\r\n-* Le glossaire est li� �  un groupe de mots-cl�s ÿ«glossaireÿ» �  cr�er\r\n-* Filtre <code>lier_au_glossaire</code> �  appliquer aux champs de texte dans les squelettes\r\n-* N�cessite la balise <code>#INSERT_HEAD</code>', 'a:3:{i:0;a:3:{s:3:"nom";s:42:"Fran�§ois Schreuer (francois.schreuer.org)";s:3:"url";s:28:"http://francois.schreuer.org";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:4:"fred";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:15:"Philippe Auriol";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/1459', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-10-09 16:00:17', '2011-10-09 16:00:17', 1, 'glossaire_interne.zip', 3568, '2011-10-09 16:00:18', '_plugins_/glossaire_interne', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'dce4308ff114d55107ff172aef7dd457'),
(127, 121, 'GOOGLEAJAXSEARCH', 'http://files.spip.org/spip-zone/google_ajax_search.png', '000.001.002', '', '[3.0.0-dev;[', '3.0,3.1', '', 'a:1:{i:1;a:3:{s:3:"nom";s:9:"erational";s:3:"url";s:24:"http://www.erational.org";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Plugin-Google-Ajax-Search', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-03-27 04:00:06', '2012-03-27 04:00:06', 1, 'google_ajax_search.zip', 10518, '2012-03-27 04:00:08', '_plugins_/google_ajax_search', 'a:1:{s:16:"googleajaxsearch";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '4ab9508b98fa662fb483ba3a306b0457'),
(128, 122, 'GOOGLEANALYTICS', 'http://files.spip.org/spip-zone/google_analytics.png', '000.004.001', '', '[1.9.2;3.0.*]', '1.9,2.0,2.1,3.0', '<multi>\n[en]Adds the Google Analytics script in public space by inserting google analytics code in the configuration.\n[fr]Ajoute automatiquement le script Google Analytics dans l''espace public en ins�rant le code personnel de Google Analytics dans la configuration.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:4:"Phil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/?article2495', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-05-15 21:00:29', '2012-05-15 21:00:29', 1, 'google_analytics.zip', 37679, '2012-05-15 21:00:30', '_plugins_/google_analytics', 'a:1:{s:15:"googleanalytics";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '4beb19948f6b318527e26971e0169a4f'),
(129, 123, 'GVIEWER', 'http://files.spip.org/spip-zone/google-viewer.png', '000.003.000', '', '[2.1.0;3.0.99]', '2.1,3.0', '<multi>\n[fr]Mod�le pour utiliser le [lecteur de documents en ligne de Google->http://docs.google.com/viewer]. Ce plugin �tend le mod�ve <code><mediaXX|embed></code> pour les documents de type doc, docx, xls, xlsx, ppt, pptx, pdf, ai, psd, eps, ps, et ttf. En l''absence des mod�les media, il est possible d\'utiliser <code><embXX|google></code>.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:34:"http://www.spip-contrib.net/Joseph";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Plugin-Google-Viewer', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:5:"media";a:1:{s:3:"nom";s:5:"media";}}}}', '2012-05-28 19:00:08', '2012-05-28 19:00:08', 1, 'google-viewer.zip', 19963, '2012-05-28 19:00:10', '_plugins_/google-viewer', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ffd77a9a27d5ea2b69cdbff1e0fbf882'),
(130, 124, 'GOOGLEPLUS1', 'http://files.spip.org/spip-zone/googleplus1.png', '000.004.001', '', '[2.0.10;3.0.*]', '2.0,2.1,3.0', '<multi>\n[en] \n[fr] \n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:4:"Phil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Google-1', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-11-03 21:25:53', '2011-11-03 21:25:53', 1, 'googleplus1.zip', 16134, '2011-11-03 22:00:18', '_plugins_/googleplus1', 'a:1:{s:11:"googleplus1";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'f04a89281785c0f7e0024584cf7a1113'),
(131, 125, 'GRAVATAR', 'http://files.spip.org/spip-zone/gravatar.png', '001.003.002', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\n			[fr]Permet d\'utiliser un cache pour stocker les gravatars.\n_ �⿬ utiliser dans une boucle de cette mani�re : <code>#GRAVATAR{email, taille, url image par\nd&#233faut}</code>\n_ Exemple : <code>#GRAVATAR{#EMAIL,80,#URL_SITE_SPIP/defaut-gravatar.gif}</code>\n\n�⿰tend la balise #LOGO_AUTEUR de mani�re �  prendre en compte le gravatar d\'un auteur s''il existe, y compris dans les forums et p�titions.\n_ Permet de configurer une image par defaut, et la taille des images.\n\nFournit le filtre <code>|gravatar</code>, �  utiliser par exemple comme \n<code>[(#EMAIL|gravatar|image_reduire{80})]</code>.\n			[en]Enables to use a cache system to store the gravatars.\n_ To use it in a loop in this manner : <code>#GRAVATAR{email, size, URL of the default image}</code>\n_ Example : <code>#GRAVATAR{#EMAIL,80,#URL_SITE_SPIP/defaut-gravatar.gif}</code>\n\nAlso extend the #LOGO_AUTEUR tag in order to take into account the gravatar of an author if it exists, including in forums and petitions.\n_ Configures a default image, and image size.\n		</multi>', 'a:4:{i:0;a:3:{s:3:"nom";s:17:"Thomas Beaumanoir";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:10:"Clever Age";s:3:"url";s:25:"http://www.clever-age.com";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:6:"Cedric";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/gravatar', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:13:48', '2012-07-26 13:13:48', 1, 'gravatar.zip', 46892, '2012-07-26 13:13:48', '_plugins_/gravatar', 'a:1:{s:8:"gravatar";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:6:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '219d0c5f3a8240a8fd4ca72aeb3b0307'),
(132, 126, 'GREVES', 'http://files.spip.org/spip-zone/greves.png', '000.002.000', '0.1', '[2.1.0;3.0.*]', '2.1,3.0', '<multi>\n[fr]Permet de mettre temporairement un site hors service pour protester. On peut �diter une gr�ve, qui re�§oit un titre, un texte explicatif, une date de d�but et une de fin.\n    \n    Entre la date de d�but et la date de fin, le site n''affiche plus que le titre de la gr�ve et son explication.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:17:"Ma�¯eul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Mettre-son-site-en-greve', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:1:{s:3:"nom";s:7:"saisies";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:1:"Z";a:1:{s:3:"nom";s:1:"Z";}}}}', '2012-01-17 00:00:02', '2012-01-17 00:00:02', 1, 'greves.zip', 17681, '2012-01-17 00:00:02', '_plugins_/greves', 'a:1:{s:6:"greves";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'cf362832d699f4b31cba40a310cbd1d9'),
(133, 127, 'GMA', 'http://files.spip.org/spip-zone/groupes_mots_arborescents.png', '001.001.002', '1.0.0', '[3.0.0;3.1.*]', '3.0,3.1', '<multi>\n[fr]Les groupes de mots cl�s peuvent appartenir �  un autre groupe de mots cl�s. Ils h�ritent alors des propri�t�s du groupe racine. Les s�lecteurs de liens entre mots cl�s et les autres objets sont modifi�s pour afficher les groupes racines avec l''arborescence dedans.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:19:"Marcillaud Matthieu";s:3:"url";s:23:"http://www.magraine.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/?article4193', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:3:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.21.0;]";}s:4:"mots";a:2:{s:3:"nom";s:4:"mots";s:13:"compatibilite";s:8:"[2.4.8;]";}s:9:"querypath";a:2:{s:3:"nom";s:9:"querypath";s:13:"compatibilite";s:8:"[1.0.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-13 20:00:14', '2012-07-13 20:00:14', 1, 'groupes_mots_arborescents.zip', 28598, '2012-07-13 20:00:16', '_plugins_/groupes_mots_arborescents', 'a:1:{s:3:"gma";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '1174d5bd4e51362a9305d7249f4b4131'),
(135, 129, 'ICONES_SEMANTIQUES', 'http://files.spip.org/spip-zone/icones_semantiques.png', '000.001.001', '', '[2.0.2;3.0.99]', '2.0,2.1,3.0', 'Permet au porte plume d\'ajouter des raccourcis s�mantiques plut�´t que typographiques:\r\n\r\n-* modifie des ic�´nes et les bulles de survol de la barre typographique\r\n-* configure Spip pour qu''il utilise des raccourcis s�mantiques plut�´t que typographiques :\r\n-** <code>{</code>accolades simples<code>}</code> sont remplac�es par <code><em></em></code> au lieu de <code><i></i></code>\r\n-** <code>{{</code>accolades doubles<code>}}</code> sont remplac�es par <code><strong></strong></code> au lieu de <code><b></b></code>', 'a:1:{i:0;a:3:{s:3:"nom";s:14:"Bertrand Marne";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Icones-semantiques-pour-le-Porte-plume', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{i:0;a:4:{s:2:"id";s:11:"porte_plume";s:3:"nom";s:11:"porte_plume";s:7:"version";s:8:"[0.0.0;]";s:13:"compatibilite";s:8:"[0.0.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-10-07 20:08:40', '2011-10-07 20:08:40', 1, 'icones_semantiques.zip', 54965, '2011-10-07 21:00:12', '_plugins_/porte_plume_extras/icones_semantiques', 'a:1:{s:12:"barre_outils";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '62e20058df84ff60c79c99f9d1abfb32'),
(505, 81, 'COUTEAU_SUISSE', 'http://files.spip.org/spip-zone/couteau_suisse.gif', '001.008.100', '1.8', '[1.9.2;3.0.99]', '1.9,2.0,2.1,3.0', '<multi>\n[en]Combines in one plugin a list of small and useful new features improving the management of your SPIP site.\n\nEach of these tools can be enabled or disabled by the user on [the plugin administration page->./?exec=admin_couteau_suisse] and manage a number of variables: click {{Configuration}}, then select the tab Couteau Suisse.\n\nThe categories are: Administration, Security, Private interface, text enhancements, Typographical shortcuts, Display public, Tags, filters, criteria.\n\nCheck out this plugin in your favorite tools: {Removes the number}, {URLs Format}, {Typographical superscript}, {Smart Quotes}, {Beautiful bullets}, {Fight against SPAM}, {Mailcrypt}, {Beautiful URLs} , {SPIP and external links...}, {Smileys}, {A summary for your articles}, {cut in pages and tabs}, etc.., etc..\n\nFeel free to consult the articles of plugin documentation that are published on: [spip-contrib.net->http://www.spip-contrib.net/Le-Couteau-Suisse].\n\nCompatibility: SPIP v1.92x, v2.x.x and v3.0\n[fr]R�unit en un seul plugin une liste de petites fonctionnalit�s nouvelles et utiles am�liorant la gestion de votre site SPIP.\n\nChacun de ces outils peut �tre activ� ou non par l''utilisateur sur [la page d\'administration du plugin->./?exec=admin_couteau_suisse] et g�rer un certain nombre de variables : cliquer sur {{Configuration}}, puis choisir l''onglet {{Le Couteau Suisse}}.\n\nLes cat�gories disponibles sont : Administration, S�curit�, Interface priv�e, Am�liorations des textes, Raccourcis typographiques, Affichage public, Balises, filtres, crit�res.\n\nD�couvrez dans ce plugin vos outils favoris : {Supprime le num�ro}, {Format des URLs}, {Exposants typographiques}, {Guillemets typographiques}, {Belles puces}, {Lutte contre le SPAM}, {Mailcrypt}, {Belles URLs}, {SPIP et les liens... externes}, {Smileys}, {Un sommaire pour vos articles}, {D�coupe en pages et onglets}, etc., etc.\n\nN''h�sitez pas � consulter les articles de documentation du plugin publi�s sur : [spip-contrib.net->http://www.spip-contrib.net/Le-Couteau-Suisse].\n\nCompatibilit� : SPIP v1.92x, v2.x.x et v3.0\n[sk]V�jednom z�suvnom module sp�ja ve�a mal�ch nov�ch a u�ito�n�ch funkci� zlep�uj�cich riadenie va�ej str�nky v�SPIPe.\n\nKa�d� z�t�chto n�strojov m��e pou��vate� aktivova� alebo deaktivova� [na riadiacej str�nke z�suvn�ho modulu->./?exec=admin_couteau_suisse] a vybera� si z�ur�it�ho po�tu premenn�ch: kliknite na {{Konfigur�ciu,}} potom vyberte kartu {{Vreckov� no��k.}}\n\nK�dispoz�cii s� tieto kateg�rie: Riadenie, Zabezpe�enie, S�kromn� rozhranie, Vylep�enie textov, Kl�vesov� skratky, Zobrazenie na verejne pr�stupnej str�nke, Tagy, filtre, krit�ri�.\n\nObjavte svoje ob��ben� n�stroje v�tomto z�suvnom module: {vymazanie ��sla}, {form�t internetov�ch adries}, {kl�vesov� indexy}, {inteligentn� �vodzovky}, {pekn� odr�ky}, {boj proti SPAMU}, {�ifrovanie po�ty}, {pekn� internetov� adresy}, {SPIP a�extern� odkazy...}, {smajl�ky}, {zhrnutie �l�nku}, {vystrihovanie na str�nkach a�kart�ch} a�tak �alej, a�tak �alej.\n\nPokojne si pre��tajte dokument�ciu k�z�suvn�mu modulu publikovan� na str�nke: [spip-contrib.net.->http://www.spip-contrib.net/Le-Couteau-Suisse]\n\nKompatibilita: SPIP v1.92x, v2.x.x a�v3.0\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:33:"Patrice Vanneufville~�~2007-2012";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:301:"Collectif SPIP, Vincent Ramos, Ma�eul Rouquette, Fil, Arnaud Ventre, Joseph Larmarange, Cerdic, Pierre Andrews (Mortimer), IZO, Phil, J�r�me Combaz, Bertrand Marne, T�tue, Aur�lien Pierard, FredoMkb, Sylvain, BoOz, Alexis Roussel, Paolo, PatV, Yohann(potter64), Nicolas Hoizey, Piero Wbmstr, etc.";s:3:"url";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2007-2012";}', 'http://www.spip-contrib.net/Le-Couteau-Suisse', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-27 00:00:03', '2012-09-27 00:00:03', 1, 'couteau_suisse.zip', 714950, '2012-09-27 00:00:08', '_plugins_/couteau_suisse', 'a:3:{s:7:"couteau";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:17:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/����-������";}}s:3:"ast";a:0:{}s:2:"br";a:0:{}s:2:"ca";a:1:{i:0;a:2:{s:3:"nom";s:5:"merce";s:4:"lien";s:33:"http://trad.spip.net/auteur/merce";}}s:2:"de";a:1:{i:0;a:2:{s:3:"nom";s:7:"klaus++";s:4:"lien";s:33:"http://trad.spip.net/auteur/klaus";}}s:2:"en";a:2:{i:0;a:2:{s:3:"nom";s:6:"sQuonk";s:4:"lien";s:34:"http://trad.spip.net/auteur/squonk";}i:1;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/����-������";}}s:2:"es";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:5:"fr_tu";a:1:{i:0;a:2:{s:3:"nom";s:8:"beatnick";s:4:"lien";s:36:"http://trad.spip.net/auteur/beatnick";}}s:2:"gl";a:0:{}s:2:"it";a:0:{}s:2:"nl";a:2:{i:0;a:2:{s:3:"nom";s:7:"mpossoz";s:4:"lien";s:35:"http://trad.spip.net/auteur/mpossoz";}i:1;a:2:{s:3:"nom";s:5:"Suske";s:4:"lien";s:33:"http://trad.spip.net/auteur/suske";}}s:5:"pt_br";a:1:{i:0;a:2:{s:3:"nom";s:13:"Ricardo Porto";s:4:"lien";s:41:"http://trad.spip.net/auteur/ricardo-porto";}}s:2:"ro";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}s:2:"tr";a:0:{}}}s:12:"couteauprive";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:10:{s:3:"ast";a:0:{}s:2:"ca";a:1:{i:0;a:2:{s:3:"nom";s:5:"merce";s:4:"lien";s:33:"http://trad.spip.net/auteur/merce";}}s:2:"en";a:6:{i:0;a:2:{s:3:"nom";s:4:"Mark";s:4:"lien";s:32:"http://trad.spip.net/auteur/mark";}i:1;a:2:{s:3:"nom";s:6:"sQuonk";s:4:"lien";s:34:"http://trad.spip.net/auteur/squonk";}i:2;a:2:{s:3:"nom";s:4:"PatV";s:4:"lien";s:31:"http://trad.spip.net/auteur/pat";}i:3;a:2:{s:3:"nom";s:5:"Paolo";s:4:"lien";s:33:"http://trad.spip.net/auteur/paolo";}i:4;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/����-������";}i:5;a:2:{s:3:"nom";s:5:"merce";s:4:"lien";s:33:"http://trad.spip.net/auteur/merce";}}s:2:"es";a:1:{i:0;a:2:{s:3:"nom";s:4:"PatV";s:4:"lien";s:31:"http://trad.spip.net/auteur/pat";}}s:2:"fr";a:0:{}s:5:"fr_tu";a:2:{i:0;a:2:{s:3:"nom";s:8:"beatnick";s:4:"lien";s:36:"http://trad.spip.net/auteur/beatnick";}i:1;a:2:{s:3:"nom";s:4:"PatV";s:4:"lien";s:31:"http://trad.spip.net/auteur/pat";}}s:2:"gl";a:1:{i:0;a:2:{s:3:"nom";s:4:"PatV";s:4:"lien";s:31:"http://trad.spip.net/auteur/pat";}}s:2:"nl";a:1:{i:0;a:2:{s:3:"nom";s:7:"mpossoz";s:4:"lien";s:35:"http://trad.spip.net/auteur/mpossoz";}}s:2:"sk";a:2:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}i:1;a:2:{s:3:"nom";s:4:"PatV";s:4:"lien";s:31:"http://trad.spip.net/auteur/pat";}}s:2:"tr";a:0:{}}}s:21:"paquet-couteau_suisse";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:2:{i:0;a:2:{s:3:"nom";s:6:"Gilles";s:4:"lien";s:34:"http://trad.spip.net/auteur/gilles";}i:1;a:2:{s:3:"nom";s:5:"Paolo";s:4:"lien";s:33:"http://trad.spip.net/auteur/paolo";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd00ea3d1473e764e831f49ff65958a85'),
(137, 131, 'IMAPDEPART', 'http://files.spip.org/spip-zone/imagemap_departements.png', '000.002.000', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', 'Propose un mod�le pour afficher une carte de France avec une imagemap des d�partements:\r\n_ &lt;departements|lien_base=truc&gt; ou [(#MODELE{departements}{lien_base=truc})]\r\nqui accepte les param�tres suivants:\r\n-* |redim= : le facteur de redimensionnement de la carte (par d�faut = 1, ce qui correspond �  une carte de 479x434 pixels)\r\n-* |lien_base= : l''url des liens sur les d�partements (par d�faut #SELF donc la page en cours)\r\n-* |lien_param= : le param�tre de l''url pour passer le num�ro de d�partement (par d�faut "depart" : ...?depart=...)\r\n-* |param=nom : pour passer le nom du d�partement �  la place de son num�ro comme valeur du param�tre |lien_param\r\n-* |mono=1 si on souhaite la carte en monoteinte\r\n-* |aff_region=1 si on souhaite afficher la r�gion en plus du nom du d�partement dans l''info-bulle au survol\r\n-* |bullehtml=1 si on pr�fere l''info-bulle native HTML �  celle g�n�r�e en javascript (non-accessible lors de la navigation au clavier...)\r\n\r\nCr�dits:\r\n-* Source de la carte [Lionel Delvarre->http://www.lion1906.com/]', 'a:1:{i:0;a:3:{s:3:"nom";s:9:"cy_altern";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:0;s:4:"2010";}', 'http://www.spip-contrib.net/Plugin-image-map-des-departements', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-04-12 13:00:02', '2012-04-12 13:00:02', 1, 'imagemap_departements.zip', 99626, '2012-04-12 13:00:02', '_plugins_/imagemap_departements', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '46cd5af6744ce6845fb594aa7be61232');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(138, 132, 'IMAGESACTIVES', 'http://files.spip.org/spip-zone/imagesactives.png', '001.000.000', '', '[2.0.0;3.1.*[', '2.0,2.1,3.0,3.1', '', 'a:1:{i:1;a:3:{s:3:"nom";s:13:"Johan Pustoch";s:3:"url";s:39:"http://www.spip-contrib.net/?auteur7949";s:4:"mail";s:38:"johan.pustoch AT crdp.ac-versailles.fr";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:9:"SWFObject";s:3:"url";s:35:"http://code.google.com/p/swfobject/";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article4159', 'http://images-actives.crdp-versailles.fr/', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-07 10:00:03', '2012-06-07 10:00:03', 1, 'imagesactives.zip', 158705, '2012-06-07 10:00:04', '_plugins_/imagesactives/trunk', 'a:1:{s:13:"imagesactives";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'e270f34ff84aa8186a45b50cad7b3f05'),
(139, 133, 'INCLUREAJAXLOAD', '', '001.002.000', '', '[2.1.0;3.0.99]', '2.1,3.0', 'Ce plugin ajoute une option <code>{ajaxload}</code> �  la balise <code>#INCLURE</code>. La noisette n''est alors pas incluse, mais charg�e dynamiquement en Ajax au chargement de la page.\r\n\r\n	Autre m�thode: <code>{ajaxload=html}</code> fabrique une noisette statique (en HTML non dynamique) dans <code>/local/cache-ajaxload</code>, son appel se faisant ainsi hors SPIP. Le cache n''est donc plus g�r� par le <code>#CACHE</code> de SPIP; il est par d�faut de 2 heures, on peut le forcer en ajoutant le crit�re <code>{ttl_ajaxload=60*60*24}</code>.\r\n\r\n	Pour g�rer les chargements Ajax ÿ«�  la mainÿ», on peut r�cup�rer l''URL des noisettes en modifiant le crit�re:\r\n-- <code>{ajaxload=url}</code> retourne l''URL de la noisette dynamique;\r\n-- <code>{ajaxload=url_html}</code> retourne l''URL du fichier HTML statique.', 'a:2:{i:0;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:5:"ARNO*";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.paris-beyrouth.org/tutoriaux-spip/article/plugin-inclure-ajaxload', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-03-28 20:00:18', '2012-03-28 20:00:18', 1, 'inclure-ajaxload.zip', 5309, '2012-03-28 20:00:18', '_plugins_/inclure-ajaxload', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c8adf0bf904d0bc475c0fe8cccc06a34'),
(140, 134, 'INSERER_MODELES', 'http://files.spip.org/spip-zone/inserer_modeles_v1.png', '001.001.001', '', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin fournit une aide �  l''insertion des mod�les dans vos textes �  travers des formulaires de saisies. Ces formulaires sont accessibles dans la colonne de droite ou via un bouton dans le porte-plume.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:34:"http://www.spip-contrib.net/Joseph";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article3631', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:4:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.25.4;[";}s:8:"verifier";a:2:{s:3:"nom";s:8:"verifier";s:13:"compatibilite";s:8:"[0.1.1;[";}s:4:"yaml";a:2:{s:3:"nom";s:4:"yaml";s:13:"compatibilite";s:8:"[1.4.1;[";}s:8:"mediabox";a:1:{s:3:"nom";s:8:"mediabox";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-19 18:00:07', '2012-07-19 18:00:07', 1, 'inserer_modeles_v1.zip', 16984, '2012-07-19 18:00:08', '_plugins_/inserer_modeles/trunk', 'a:1:{s:15:"inserer_modeles";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '1e1b8011fc2549acc6bd9638a036d3aa'),
(141, 135, 'INTERTITRESTDM', 'http://files.spip.org/spip-zone/intertitres_hierarchises.png', '000.009.005', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', 'Ce plugin rajoute des raccourcis typographiques pour g�rer des niveaux d\'intertitres, num�rot�s ou non, dans Spip (Ce plugin peut r�utiliser les intertitres des enluminures typographiques). Il permet aussi d\'ajouter dans l''article, une table des mati�res qui liste les intertitres contenus dans l''article gr�¢ce �  un mod�le. D''autres mod�les permettent de se r�f�rer �  une sous-partie d\'un article dans un autre article (en citant le titre, extrait ou rien).', 'a:4:{i:0;a:3:{s:3:"nom";s:8:"Mortimer";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:7:"Chtitux";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:28:"Beurt pour la mise en plugin";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:32:"Paladin pour les ancres nomm�es";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 2";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-2.0.html";}}', '', 'http://www.spip-contrib.net/Des-intertitres-hierarchises-et', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-01 12:00:08', '2012-08-01 12:00:08', 1, 'intertitres_hierarchises.zip', 13960, '2012-08-01 12:00:08', '_plugins_/intertitres_hierarchises_et_table_matieres', 'a:1:{s:14:"IntertitresTdm";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '430afae506c0d09d98bfaccf2934463f'),
(142, 136, 'JAPPIX_MINI', 'http://files.spip.org/spip-zone/jappix_mini_v1.png', '001.000.000', '', '[3.0.0;3.*]', '', '<multi>\n[fr]Int�gration d\'un mini chat ([Jappix Mini->http://mini.jappix.com/]) dans les pages SPIP.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"davux";s:3:"url";s:20:"http://da.weeno.net/";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Jappix-Mini', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-03 16:00:15', '2012-09-03 16:00:15', 1, 'jappix_mini_v1.zip', 11323, '2012-09-03 16:00:16', '_plugins_/jappix_mini/trunk', 'a:1:{s:11:"jappix_mini";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"es";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '4e5dd3014659a86bace29bdcce4a0a88'),
(143, 137, 'JS_SCROLLER', 'http://files.spip.org/spip-zone/js_scroller.png', '001.044.001', '', '[2.0.0;[', '2.0,2.1,3.0,3.1', '<multi>\n[fr]{{Javascript Scroller :: un scroller javascript de donn�es XML}}\n\nCe plugin ajoute un widget javascript sous forme de banni�re d�filante pr�sentant une liste d''�l�ments SPIP du site.\n\nLe widget s''appelle en utilisant la balise : {{#JS_SCROLLER{width,height,type,maximum,coupe,direction,titre}}} avec :\n- {{width et height}} les dimensions ({par d�faut 600 x 20 pixels}),\n- {{type}} le type d''�l�ments SPIP pr�sent� ({par d�faut les articles}),\n- {{maximum}} le nombre d\'entr�es pr�sent�es ({par d�faut 50}),\n- {{coupe}} le nombre de caract�res du texte pr�sent� pour chaque entr�e ({par d�faut 40}),\n- {{direction}} la direction du texte ({par d�faut ''ltr'' : gauche->droite}),\n- {{titre}} le titre du bandeau ({valeur par d�faut selon le type - mettre ''non'' pour un titre vide}).\n\nLe code javascript du {scroller} est tir� de [->http://javascripts.vbarsan.com/].\n\nUne documentation interne est disponible lorsque le plugin est actif sur la page publique [js_scroller_documentation->../?page=js_scroller_documentation].\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"Piero Wbmstr";s:3:"url";s:39:"http://www.spip-contrib.net/PieroWbmstr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:4:"2009";}', 'http://www.spip-contrib.fr/?article3570', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-05-09 01:45:15', '2012-05-09 01:45:15', 1, 'js_scroller.zip', 25349, '2012-05-09 01:45:16', '_plugins_/js_scroller', 'a:1:{s:11:"js_scroller";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '880f136a87fbeb979d75bf7393e08533'),
(144, 138, 'JEUX', 'http://files.spip.org/spip-zone/jeux.png', '002.005.001', '0.17', '[3.0.0;3.0.99]', '3.0', '<multi>\n[fr]Des jeux avec SPIP !\n\nVoici pour vous la possibilit� d\'ins�rer dans vos articles des mots crois�s, des sudokus, des devinettes, des blagues, des po�sies, des QCM, des exercices �  trous, etc.\n\nMettez une touche �ducative et ludique �  votre site !\n\nDeux solutions :\n-* Des jeux cod�s en clair dans les articles entre les balises <code><jeux></code> et <code></jeux></code>.\n-* Des jeux cod�s dans l''espace priv� et accessibles gr�¢ce au mod�le <code><jeuXX></code> o�¹ XX est l''identifiant du jeu.\n\nL''enregistrement et la gestion des scores n''est possible qu''en utilisant la seconde solution.\n\nCe plugin fonctionne de fa�§on optimale sur les squelettes disposant de la balise [#INSERT_HEAD->http://www.spip.net/fr_article1902.html] et peut �galement �ªtre test� dans l''espace priv�.\n\n_* Pour les jeux graphiques, il faut avoir les librairies {{GD}} install�es sur votre server.\n_* Ce plugin est encore en �volution, proc�dez r�guli�rement �  vos mises �  jour.\n  \nAfin d''�viter les mauvaises surprises de pr�sentation (comme l''affichage des solutions dans les sommaires, rubriques, backends, etc.), pensez bien :\n-* soit �  placer une {{introduction}} dans votre article entre les balises <code><intro></code> et <code></intro></code>,\n-* soit �  remplir le {{descriptif}} de l''article.\n\nCr�dits :\n-* Icones : Jonathan Roche\n-* Travaux originaux :\n-** QCM : Mathieu Giannecchini\n-** Mots crois�s et scores : Ma�¯eul Rouquette\n-** Diagrammes d''�checs : Fran�§ois Schreuer\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:39:"Patrice VANNEUFVILLE, Ma�¯eul Rouquette";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:24:"GNU/LGPL - (c) 2006-2012";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Des-jeux-dans-vos-articles', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-17 16:00:32', '2012-08-17 16:00:32', 1, 'jeux.zip', 645398, '2012-08-17 16:00:34', '_plugins_/jeux/branches/jeux2', 'a:5:{s:4:"jeux";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:3:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"it";a:0:{}}}s:11:"motscroises";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:3:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"it";a:0:{}}}s:5:"pendu";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"it";a:0:{}}}s:3:"qcm";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"it";a:0:{}}}s:6:"sudoku";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"it";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '6826100adaa14580bf0f9e299d5ca5df'),
(474, 478, 'NOTATION', 'http://files.spip.org/spip-zone/notation-2.png', '002.000.004', '0.6.3', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[en]Defines the <code>#FORMULAIRE_NOTATION</code> tag which allows the capture and the display of the rating of a loop element.\n_ Defines the models <code><autxx|notation|id_article=yy></code> which gives the author''s rating <i>xx</i> for the article <i>yy</i>\nand <code><notation|topten></code> which gives the 10 best articles.\n[fa]تعرٿف برڿسب اجازٿ درٿافت ٿ ٿٿاٿش رتبٿ⿿ بٿدٿ عٿصرٿ از ٿٿ حٿٿٿ را ٿٿ⿿دٿد\n_تعرٿف ٿدٿ⿿ٿاٿ <code><autxx|notation|id_article=yy></code>ٿٿ رتبٿ بٿدٿ ٿٿٿسٿدٿ⿿ٿ<i>xx</i> ٿٿاٿٿ⿿ٿ <i>yy</i> را ٿٿ⿿أٿد ٿ ٿٿ <code><notation|topten></code> 10 ٿٿاٿٿ⿿ٿ برتر را ٿٿ⿿دٿد. \n\n[fr]D�finition de la balise <code>#FORMULAIRE_NOTATION</code> permettant la saisie et l''affichage de la note d\'un �l�ment de boucle.\n_ D�finition des mod�les <code><autxx|notation|id_article=yy></code> qui donne la note de l''auteur <i>xx</i> pour l''article <i>yy</i>\net <code><notation|topten></code> qui donne les 10 meilleurs articles.\n[ru]Тег <code>#FORMULAIRE_NOTATION</code> пѿедназнаѿен для вѿвода звезд голосования.\n_ поделѿ <code><autxx|notation|id_article=yy></code> исполѿзѿеѿся для вѿвода сѿаѿѿи.\n <code><notation|topten></code> вѿводиѿ 10 оѿенок..\n[sk]Definícia tagu <code> FORMULAIRE_NOTATION # </ code> na zadávanie a zobrazenie poznámky prvku cyklu.\n_ Definícia modelov <code> <autxx|notation|id_article=yy>,</ code> ktorá vypíše poznámku o autorovi <i> xx </ i> k článku <i> yy </ i>\na <code> <notation|topten> </ code> ktorá vypíše najlepších 10 článkov.\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:3:"JEM";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2008-2012";}', 'http://www.spip-contrib.net/Notation-d-elements-SPIP', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-09 11:00:01', '2012-09-09 11:00:01', 1, 'notation-2.zip', 68522, '2012-09-09 11:00:02', '_plugins_/notation/trunk', 'a:2:{s:8:"notation";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:5:"nazar";s:4:"lien";s:33:"http://trad.spip.net/auteur/nazar";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:15:"paquet-notation";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"en";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:5:"nazar";s:4:"lien";s:33:"http://trad.spip.net/auteur/nazar";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '199cb698e109fa08718e05027498ef62'),
(146, 139, 'JAZ', 'http://files.spip.org/spip-zone/joindre_auto_zone.png', '001.001.000', '', '[2.1.0;*]', '', '', 'a:1:{i:1;a:3:{s:3:"nom";s:27:"Cyril MARION - Ateliers CYM";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:13:"ÿ©2012 GPL v3";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Plugin-JAZ', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:14:"accesrestreint";a:2:{s:3:"nom";s:14:"accesrestreint";s:13:"compatibilite";s:8:"[3.0.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:14:"polyhierarchie";a:2:{s:3:"nom";s:14:"polyhierarchie";s:13:"compatibilite";s:8:"[1.0.0;]";}}}}', '2012-08-02 16:00:03', '2012-08-02 16:00:03', 1, 'joindre_auto_zone.zip', 22082, '2012-08-02 16:00:06', '_plugins_/joindre_auto_zone', 'a:1:{s:3:"jaz";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '80deefb73e736d6b21463a149e6d6766'),
(147, 140, 'JOOMLA2SPIP', 'http://files.spip.org/spip-zone/joomla2spip.png', '000.002.002', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '', 'a:1:{i:1;a:3:{s:3:"nom";s:21:"[BoOz->booz@rezo.net]";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Plugin-Porte-plume-partout', '', '', 'experimental', 1, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-17 13:00:13', '2012-06-17 13:00:13', 1, 'joomla2spip.zip', 21157, '2012-06-17 13:00:14', '_plugins_/joomla2spip', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '29ae4fa61cf0f2914ccf7ce47cf801ed'),
(148, 141, 'JPGRAPH', 'http://files.spip.org/spip-zone/jpgraph.png', '000.003.001', '', '[2.0.0;3.1.99[', '2.0,2.1,3.0,3.1', 'Int�gration de la biblioth�que JpGraph, pour r�aliser des graphes (histogrammes, courbes, camemberts, ...). Requiert PHP5.1 avec l''extension GD\r\n  \r\n  Une fois le plugin activ�, [consulter la page d�monstration->../spip.php?page=demo_jpgraph]', 'a:2:{i:0;a:3:{s:3:"nom";s:9:"erational";s:3:"url";s:24:"http://www.erational.org";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:15:"Olivier Gautier";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:7:"QPL 1.0";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/plugin-JpGraph', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:1:{i:0;a:1:{i:0;a:3:{s:3:"nom";s:13:"jpgraph-3.0.7";s:2:"id";s:13:"jpgraph-3.0.7";s:4:"lien";s:44:"http://jpgraph.net/download/download.php?p=1";}}}s:7:"utilise";a:0:{}}', '2012-07-31 10:00:09', '2012-07-31 10:00:09', 1, 'jpgraph.zip', 10080, '2012-07-31 10:00:10', '_plugins_/jpgraph', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c3d7f595380d32bc4250956904327c13'),
(149, 142, 'JQUERYCORNER', 'http://files.spip.org/spip-zone/jquery_corner.png', '000.004.002', '0.1', '[2.1.0;3.0.99]', '2.1,3.0', '<multi>\n[fr]Une adaptation pour Spip du plugin [JQuery Corner->http://jquery.malsup.com/corner/]\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"Yffic";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/JQuery-Corner', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:8:"[1.9.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-04 20:00:02', '2012-07-04 20:00:02', 1, 'jquery_corner.zip', 16005, '2012-07-04 20:00:04', '_plugins_/jquery_corner', 'a:1:{s:12:"jquerycorner";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ff47995ff095f01f01a3790313aa71be'),
(150, 143, 'JQUERYMASONRY', 'http://files.spip.org/spip-zone/jquery_masonry.png', '000.004.001', '0.1', '[2.1.0;3.0.99]', '2.1,3.0', '<multi>\n[fr]Une adaptation pour Spip du plugin [JQuery Masonry->http://masonry.desandro.com/]\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"Yffic";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/JQuery-Masonry', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:8:"[1.9.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-04-17 18:00:25', '2012-04-17 18:00:25', 1, 'jquery_masonry.zip', 18861, '2012-04-17 18:00:32', '_plugins_/jquery_masonry', 'a:1:{s:13:"jquerymasonry";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'b152b51d7748a658e793e938f66ac7eb'),
(151, 144, 'JQUERYSUPERFISH', 'http://files.spip.org/spip-zone/jquery_menu_superfish.png', '000.005.003', '0.2', '[2.1.0;3.0.99]', '2.1,3.0', '<multi>\n[fr]Une adaptation pour Spip du plugin [jQuery Superfish->http://users.tpg.com.au/j_birch/plugins/superfish/ �  partir d\'une structure ul/li g�n�r�e par exemple par le plugin [Menus->http://www.spip-contrib.net/Menus,3139]\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"Yffic";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Menu-jQuery-Superfish', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.25.5;[";}s:4:"YAML";a:2:{s:3:"nom";s:4:"YAML";s:13:"compatibilite";s:6:"[1.5;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-05-20 19:00:03', '2012-05-20 19:00:03', 1, 'jquery_menu_superfish.zip', 29509, '2012-05-20 19:00:04', '_plugins_/jquery_menu_superfish', 'a:1:{s:15:"jquerysuperfish";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '0623dff5c63ae298a86ad9e2bbed5572'),
(152, 145, 'KAYE', 'http://files.spip.org/spip-zone/kaye.png', '003.000.005', '1.0.0', '[3.0.0-rc;3.0.*]', '3.0', '<multi>\n[fr]Un cahier de texte �lectronique pour l\'�cole primaire.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:15:"C�dric Couvrat";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', '', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:1:{i:0;a:3:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.24.0;]";}s:8:"verifier";a:2:{s:3:"nom";s:8:"verifier";s:13:"compatibilite";s:9:"[0.1.16;]";}s:8:"jqueryui";a:2:{s:3:"nom";s:8:"jqueryui";s:13:"compatibilite";s:9:"[1.8.20;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-21 10:00:02', '2012-07-21 10:00:02', 1, 'kaye.zip', 101677, '2012-07-21 10:00:06', '_plugins_/kaye/trunk', 'a:3:{s:6:"classe";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}s:6:"devoir";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}s:4:"kaye";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd68ce88eb8d761f4655f49608dc2e832'),
(153, 146, 'LANGONET', 'http://files.spip.org/spip-zone/langonet.png', '000.007.004', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', 'Ce plugin permet d\'ex�cuter des actions de v�rification et de nettoyage des fichiers de langue de SPIP, des plugins ou des squelettes. Il est aussi possible de consulter l''ensemble des items contenus dans les fichiers de langue disponibles sur le site et d\'effectuer des recherches d\'items dans les fichiers de langue de SPIP. Sous certaines conditions, il produit automatiquement des items de langue �  partir des textes libres rep�r�s.', 'a:4:{i:0;a:3:{s:3:"nom";s:14:"Eric Lupinacci";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:6:"denisb";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:3:"esj";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:5:"kent1";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/langOnet-Presentation-generale', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{i:0;a:4:{s:2:"id";s:10:"Iterateurs";s:3:"nom";s:10:"Iterateurs";s:7:"version";s:8:"[0.2.5;]";s:13:"compatibilite";s:8:"[0.2.5;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-16 04:00:45', '2012-08-16 04:00:45', 1, 'langonet.zip', 65445, '2012-08-16 04:00:46', '_plugins_/langonet', 'a:1:{s:8:"langonet";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '2bb89b8202aeb70179dce2fda3205baa'),
(154, 147, 'LANGUEPREFEREE', 'http://files.spip.org/spip-zone/langue_preferee.png', '000.004.002', '', '[1.9.2;3.0.99]', '1.9,2.0,2.1,3.0', '<multi>\r\n		[fr]Ce plugin permet d\'identifier les langues pr�f�r�es configur�es par l''internaute dans son navigateur et de lui proposer automatiquement la langue la plus pertinente dans un site multilingue ayant un secteur par langue.\r\nCe m�canisme suppose qu''il n''y a pas de page sommaire particuli�re, les pages d\'accueil localis�es �tant des pages de secteurs.\r\n\r\nUtilisez la balise <code>#LANGUE_PREFEREE_SECTEUR_REDIRECTION</code> en ins�rant le code suivant dans <code>sommaire.html</code>, �  l''exclusion de tout autre code, pour que l''internaute soit redirig� automatiquement vers le secteur qu''il est le plus susceptible de comprendre, selon la configuration de langue de son navigateur : <code>[(#LANGUE_PREFEREE_SECTEUR_REDIRECTION|sinon{Activer le plugin langue_preferee})]</code>\r\n\r\nSi aucune langue disponible n''est compatible avec les choix configur�s dans le navigateur, la langue par d�faut du site est choisie. Si cette langue n''est utilis�e par aucun secteur (!!!), le premier secteur trouv� est choisi.\r\nIl est possible de filtrer le ou les secteurs pour ne par rediriger vers un secteur non souhait�. Pour cela mettez la liste des secteurs non souhait�s s�par�s par des virgules en param�tre de <code>#LANGUE_PREFEREE_SECTEUR_REDIRECTION</code>, par exemple : <code>#LANGUE_PREFEREE_SECTEUR_REDIRECTION{"3,12"}</code>, la balise ne pourra pas rediriger ni vers le secteur 3, ni vers le 12.\r\n\r\nIl est possible de laisser l''internaute choisir sa langue pr�f�r�e, diff�rente de celle configur�e dans son navigateur, en la pr�cisant en param�tre d\'appel du sommaire, avec <code>/?lang=fr</code> par exemple pour le fran�§ais. Ce choix est alors stock� dans un cookie pour utilisation ult�rieure prioritaire sur la configuration du navigateur. La balise <code>#LANGUE_PREFEREE_LIEN_EFFACE_COOKIE</code> permet de proposer un lien de suppression de ce cookie.\r\n<code>#LANGUE_PREFEREE_LIEN_EFFACE_COOKIE{mon message personnalise}</code> permet de remplacer le message propos� par d�faut.\r\n	[en]This plugin (for SPIP 1.9.2+ and 2.0.0+) checks the visitor browser prefered languages and redirects automagically to this language within a multi language website having one section per language. It requiers not to have a specific sommaire page, the home pages will be localized to each sectors.\r\n\r\nUse only the <code>#LANGUE_PREFEREE_SECTEUR_REDIRECTION</code> tag by putting the following code in <code>sommaire.html</code>, but any other code, allowing each visitors to be redirected to the most meaningful sector: [(#LANGUE_PREFEREE_SECTEUR_REDIRECTION|sinon{Activate the langue_preferee plugin})]\r\n\r\nIf not any website language suits the visitor''s preferred language, the website default language is selected. By the way, if this language is not used by any sector (yes you can !), the first avalaible sector is selected. It''s also possible to exclude some sectors from the possible redirections. In this case, just add as parameter a comma seperated list of unwanted sectors to <code>#LANGUE_PREFEREE_SECTEUR_REDIRECTION</code>, for example: <code>#LANGUE_PREFEREE_SECTEUR_REDIRECTION{"3,12"}</code>, the tag can not redirect to sector 3 or 12.\r\n\r\nIt''s possible to let the visitor choose it''s own preferred language, that may be different from its browser, by adding (for example selecting english) <code>/?lang=en</code> calling sommaire page. Therefore this choice is stored in a cookie for further use and will take precedence to the browser preference. The <code>#LANGUE_PREFEREE_LIEN_EFFACE_COOKIE</code> tag allows you to add a link allowing to remove this cookie. Using a parameter like: <code>#LANGUE_PREFEREE_LIEN_EFFACE_COOKIE{my own message}</code> prompts your "own message" instead of the default one.\r\n		</multi>', 'a:3:{i:0;a:3:{s:3:"nom";s:14:"Nicolas Hoizey";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:6:"Chryjs";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:7:"BobCaTT";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Plugin-Langue-preferee-par-l-internaute', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-10 00:00:11', '2012-08-10 00:00:11', 1, 'langue_preferee.zip', 17360, '2012-08-10 00:00:12', '_plugins_/langue_preferee', 'a:1:{s:14:"languepreferee";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '7c3436950b69d9a2f144f099875d22a7'),
(155, 148, 'LATEXWHEEL', 'http://files.spip.org/spip-zone/latexwheel.png', '001.000.000', '', '[3.0.0 ;[', '3.0,3.1', '', 'a:1:{i:1;a:3:{s:3:"nom";s:17:"Ma�¯eul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Livre-avec-SPIP', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:2:"tw";a:1:{s:3:"nom";s:2:"tw";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:7:"zippeur";a:2:{s:3:"nom";s:7:"zippeur";s:13:"compatibilite";s:8:"[2.0.0;[";}}}}', '2012-03-27 22:00:56', '2012-03-27 22:00:56', 1, 'latexwheel.zip', 45669, '2012-03-27 22:00:58', '_plugins_/latexwheel/trunk', 'a:1:{s:10:"latexwheel";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '3fe3a35ab423bf141c2a0a84c11d9e3e'),
(156, 149, 'PLAYER', 'http://files.spip.org/spip-zone/lecteur_multimedia-2.png', '002.001.001', '0.2.4', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en]This plugin allows to read and display sounds and videos.\nIt adds flash player suitable the formats .mp3.\nIt works on all <code><docXX|player></code> inserted in the texts, as well as in the templates.\n\n-* In a text, <code><docXX|player></code>, displays a flash audio player (several players to choose from);\n-* In a template <code>#MODELE{playliste}</code> displays a playlist of the latest mp3\n[fa]ÿ§ÿŠÿ⿠ ÿ¾ÿ⿿ÿ§ÿ¯ÿŠÿ⿠ ÿ¨ÿ⿡ ÿ´ÿ⿦ÿ§ ÿ§ÿ¬ÿ§ÿ²ÿ⿡ ÿ⿦ÿŠâ⿬ſÿ¯ÿ⿡ÿ¯ ÿµÿ¯ÿ§ ÿ˿ ÿ˿ÿŠÿ¯ÿ¦ÿ˿ ÿ±ÿ§ ÿ¨ÿ®ÿ˿ÿ§ÿ⿠ÿŠÿ¯ ÿ˿ ÿ⿠ÿ⿦ÿ§ÿŠÿ´ ÿ¯ÿ⿡ÿŠÿ¯. \nÿ⿡ÿ⿦ÿ⿠ÿ⿠ÿŠÿ⿠ ÿÿ⿿ÿ§ÿ´ ÿ¾ÿ⿿ÿŠâ⿬ſÿŠÿ± ÿ⿦ÿ⿠ÿ§ÿ³ÿ¨ ÿÿ±ÿ⿦ÿª ÿ§ÿ⿦.ÿ¾ÿŠ.3 (.mp3) ÿ±ÿ§ ÿ§ÿ¶ÿ§ÿÿ⿡ ÿ⿦ÿŠâ⿬ſÿƿÿ⿠ÿ¯. \n\nÿ§ÿŠÿ⿠ ÿ¾ÿ⿿ÿ§ÿ¯ÿŠÿ⿠ ÿ±ÿ˿ÿŠ ÿªÿ⿦ÿ§ÿ⿦ <code><docXX|player></code> ÿƿÿ⿡ ÿ¯ÿ± ÿ⿦ÿªÿ⿠â⿬ſÿ⿡ÿ§ ÿ˿ ÿ⿠ÿŠÿ² ÿ¯ÿ± ÿªÿ⿦ÿ¾ÿ⿿ÿ³ÿªâ⿬ſÿ⿡ÿ§ ÿ¯ÿ⿠ÿ¬ÿ§ÿ¯ÿ⿡ ÿ´ÿ¯ÿ⿡ ÿ¨ÿ§ÿ´ÿ¯ÿſ ÿƿÿ§ÿ± ÿ⿦ÿŠâ⿬ſÿƿÿ⿠ÿ¯ \n-* ÿ¯ÿ± ÿ⿦ÿªÿ⿠ÿſ  <code><docXX|player></code>,  ÿŠÿƿ ÿÿ⿿ÿ§ÿ´ ÿ§ÿ˿ÿ¯ÿŠÿ˿ ÿ¾ÿ⿿ÿŠâ⿬ſÿŠÿ± (ÿ⿠ÿ⿠ÿ¯ ÿ¾ÿ⿿ÿŠâ⿬ſÿŠÿ± ÿ¨ÿ±ÿ§ÿŠ ÿ§ÿ⿠ÿªÿ®ÿ§ÿ¨ ÿ§ÿ² ÿ⿦ÿŠÿ§ÿ⿠ ÿ¢ÿ⿠â⿬ſÿ⿡ÿ§) ÿ±ÿ§ ÿ⿠ÿ´ÿ§ÿ⿠ ÿ⿦ÿŠâ⿬ſâ⿬ſÿ¯ÿ⿡ÿ¯\n-* ÿ¯ÿ± ÿŠÿƿ ÿªÿ⿦ÿ¾ÿ⿿ÿŠÿªÿſ <code>#MODELE{playliste}</code> ÿŠÿƿ ÿÿ⿡ÿ±ÿ³ÿª ÿ¾ÿ®ÿ´  ÿ§ÿ² ÿ¢ÿ®ÿ±ÿŠÿ⿠ ÿ§ÿ⿦â⿬ſ.ÿ¾ÿŠ.3 ÿ±ÿ§ ÿ⿠ÿ´ÿ§ÿ⿠ ÿ⿦ÿŠâ⿬ſÿ¯ÿ⿡ÿ¯\n\n[fr]Ce plugin permet la lecture et l''affichage de sons ou de vid�os.\nIl ajoute des lecteurs flash adapt�s aux formats .mp3.\nIl agit sur tous les <code><docXX|player></code> ins�r�s dans les textes, aussi bien que dans les squelettes.\n\n-* Dans un texte <code><docXX|player></code> affiche un lecteur flash audio (plusieurs lecteurs au choix);\n-* Dans un squelette <code>#MODELE{playliste}</code> permet d\'afficher une playliste des derniers mp3\n[ru]ÐŸÐ»Ð°Ð³Ð¸Ð½ Ð¿Ð¾Ð·Ð²Ð¾Ð»ÿÐµÿ⿿ Ð¿ÿ⿬Ð¾Ð¸Ð³ÿ⿬ÿ⿹Ð²Ð°ÿ⿿ÿſ Ð°ÿƿÐ´Ð¸Ð¾ Ð¸ Ð²Ð¸Ð´ÐµÐ¾ ÿ⿿Ð°Ð¹Ð»ÿ⿹ Ð½Ð° ÿÐ°Ð¹ÿ⿿Ðµ. ÐžÐ½ Ð´Ð¾Ð±Ð°Ð²Ð»ÿÐµÿ⿿ ÿ⿿Ð»Ðµÿ˿ Ð¿Ð»ÐµÐµÿ⿬ Ð¿Ð¾Ð´Ð´Ðµÿ⿬Ð¶Ð¸Ð²Ð°ÿŽÿ⿰Ð¸Ð¹ ÿ⿿Ð¾ÿ⿬Ð¼Ð°ÿ⿿ mp3.\n\nÐŸÐ»ÐµÐµÿ⿬ Ð²ÿ⿹Ð²Ð¾Ð´Ð¸ÿ⿿ÿÿ Ð¿ÿ⿬Ð¸ Ð²ÿ⿹Ð²Ð¾Ð´Ðµ Ð´Ð¾ÐºÿƿÐ¼ÐµÐ½ÿ⿿Ð° ÐºÐ¾Ð´Ð¾Ð¼ <code><docXX|player></code> ÐºÐ°Ðº Ð² ÿÿ⿿Ð°ÿ⿿ÿſÐµ, ÿ⿿Ð°Ðº Ð¸ Ð² ÿ˿Ð°Ð±Ð»Ð¾Ð½Ðµ.\n\n-* Ð⿿ ÿ⿿ÐµÐºÿÿ⿿Ðµ Ð½Ð° ÿÐ°Ð¹ÿ⿿Ðµ <code><docXX|player></code> Ð²ÿ⿹Ð²Ð¾Ð´Ð¸ÿ⿿ÿÿ ÐºÐ°Ðº flash Ð¿Ð»ÐµÐµÿ⿬ (Ðµÿÿ⿿ÿſ Ð½ÐµÿÐºÐ¾Ð»ÿſÐºÐ¾ Ð²Ð°ÿ⿬Ð¸Ð°Ð½ÿ⿿Ð¾Ð² Ð¿Ð»ÐµÐµÿ⿬ Ð½Ð° Ð²ÿ⿹Ð±Ð¾ÿ⿬);\n-* Ð⿿ ÿ˿Ð°Ð±Ð»Ð¾Ð½Ðµ <code>#MODELE{playliste}</code> Ð¾ÿ⿿Ð¾Ð±ÿ⿬Ð°Ð¶Ð°Ðµÿ⿿ ÿÐ¿Ð¸ÿÐ¾Ðº Ð¿Ð¾ÿÐ»ÐµÐ´Ð½Ð¸ÿ⿦ mp3 ÿ⿿Ð°Ð¹Ð»Ð¾Ð²\n[sk]Tento z�¡suvn�½ modul umoÿ¾ÿ˿uje prehr�¡vanie aÿ zobrazenie zvukov alebo vide�­.\nPrid�¡va �ºdaje zoÿ zariaden�­ USB voÿ form�¡te .mp3.\nFunguje na vÿ¡etk�½ch <code><docXX|player></code> vloÿ¾en�½ch vÿ texte, ako aj vÿ ÿ¡abl�³nach.\n\n-* v texte <code><docXX|player></code> zobraz�­ �ºdaje zoÿ zariaden�­ USB (m�´ÿ¾ete si vybraÿ¥ zÿ viacer�½ch zariaden�­),\n-* v ÿ¡abl�³ne <code>#MODELE{playliste}</code> umoÿ¾ÿ˿uje zobraziÿ¥ zoznam skladieb zÿ posledn�½ch mp3\n</multi>', 'a:4:{i:1;a:3:{s:3:"nom";s:4:"BoOz";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:7:"C�dric";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:9:"erational";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:4;a:3:{s:3:"nom";s:3:"CP.";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Lecteur-Multimedia', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-20 04:00:21', '2012-08-20 04:00:21', 1, 'lecteur_multimedia-2.zip', 217771, '2012-08-20 04:00:22', '_plugins_/player/trunk', 'a:2:{s:13:"paquet-player";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:6:"player";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:2:{i:0;a:2:{s:3:"nom";s:6:"Gilles";s:4:"lien";s:34:"http://trad.spip.net/auteur/gilles";}i:1;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '8e5abe22878ac730688d49d90c8714cc'),
(157, 150, 'LEGENDES', 'http://files.spip.org/spip-zone/legendes.png', '001.000.002', '0.1', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en]A plugin to add captions on pictures as Flickr. inspired from [Fotonotes->http://www.fotonotes.net/] and based on the script [jQuery Image Annotation->http://www.flipbit.co.uk/jquery-image-annotation.html].\n[fr]Un plugin pour ajouter des l�gendes �  ses images comme sur Flickr. Inspir� de [Fotonotes->http://www.fotonotes.net/] et bas� sur le script [jQuery Image Annotation->http://www.flipbit.co.uk/jquery-image-annotation.html].\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Legendes', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:3:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:6:"[1.1;[";}s:8:"jqueryui";a:2:{s:3:"nom";s:8:"jqueryui";s:13:"compatibilite";s:8:"[1.8.2;[";}s:6:"medias";a:2:{s:3:"nom";s:6:"medias";s:13:"compatibilite";s:9:"[2.7.28;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-03 16:00:32', '2012-07-03 16:00:32', 1, 'legendes.zip', 29431, '2012-07-03 16:00:34', '_plugins_/legendes', 'a:1:{s:8:"legendes";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '9df7a9611ae389d3b4aaba39e3151091'),
(158, 151, 'LICENCE', 'http://files.spip.org/spip-zone/licence.png', '000.004.003', '0.2.0', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\n[en]Link a license on articles and documents\n[fr]Permet de relier une licence d\'utilisation �  un article ou un document\n[sk]Umoÿ¾ÿ˿uje prepojiÿ¥ licenciu na pouÿ¾�­vanie sÿ ÿl�¡nkom alebo dokumentom\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:7:"fanouch";s:3:"url";s:0:"";s:4:"mail";s:21:"lesguppies AT free.fr";}i:2;a:3:{s:3:"nom";s:9:"erational";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/spip.php?article2147', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-08 20:00:06', '2012-08-08 20:00:06', 1, 'licence.zip', 111908, '2012-08-08 20:00:08', '_plugins_/licence', 'a:2:{s:7:"licence";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:7:{s:2:"ca";a:0:{}s:2:"de";a:1:{i:0;a:2:{s:3:"nom";s:7:"klaus++";s:4:"lien";s:33:"http://trad.spip.net/auteur/klaus";}}s:2:"en";a:3:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}i:1;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}i:2;a:2:{s:3:"nom";s:4:"Mark";s:4:"lien";s:32:"http://trad.spip.net/auteur/mark";}}s:2:"fr";a:0:{}s:5:"fr_tu";a:1:{i:0;a:2:{s:3:"nom";s:8:"beatnick";s:4:"lien";s:36:"http://trad.spip.net/auteur/beatnick";}}s:2:"it";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:14:"paquet-licence";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '2c00167d6559a415acabf4693cc556e4'),
(159, 152, 'LINKS', 'http://files.spip.org/spip-zone/links.png', '002.003.005', '', '[2.0.0;3.0.*]', '2.0,2.1,3.0', '<multi>\r\n		[fr]Styles et pictos explicitant les liens du site : documents �  t�l�charger, liens externes, mailto, etc. (avec ouverture possible en nouvelle fen�ªtre).\r\n	</multi>', 'a:3:{i:0;a:3:{s:3:"nom";s:14:"romy.tetue.net";s:3:"url";s:21:"http://romy.tetue.net";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:13:"C�dric Morin";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:13:"Gael Chareyre";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article3706', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:2:{s:14:"[2.0.0;2.1.99]";a:1:{i:0;a:4:{s:2:"id";s:10:"spip_bonux";s:3:"nom";s:10:"spip_bonux";s:7:"version";s:9:"[2.2.18;]";s:13:"compatibilite";s:9:"[2.2.18;]";}}i:0;a:0:{}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-02-22 12:00:02', '2012-02-22 12:00:02', 1, 'links.zip', 17953, '2012-02-22 12:00:04', '_plugins_/links', 'a:1:{s:5:"links";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '20231934508c17baf0ccb6ce1b2afed3'),
(160, 153, 'LOGAHOLIC', 'http://files.spip.org/spip-zone/logaholic.png', '000.000.002', '', '[1.9.2;3.0.*]', '1.9,2.0,2.1,3.0', '<multi>\n[fr]Ajoute automatiquement le script Logaholic dans l''espace public en ins�rant le num�ro du site dans la base g�n�ral de Logaholic dans la configuration.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:11:"Pierre KUHN";s:3:"url";s:26:"http://www.pierre-kuhn.org";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/?article4153', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-24 17:00:02', '2012-06-24 17:00:02', 1, 'logaholic.zip', 43546, '2012-06-24 17:00:02', '_plugins_/logaholic', 'a:1:{s:9:"logaholic";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '879fd6393dc5598b594aa790775fd56d'),
(161, 154, 'MALETTRE', 'http://files.spip.org/spip-zone/ma-lettre_3_0.png', '003.000.002', '1.0.0', '[3.0.0-dev;3.0.*]', '3.0', '<multi>\n[fr]Cr�er le contenu d\'une newsletter en s�lectionnant manuellement �dito, articles, �v�nements \r\n    pour l''envoyer ensuite �  un gestionnaire de listes de type SYMPA, Mailman, ... \n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:9:"erational";s:3:"url";s:24:"http://www.erational.org";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:6:"GPL v3";s:3:"url";s:0:"";}}', 'a:1:{i:1;s:4:"2012";}', 'http://www.spip-contrib.net/Plugin-Ma-lettre', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.19.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-11 11:00:08', '2012-06-11 11:00:08', 1, 'ma-lettre_3_0.zip', 49288, '2012-06-11 11:00:08', '_plugins_/ma-lettre/trunk', 'a:1:{s:8:"malettre";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"nl";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '00b07235d04cc7043818956c22f7db56'),
(162, 155, 'MAILCRYPT', 'http://files.spip.org/spip-zone/mailcrypt.png', '002.003.000', '', '[2.1.0;3.0.99]', '2.1,3.0', '<multi>\n[fr]MailCrypt remplace les liens de courriels dans vos textes par un lien javascript afin d''�viter que des robots spammeurs ne collectent les emails affich�s sur votre site. La modification est transparente sur un navigateur disposant de javascript. Lorsque javascript n''est pas install�, le mail reste compr�hensible par un �ªtre humain.\n</multi>', 'a:4:{i:1;a:3:{s:3:"nom";s:14:"Alexis Roussel";s:3:"url";s:42:"http://www.spip-contrib.net/Alexis-Roussel";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"Paolo";s:3:"url";s:33:"http://www.spip-contrib.net/paolo";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:20:"Patrice Vanneufville";s:3:"url";s:48:"http://www.spip-contrib.net/Patrice-Vanneufville";s:4:"mail";s:0:"";}i:4;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:34:"http://www.spip-contrib.net/Joseph";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/?article3828', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-20 18:00:13', '2012-06-20 18:00:13', 1, 'mailcrypt.zip', 33395, '2012-06-20 18:00:14', '_plugins_/mailcrypt', 'a:1:{s:9:"mailcrypt";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '7059d72395f70c26912a18fe877c9c05');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(163, 156, 'MANUELSITE', 'http://files.spip.org/spip-zone/manuel_site.png', '000.008.001', '0.2', '[2.1.0;3.0.99]', '2.1,3.0', '<multi>\n[en]This plugin displays an help icon on every page of the private space showing the Website Editor Manual. This manual is an article of the website. The plugin also provides a set of Frequently Asked Questions that can be easily inserted in your manual.\n[fr]Ce plugin installe une ic�´ne d\'aide permettant d\'afficher depuis n''importe quelle page de l''espace priv� le manuel de r�daction du site. Ce manuel est un article du site. Le plugin fournit �galement un jeu d\'item de Foire Aux Questions courants pouvant �ªtre ins�r�s facilement dans votre manuel.\n[sk]Tento z�¡suvn�½ modul nainÿ¡taluje ikonu pomocn�­ka, ktor�¡ umoÿ¾ÿ˿uje zobraziÿ¥ hociktor�º str�¡nku tohto manu�¡lu na publikovanie zoÿ s�ºkromnej z�³ny. Tento manu�¡l je ÿl�¡nok na str�¡nke. Z�¡suvn�½ modul pon�ºka ajÿ ÿasÿ¥ ÿſast� ot�¡zky, ktor�º m�´ÿ¾ete do svojho manu�¡lu ÿ¾ahko vloÿ¾iÿ¥.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"Yffic";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Manuel-de-redaction-du-site', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:8:"[1.9.0;[";}s:4:"yaml";a:2:{s:3:"nom";s:4:"yaml";s:13:"compatibilite";s:6:"[1.1;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:7:"palette";a:2:{s:3:"nom";s:7:"palette";s:13:"compatibilite";s:8:"[1.2.2;[";}s:5:"pages";a:2:{s:3:"nom";s:5:"pages";s:13:"compatibilite";s:8:"[0.3.5;[";}}}}', '2012-07-28 04:00:33', '2012-07-28 04:00:33', 1, 'manuel_site.zip', 46521, '2012-07-28 04:00:34', '_plugins_/manuel_site', 'a:3:{s:14:"faq-manuelsite";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:10:"manuelsite";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:2:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}i:1;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}}}s:17:"paquet-manuelsite";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '57ffbfb88b23063337ac7ab9ddbd98ec'),
(164, 157, 'MASQUER', 'http://files.spip.org/spip-zone/masquer.png', '000.005.000', '', '[2.0.0;3.99.99]', '2.0,2.1,3.0,3.1', 'Ce plugin permet de masquer sur le site public les contenus qui ont un mot cl� dont le titre est ÿ« masquer ÿ». Si une rubrique est masqu�e, toute sa branche l''est aussi. Seuls les rubriques et articles sont g�r�s dans un premier temps. Il suffit d\'ajouter le crit�re <code>{tout_voir}</code> aux boucles pour forcer l''affichage des contenus masqu�s.', 'a:3:{i:0;a:3:{s:3:"nom";s:14:"Nicolas Hoizey";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:30:"St�phanie Caron de Clever Age";s:3:"url";s:26:"http://www.clever-age.com/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:20:"Patrice Vanneufville";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Plugin-masquer', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-04 04:00:08', '2012-06-04 04:00:08', 1, 'masquer.zip', 10757, '2012-06-04 04:00:08', '_plugins_/masquer', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'a5cf36f556718aedf3c767e4ab6f6479'),
(473, 477, 'NOSPAM', 'http://files.spip.org/spip-zone/nospam.png', '001.000.003', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\n	[fr]Halte au spam ! Filtrez les spams dans les messages, sans nuisance pour les utilisateurs honnêtes.\n	[en]Stop spam! Filter spam in messages, without nuisance to honest users.\n	[es]Detenga el spam! Filtro de spam en los mensajes, sin molestias a los usuarios honestos.\n	[ar]تٿٿف اٿٿتطفٿ! فٿتر اٿبرٿد اٿٿزعج فٿ اٿرسائٿ ؿ دٿٿ ازعاج ٿٿستخدٿ صادٿ.\n	[de]SPAM stoppen! Ein Filter ohne Nebenwirkungen für ehrliche Nutzer.\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:7:"Yterium";s:3:"url";s:22:"http://www.yterium.net";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:21:"Superyms (Traduction)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:0;s:4:"2008";}', 'http://www.spip-contrib.net/?rubrique1165', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-16 04:00:39', '2012-09-16 04:00:39', 1, 'nospam.zip', 41817, '2012-09-16 04:00:40', '_plugins_/nospam', 'a:1:{s:6:"nospam";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:6:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/جٿرج-ٿٿدٿفت";}}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '08f51df1682f268525dbb375f6bab699'),
(166, 159, 'ACCORDEON', 'http://files.spip.org/spip-zone/menu_accordeon3.png', '003.001.000', '', '[3.0.0;3.0.99]', '3.0', '<multi>\n[fr]Ce plugin permet d\'appliquer �  une structure ul/li un effet accord�on (pr�sentation ÿ« en tiroir ÿ»). Il utilise le script <a href="http://jqueryui.com/demos/accordion/">jQuery UI Accordeon</a>. Le travail de g�n�ration de la structure ul/li peut-�ªtre d�l�gu� au plugin Menus ou �  une noisette Aveline par exemple ou m�ªme g�r� ind�pendamment en squelette. Il suffit de donner au ul principal la classe accordeon.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:30:"Ma�¯eul Rouquette d\'apr�s b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article3763', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:8:"jqueryui";a:1:{s:3:"nom";s:8:"jqueryui";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:5:"menus";a:2:{s:3:"nom";s:5:"menus";s:13:"compatibilite";s:9:"[0.8.10;[";}}}}', '2012-08-14 13:00:25', '2012-08-14 13:00:25', 1, 'menu_accordeon3.zip', 39173, '2012-08-14 13:00:30', '_plugins_/menu_accordeon/trunk', 'a:1:{s:9:"accordeon";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'fd35a8b2607103ad38918f3403e44546'),
(167, 160, 'BABBI', 'http://files.spip.org/spip-zone/menu_babbibel.png', '003.000', '', '[1.9.2;3.0.99)', '1.9,2.0,2.1,3.0', '', 'a:1:{i:1;a:3:{s:3:"nom";s:8:"babbibel";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/spip.php?article3055', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-30 22:00:01', '2012-07-30 22:00:01', 1, 'menu_babbibel.zip', 38293, '2012-07-30 22:00:02', '_plugins_/menu_babbibel/tags/stable', 'a:1:{s:5:"babbi";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '2db1b0308f693d842ad60703843d3c55'),
(168, 161, 'MLL', 'http://files.spip.org/spip-zone/Menu_langue_lien.png', '001.001.007', '', '[2.0.10;3.0.*]', '2.0,2.1,3.0', '<multi>\n[en]Replace the original language menu by a clickable menu. This menu is displayed only if at least two languages are â⿬⿹â⿬⿹actually used on the site.\n[fr]Remplace le menu d�roulant de langues par un menu cliquable. Ce menu n''est affich� que s''il y a au moins 2 langues vraiment utilis�es dans le site.\n[sk]Rozbaÿ¾ovacie menu sÿ jazykmi nahrad�­ klikateÿ¾n�½m. Toto menu sa nezobraz�­, ak sa na str�¡nke naozaj nepouÿ¾�­vaj�º aspoÿ˿ 2ÿ jazyky.\n</multi>', 'a:4:{i:1;a:3:{s:3:"nom";s:7:"Jacques";s:3:"url";s:43:"http://www.spip-contrib.net/_Jacques-PYRAT_";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:21:"Jean-Baptiste Pressac";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:5:"kent1";s:3:"url";s:21:"http://www.kent1.info";s:4:"mail";s:0:"";}i:4;a:3:{s:3:"nom";s:13:"C�dric Morin";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:17:"ic�´ne par FatCow";s:3:"url";s:32:"http://www.fatcow.com/free-icons";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2009-2012";}', 'http://www.spip-contrib.net/Menu-de-langues-sous-forme-de-liens', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:10:"spip_bonux";a:2:{s:3:"nom";s:10:"spip_bonux";s:13:"compatibilite";s:12:"[3.0.0-dev;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:7:"tradrub";a:2:{s:3:"nom";s:7:"tradrub";s:13:"compatibilite";s:8:"[2.1.1;[";}}}}', '2012-07-26 13:15:37', '2012-07-26 13:15:37', 1, 'Menu_langue_lien.zip', 26423, '2012-07-26 13:15:38', '_plugins_/menu_langues_liens', 'a:2:{s:3:"mll";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:10:"paquet-mll";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '10db9d9fd00fd7bb5eaa69791710c5f0'),
(169, 162, 'MENUS', 'http://files.spip.org/spip-zone/menus.png', '000.009.002', '0.5.0', '[2.0.9;3.0.*]', '2.0,2.1,3.0', '<multi>\n[de]Men�¼s bequem im Redaktionssystem gestalten.\n[en]Create your own custom menus.\n[fr]Lorsqu''on ne se sert pas du plugin {{Menus}}, on est oblig� de d�finir tous ses menus dans les squelettes,\n	ce qui fait que les administrateurs du site n''ont pas directement la main dessus et que lorsqu''ils veulent y changer quelque chose, ils sont oblig�s\n	d\'en faire la demande �  la personne en charge des squelettes. De plus, lorsqu''on veut des liens statiques (un lien vers un article pr�cis,\n	ou vers une page pr�cise, ou vers un site externe) il faut les �crire en dur dans le squelette du menu.\n\n	Le but du plugin {{Menus}} est donc de permettre de facilement �laborer des menus au moyen d\'une interface conviviale, directement dans la partie priv�e.\n	{{Attention !}} Ce plugin ne s''occupe pas de la mani�re dont seront affich�s les menus. Il permet de les cr�er facilement et d\'en g�n�rer le code HTML.\n[it]Crea i tuoi men�¹ in redazione.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:13:"RastaPopoulos";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:6:"GPL v3";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Plugin-Menus', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:10:"spip_bonux";a:2:{s:3:"nom";s:10:"spip_bonux";s:13:"compatibilite";s:9:"[1.8.10;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:1:"Z";a:1:{s:3:"nom";s:1:"Z";}}}}', '2012-08-25 05:00:02', '2012-08-25 05:00:02', 1, 'menus.zip', 124473, '2012-08-25 05:00:02', '_plugins_/menus/branches/v0_9', 'a:1:{s:5:"menus";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:7:{s:2:"ca";a:0:{}s:2:"de";a:1:{i:0;a:1:{s:3:"nom";s:5:"klaus";}}s:2:"en";a:5:{i:0;a:1:{s:3:"nom";s:5:"suske";}i:1;a:1:{s:3:"nom";s:14:" RastaPopoulos";}i:2;a:1:{s:3:"nom";s:10:"mark_baber";}i:3;a:1:{s:3:"nom";s:6:" kent1";}i:4;a:1:{s:3:"nom";s:5:"kent1";}}s:2:"es";a:1:{i:0;a:1:{s:3:"nom";s:3:"tin";}}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"sk";a:1:{i:0;a:1:{s:3:"nom";s:4:"jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'fc2e7fcda2fc622fca805f6a1db708c5'),
(517, 512, 'MICROBLOG', 'http://files.spip.org/spip-zone/microblog.png', '000.007.005', '0.1.0', '[2.1.0;3.0.99]', '2.1,3.0', '<multi>\n			[fr]Envoyer des micro-messages vers les plateformes laconica, twitter (via supertweet.net), twitter (via l''API oAuth), spip.org etc. Fournit une fonction <code>microblog($statut, $user, $pass, $service);</code>.\n	\nUtilise la librairie [twitteroauth->http://github.com/abraham/twitteroauth] d\'Abraham Williams pour l''API oAuth de Twitter.\n			[en]Send micromessages to the microblogging platforms like laconica, twitter (via supertweet.net), twitter (via l''API oAuth), spip.org etc. Provides a function <code>microblog($statut, $user, $pass, $service);</code>.\n	\nUses the library [twitteroauth->http://github.com/abraham/twitteroauth] of Abraham Williams for the Twitter oAuth API.\n		</multi>', 'a:1:{i:0;a:3:{s:3:"nom";s:16:"Fil � 2009-2010";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:6:"LGPL 3";s:3:"url";s:41:"http://www.gnu.org/licenses/lgpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Microblog,3051', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-26 18:00:15', '2012-09-26 18:00:15', 1, 'microblog.zip', 70228, '2012-09-26 18:00:20', '_plugins_/microblog', 'a:1:{s:9:"microblog";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '81001a028f9e629d75482f9ee47b046f'),
(518, 513, 'MOSAIQUE', 'http://files.spip.org/spip-zone/mosaique.png', '000.003.003', '0.0.1', '[3.0.0-rc;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin propose de trier les documents associ�s aux articles (via la page d''�dition de l''article) par simple glisser-d�poser des vignettes d\'une mosaique.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:4:"Thom";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:7:"cextras";a:2:{s:3:"nom";s:7:"cextras";s:13:"compatibilite";s:8:"[3.0.5;[";}s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.25.3;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-20 11:00:13', '2012-09-20 11:00:13', 1, 'mosaique.zip', 112218, '2012-09-20 11:00:14', '_plugins_/mosaique', 'a:2:{s:15:"paquet-mosaique";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"fr";a:0:{}}}s:8:"mosaique";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '11703eb640098103572118079c42860d'),
(519, 514, 'NOTIFICATIONS', 'http://files.spip.org/spip-zone/notifications2.png', '002.002.001', '0.1.3', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en]Sends mail notifications for certain actions : forums posts and answers notified to users, private messages notified to redactors or articles publication notified to their authors.\n[fa]���� ���� ���������� �� ������� ����� ���� ������ �� ���� ��������� � ��� ���� ����� ������� ����� �� ����� �� ���� ������� ����� ��� ��������� ���� �� ������.\n\n[fr]Active les notifications par email de certaines actions, notamment des forums et de la messagerie de l''espace priv�, permet �galement l''envoi d\'un mail aux auteurs lors de la publication de leurs articles.\n[sk]Aktivuje oznamy e-mailom pri ur�it�ch akci�ch, vr�tane diskusn�ch f�r a�odkazova�a v�s�kromnej z�ne, ako aj�odoslania e-mailov autorom pri publikovan� ich �l�nkov.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"fil@rezo.net";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Notifications,2360', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:5:"forum";a:1:{s:3:"nom";s:5:"forum";}}}}', '2012-09-24 04:00:19', '2012-09-24 04:00:19', 1, 'notifications2.zip', 57256, '2012-09-24 04:00:20', '_plugins_/notifications/trunk', 'a:3:{s:13:"notifications";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:20:"paquet-notifications";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:20:"abonnernotifications";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fa";a:0:{}s:2:"sk";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '658feda032d873e30d4939c5249e3f8c'),
(520, 515, 'ORESOURCE', 'http://files.spip.org/spip-zone/oresource.png', '001.000.001', '1.0.0', '[3.0.1;3.0.*]', '3.0', '<multi>\n[fr]Adaptation du c�l�bre GRR pour spip\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:6:"tofulm";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', '', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:1:{i:0;a:3:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.24.0;]";}s:10:"timepicker";a:2:{s:3:"nom";s:10:"timepicker";s:13:"compatibilite";s:8:"[1.0.0;]";}s:7:"palette";a:2:{s:3:"nom";s:7:"palette";s:13:"compatibilite";s:8:"[3.0.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-19 22:00:14', '2012-09-19 22:00:14', 1, 'oresource.zip', 56645, '2012-09-19 22:00:14', '_plugins_/orr', 'a:3:{s:9:"oresource";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}s:15:"orr_reservation";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}s:13:"orr_ressource";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '2cc4080ddac9d295abf99291e07a55db'),
(521, 516, 'PGN4SPIP', 'http://files.spip.org/spip-zone/pgn4spip-2.61.0.png', '002.061.000', '', '[3.0.0;3.*.*]', '', '<multi>\n[en]Help: click the chessboard\n[fr]Aide : cliquer sur l''�chiquier.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Matt Chesstale";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:29:"Paolo Casaschi''s pgn4web 2.61";s:3:"url";s:27:"http://pgn4web.casaschi.net";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:4:"2012";}', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-23 01:00:03', '2012-09-23 01:00:03', 1, 'pgn4spip-2.61.0.zip', 75790, '2012-09-23 01:00:06', 'tags/pgn4spip/pgn4spip-2.61.0', 'a:1:{s:8:"pgn4spip";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'cb4ea29cd6b2f01320b59947148bd654'),
(522, 517, 'SAISIES', 'http://files.spip.org/spip-zone/saisies.png', '001.026.007', '', '[2.0.0;3.0.*]', '2.0,2.1,3.0', '<multi>\n[en]This plugin makes it easier to write form fields by providing a #SAISIE tag. \n		The generated HTML is compatible with the classification of forms\n		proposed by SPIP > 2.0 and with the configuration plugin CFG.\n[fr]Ce plugin permet de faciliter l''�criture de champs de formulaires en proposant une\n		balise #SAISIE. Le HTML g�n�r� est compatible avec la nomenclature des formulaires\n		propos�e par SPIP > 2.0 et avec le plugin de configuration CFG.\n[ru]���� ������ ��������� ������ �� �������� ����. ��� ��������������� ����������� �������� ���� � ����� ��� ������ ���� #SAISIE. ���������� ����� ��������� ���������� �� ���������� ��� ������ SPIP 2.0 � ������ � ������������� ��� ������ ������� CFG.\n[sk]Tento z�suvn� modul u�ah�uje z�pis pol� formul�ra pon�knut�m tagu #INPUT. Vytvoren� k�d HTML je kompatibiln� s�klasifik�ciou formul�rov, ktor� pon�ka SPIP > 2.0 a�so�z�suvn�m modulom na konfigur�ciu � CFG.\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:13:"RastaPopoulos";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Saisies', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:8:"verifier";a:1:{s:3:"nom";s:8:"verifier";}s:10:"spip_bonux";a:1:{s:3:"nom";s:10:"spip_bonux";}}}}', '2012-09-25 18:00:17', '2012-09-25 18:00:17', 1, 'saisies.zip', 162040, '2012-09-25 18:00:18', '_plugins_/saisies', 'a:2:{s:14:"paquet-saisies";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:7:"saisies";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:10:{s:2:"ca";a:0:{}s:2:"de";a:1:{i:0;a:2:{s:3:"nom";s:7:"klaus++";s:4:"lien";s:33:"http://trad.spip.net/auteur/klaus";}}s:2:"en";a:2:{i:0;a:2:{s:3:"nom";s:5:"Paolo";s:4:"lien";s:33:"http://trad.spip.net/auteur/paolo";}i:1;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:5:"fr_tu";a:1:{i:0;a:2:{s:3:"nom";s:8:"beatnick";s:4:"lien";s:36:"http://trad.spip.net/auteur/beatnick";}}s:2:"it";a:0:{}s:2:"ru";a:2:{i:0;a:2:{s:3:"nom";s:5:"nazar";s:4:"lien";s:33:"http://trad.spip.net/auteur/nazar";}i:1;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '1a078a4ac065714bb0890c0b5b6f08ec'),
(171, 163, 'MENUDER', 'http://files.spip.org/spip-zone/menuder-2.png', '002.001.004', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', 'Menu d�roulant dynamique full CSS, qui plonge en profondeur, sans limitation de niveaux de hi�rarchie.', 'a:1:{i:0;a:3:{s:3:"nom";s:6:"Cedric";s:3:"url";s:26:"http://www.notre-ville.net";s:4:"mail";s:22:"cedric@notre-ville.net";}}', '', '', '', 'http://www.spip-contrib.net/?article3804', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-05-22 12:00:03', '2012-05-22 12:00:03', 1, 'menuder-2.zip', 12445, '2012-05-22 12:00:04', '_plugins_/menuder', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ecc897313ead40269cb37d31a015a71a'),
(172, 164, 'MESABONNES', 'http://files.spip.org/spip-zone/mes_abonnes.png', '000.004.000', '', '[2.1.0;3.0.99]', '2.1,3.0', 'Module d\'abonnement pour logiciels de publipostages de type MaxBulker Mailer', 'a:1:{i:0;a:3:{s:3:"nom";s:9:"erational";s:3:"url";s:24:"http://www.erational.org";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Mes-abonnes', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-02 07:00:02', '2012-08-02 07:00:02', 1, 'mes_abonnes.zip', 12336, '2012-08-02 07:00:04', '_plugins_/mes_abonnes', 'a:1:{s:10:"mesabonnes";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"nl";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '9150ebd4e7e6a0cc161607b52642763a'),
(173, 165, 'MES_PREFERENCES', 'http://files.spip.org/spip-zone/mes_preferences.png', '000.001.002', '', '[3.0.0-rc;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin modifie les syt�me des prf�rences utilisateur de spip pour lui ajouter des fonctionalit�s ou options suppl�mentaires\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:29:"Arnaud B�rard (Mist. GraphX)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', '', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:11:"jappix_mini";a:2:{s:3:"nom";s:11:"jappix_mini";s:13:"compatibilite";s:8:"[1.0.0;]";}}}}', '2012-09-04 12:00:44', '2012-09-04 12:00:44', 1, 'mes_preferences.zip', 787167, '2012-09-04 12:00:44', '_plugins_/mes_preferences/trunk', 'a:1:{s:15:"mes_preferences";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '69ad8be2c8815484f3d1e1f26fca8379'),
(471, 475, 'MULTIDOMAINES', 'http://files.spip.org/spip-zone/multidomaines.png', '002.001.002', '0.0.2', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Le plug-in Multidomaines permet d\'associer un nom de domaine ou un sous-domaine à un secteur(ou rubrique de second niveau) spip. Les balises rajout�es permettent de pointer un lien absolu aussi facilement qu''avec les balises originales. Il offre la possibilit� de faire plusieurs sites avec les mêmes donn�es et/ou un site internet sur plusieurs domaines diff�rents.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:18:"Nathanaël Louison";s:3:"url";s:0:"";s:4:"mail";s:29:"mailto:bennetteson AT free.fr";}i:2;a:3:{s:3:"nom";s:11:"Pierre KUHN";s:3:"url";s:26:"http://www.pierre-kuhn.org";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/article4182', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-06 15:00:28', '2012-09-06 15:00:28', 1, 'multidomaines.zip', 26072, '2012-09-06 15:00:36', '_plugins_/multidomaines/trunk', 'a:1:{s:13:"multidomaines";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '482c3a83d2f81c6f1664211109e6face'),
(472, 476, 'NOIE', 'http://files.spip.org/spip-zone/noie.gif', '001.003.000', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', 'Affichez un gentil message aux internautes surfant avec Internet Explorer afin de les pr�venir qu''ils ne visitent pas le site dans les meilleures conditions.', 'a:3:{i:0;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:14:"romy.tetue.net";s:3:"url";s:21:"http://romy.tetue.net";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:4:"2009";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?rubrique774', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-15 04:00:46', '2012-09-15 04:00:46', 1, 'noie.zip', 103833, '2012-09-15 04:00:46', '_plugins_/noie', 'a:1:{s:4:"noie";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:20:{s:2:"ar";a:0:{}s:3:"ast";a:1:{i:0;a:2:{s:3:"nom";s:5:"Xuacu";s:4:"lien";s:33:"http://trad.spip.net/auteur/xuacu";}}s:2:"ca";a:0:{}s:2:"cs";a:0:{}s:2:"de";a:0:{}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:4:"Mark";s:4:"lien";s:32:"http://trad.spip.net/auteur/mark";}}s:2:"es";a:0:{}s:2:"eu";a:1:{i:0;a:2:{s:3:"nom";s:7:"otalazt";s:4:"lien";s:35:"http://trad.spip.net/auteur/otalazt";}}s:2:"fa";a:0:{}s:2:"fr";a:0:{}s:5:"fr_tu";a:0:{}s:2:"gl";a:0:{}s:2:"it";a:0:{}s:2:"km";a:0:{}s:2:"nl";a:0:{}s:2:"pt";a:0:{}s:2:"ro";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}s:2:"tr";a:0:{}s:2:"zh";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ef0d3e7e076574f8011029eed542d268'),
(470, 172, 'FB_MODELES', 'http://files.spip.org/spip-zone/modeles_facebook_s3.png', '000.020.000', '', '[3.0.0-beta;[', '3.0,3.1', '<multi>\n[fr]Ce plugin propose un ensemble de mod�les SPIP pour int�grer simplement et rapidement les modules sociaux du site Facebook :\n\n-*  {{send}} : le bouton « Envoyer » classique (avec commentaire)\n-*  {{like}} : le bouton « J''aime » classique (avec commentaire)\n-*  {{like box}} : liste des commentaires des utilisateurs qui ont « aim� »\n-*  {{activity}} : liste des activit�s r�centes d\'une page ou d\'un profil\n-*  {{comments}} : liste des commentaires et bouton permettant d\'en �crire un\n-*  {{live stream}} (exp�rimental) : boîte de discussion type « chat »\n[sk]Tento zásuvný modul ponúka rad šablón SPIPu na ľahk� a rýchle zavedenie modulov sociálnej siete Facebook:\n\n-*  {{Poslať:}} klasick� tlačidlo "Poslať" (pri komentári).\n-*  {{Páči sa mi to:}} klasick� tlačidlo "Páči sa mi to" (s komentárom).\n-*  {{like box}} : zoznam komentárov od používateľov, ktorým sa daná vec páči.\n-*  {{Aktivita:}}  prehľad poslednej aktivity na stránke alebo profile.\n-*  {{Komentáre:}} zoznam komentárov a tlačidlo, ktor� umožſuje komentár napísať.\n-*  {{live stream}} (experiment): pole s diskusiou ako chat.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"Piero Wbmstr";s:3:"url";s:39:"http://www.spip-contrib.net/PieroWbmstr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article3872', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-16 04:00:33', '2012-09-16 04:00:33', 1, 'modeles_facebook_s3.zip', 56912, '2012-09-16 04:00:34', '_plugins_/modeles_facebook/trunk', 'a:2:{s:9:"fbmodeles";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:17:"paquet-fb_modeles";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'f58da26d8011e5aa1eeb331276f2ba25'),
(176, 168, 'PHOTO_INFOS', 'http://files.spip.org/spip-zone/metadonnees_photo-2.png', '002.000.001', '', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[en]This plugin allows to view EXIF, IPTC and GPS data from a JPEG file.\r\n\r\nEXIF informations are handled without using the PHP''s EXIF extension, but through a script by Vinay Yadav (under LGPL license).\r\n\r\nIPTC informations requires the "iptcparse" PHP function and use the class "class_iptc" by Alex Arica.\n[fr]Ce plugin permet d\'afficher les informations EXIF, GPS et IPTC d\'un fichier JPEG.\r\n\r\nLes informations EXIF sont manipul�es, sans recours �  l''extension EXIF de PHP, gr�¢ce au script de Vinay Yadav (sous licence LGPL).\r\n\r\nLes informations IPTC n�cessitent la fonction "iptcparse" de PHP et utilisent la classe "class_iptc" d\'Alex Arica.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"ARNO*";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:6:"LGPL 3";s:3:"url";s:41:"http://www.gnu.org/licenses/lgpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Metadonnees-Photo', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:6:"medias";a:2:{s:3:"nom";s:6:"medias";s:13:"compatibilite";s:8:"[2.6.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-11-14 13:02:46', '2011-11-14 13:02:46', 1, 'metadonnees_photo-2.zip', 16142412, '2011-11-14 14:00:04', '_plugins_/metadonnees_photo/trunk', 'a:1:{s:21:"photo_infos_fonctions";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '87ccac3fa0c084154372510688b2ea35'),
(178, 170, 'MINIBANDO', 'http://files.spip.org/spip-zone/minibando-dev.png', '001.001.000', '', '[3.0.0-dev;3.0.99]', '3.0', '<multi>\n[ar]ÿŠÿ³ÿªÿ¨ÿ¯ÿ⿿ ÿ⿡ÿ°ÿ§ ÿ§ÿ⿿ÿ⿦ÿ⿿ÿ­ÿ⿿ ÿ£ÿ²ÿ±ÿ§ÿ± ÿ§ÿ⿿ÿ¥ÿ¯ÿ§ÿ±ÿ© ÿÿŠ SPIP ÿ¨ÿ´ÿ±ÿŠÿ· ÿ£ÿ¯ÿ˿ÿ§ÿª ÿŠÿ­ÿªÿ˿ÿŠ ÿ¹ÿ⿿ÿ⿰ ÿ§ÿ⿿ÿ¹ÿ⿠ÿ§ÿµÿ± ÿ§ÿ⿿ÿ⿦ÿªÿ˿ÿ§ÿÿ±ÿ© ÿÿŠ ÿ§ÿ⿿ÿªÿµÿÿ­ ÿ§ÿ⿿ÿ£ÿ¹ÿ⿿ÿ⿰ ÿÿŠ ÿ§ÿ⿿ÿ⿦ÿ¬ÿ§ÿ⿿ ÿ§ÿ⿿ÿ®ÿ§ÿµ. \n[en]The minibando plugin replaces the administration buttons of SPIP by a toolbar that shows the items available in the top navigation of the SPIP private area.\n[fr]Le plugin minibando remplace les boutons d\'administration de SPIP par une barre d\'outils qui reprend les �l�ments disponibles dans la navigation haute de l\'espace priv� de SPIP.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/minibando', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-27 04:00:27', '2012-08-27 04:00:27', 1, 'minibando-dev.zip', 36480, '2012-08-27 04:00:28', '_plugins_/minibando/trunk', 'a:2:{s:9:"minibando";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:6:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/ÿ¬ÿ˿ÿ±ÿ¬-ÿ⿿ÿ⿠ÿ¯ÿ⿿ÿÿª";}}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"eu";a:1:{i:0;a:2:{s:3:"nom";s:7:"otalazt";s:4:"lien";s:35:"http://trad.spip.net/auteur/otalazt";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:16:"paquet-minibando";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/ÿ¬ÿ˿ÿ±ÿ¬-ÿ⿿ÿ⿠ÿ¯ÿ⿿ÿÿª";}}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '2fc0ff59379c9903536b0030f3faeb60'),
(179, 171, 'MINIGRISPIP', 'http://files.spip.org/spip-zone/minigrispip_2.png', '002.000.008', '', '[2.0.0;3.0.*]', '2.0,2.1,3.0', '<multi>\n[fr]MiniGriSpip est un squelette simple et sobre fait pour les d�butants. Une version 1 du squelette (pour spip 1.9) a �t� document�e sur le site : [->http://fredomkb.free.fr/spip/]. ATTENTION, la version 2 est une adaptation de {{MiniGriSpip 1.2}} �  SPIP 2. Les fonctionnalit�s des versions 1.4 et 1.6 ne sont PAS reprises dans la pr�sente version.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:9:"Fredo Mkb";s:3:"url";s:29:"http://fredomkb.free.fr/spip/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"Suske";s:3:"url";s:30:"http://minigrispip.brubel.net/";s:4:"mail";s:0:"";}}', 'a:2:{i:1;a:2:{s:3:"nom";s:20:"Fredo Mkb, cr�ateur";s:3:"url";s:29:"http://fredomkb.free.fr/spip/";}i:2;a:2:{s:3:"nom";s:33:"Suske, mise en plugin pour spip 3";s:3:"url";s:29:"http://minigrispip.brubel.net";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2006-2012";}', 'http://www.spip-contrib.net/spip.php?article3934', 'http://minigrispip.brubel.net/', 'http://minigrispip.brubel.net/', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:5:"menus";a:1:{s:3:"nom";s:5:"menus";}s:7:"crayons";a:1:{s:3:"nom";s:7:"crayons";}}}}', '2012-03-31 19:00:03', '2012-03-31 19:00:03', 1, 'minigrispip_2.zip', 94846, '2012-03-31 19:00:08', '_squelettes_/MiniGriSpip/trunk', 'a:1:{s:3:"mgs";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '64fa6db248de7d1cb1b6931df384ea15'),
(180, 171, 'MINIGRISPIP', 'http://files.spip.org/spip-zone/minigrispip_1-6.png', '001.006.000', '', '[2.0.0;3.0.*]', '2.0,2.1,3.0', '<multi>\n[fr]	MiniGriSpip est un squelette simple et sobre fait par un d�butant pour les d�butants, bas� sur le squelette Minimal-SPIP, mais avec quelques modifications pour une adaptation �  l''�volution de SPIP.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:9:"Fredo Mkb";s:3:"url";s:29:"http://fredomkb.free.fr/spip/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"Suske";s:3:"url";s:30:"http://minigrispip.brubel.net/";s:4:"mail";s:0:"";}}', 'a:2:{i:1;a:2:{s:3:"nom";s:20:"Fredo Mkb, cr�ateur";s:3:"url";s:29:"http://fredomkb.free.fr/spip/";}i:2;a:2:{s:3:"nom";s:33:"Suske, mise en plugin pour spip 3";s:3:"url";s:29:"http://minigrispip.brubel.net";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2006-2012";}', 'http://www.spip-contrib.net/spip.php?article2153', 'http://minigrispip.brubel.net/', 'http://minigrispip.brubel.net/', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:5:"menus";a:1:{s:3:"nom";s:5:"menus";}s:7:"crayons";a:1:{s:3:"nom";s:7:"crayons";}}}}', '2012-03-31 19:00:03', '2012-03-31 19:00:03', 1, 'minigrispip_1-6.zip', 367699, '2012-03-31 19:00:04', '_squelettes_/MiniGriSpip/mgs_1-6', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'a1b0b021f69830f24f33bec8384a0ff5'),
(181, 172, 'FB_MODELES', 'http://files.spip.org/spip-zone/modeles_facebook.png', '000.017.000', '', '[2.1.0;3.0.99]', '2.1,3.0', 'Ce plugin propose un ensemble de mod�les SPIP pour int�grer simplement et rapidement les modules sociaux du site Facebook :\r\n-*  {{send}} : le bouton ÿ« Envoyer ÿ» classique (avec commentaire)\r\n-*  {{like}} : le bouton ÿ« J''aime ÿ» classique (avec commentaire)\r\n-*  {{like box}} : liste des commentaires des utilisateurs qui ont ÿ« aim� ÿ»\r\n-*  {{activity}} : liste des activit�s r�centes d\'une page ou d\'un profil\r\n-*  {{comments}} : liste des commentaires et bouton permettant d\'en �crire un\r\n-*  {{live stream}} (exp�rimental) : bo�®te de discussion type ÿ« chat ÿ»', 'a:1:{i:0;a:3:{s:3:"nom";s:12:"Piero Wbmstr";s:3:"url";s:39:"http://www.spip-contrib.net/PieroWbmstr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article3872', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"z";s:2:"id";s:1:"z";s:7:"version";s:8:"[1.0.0;]";s:13:"compatibilite";s:8:"[1.0.0;]";}}}}', '2012-05-08 01:15:11', '2012-05-08 01:15:11', 1, 'modeles_facebook.zip', 49503, '2012-05-08 01:15:12', '_plugins_/modeles_facebook/trunk_spip2', 'a:1:{s:9:"fbmodeles";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'da5168bb69bb25eb40539f32b0a3fc46'),
(469, 474, 'MESSAGERIE', 'http://files.spip.org/spip-zone/messagerie_3_0.png', '003.000.001', '1.0.0', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Gestion de la messagerie interne entre auteurs dans les squelettes publics.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"Cedric MORIN";s:3:"url";s:22:"http://www.yterium.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:4:"2008";}', 'http://www.spip-contrib.net/Messagerie-entre-membres', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:10:"organiseur";a:2:{s:3:"nom";s:10:"organiseur";s:13:"compatibilite";s:8:"[0.6.1;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-04 15:00:25', '2012-09-04 15:00:25', 1, 'messagerie_3_0.zip', 54736, '2012-09-04 15:00:26', '_plugins_/messagerie/trunk', 'a:3:{s:14:"ecrire_message";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:11:"formulaires";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:10:"messagerie";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '054a37ab5b1bf61a4eb72a37704ce162'),
(183, 173, 'MEDIA', 'http://files.spip.org/spip-zone/modeles_media_spip_3.png', '001.000.000', '', '[3.0.0;3.0.99]', '3.0', '<multi>\n[fr]Les mod�les <doc>, <img> et <emb> produisent chacun un r�sultat diff�rent et ce r�sultat, pour les images, d�pend du fait qu\'elle soit dans le portfolio ou non. Ce plugin propose une nouvelle s�rie de mod�les ayant un comportement unifi� et ind�pendant du mode des images. Les mod�les existants (doc, emb, img) ne sont pas modifi�s afin d\'assurer la r�trocompatibilit�.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:34:"http://www.spip-contrib.net/Joseph";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Plugin-Modeles-media', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:6:"medias";a:1:{s:3:"nom";s:6:"medias";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-03 19:00:04', '2012-07-03 19:00:04', 1, 'modeles_media_spip_3.zip', 29109, '2012-07-03 19:00:06', '_plugins_/modeles_media/trunk', 'a:1:{s:5:"media";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd05b88cc2f816a691b4e11e69663b684');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(184, 174, 'MOTS_TECHNIQUES', 'http://files.spip.org/spip-zone/mots_techniques-spip3.png', '001.000.000', '0.3', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[en]By default, the loops MOTS and GROUPES_MOTS keywords will filter technical keywords. However, the criterion <code>{tout}</code> will return all\nkeywords and the criterion <code>{technique=oui}</code> allows to select by technical type.\n[fa]ÿ¾ÿŠÿ´â⿬ſÿ¯ÿ²ÿŠÿ¯ÿ⿡ÿſ ÿ­ÿ⿿ÿ⿿ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ ÿƿÿ⿿ÿŠÿ¯â⿬ſÿ˿ÿ§ÿ˿ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ MOTS ÿ˿  GROUPES_MOTS  ÿƿÿ⿿ÿŠÿ¯ÿ˿ÿ§ÿ˿ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ ÿÿ⿠ÿŠ ÿ±ÿ§ ÿÿŠÿ⿿ÿªÿ± ÿ®ÿ˿ÿ§ÿ⿡ÿ⿠ÿ¯ ÿƿÿ±ÿ¯. ÿ¨ÿ§ ÿ§ÿŠÿ⿠ ÿ­ÿ§ÿ⿿ÿſ ÿ⿦ÿ¹ÿŠÿ§ÿ±<code>{tout}</code> ÿªÿ⿦ÿ§ÿ⿦ ÿƿÿ⿿ÿŠÿ¯ÿ˿ÿ§ÿ˿ÿ⿡â⿬ſÿ⿡ÿ§ ÿ±ÿ§ ÿ¨ÿ±ÿ®ÿ˿ÿ§ÿ⿡ÿ¯ ÿ¯ÿ±ÿ¯ÿ§ÿ⿠ÿ¯ ÿ˿ ÿ⿦ÿ¹ÿŠÿ§ÿ± <code>{technique=oui}</code> ÿ§ÿ¬ÿ§ÿ²ÿ§ÿ⿡â⿬ſÿŠ ÿ§ÿ⿠ÿªÿ®ÿ§ÿ¨ ÿ⿠ÿ˿ÿ¹ ÿÿ⿠ÿŠ ÿ±ÿ§ ÿ®ÿ˿ÿ§ÿ⿡ÿ¯ ÿ¯ÿ§ÿ¯. \n\n[fr]Par d�faut, les boucles MOTS et GROUPES_MOTS filtreront les mots-cl�s \n				techniques. Cependant, le crit�re <code>{tout}</code> permettra de renvoyer tous \n				les mots cl�s et le crit�re <code>{technique=oui}</code> \n				permet de s�lectionner par type technique.\n[ru]ÐŸÐ»Ð°Ð³Ð¸Ð½ Ð¿Ð¾Ð·Ð²Ð¾Ð»ÿÐµÿ⿿ Ð²ÿ⿹Ð´ÐµÐ»ÿÿ⿿ÿſ ÿÐ»ÿƿÐ¶ÐµÐ±Ð½ÿ⿹Ðµ Ð³ÿ⿬ÿƿÐ¿Ð¿ÿ⿹ ÐºÐ»ÿŽÿ⿡ÐµÐ¹ - ÿÿ⿿Ð¾ ÐºÐ»ÿŽÿ⿡Ð¸, ÐºÐ¾ÿ⿿Ð¾ÿ⿬ÿ⿹Ðµ Ð·Ð°Ð´Ð°ÿŽÿ⿿ ÿ⿿ÿƿÐ½Ðºÿ⿠Ð¸Ð¾Ð½Ð°Ð» ÿÐ°Ð¹ÿ⿿Ð° Ð¸ Ð½Ðµ Ð½Ðµÿÿƿÿ⿿ ÐºÐ°ÐºÐ¾Ð¹-Ð»Ð¸Ð±Ð¾ Ð¸Ð½ÿ⿿Ð¾ÿ⿬Ð¼Ð°ÿ⿠Ð¸Ð¾Ð½Ð½Ð¾Ð¹ Ð½Ð°Ð³ÿ⿬ÿƿÐ·ÐºÐ¸. ÐŸÐ¾ ÿƿÐ¼Ð¾Ð»ÿ⿡Ð°Ð½Ð¸ÿŽ ÿ⿠Ð¸ÐºÐ»ÿ⿹ MOTS Ð¸ GROUPES_MOTS Ð½Ðµ Ð±ÿƿÐ´ÿƿÿ⿿ Ð²ÿ⿹Ð²Ð¾Ð´Ð¸ÿ⿿ÿſ ÿÐ»ÿƿÐ¶ÐµÐ±Ð½ÿ⿹Ðµ ÐºÐ»ÿŽÿ⿡Ð¸. Ð⿿ ÿ⿿Ð¾Ð¶Ðµ Ð²ÿ⿬ÐµÐ¼ÿ Ðºÿ⿬Ð¸ÿ⿿Ðµÿ⿬Ð¸Ð¹  <code>{tout}</code> Ð±ÿƿÐ´Ðµÿ⿿ Ð²ÿ⿹Ð²Ð¾Ð´Ð¸ÿ⿿ÿſ Ð¸Ð½ÿ⿿Ð¾ÿ⿬Ð¼Ð°ÿ⿠Ð¸ÿŽ Ð¾ Ð²ÿÐµÿ⿦ ÐºÐ»ÿŽÿ⿡Ð°ÿ⿦, Ð° Ðºÿ⿬Ð¸ÿ⿿Ðµÿ⿬Ð¸Ð¹ <code>{technique=oui}</code> \n				Ð±ÿƿÐ´Ðµÿ⿿ Ð²ÿ⿹Ð²Ð¾Ð´Ð¸ÿ⿿ÿſ ÿ⿿Ð¾Ð»ÿſÐºÐ¾ ÿÐ»ÿƿÐ¶ÐµÐ±Ð½ÿ⿹Ðµ ÐºÐ»ÿŽÿ⿡Ð¸.\n[sk]Podÿ¾a predvolen�½ch nastaven�­ cykly MOTS aÿ GROUPES_MOTS vyfiltruj�º technick� kÿ¾�ºÿov� slov�¡. Krit�rium <code>{tout}</code> vÿ¡ak vyp�­ÿ¡e kÿ¾�ºÿov� slov�¡ aÿ krit�rium <code>{technique=oui}</code> \n				umoÿ¾n�­ vybraÿ¥ technick� podÿ¾a typu.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:21:"MidTone Design (logo)";s:3:"url";s:62:"http://www.iconfinder.com/icondetails/10622/48/orange_tag_icon";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/?article3726', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"cextras";a:2:{s:3:"nom";s:7:"cextras";s:13:"compatibilite";s:8:"[3.0.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:4:"mots";a:2:{s:3:"nom";s:4:"mots";s:13:"compatibilite";s:8:"[2.4.0;[";}}}}', '2012-08-20 04:00:32', '2012-08-20 04:00:32', 1, 'mots_techniques-spip3.zip', 24840, '2012-08-20 04:00:34', '_plugins_/mots_techniques/trunk', 'a:2:{s:14:"motstechniques";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:22:"paquet-mots_techniques";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '67e8901b7eb7800786f503027fbfe4ef'),
(185, 175, 'MOTUS', 'http://files.spip.org/spip-zone/motus-spip3.png', '001.001.001', '1.0.0', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin permet de restreindre dans l''interface priv�e l''ajout des certains groupes de mots �  certaines rubriques (et leurs enfants et objets).\r\n\r\nCe qui peut faciliter la prise en main d\'un site par des r�dacteurs en n''affichant uniquement les groupes de mots utiles sur un espace d�termin�.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:12:"magraine.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Motus', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:7:"cextras";a:2:{s:3:"nom";s:7:"cextras";s:13:"compatibilite";s:8:"[2.1.0;[";}s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:10:"[1.25.14;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-13 16:00:03', '2012-07-13 16:00:03', 1, 'motus-spip3.zip', 14254, '2012-07-13 16:00:04', '_plugins_/motus/trunk', 'a:1:{s:5:"motus";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"ar";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '3fcad9eea6f7d582b8153d7d5e659cc7'),
(468, 473, 'MESFAVORIS', 'http://files.spip.org/spip-zone/mesfavoris_2_0.png', '002.003.002', '1.0.0', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\n[en](Un)Select an object to manage favorites objects (articles, sections...) for authenticated visitors\n[fr](D�)S�lectionne un objet pour g�rer des objets (articles, rubriques ...) favoris pour un visiteur authentifi�\n[ru]плагин позволяеѿ заѿегисѿѿиѿованнѿм полѿзоваѿелям добавляѿѿ маѿеѿиалѿ (сѿаѿѿи, ѿазделѿ) в избѿанное на ваѿем сайѿе.\n[sk]U prihlásen�ho návštevníka (od)značí objekt, aby bol zaradený do obľúbených objektov (články, rubriky atď.)\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:14:"Olivier Sallou";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:13:"C�dric Morin";s:3:"url";s:11:"yterium.net";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Mes-Favoris-2-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-14 15:00:02', '2012-09-14 15:00:02', 1, 'mesfavoris_2_0.zip', 99605, '2012-09-14 15:00:04', '_plugins_/mesfavoris', 'a:2:{s:10:"mesfavoris";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:10:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/جٿرج-ٿٿدٿفت";}}s:2:"de";a:0:{}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"pt";a:0:{}s:2:"ru";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:17:"paquet-mesfavoris";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '80f356d009469a967ac8512e1d533859'),
(187, 177, 'MULTILINGUE', 'http://files.spip.org/spip-zone/multilingue.png', '000.002.001', '', '[2.0.0;3.0.*]', '2.0,2.1,3.0', '<multi>\n[fr]Met en place un site multilingue avec une langue par secteur.\n	\n	Le plugin force l''installation de, plusieurs plugin\n	\n	- [Traduction entre rubriques->http://plugins.spip.net/tradrub.html]\n	- [Langue pr�f�r�e par l\'internaute ->http://www.spip-contrib.net/Plugin-Langue-preferee-par-l-internaute]\n	- [Traductions de rubriques autrement->http://www.spip-contrib.net/Traductions-de-rubriques-autrement-3]\n	- [Traductions d\'articles autremen->http://www.spip-contrib.net/Traductions-d-articles-autrement-3]\n	\n	Sous Spip 2 ou 2.1 il es recommendable d\'installer auparavant le plugin [Step->http://www.spip-contrib.net/STEP-Systeme-de-Telechargements-de-Plugins], puis installer ce plugin ce qui forcera �galement l''installation de tous les plugin n�cessaires.\n	\n	\n	Le plugin modifie �galement quelques squelettes (rubriques et articles) et quelques noisettes de bases.\n	\n	Une fois install� les plugins n�cessaires, il vous suffira de d�terminer les langues du site dans "Configuration"->"Mulilinguisme/Gestion des langues\n\n	et voil�  votre site est multilingue\n	\n	\n[sk]Nastav�­ viacjazyÿn�º str�¡nku sÿ jazykom pre dan�½ sektor.\n	\n	Z�¡suvn�½ modul si vyn�ºti inÿ¡tal�¡ciu viacer�½ch z�¡suvn�½ch modulov na\n	\n	- [preklad rubr�­k,->http://plugins.spip.net/tradrub.html]\n	- [jazyk, ktor�½ preferuje pouÿ¾�­vateÿ¾,->http://www.spip-contrib.net/Plugin-Langue-preferee-par-l-internaute]\n	- [preklady in�½ch rubr�­k,->http://www.spip-contrib.net/Traductions-de-rubriques-autrement-3]\n	- [preklady in�½ch ÿl�¡nkov.->http://www.spip-contrib.net/Traductions-d-articles-autrement-3]\n	\n	Vÿ Spipe 2 alebo 2.1 sa odpor�ºÿa nainÿ¡talovaÿ¥ ich pred inÿ¡tal�¡ciou z�¡suvn�ho modulu [Step->http://www.spip-contrib.net/STEP-Systeme-de-Telechargements-de-Plugins], potom nainÿ¡talujte tento z�¡suvn�½ modul, ktor�½ si vyn�ºti ajÿ inÿ¡tal�¡ciu vÿ¡etk�½ch potrebn�½ch z�¡suvn�½ch modulov.\n	\n	Z�¡suvn�½ modul men�­ ajÿ niektor� ÿ¡abl�³ny (rubriky aÿ ÿl�¡nky) aÿ niekoÿ¾ko z�¡kladn�½ch orieÿ¡kov.\n	\n	Keÿ nainÿ¡talujete potrebn� z�¡suvn� moduly, jazyky str�¡nky vyberte vÿ menu  "Konfigur�¡cia"->"Viacjazyÿnosÿ¥/Riadenie jazykov"\n\n	aÿ potom bude vaÿ¡a str�¡nka viacjazyÿn�¡\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Rainer M�¼ller";s:3:"url";s:24:"http://www.mychacra.net/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Site-multilingue-facile', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:4:{s:7:"tradrub";a:2:{s:3:"nom";s:7:"tradrub";s:13:"compatibilite";s:8:"[3.0.0;[";}s:14:"languepreferee";a:2:{s:3:"nom";s:14:"languepreferee";s:13:"compatibilite";s:8:"[0.4.0;[";}s:8:"trad_rub";a:2:{s:3:"nom";s:8:"trad_rub";s:13:"compatibilite";s:8:"[1.1.0;]";}s:3:"taa";a:2:{s:3:"nom";s:3:"taa";s:13:"compatibilite";s:8:"[1.1.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:1:"z";a:2:{s:3:"nom";s:1:"z";s:13:"compatibilite";s:9:"[1.7.17;[";}}}}', '2012-08-09 09:00:09', '2012-08-09 09:00:09', 1, 'multilingue.zip', 71846, '2012-08-09 09:00:10', '_plugins_/multilingue/branches/0', 'a:2:{s:11:"multilingue";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"de";a:1:{i:0;a:2:{s:3:"nom";s:7:"abelass";s:4:"lien";s:35:"http://trad.spip.net/auteur/abelass";}}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:7:"abelass";s:4:"lien";s:35:"http://trad.spip.net/auteur/abelass";}}s:2:"es";a:1:{i:0;a:2:{s:3:"nom";s:7:"abelass";s:4:"lien";s:35:"http://trad.spip.net/auteur/abelass";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:18:"paquet-multilingue";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '21a5ea02e75b3ee1ed6bd82d044b7acd'),
(188, 178, 'MULTILANG', 'http://files.spip.org/spip-zone/multilang.png', '000.007.000', '0.1', '[2.1;3.0.99]', '2.1,3.0', '<multi>\n[en]This plugin adds a language menu like <code>[fr] [en] [it]</code> at the top of each form, depending on the language selected in the site configuration.\n[fr]Ce plugin rajoute un menu de langues du type <code>[fr] [en] [it]</code> au-dessus de chaque formulaire, en fonction des langues activ�es dans la configuration du site.\n[it]Questo plugin aggiunge un menu di linguaggi di tipo <code>[fr] [it] [it]</code> nella parte superiore di ogni modulo, a seconda della lingua selezionata nella configurazione del sito.\n[ru]Ð­ÿ⿿Ð¾ÿ⿿ Ð¿Ð»Ð°Ð³Ð¸Ð½ Ð´Ð¾Ð±Ð°Ð²Ð»ÿÐµÿ⿿ ÿÐ·ÿ⿹ÐºÐ¾Ð²Ð¾Ðµ Ð¼ÐµÐ½ÿŽ, Ð² Ð²Ð¸Ð´Ðµ <code> [RU] [EN] [IT] </code> Ð² Ð²Ðµÿ⿬ÿ⿦Ð½ÐµÐ¹ ÿ⿡Ð°ÿÿ⿿Ð¸ ÐºÐ°Ð¶Ð´Ð¾Ð¹ ÿ⿿Ð¾ÿ⿬Ð¼ÿ⿹, Ð² Ð·Ð°Ð²Ð¸ÿÐ¸Ð¼Ð¾ÿÿ⿿Ð¸ Ð¾ÿ⿿ ÿÐ·ÿ⿹ÐºÐ°, Ð²ÿ⿹Ð±ÿ⿬Ð°Ð½Ð½Ð¾Ð³Ð¾ Ð² Ð½Ð°ÿÿ⿿ÿ⿬Ð¾Ð¹ÐºÐ°ÿ⿦ ÿÐ°Ð¹ÿ⿿Ð°.\n[sk]Tento z�¡suvn�½ modul prid�¡ jazykov� menu <code>[fr] [en] [it]</code> do hornej ÿasti kaÿ¾d�ho formul�¡ra podÿ¾a aktivovan�½ch jazykov vÿ konfigur�¡cii str�¡nky.\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:14:"Renato Formato";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"kent1";s:3:"url";s:21:"http://www.kent1.info";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:5:"Yffic";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Multilang', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:6:"[1.1;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:7:"crayons";a:1:{s:3:"nom";s:7:"crayons";}}}}', '2012-08-03 11:00:13', '2012-08-03 11:00:13', 1, 'multilang.zip', 49058, '2012-08-03 11:00:14', '_plugins_/multilang', 'a:2:{s:9:"multilang";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:2:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}i:1;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:16:"paquet-multilang";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:5:"nazar";s:4:"lien";s:33:"http://trad.spip.net/auteur/nazar";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '91dda8925fd5f5b1286704b2797730f7'),
(189, 179, 'MUTUALISATION', 'http://files.spip.org/spip-zone/mutualisation.png', '000.009.001', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[fr]Ce plugin contient quelques fonctions facilitant la mutualisation de sites : notamment <code>demarrer_site()</code>, <code>prefixe_mutualisation()</code> et <code>mutualiser_creer()</code>.\r\n		Attention ce plugin ne s''installe pas comme les autres (cf. documentation).\r\n		[es]Este plugin contiene algunas funciones que facilitan la mutualizaci�³n de sitios, en particular: <code>demarrer_site()</code>, <code>prefixe_mutualisation()</code> y <code>mutualiser_creer()</code>.  Cuidado, este plugin no se instala como los dem�¡s (ver documentaci�³n).\r\n		[en]This plugin provides some function that facilitate site''s mutualisation, particularly: <code>demarrer_site()</code>, <code>prefixe_mutualisation()</code> and <code>mutualiser_creer()</code>. Be careful, the installation of this plugin is different than general one (see documentation).\r\n		</multi>', 'a:1:{i:0;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:6:"LGPL 3";s:3:"url";s:41:"http://www.gnu.org/licenses/lgpl-3.0.html";}}', '', 'http://www.spip-contrib.net/La-mutualisation-facile', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-04-02 05:00:04', '2012-04-02 05:00:04', 1, 'mutualisation.zip', 48647, '2012-04-02 05:00:06', '_plugins_/mutualisation', 'a:1:{s:4:"mutu";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"es";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '59442ed687dde7cd9137242a5c07ed5b'),
(190, 180, 'NIVOSLIDER', 'http://files.spip.org/spip-zone/nivoslider-v2.png', '002.000.000', '', '[3.0.0-dev;3.0.*]', '3.0', '<multi>\n[en]Add <code><nivosliderXX></code>, <code><nivoslider_doc></code> and <code><nivoslider_rub></code> tags to create a [Nivo Slider->http://nivo.dev7studios.com/] slideshow.\n[fr]Ajoute les balises <code><nivosliderXX></code>, <code><nivoslider_doc></code> et <code><nivoslider_rub></code> pour cr�er un diaporama [Nivo Slider->http://nivo.dev7studios.com/] param�trable.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:15:"Gr�gory Pascal";s:3:"url";s:34:"http://www.spip-contrib.net/ngombe";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Nivo-Slider-pour-SPIP', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-07 18:00:03', '2012-08-07 18:00:03', 1, 'nivoslider-v2.zip', 49308, '2012-08-07 18:00:04', '_plugins_/nivoslider/trunk', 'a:1:{s:10:"nivoslider";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'cc43967fcfada6635d5cd129df7a722b'),
(191, 181, 'NO_BR', 'http://files.spip.org/spip-zone/no_br.png', '001.000.000', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', 'Les retours-chariot c''est mal, les retours-chariot sont une plaie, les retours-chariot nuisent �  votre sant�. Ce plugin interdit l''insertion de retours-chariot dans le texte en les rempla�§ant par des changements de paragraphe (ce qu''ils devraient toujours �ªtre).', 'a:1:{i:0;a:3:{s:3:"nom";s:5:"ARNO*";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Interdire-les-retours-chariot', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-10-29 15:00:06', '2011-10-29 15:00:06', 1, 'no_br.zip', 3395, '2011-10-29 15:00:06', '_plugins_/no_br', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '2b31de84821a449bec66c43aa3230012'),
(466, 471, 'TIMEPICKER', 'http://files.spip.org/spip-zone/timepicker.png', '001.000.000', '', '[3.0.1;3.0.*]', '3.0', '', 'a:1:{i:1;a:3:{s:3:"nom";s:6:"tofulm";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://trentrichardson.com/examples/timepicker', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-16 22:00:02', '2012-09-16 22:00:02', 1, 'timepicker.zip', 22157, '2012-09-16 22:00:04', '_plugins_/jquery_timepicker', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '86033bc5d78155a9af1809b5815a84f7'),
(467, 472, 'MEMOIZATION', 'http://files.spip.org/spip-zone/memoization.png', '001.002.001', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n			[fr]M�moïzation est un terme d⿿informatique, dont Wikip�dia donne la d�finition suivante : « une technique consistant à r�duire le temps d⿿ex�cution d⿿une fonction en m�morisant ses r�sultats d⿿une fois sur l⿿autre ». C⿿est aussi le nom d⿿une nouvelle librairie de fonctions pour PHP, qui fait suite à mes exp�rimentations sur XCache.\r\n			[en]Memoization is a computer science term, which Wikipedia defines as "a technique of reducing the execution time of a function by storing the results once on the other." It is also the name of a new function library for PHP, which follows my experiments XCache.\r\n		</multi>', 'a:1:{i:0;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:3:{i:0;a:2:{s:3:"nom";s:12:"© 2009-2011";s:3:"url";s:0:"";}i:1;a:2:{s:3:"nom";s:6:"LGPL 3";s:3:"url";s:41:"http://www.gnu.org/licenses/lgpl-3.0.html";}i:2;a:2:{s:3:"nom";s:3:"MIT";s:3:"url";s:46:"http://opensource.org/licenses/mit-license.php";}}', '', 'http://zzz.rezo.net/Memoization.html', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-12 11:00:03', '2012-09-12 11:00:03', 1, 'memoization.zip', 83758, '2012-09-12 11:00:06', '_plugins_/memoization', 'a:1:{s:11:"memoization";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c19edd1e9443586f3b2ba5e028c787ea'),
(464, 470, 'IMGCOMPARE', 'http://files.spip.org/spip-zone/images_compare.png', '000.000.002', '', '[2.1;3.0.99]', '2.1,3.0', 'Un simple mod�le qui permet de superposer deux images pour les comparer. Logo bas� sur une image originale de Samuel Q. Green CC-BY http://thenounproject.com/noun/picture/#icon-No3421', 'a:2:{i:0;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:10:"Kevin Liew";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://contrib.spip.net/4229', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-06 12:00:47', '2012-09-06 12:00:47', 1, 'images_compare.zip', 4761, '2012-09-06 12:00:50', '_plugins_/images_compare', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '710382db63d00b53ffd5b78bf0596a27'),
(465, 138, 'JEUX', 'http://files.spip.org/spip-zone/jeux3.png', '003.001.005', '0.20', '[3.0.0;3.0.99]', '3.0', '<multi>\n[fr]Des jeux avec SPIP !\n\nVoici pour vous la possibilit� d\'ins�rer dans vos articles des mots crois�s, des sudokus, des devinettes, des blagues, des po�sies, des QCM, des exercices à trous, etc.\n\nMettez une touche �ducative et ludique à votre site !\n\nDeux solutions :\n-* Des jeux cod�s en clair dans les articles entre les balises <code><jeux></code> et <code></jeux></code>.\n-* Des jeux cod�s dans l''espace priv� et accessibles grâce au mod�le <code><jeuXX></code> où XX est l''identifiant du jeu.\n\nL''enregistrement et la gestion des scores n''est possible qu''en utilisant la seconde solution.\n\nCe plugin fonctionne de façon optimale sur les squelettes disposant de la balise [#INSERT_HEAD->http://www.spip.net/fr_article1902.html] et peut �galement être test� dans l''espace priv�.\n\n_* Pour les jeux graphiques, il faut avoir les librairies {{GD}} install�es sur votre server.\n_* Ce plugin est encore en �volution, proc�dez r�guli�rement à vos mises à jour.\n  \nAfin d''�viter les mauvaises surprises de pr�sentation (comme l''affichage des solutions dans les sommaires, rubriques, backends, etc.), pensez bien :\n-* soit à placer une {{introduction}} dans votre article entre les balises <code><intro></code> et <code></intro></code>,\n-* soit à remplir le {{descriptif}} de l''article.\n\nCr�dits :\n-* Icones : Jonathan Roche\n-* Travaux originaux :\n-** QCM : Mathieu Giannecchini\n-** Mots crois�s et scores : Maïeul Rouquette\n-** Diagrammes d''�checs : François Schreuer\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:20:"Patrice VANNEUFVILLE";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:17:"Maïeul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:24:"GNU/LGPL - (c) 2006-2012";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Des-jeux-dans-vos-articles', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:1:{s:3:"nom";s:7:"saisies";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-14 12:00:06', '2012-09-14 12:00:06', 1, 'jeux3.zip', 648354, '2012-09-14 12:00:06', '_plugins_/jeux/trunk', 'a:7:{s:3:"jeu";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:1:{s:2:"fr";a:0:{}}}s:4:"jeux";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"it";a:0:{}}}s:20:"jeux_gerer_resultats";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}s:11:"motscroises";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:3:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"it";a:0:{}}}s:5:"pendu";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"it";a:0:{}}}s:3:"qcm";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"it";a:0:{}}}s:6:"sudoku";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"it";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '25384263857c46d35a934c7755607aef'),
(196, 186, 'NUAGE', 'http://files.spip.org/spip-zone/nuage.png', '004.000.000', '', '[3.0.0-dev;3.0.99]', '3.0', '<multi>\n[en]This plugin displays the keywords in bulk by varying the font size on the number of items associated with the keyword. In other words, spip can create "tags"!\n\nSeveral models available:\n-* article_nuage : displays keywords of the article, the size varying according to the frequency of words in the articles of the Web site;\n-* rubrique_nuage : displays keywords of the articles in the branch, the size varying according to the frequency of words in the articles of this branch;\n-* nuage_popularite : displays the keywords of the Web site (or group), the size varying according to its relative popularity (sum of popularity of articles having that word);\n[fa]ÿ§ÿŠÿ⿠ ÿ¾ÿ⿿ÿ§ÿ¯ÿŠÿ⿠ ÿƿÿ⿿ÿŠÿ¯â⿬ſÿ˿ÿ§ÿ˿ÿ⿡â⿬ſÿ⿡ÿ§ ÿ±ÿ§ ÿ¨ÿ⿡ ÿµÿ˿ÿ±ÿª ÿÿ⿿ÿ⿡ ÿ¨ÿ§ ÿªÿºÿŠÿŠÿ± ÿ§ÿ⿠ÿ¯ÿ§ÿ²ÿ⿡â⿬ſ ÿ⿿ÿ⿿ÿ⿦ ÿªÿ¹ÿ¯ÿ§ÿ¯ÿŠ ÿ§ÿ² ÿ⿦ÿ˿ÿ¶ÿ˿ÿ¹â⿬ſÿ⿡ÿ§ÿŠ ÿ⿦ÿ±ÿ¨ÿ˿ÿ· ÿ¨ÿ⿡ ÿƿÿ⿿ÿŠÿ¯ ÿ˿ÿ§ÿ˿ÿ⿡ ÿ⿠ÿ´ÿ§ÿ⿠ ÿ⿦ÿŠâ⿬ſÿ¯ÿ⿡ÿ¯. ÿ¨ÿ⿡ ÿ¹ÿ¨ÿ§ÿ±ÿª ÿ¯ÿŠÿ¯ÿ±ÿſ ÿ§ÿ³ÿ¾ÿŠÿ¾ ÿ⿦ÿŠâ⿬ſÿªÿ˿ÿ§ÿ⿠ ÿ«ÿªÿ¯ÿ» ÿ®ÿ⿿ÿ⿿ ÿƿÿ⿠ÿ¯!\nÿ⿠ÿ⿠ÿ¯ ÿ⿦ÿ¯ÿ⿿ ÿ¯ÿ± ÿ¯ÿ³ÿªÿ±ÿ³ ÿ§ÿ³ÿª:\n-* article_nuage: ÿƿÿ⿿ÿŠÿ¯ÿ˿ÿ§ÿ˿ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ ÿ⿦ÿ⿿ÿ§ÿ⿿ÿ⿡ ÿ±ÿ§ÿſâ⿬ſ ÿ¨ÿ§ ÿ§ÿ⿠ÿ¯ÿ§ÿ²ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ ÿ⿦ÿªÿÿ§ÿ˿ÿª ÿ·ÿ¨ÿ⿿ ÿ˿ÿÿ˿ÿ± ÿƿÿ⿿ÿ⿦ÿ§ÿª  ÿ¯ÿ± ÿ⿦ÿ⿿ÿ§ÿ⿿ÿ§ÿª ÿ˿ÿ¨ ÿ³ÿ§ÿŠÿª ÿ⿠ÿ´ÿ§ÿ⿠ ÿ⿦ÿŠâ⿬ſÿ¯ÿ⿡ÿ¯\n-* rubrique_nuage: ÿƿÿ⿿ÿŠÿ¯ÿ˿ÿ§ÿ˿ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ ÿ⿦ÿ⿿ÿ§ÿ⿿ÿ⿡â⿬ſÿ⿡ÿ§ ÿ±ÿ§ ÿ¯ÿ± ÿ´ÿ§ÿ®ÿ⿡â⿬ſÿ⿡ÿ§ ÿ⿠ÿ´ÿ§ÿ⿠ ÿ⿦ÿŠâ⿬ſÿ¯ÿ⿡ÿ¯ÿſ ÿ§ÿ⿠ÿ¯ÿ§ÿ² ÿ·ÿ¨ÿ⿿ ÿ˿ÿÿ˿ÿ± ÿƿÿ⿿ÿ⿦ÿ§ÿª ÿ¯ÿ± ÿ⿦ÿ⿿ÿ§ÿ⿿ÿ⿡â⿬ſÿŠ ÿ⿡ÿ⿦ÿ§ÿ⿠ ÿ´ÿ§ÿ®ÿ⿡ ÿªÿºÿŠÿŠÿ± ÿ®ÿ˿ÿ§ÿ⿡ÿ¯ ÿƿÿ±ÿ¯. \n-* nuage_popularite: ÿƿÿ⿿ÿŠÿ¯ÿ˿ÿ§ÿ˿ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ ÿ˿ÿ¨ ÿ³ÿ§ÿŠÿª (ÿŠÿ§ ÿ¯ÿ±ÿ˿ÿ⿡) ÿ±ÿ§ ÿ¨ÿ§ ÿ§ÿ⿠ÿ¯ÿ§ÿ²ÿ⿡â⿬ſÿŠ ÿ⿦ÿªÿºÿŠÿŠÿ± ÿ·ÿ¨ÿ⿿ ÿ⿦ÿ­ÿ¨ÿ˿ÿ¨ÿŠÿª ÿ⿠ÿ³ÿ¨ÿŠ (ÿƿÿ⿿ ÿ⿦ÿ­ÿ¨ÿ˿ÿ¨ÿŠÿª ÿ⿦ÿ⿿ÿ§ÿ⿿ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ ÿ¯ÿ§ÿ±ÿ§ÿŠ ÿ¢ÿ⿠ ÿ˿ÿ§ÿ˿ÿ⿡) ÿ⿠ÿ´ÿ§ÿ⿠ ÿ⿦ÿŠâ⿬ſÿ¯ÿ⿡ÿ¯. \n\n\n[fr]Ce plugin permet d\'afficher les mots-cl�s en vrac, en faisant varier la taille de la police en fonction du nombre d\'articles associ�s au mot-cl�. En d\'autres termes, spip permet de cr�er des ÿ« tags ÿ» !\n\n	Plusieurs mod�les disponibles :\n-* article_nuage : affiche les mots-cl�s de l''article la taille variant en fonction de la fr�quence des mots dans les articles du site\n-* rubrique_nuage : affiche les mots-cl�s des articles de la branche, la taille variant en fonction de la fr�quence des mots dans les articles de cette branche\n-* nuage_popularite : affiche les mots-cl�s du site (ou d\'un groupe), la taille variant en fonction de sa popularit� relative (somme des popularit� des articles ayant ce mot)\n[sk]Tento z�¡suvn�½ modul umoÿ¾ÿ˿uje zobraziÿ¥ kÿ¾�ºÿov� slov�¡ neusporiadane r�´znou  veÿ¾kosÿ¥ou p�­sma vÿ z�¡vislosti od poÿtu poloÿ¾iek priraden�½ch kuÿ kÿ¾�ºÿov�mu slovu. In�½mi slovami spip umoÿ¾ÿ˿uje vytv�¡raÿ¥ "znaÿky"!\n\n	Kÿ dispoz�­cii je niekoÿ¾ko modelov:\n-* article_nuage: zobraz�­ kÿ¾�ºÿov� slov�¡ ÿl�¡nku, ktor�½ch veÿ¾kosÿ¥ p�­sma sa odliÿ¡uje podÿ¾a frekvencie kÿ¾�ºÿov�½ch slov vÿ ÿl�¡nku na str�¡nke,\n-* rubrique_nuage: zobraz�­ kÿ¾�ºÿov� slov�¡ ÿl�¡nkov vetvy, ktor�½ch veÿ¾kosÿ¥ p�­sma sa bude odliÿ¡ovaÿ¥ podÿ¾a frekvencie kÿ¾�ºÿov�½ch slov vÿ ÿl�¡nkoch danej vetvy,\n-* nuage_popularite: zobraz�­ kÿ¾�ºÿov� slov�¡ str�¡nky (alebo skupiny), ktor�½ch veÿ¾kosÿ¥ p�­sma sa bude odliÿ¡ovaÿ¥ podÿ¾a ich relat�­vnej popularity (s�ºÿet popularity ÿl�¡nkov sÿ dan�½m kÿ¾�ºÿov�½m slovom)\n</multi>', 'a:5:{i:1;a:3:{s:3:"nom";s:4:"Booz";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:5:"James";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:4;a:3:{s:3:"nom";s:9:"St�phane";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:5;a:3:{s:3:"nom";s:15:"Camille Lafitte";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Nuage-de-mots-cles', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:10:"spip_bonux";a:2:{s:3:"nom";s:10:"spip_bonux";s:13:"compatibilite";s:12:"[3.0.0-dev;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:18:23', '2012-07-26 13:18:23', 1, 'nuage.zip', 21640, '2012-07-26 13:18:24', '_plugins_/nuage/trunk', 'a:2:{s:5:"nuage";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:12:"paquet-nuage";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '8e07b5b5aaeb2d93bd1526d542c96dae'),
(197, 187, 'NUMERO', 'http://files.spip.org/spip-zone/numerotation_v1.gif', '001.000.001', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin permet d\'un clic de num�roter/re-num�roter/d�-num�roter tous les articles ou sous-rubriques d\'une rubrique.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"Cedric Morin";s:3:"url";s:0:"";s:4:"mail";s:27:"cedric.morin AT yterium.com";}}', '', '', '', 'http://www.spip-contrib.net/Numerotation-Rapide', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-05 13:00:15', '2012-07-05 13:00:15', 1, 'numerotation_v1.zip', 7297, '2012-07-05 13:00:16', '_plugins_/numerotation/trunk', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '59282c29bbbd01ccd076bbb3ddb65982'),
(198, 188, 'OPENSEARCH', 'http://files.spip.org/spip-zone/opensearch.png', '000.001.001', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n			[fr]Plugin qui permet de proposer aux visiteurs de votre site d\'ajouter un moteur de recherche personnalis�e �  leur navigateur.\r\n			[en]Plugin which enables to offer the users to add a custom search engine related to your website on their browser.\r\n		</multi>', 'a:1:{i:0;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Plugin-OpenSearch', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{i:0;a:4:{s:3:"nom";s:7:"saisies";s:2:"id";s:7:"saisies";s:7:"version";s:6:"[1.1;]";s:13:"compatibilite";s:6:"[1.1;]";}i:1;a:4:{s:3:"nom";s:3:"cfg";s:2:"id";s:3:"cfg";s:7:"version";s:9:"[1.13.0;]";s:13:"compatibilite";s:9:"[1.13.0;]";}}}}', '2012-07-26 13:18:53', '2012-07-26 13:18:53', 1, 'opensearch.zip', 16535, '2012-07-26 13:18:54', '_plugins_/opensearch', 'a:1:{s:10:"opensearch";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'a258479f6e4acd52ab447c037f12476d'),
(199, 189, 'ORIENTATION', 'http://files.spip.org/spip-zone/orientation_1_9.png', '000.002.000', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', 'Le plugin orientation ajoute les crit�res <code>{portrait}</code>, <code>{carre}</code> et <code>{paysage}</code> pour le classement des photos.', 'a:2:{i:0;a:3:{s:3:"nom";s:25:"Pierre Andrews (Mortimer)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:3:"IZO";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Portrait-ou-Paysage', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-10-06 12:00:36', '2011-10-06 12:00:36', 1, 'orientation_1_9.zip', 3498, '2011-10-06 12:00:36', '_plugins_/orientation', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '6e428d6930c8c4236161fc9e3dd8608d'),
(200, 190, 'ORTHO', 'http://files.spip.org/spip-zone/ortho.gif', '000.001', '0.1', '[1.9.2;]', '1.9,2.0,2.1,3.0,3.1', 'ortho:ortho_description', 'a:1:{i:0;a:3:{s:3:"nom";s:14:"Antoine Pitrou";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-26 04:00:41', '2012-08-26 04:00:41', 1, 'ortho.zip', 128501, '2012-08-26 04:00:42', '_grenier_/ortho', 'a:1:{s:5:"ortho";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:46:{s:2:"ar";a:0:{}s:3:"ast";a:0:{}s:2:"bg";a:0:{}s:2:"br";a:0:{}s:2:"bs";a:0:{}s:2:"ca";a:0:{}s:2:"co";a:0:{}s:3:"cpf";a:0:{}s:7:"cpf_hat";a:0:{}s:2:"cs";a:0:{}s:2:"de";a:0:{}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:4:"Mark";s:4:"lien";s:32:"http://trad.spip.net/auteur/mark";}}s:2:"eo";a:0:{}s:2:"es";a:0:{}s:2:"eu";a:0:{}s:2:"fa";a:0:{}s:3:"fon";a:0:{}s:2:"fr";a:0:{}s:5:"fr_tu";a:0:{}s:2:"gl";a:0:{}s:2:"hu";a:0:{}s:2:"id";a:0:{}s:2:"it";a:0:{}s:6:"it_fem";a:0:{}s:2:"ja";a:0:{}s:2:"km";a:0:{}s:2:"lb";a:0:{}s:2:"my";a:0:{}s:2:"nl";a:0:{}s:6:"oc_auv";a:0:{}s:6:"oc_gsc";a:0:{}s:6:"oc_lms";a:0:{}s:6:"oc_lnc";a:0:{}s:5:"oc_ni";a:0:{}s:8:"oc_ni_la";a:0:{}s:6:"oc_prv";a:0:{}s:5:"oc_va";a:0:{}s:2:"pl";a:0:{}s:2:"pt";a:0:{}s:5:"pt_br";a:0:{}s:2:"ro";a:0:{}s:2:"ru";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}s:2:"tr";a:0:{}s:2:"vi";a:0:{}s:2:"zh";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ea8710594e1c1a30213b1fb4acc80a9b'),
(201, 191, 'OUTILS_ARTICLE', 'http://files.spip.org/spip-zone/outils_article1.png', '001.000.001', '', '[3.0.0;3.0.99]', '3.0', '<multi>\n[es]Insertar una panoplia de herramientas para sus art�­culos en forma de barra o de cojea con dos avellanas que deben insertarse en sus esqueletos : \r\n-* <code>[(#INCLURE{fond=inc-barre-outils}{id_article})]</code> para la versi�³n barra\r\n-* <code>[(#INCLURE{fond=inc-boite-outils}{id_article})]</code> para la versi�³n cojea\n[fr]Ins�rer une panoplie d\'outils pour vos articles sous forme de barre ou de boite gr�¢ce �  deux noisettes �  ins�rer dans vos squelettes : \r\n-* <code>[(#INCLURE{fond=inc-barre-outils}{id_article})]</code> pour la version en barre\r\n-* <code>[(#INCLURE{fond=inc-boite-outils}{id_article})]</code> pour la version en boite\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:18:"Christophe Vallois";s:3:"url";s:35:"http://www.spip-contrib.net/_vcris_";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:4:"2007";}', 'http://www.spip-contrib.net/Boite-a-outils-pour-articles', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:5:{s:11:"article_pdf";a:1:{s:3:"nom";s:11:"article_pdf";}s:12:"enviar_email";a:1:{s:3:"nom";s:12:"enviar_email";}s:18:"imprimir_documento";a:1:{s:3:"nom";s:18:"imprimir_documento";}s:12:"boutonstexte";a:1:{s:3:"nom";s:12:"boutonstexte";}s:8:"notation";a:1:{s:3:"nom";s:8:"notation";}}}}', '2012-06-20 11:00:22', '2012-06-20 11:00:22', 1, 'outils_article1.zip', 461694, '2012-06-20 11:00:28', '_plugins_/outils_article/trunk', 'a:1:{s:13:"outilsarticle";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"es";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'cd73a2f22b586814e57a022a9fd4ee7a');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(202, 192, 'PAGES', 'http://files.spip.org/spip-zone/pages_v1.png', '001.000.001', '1.0.0', '[3.0.0-dev;3.0.*]', '3.0', '<multi>\n[ar]ÿ⿡ÿ°ÿ§ ÿ§ÿ⿿ÿ¨ÿ±ÿ⿠ÿ§ÿ⿦ÿ¬ ÿ§ÿ⿿ÿ⿦ÿ³ÿ§ÿ¹ÿ¯ ÿŠÿ³ÿ⿦ÿ­ ÿ⿿ÿƿ ÿ¥ÿ⿠ÿ´ÿ§ÿ¡ ÿµÿÿ­ÿ§ÿª ÿ⿦ÿ⿠ ÿ§ÿ⿿ÿ¨ÿ⿠ÿ˿ÿ¯ ÿ§ÿ⿿ÿªÿŠ ÿ⿿ÿ§ ÿªÿ±ÿªÿ¨ÿ· ÿ¨ÿ£ÿŠ ÿªÿ³ÿ⿿ÿ³ÿ⿿ ÿ⿦ÿ¹ÿŠÿ⿠. ÿ¨ÿŠÿ¯ ÿ£ÿ⿠ÿ⿡ÿ§ ÿ⿿ÿ¯ ÿªÿªÿ±ÿ§ÿÿ⿿ ÿ⿦ÿ¹ ÿ§ÿ³ÿ⿦ ÿ§ÿ⿿ÿ⿿ÿ§ÿ⿿ÿ¨\nÿŠÿ£ÿ°ÿ⿠ ÿ⿿ÿ⿿ÿ¥ÿ⿠ÿ´ÿ§ÿ¡ ÿµÿÿ­ÿ© ÿ⿦ÿ⿠ ÿ§ÿ⿿ÿ⿦ÿ¹ÿ⿿ÿ˿ÿ⿦ÿ§ÿª ÿ§ÿ⿿ÿ⿿ÿ§ÿ⿠ÿ˿ÿ⿠ÿŠÿ© ÿſ ÿ⿦ÿ⿠ ÿ⿠ÿ­ÿ⿠ ÿſ ÿ§ÿªÿµÿ§ÿ⿿ ÿſ ÿ˿ÿ⿦ÿ§ ÿ¥ÿ⿿ÿ⿰ ÿ°ÿ⿿ÿƿ.\n\n[en]This plugin allows you to create pages of articles that are not linked to any particular hierarchy.\nHowever they may be associated with a name template.\nThis allows the creation of pages of legal information, about, contact, etc..\n\n[fa]ÿ§ÿŠÿ⿠ ÿ¾ÿ⿿ÿ§ÿ¯ÿŠÿ⿠ ÿ§ÿ¬ÿ§ÿ²ÿ⿡â⿬ſÿŠ ÿ§ÿŠÿ¬ÿ§ÿ¯ ÿµÿÿ­ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ ÿ⿦ÿ⿿ÿ§ÿ⿿ÿ⿡â⿬ſÿ⿡ÿ§ÿŠÿŠ ÿ±ÿ§ ÿ⿦ÿŠâ⿬ſÿ¯ÿ⿡ÿ¯ ÿƿÿ⿡ ÿ¨ÿ⿡ ÿ⿡ÿŠÿ⿠ ÿ³ÿ⿿ÿ³ÿ⿿ÿ⿡ ÿ⿦ÿ±ÿ§ÿªÿ¨ÿŠ ÿ⿦ÿªÿƿÿŠ ÿ⿠ÿŠÿ³ÿªÿ⿠ÿ¯. \nÿ¯ÿ± ÿ¹ÿ¶ÿ˿ ÿ⿦ÿŠâ⿬ſÿªÿ˿ÿ§ÿ⿠ÿ⿠ÿ¯ ÿ¨ÿ⿡ ÿ⿠ÿ§ÿ⿦ ÿŠÿƿ ÿ§ÿ³ÿ⿿ÿƿÿª ÿ⿦ÿ±ÿªÿ¨ÿ· ÿ´ÿ˿ÿ⿠ÿ¯. \nÿ§ÿŠÿ⿠ ÿ¾ÿ⿿ÿ§ÿ¯ÿŠÿ⿠ ÿ§ÿ¬ÿ§ÿ²ÿ⿡â⿬ſÿŠ ÿ§ÿŠÿ¬ÿ§ÿ¯ ÿµÿÿ­ÿ⿡â⿬ſÿ⿡ÿ§ÿŠÿŠ ÿ⿦ÿ§ÿ⿠ÿ⿠ÿ¯ ÿ§ÿ·ÿ⿿ÿ§ÿ¹ÿ§ÿª ÿ­ÿ⿿ÿ˿ÿ⿿ÿŠÿſ ÿ¯ÿ± ÿ¨ÿ§ÿ±ÿ⿡â⿬ſÿŠ ÿ⿦ÿ§ÿſ ÿªÿ⿦ÿ§ÿ³ ÿ¨ÿ§ ÿ⿦ÿ§ ÿ˿ ÿºÿŠÿ±ÿ⿡ ÿ±ÿ§ ÿ®ÿ˿ÿ§ÿ⿡ÿ¯ ÿ¯ÿ§ÿ¯.\n[fr]Ce plugin permet de cr�er des pages d\'articles qui ne sont reli�es �  aucune hi�rarchie particuli�re.\nEn revanche elles peuvent �ªtre associ�es �  un nom de squelette.\nCela permet notamment de cr�er des pages de notice l�gale, d''� -propos, de contact, etc.\n[ru]Ð⿝Ð°Ð½Ð½ÿ⿹Ð¹ Ð¿Ð»Ð°Ð³Ð¸Ð½ Ð¿Ð¾Ð·Ð²Ð¾Ð»ÿÐµÿ⿿ ÿÐ¾Ð·Ð´Ð°Ð²Ð°ÿ⿿ÿſ Ð¾ÿ⿿Ð´ÐµÐ»ÿſÐ½ÿ⿹Ðµ ÿÿ⿿ÿ⿬Ð°Ð½Ð¸ÿ⿠ÿ⿹ Ð²Ð½Ðµ Ð»ÿŽÐ±ÿ⿹ÿ⿦ ÿ⿬Ð°Ð·Ð´ÐµÐ»Ð¾Ð² ÿÐ°Ð¹ÿ⿿Ð°. Ð­ÿ⿿Ð¾ Ð¾ÿ⿿Ð»Ð¸ÿ⿡Ð½Ð¾Ðµ ÿ⿬Ðµÿ˿ÐµÐ½Ð¸ÿ Ð´Ð»ÿ ÿ⿬Ð°Ð·Ð¼Ðµÿ⿰ÐµÐ½Ð¸ÿ ÐºÐ¾Ð½ÿ⿿Ð°Ðºÿ⿿Ð½Ð¾Ð¹ Ð¸Ð½ÿ⿿Ð¾ÿ⿬Ð¼Ð°ÿ⿠Ð¸Ð¸, ÿƿÿÐ»Ð¾Ð²Ð¸Ð¹ Ð¸ Ð¿ÿ⿬Ð°Ð²Ð¸Ð» Ð¸ÿÐ¿Ð¾Ð»ÿſÐ·Ð¾Ð²Ð°Ð½Ð¸ÿ, Ð° ÿ⿿Ð°Ðº Ð¶Ðµ Ð´Ð»ÿ Ð»ÿŽÐ±Ð¾Ð¹ Ð¸Ð½ÿ⿿Ð¾ÿ⿬Ð¼Ð°ÿ⿠Ð¸Ð¸, ÐºÐ¾ÿ⿿Ð¾ÿ⿬Ð°ÿ Ð»Ð¾Ð³Ð¸ÿ⿡ÐµÿÐºÐ¸ Ð½Ðµ Ð²ÿÿ⿿ÿ⿬Ð°Ð¸Ð²Ð°Ðµÿ⿿ÿÿ Ð² ÿÿ⿿ÿ⿬ÿƿÐºÿ⿿ÿƿÿ⿬ÿƿ ÿÐ°Ð¹ÿ⿿Ð°.\nCela permet notamment de cr�er des pages de notice l�gale, d''� -propos, de contact, etc.\n[sk]Tento z�¡suvn�½ modul v�¡m umoÿ¾ÿ˿uje vytv�¡raÿ¥ str�¡nky sÿ ÿl�¡nkami, ktor� nemaj�º ÿ¾iadnu konkr�tnu hierarchick�º ÿ¡trukt�ºru.\nM�´ÿ¾ete ich vÿ¡ak prepojiÿ¥ sÿ n�¡zvom ÿ¡abl�³ny.\nTo v�¡m umoÿ¾ÿ˿uje vytv�¡raÿ¥ str�¡nky sÿ inform�¡ciami pr�¡vneho charakteru, ÿasov� osi, zmluvy, aÿ i.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:13:"RastaPopoulos";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Plugin-Pages-uniques', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:8:"polyhier";a:1:{s:3:"nom";s:8:"polyhier";}}}}', '2012-08-20 17:00:12', '2012-08-20 17:00:12', 1, 'pages_v1.zip', 32791, '2012-08-20 17:00:12', '_plugins_/pages/trunk', 'a:2:{s:5:"pages";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:6:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/ÿ¬ÿ˿ÿ±ÿ¬-ÿ⿿ÿ⿠ÿ¯ÿ⿿ÿÿª";}}s:2:"en";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:12:"paquet-pages";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:6:{s:2:"ar";a:0:{}s:2:"en";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '6dd1dbfdecc918f9fbf3e202c875a91e'),
(203, 193, 'PALETTE', 'http://files.spip.org/spip-zone/palette_3.png', '003.000.001', '0.1', '[3.0.0;3.*]', '', '<multi>\n[en]Set class palette to an input to add a color picker: <code><input class="palette" name="couleur" value="#dfdfdf" /></code>\n[fr]Donnez la classe palette �  un input pour lui ajouter un s�lecteur de couleurs : <code><input class="palette" name="couleur" value="#dfdfdf" /></code>\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:48:"Daniel FAIVRE (�  partir de travaux de Marcimat)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:6:"LGPL 3";s:3:"url";s:41:"http://www.gnu.org/licenses/lgpl-3.0.html";}}', 'a:1:{i:1;s:9:"2008-2012";}', 'http://www.spip-contrib.net/Palette', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:1:{i:0;a:1:{s:16:"farbtastic_1_3_1";a:2:{s:3:"nom";s:16:"farbtastic_1_3_1";s:4:"lien";s:51:"http://files.spip.org/contribs/farbtastic_1_3_1.zip";}}}s:7:"utilise";a:0:{}}', '2012-07-26 13:19:10', '2012-07-26 13:19:10', 1, 'palette_3.zip', 38211, '2012-07-26 13:19:12', '_plugins_/palette/trunk', 'a:1:{s:7:"palette";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:8:{s:3:"ast";a:1:{i:0;a:2:{s:3:"nom";s:5:"Xuacu";s:4:"lien";s:33:"http://trad.spip.net/auteur/xuacu";}}s:2:"ca";a:0:{}s:2:"de";a:0:{}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:4:"Mark";s:4:"lien";s:32:"http://trad.spip.net/auteur/mark";}}s:2:"fa";a:0:{}s:2:"fr";a:0:{}s:5:"fr_tu";a:1:{i:0;a:2:{s:3:"nom";s:8:"beatnick";s:4:"lien";s:36:"http://trad.spip.net/auteur/beatnick";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'b98d2b778edaee4f0f4b6e05fff97536'),
(204, 194, 'PAYS', 'http://files.spip.org/spip-zone/pays.png', '001.000.006', '1.2.1', '[2.0.9;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[fr]Ce plugin fournit la liste officielle des pays �labor�e par l''[Organisation Internationale de Normalisation->http://www.iso.org/iso/fr/country_codes/iso_3166_code_lists.htm]. La table des pays inclut le champ num�rique id_pays issu du plugin spip_geographie, le code ISO3166-1 et le nom du pays dans diff�rents langages.\r\n	[en]This plugin includes the official country names and codes list provided by the [International Orgnisation for Standardization->http://www.iso.org/iso/fr/country_codes/iso_3166_code_lists.htm]. The country table includes a primary key id_pays used by spip_geographie plugin, an ISO 3166-1 2 code as key, and country names in different languages.\r\n	</multi>', 'a:3:{i:0;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:12:"Cyril MARION";s:3:"url";s:17:"http://www.cym.fr";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:12:"Ateliers CYM";s:3:"url";s:17:"http://www.cym.fr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Liste-des-pays-avec-codes-ISO-3166-1', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:7:"saisies";s:2:"id";s:7:"saisies";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}}}}', '2012-02-16 12:00:35', '2012-02-16 12:00:35', 1, 'pays.zip', 29671, '2012-02-16 12:00:36', '_plugins_/pays/branches/v1.0', 'a:1:{s:4:"pays";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'b96a8ca37ff7761c07cfbf1af3d1c0f6'),
(205, 194, 'PAYS', 'http://files.spip.org/spip-zone/pays-300.png', '002.001.001', '1.2.1', '[3.0.0-alpha2;3.0.*]', '3.0', '<multi>\n[en]This plugin includes the official country names and codes list provided by the [International Orgnisation for Standardization->http://www.iso.org/iso/fr/country_codes/iso_3166_code_lists.htm]. The country table includes a primary key id_pays used by spip_geographie plugin, an ISO 3166-1 2 code as key, and country names in different languages.\n[fr]Ce plugin fournit la liste officielle des pays �labor�e par l''[Organisation Internationale de Normalisation->http://www.iso.org/iso/fr/country_codes/iso_3166_code_lists.htm]. La table des pays inclut le champ num�rique id_pays issu du plugin spip_geographie, le code ISO3166-1 et le nom du pays dans diff�rents langages.\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:12:"Cyril MARION";s:3:"url";s:17:"http://www.cym.fr";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:12:"Ateliers CYM";s:3:"url";s:17:"http://www.cym.fr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Liste-des-pays-avec-codes-ISO-3166-1', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:6:"[1.0;[";}}}}', '2012-04-12 22:00:02', '2012-04-12 22:00:02', 1, 'pays-300.zip', 41303, '2012-04-12 22:00:04', '_plugins_/pays/trunk', 'a:1:{s:4:"pays";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '924904010c39ecaa44afea854af4b8bf'),
(206, 195, 'PDFJS', 'http://files.spip.org/spip-zone/pdfjs.png', '000.001.000', '', '[3.0.0-dev;[', '3.0,3.1', '', 'a:1:{i:1;a:3:{s:3:"nom";s:11:"andreas gal";s:3:"url";s:33:"http://mozilla.github.com/pdf.js/";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:26:"erational (mise en plugin)";s:3:"url";s:24:"http://www.erational.org";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"license";s:3:"url";s:53:"https://github.com/mozilla/pdf.js/blob/master/LICENSE";}}', 'a:1:{i:1;s:23:"2011 Mozilla Foundation";}', 'http://www.spip-contrib.net/Lecteur-pdf-javascript-pdf-js', '', '', 'experimental', 1, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-02-20 01:45:06', '2012-02-20 01:45:06', 1, 'pdfjs.zip', 407291, '2012-02-20 01:45:10', '_plugins_/pdfjs', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '5fef99c5293e454f79582b5e3d1bef36'),
(207, 196, 'PHOTOSPIP', 'http://files.spip.org/spip-zone/photospip3.png', '001.000.002', '0.4', '[3.0.0;3.0.99]', '3.0', '<multi>\n[en]Edit pictures inserted in SPIP applying to them various filters\n[fr]Modifier les images ins�r�es dans SPIP en leur appliquant diff�rents filtres\n[sk]Upravujte obr�¡zky vloÿ¾en� do SPIPu pouÿ¾it�­m r�´znych filtrov\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"kent1";s:3:"url";s:22:"http://www.kent1.info/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2008-2012";}', 'http://photospip.arscenic.org/', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:8:{s:7:"palette";a:2:{s:3:"nom";s:7:"palette";s:13:"compatibilite";s:8:"[1.3.4;[";}s:6:"medias";a:2:{s:3:"nom";s:6:"medias";s:13:"compatibilite";s:9:"[1.6.12;[";}s:8:"jqueryui";a:2:{s:3:"nom";s:8:"jqueryui";s:13:"compatibilite";s:9:"[1.8.19;[";}s:10:"spip_bonux";a:2:{s:3:"nom";s:10:"spip_bonux";s:13:"compatibilite";s:8:"[2.3.0;[";}s:6:"images";a:2:{s:3:"nom";s:6:"images";s:13:"compatibilite";s:8:"[1.0.1;[";}s:8:"verifier";a:2:{s:3:"nom";s:8:"verifier";s:13:"compatibilite";s:9:"[0.1.14;[";}s:12:"ancresdouces";a:2:{s:3:"nom";s:12:"ancresdouces";s:13:"compatibilite";s:8:"[1.3.0;[";}s:8:"mediabox";a:2:{s:3:"nom";s:8:"mediabox";s:13:"compatibilite";s:9:"[0.6.10;[";}}}s:9:"librairie";a:1:{i:0;a:1:{s:26:"jquery.imgareaselect-0.9.8";a:2:{s:3:"nom";s:26:"jquery.imgareaselect-0.9.8";s:4:"lien";s:72:"http://odyniec.net/projects/imgareaselect/jquery.imgareaselect-0.9.8.zip";}}}s:7:"utilise";a:1:{i:0;a:1:{s:16:"Fonctions_images";a:2:{s:3:"nom";s:16:"Fonctions_images";s:13:"compatibilite";s:8:"[0.5.2;[";}}}}', '2012-07-26 13:20:01', '2012-07-26 13:20:01', 1, 'photospip3.zip', 78082, '2012-07-26 13:20:02', '_plugins_/photospip/trunk', 'a:2:{s:16:"paquet-photospip";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:9:"photospip";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '147aa508025655ef52ee27b064b8af3a'),
(208, 197, 'SPIP_THELIA', 'http://files.spip.org/spip-zone/plugin-thelia.png', '001.005', '', '[1.9.0;]', '1.9,2.0,2.1,3.0,3.1', '', 'a:4:{i:1;a:3:{s:3:"nom";s:14:"Arnault Pachot";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:14:"Gilles Vincent";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:17:"Claude Chadoutaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:4;a:3:{s:3:"nom";s:15:"Aur�lien Dumas";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Plugin-Thelia', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-01 16:00:03', '2012-08-01 16:00:03', 1, 'plugin-thelia.zip', 268107, '2012-08-01 16:00:08', '_plugins_/plugin-thelia', 'a:1:{s:10:"spipthelia";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:3:{s:2:"ca";a:0:{}s:2:"en";a:0:{}s:2:"nl";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ed065b5b90ea70b146752584eaa96c80'),
(462, 468, 'GIS', 'http://files.spip.org/spip-zone/gis4.png', '004.001.007', '2.0.2', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en]This plugin allows you to create location-based points that can be attached to SPIP objects to display them on maps in the pages of your site. They can use the tiles from different maps vendors through the Leaflet library.\n[es]Provee la estructura y las interfaces para crear, manejar y visualizar puntos geolocalizados sobre mapas. Estás mapas puedes ser recuperadas desde varios proveedores gracias a la libreria Mapstraction.\n[fr]Ce plugin permet de cr�er des points g�olocalis�s qui peuvent être attach�s aux objets de SPIP afin de les afficher sur des cartes dans les pages de votre site. Ces derni�res peuvent utiliser les tuiles de diff�rents fournisseurs grâce à la librairie Leaflet.\n[sk]Tento zásuvný modul umožſuje vytvárať zemepisn� body, ktor� m�žete pripojiť k objektom SPIPu, aby sa dali zobraziť na mapách na stránkach vášho webu. Vďaka knižnici Leaflet m�žete používať rozhranie od r�znych výrobcov.\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"kent1";s:3:"url";s:21:"http://www.kent1.info";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:28:"Les D�veloppements Durables";s:3:"url";s:17:"http://www.ldd.fr";s:4:"mail";s:0:"";}}', 'a:5:{i:1;a:2:{s:3:"nom";s:7:"Leaflet";s:3:"url";s:29:"http://leaflet.cloudmade.com/";}i:2;a:2:{s:3:"nom";s:15:"Leaflet plugins";s:3:"url";s:42:"https://github.com/shramov/leaflet-plugins";}i:3;a:2:{s:3:"nom";s:17:"Leaflet providers";s:3:"url";s:43:"https://github.com/brunob/leaflet-providers";}i:4;a:2:{s:3:"nom";s:18:"Leaflet fullscreen";s:3:"url";s:44:"https://github.com/brunob/leaflet.fullscreen";}i:5;a:2:{s:3:"nom";s:43:"Ic�ne de mattrich sous licence CC BY-NC-SA";s:3:"url";s:51:"http://mattrich.deviantart.com/art/Picnic-101256405";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:6:"GPL v3";s:3:"url";s:0:"";}}', 'a:1:{i:1;s:9:"2011-2012";}', 'http://contrib.spip.net/4189', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.19.0;]";}}}s:9:"librairie";a:1:{i:0;a:1:{s:17:"leaflet-gis-4.1.1";a:2:{s:3:"nom";s:17:"leaflet-gis-4.1.1";s:4:"lien";s:65:"https://github.com/downloads/brunob/Leaflet/leaflet-gis-4.1.1.zip";}}}s:7:"utilise";a:1:{i:0;a:1:{s:19:"selecteur_generique";a:2:{s:3:"nom";s:19:"selecteur_generique";s:13:"compatibilite";s:7:"[1.12;]";}}}}', '2012-09-10 01:00:10', '2012-09-10 01:00:10', 1, 'gis4.zip', 95734, '2012-09-10 01:00:12', '_plugins_/gis/trunk', 'a:2:{s:3:"gis";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:10:"paquet-gis";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '8edceef4195c087db2451131dda76f3e'),
(210, 199, 'POLYHIER', 'http://files.spip.org/spip-zone/polyhierarchie_v2.png', '002.000.004', '0.1.0', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[en]Plugin for creating cross-links by referencing sections\n	and articles to other sections that their direct parent.\n[fr]Plugin permettant de cr�er des liens transversaux en rattachant des rubriques\n	et articles �  d\'autres rubriques que leur parent direct.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:13:"C�dric Morin";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Polyhierarchie', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-21 16:00:18', '2012-06-21 16:00:18', 1, 'polyhierarchie_v2.zip', 24329, '2012-06-21 16:00:18', '_plugins_/polyhierarchie/branches/v2.0', 'a:2:{s:15:"paquet-polyhier";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"fr";a:0:{}}}s:8:"polyhier";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.org/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.org/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'e9fc127ac821317b8b2164b438050a02'),
(211, 200, 'SPIPOPUP', 'http://files.spip.org/spip-zone/spipopup_s3.png', '001.004.001', '', '[3.0.0-alpha2;[', '3.0,3.1', '<multi>\n[fr]Gestion d\'une fen�ªtre popup ({fen�ªtre externe}) unique sous forme de squelette SPIP et aux dimensions r�glables pour diff�rents usages.\n\n{{Utilisation de la balise #POPUP }}\n<code>\n#POPUP{objet SPIP,squelette,width,height,titre,options}\n</code>\n- {{objet SPIP}} : ''article1'' ou ''id_article=1'' (valable par d�faut pour tout objet �ditorial de SPIP).\n- {{squelette}} : squelette utilis� pour afficher la fen�ªtre ({optionnel - par d�faut : ''{{popup_defaut.html}}''}).\n- {{width}} : la largeur de la fen�ªtre en pixels ({optionnel - {{620px}} par d�faut}).\n- {{height}} : la hauteur de la fen�ªtre en pixels ({optionnel - {{640px}} par d�faut}).\n- {{titre}} : le titre ajout� au lien.\n- {{options}} : un tableau d\'options JavaScript pour la nouvelle fen�ªtre ({location, status ...}).\n\n{{Utilisation du mod�le dans les articles}}\n<code>\n<popup\n|texte=le texte du lien (necessaire)\n|lien=objet SPIP pour le lien (necessaire)\n|skel=squelette (option)\n|width=XX (option)\n|height=XX (option)\n|titre=mon titre (option)\n>\n</code>\nM�ªmes options que la balise, le texte du lien en plus.\n\n{{Retour de la balise #POPUP }}\n\nLa balise retourne un tag de lien (<code>a</code>) avec les attributs suivants:\n- href = " url "\n- onclick = " _popup_set(''url'', width, height, options); return false; " \n- title = " titre - nouvelle fen�ªtre "\n\n[sk]Unik�¡tne ovl�¡danie vyskakovacieho okna ({extern�ho okna}) voÿ forme ÿ¡abl�³ny SPIPu aÿ sÿ rozmermi, ktor� sa daj�º prisp�´sobiÿ¥ podÿ¾a pouÿ¾itia.\n\n{{Pouÿ¾itie tagu #POPUP }}\n<code>\n#POPUP{objekt SPIPu,ÿ¡abl�³na,ÿ¡�­rka,v�½ÿ¡ka,nadpis,vlastnosti}\n</code>\n- {{objekt SPIPu:}} ''article1'' alebo ''id_article=1'' (predvolen�¡ premenn�¡ pre kaÿ¾d�½ redakÿn�½ objekt SPIPu).\n- {{ÿ¡abl�³na:}} ÿ¡abl�³na, ktor�¡ sa pouÿ¾ije na zobrazenie okna  ({nepovinn� â⿬⿿ predvolen�: ''{{popup_defaut.html}}''}).\n- {{ÿ¡�­rka:}} ÿ¡�­rka okna vÿ pixeloch ({nepovinn� â⿬⿿ predvolen�}{{620ÿ px}}).\n- {{v�½ÿ¡ka:}} v�½ÿ¡ka okna vÿ pixeloch ({nepovinn� â⿬⿿ predvolen�} {{640ÿ px}}).\n- {{nadpis:}} nadpis, ktor�½ bude pripojen�½ kÿ odkazu.\n- {{vlastnosti:}} tabuÿ¾ka sÿ vlastnosÿ¥ami JavaScriptu pre nov� okno ({poloha, status, aÿ i.}).\n\n{{Pouÿ¾itie ÿ¡abl�³ny vÿ ÿl�¡nkoch}}\n<pre>\n<popup\n|texte=text odkazu (povinn�)\n|lien=objekt SPIPu pre odkaz(povinn�)\n|skel=ÿ¡abl�³na (nepovinn�)\n|width=XX (nepovinn�)\n|height=XX (nepovinn�)\n|titre=m�´j nadpis (nepovinn�)\n>\n</pre>\nRovnak� vlastnosti ako tag, text odkazu aÿ in�.\n\n{{V�½pis zÿ tagu #POPUP }}\n\nTag vyp�­ÿ¡e tag odkazu (<code>a</code>) sÿ t�½mito parametrami:\n- href = " url "\n- onclick = " _popup_set(''url'', ÿ¡�­rka, v�½ÿ¡ka, vlastnosti); return false; " \n- title = " nadpis â⿬⿿ nov� okno "\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"Piero Wbmstr";s:3:"url";s:39:"http://www.spip-contrib.net/PieroWbmstr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2010-2012";}', 'http://www.spip-contrib.net/?article3573', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:11:"porte_plume";a:2:{s:3:"nom";s:11:"porte_plume";s:13:"compatibilite";s:8:"[1.2.2;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:21:36', '2012-07-26 13:21:36', 1, 'spipopup_s3.zip', 42966, '2012-07-26 13:21:36', '_plugins_/popup/spipopup_spip3', 'a:2:{s:15:"paquet-spipopup";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:8:"spipopup";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'f0f51be3b2ba1cdaa35ecd047b80cbc3'),
(212, 201, 'TYPOENLUMINEE', 'http://files.spip.org/spip-zone/enluminures_typographiques_v3.png', '003.003.001', '', '[2.0.3;3.0.99]', '2.0,2.1,3.0', '<multi>\n[fr]Ce plugin ajoute des raccourcis typographiques et des boutons au porte plume. Par exemple :\r\n-* Paragraphes :\r\n-** {{Sous-titres}} <code>{{{**</code>Texte du titre<code>}}}</code>, le nombre d''�toiles (*) variant de 2 �  5, la barre de raccourcis ne proposant que 2 et 3\r\n-** {{Centrer}} <code>[|</code>Paragraphe centr�<code>|]</code>\r\n-** {{Aligner �  droite}} <code>[/</code>Paragraphe align� �  droite<code>/]</code>\r\n-** {{Encadrer}} <code>[(</code>Paragraphe �  encadrer<code>)]</code>\r\n-* Caract�res :\r\n-** {{Mise en �vidence}} <code>[*</code>texte en �vidence<code>*]</code>\r\n-** {{Mise en �vidence variante}} <code>[**</code>texte en �vidence (autre couleur)<code>*]</code>\r\n-** {{Mise en exposant}} {&lt;sup&gt;}texte en exposant{&lt;/sup&gt;}\r\n-** {{Petites capitales}} {&lt;sc&gt;}texte en petite capitales{&lt;/sc&gt;}\r\n-** {{Biff�}} {&lt;del&gt;}texte biff�{&lt;/del&gt;}\n\n\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:7:"Jacques";s:3:"url";s:43:"http://www.spip-contrib.net/_Jacques-PYRAT_";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:9:"Fran�§ois";s:3:"url";s:47:"http://www.spip-contrib.net/_Francois-Schreuer_";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:4:"2007";}', 'http://www.spip-contrib.net/Enluminures-typographiques-V3-pour-SPIP-2-avec', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:11:"porte_plume";a:2:{s:3:"nom";s:11:"porte_plume";s:13:"compatibilite";s:8:"[1.2.2;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-05-23 13:00:12', '2012-05-23 13:00:12', 1, 'enluminures_typographiques_v3.zip', 51675, '2012-05-23 13:00:14', '_plugins_/porte_plume_extras/enluminures_typographiques_v3', 'a:1:{s:9:"enlumtypo";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:4:{s:2:"ar";a:0:{}s:2:"en";a:0:{}s:2:"es";a:0:{}s:2:"it";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'e6687effb1efdcd426b08a1785297ca8'),
(213, 202, 'PP_CHGT_LG', 'http://files.spip.org/spip-zone/porte_plume_changement_langue.png', '000.003.000', '', '[2.0.3;3.0.99]', '2.0,2.1,3.0', 'Ajoute un bouton au porte-plume permettant d\'indiquer un changement de langue dans le texte.', 'a:1:{i:0;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article3705', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{i:0;a:4:{s:2:"id";s:11:"porte_plume";s:3:"nom";s:11:"porte_plume";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-10-21 09:16:51', '2011-10-21 09:16:51', 1, 'porte_plume_changement_langue.zip', 17790, '2011-10-21 10:00:06', '_plugins_/porte_plume_extras/changement_langue', 'a:1:{s:10:"pp_chgt_lg";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '7cfe7d3ee5b9019e32cd35148448bc0d'),
(214, 203, 'PP_LOREMIPSUM', '', '001.001.000', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', 'Cette extension ajoute des boutons pour cr�er du texte factice dans la barre d\'outil de SPIP.', 'a:1:{i:0;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:2:{i:0;a:2:{s:3:"nom";s:7:"ÿ© 2007";s:3:"url";s:0:"";}i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{i:0;a:4:{s:2:"id";s:11:"porte_plume";s:3:"nom";s:11:"porte_plume";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-10-18 14:57:11', '2011-10-18 14:57:11', 1, 'porte_plume_lorem_ipsum.zip', 5052, '2011-10-18 15:00:36', '_plugins_/porte_plume_extras/loremipsum', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '482522b8904b2a01eaeb3236d54f9b0b'),
(215, 204, 'PPP', 'http://files.spip.org/spip-zone/porte_plume_partout.png', '001.000.005', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\n[en]Quill everywhere enables the editing toolbar on other text fields (standfirst, description, ps)\n[fr]Porte Plume Partout sert �  ajouter la barre d''�dition aux champs DESCRIPTIF, CHAPO et PS\n[ru]Ð⿝Ð¾Ð±Ð°Ð²Ð»ÐµÐ½Ð¸Ðµ Ð¿Ð°Ð½ÐµÐ»Ð¸ Ð¸Ð½ÿÿ⿿ÿ⿬ÿƿÐ¼ÐµÐ½ÿ⿿Ð¾Ð² Ð´Ð»ÿ ÿ⿿Ð¾ÿ⿬Ð¼Ð°ÿ⿿Ð¸ÿ⿬Ð¾Ð²Ð°Ð½Ð¸ÿ ÿ⿿ÐµÐºÿÿ⿿Ð° Ð½Ð° Ð²ÿÐµ Ð¾ÿÐ½Ð¾Ð²Ð½ÿ⿹Ðµ Ð¿Ð¾Ð»ÿ ÿÐ°Ð¹ÿ⿿Ð° (chapo, post script, descriptif)\n[sk]Porte Plume vÿ¡ade sa pouÿ¾�­va na prid�¡vanie panela �ºprav kÿ poliam POPIS, PEREX aÿ PS\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:14:"Pascal M�chin";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:13:"Jacques Pyrat";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Plugin-Porte-plume-partout', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:11:"porte_plume";a:2:{s:3:"nom";s:11:"porte_plume";s:13:"compatibilite";s:8:"[1.6.4;[";}s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:6:"[1.1;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-25 00:01:21', '2012-08-25 00:01:21', 1, 'porte_plume_partout.zip', 16043, '2012-08-25 00:01:22', '_plugins_/porte_plume_extras/partout', 'a:2:{s:10:"paquet-ppp";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:3:"ppp";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '6d537bb3ee9dc81f23fdececa2fe5d55'),
(216, 205, 'ICONESPEDAGO', 'http://files.spip.org/spip-zone/icones_pedagogiques.png', '000.001.000', '', '[2.0.3;3.0.99]', '2.0,2.1,3.0', 'Ajoute des boutons au porte-plume afin d\'ins�rer des ic�´nes �  orientation p�dagogique ou des smileys.\r\n\r\nLes images disponibles sont regroup�es par onglet.\r\n-* Liste des onglets :\r\n-* Consignes\r\n-* Mat�riel\r\n-* Num�ration : dominos\r\n-* Num�ration : mains\r\n-* Conscience phonologique\r\n-* Supports d''�criture\r\n-* Binettes\r\n\r\nUn simple clic sur une ic�´ne propos�e permet d\'ajouter dans le texte de l''article un morceau de code qui sera ensuite interpr�t� par SPIP pour afficher l''image correspondante.', 'a:2:{i:0;a:3:{s:3:"nom";s:15:"Olivier Gautier";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:14:"Michel Fraisse";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{i:0;a:4:{s:2:"id";s:11:"porte_plume";s:3:"nom";s:11:"porte_plume";s:7:"version";s:8:"[1.2.2;]";s:13:"compatibilite";s:8:"[1.2.2;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-12-22 14:00:20', '2011-12-22 14:00:20', 1, 'icones_pedagogiques.zip', 136841, '2011-12-22 14:00:20', '_plugins_/porte_plume_extras/icones_pedagogiques', 'a:1:{s:12:"iconespedago";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '4a5363ba23fc984bc555c0c6f1b3ca9b'),
(217, 206, 'PP_LATEX', 'http://files.spip.org/spip-zone/porteplume_equation.png', '000.003.001', '', '[2.0.3;3.1.99]', '2.0,2.1,3.0,3.1', 'Ajoute un bouton au porte-plume permettant le chargemente de boutons pour inserer les raccourci LaTeX.', 'a:1:{i:0;a:3:{s:3:"nom";s:4:"MMMX";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/2978', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{i:0;a:4:{s:2:"id";s:11:"porte_plume";s:3:"nom";s:11:"porte_plume";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-11 20:00:02', '2012-06-11 20:00:02', 1, 'porteplume_equation.zip', 201831, '2012-06-11 20:00:02', '_plugins_/pp_equation', 'a:1:{s:8:"pp_latex";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"it";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ce8bc6fc7341016122dad9b1b7cc3183'),
(218, 207, 'PRIX', 'http://files.spip.org/spip-zone/prix.png', '000.001.005', '', '[2.1.8;3.0.99]', '2.1,3.0', 'Interface de programmation pour conna�®tre le prix d\'un objet SPIP. Ce plugin est un outil pour d�veloppeur.', 'a:1:{i:0;a:3:{s:3:"nom";s:28:"Les D�veloppements Durables";s:3:"url";s:17:"http://www.ldd.fr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:21:17', '2012-07-26 13:21:17', 1, 'prix.zip', 14731, '2012-07-26 13:21:20', '_plugins_/prix', 'a:1:{s:4:"prix";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ac39cbdac11d385695a1caf3788c6728'),
(220, 209, 'PUBBAN', 'http://files.spip.org/spip-zone/pub_banner_s3.png', '001.030.002', '0.9', '[3.0.0-beta;[', '3.0,3.1', '<multi>\n[fr]Gestion et statistiques de banni�res publicitaires pour int�gr�es aux squelettes SPIP ...\n\n{{UTILISATION}}\n\n-* Ce plugin ajoute la balise {{ #PUBBAN{nom de la banni�re} }} pour les squelettes, qui est remplac�e par une frame englobant la banni�re.\n-* Une page publique vous permet de pr�senter les statistiques des encarts et de les exporter au format ''.xls''.\n\n{{VALEURS PAR DEFAUT}}\n\n-* Des banni�res standards sont charg�es par d�faut �  l''installation ; il s''agit des quatre types les plus r�pandus sur le web. Vous pouvez les effacer et en cr�er de nouvelles.\n-* Des exemples d\'encarts ({�cureuil SPIP}) sont �galement charg�s, pour d�monstration.\n\n{{AIDE / DOC}}\n\n-* Une explication ainsi qu''un exemple complet sont disponibles dans la documentation, qui vous permettra �galement de visualiser l''int�gration des banni�res dans vos squelettes. Cette documentation est disponible, si le plugin est actif sur votre site, sur la page publique "pubban_documentation".\n\n-* La page de statistiques du plugin est une adaptation libre du script ''{{[VRG pub->http://vrgpub.frankdevelopper.com/]}}'' d�velopp� par {{Vincent Roseberry}} ({sous licence GPL �  l''�poque}).\n[sk]Ovl�¡danie aÿ ÿ¡tatistiky reklamn�½ch p�ºtaÿov integrovan�½ch vÿ ÿ¡abl�³nach SPIPu.\n\n{{POUÿ½ITIE}}\n\n-* Tento z�¡suvn�½ modul prid�¡ do ÿ¡abl�³n tag {{ #PUBBAN{n�¡zov p�ºtaÿa,} }} ktor�½ nahrad�­ r�¡m umiestnen�½ okolo p�ºtaÿa.\n-* Verejn�¡ str�¡nka v�¡m umoÿ¾ÿ˿uje zobraziÿ¥ ÿ¡tatistiky p�ºtaÿov aÿ exportovaÿ¥ ich do form�¡tu  ".xls".\n\n{{PREDVOLEN�⿰ HODNOTY}}\n\n-* Podÿ¾a predvolen�½ch nastaven�­ sa ÿ¡tandardn� p�ºtaÿe nahr�¡vaj�º pri inÿ¡tal�¡cii; s�º to ÿ¡tyri najbeÿ¾nejÿ¡ie typy na internete. M�´ÿ¾ete ich mazaÿ¥ aÿ vytv�¡raÿ¥ nov�.\n-* Uk�¡ÿ¾kov� p�ºtaÿe ({veveriÿka SPIP}) sa nahr�¡vaj�º ajÿ ako demo.\n\n{{POMOC/DOKUMENT�CIA}}\n\n-* Podrobn� vysvetlenie aÿ pr�­klady n�¡jdete vÿ dokument�¡cii, ktor�¡ v�¡m umoÿ¾ÿ˿uje ajÿ zobraziÿ¥ si uk�¡ÿ¾ku integr�¡cie p�ºtaÿov do ÿ¡abl�³n. T�¡to dokument�¡cia v�¡m bude kÿ dispoz�­cii, ak si z�¡suvn�½ modul aktivujete na verejne pr�­stupnej str�¡nke "pubban_documentation".\n\n-* Str�¡nka soÿ ÿ¡tatistikami z�¡suvn�ho modulu je jednoduch�½m prisp�´soben�­m skriptu "{{[VRG pub->http://vrgpub.frankdevelopper.com/]}}," ktor�½ naprogramoval {{Vincent Roseberry}} ({toho ÿasu sÿ licenciou GPL.})\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"Piero Wbmstr";s:3:"url";s:39:"http://www.spip-contrib.net/PieroWbmstr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:22:"Creative Commons BY-SA";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/?article3637', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:10:"spip_bonux";a:2:{s:3:"nom";s:10:"spip_bonux";s:13:"compatibilite";s:6:"[1.3;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-02 12:00:03', '2012-09-02 12:00:03', 1, 'pub_banner_s3.zip', 684152, '2012-09-02 12:00:16', '_plugins_/pub_banner/trunk', 'a:2:{s:13:"paquet-pubban";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:6:"pubban";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:1:{s:2:"fr";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '160a693210044a3a48089544259cf0bd'),
(221, 210, 'QUERYPATH', 'http://files.spip.org/spip-zone/querypath.png', '001.000.000', '', '[3.0.0-dev;3.1.*]', '3.0,3.1', '<multi>\n[fr]Query Path (http://querypath.org/) est une librairie PHP permettant de r�cup�rer, s�lectionner et manipuler un contenu HTML comme le fait la librairie javascript jQuery.\r\n\r\nCe plugin permet d\'utiliser cette librairie dans SPIP.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:19:"Marcillaud Matthieu";s:3:"url";s:24:"http://www.magraine.net/";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:28:"Matt Butcher (QueryPath lib)";s:3:"url";s:20:"http://querypath.org";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/?article4197', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-12 16:00:33', '2012-07-12 16:00:33', 1, 'querypath.zip', 88204, '2012-07-12 16:00:34', '_plugins_/querypath', 'a:1:{s:9:"querypath";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '7fe2bc1eb71bdb126b1409f2ef54b188'),
(222, 211, 'RAINETTE', 'http://files.spip.org/spip-zone/rainette_v1.png', '001.004.001', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', 'Ce plugin permet d\'afficher les conditions et les pr�visions m�t�orologiques d\'une ville donn�e �  partir du flux xml fourni par le site weather.comÿ®.\nIl ne stocke aucune information en base de donn�es ni ne g�re le choix des villes.\n\nL''affichage des donn�es m�t�orologiques se fait principalement via l''utilisation de mod�les dans les squelettes. Le plugin propose des \nmod�les par d�faut comme {{rainette_previsions}} et {{rainette_conditions}}. Il est possible aussi d\'afficher les informations sur la ville choisie soit via le mod�le {{rainette_infos}},\nsoit via la balise {{RAINETTE_INFOS}}. Tous les affichages propos�s par Rainette sont personnalisables (ic�´nes, libell�s, unit�s, pr�sentation...).\n\nUne page ÿ« Meteo ÿ» compatible avec les squelettes Z est disponible : elle propose les conditions et pr�visions �  10 jours d\'une ville donn�ee.\n\nEssayez la page de d�mo {demo/rainette.html} pour des exemples d\'utilisation.', 'a:2:{i:0;a:3:{s:3:"nom";s:12:"Cedric Morin";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:14:"Eric Lupinacci";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/article3133', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-16 04:00:50', '2012-08-16 04:00:50', 1, 'rainette_v1.zip', 2033526, '2012-08-16 04:00:52', '_plugins_/rainette/branches/v1', 'a:1:{s:8:"rainette";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:7:{s:2:"ca";a:0:{}s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"es";a:1:{i:0;a:2:{s:3:"nom";s:6:"_Eric_";s:4:"lien";s:34:"http://trad.spip.net/auteur/_eric_";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '798855d6baaf6b8e4530d77b87aad8d6'),
(223, 212, 'READABILITY', 'http://files.spip.org/spip-zone/readability.png', '000.002.000', '', '[2.1.0;3.0.99]', '2.1,3.0', 'Readability est au d�part un javascript d�velopp� par la soci�t� [arc90->http://lab.arc90.com/2009/03/02/readability/] qui permet de retirer tout le superflu d\'une page Web, et d\'en afficher le contenu essentiel, sans la navigation, la pub, etc.\r\n\r\nCe script a depuis �t� port� par ses auteurs sous forme de service Web ([->http://www.readability.com]). Apple l''a �galement install� en standard dans son navigateur Safari. Il en existe un portage en PHP, d�velopp� par [Keyvan Minoukadeh->http://www.keyvan.net/2010/08/php-readability/]. C''est ce dernier qui est inclus dans ce plugin.', 'a:3:{i:0;a:3:{s:3:"nom";s:5:"Arc90";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:17:"Keyvan Minoukadeh";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:27:"Apache licence, version 2.0";s:3:"url";s:42:"http://www.apache.org/licenses/LICENSE-2.0";}}', '', 'http://www.spip-contrib.net/3758', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-11-19 16:13:11', '2011-11-19 16:13:11', 1, 'readability.zip', 33842, '2011-11-19 17:00:16', '_plugins_/readability', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '96d7a4ab01ce1a2e018331c76e1cf8d0');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(224, 213, 'RECOMMANDER', 'http://files.spip.org/spip-zone/recommander.png', '001.000.002', '', '[2.0.12;3.0.*]', '2.0,2.1,3.0', '<multi>\n[en]"Recommend a pages to a friend" functionnality.\n			\nWe add it in a skeleton like this :\n<code>#RECOMMANDER{title of the page,URL of the page,introduction of the page,subject}</code>\n_ for example\n<code>#RECOMMANDER{#TITRE,#URL_ARTICLE,#INTRODUCTION}</code>\n_ Url, introduction and subject are optionals.\n[fr]Fonction recommander une page �  un ami.\n\nOn l''ajoute dans n''importe quel squelette sous la forme :\n<code>#RECOMMANDER{titre de la page,url de la page,intro de la page,sujet}</code>\n_ par exemple\n<code>#RECOMMANDER{#TITRE,#URL_ARTICLE,#INTRODUCTION}</code>\n_ l''url, l''intro et le sujet sont facultatifs\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"fil@rezo.net";s:3:"url";s:0:"";s:4:"mail";s:22:"mailto:fil AT rezo.net";}}', '', '', '', 'http://www.spip-contrib.net/Recommander', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-25 00:01:04', '2012-08-25 00:01:04', 1, 'recommander.zip', 14273, '2012-08-25 00:01:04', '_plugins_/recommander', 'a:2:{s:18:"paquet-recommander";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"fr";a:0:{}}}s:11:"recommander";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"ar";a:0:{}s:2:"en";a:0:{}s:2:"fr";a:0:{}s:5:"pt_br";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '72ce8d7ade23bdf6e6e0f3b5d486d123'),
(225, 214, 'REDIRHTTPS', 'http://files.spip.org/spip-zone/redirhttps.png', '000.001.000', '', '[2.1.11;[', '2.1,3.0,3.1', '<multi>\n[es]Redirecci�³n hac�­a HTTPS cuando el contendio le necesita (espacio privado, login, p�¡ginas p�ºblicas con el usuario conectado)\n[fr]Redirection vers HTTPS quand le contenu le n�cessite (espace priv�, login, pages publiques avec utilisateur connect�)\n[sk]Presmerovanie na HTTPS, ak si to vyÿ¾aduje obsah (s�ºkromn�¡ z�³na, prihl�¡senie, pouÿ¾�­vateÿ¾ prihl�¡sen�½ cezÿ verejne pr�­stupn� str�¡nky)\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:6:"Severo";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:14:"Oliver Scholtz";s:3:"url";s:72:"http://www.iconfinder.com/icondetails/25388/128/high_security_thick_icon";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Rediriger-en-HTTPS-quand-l-utilisateur-est-connecte', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:22:01', '2012-07-26 13:22:01', 1, 'redirhttps.zip', 16024, '2012-07-26 13:22:02', '_plugins_/redirhttps', 'a:2:{s:17:"paquet-redirhttps";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"es";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:10:"redirhttps";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '793891fdbf8b6b72e667b72475761b02'),
(226, 215, 'REFBASE', 'http://files.spip.org/spip-zone/refbase_v2.png', '002.001.002', '0.1.0', '[3.0.0-dev;3.0.99]', '3.0', '<multi>\n[en]This plugin allows to import bibliographic references from a [refbase->http://www.refbase.net] database and to display them \r\nin SPIP with a model called <code><refbase></code>.\n[fr]Ce plugin permet d\'importer des r�f�rences bibliographiques contenues dans une ou plusieurs bases de donn�es [refbase->http://www.refbase.net] et de les afficher simplement dans SPIP �  l''aide du mod�le <code><refbase></code>.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:34:"http://www.spip-contrib.net/Joseph";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/spip.php?article3036', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-01-26 17:00:32', '2012-01-26 17:00:32', 1, 'refbase_v2.zip', 31092, '2012-01-26 17:00:34', '_plugins_/refbase/trunk', 'a:1:{s:7:"refbase";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '03d11b470c6f12203a20335ee31fd6c8'),
(227, 216, 'RETOURSIMPLE', 'http://files.spip.org/spip-zone/retoursimple.png', '000.002.000', '', '[2.1.0;3.0.99]', '2.1,3.0', 'Pour le respect automatique des ÿ«ÿ retours �  la ligneÿ ÿ», ÿ«ÿ allers �  la ligneÿ ÿ», ÿ«ÿ retours chariotÿ ÿ». \r\n\r\nDepuis ses d�buts semble-t-il, SPIP comporte le filtre <code>|post_autobr</code> destin� �  assurer le respect des alin�as, mais curieusement ce filtre a �t� n�glig� et aucun plugin n\'en permettait la mise en ÿ⿿uvre. Tel est d�sormais l\'objet du pr�sent plugin. Le code <code><br /></code> est automatiquement ajout� dans ce cas, comme lors de l\'ajout manuel de <code>_</code> (â⿬ſtiret basâ⿬, â⿬ſunderscoreâ⿬, suivi d\'un{e} espace) en d�but de ligne.\r\n\r\nEn revanche, il ne s\'agit pas de cr�er des espaces (multiples â⿬ſlignes videsâ⿬) par plusieurs retours �  la ligneÿ : dans ce cas il est estim� que le comportement de SPIP doit demeurer, qui �limine les espaces multiples, et cr�e un nouveau paragraphe lors de saut(s) de ligne(s).\r\n\r\nR�sultatÿ : Le respect des alin�as obtenu concerne les Rubriques, les Articles (chapeau, texte, post-scriptum), les Br�ves, et leurs Notes de bas de page respectives. Et dans nombre de cas, les champs cr��s par d\'autres pluginsÿ : tout champ sur lequel les raccourcis typographiques de SPIP sont appel�s doit normalement respecter ces r�gles de ÿ«ÿ Retour simpleÿ ÿ», respect des alin�as, avec ce plugin.\r\n\r\nP.S.ÿ 1ÿ : S\'agissant des plus r�centes versions de SPIP, le respect des alin�as est assur� directement par SPIP (sans plugin) dans les messages de forums publics sous les articlesÿ : il a �t� donc r�cemment consid�r� dans ce cas que ÿ«ÿ le publicÿ ÿ» de SPIP doit s\'attendre au respect des alin�as.\r\n\r\nP.S.ÿ 2ÿ : {Le pr�sent plugin ne fonctionne pas si le ÿ«ÿ Couteau suisseÿ ÿ» est install�ÿ ; dans ce cas, utiliser la â⿬ſlameâ⿬ ÿ«ÿ Retours de ligne automatiquesÿ ÿ» du Couteau suisse.}', 'a:3:{i:0;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:35:"http://www.spip-contrib.net/auteur4";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:7:"Ma�¯eul";s:3:"url";s:38:"http://www.spip-contrib.net/auteur2650";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:4:"PatV";s:3:"url";s:38:"http://www.spip-contrib.net/auteur5714";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Alineas-Retour-simple', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-10-20 01:00:06', '2011-10-20 01:00:06', 1, 'retoursimple.zip', 3395, '2011-10-20 01:00:06', '_plugins_/retoursimple', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '098d93020080fd5211d4d1eeb5d51974'),
(228, 217, 'RSSARTICLE', 'http://files.spip.org/spip-zone/rss_article_3_0.png', '001.001.000', '1.0.0', '[3.0.2;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin recopie les flux RSS (articles syndiqu�s) en articles\r\n\r\n-* reprise du contenu du flux;\r\n-* cr�� l''auteur s''il est mentionn� dans le flux;\r\n-* ajoute les documents distants pr�sents dans le flux;\r\n-* dans le champs URL de l''article, on indique l''adresse de l''article d\'origine.\r\n\r\nPour �viter les doublons et les imports successifs, une fois l''article cr��, l''article syndiqu� est rejet� (ce qui permet de suivre o�¹ en sont les recopi�s).\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:9:"erational";s:3:"url";s:24:"http://www.erational.org";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:6:"LudoRA";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:10:"GNU/GPL v3";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Plugin-Flux-RSS-en-articles', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-01 10:00:12', '2012-08-01 10:00:12', 1, 'rss_article_3_0.zip', 24260, '2012-08-01 10:00:22', '_plugins_/rss_article/trunk', 'a:1:{s:10:"rssarticle";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"ar";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '5df95015f72bb01196cf0d854ef329d2'),
(229, 218, 'RSSCONFIG', 'http://files.spip.org/spip-zone/rss_configurable.png', '001.004.000', '', '[2.1.0;3.0.*]', '2.1,3.0', '<multi>\n[fr]Ce plugin vous permet de personnaliser le fonctionnement de votre flux RSS �  l\'aide d\'un formulaire dans l\'espace priv�.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:34:"http://www.spip-contrib.net/Joseph";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article3793', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:1:"Z";a:1:{s:3:"nom";s:1:"Z";}s:5:"Zdist";a:1:{s:3:"nom";s:5:"Zdist";}}}}', '2012-07-27 11:00:02', '2012-07-27 11:00:02', 1, 'rss_configurable.zip', 128829, '2012-07-27 11:00:04', '_plugins_/rss_configurable', 'a:1:{s:9:"rssconfig";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '416743af92f7a38d70dae4e7ae5ab12e'),
(230, 219, 'RUBRIQUE_A_LINSCRIPTION', 'http://files.spip.org/spip-zone/rubrique_a_linscription.png', '001.000.000', '0.3', '[3.0.0-beta;3.0.99]', '3.0', '<multi>\n[fr]Si le formulaire d\'inscription est pass� avec l''argument 0minirezo (<code>#FORMULAIRE_INSCRIPTION{0minirezo}</code>), une rubrique est automatiquement cr��e, o�¹ l''auteur est admin restreint.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:17:"Ma�¯eul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Rubrique-a-l-inscription', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-04-14 22:01:00', '2012-04-14 22:01:00', 1, 'rubrique_a_linscription.zip', 15559, '2012-04-14 22:01:00', '_plugins_/rubrique_a_linscription/trunk', 'a:1:{s:23:"rubrique_a_linscription";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'bb2fffc2c046dcd9549394593f54461d'),
(461, 468, 'GIS', 'http://files.spip.org/spip-zone/gis3.png', '003.003.012', '2.0.2', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en]This plugin allows you to create location-based points that can be attached to SPIP objects to display them on maps in the pages of your site. They can use the interface of different suppliers through the Mapstraction library.\n[es]Provee la estructura y las interfaces para crear, manejar y visualizar puntos geolocalizados sobre mapas. Estás mapas puedes ser recuperadas desde varios proveedores gracias a la libreria Mapstraction.\n[fr]Ce plugin permet de cr�er des points g�olocalis�s qui peuvent être attach�s aux objets de SPIP afin de les afficher sur des cartes dans les pages de votre site. Ces derni�res peuvent utiliser l''interface de diff�rents fournisseurs grâce à la librairie Mapstraction.\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"kent1";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:28:"Les D�veloppements Durables";s:3:"url";s:17:"http://www.ldd.fr";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:43:"Ic�ne de mattrich sous licence CC BY-NC-SA";s:3:"url";s:51:"http://mattrich.deviantart.com/art/Picnic-101256405";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:6:"GPL v3";s:3:"url";s:0:"";}}', 'a:1:{i:1;s:4:"2011";}', 'http://www.spip-contrib.net/GIS2', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.19.0;]";}}}s:9:"librairie";a:1:{i:0;a:1:{s:13:"mxn-gis-2.2.2";a:2:{s:3:"nom";s:13:"mxn-gis-2.2.2";s:4:"lien";s:57:"https://github.com/downloads/brunob/mxn/mxn-gis-2.2.2.zip";}}}s:7:"utilise";a:1:{i:0;a:1:{s:19:"selecteur_generique";a:2:{s:3:"nom";s:19:"selecteur_generique";s:13:"compatibilite";s:7:"[1.12;]";}}}}', '2012-09-10 01:00:03', '2012-09-10 01:00:03', 1, 'gis3.zip', 89927, '2012-09-10 01:00:06', '_plugins_/gis/branches/v3', 'a:2:{s:3:"gis";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.org/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.org/auteur/jaro";}}}}s:10:"paquet-gis";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.org/auteur/kent1";}}s:2:"es";a:0:{}s:2:"fr";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '05ed2980aff3e0c4079b49c14e0c31ae'),
(232, 221, 'SAVEAUTO', 'http://files.spip.org/spip-zone/saveauto_3_0.png', '000.008.001', '0.1.0', '[3.0.0;3.0.99]', '3.0', '<multi>\n[en]Makes a backup of the entire database used by SPIP.\r\n			The .gz or .sql file obtained is stored in a directory (default /tmp, but configurable) and can be sent automatically by email.\r\n			\r\n			The backup is triggered by a cron job (the frequency is configurable).\r\n			The stored backups considered obsolete (according to the corresponding config setting) are automatically destroyed.\n[fr]Permet de r�aliser une sauvegarde de toute la base de donn�es utilis�e par SPIP.\r\n			Le fichier .zip (ou .sql) obtenu est stock� dans un r�pertoire (par d�faut /tmp/dump, configurable)\r\n			et peut �ªtre envoy� par mail.\r\n			\r\n			Les sauvegardes stock�es consid�r�es comme obsol�tes (en fonction du param�tre de config correspondant)\r\n			sont automatiquement d�truites.\r\n			\r\n			Une interface permet de d�clencher manuellement les sauvegardes et de g�rer les fichiers g�n�r�s\n[it]Consente di effettuare un salvataggio di tutta la base dati utilizzata da SPIP.\r\n			Il file .zip (o .sql) ottenuto � memorizzato all''interno di una cartella (in maniera predefinita /tmp/dump, configurabile)\r\n			e pu�² essere inviato per posta elettronica.\r\n			\r\n			I salvataggi memorizzati considerati obsoleti (in funzione del parametro di configurazione corrispondente)\r\n			vengono automaticamente cancellati.\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:9:"cy_altern";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:14:"Eric Lupinacci";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:8:"Silicium";s:3:"url";s:0:"";s:4:"mail";s:23:"silicium AT japanim.net";}}', '', '', '', 'http://www.spip-contrib.net/Le-plugin-saveauto-sauvegarde', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"facteur";a:2:{s:3:"nom";s:7:"facteur";s:13:"compatibilite";s:8:"[1.5.6;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-19 12:00:47', '2012-06-19 12:00:47', 1, 'saveauto_3_0.zip', 36634, '2012-06-19 12:00:58', '_plugins_/saveauto/branches/3.0', 'a:1:{s:8:"saveauto";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"ca";a:0:{}s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.org/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '9b5e142334edb9e4abb2526e4d89e091'),
(233, 222, 'SCRUT_PROP', 'http://files.spip.org/spip-zone/scrutin_liste_proportionelle_dev.png', '001.003.000', '', '[3.0.0;3.0.99]', '3.0', '<multi>\n[fr]Vous pouvez ins�rer dans un article un formulaire de la mani�re suivante.\n	<code><formulaire|scrut_prop|liste=A;B;C;...></code>, ou A;B;C,... sont des noms de liste.\n	\n	Un formulaire apparait. Il propose :\n-* de remplir les voix pour chaque liste.\n-* de remplir le nombre de blanc ou nul.\n-* de remplir le nombre d\'inscrits.\n-* de fournir le nombre de si�ges �  pourvoir.\n-* de pr�ciser si le scrutin se fait au plus fort reste ou �  la plus forte moyenne.\n-* de fixer un seuil de voix (en pourcentage) pour obtenir des si�ges (le nombre de voix est arrondi �  la valeur inf�rieure).\n-* de proposer une prime majoritaire (depuis la version 1.1)\n\n	Une fois rempli, le formulaire teste si les valeurs sont coh�rentes (pas plus de votants que d\'inscrits par exemple !). Puis il calcule la r�partition de si�ges.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:17:"Ma�¯eul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Plugin-scrutin-de-liste-a-la', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-05-23 23:00:02', '2012-05-23 23:00:02', 1, 'scrutin_liste_proportionelle_dev.zip', 17330, '2012-05-23 23:00:04', '_plugins_/scrutin_liste_proportionnel', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '957ba5ac88b1ab214e86108b78fabf97'),
(234, 223, 'SCENARI', 'http://files.spip.org/spip-zone/scenari.png', '000.000.001', '', '[2.1.0;3.0.99]', '2.1,3.0', '<multi>\r\n	[fr]Permet d\'ajouter facilement une archive [scenari->http://scenari-platform.org/] dans un article SPIP.\r\n	[en]Make it easy to add a [scenari->http://scenari-platform.org/] archive in articles.\r\n	</multi>', 'a:1:{i:0;a:3:{s:3:"nom";s:15:"Gr�gory Pascal";s:3:"url";s:34:"http://www.spip-contrib.net/ngombe";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Scenari-pour-SPIP', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-10-09 21:41:50', '2011-10-09 21:41:50', 1, 'scenari.zip', 18652, '2011-10-09 22:00:32', '_plugins_/scenari', 'a:1:{s:7:"scenari";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '7b61e92714f7fa26c9f0a71ba3f4831a'),
(457, 464, 'FACTEUR', 'http://files.spip.org/spip-zone/facteur-2.0.png', '002.002.006', '1.1', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en]Postman delivers emails in HTML, text or mixed format; via SMTP or not\n[fr]Facteur s''occupe de la distribution des courriels au format HTML, texte ou mixte ; via SMTP ou non\n[sk]Poštár slúži na doručovanie e-mailov vo formáte HTML, v textovej alebo v zmiešanej podobe či už cez SMTP, alebo nie\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Facteur', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-13 11:00:03', '2012-09-13 11:00:03', 1, 'facteur-2.0.zip', 101817, '2012-09-13 11:00:04', '_plugins_/facteur/trunk', 'a:2:{s:7:"facteur";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"de";a:0:{}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:14:"paquet-facteur";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'be7fa6840213d9810e8669b3d4e83d97'),
(458, 465, 'FAQ', 'http://files.spip.org/spip-zone/faq.png', '002.001.021', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', 'Transformez les listes de d�finitions marqu�es du s�lecteur «<code>faq</code>» en <abbr title="Foire Aux Questions">FAQ</abbr> d�pliable.', 'a:1:{i:0;a:3:{s:3:"nom";s:14:"romy.tetue.net";s:3:"url";s:21:"http://romy.tetue.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?rubrique891', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-06 16:00:25', '2012-09-06 16:00:25', 1, 'faq.zip', 44351, '2012-09-06 16:00:26', '_plugins_/faq', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd2ff7873b7f9fb6d8f2fcd9bec87bfec'),
(236, 225, 'SIMPLOG', 'http://files.spip.org/spip-zone/simplog_v1.gif', '000.002.001', '', '[2.1.0;3.0.99]', '2.1,3.0', 'Une fois le plugin activ�, les administrateurs ont la possibilit� de consulter tous les journaux disponibles sur le site. Une entr�e du menu Maintenance permet de se rendre sur la page de consultation (simplog).', 'a:1:{i:0;a:3:{s:3:"nom";s:8:"Luc Tech";s:3:"url";s:0:"";s:4:"mail";s:16:"luc.tech@free.fr";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:7:"GNU/GLP";s:3:"url";s:0:"";}}', '', '', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{i:0;a:4:{s:2:"id";s:10:"iterateurs";s:3:"nom";s:10:"iterateurs";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:5:"bando";s:2:"id";s:5:"bando";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}}}}', '2012-05-14 10:00:14', '2012-05-14 10:00:14', 1, 'simplog_v1.zip', 7769, '2012-05-14 10:00:16', '_plugins_/simplog/branches/v1', 'a:1:{s:7:"simplog";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.org/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.org/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '873e8e3510f57ab39746bd6508e3145b'),
(237, 225, 'SIMPLOG', 'http://files.spip.org/spip-zone/simplog.gif', '000.004.003', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en]Once the plugin is enabled, administrators can look at all available logs on the site. A maintenance menu entry allows to access the consultation page.\n[fr]Une fois le plugin activ�, les administrateurs ont la possibilit� de consulter tous les journaux disponibles sur le site. Une entr�e du menu Maintenance permet de se rendre sur la page de consultation.\n[sk]Ak je z�¡suvn�½ modul aktivovan�½, administr�¡tori maj�º moÿ¾nosÿ¥ prezrieÿ¥ si vÿ¡etky protokoly, ktor� s�º na str�¡nke dostupn�. Vstup do menu �ºdrÿ¾by umoÿ¾ÿ˿uje navÿ¡t�­viÿ¥ str�¡nku na prezeranie protokolov.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:8:"Luc Tech";s:3:"url";s:0:"";s:4:"mail";s:19:"luc.tech AT free.fr";}i:2;a:3:{s:3:"nom";s:14:"Eric Lupinacci";s:3:"url";s:24:"http://blog.smellup.net/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GLP";s:3:"url";s:0:"";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:23:04', '2012-07-26 13:23:04', 1, 'simplog.zip', 11768, '2012-07-26 13:23:04', '_plugins_/simplog/trunk', 'a:2:{s:14:"paquet-simplog";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:7:"simplog";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '67178fd969fea529da36f95f2f90f9f0'),
(515, 511, 'LESSCSS', 'http://files.spip.org/spip-zone/less-css.png', '000.007.001', '', '[2.1.0;3.0.99]', '2.1,3.0', 'LESS est une extension de CSS ajoutant les variables, les classes, les op�rations, les imbrications au langage. Facilitant ainsi\r\nl''�criture de feuilles de style complexes. [->http://leafo.net/lessphp/]\r\n\r\nCe plugin compile � la vol�e tous les fichiers .less.css ou .less du squelette qui contient #INSERT_HEAD. Vous pouvez aussi forcer la compilation d\'un fichier ou d\'une feuille de style calcul�e � l''aide du filtre less_css.', 'a:1:{i:0;a:3:{s:3:"nom";s:22:"Jean-Baptiste Bourgoin";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:3:"MIT";s:3:"url";s:46:"http://opensource.org/licenses/mit-license.php";}}', '', 'http://www.spip-contrib.net/CSS-facile-avec-LESSpip', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-27 11:00:04', '2012-09-27 11:00:04', 1, 'less-css.zip', 78013, '2012-09-27 11:00:06', '_plugins_/less-css/trunk', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '90b08ec03104652210110aec1aad9dbc'),
(516, 162, 'MENUS', 'http://files.spip.org/spip-zone/menus_1.png', '001.002.004', '0.5.1', '[3.0.0;3.0.*]', '3.0', '<multi>\n[ar]����� �� ������ ���� {{�������}}� ���� ������ �� ����� ������ �� ������� ����������\n	��� ���� ��� �� ����� ������ �� ������ ������ ������ ���� �������� ������ ������ �� ����� �� ��� ����� ������ ��� \n	����� �� ���� ������� ��������� ����� ���������. ����� ��� ���� ��� ����� ��� ����� ����� (����� ���� ��� ���� ���� �� ���� ����� �� ���� ���) ��� ����� ��� ������� ��� �� �� ���� ������� ���������.\n\n	����� �� ���� {{�������}} �� ������ ������ ����� ������ �� ���� ����� ������� �� ������ �����.\n	{{�����!}} �� ����� ��� ������ �������� ���� ����� ���� ��� ������� �� ������ �������. ����� ������ ������� ������ ������ ������ html ������ ���. \n[de]Men�s bequem im Redaktionssystem gestalten.\n[en]When you are not using the plugin {{menus}}, you have to define all the menus in your templates, so that site administrators do not have direct hands on it and when they want to change something in it, they are forced to make a request to the person in charge of the templates.\n\nIn addition, when you want static links (a link to a specific article, to a specific page or to an external site) they should be hard written in the template of the menu.\n\nThe purpose of the plugin {{Menus}} is to allow you to create easily menus using an intuitive interface, directly into the private area.\n\n{{Warning}} This plugin does not deal with the way menus are displayed. It allows their easy creation and to generate the HTML code.\n[fr]Lorsqu''on ne se sert pas du plugin {{Menus}}, on est oblig� de d�finir tous ses menus dans les squelettes,\n	ce qui fait que les administrateurs du site n''ont pas directement la main dessus et que lorsqu''ils veulent y changer quelque chose, ils sont oblig�s\n	d\'en faire la demande � la personne en charge des squelettes. De plus, lorsqu''on veut des liens statiques (un lien vers un article pr�cis,\n	ou vers une page pr�cise, ou vers un site externe) il faut les �crire en dur dans le squelette du menu.\n\n	Le but du plugin {{Menus}} est donc de permettre de facilement �laborer des menus au moyen d\'une interface conviviale, directement dans la partie priv�e.\n	{{Attention !}} Ce plugin ne s''occupe pas de la mani�re dont seront affich�s les menus. Il permet de les cr�er facilement et d\'en g�n�rer le code HTML.\n[it]Crea i tuoi men� in redazione.\n[sk]Ke� sa nepou��va z�suvn� modul{{Menus,}} v�etky �abl�ny musia by� definovan� v�ich menu,\n	�i�e administr�tori str�nky to nemaj� �plne pod kontrolou a�ak chc� nie�o zmeni�, musia sa obr�ti� \n	na �loveka, ktor� je zodpovedn� za��abl�ny. Okrem toho ak chcete prida� statick� odkazy (odkaz na konkr�tny �l�nok\n	alebo na konkr�tnu str�nku, alebo na extern� str�nku), tie musia by� zap�san� do �abl�ny menu.\n\n	Cie�om z�suvn�ho modulu {{Menus}} je umo�ni� v�m �ahko vytv�ra� menu pomocou intuit�vneho rozhrania priamo do s�kromnej z�ny.\n	{{Pozor!}} Tento z�suvn� modul sa nezaober� t�m, ako sa polo�ky menu zobrazia. Umo��uje  �ahk� vytv�ranie menu a�vygenerovanie k�du HTML.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:13:"RastaPopoulos";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:28:"Les D�veloppements Durables";s:3:"url";s:17:"http://www.ldd.fr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:6:"GPL v3";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Plugin-Menus', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.9.10;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:1:"Z";a:1:{s:3:"nom";s:1:"Z";}s:4:"Zpip";a:1:{s:3:"nom";s:4:"Zpip";}}}}', '2012-09-22 22:00:51', '2012-09-22 22:00:51', 1, 'menus_1.zip', 149537, '2012-09-22 22:00:52', '_plugins_/menus/trunk', 'a:2:{s:5:"menus";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:9:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/����-������";}}s:2:"ca";a:0:{}s:2:"de";a:1:{i:0;a:2:{s:3:"nom";s:7:"klaus++";s:4:"lien";s:33:"http://trad.spip.net/auteur/klaus";}}s:2:"en";a:5:{i:0;a:2:{s:3:"nom";s:5:"Suske";s:4:"lien";s:33:"http://trad.spip.net/auteur/suske";}i:1;a:2:{s:3:"nom";s:13:"RastaPopoulos";s:4:"lien";s:0:"";}i:2;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}i:3;a:2:{s:3:"nom";s:4:"Mark";s:4:"lien";s:32:"http://trad.spip.net/auteur/mark";}i:4;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:0:"";}}s:2:"es";a:1:{i:0;a:2:{s:3:"nom";s:3:"tin";s:4:"lien";s:31:"http://trad.spip.net/auteur/tin";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:12:"paquet-menus";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:6:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/����-������";}}s:2:"de";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"it";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'abb863fa2d611be49c8b90241ebe9d1a'),
(239, 227, 'SKELEDITOR', 'http://files.spip.org/spip-zone/skeleditor-dev.png', '002.007.002', '', '[3.0.0-dev;3.0.*]', '3.0', '<multi>\n[de]Im privaten Raum erlaubt Herausgeber die Aktenskelette\n[en]Edit template files in the backoffice\n[es]En espacio privado, no prohibe a redactor los esqueletos de los archivos\n[fr]Editeur de squelettes, css, js, dans l''espace priv�\n[it]Nello spazio riservato, concede a redattore gli scheletri delle lime\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:9:"erational";s:3:"url";s:24:"http://www.erational.org";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:13:"C�dric Morin";s:3:"url";s:22:"http://www.yterium.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:10:"GNU/GPL v3";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/SkelEditor-2-0', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-04-20 12:00:14', '2012-04-20 12:00:14', 1, 'skeleditor-dev.zip', 248996, '2012-04-20 12:00:24', '_plugins_/skeleditor/trunk', 'a:1:{s:10:"skeleditor";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"es";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '3bee4c6b2cbcbd41d60a200c630bae7d'),
(240, 228, 'SKIPLINK', 'http://files.spip.org/spip-zone/skiplink-1.png', '001.000.002', '', '[1.9.0;]', '1.9,2.0,2.1,3.0,3.1', '<multi>\n[fr]Liens facilitant la navigation dans la pageÿ : liens d\'acc�s rapide, retour en haut de page et leurs ancres. Indispensables pour naviguer au clavier et tr�s appr�ciables sur t�l�phone portable.\n[en]Skip Navigation Links\n[ar]ÿ±ÿ˿ÿ§ÿ¨ÿ· ÿªÿ³ÿ⿡ÿ⿿ÿ⿿ ÿ§ÿ⿿ÿªÿ⿠ÿ⿿ÿ⿿ ÿÿŠ ÿ§ÿ⿿ÿµÿÿ­ÿ©: ÿ±ÿ˿ÿ§ÿ¨ÿ· ÿ˿ÿµÿ˿ÿ⿿ ÿ³ÿ±ÿŠÿ¹ ÿ˿ÿ¹ÿ˿ÿ¯ÿ© ÿ§ÿ⿿ÿ⿰ ÿ£ÿ¹ÿ⿿ÿ⿰ ÿ§ÿ⿿ÿµÿÿ­ÿ© ÿ˿ÿ⿦ÿ±ÿ§ÿ³ÿŠÿ⿡ÿ§.ÿ⿡ÿ°ÿ⿡ ÿ§ÿ⿿ÿ±ÿ˿ÿ§ÿ¨ÿ· ÿ¶ÿ±ÿ˿ÿ±ÿŠÿ© ÿ⿿ÿ⿿ÿªÿ⿠ÿ⿿ÿ⿿ ÿ¨ÿ§ÿ³ÿªÿ®ÿ¯ÿ§ÿ⿦ ÿ⿿ÿ˿ÿ­ÿ© ÿ§ÿ⿿ÿ⿦ÿÿ§ÿªÿŠÿ­ ÿ˿ÿ⿦ÿÿŠÿ¯ÿ© ÿ¬ÿ¯ÿ§ÿ⿹ ÿÿŠ ÿ§ÿ⿿ÿ⿡ÿ˿ÿ§ÿªÿ ÿ§ÿ⿿ÿ¬ÿ˿ÿ§ÿ⿿ÿ©.\n</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:14:"romy.tetue.net";s:3:"url";s:21:"http://romy.tetue.net";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:4:"2009";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/skiplink', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-01-10 23:00:10', '2012-01-10 23:00:10', 1, 'skiplink-1.zip', 24059, '2012-01-10 23:00:12', 'tags/skiplink-1', 'a:1:{s:8:"skiplink";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:7:{s:2:"ar";a:0:{}s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"es";a:0:{}s:2:"it";a:0:{}s:2:"ja";a:0:{}s:5:"pt_br";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '4e302dea4441aac22b67c2be171b7f99'),
(241, 229, 'SOCIALTAGS', 'http://files.spip.org/spip-zone/socialtags.png', '001.000.002', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\n[fr]Le plugin Social Tags permet d\'ajouter des ic�´nes de partage de liens vers les sites tels que Digg, Facebook, Delicious...\r\nEn outre, si le plugin Google+1 est actif, il est possible de rajouter le bouton correspondant dans la liste des liens de Social tags. Il propose �galement des noisettes param�trables permettant d\'afficher les badges et boites de type "J''aime" de Facebook.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:4:"phil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Social-tags', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-02 23:00:40', '2012-08-02 23:00:40', 1, 'socialtags.zip', 89863, '2012-08-02 23:00:44', '_plugins_/socialtags', 'a:1:{s:10:"socialtags";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '3d2420af962ecd57e2b3f102ccdcb361'),
(242, 230, 'SPIPDF', 'http://files.spip.org/spip-zone/spipdf.png', '000.002.002', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', 'Ce plugin permet de convertir un article au format PDF par le biais d\'un simple squelette cod� en HTML 4.01.	Il utilise la librairie [HTML2PDF->http://www.html2pdf.fr] ou la librairie [mPDF->http://mpdf.bpm1.com]. Il n�cessite PHP 5.', 'a:2:{i:0;a:3:{s:3:"nom";s:12:"Yves Tannier";s:3:"url";s:0:"";s:4:"mail";s:24:"yvestanSANSPAM@gmail.com";}i:1;a:3:{s:3:"nom";s:14:"grafactory.net";s:3:"url";s:25:"http://www.grafactory.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:0;s:4:"2010";}', 'http://www.spip-contrib.net/spiPDF-v0-2-0-generer-des-contenus-sur-mesure-en-PDF', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-03 18:00:07', '2012-09-03 18:00:07', 1, 'spipdf.zip', 17511, '2012-09-03 18:00:08', '_plugins_/spipdf', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '57117c81080758509461341879831530'),
(243, 231, 'SPIP_PROPRIO', 'http://files.spip.org/spip-zone/spip_proprietaire_s3.png', '001.070.000', '', '[3.0.0-beta;[', '3.0,3.1', '<multi>\n[fr]Ce plugin vous propose la g�n�ration automatique de {{Mentions L�gales}}, {{Conditions d\'Utilisation}} et informations de {{Copyright}} propres �  votre site SPIP.\n\n-* La page de configuration du plugin, accessible depuis l''onglet "Configuration" de l''espace priv� de SPIP, vous permet de saisir diff�rentes informations sur l''�diteur du site, son h�bergeur et son cr�ateur.\n-* <u>Les textes l�gaux se basent par d�faut sur la l�gislation en vigueur en France ({au 1er janvier 2010})</u> et repr�sentent en grande partie le {{minimum l�gal pour tout site web}}. Ils sont modifiables dans un fichier de langue sp�cifique pour vous permettre de les personnaliser.\n-* Un ensemble de mod�les est disponible : \n- des outils pour valoriser votre site SPIP : vCard, cartes de visites, blocs d\'informations ...\n- des outils pour organiser votre site SPIP : deux nouveaux mod�les de {header} et de {pied}, bas�s sur les squelettes de la distribution de SPIP (''inc-header.html'' et ''inc-pied.html''), pr�sentant les informations de copyright et un acc�s �  la page de mentions l�gales. \n\nCertaines ic�´nes du plugin, dans les mod�les publics, proviennent du set "{{[bwpx.icns->http://paularmstrongdesigns.com/portfolio/bwpx-icns/]}}" de {{Paul Armstrong}}, distribu� sous licence {Creative Commons Attribution-Share Alike 3.0} (US).\n\nLes ic�´nes de l''espace priv� proviennent du projet {{[GNOME->http://www.gnome.org/]}}.\n[sk]Tento z�¡suvn�½ modul v�¡m umoÿ¾ÿ˿uje automatick� vytv�¡ranie {{inform�¡ci�­ pr�¡vneho charakteru,}} {{podmienok pouÿ¾�­vania str�¡nky}} aÿ inform�¡ci�­ oÿ {{autorsk�½ch pr�¡vach}} kÿ vaÿ¡ej str�¡nke vÿ SPIPe.\n\n-* Str�¡nka sÿ nastaveniami z�¡suvn�ho modulu, dostupn�¡ cezÿ kartu "Konfigur�¡cia" vÿ s�ºkromnej z�³ne SPIPu, v�¡m umoÿ¾ÿ˿uje zadaÿ¥ r�´zne �ºdaje oÿ vydavateÿ¾ovi str�¡nky, poskytovateÿ¾ovi webhostingu pre str�¡nku aÿ tvorcovi str�¡nky.\n-* <u>Inform�¡cie pr�¡vneho charakteru vÿ predvolen�½ch nastaveniach vych�¡dzaj�º zÿ aktu�¡lne platnej legislat�­vy voÿ Franc�ºzsku ({od 1.ÿ janu�¡raÿ 2010})</u> aÿ spÿºÿ˿aj�º veÿ¾k�º ÿasÿ¥ zÿ {{pr�¡vneho minima pre kaÿ¾d�º internetov�º str�¡nku.}} Daj�º sa upraviÿ¥ vÿ jazykovom s�ºbore pre konkr�tny jazyk, aby ste si ich mohli prisp�´sobiÿ¥.\n-* Kÿ dispoz�­cii m�¡te niekoÿ¾ko ÿ¡abl�³n: \n- n�¡stroje na vylepÿ¡enie str�¡nky vÿ SPIPe: vCard, vizitky, bloky sÿ �ºdajmi atÿ.\n- n�¡stroje na usporiadanie str�¡nky vÿ SPIPe: dve nov� ÿ¡abl�³ny pre {hlaviÿku} aÿ {p�¤tu} vytvoren� podÿ¾a distrib�ºcie SPIPu (''inc-header.html'' aÿ ''inc-pied.html'') sÿ uveden�­m inform�¡ci�­ oÿ autorsk�½ch pr�¡vach aÿ pr�­stupe kÿ str�¡nke sÿ inform�¡ciami pr�¡vneho charakteru.\n\nNiektor� ikony z�¡suvn�ho modulu voÿ verejn�½ch ÿ¡abl�³nach s�º zoÿ sady {{"[bwpx.icns->http://paularmstrongdesigns.com/portfolio/bwpx-icns/]",}} ktor�º vytvoril {{Paul Armstrong}} aÿ ktor�¡ je distribuovan�¡ sÿ licenciou {Creative Commons Attribution-Share Alike 3.0.}\n\nIkony s�ºkromnej z�³ny s�º zÿ projektu {{[GNOME.->http://www.gnome.org/]}}\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"Piero Wbmstr";s:3:"url";s:39:"http://www.spip-contrib.net/PieroWbmstr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2009-2012";}', 'http://www.spip-contrib.net/?article3516', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-25 20:00:08', '2012-08-25 20:00:08', 1, 'spip_proprietaire_s3.zip', 448716, '2012-08-25 20:00:08', '_plugins_/spip_proprietaire/spip_3', 'a:3:{s:19:"paquet-spip_proprio";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:11:"spipproprio";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"merce";s:4:"lien";s:33:"http://trad.spip.net/auteur/merce";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:12:"texteslegaux";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'e12a03e748c9d4c1a48c24e7c5d49bf8'),
(244, 232, 'PIWIK', 'http://files.spip.org/spip-zone/spip_piwik_2_0.png', '000.005.001', '0.1', '[2.0.8;3.0.99]', '2.0,2.1,3.0', '<multi>\n[en]Adds the Piwik statistics script (web traffic analyzer) on the pages of the site.\n[fa]ÿ§ÿÿ²ÿ˿ÿ¯ÿ⿠ ÿ⿠ÿ˿ÿŠÿ³ÿ⿡â⿬ſÿŠ ÿ¢ÿ⿦ÿ§ÿ±ÿŠ ÿ¾ÿŠÿ˿ÿŠÿƿ (ÿªÿ­ÿ⿿ÿŠÿ⿿ÿ¯ÿ± ÿªÿ±ÿ§ÿÿŠÿƿ ÿ˿ÿ¨)(Piwik) ÿ±ÿ˿ÿŠ ÿµÿÿ­ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ ÿ³ÿ§ÿŠÿª \n[fr]Ajoute le script de statistiques Piwik (analyseur de trafic web) sur les pages du site.\n[ru]Ð⿝Ð¾Ð±Ð°Ð²Ð»ÿÐµÿ⿿ ÐºÐ¾Ð´ ÿÐ¸ÿÿ⿿ÐµÐ¼ÿ⿹ Ð²ÐµÐ±-Ð°Ð½Ð°Ð»Ð¸ÿ⿿Ð¸ÐºÐ¸ Piwik Ð½Ð° Ð²ÿÐµ ÿÿ⿿ÿ⿬Ð°Ð½Ð¸ÿ⿠ÿ⿹ ÿÐ°Ð¹ÿ⿿Ð°.\n[sk]Na str�¡nky webu prid�¡ skript so ÿ¡tatistikami Piwik (analyz�¡tor n�¡vÿ¡tevnosti webu).\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:3:"jsb";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"kent1";s:3:"url";s:21:"http://www.kent1.info";s:4:"mail";s:22:"kent1 AT arscenic.info";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article2860', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:6:"[1.1;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-20 04:00:38', '2012-08-20 04:00:38', 1, 'spip_piwik_2_0.zip', 40493, '2012-08-20 04:00:40', '_plugins_/spip_piwik/spip_piwik_2_0', 'a:2:{s:12:"paquet-piwik";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"en";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:5:"piwik";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:7:{s:2:"ca";a:0:{}s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"fa";a:0:{}s:2:"fr";a:0:{}s:5:"fr_tu";a:1:{i:0;a:2:{s:3:"nom";s:8:"beatnick";s:4:"lien";s:36:"http://trad.spip.net/auteur/beatnick";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c43e0f856aa0753b754bcd6a18e863cd'),
(456, 463, 'FABRIQUE', 'http://files.spip.org/spip-zone/fabrique.png', '001.017.000', '', '[3.0.0-rc;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin permet de g�n�rer le code de plugins pour SPIP.\n		Il peut g�rer la cr�ation d\'objets �ditoriaux simples. L''objectif n''est pas de faire cr�er un\n		plugin parfait, mais une base solide, rapide à mettre en place, à �diter ensuite à votre goût.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/?article4134', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:10:"[1.25.11;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:3:{s:10:"skeleditor";a:2:{s:3:"nom";s:10:"skeleditor";s:13:"compatibilite";s:8:"[2.7.1;]";}s:15:"coloration_code";a:2:{s:3:"nom";s:15:"coloration_code";s:13:"compatibilite";s:8:"[0.6.0;]";}s:4:"yaml";a:2:{s:3:"nom";s:4:"yaml";s:13:"compatibilite";s:8:"[1.5.0;]";}}}}', '2012-09-13 15:00:05', '2012-09-13 15:00:05', 1, 'fabrique.zip', 150385, '2012-09-13 15:00:06', '_plugins_/fabrique', 'a:1:{s:8:"fabrique";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'a58c1e6980cda9c6d8a60e5474cd94d5');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(454, 461, 'ELEMENTS', 'http://files.spip.org/spip-zone/elements.png', '001.001.001', '1.0.0', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Permet de d�finir sur les articles et les rubriques des �l�ments qui peuvent être affich�s quelque part dans les squelettes.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:19:"Marcillaud Matthieu";s:3:"url";s:19:"http://magraine.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', '', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:3:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.26.6;[";}s:8:"verifier";a:2:{s:3:"nom";s:8:"verifier";s:13:"compatibilite";s:9:"[0.1.16;[";}s:4:"yaml";a:2:{s:3:"nom";s:4:"yaml";s:13:"compatibilite";s:6:"[1.1;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-12 00:00:02', '2012-09-12 00:00:02', 1, 'elements.zip', 51388, '2012-09-12 00:00:04', '_plugins_/elements', 'a:1:{s:8:"elements";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '06fc1824ee70add5188b84884021970c'),
(455, 462, 'CELEMENTS', 'http://files.spip.org/spip-zone/elements_catalogue.png', '001.000.000', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Propose des �l�ments qui peuvent être utilis�s ou dont vous\n		pouvez vous inspirer !\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:19:"Marcillaud Matthieu";s:3:"url";s:19:"http://magraine.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', '', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:8:"elements";a:2:{s:3:"nom";s:8:"elements";s:13:"compatibilite";s:8:"[1.0.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-11 17:00:22', '2012-09-11 17:00:22', 1, 'elements_catalogue.zip', 16510, '2012-09-11 17:00:22', '_plugins_/elements_catalogue', 'a:1:{s:8:"elements";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'da2075a92d077f4562af12935b305717'),
(247, 235, 'SPIPLISTES', 'http://files.spip.org/spip-zone/spip-listes-spip3.png', '003.000.005', '1.9923', '[3.0.0-alpha2;[', '3.0,3.1', '<multi>\n[ar]\n[de]\n[en]\n[es]\n[fr]SPIP-listes permet la gestion et l''envoi de lettres d\'information (newsletters) au moyen d\'un courriel au format html ou texte. Il est possible d\'envoyer des messages aux abonn�s qui se sont formellement inscrits �  une ou plusieurs lettres d\'information via un formulaire d\'inscription.\n</multi>', '', '', '', '', 'http://www.spip-contrib.net/SPIP-Listes', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"facteur";a:2:{s:3:"nom";s:7:"facteur";s:13:"compatibilite";s:8:"[2.2.1;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-24 10:00:06', '2012-08-24 10:00:06', 1, 'spip-listes-spip3.zip', 688360, '2012-08-24 10:00:12', '_plugins_/spip-listes/trunk', 'a:1:{s:10:"spiplistes";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:6:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"es";a:0:{}s:2:"gl";a:0:{}s:2:"it";a:0:{}s:2:"nl";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '608f3020949f8f916777b7462f174d19'),
(248, 236, 'SPIPCLEAR', 'http://files.spip.org/spip-zone/spipclear_plugin.png', '000.002.001', '', '[2.0.6;3.0.99]', '2.0,2.1,3.0', '<multi>\n[fr]SpipClear est con�§u pour transformer un secteur en blog ou carnet web. Pour cela, il s''inspire de DotClear, un syst�me de gestion de blog d�velopp� en php par Neokraft.net. Il est n�cessaire de cr�er, a minima, les pages sommaire, article-x et rubrique-x pour activer le blog sur le secteur choisi.\n</multi>', 'a:4:{i:1;a:3:{s:3:"nom";s:5:"James";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:3:"Ben";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:14:"Eric Lupinacci";s:3:"url";s:23:"http://blog.smellup.net";s:4:"mail";s:0:"";}i:4;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:4:"2009";}', 'http://www.spip-contrib.net/SpipClear-2-1', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:14:"calendriermini";a:2:{s:3:"nom";s:14:"calendriermini";s:13:"compatibilite";s:8:"[0.5.1;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-27 21:00:42', '2012-07-27 21:00:42', 1, 'spipclear_plugin.zip', 1333012, '2012-07-27 21:00:48', '_plugins_/spipclear', 'a:1:{s:9:"spipclear";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:5:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"es";a:0:{}s:2:"it";a:0:{}s:2:"pt";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd68b4acf0201325344c5c646fc8e48c1'),
(506, 502, 'DICTIONNAIRES', 'http://files.spip.org/spip-zone/dictionnaires_3.png', '000.005.001', '0.4.1', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Permet la cr�ation de dictionnaires regroupant des d�finitions. Les termes d�finis sont automatiquement d�tect�s dans les textes du site et il est alors possible de les ins�rer dans le HTML du texte de mani�re accessible.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:28:"Les D�veloppements Durables";s:3:"url";s:17:"http://www.ldd.fr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.20.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-25 17:00:10', '2012-09-25 17:00:10', 1, 'dictionnaires_3.zip', 65739, '2012-09-25 17:00:12', '_plugins_/dictionnaires/trunk', 'a:2:{s:10:"definition";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"eu";a:0:{}}}s:12:"dictionnaire";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"eu";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '4a07d87fa709c040176f91efb27fc4cd'),
(507, 503, 'EDITION_DIRECTE', 'http://files.spip.org/spip-zone/edition_directe_3.png', '003.002.006', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[de]Erm�glicht es Spip Objekete im Backoffice direkt auf von deren Seite aus zu bearbeiten. Die gew�nschten Objekte m�ssen zuerst via cfg aktiviert werden\n[en]Permits direct editing of the spip objects from their page. By default only articles are in direct mode, you can ad other objects in the plugins configuration panel\n[es]Permite editar directamente los objetos spip en el espacio privado. Por defecto s�lo los art�culos se pueden editar directamente, en el panel de configuraci�n del plugin se pueden a�adir otros objetos spip\n[fr]Editer directement les objets spip depuis leur page dans l�espace priv�. Les objets � �diter directement doivent �tre activ�s dans Configuration\n[sk]Priama �prava objektov spipu z�ich str�nky v�s�kromnej z�ne. Objekty na priame upravovanie musia by� aktivovan� v�konfigur�cii\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Rainer M�ller";s:3:"url";s:23:"http://www.mychacra.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Edition-directe-3', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.14.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:6:"medias";a:2:{s:3:"nom";s:6:"medias";s:13:"compatibilite";s:9:"[2.7.27;[";}}}}', '2012-09-20 19:00:07', '2012-09-20 19:00:07', 1, 'edition_directe_3.zip', 50032, '2012-09-20 19:00:08', '_plugins_/edition_directe/branches/3.0', 'a:2:{s:4:"edir";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:6:{s:2:"de";a:1:{i:0;a:2:{s:3:"nom";s:14:"Rainer M�ller";s:4:"lien";s:41:"http://trad.spip.net/auteur/rainer-muller";}}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:14:"Rainer M�ller";s:4:"lien";s:41:"http://trad.spip.net/auteur/rainer-muller";}}s:2:"es";a:1:{i:0;a:2:{s:3:"nom";s:14:"Rainer M�ller";s:4:"lien";s:41:"http://trad.spip.net/auteur/rainer-muller";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:22:"paquet-edition_directe";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"es";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '9b1de484aeacfabde7770a27b666aab6'),
(251, 239, 'SPIPMOTION', 'http://files.spip.org/spip-zone/spipmotion.png', '001.001.005', '1.1.4', '[3.0.0;3.0.99]', '3.0', '<multi>\n[en]Create a Youtube or Dailymotion like website...\n[fr]Faire un site �  la Youtube ou Dailymotion ...\n[sk]Vytvorte str�¡nku na Youtube alebo Dailymotion.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"kent1";s:3:"url";s:21:"http://www.kent1.info";s:4:"mail";s:22:"kent1 AT arscenic.info";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.mediaspip.net/technical-documentation/plugins-used-by-mediaspip/spipmotion/', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:4:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.25.7;[";}s:6:"medias";a:2:{s:3:"nom";s:6:"medias";s:13:"compatibilite";s:9:"[2.7.30;[";}s:8:"jqueryui";a:2:{s:3:"nom";s:8:"jqueryui";s:13:"compatibilite";s:9:"[1.8.20;[";}s:4:"facd";a:2:{s:3:"nom";s:4:"facd";s:13:"compatibilite";s:8:"[0.1.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:4:{s:6:"getid3";a:2:{s:3:"nom";s:6:"getid3";s:13:"compatibilite";s:8:"[1.1.3;[";}s:7:"podcast";a:1:{s:3:"nom";s:7:"podcast";}s:7:"licence";a:1:{s:3:"nom";s:7:"licence";}s:16:"fonctions_images";a:1:{s:3:"nom";s:16:"fonctions_images";}}}}', '2012-08-16 12:00:15', '2012-08-16 12:00:15', 1, 'spipmotion.zip', 99587, '2012-08-16 12:00:22', '_plugins_/spipmotion/trunk', 'a:2:{s:17:"paquet-spipmotion";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:10:"spipmotion";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'f6e0984768561e944721dd391173d5ff'),
(252, 240, 'SPIPSERVICE', 'http://files.spip.org/spip-zone/spipservice_3.png', '002.000.000', '10', '[3.0.0 ;3.0.*]', '3.0', '', 'a:1:{i:1;a:3:{s:3:"nom";s:13:"Studio Lambda";s:3:"url";s:28:"http://www.studio-lambda.com";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-05-14 19:00:02', '2012-05-14 19:00:02', 1, 'spipservice_3.zip', 87301, '2012-05-14 19:00:02', '_plugins_/spipservice/trunk', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '485b9a3edb692f44c60316ea4bfe63d1'),
(253, 241, 'SPIP_400', 'http://files.spip.org/spip-zone/spip_400.png', '000.021', '', '[2.0.0;]', '2.0,2.1,3.0,3.1', '{{Gestion pouss�e des erreurs HTTP (401, 404) pour SPIP}}\n\nCe plugin tente de compl�ter la distribution de SPIP en proposant des mod�les de pages d\'erreur HTTP ({codes 401 et 404}) avec un texte explicatif et la possibilit� pour l''internaute de transmettre un "ticket de bug" au webmestre du site.\n\nIl propose notamment : \n- un message sur les pages publiques pour que l''internaute ne se perde pas, \n- l''envoi d\'un mail au webmestre avec une info compl�te sur l''erreur en question ({utilisateur SPIP, URL, REFERER, backtrace PHP, etc}), \n- l''�criture de messages de LOG dans un fichier sp�cifique ...\n\nUne page de configuration est propos�e en option si vous utilisez le plugin [CFG : moteur de configuration->http://www.spip-contrib.net/?rubrique575].', 'a:1:{i:0;a:3:{s:3:"nom";s:12:"Piero Wbmstr";s:3:"url";s:39:"http://www.spip-contrib.net/PieroWbmstr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{i:0;a:4:{s:3:"nom";s:1:"z";s:2:"id";s:1:"z";s:7:"version";s:8:"[1.0.0;]";s:13:"compatibilite";s:8:"[1.0.0;]";}i:1;a:4:{s:3:"nom";s:3:"cfg";s:2:"id";s:3:"cfg";s:7:"version";s:6:"[1.0;]";s:13:"compatibilite";s:6:"[1.0;]";}}}}', '2012-05-04 20:00:12', '2012-05-04 20:00:12', 1, 'spip_400.zip', 21680, '2012-05-04 20:00:20', '_plugins_/spip_400/spip_2', 'a:1:{s:8:"spip_400";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '360622227eaa18bd93d6f4eb5d5cd941'),
(254, 241, 'SPIP_400', 'http://files.spip.org/spip-zone/spip_400_s3.png', '000.022.002', '', '[3.0.0-beta;[', '3.0,3.1', '<multi>\n[en]This plugin adds models of error pages ({HTTP 401 and 404 code}) to the SPIP distribution with explanatory text and the ability for the user to transmit a "bug report" to the webmaster.\n\nIt proposes to:\n- * show a message on the public pages to avoid to loose the user;\n- * sends an email to the webmaster with a comprehensive info on the error ({SPIP user, URL, REFERER, PHP backtrace, etc.});\n- * writes messages in a specific log file;\n[fr]Ce plugin compl�te la distribution de SPIP en proposant des mod�les de pages d\'erreur HTTP ({codes 401 et 404}) avec un texte explicatif et la possibilit� pour l''internaute de transmettre un "ticket de bug" au webmestre du site.\n\nIl propose notamment : \n-* un message sur les pages publiques pour que l''internaute ne se perde pas;\n-* l''envoi d\'un mail au webmestre avec une info compl�te sur l''erreur en question ({utilisateur SPIP, URL, REFERER, backtrace PHP, etc}); \n-* l''�criture de messages de LOG dans un fichier sp�cifique;\n[sk]Tento z�¡suvn�½ modul dopÿºÿ˿a distrib�ºciu SPIPu t�½m, ÿ¾e pon�ºka ÿ¡abl�³ny chybov�½ch str�¡nok HTTP ({k�³dy 401 aÿ 404}) sÿ vysvetlivkou aÿ moÿ¾nosÿ¥ou pre pouÿ¾�­vateÿ¾a poslaÿ¥ webmasterovi str�¡nky "l�­stok sÿ chybou".\n\nPon�ºka najm�¤:\n-* spr�¡vu na verejne pr�­stupn�½ch str�¡nkach, aby sa pouÿ¾�­vateÿ¾ nestratil,\n-* poslanie e-mailu webmasterovi sÿ kompletn�½mi inform�¡ciami oÿ danej chybe ({pouÿ¾�­vateÿ¾ SPIPu, URL, backtrace PHP, atÿ.}),\n-* z�¡pis spr�¡v do ÿ¡peci�¡lneho s�ºboru LOG.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"Piero Wbmstr";s:3:"url";s:39:"http://www.spip-contrib.net/PieroWbmstr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2011-2012";}', 'http://www.spip-contrib.net/?article3884', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:1:"z";a:2:{s:3:"nom";s:1:"z";s:13:"compatibilite";s:8:"[1.0.0;[";}s:4:"Zpip";a:2:{s:3:"nom";s:4:"Zpip";s:13:"compatibilite";s:12:"[2.0.5-dev;[";}}}}', '2012-07-26 13:24:05', '2012-07-26 13:24:05', 1, 'spip_400_s3.zip', 28835, '2012-07-26 13:24:06', '_plugins_/spip_400/spip_3', 'a:2:{s:15:"paquet-spip_400";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:7:"spip400";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '0d952fecb47ac2dbd503568a2233df9c'),
(255, 242, 'SPLICKR', 'http://files.spip.org/spip-zone/splickrbox.png', '000.004.005', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', 'Noisette pour afficher les dernieres photos �  la Flickr (le "badge"), tout �§a en javascript via <code>#INSERT_HEAD</code> et JQuery.\r\n\r\n-* On peut l''utiliser en modele avec <code><splickrbox></code> en lui passant en option un parametre d\'id pour limiter la boucle document,\r\n-* On peut l''utiliser dans les squelettes avec la balise <code>#MODELE{splickrbox}</code>\r\n-* On peut l''utiliser avec diff�rent param�tres (qu''on peut aussi combiner):\r\n-** <code><splickrbox|right></code> et <code><splickrbox|left></code> pour les alignements\r\n-** <code><splickrbox|taille=24></code> permet de sp�cifier le nombre de vignettes �  afficher. Ce nombre devrait �ªtre un multiple du nombre de colonnes.\r\n-** <code><splickrbox|colonnes=10></code> permet de sp�cifier le nombre de colonnes �  afficher.\r\n-** <code><splickrbox|masque=carre-100.png></code> permet de d�finir la taille des vignettes (le masque correspond �  la grande vignette).\r\n-** <code><splickrbox|tri=date></code> permet de sp�cifier le classement (date, hasard...).\r\n-** <code><splickrbox|senstri=1></code> permet d\'inverser le sens de classement choisi ci-dessus.', 'a:2:{i:0;a:3:{s:3:"nom";s:4:"BoOz";s:3:"url";s:0:"";s:4:"mail";s:13:"booz@rezo.net";}i:1;a:3:{s:3:"nom";s:25:"Pierre Andrews (mortimer)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://trac.rezo.net/trac/spip-zone/wiki/SplickrBox', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-04-15 14:00:02', '2012-04-15 14:00:02', 1, 'splickrbox.zip', 23226, '2012-04-15 14:00:02', '_plugins_/splickrbox', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '81cd0a0ba95a554f757fe0775c16b9c3'),
(256, 243, 'SQUELETTESMOTS', 'http://files.spip.org/spip-zone/squelettes_par_mots_cle_3.png', '003.001.000', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en]This plugin provides selection of template using keywords.\r\n\r\n	  You can create rules on the configuration page to link:\r\n-* an element type,\r\n-* a group of keyword specifying the template\r\n-* a template base name.\r\n	  \r\n	  Then, the authors only have to associate a keyword to their article (for example) to set its layout.\n[fr]Ce plugin permet de choisir le squelette en fonction d\'un mot clef.\r\n	  \r\n      La page de configuration permet de cr�er des r�gles liant:\r\n-* un type d''�l�ment, \r\n-* un groupe de mot clef sp�cifiant le squelette \r\n-* un fond.\r\n\r\n	  Ainsi, les auteurs n''ont plus qu''�  associer le bon mot clef �  leur article (par exemple) pour s�lectionner sa mise en page.\n[it]Questo plugin permette di scegliere un modello mediante una parola chiave.\r\n\r\n	La pagina di configurazione permette di creare regole per legare:\r\n-* un tipo di elemento,\r\n-* un gruppo di parole chiave per scegliere il modello,\r\n-* un sfondo,\r\n\r\n	Cos�¬, gli autori devono solamente scegliere la parola chiave giusta per cambiare il modello de la pagina che visualizza l''elemento (l''articolo per esempio)\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:25:"Pierre Andrews (Mortimer)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:14:"Florent Cavard";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:40:"d\'apr�s un code propos� par D�esse A.";s:3:"url";s:0:"";}}', '', '', 'http://www.spip-contrib.net/SPMC-Squelette-par-mot-cle-V2-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-27 12:00:05', '2012-06-27 12:00:05', 1, 'squelettes_par_mots_cle_3.zip', 18059, '2012-06-27 12:00:06', '_plugins_/squelettes_par_mots_cle/trunk', 'a:1:{s:14:"squelettesmots";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"it";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'b4913913cf211c2b5c831c887565a726'),
(257, 244, 'SQUIRREL_CHIMP', 'http://files.spip.org/spip-zone/squirrels_love_chimps.png', '002.000.003', '', '[2.0.15;3.0.*]', '2.0,2.1,3.0', '<multi>\n[fr]Ce plugin constitue le coeur d\'un set de plugins qui on pour but de d\'int�gerer connecter SPIP  avec [MailChimp->http://mailchimp.com/]\n	\n		Il met �  disposition l''api de Mailchimp ainsi qu''un framework permettant d\'ajouter facilement d\'autre plugins\n		\n		Existent pour le moment les plugins suivants\n		-* [Squirrels Love Chimps Lists->http://files.spip.org/spip-zone/squirrels_love_chimps_lists.zip](squirrel_chimp_lists)\n		-* [Squirrels Love Chimps Lists us->http://files.spip.org/spip-zone/squirrels_love_chimps_lists_plus.zip](squirrel_chimp_lists_plus)	\n		-* [Squirrels Love Chimps Campagnes->http://files.spip.org/spip-zone/squirrels_love_chimps_campaigns.zip](squirrel_chimp_campaigns)\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:9:"My Chacra";s:3:"url";s:24:"http://www.mychacra.net/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"Spade";s:3:"url";s:46:"http://www.spade.be/labs/squirrels-love-chimps";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"MIT";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Squirrels-Love-Chimps', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-06 11:00:23', '2012-08-06 11:00:23', 1, 'squirrels_love_chimps.zip', 301726, '2012-08-06 11:00:26', '_plugins_/squirrels_love_chimps/branches/2', 'a:2:{s:21:"paquet-squirrel_chimp";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:1:{s:2:"fr";a:0:{}}}s:13:"squirrelchimp";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '89347de5b607da87b25caa3cf0c4383a'),
(258, 245, 'SQUIRREL_CHIMP_LISTS', 'http://files.spip.org/spip-zone/squirrels_love_chimps_lists.png', '002.000.000', '', '[2.0.15;3.0.*]', '2.0,2.1,3.0', '<multi>\n[fr]Gestion de mailing listes de [Mailchimp->http://mailchimp.com/] inspir�e des fonctionnalit�s du plugin Wordpress [Autochimp->http://wordpress.org/extend/plugins/autochimp/] avec quelques "emprunts" de code du plugin SPIP "MailChimp de [Ben->http://www.nursit.net]\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:9:"My Chacra";s:3:"url";s:24:"http://www.mychacra.net/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"Spade";s:3:"url";s:46:"http://www.spade.be/labs/squirrels-love-chimps";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"MIT";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Squirrels-Love-Chimps', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:14:"squirrel_chimp";a:2:{s:3:"nom";s:14:"squirrel_chimp";s:13:"compatibilite";s:8:"[2.0.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-06 11:00:46', '2012-08-06 11:00:46', 1, 'squirrels_love_chimps_lists.zip', 112031, '2012-08-06 11:00:56', '_plugins_/squirrels_love_chimps_lists/branches/2', 'a:2:{s:27:"paquet-squirrel_chimp_lists";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:1:{s:2:"fr";a:0:{}}}s:3:"scl";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd3238f94b4a605829a14719c7b99c356'),
(259, 246, 'SCLP', 'http://files.spip.org/spip-zone/squirrels_love_chimps_lists_plus.png', '001.000.003', '0.2.14', '[2.0.15;3.0.*]', '2.0,2.1,3.0', '<multi>\n[fr]Gestion avanc�s de mailing listes de [Mailchimp->http://mailchimp.com/] \n		\n		Synchronistation entre listes Spip et liste mailchimps\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:9:"My Chacra";s:3:"url";s:24:"http://www.mychacra.net/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"Spade";s:3:"url";s:46:"http://www.spade.be/labs/squirrels-love-chimps";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"MIT";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Squirrels-Love-Chimps', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:14:"squirrel_chimp";a:2:{s:3:"nom";s:14:"squirrel_chimp";s:13:"compatibilite";s:8:"[2.0.0;[";}s:20:"squirrel_chimp_lists";a:2:{s:3:"nom";s:20:"squirrel_chimp_lists";s:13:"compatibilite";s:8:"[2.0.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-06 11:00:56', '2012-08-06 11:00:56', 1, 'squirrels_love_chimps_lists_plus.zip', 224846, '2012-08-06 11:00:58', '_plugins_/squirrels_love_chimps_lists_plus/branches/1', 'a:2:{s:11:"paquet-sclp";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:1:{s:2:"fr";a:0:{}}}s:4:"sclp";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'eaa0c9500088050ff55dbd968eb99fe7'),
(260, 247, 'SQUIRREL_CHIMP_CAMPAIGNS', 'http://files.spip.org/spip-zone/squirrels_love_chimps_campaigns.png', '002.000.000', '', '[2.0.15;3.0.*]', '2.0,2.1,3.0', '<multi>\n[fr]Gestion des campagnes de [Mailchimp->http://mailchimp.com/] inspir�e  des fonctionnalit�s du plugin Wordpress [Autochimp->http://wordpress.org/extend/plugins/autochimp/]\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:9:"My Chacra";s:3:"url";s:24:"http://www.mychacra.net/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"Spade";s:3:"url";s:46:"http://www.spade.be/labs/squirrels-love-chimps";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"MIT";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Squirrels-Love-Chimps', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:3:{s:14:"squirrel_chimp";a:2:{s:3:"nom";s:14:"squirrel_chimp";s:13:"compatibilite";s:8:"[2.0.0;[";}s:20:"squirrel_chimp_lists";a:2:{s:3:"nom";s:20:"squirrel_chimp_lists";s:13:"compatibilite";s:8:"[2.0.0;[";}s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:10:"[1.25.13;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-06 11:00:38', '2012-08-06 11:00:38', 1, 'squirrels_love_chimps_campaigns.zip', 190980, '2012-08-06 11:00:40', '_plugins_/squirrels_love_chimps_campaigns/branches/2', 'a:2:{s:31:"paquet-squirrel_chimp_campaigns";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:1:{s:2:"fr";a:0:{}}}s:3:"scc";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '2385fb47234996f82bedb49da728a076'),
(261, 248, 'SVPSTATS', 'http://files.spip.org/spip-zone/svp_stats.png', '000.001.003', '0.1', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[en]This plugin is an optional module of SVP. \n_ It allows you to acquire, update and return the usage statistics of SPIP plugins on the Internet.\nThose statistics come from the <a href="http://stats.spip.org">stats.spip.org</a> Web site.\n[fr]Ce plugin est un module optionnel de SVP. \n_ Il permet d\'acqu�rir, de mettre �  jour et de restituer les statistiques d\'utilisation des plugins SPIP sur le net. \nCes statistiques sont issues du site <a href="http://stats.spip.org">stats.spip.org</a>.\n[sk]Tento z�¡suvn�½ modul je nepovinn�½m modulom SVP.\n _ Umoÿ¾ÿ˿uje v�¡m zistiÿ¥, aktualizovaÿ¥ aÿ vyp�­saÿ¥ ÿ¡tatistiky vyuÿ¾�­vania z�¡suvn�½ch modulov SPIPu na internete.\n Tieto ÿ¡tatistiky poch�¡dzaj�º zoÿ str�¡nky <a href="http://stats.spip.org">stats.spip.org.</a>\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Eric Lupinacci";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:3:"svp";a:2:{s:3:"nom";s:3:"svp";s:13:"compatibilite";s:9:"[0.72.1;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:25:29', '2012-07-26 13:25:29', 1, 'svp_stats.zip', 24957, '2012-07-26 13:25:30', '_plugins_/svp_stats/trunk', 'a:2:{s:15:"paquet-svpstats";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:8:"svpstats";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '382113246db8b9f09eb502c959583f9c'),
(262, 249, 'TABLEMATIERES', '', '002.000.002', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n			[fr]Introduit une ancre translitter�e pour chaque intertitre du champ #TEXTE des ARTICLES,\r\n	ainsi qu''une balise #TABLE_MATIERES (facultative) associ�e �  placer, bien s�»r, dans une boucle ARTICLES.\r\n			[en]Introduce an anchor for each heading of a #TEXTE field of the articles, and an \r\n	associated optional tag #TABLE_MATIERES to put in the ARTICLES loops.\r\n		</multi>', 'a:3:{i:0;a:3:{s:3:"nom";s:8:"marcimat";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"James";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Table-des-Matieres', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:25:35', '2012-07-26 13:25:35', 1, 'table_matieres.zip', 15576, '2012-07-26 13:25:36', '_plugins_/table_matieres/trunk', 'a:1:{s:3:"tdm";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c18ebc56b9847cc2930ff2e2c01206ca'),
(263, 250, 'TABLESORTER', 'http://files.spip.org/spip-zone/tablesorter.png', '001.003.001', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', '<multi>\n[en]This plugin allows you to sort the tables having the CSS class "spip" by clicking on a column header (HTML table  must have the tags thead and tbody). See all sorting options on the [->http://tablesorter.com] Web site.\n[fr]Ce plugin permet de trier les tableaux portant la class CSS "spip" en cliquant simplement sur l''ent�ªte d\'une colonne (le tableau HTML doit donc poss�der les tags thead et tbody). Voir en ligne toutes les options de tri, sur le site de [->http://tablesorter.com].\n[sk]Tento z�¡suvn�½ modul v�¡m umoÿ¾ÿ˿uje triediÿ¥ tabuÿ¾ky sÿ CSS triedou "spip" kliknut�­m na z�¡hlavie stÿºpca (vÿ HTML tabuÿ¾ke musia byÿ¥ tagy thead aÿ tbody). Vÿ¡etky moÿ¾nosti triedenia si m�´ÿ¾ete prezrieÿ¥ na str�¡nke [http://tablesorter.com.->http://tablesorter.com]\n</multi>', 'a:5:{i:1;a:3:{s:3:"nom";s:13:"Chistian Bach";s:3:"url";s:26:"http://lovepeacenukes.com/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:3:"cym";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:4;a:3:{s:3:"nom";s:14:"Eric Lupinacci";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:5;a:3:{s:3:"nom";s:4:"BoOz";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Tablesorter-pour-SPIP', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-12 14:00:21', '2012-08-12 14:00:21', 1, 'tablesorter.zip', 25024, '2012-08-12 14:00:22', '_plugins_/tablesorter', 'a:1:{s:18:"paquet-tablesorter";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '4a276decd5efe31616f7222d1c0cb23b'),
(264, 251, 'TAGSPHERE', 'http://files.spip.org/spip-zone/tagsphere.png', '000.004.000', '', '[1.9.2;3.0.99]', '1.9,2.0,2.1,3.0', 'Affiche les mots cl� du site sous la forme d\'un nuage 3D', 'a:1:{i:0;a:3:{s:3:"nom";s:18:"christophe vallois";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Plugin-TagSphere', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-05 14:00:17', '2012-08-05 14:00:17', 1, 'tagsphere.zip', 15073, '2012-08-05 14:00:18', '_plugins_/tagsphere', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'f6346b08daf4b593eaeb7787e4e3603c'),
(265, 252, 'TB', 'http://files.spip.org/spip-zone/testbuilder.png', '000.003.002', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un plugin pour aider les d�veloppeurs de plugin �  �crire plus vite leurs tests. Et les encourager �  en �crire plus souvent !\r\n\r\nCe plugin est un outil de d�veloppement. Il a tout son int�r�ªt install� sur votre machine de d�veloppement, mais il est tr�s vivement d�conseill� de l''installer sur un serveur en ligne car il manipule les scripts PHP dans l''arborescence de votre site et permet de lancer l''ex�cution de code PHP arbitraire.', 'a:1:{i:0;a:3:{s:3:"nom";s:6:"Cedric";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/TestBuilder', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:2:{s:15:"[2.0.10;2.1.99]";a:1:{i:0;a:4:{s:2:"id";s:10:"spip_bonux";s:3:"nom";s:10:"spip_bonux";s:7:"version";s:8:"[1.9.0;]";s:13:"compatibilite";s:8:"[1.9.0;]";}}i:0;a:0:{}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-04-04 15:00:14', '2012-04-04 15:00:14', 1, 'testbuilder.zip', 122929, '2012-04-04 15:00:18', '_plugins_/testbuilder', 'a:1:{s:2:"tb";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '7ed32759ac0b8760d2a83b5e055f94fb'),
(451, 458, 'DEV', 'http://files.spip.org/spip-zone/dev.png', '000.002.001', '', '[3.0.0;3.1.*]', '3.0,3.1', '<multi>\n[ar]أدٿات اٿتطٿٿر\n[en]Development tools\n[fa]ابزارٿاٿ تٿسعٿ\n[fr]Outils de d�veloppement\n[it]Strumenti di sviluppo\n[ru]Сѿедсѿва ѿазѿабоѿки\n[sk]Nástroje na vývoj\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-18 20:00:02', '2012-09-18 20:00:02', 1, 'dev.zip', 27139, '2012-09-18 20:00:02', '_core_/plugins/dev', 'a:2:{s:7:"charter";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/جٿرج-ٿٿدٿفت";}}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:10:"paquet-dev";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:7:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/جٿرج-ٿٿدٿفت";}}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"it";a:1:{i:0;a:2:{s:3:"nom";s:6:"phante";s:4:"lien";s:34:"http://trad.spip.net/auteur/phante";}}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:18:"Serge Markitanenko";s:4:"lien";s:46:"http://trad.spip.net/auteur/serge-markitanenko";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '0ea132cd276c09351ba2bcdc985a059a'),
(267, 254, 'TITRES_TYPOGRAPHIES', 'http://files.spip.org/spip-zone/titres_typographies.jpg', '001.000.001', '', '[3.0;3.0.99]', '3.0', '<multi>\n[fr]Permet d\'utiliser les raccourcis typographiques de SPIP dans les champs TITRE et apparent�s.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:17:"Ma�¯eul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:10:"Wikip�dia";s:3:"url";s:68:"http://fr.wikipedia.org/wiki/Fichier:Garamond_type_fi-ligature_2.jpg";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://contrib.spip.net/Titres-typographies', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-09 03:00:06', '2012-08-09 03:00:06', 1, 'titres_typographies.zip', 22354, '2012-08-09 03:00:06', '_plugins_/titres_typographies/trunk', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '389679a31698ee56012a581dbc86b01b'),
(450, 457, 'PB_COULEUR_RUBRIQUE', 'http://files.spip.org/spip-zone/couleur_rubrique2.png', '002.002.001', '', '[3.0.0;3.*]', '', '<multi>\n[fr]Ce plugin permet de choisir une couleur pour chaque rubrique du site. Une fois activ�, il ne demande aucune configuration suppl�mentaire. Il ajoute simplement un pav� dans les pages des rubriques permettant de choisir une couleur. L''option n''est accessible qu''aux administrateurs.\n	\n		Pour afficher la couleur d\'une rubrique dans un squelette, il suffit d\'utiliser le code : <code>[#(#ID_RUBRIQUE|couleur_rubrique)]</code>.\n\n		Pour afficher la couleur d\'un secteur dans un squelette, il suffit d\'utiliser le code : <code>[#(#ID_RUBRIQUE|couleur_secteur)]</code>.\n\n		Il faut installer en plus le plugin Palette pour s�lectionner visuellement la couleur sur une roue chromatique, sinon il faut utiliser le code hexad�cimal correspondant à la couleur, du type : #C5E41C\n		\n		Une page de configuration permet d\'interdire le changement de couleur, ou de ne permettre les couleurs que sur les secteurs.\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:5:"ARNO*";s:3:"url";s:0:"";s:4:"mail";s:16:"arno AT rezo.net";}i:2;a:3:{s:3:"nom";s:34:"sur la base du travail d\'erational";s:3:"url";s:24:"http://www.erational.org";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:30:"adapt� à SPIP3 par Chankalan";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Couleur-de-Rubrique', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:7:"palette";a:2:{s:3:"nom";s:7:"palette";s:13:"compatibilite";s:8:"[3.0.0;[";}}}}', '2012-09-07 17:00:02', '2012-09-07 17:00:02', 1, 'couleur_rubrique2.zip', 15281, '2012-09-07 17:00:04', '_plugins_/couleur_rubrique/trunk', 'a:1:{s:19:"pb_couleur_rubrique";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '5185117bf0b487435cd2dd418771a05a'),
(508, 504, 'FIL_ARIANE', 'http://files.spip.org/spip-zone/fil_ariane.png', '000.001.006', '1.5', '[2.1.0;3.0.*]', '2.1,3.0', '', 'a:2:{i:1;a:3:{s:3:"nom";s:12:"Cyril MARION";s:3:"url";s:17:"http://www.cym.fr";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:19:"http://magraine.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', 'http://contrib.spip.net/Plugin-Fil-d-Ariane?var_mode=preview', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-24 20:00:02', '2012-09-24 20:00:02', 1, 'fil_ariane.zip', 42254, '2012-09-24 20:00:02', '_plugins_/fil_ariane/trunk', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'b1fd33abd6c761e16e5b70e0161a0e89'),
(449, 456, 'CONTACT', 'http://files.spip.org/spip-zone/contact.png', '000.010.003', '0.2.0', '[3.0.0-dev;3.1.0[', '3.0', '<multi>\n[ar]ٿذا اٿتٿدٿد ٿٿفر شٿٿ ٿٿ أشٿاٿ اٿاتصاٿ ٿع خٿارات ٿتعددة\n[en]This plugin allows you to compose a contact form (name, address, phone number,...) and to choose the recipient list to receive collected informations by email.\n[fr]Ce plugin permet de composer librement un formulaire de contact (nom, pr�nom, adresse, t�l�phone,...) et de choisir la liste des destinataires qui recevront par mail les informations collect�es.\n[sk]Tento zásuvný modul vám umožſuje vytvoriť vlastný kontaktný formulár (meno, priezvisko, adresa, telefón, atď) a vybrať príjemcov, ktorí dostanú zisten� údaje e-mailom.\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:13:"Pierre Fiches";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:13:"RastaPopoulos";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:21:"Superyms (traduction)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:6:"GPL V3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Formulaire-de-contact-avance', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:10:"organiseur";a:2:{s:3:"nom";s:10:"organiseur";s:13:"compatibilite";s:8:"[0.6.1;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:7:"facteur";a:1:{s:3:"nom";s:7:"facteur";}s:15:"inserer_modeles";a:2:{s:3:"nom";s:15:"inserer_modeles";s:13:"compatibilite";s:8:"[0.4.3;[";}}}}', '2012-09-14 16:00:11', '2012-09-14 16:00:11', 1, 'contact.zip', 67048, '2012-09-14 16:00:14', '_plugins_/contact/trunk', 'a:3:{s:7:"contact";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:10:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/جٿرج-ٿٿدٿفت";}}s:2:"ca";a:0:{}s:2:"de";a:3:{i:0;a:2:{s:3:"nom";s:6:"Martin";s:4:"lien";s:34:"http://trad.spip.net/auteur/martin";}i:1;a:2:{s:3:"nom";s:7:"klaus++";s:4:"lien";s:33:"http://trad.spip.net/auteur/klaus";}i:2;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}s:2:"en";a:4:{i:0;a:2:{s:3:"nom";s:5:"Paolo";s:4:"lien";s:33:"http://trad.spip.net/auteur/paolo";}i:1;a:2:{s:3:"nom";s:4:"Mark";s:4:"lien";s:32:"http://trad.spip.net/auteur/mark";}i:2;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}i:3;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/جٿرج-ٿٿدٿفت";}}s:2:"es";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:5:"fr_tu";a:1:{i:0;a:2:{s:3:"nom";s:8:"beatnick";s:4:"lien";s:36:"http://trad.spip.net/auteur/beatnick";}}s:5:"pt_br";a:1:{i:0;a:2:{s:3:"nom";s:13:"Ricardo Porto";s:4:"lien";s:41:"http://trad.spip.net/auteur/ricardo-porto";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:14:"paquet-contact";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"ar";a:0:{}s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:6:"public";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '3a10f0d7fc068bd8d29d077d1cec59d5'),
(509, 505, 'FORMIDABLE', 'http://files.spip.org/spip-zone/formidable_1_0.png', '001.003.003', '0.5.1', '[3.0.0-dev;3.0.99]', '3.0', '<multi>\n[fr]Cr�ation de formulaires avec une interface graphique et configuration des traitements associ�s (envoyer par courriel, enregistrer les r�ponses, etc).\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:13:"RastaPopoulos";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:28:"Les D�veloppements Durables";s:3:"url";s:17:"http://www.ldd.fr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Formidable-le-generateur-de', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:1:{i:0;a:5:{s:10:"spip_bonux";a:2:{s:3:"nom";s:10:"spip_bonux";s:13:"compatibilite";s:8:"[1.9.3;[";}s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.10.1;[";}s:8:"verifier";a:2:{s:3:"nom";s:8:"verifier";s:13:"compatibilite";s:6:"[0.1;[";}s:4:"yaml";a:2:{s:3:"nom";s:4:"yaml";s:13:"compatibilite";s:6:"[1.1;[";}s:7:"facteur";a:2:{s:3:"nom";s:7:"facteur";s:13:"compatibilite";s:8:"[1.5.3;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-20 15:00:04', '2012-09-20 15:00:04', 1, 'formidable_1_0.zip', 143123, '2012-09-20 15:00:06', '_plugins_/formidable/trunk', 'a:3:{s:10:"formidable";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"de";a:0:{}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:10:"formulaire";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:3:{s:2:"de";a:0:{}s:2:"it";a:0:{}s:2:"sk";a:0:{}}}s:19:"formulaires_reponse";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '24d71ca656bd68ee4e13bf93b81d1fe5'),
(510, 506, 'FORMULAIREUPLOAD', 'http://files.spip.org/spip-zone/formulaire_upload_3_0.png', '001.000.003', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Upload de fichiers depuis l''espace public gr�ce � la balise #FORMULAIRE_UPLOAD qui prend le contexte de boucle (articles, auteurs, ...) pour y ajouter les fichiers upload�s \n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:19:"http://zzz.rezo.net";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:3:"b_b";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:9:"erational";s:3:"url";s:24:"http://www.erational.org";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Formulaire-upload,952', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-21 11:00:02', '2012-09-21 11:00:02', 1, 'formulaire_upload_3_0.zip', 18722, '2012-09-21 11:00:02', '_plugins_/formulaire_upload/trunk', 'a:1:{s:10:"formupload";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"es";a:0:{}s:2:"it";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c5117ed655f80a2827c7689a12434c15');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(511, 507, 'FORMS', 'http://files.spip.org/spip-zone/forms_et_tables_2_5.png', '000.005.000', '', '[v3 ;[', '1.9,2.0,2.1,3.0,3.1', '', 'a:1:{i:1;a:3:{s:3:"nom";s:26:"Sylvain BLANC, Loic LE MAO";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-17 19:04:10', '2012-09-17 19:04:10', 1, 'forms_et_tables_2_5.zip', 313604, '2012-09-17 19:04:10', '_plugins_/forms/forms_et_tables_2_5', 'a:3:{s:4:"form";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:9:{s:2:"ca";a:0:{}s:2:"de";a:0:{}s:2:"en";a:0:{}s:5:"fr_tu";a:0:{}s:2:"gl";a:0:{}s:2:"nl";a:0:{}s:5:"pt_br";a:0:{}s:2:"ro";a:0:{}s:2:"tr";a:0:{}}}s:5:"forms";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:30:{s:2:"ar";a:0:{}s:2:"bg";a:0:{}s:2:"ca";a:0:{}s:3:"cpf";a:0:{}s:2:"da";a:0:{}s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"eo";a:0:{}s:2:"es";a:0:{}s:2:"fa";a:0:{}s:2:"gl";a:0:{}s:2:"hu";a:0:{}s:2:"it";a:0:{}s:2:"lb";a:0:{}s:2:"nl";a:0:{}s:6:"oc_auv";a:0:{}s:6:"oc_gsc";a:0:{}s:6:"oc_lms";a:0:{}s:6:"oc_lnc";a:0:{}s:5:"oc_ni";a:0:{}s:6:"oc_prv";a:0:{}s:5:"oc_va";a:0:{}s:2:"pl";a:0:{}s:2:"pt";a:0:{}s:5:"pt_br";a:0:{}s:2:"tr";a:0:{}s:2:"vi";a:0:{}s:2:"zh";a:0:{}s:5:"fr_tu";a:0:{}s:2:"ro";a:0:{}}}s:5:"table";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:30:{s:2:"ar";a:0:{}s:2:"bg";a:0:{}s:2:"ca";a:0:{}s:3:"cpf";a:0:{}s:2:"da";a:0:{}s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"eo";a:0:{}s:2:"es";a:0:{}s:2:"fa";a:0:{}s:2:"gl";a:0:{}s:2:"hu";a:0:{}s:2:"it";a:0:{}s:2:"lb";a:0:{}s:2:"nl";a:0:{}s:6:"oc_auv";a:0:{}s:6:"oc_gsc";a:0:{}s:6:"oc_lms";a:0:{}s:6:"oc_lnc";a:0:{}s:5:"oc_ni";a:0:{}s:6:"oc_prv";a:0:{}s:5:"oc_va";a:0:{}s:2:"pl";a:0:{}s:2:"pt";a:0:{}s:5:"pt_br";a:0:{}s:2:"tr";a:0:{}s:2:"vi";a:0:{}s:2:"zh";a:0:{}s:5:"fr_tu";a:0:{}s:2:"ro";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '7291c9f5b9803892283f1c99cf101cf7'),
(447, 454, 'IEXTRAS', 'http://files.spip.org/spip-zone/champs_extras3_interface.png', '003.001.000', '1.0.0', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en]Adds in the private space a complete interface to manage additional fields on editorial objects.\n[fr]Ajoute dans l''espace priv� une interface compl�te de gestion de champs suppl�mentaires\n							dans les objets �ditoriaux.\n[it]Ajoute dans l''espace priv� une interface compl�te de gestion de champs suppl�mentaires\n							dans les objets �ditoriaux.\n[sk]Do súkromnej zóny pridá kompletn� rozhranie na riadenie doplnkových polí\n							v redakčných objektoch.\n</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/?article4028', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:4:{s:7:"cextras";a:2:{s:3:"nom";s:7:"cextras";s:13:"compatibilite";s:8:"[3.0.4;]";}s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.21.0;]";}s:8:"verifier";a:2:{s:3:"nom";s:8:"verifier";s:13:"compatibilite";s:9:"[0.1.12;]";}s:4:"yaml";a:2:{s:3:"nom";s:4:"yaml";s:13:"compatibilite";s:8:"[1.5.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-16 04:00:21', '2012-09-16 04:00:21', 1, 'champs_extras3_interface.zip', 45166, '2012-09-16 04:00:22', '_plugins_/champs_extras/interface/trunk', 'a:2:{s:7:"iextras";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:14:"paquet-iextras";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"it";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"sk";a:2:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}i:1;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '104dc41269653a82f17760c7ff4deb61'),
(271, 258, 'TRANSACTION', 'http://files.spip.org/spip-zone/transaction.png', '000.003.001', '0.1', '[2.0.0;3.0.99]', '2.0,2.1,3.0', 'Champs additionnels de paiement en ligne pour le plugin Formidable\r\n_ Exemples sur le site de [l''Association Point-Cÿ⿿ur->http://france.pointscoeur.org/]', 'a:2:{i:0;a:3:{s:3:"nom";s:14:"Arnault Pachot";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:14:"Emmanuel Nurit";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Transaction-creer-des-formulaires-avec-paiement-en', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:1:{i:0;a:6:{i:0;a:4:{s:2:"id";s:10:"spip_bonux";s:3:"nom";s:10:"spip_bonux";s:7:"version";s:8:"[1.9.3;]";s:13:"compatibilite";s:8:"[1.9.3;]";}i:1;a:4:{s:2:"id";s:7:"saisies";s:3:"nom";s:7:"saisies";s:7:"version";s:8:"[1.7.5;]";s:13:"compatibilite";s:8:"[1.7.5;]";}i:2;a:4:{s:2:"id";s:8:"verifier";s:3:"nom";s:8:"verifier";s:7:"version";s:6:"[0.1;]";s:13:"compatibilite";s:6:"[0.1;]";}i:3;a:4:{s:2:"id";s:4:"yaml";s:3:"nom";s:4:"yaml";s:7:"version";s:6:"[1.1;]";s:13:"compatibilite";s:6:"[1.1;]";}i:4;a:4:{s:2:"id";s:7:"facteur";s:3:"nom";s:7:"facteur";s:7:"version";s:8:"[1.5.3;]";s:13:"compatibilite";s:8:"[1.5.3;]";}i:5;a:4:{s:2:"id";s:10:"formidable";s:3:"nom";s:10:"formidable";s:7:"version";s:8:"[0.5.3;]";s:13:"compatibilite";s:8:"[0.5.3;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-08 18:00:13', '2012-08-08 18:00:13', 1, 'transaction.zip', 173448, '2012-08-08 18:00:14', '_plugins_/transaction', 'a:1:{s:11:"transaction";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'a88dd7d50ba0542e054ff7dcafb27e64'),
(272, 259, 'TYPOMANIAC', 'http://files.spip.org/spip-zone/typomaniac.jpg', '001.001.001', '', '[v3;]', '1.9,2.0,2.1,3.0,3.1', '', 'a:1:{i:1;a:3:{s:3:"nom";s:6:"Davduf";s:3:"url";s:21:"http://www.davduf.net";s:4:"mail";s:20:"davduf AT davduf.net";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:6:"DWTFYW";s:3:"url";s:32:"http://sam.zoy.org/wtfpl/COPYING";}}', '', 'http://www.davduf.net/typomaniac-un-squelette-responsive-pour-spip-3-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-26 20:00:09', '2012-08-26 20:00:09', 1, 'typomaniac.zip', 428348, '2012-08-26 20:00:10', '_squelettes_/typomaniac', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '85e55d1db3a8bfff02365d735a649954'),
(273, 260, 'TYPO_GUILLEMETS', 'http://files.spip.org/spip-zone/typo_guillemets.png', '001.005.000', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', 'Ce plugin remplace automatiquement les guillemets droits (") par les guillemets typographiques (ÿ«ÿ»â⿬ſâ⿬â⿬ž) de la langue de composition et guillemette correctement la balise <code><q></code>. Les liens automatiques <code>[->1]</code> vers des articles dont le titre contient des ÿ«guillemets fran�§aisÿ» passent en guillemets â⿬ſde second niveauâ⿬. Le remplacement, transparent pour l''utilisateur, ne modifie pas le texte mais seulement l''affichage final.', 'a:1:{i:0;a:3:{s:3:"nom";s:13:"Vincent Ramos";s:3:"url";s:43:"http://www.spip-contrib.net/auteur7639.html";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/article1592.html', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-01-14 01:45:02', '2012-01-14 01:45:02', 1, 'typo_guillemets.zip', 15876, '2012-01-14 01:45:04', '_plugins_/typo_guillemets', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '74f53667a847cdb67a78a9c34523cac1'),
(274, 261, 'VARICELLE', 'http://files.spip.org/spip-zone/varicelle.png', '000.002.001', '', '[1.9.1;3.0.99]', '1.9,2.0,2.1,3.0', 'De jolis boutonsÿ : s�duisants, l�gers et performants (en CSS3 sans image), pour styler d\'un coup tous les appels �  l''action du site. S''applique �  tout ce qui porte le s�lecteur .submit (notamment : <code>button, input, a</code>).', 'a:2:{i:0;a:3:{s:3:"nom";s:14:"romy.tetue.net";s:3:"url";s:21:"http://romy.tetue.net";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:4:"2010";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/varicelle', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:3:"[;]";s:13:"compatibilite";s:3:"[;]";}}}}', '2011-12-29 22:00:07', '2011-12-29 22:00:07', 1, 'varicelle.zip', 18139, '2011-12-29 22:00:08', '_plugins_/varicelle', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '76ed557e3b211dc9651e881ab90669b0'),
(275, 262, 'VERIFIER', 'http://files.spip.org/spip-zone/verifier.png', '000.001.016', '', '[2.0.10;3.0.*]', '2.0,2.1,3.0', '<multi>\n[en]Provides a unique function <code>verifier($value, $type, $options,&$valeur_normalisee)</code> to test the validity of a value.\n[fr]Fournit une fonction unique <code>verifier($valeur, $type, $options, &$valeur_normalisee)</code> permettant de tester la validit� d\'une valeur.\n[sk]Poskytuje jedineÿn�º funkciu <code>verifier($hodnota, $typ, $podmienky),</code> ktor�¡ umoÿ¾ÿ˿uje otestovaÿ¥ platnosÿ¥ hodnoty.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:28:"Les D�veloppements Durables";s:3:"url";s:17:"http://www.ldd.fr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Verifier,1505', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:4:"yaml";a:1:{s:3:"nom";s:4:"yaml";}}}}', '2012-08-30 04:00:09', '2012-08-30 04:00:09', 1, 'verifier.zip', 67796, '2012-08-30 04:00:10', '_plugins_/verifier', 'a:2:{s:15:"paquet-verifier";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:8:"verifier";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:11:{s:2:"ca";a:0:{}s:2:"de";a:1:{i:0;a:2:{s:3:"nom";s:7:"klaus++";s:4:"lien";s:33:"http://trad.spip.net/auteur/klaus";}}s:2:"en";a:4:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}i:1;a:2:{s:3:"nom";s:13:"RastaPopoulos";s:4:"lien";s:41:"http://trad.spip.net/auteur/rastapopoulos";}i:2;a:2:{s:3:"nom";s:4:"Mark";s:4:"lien";s:32:"http://trad.spip.net/auteur/mark";}i:3;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/ÿ¬ÿ˿ÿ±ÿ¬-ÿ⿿ÿ⿠ÿ¯ÿ⿿ÿÿª";}}s:2:"es";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:5:"fr_tu";a:2:{i:0;a:2:{s:3:"nom";s:8:"beatnick";s:4:"lien";s:36:"http://trad.spip.net/auteur/beatnick";}i:1;a:2:{s:3:"nom";s:6:"stefdn";s:4:"lien";s:34:"http://trad.spip.net/auteur/stefdn";}}s:2:"it";a:1:{i:0;a:2:{s:3:"nom";s:3:"Cap";s:4:"lien";s:31:"http://trad.spip.net/auteur/cap";}}s:5:"pt_br";a:1:{i:0;a:2:{s:3:"nom";s:13:"Ricardo Porto";s:4:"lien";s:41:"http://trad.spip.net/auteur/ricardo-porto";}}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:5:"nazar";s:4:"lien";s:33:"http://trad.spip.net/auteur/nazar";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '22fd45b829a89ae1678e11ef36a81181'),
(276, 263, 'VIDEOS', 'http://files.spip.org/spip-zone/videos_0_9_8.png', '000.009.008', '0.3', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\n[en]This plugin allows the integration, using a simple copy/paste of URL, of videos hosted on major platforms (Dailymotion, Vimeo, YouTube, Culturebox) and manage them as spip documents. It also allows the HTML5 display of video in MP4, H.264, Ogg, WebM anf Mkv formats, even in mobile browsers.\n[fr]Ce plugin permet d\'int�grer, �  partir d\'un\n			simple copier/coller d\'URL, des vid�os h�berg�es\n			sur les principales plateformes (Dailymotion, Vimeo, Youtube, CultureBox)\n			et de les g�rer comme des documents spip. Il permet �galement\n			l\'affichage HTML5 des vid�os aux formats MP4, H264, Ogg,\n			WebM et Mkv m�ªme dans les navigateurs mobiles.\n[sk]Tento z�¡suvn�½ modul v�¡m umoÿ¾ÿ˿uje vkladaÿ¥ zÿ jednoduchej k�³pie/prilepenia internetov�½ch adries vide�­ zoÿ vÿ¡etk�½ch v�½znamn�½ch siet�­ (Dailymotion, Vimeo, Youtube, CultureBox)\n			aÿ ovl�¡daÿ¥ ich ako objekty SPIPu. Umoÿ¾ÿ˿uje zobraziÿ¥ ajÿ HTML5 pre vide�¡  form�¡tov MP4, H264, Ogg,\n			WebM aÿ Mkv, aÿ dokonca ajÿ vÿ prehliadaÿoch mobiln�½ch telef�³nov.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:5:"XDjuj";s:3:"url";s:23:"http://demo.apsulis.com";s:4:"mail";s:20:"XDjuj AT apsulis.com";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:4:"2010";}', 'http://www.spip-contrib.net/?article3636', '', '', 'dev', 2, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:6:"medias";a:2:{s:3:"nom";s:6:"medias";s:13:"compatibilite";s:8:"[1.6.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-13 21:00:26', '2012-08-13 21:00:26', 1, 'videos_0_9_8.zip', 312480, '2012-08-13 21:00:28', '_plugins_/videos/tags/videos_0_9_8', 'a:2:{s:13:"paquet-videos";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:6:"videos";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:0:{}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '22fdf194cff6d1df504a3a86121b750b'),
(277, 264, 'VIGNETTES_OXYGEN', 'http://files.spip.org/spip-zone/vignettes_oxygen_128.png', '001.000.000', '', '[3.0.0-alpha2;3.0.99]', '3.0', '<multi>\n[fr]Ce plugin fournit un ensemble d\'ic�´nes de documents en 128x128 pixels venant remplacer les ic�´nes par d�faut de SPIP. Cette collection est bas�es sur les ic�´nes du projet [Oxygen->http://www.softicons.com/free-icons/system-icons/oxygen-icons-by-oxygen]. Une version en 52x52 pixels est �galement disponible.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:34:"http://www.spip-contrib.net/Joseph";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:11:"Team Oxygen";s:3:"url";s:28:"http://www.oxygen-icons.org/";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:4:"LGPL";s:3:"url";s:41:"http://www.gnu.org/licenses/lgpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article3970', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:6:"medias";a:1:{s:3:"nom";s:6:"medias";}}}}', '2012-04-26 20:00:05', '2012-04-26 20:00:05', 1, 'vignettes_oxygen_128.zip', 1645613, '2012-04-26 20:00:12', '_plugins_/vignettes_oxygen/128/trunk', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'f8857f61e46d15e1dfbdca9bfeed9cee'),
(278, 265, 'VIGNETTES_OXYGEN52', 'http://files.spip.org/spip-zone/vignettes_oxygen_52.png', '001.000.000', '', '[3.0.0-alpha2;3.0.99]', '3.0', '', 'a:1:{i:1;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:34:"http://www.spip-contrib.net/Joseph";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:11:"Team Oxygen";s:3:"url";s:28:"http://www.oxygen-icons.org/";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:4:"LGPL";s:3:"url";s:41:"http://www.gnu.org/licenses/lgpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article3970', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:6:"medias";a:1:{s:3:"nom";s:6:"medias";}}}}', '2012-04-26 20:00:29', '2012-04-26 20:00:29', 1, 'vignettes_oxygen_52.zip', 570432, '2012-04-26 20:00:38', '_plugins_/vignettes_oxygen/52/trunk', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd45f823087d2aff1582d821caaf3d74a'),
(279, 266, 'VISITEURS_CONNECTES', '', '000.002.000', '', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0', '<multi>erreur : tag fermant multi manquant::\r\n[fr]\r\n-* Un plugin gadget qui permet d\'afficher le nombre de visiteurs connect�s sur votre site.\r\n-* Ajouter <code><INCLURE{fond=inc-visiteurs}></code> dans vos pages.\r\n[ar]\r\n-* ÿŠÿ¹ÿ±ÿ¶ ÿ¹ÿ¯ÿ¯ ÿ§ÿ⿿ÿ²ÿ˿ÿ§ÿ± ÿ¹ÿ⿿ÿ⿰ ÿ§ÿ⿿ÿ⿦ÿ˿ÿ⿿ÿ¹.\r\n-* ÿ£ÿ¶ÿŠÿ <code><INCLURE{fond=inc-visiteurs}></code> ÿÿŠ ÿµÿÿ­ÿ§ÿªÿƿ.\r\n[en]\r\n-* Displays the number of visitors connected on the site.\r\n-* Add <code><INCLURE{fond=inc-visiteurs}></code> in your pages.\r\n[es]\r\n-* Muestra el n�ºmero de visitantes conectados en el sitio.\r\n-* Agregar <code><INCLURE{fond=inc-visiteurs}></code> en tus p�¡ginas.\r\n[it]\r\n-* Visualizza il numero di visitatori collegati sul sito.\r\n-* Aggiungere <code><INCLURE{fond=inc-visiteurs}></code> nelle vostre pagine.\r\n[de]\r\n-* Zeigt die anzahl der besucher auf der website verbunden.\r\n-* hinzuf�¼gen <code><INCLURE{fond=inc-visiteurs}></code> in ihre seiten.\r\n	<multi></multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:4:"Phil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:21:"superyms (traduction)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Nombres-de-visiteurs-connectes', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-10-06 23:23:31', '2011-10-06 23:23:31', 1, 'visiteurs_connectes.zip', 6258, '2011-10-07 00:00:20', '_plugins_/visiteurs_connectes', 'a:1:{s:5:"local";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:5:{s:2:"ar";a:0:{}s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"es";a:0:{}s:2:"it";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'abfa27a1a3ad48a4e2a3a65ecd75e3b7'),
(280, 267, 'VITTORY', 'http://files.spip.org/spip-zone/Vittory.png', '000.000.001', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\n		[fr]Ce plugin active ou d�sactive le squelette Vittori''s.\n		[en]This plugin activate Vittori''s skeleton.\n		</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:8:"Mary Lou";s:3:"url";s:59:"http://tympanus.net/codrops/2011/04/21/restaurant-template/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:15:"Gr�gory Pascal";s:3:"url";s:34:"http://www.spip-contrib.net/ngombe";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Vittory-s', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{i:0;a:4:{s:2:"id";s:3:"cfg";s:3:"nom";s:3:"cfg";s:7:"version";s:8:"[1.0.4;]";s:13:"compatibilite";s:8:"[1.0.4;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{i:0;a:4:{s:3:"nom";s:7:"palette";s:2:"id";s:7:"palette";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}i:1;a:4:{s:3:"nom";s:11:"mediatheque";s:2:"id";s:11:"mediatheque";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}}}}', '2011-10-17 02:36:48', '2011-10-17 02:36:48', 1, 'Vittory.zip', 1096415, '2011-10-17 03:00:08', '_squelettes_/Vittory', 'a:1:{s:7:"vittory";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'de2cb3a00ed3fc718f57fe5e0b2b7d41'),
(281, 268, 'WEBFONTS', 'http://files.spip.org/spip-zone/webfonts.png', '000.001.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Les navigateurs modernes permettent l\'utilisation de polices de caract�res enrichies, non disponibles par d�faut sur le poste des utilisateurs. Par un coup de chance, Internet Explorer permet aussi cela (avec quelques diff�rences de syntaxe) ce qui rend la fonctionnalit� utilisable par tous les visiteurs.\r\n\r\nGoogle a mis en place un r�pertoire de polices enrichies utilisables librement, ainsi qu\'une API pour g�rer les diff�rences entre navigateur.\r\n\r\nCe plugin facilite compl�tement l\'utilisation de ces polices, et prenant en charge l\'insertion des directives de chargement depuis le r�pertoire des polices propos�es par Google dans votre site.', 'a:1:{i:0;a:3:{s:3:"nom";s:13:"C�dric Morin";s:3:"url";s:22:"http://www.yterium.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Webfonts', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-02-02 17:00:27', '2012-02-02 17:00:27', 1, 'webfonts.zip', 25738, '2012-02-02 17:00:28', '_plugins_/webfonts', 'a:1:{s:8:"webfonts";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '1789711da785d84cb5b26d29cc9c1e29'),
(282, 269, 'YAML', 'http://files.spip.org/spip-zone/yaml.png', '001.005.000', '', '[2.1.0;3.0.*]', '2.1,3.0', '<multi>\n[en]This plugin provides the functions for reading/writing YAML format:\n<code>yaml_decode()</code> and <code>yaml_encode()</code>. It also provides the yaml format for the (DATA) loop.\n[fa]ÿ§ÿŠÿ⿠ ÿ¾ÿ⿿ÿ§ÿ¯ÿŠÿ⿠ ÿƿÿ§ÿ±ÿƿÿ±ÿ¯ÿ⿡ÿ§ÿŠ ÿ®ÿ˿ÿ§ÿ⿠ÿ¯ÿ⿠/ÿ⿠ÿ˿ÿ´ÿªÿ⿠ ÿÿ±ÿ⿦ÿª ÿŠÿ§.ÿ§ÿŠ.ÿ§ÿ⿦.ÿ§ÿ⿿ ÿ±ÿ§ ÿÿ±ÿ§ÿ⿡ÿ⿦ ÿ⿦ÿŠâ⿬ſÿ¢ÿ˿ÿ±ÿ¯: <code>yaml_decode()</code> ÿ˿<code>yaml_encode()</code>. ÿ⿡ÿ⿦ÿ⿠ÿ⿠ÿŠÿ⿠ ÿÿ±ÿ⿦ÿª ÿŠÿ§.ÿ§ÿŠ.ÿ§ÿ⿦.ÿ§ÿ⿿ ÿ±ÿ§ ÿ¨ÿ±ÿ§ÿŠ ÿ­ÿ⿿ÿ⿿ÿ⿡â⿬ſÿŠ (DATA) ÿÿ±ÿ§ÿ⿡ÿ⿦ ÿ⿦ÿŠâ⿬ſÿ³ÿ§ÿ²ÿ¯.\n[fr]Ce plugin fournit les fonctions de lecture/�criture du format YAML:\n	<code>yaml_decode()</code> et <code>yaml_encode()</code>. Il fournit aussi le format yaml pour la boucle (DATA).\n[ru]ÐŸÐ»Ð°Ð³Ð¸Ð½ Ð¿ÿ⿬ÐµÐ´Ð¾ÿÿ⿿Ð°Ð²Ð»ÿÐµÿ⿿ Ð²Ð¾Ð·Ð¼Ð¾Ð¶Ð½Ð¾ÿÿ⿿ÿſ ÿ⿡ÿ⿿ÐµÐ½Ð¸ÿ/Ð½Ð°Ð¿Ð¸ÿÐ°Ð½Ð¸ÿ Ð² ÿ⿿Ð¾ÿ⿬Ð¼Ð°ÿ⿿Ð° YAML:\n	<code>yaml_decode()</code> et <code>yaml_encode()</code>. Ð ÿ⿿Ð°ÐºÐ¶Ðµ Ð´ÐµÐ»Ð°Ðµÿ⿿ Ð´Ð¾ÿÿ⿿ÿƿÐ¿Ð½ÿ⿹Ð¼ ÿ⿿Ð¾ÿ⿬Ð¼Ð°ÿ⿿ YAML Ð´Ð»ÿ ÿ⿠Ð¸ÐºÐ»Ð¾Ð².\n[sk]Tento z�¡suvn�½ modul pon�ºka funkcie ÿ�­tanie/z�¡pisu form�¡tu YAML:\n	<code>yaml_decode()</code> aÿ <code>yaml_encode()</code>. Poskytuje form�¡t yaml ajÿ pre cyklus (DATA).\n</multi>', '', 'a:3:{i:1;a:2:{s:3:"nom";s:8:"yaml.org";s:3:"url";s:16:"http://yaml.org/";}i:2;a:2:{s:3:"nom";s:4:"Spyc";s:3:"url";s:30:"http://code.google.com/p/spyc/";}i:3;a:2:{s:3:"nom";s:31:"Symfony YAML - Fabien Potencier";s:3:"url";s:43:"http://components.symfony-project.org/yaml/";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"MIT";s:3:"url";s:46:"http://opensource.org/licenses/mit-license.php";}}', '', 'http://www.spip-contrib.net/Le-plugin-YAML', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-26 13:27:42', '2012-07-26 13:27:42', 1, 'yaml.zip', 46593, '2012-07-26 13:27:42', '_plugins_/yaml', 'a:1:{s:11:"paquet-yaml";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:5:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:5:"nazar";s:4:"lien";s:33:"http://trad.spip.net/auteur/nazar";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'b59cf80fe4a00ecc53127e882266eb5c'),
(284, 271, 'ZENGARDEN', 'http://files.spip.org/spip-zone/zen-garden-2.png', '002.004.002', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[en] \n[fa] \n[fr] \n[nl] Zie, proef en kies het juiste thema voor je site. \n[ru] \n[sk] \n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:21:"Cedric Morin, Yterium";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/SPIP-Zen-Garden', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-25 04:00:30', '2012-08-25 04:00:30', 1, 'zen-garden-2.zip', 68448, '2012-08-25 04:00:30', '_plugins_/zen-garden/trunk', 'a:2:{s:16:"paquet-zengarden";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:6:{s:2:"en";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"nl";a:1:{i:0;a:2:{s:3:"nom";s:5:"Suske";s:4:"lien";s:33:"http://trad.spip.net/auteur/suske";}}s:2:"ru";a:1:{i:0;a:2:{s:3:"nom";s:5:"nazar";s:4:"lien";s:33:"http://trad.spip.net/auteur/nazar";}}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:9:"zengarden";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:6:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"es";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '34d1ee0c0c480f6c498f3d34d114598e'),
(285, 272, 'ZIPPEUR', 'http://files.spip.org/spip-zone/zippeur.png', '003.000.003', '0.5', '[2.0.0;3.0.99]', '2.0,2.1,3.0', 'Il est parfois utile, notamment quand un article comprend beaucoup de documents joints, de proposer l\'ensemble des documents sous forme de zip. Ce plugin permet �  SPIP de g�n�rer une archive zip �  partir d\'une liste de documents.', 'a:2:{i:0;a:3:{s:3:"nom";s:17:"Ma�¯eul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:19:"Julien Coste-Louret";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Zippeur', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:2:{s:14:"[2.0.0;2.1.99)";a:1:{i:0;a:4:{s:2:"id";s:3:"cfg";s:3:"nom";s:3:"cfg";s:7:"version";s:9:"[1.10.0;]";s:13:"compatibilite";s:9:"[1.10.0;]";}}i:0;a:0:{}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-15 17:00:08', '2012-08-15 17:00:08', 1, 'zippeur.zip', 16099, '2012-08-15 17:00:14', '_plugins_/zippeur/trunk', 'a:1:{s:7:"zippeur";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'f2db10938c7010e8f13ae07235204953'),
(286, 273, 'ZIPTEX', 'http://files.spip.org/spip-zone/ziptex.png', '000.003.003', '', '[3.0.0 ;[', '3.0,3.1', '<multi>\n[fr]Il s''agit d\'une API permettant de regrouper en ZIP le r�sultat d\'une s�rie de squelettes visant �  produire �  des fichiers .tex.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:17:"Ma�¯eul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Livre-avec-SPIP', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:7:"zippeur";a:2:{s:3:"nom";s:7:"zippeur";s:13:"compatibilite";s:8:"[1.4.0;[";}s:10:"latexwheel";a:1:{s:3:"nom";s:10:"latexwheel";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-03-28 11:00:03', '2012-03-28 11:00:03', 1, 'ziptex.zip', 37447, '2012-03-28 11:00:04', '_plugins_/ziptex', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ea2ccfd42a787e1b3dd0bdbf6a6f13c6'),
(287, 274, 'ZOOMER', 'http://files.spip.org/spip-zone/zoomer.png', '000.001', '', '', '', 'cf http://www.dynamicdrive.com/dynamicindex4/featuredzoomer.htm\n	  Ce plugin ajoute un mod�le pour afficher une loupe et offrir un agrandissement localis� : <code>&lt;img|zoom&gt;</code>.\n\nEncore mieux, on peut utiliser une image de plus forte r�solution pour l''agrandissement, mais laisser une petite vignette pour l''image de base.\n\nLa [page de configuration->./?exec=cfg&cfg=zoomer] permet de sp�cifier un style pour la loupe et des styles personalis�s peuvent �ªtre cr��s.\n\nLe code est bas� sur [zoomer->http://valid.tjp.hu/zoomer/] par J� nos T�²th.\n\nLe plugin ne marche qu''avec les squelettes utilisant la balise <code>#INSERT_HEAD</code>\n\nSi vous utilisez SPIP 1.9.2, il faut t�l�charger la biblioth�que javascript [zoomer->http://valid.tjp.hu/zoomer/zoomer.zip] et placer le contenu de l''archive dans un r�pertoire {zoomer} dans votre r�pertoire {squelettes}. Si vous avec SPIP 2, cela sera fait automatiquement pour vous.', 'a:2:{i:0;a:3:{s:3:"nom";s:17:"Pierre Andrews ()";s:3:"url";s:0:"";s:4:"mail";s:19:"mortimer.pa@free.fr";}i:1;a:3:{s:3:"nom";s:13:"J� nos T�²th.";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:2:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}i:1;a:2:{s:3:"nom";s:12:"ÿ© 2006-2010";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Une-loupe-pour-vos-vignette', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2010-12-23 20:00:02', '2010-12-23 20:00:02', 1, 'zoomer.zip', 294373, '2010-12-23 20:00:02', '_plugins_/zoomer', 'a:1:{s:6:"zoomer";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:1:{s:2:"en";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '5c2c1755fca7cc174c56f6f62996a90e'),
(512, 508, 'GALLERIA', 'http://files.spip.org/spip-zone/galleria.png', '001.002.001', '', '[1.9.2;3.0.*]', '1.9,2.0,2.1,3.0', '', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"LUU-THO Th�nh";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Galleria', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-20 18:00:49', '2012-09-20 18:00:49', 1, 'galleria.zip', 94013, '2012-09-20 18:00:50', '_plugins_/galleria', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '61c12316c02b9d20229d5caac0ea609a'),
(289, 276, 'AHUNTSIC', '', '002.000.001', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\n		[en]Activate this plugin to enable {{Ahuntsic}} as the default template of your site.\n		[fr]Activer ce plugin pour s�lectionner le squelette {{Ahuntsic}} pour votre site.\n		</multi>', 'a:1:{i:0;a:3:{s:3:"nom";s:14:"Andr� Vincent";s:3:"url";s:25:"http://andre-vincent.info";s:4:"mail";s:0:"";}}', '', 'a:2:{i:0;a:2:{s:3:"nom";s:12:"ÿ© 2006-2011";s:3:"url";s:0:"";}i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://edu.ca.edu/rubrique43.html', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-07-24 19:00:32', '2012-07-24 19:00:32', 1, 'ahuntsic.zip', 260720, '2012-07-24 19:00:34', '_squelettes_/ahuntsic', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'e17a282c049b3c532e58b12d0ca74776'),
(290, 277, 'ESCAL', 'http://files.spip.org/spip-zone/escal_V2.png', '002.010.002', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', '<multi>\n[fr]Adapt� pour les versions 2 et 3 de SPIP, il propose :\n-* une mise en page param�trable en 2 ou 3 colonnes par le choix d\'une feuille de style \n-* une gestion du multilinguisme \n-* un forum du site style PhpBB mais tr�s simplifi�\n-* un large choix de noisettes �  garder ou pas, certaines �tant redondantes : identification, menu horizontal et/ou vertical. \n-* place, couleur et contenu des blocs lat�raux facile �  changer \n-* un menu horizontal et/ou vertical (2 au choix) d�roulants avec mise en valeur de la rubrique courante  \n-* une redirection automatique vers l''article s''il est seul dans sa rubrique \n-* une navigation par mots-cl�s \n-* un calendrier et/ou une liste d''�v�nements + un agenda \n-* un affichage des derniers articles ou des articles dans la m�ªme rubrique \n-* un affichage des sous-rubriques et des articles dans chaque page rubrique\n-* un affichage des forums des articles \n-* un formulaire de contact des auteurs s''ils ont indiqu� leur e-mail \n-* une page contact �labor�e \n-* un plan du site \n-* un fichier backend pour la syndication du site \n-* une feuille de style sp�ciale pour l''impression des articles \n-* une zone de connexion en page d\'accueil (2 choix possibles d\'affichage) \n-* un ensemble valide XHTML Strict 1.0 \n[en]Activate this plugin to enable {{Escal}} as the default template of your site.\n		</multi>', 'a:1:{i:0;a:3:{s:3:"nom";s:26:"Jean-Christophe Villeneuve";s:3:"url";s:39:"http://projetice.crdp.ac-lyon.fr/escal/";s:4:"mail";s:0:"";}}', '', 'a:2:{i:0;a:2:{s:3:"nom";s:12:"ÿ© 2007-2009";s:3:"url";s:0:"";}i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Escal', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-31 23:00:13', '2012-08-31 23:00:13', 1, 'escal_V2.zip', 437351, '2012-08-31 23:00:14', '_squelettes_/escal/branche_V2', 'a:2:{s:5:"escal";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:4:{s:2:"en";a:0:{}s:2:"eo";a:0:{}s:2:"es";a:0:{}s:2:"it";a:0:{}}}s:5:"local";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:4:{s:2:"en";a:0:{}s:2:"eo";a:0:{}s:2:"es";a:0:{}s:2:"it";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd6301d3ddd930780c7232452fca7e23f'),
(444, 452, 'AUTORITE', 'http://files.spip.org/spip-zone/autorite.png', '000.009.012', '', '[1.9.2;3.0.*]', '1.9,2.0,2.1,3.0', '<multi>\n[ar]بعض إعدادات اٿأذٿٿات\n[de]Dieses Plugin ermöglicht es Ihnen, unterschiedliche Berechtigungen als die Standard-Konfiguration.\n[en]This plugin allows you to configure different permissions than the default.\n[fa]اٿٿ پٿاگٿٿ اجازٿ⿿ٿ پٿٿربٿدٿ⿿ ٿجٿزٿاٿ ٿختٿف غٿر از پٿش⿿گزٿدٿ⿿ٿا را ٿٿ⿿دٿد \n[fr]Ce plugin permet de configurer des autorisations diff�rentes de celles par d�faut.\n[it]Questo plugin vi permette di configurare autorizzazioni diverse da quella di default.\n[sk]Tento zásuvný modul vám umožſuje nastaviť in� povolenia ako predvolen�.\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:5:"James";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:8:"Superyms";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:8:"GNU/LGPL";s:3:"url";s:41:"http://www.gnu.org/licenses/lgpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Le-plugin-Autorite', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:2:{s:14:"[1.9.2;2.1.99]";a:1:{s:3:"cfg";a:2:{s:3:"nom";s:3:"cfg";s:13:"compatibilite";s:8:"[1.5.0;]";}}i:0;a:0:{}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-05 15:00:17', '2012-09-05 15:00:17', 1, 'autorite.zip', 73269, '2012-09-05 15:00:18', '_plugins_/autorite', 'a:2:{s:8:"autorite";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:6:{s:2:"ar";a:1:{i:0;a:2:{s:3:"nom";s:6:"George";s:4:"lien";s:49:"http://trad.spip.net/auteur/جٿرج-ٿٿدٿفت";}}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:15:"paquet-autorite";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:7:{s:2:"ar";a:0:{}s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"fa";a:1:{i:0;a:2:{s:3:"nom";s:14:"Davood Hossein";s:4:"lien";s:42:"http://trad.spip.net/auteur/davood-hossein";}}s:2:"fr";a:0:{}s:2:"it";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd75f0ef9a591cbf69889a63b7cfb7192'),
(297, 283, 'LIVRE_2', 'http://files.spip.org/spip-zone/eva_livre_2_pour_spip_3_0.png', '004.002', '', '[2.9.9;3.0.99]', '', '<multi>\n[fr]{{Int�ret de ce plugin}}\n	\n- Publier les articles d\'une rubrique sous forme de livre\n- Permettre le passage d\'un article �  un autre par pagination\n\n{{Mise en place de ce plugin}}\n\n- Activer le plugin en cochant la case ci-contre, puis valider\n- Suivre la proc�dure de mise en place du livre d�crite dans l\'aide d\'Eva\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:113:"Laurent JULLIEN, Olivier Gautier,�quipe de d�veloppement d\'Eva. Mise �  jour pour SPIP 3 par Olivier Gautier.";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://evaweb.fr', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:13:"evasquelettes";a:2:{s:3:"nom";s:13:"evasquelettes";s:13:"compatibilite";s:6:"[4.2;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-25 17:00:09', '2012-06-25 17:00:09', 1, 'eva_livre_2_pour_spip_3_0.zip', 6662, '2012-06-25 17:00:18', '_squelettes_/eva-web/4_2/eva_livre_2', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'a84ecac16f95f39763e03fb994aba58b'),
(299, 285, 'MINI_CALENDRIER', 'http://files.spip.org/spip-zone/eva_mini_calendrier_pour_spip_3_0.png', '004.002', '', '[2.9.9;3.0.99]', '', '', 'a:1:{i:1;a:3:{s:3:"nom";s:49:"Olivier Gautier,�quipe de d�veloppement EVA-web";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://spip.ac-rouen.fr/?Agenda-calendrier-et-mini', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:13:"evasquelettes";a:2:{s:3:"nom";s:13:"evasquelettes";s:13:"compatibilite";s:6:"[4.2;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-06-25 17:00:34', '2012-06-25 17:00:34', 1, 'eva_mini_calendrier_pour_spip_3_0.zip', 7200, '2012-06-25 17:00:42', '_squelettes_/eva-web/4_2/eva_mini_calendrier', 'a:0:{}', 'oui', 'oui', 0, '', 'non', 'non', 'non', '', '9b103328d88e255f6e4cf3b2fdf5fe9b');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(301, 287, 'ISPIP', 'http://files.spip.org/spip-zone/ispip_1_9.png', '001.000.000', '', '', '', '<multi>\n		[fr]Les squelettes iSPIP offrent une version du site adapt�e pour les terminaux mobiles iPhone et iPod Touch. Aussit�´t le plugin activ�, la version iPhone du site sera accessible �  la page SPIP ÿ«page=ispipÿ».\n		</multi>', 'a:4:{i:0;a:3:{s:3:"nom";s:32:"Joe Hewitt pour la librairie iUI";s:3:"url";s:29:"http://code.google.com/p/iui/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:39:"[Abel Poucet pour le squelette original";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:96:"intialement nomm� MobileSPIP->http://abel.foxylounge.com/MobileSPIP-Un-squelette-optimise.html]";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:45:"Joseph Larmarange pour l''adaptation en plugin";s:3:"url";s:34:"http://www.spip-contrib.net/Joseph";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/plugin-iSPIP', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-10-08 18:39:14', '2011-10-08 18:39:14', 1, 'ispip_1_9.zip', 110872, '2011-10-08 19:01:08', 'tags/ispip_1_9', 'a:1:{s:5:"ispip";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '8023b9b34560a701400d6129d93f3597'),
(302, 288, 'SQUELETTE_MAPARAAN', 'http://files.spip.org/spip-zone/squelette_maparaan.jpg', '001.000.000', '', '[2.0.0;3.0.99]', '2.0,2.1,3.0', 'Un squelette 3 colonnes, gris et rouge. Con�§u pour fonctionner avec le th�me du m�ªme nom.', 'a:3:{i:0;a:3:{s:3:"nom";s:30:"Guillaume Michard (OpenStudio)";s:3:"url";s:25:"http://www.openstudio.fr/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:27:"d\'apr�s le th�me Maparaan";s:3:"url";s:54:"http://www.paddsolutions.com/wordpress-theme-maparaan/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:19:"chez Padd Solutions";s:3:"url";s:29:"http://www.paddsolutions.com/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Mapaaran', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{i:0;a:4:{s:2:"id";s:1:"Z";s:3:"nom";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:5:{i:0;a:4:{s:3:"nom";s:5:"menus";s:2:"id";s:5:"menus";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}i:1;a:4:{s:3:"nom";s:13:"typoenluminee";s:2:"id";s:13:"typoenluminee";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}i:2;a:4:{s:3:"nom";s:10:"socialtags";s:2:"id";s:10:"socialtags";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}i:3;a:4:{s:3:"nom";s:8:"gravatar";s:2:"id";s:8:"gravatar";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}i:4;a:4:{s:3:"nom";s:6:"slogan";s:2:"id";s:6:"slogan";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}}}}', '2012-08-12 21:00:57', '2012-08-12 21:00:57', 1, 'squelette_maparaan.zip', 88175, '2012-08-12 21:01:04', '_squelettes_/maparaan', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'b59237f3999774755f798f9072cd5ff4'),
(513, 509, 'HASHER', 'http://files.spip.org/spip-zone/trunk.png', '002.000.001', '', '[3.0.0;3.0.99]', '3.0', '<multi>\n[en]The number of documents in the directory IMG/extension/ site can become too important and affect the performance of the server''s file system. The solution proposed by this plugin is to "hash" directory IMG/.\n[fr]Le nombre de documents dans le r�pertoire IMG/extension/ du site peut devenir beaucoup trop important et avoir un impact sur les performances du syst�me de fichiers du serveur. La solution propos�e par ce plugin est de � hasher � le r�pertoire IMG/.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:3:"Fil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Le-plugin-hash_documents', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-19 22:00:02', '2012-09-19 22:00:02', 1, 'trunk.zip', 25633, '2012-09-19 22:00:02', '_plugins_/hash_documents/trunk', 'a:1:{s:6:"hasher";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '4140f5967b1aaedd52076a13d64ba4fc'),
(514, 510, 'IECONFIG', 'http://files.spip.org/spip-zone/ieconfig_v1.png', '001.001.002', '', '[3.0.0;3.0.99]', '3.0', '<multi>\n[fr]Ce plugin permet d\'exporter la configuration de SPIP et des plugins compatibles dans un seul et unique fichier au format YAML. Ces fichiers de configuration peuvent ensuite �tre import�s.\n[sk]Tento z�suvn� modul umo��uje exportova� nastavenia SPIPu a�kompatibiln�ch z�suvn�ch modulov v�jedinom s�bore vo�form�te YAML. Tieto s�bory s�nastaveniami potom m��ete nahra�.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:6:"Joseph";s:3:"url";s:30:"http://contrib.spip.net/Joseph";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://contrib.spip.net/spip.php?article3703', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:3:{s:7:"saisies";a:2:{s:3:"nom";s:7:"saisies";s:13:"compatibilite";s:9:"[1.22.0;[";}s:8:"verifier";a:1:{s:3:"nom";s:8:"verifier";}s:4:"YAML";a:1:{s:3:"nom";s:4:"YAML";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-25 18:01:08', '2012-09-25 18:01:08', 1, 'ieconfig_v1.zip', 36096, '2012-09-25 18:01:16', '_plugins_/ieconfig/trunk', 'a:2:{s:8:"ieconfig";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:15:"paquet-ieconfig";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:2:{s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '7b950faad1dd6c88c863d86f8be05279'),
(304, 290, 'SPIP_RESET', 'http://files.spip.org/spip-zone/squelette_spip_reset_v1.png', '001.000', '', '', '', 'Ce plugin permet de faire comme les Framework de reset CSS, mais au niveau squelettes : vider un site de tous les squelettes par d� de SPIP.\r\n	Permet d''�viter la fuite d\'informations sensibles d\'un site.', 'a:1:{i:0;a:3:{s:3:"nom";s:7:"Jacques";s:3:"url";s:43:"http://www.spip-contrib.net/_Jacques-PYRAT_";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Squelettes-SPIP-Reset', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2011-06-29 00:00:46', '2011-06-29 00:00:46', 1, 'squelette_spip_reset_v1.zip', 15813, '2011-06-29 00:00:46', 'tags/spip_reset_1', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '88558688d130fe89010f3742efb8de90'),
(305, 291, 'SVPSKEL', 'http://files.spip.org/spip-zone/svp_skel.png', '000.002.004', '', '[3.0.0-beta;3.0.*]', '3.0', '<multi>\n[fr]Ce plugin est un module optionnel de SVP. \n_ Il fournit un jeu de squelettes Z simple mais complet pour afficher l''ensemble des objets SVP.\nSon but est avant tout de permettre une v�rification ais�e de toutes les informations collect�es par SVP sur les objets d�p�´t, plugin et paquet.\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:14:"Eric Lupinacci";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:3:"svp";a:2:{s:3:"nom";s:3:"svp";s:13:"compatibilite";s:9:"[0.75.4;[";}s:4:"Zpip";a:2:{s:3:"nom";s:4:"Zpip";s:13:"compatibilite";s:12:"[2.0.0-dev;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{s:8:"svpstats";a:2:{s:3:"nom";s:8:"svpstats";s:13:"compatibilite";s:8:"[0.1.3;[";}}}}', '2012-01-22 21:00:19', '2012-01-22 21:00:19', 1, 'svp_skel.zip', 36503, '2012-01-22 21:00:22', '_squelettes_/svp_skel', 'a:1:{s:7:"svpskel";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'a832478750495f031c60e476a6d859b1'),
(306, 292, 'TOOLTIP', 'http://files.spip.org/spip-zone/tooltip.png', '001.003.003', '', '[3.0.0-dev;3.0.99]', '3.0', '<multi>\n[en]jQuery and CSS tooltips, keyboard accessible.\n_ From the jQuery script "Tooltip".\n[fr]Infobulles en jQuery et CSS, accessibles au clavier.\n_ D''apr�s le script jQuery ÿ«ÿ Tooltipÿ ÿ».\n[sk]Bublinkov�¡ n�¡poveda vÿ jQuery aÿ CSS dostupn� prostredn�­ctvom kl�¡vesnice.\n_ D''apr�s le script jQuery ÿ«ÿ Tooltipÿ ÿ».\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:15:"J�¶rn Zaefferer";s:3:"url";s:21:"http://bassistance.de";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"MIT/GPL";s:3:"url";s:0:"";}}', '', '', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-08-12 14:00:16', '2012-08-12 14:00:16', 1, 'tooltip.zip', 98536, '2012-08-12 14:00:18', '_plugins_/tooltip', 'a:2:{s:14:"paquet-tooltip";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:7:"tooltip";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:3:{s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '1743926631539859819cb963d0f1c7c3'),
(308, 294, 'THEME_ANDREAS09_BLACK', 'http://files.spip.org/spip-zone/theme_andreas09-black.png', '000.009.002', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[en]A template with a colorful and shiny header. Fluid base: the content is fluid, the navigation menu and the extra block are fixed. Black version.\r\n	[fr]Un th�me avec une ent�ªte color�e et brillante. Base fluide : le contenu est fluide, le menu de navigation et le bloc extra sont fixe. Version en noir.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:15:"Andreas Viklund";s:3:"url";s:26:"http://andreasviklund.com/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:41:"adapt� pour Zpip par Denis Chenu (GsiLL)";s:3:"url";s:20:"http://www.gsill.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/andreas09', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-09 11:59:14', '2011-10-09 11:59:14', 1, 'theme_andreas09-black.zip', 29561, '2011-10-09 12:00:34', '_themes_/zpip-1/Andreas09/andreas09-black', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '47c9954ab76b124865e311a9c8d1e7cf'),
(309, 295, 'THEME_ANDREAS09_BLUE', 'http://files.spip.org/spip-zone/theme_andreas09-blue.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[en]A template with a colorful and shiny header. Fluid base: the content is fluid, the navigation menu and the extra block are fixed. Blue version.\r\n	[fr]Un th�me avec une ent�ªte color�e et brillante. Base fluide : le contenu est fluide, le menu de navigation et le bloc extra sont fixe. Version en bleu.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:15:"Andreas Viklund";s:3:"url";s:26:"http://andreasviklund.com/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:41:"adapt� pour Zpip par Denis Chenu (GsiLL)";s:3:"url";s:20:"http://www.gsill.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/andreas09', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-09 11:59:14', '2011-10-09 11:59:14', 1, 'theme_andreas09-blue.zip', 31022, '2011-10-09 12:00:40', '_themes_/zpip-1/Andreas09/andreas09-blue', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ea4016ec042418c7cf2b98bfd79b6192'),
(310, 296, 'THEME_ANDREAS09_GREEN', 'http://files.spip.org/spip-zone/theme_andreas09-green.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[en]A template with a colorful and shiny header. Fluid base: the content is fluid, the navigation menu and the extra block are fixed. Green version.\r\n	[fr]Un th�me avec une ent�ªte color�e et brillante. Base fluide : le contenu est fluide, le menu de navigation et le bloc extra sont fixe. Version en vert.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:15:"Andreas Viklund";s:3:"url";s:26:"http://andreasviklund.com/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:41:"adapt� pour Zpip par Denis Chenu (GsiLL)";s:3:"url";s:20:"http://www.gsill.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/andreas09', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-09 11:59:14', '2011-10-09 11:59:14', 1, 'theme_andreas09-green.zip', 30663, '2011-10-09 12:00:42', '_themes_/zpip-1/Andreas09/andreas09-green', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'a654db91967edcee5e02e1417ce1eb00'),
(311, 297, 'THEME_ANDREAS09_ORANGE', 'http://files.spip.org/spip-zone/theme_andreas09-orange.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[en]A template with a colorful and shiny header. Fluid base: the content is fluid, the navigation menu and the extra block are fixed. Orange version.\r\n	[fr]Un th�me avec une ent�ªte color�e et brillante. Base fluide : le contenu est fluide, le menu de navigation et le bloc extra sont fixe. Version en orange.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:15:"Andreas Viklund";s:3:"url";s:26:"http://andreasviklund.com/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:41:"adapt� pour Zpip par Denis Chenu (GsiLL)";s:3:"url";s:20:"http://www.gsill.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/andreas09', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-09 11:59:14', '2011-10-09 11:59:14', 1, 'theme_andreas09-orange.zip', 30592, '2011-10-09 12:00:42', '_themes_/zpip-1/Andreas09/andreas09-orange', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'fe0266dad4208d57a063a87b1e387498'),
(312, 298, 'THEME_ANDREAS09_PURPLE', 'http://files.spip.org/spip-zone/theme_andreas09-purple.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[en]A template with a colorful and shiny header. Fluid base: the content is fluid, the navigation menu and the extra block are fixed. Purple version.\r\n	[fr]Un th�me avec une ent�ªte color�e et brillante. Base fluide : le contenu est fluide, le menu de navigation et le bloc extra sont fixe. Version en violet.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:15:"Andreas Viklund";s:3:"url";s:26:"http://andreasviklund.com/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:41:"adapt� pour Zpip par Denis Chenu (GsiLL)";s:3:"url";s:20:"http://www.gsill.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/andreas09', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-09 11:59:14', '2011-10-09 11:59:14', 1, 'theme_andreas09-purple.zip', 31260, '2011-10-09 12:00:44', '_themes_/zpip-1/Andreas09/andreas09-purple', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '25133c7f94359714b719dda5b8b8a77c'),
(313, 299, 'THEME_ANDREAS09_RED', 'http://files.spip.org/spip-zone/theme_andreas09-red.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[en]A template with a colorful and shiny header. Fluid base: the content is fluid, the navigation menu and the extra block are fixed. Red version.\r\n	[fr]Un th�me avec une ent�ªte color�e et brillante. Base fluide : le contenu est fluide, le menu de navigation et le bloc extra sont fixe. Version en rouge.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:15:"Andreas Viklund";s:3:"url";s:26:"http://andreasviklund.com/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:41:"adapt� pour Zpip par Denis Chenu (GsiLL)";s:3:"url";s:20:"http://www.gsill.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/andreas09', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-09 11:59:14', '2011-10-09 11:59:14', 1, 'theme_andreas09-red.zip', 30528, '2011-10-09 12:00:44', '_themes_/zpip-1/Andreas09/andreas09-red', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '59cf1baaded93523389c229642b43f57'),
(314, 300, 'THEME_ANDREAS1024', 'http://files.spip.org/spip-zone/theme_Andreas1024.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[fr]Un th�me basic en 2 colonnes en 1024 pixels de large.\r\n	[en]A basic 2-column XHTML/CSS template made for 1024px screen width (or higher). It is SEO-friendly and accessible, \r\n  but still very simple and logical structure. Just a good layout for those who prefer a visually clean style.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:15:"Andreas Viklund";s:3:"url";s:26:"http://andreasviklund.com/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:45:"adapt� pour Zpip par Robert Papanicola (SII)";s:3:"url";s:40:"http://www.sciences-indus-cpge.apinc.org";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-09 11:59:14', '2011-10-09 11:59:14', 1, 'theme_Andreas1024.zip', 44846, '2011-10-09 12:00:46', '_themes_/zpip-1/Andreas1024', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'df1aa7cf780b69bc3ff81568edba8e05'),
(315, 301, 'THEME_ARCLITE_BROWN', 'http://files.spip.org/spip-zone/theme_arclite.png', '000.009.002', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[en]A simple theme in 2 columns. With menu and logo. Width fluid between 780 and 1200 px. The main menu can contain up to four sub-menus. Brown version.\r\n		[fr]Un th�me simple sur 2 colonnes. Avec menu d�roulant et logo. Largeur fluide entre 780 et 1200 px. Le menu principal peut contenir jusque 4 sous menus. Version en brun.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:13:"digitalnature";s:3:"url";s:40:"http://digitalnature.ro/projects/arclite";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:41:"adapt� pour Zpip par Denis Chenu (GsiLL)";s:3:"url";s:20:"http://www.gsill.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Arclite', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{i:0;a:4:{s:2:"id";s:3:"cfg";s:3:"nom";s:3:"cfg";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}i:1;a:4:{s:2:"id";s:7:"saisies";s:3:"nom";s:7:"saisies";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_arclite.zip', 456840, '2011-10-11 12:00:18', '_themes_/zpip-1/Arclite/arclite-brown', 'a:1:{s:7:"arclite";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '2094d2e8b7cf6b2202b0cd128fde8004'),
(316, 302, 'THEME_ARCLITE_BLUE', 'http://files.spip.org/spip-zone/theme_arclite-blue.png', '000.009.002', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[en]A simple theme in 2 columns. With menu and logo. Width fluid between 780 and 1200 px. The main menu can contain up to four sub-menus. Blue version.\r\n		[fr]Un th�me simple sur 2 colonnes. Avec menu d�roulant et logo. Largeur fluide entre 780 et 1200 px. Le menu principal peut contenir jusque 4 sous menus. Version en bleu.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:13:"digitalnature";s:3:"url";s:40:"http://digitalnature.ro/projects/arclite";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:41:"adapt� pour Zpip par Denis Chenu (GsiLL)";s:3:"url";s:20:"http://www.gsill.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Arclite', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_arclite-blue.zip', 476831, '2011-10-11 12:00:14', '_themes_/zpip-1/Arclite/arclite-blue', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'adc376e5e462882d1ec67b8f6e16bddc'),
(317, 303, 'THEME_ARCLITE_GREEN', 'http://files.spip.org/spip-zone/theme_arclite-green.png', '000.009.002', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[en]A simple theme in 2 columns. With menu and logo. Width fluid between 780 and 1200 px. The main menu can contain up to four sub-menus. Green version.\r\n		[fr]Un th�me simple sur 2 colonnes. Avec menu d�roulant et logo. Largeur fluide entre 780 et 1200 px. Le menu principal peut contenir jusque 4 sous menus. Version en vert.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:13:"digitalnature";s:3:"url";s:40:"http://digitalnature.ro/projects/arclite";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:41:"adapt� pour Zpip par Denis Chenu (GsiLL)";s:3:"url";s:20:"http://www.gsill.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Arclite', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_arclite-green.zip', 486356, '2011-10-11 12:00:20', '_themes_/zpip-1/Arclite/arclite-green', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '872c6f33c23e06364a5ac962de6ec3ed'),
(318, 304, 'THEME_ARCLITE_RED', 'http://files.spip.org/spip-zone/theme_arclite-red.png', '000.009.002', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[en]A simple theme in 2 columns. With menu and logo. Width fluid between 780 and 1200 px. The main menu can contain up to four sub-menus. Red version.\r\n		[fr]Un th�me simple sur 2 colonnes. Avec menu d�roulant et logo. Largeur fluide entre 780 et 1200 px. Le menu principal peut contenir jusque 4 sous menus. Version en rouge.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:13:"digitalnature";s:3:"url";s:40:"http://digitalnature.ro/projects/arclite";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:41:"adapt� pour Zpip par Denis Chenu (GsiLL)";s:3:"url";s:20:"http://www.gsill.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Arclite', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_arclite-red.zip', 483746, '2011-10-11 12:00:20', '_themes_/zpip-1/Arclite/arclite-red', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c5e42396565e55db72512e43204dac23'),
(319, 305, 'THEME_BLACK', 'http://files.spip.org/spip-zone/theme_black.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Mercurable est un th�me noir �  deux colonnes.', 'a:4:{i:0;a:3:{s:3:"nom";s:11:"E-cosystems";s:3:"url";s:26:"http://www.e-cosystems.org";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:26:"Arnault Pachot(OpenStudio)";s:3:"url";s:25:"http://www.openstudio.fr/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:29:"d\'apr�s le th�me mercurable";s:3:"url";s:57:"http://www.paddsolutions.com/wordpress-theme-mercurable//";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:14:"Padd Solutions";s:3:"url";s:29:"http://www.paddsolutions.com/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Black', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2012-02-19 12:00:32', '2012-02-19 12:00:32', 1, 'theme_black.zip', 86441, '2012-02-19 12:00:32', '_themes_/zpip-1/Black', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '2e81d2f63057a67e9801d4ee94a0495e'),
(320, 306, 'THEME_BLUEBUSINESS', 'http://files.spip.org/spip-zone/theme_bluebusiness01.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me Corporate en 2 colonnes dans les tons blanc/bleu.', 'a:2:{i:0;a:3:{s:3:"nom";s:13:"Openwebdesign";s:3:"url";s:28:"http://www.openwebdesign.org";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:34:"adapt� pour Zpip par Yves Costiou";s:3:"url";s:25:"http://latelier2point0.fr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/bluebusiness01', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_bluebusiness01.zip', 44828, '2011-10-11 12:00:24', '_themes_/zpip-1/Bluebusiness01', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '4199ac11e6261d735ce15c7a13f062b2'),
(321, 307, 'THEME_BLUEPIGMENT', 'http://files.spip.org/spip-zone/theme_BluePigment1-0.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[fr]Un th�me bleu et tr�s web 2.0. Layout fluide en deux colonnes avec une colonne droite statique.\r\n	[en]A web 2.0, blue theme design. Has a two-column, fluid layout with a static right sidebar.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:33:"Styleshout pour le th�me de base";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:47:"C�dric Morin pour l''adaptation Z (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/BluePigment-1-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_BluePigment1-0.zip', 41946, '2011-10-11 12:00:22', '_themes_/zpip-1/BluePigment1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '230f42f41520d39053e9c2c695c338ab'),
(322, 308, 'THEME_BROMINERARY', 'http://files.spip.org/spip-zone/theme_brominerary.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me noir et bleu. Design �pur�. Menu horizontal.', 'a:3:{i:0;a:3:{s:3:"nom";s:28:"Anthony Mathieu (OpenStudio)";s:3:"url";s:25:"http://www.openstudio.fr/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:30:"d\'apr�s le th�me Brominerary";s:3:"url";s:57:"http://www.paddsolutions.com/wordpress-theme-brominerary/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:19:"chez Padd Solutions";s:3:"url";s:29:"http://www.paddsolutions.com/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Brominerary-Theme', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2012-04-24 12:00:02', '2012-04-24 12:00:02', 1, 'theme_brominerary.zip', 794614, '2012-04-24 12:00:04', '_themes_/zpip-1/Brominerary', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'a3ef7e8a4028e340af876e717a989fd6'),
(323, 309, 'THEME_BROWNIE_V1', 'http://files.spip.org/spip-zone/theme_brownie_v1.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[en]Brownie is a responsive site and works great for blog sites.\r\n	[fr]Brownie est un th�me responsive qui fonctionne tr�s bien pour la cr�ation d\'un blog.\r\n	</multi>', 'a:3:{i:0;a:3:{s:3:"nom";s:20:"Brownie de eGrappler";s:3:"url";s:84:"http://www.egrappler.com/free-responsive-html5-portfolio-business-template/blog.html";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:40:"adapt� pour Zpip par Christophe LAFFONT";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:13:"OpenStudio.fr";s:3:"url";s:24:"http://www.openstudio.fr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:26:"GNU General Public License";s:3:"url";s:36:"http://www.gnu.org/licenses/gpl.html";}}', '', 'http://www.spip-contrib.net/brownie', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2012-06-19 20:00:10', '2012-06-19 20:00:10', 1, 'theme_brownie_v1.zip', 95679, '2012-06-19 20:00:10', '_themes_/zpip-1/Brownie', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '966d4ef71829fc2ea24ad764a65a4b88'),
(324, 310, 'THEME_BROWNYGREEN', 'http://files.spip.org/spip-zone/theme_brownygreen.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me simple de couleur marron et vert, en largeur fixe, constitu� de 2 colonnes avec une en-t�ªte facilement personnalisable. Si vous utilisez le plugin Menus, une navigation principale avec sous-menus est pr�vue et mise en page dans ce th�me.', 'a:2:{i:0;a:3:{s:3:"nom";s:11:"E-cosystems";s:3:"url";s:26:"http://www.e-cosystems.org";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:35:"adapt� pour Zpip par Xavier Besson";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2012-02-11 17:00:14', '2012-02-11 17:00:14', 1, 'theme_brownygreen.zip', 1245344, '2012-02-11 17:00:14', '_themes_/zpip-1/brownygreen', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'bfb2c02e6771bdf37013650fa952bbc8'),
(325, 311, 'THEME_CALIFORNIUMITE', 'http://files.spip.org/spip-zone/theme_californiumite.jpg', '000.001', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me gris. Largeur fixe. Menu horizontal, et pied de page important.', 'a:3:{i:0;a:3:{s:3:"nom";s:25:"Sophie Legay (OpenStudio)";s:3:"url";s:25:"http://www.openstudio.fr/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:33:"d\'apr�s le th�me Californiumite";s:3:"url";s:50:"http://www.paddsolutions.com/wpmag/californiumite/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:19:"chez Padd Solutions";s:3:"url";s:29:"http://www.paddsolutions.com/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2012-05-07 12:00:49', '2012-05-07 12:00:49', 1, 'theme_californiumite.zip', 267051, '2012-05-07 12:00:50', '_themes_/zpip-1/Californiumite', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c15f103721215ff12c419f9812a98123'),
(326, 312, 'THEME_CISTICOLE', 'http://files.spip.org/spip-zone/theme_Cisticole.png', '000.001.003', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[en]Cisticole is an original template with two columns. Based on 2 color gradients, it is possible to choose different configuration of these colors.\r\n		[fr]Cisticole est un th�me original en 2 colonnes. Bas� sur 2 d�grad�s de couleurs, il est possible de choisir diff�rentes configuration de ces couleurs.\r\n	</multi>', 'a:1:{i:0;a:3:{s:3:"nom";s:11:"Denis Chenu";s:3:"url";s:20:"http://www.gsill.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/?article3558', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_Cisticole.zip', 45797, '2011-10-11 12:00:26', '_themes_/zpip-1/Cisticole', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '068a309e97641b7b752713625218151d'),
(327, 313, 'THEME_CLEARBREEZE', 'http://files.spip.org/spip-zone/theme_ClearBreeze1-0.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me fleuri (largeur fixe de 980 pixels)', 'a:2:{i:0;a:3:{s:3:"nom";s:16:"Freecsstemplates";s:3:"url";s:31:"http://www.freecsstemplates.org";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:34:"adapt� pour Zpip par yves Costiou";s:3:"url";s:0:"";s:4:"mail";s:29:"mailto:yves.costiou@gmail.com";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/ClearBreeze-1-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_ClearBreeze1-0.zip', 47623, '2011-10-11 12:00:26', '_themes_/zpip-1/ClearBreeze1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '7dc6bc805f028b73f6bfc3f9f45c5b68'),
(328, 314, 'THEME_AASTUDIO_CLOCKWORK', 'http://files.spip.org/spip-zone/theme_clockwork.jpg', '001.001.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Reprend le th�me du site U-Zwilling pour ZPIP', 'a:1:{i:0;a:3:{s:3:"nom";s:8:"AAstudio";s:3:"url";s:25:"http://www.u-zwilling.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/AA-Studio-ClockWork', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_clockwork.zip', 16201, '2011-10-11 12:00:28', '_themes_/zpip-1/Clockwork', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'de16f14c55dc9cd2d9469645ccaafe13'),
(329, 315, 'THEME_COLOURISE', 'http://files.spip.org/spip-zone/theme_Colourise1-0.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n  	[en]A light on dark theme design. Has a fixed width, 2 columns layout with a right sidebar and a nice image header.\r\n  	[fr]Un th�me sur fond noir. Largeur fixe, 2 colonnes avec navigation �  droite et une jolie image d\'en-t�ªte.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"styleshout";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Colourise-1-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_Colourise1-0.zip', 65318, '2011-10-11 12:00:30', '_themes_/zpip-1/Colourise1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '8b7fcd675261a6dd88031fc88df6cf9d'),
(330, 316, 'THEME_COLLEZION', 'http://files.spip.org/spip-zone/theme_collezion.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me issu du squelette [Collection->http://www.spip-contrib.net/Squelette-collection,3148] con�§u pour pr�senter une collection d\'objets physiques. Personnalisable via CFG', 'a:1:{i:0;a:3:{s:3:"nom";s:17:"Ma�¯eul Rouquette";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Collezion-Theme', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{i:0;a:4:{s:2:"id";s:3:"cfg";s:3:"nom";s:3:"cfg";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}i:1;a:4:{s:2:"id";s:7:"saisies";s:3:"nom";s:7:"saisies";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_collezion.zip', 25662, '2011-10-11 12:00:28', '_themes_/zpip-1/Collezion', 'a:1:{s:11:"collezionth";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'f3adb7d795038a0a6273bb886aad9ce6'),
(331, 317, 'THEME_COMPONENT', 'http://files.spip.org/spip-zone/theme_Component1-0.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me sombre en deux colonnes pour blog.', 'a:2:{i:0;a:3:{s:3:"nom";s:16:"freecsstemplates";s:3:"url";s:31:"http://www.freecsstemplates.org";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:34:"adapt� pour Zpip par Yves Costiou";s:3:"url";s:0:"";s:4:"mail";s:22:"yves.costiou@gmail.com";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Component-1-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_Component1-0.zip', 231264, '2011-10-11 12:00:30', '_themes_/zpip-1/Component1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '9728e3691d6207f7c29e0cb5b32d5dc0'),
(332, 318, 'THEME_CORPORATE_OFFICE', 'http://files.spip.org/spip-zone/theme_CorporateOffice1-0.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me Corporate en 2 colonnes dans les tons blanc/bleu/noir', 'a:3:{i:0;a:3:{s:3:"nom";s:11:"freelayouts";s:3:"url";s:26:"http://www.freelayouts.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:35:"[adapt� pour Zpip par Yves Costiou";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:27:">http://lacauserie.free.fr]";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:44:"Creative Commons Attribution-Share Alike 3.0";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Corporate-Office-1-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_CorporateOffice1-0.zip', 255657, '2011-10-11 12:00:32', '_themes_/zpip-1/CorporateOffice1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '24140c7e0d84cf8618b40b6668296a64'),
(333, 319, 'THEME_COOLWATER', 'http://files.spip.org/spip-zone/theme_CoolWater1-0.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[en]A simple and clean design. Uses a combination of light blue and green colors. Has a fixed width, two-columns Layout.\r\n	[fr]Un th�me simple et clair, reposant sur une combinaison de bleu ciel et de vert. En largeur fixe et 2 colonnes.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"styleshout";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/CoolWater-1-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_CoolWater1-0.zip', 38327, '2011-10-11 12:00:32', '_themes_/zpip-1/CoolWater1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '3a67302a45dfa875d8663e2afeee2fe3'),
(334, 320, 'THEME_CUBISMO', 'http://files.spip.org/spip-zone/theme_Cubismo.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[en]Cubismo is clean and simple two column template adapted from [Wordpress Cubismo->http://colorlightstudio.com/2007/11/20/cubismo/].\r\n	[fr]Cubismo est un th�me propre et simple en deux colonnes adapt� du th�me [Wordpress Cubismo->http://colorlightstudio.com/2007/11/20/cubismo/].\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:18:"Color Light Studio";s:3:"url";s:47:"http://colorlightstudio.com/2007/11/20/cubismo/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:42:"adapt� pour Zpip par Val�ry-Xavier Lentz";s:3:"url";s:31:"http://www.valeryxavierlentz.eu";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Cubismo', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_Cubismo.zip', 25257, '2011-10-11 12:00:34', '_themes_/zpip-1/Cubismo', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'f6a0e4a95d55a14457ef7e3a24a7eac3'),
(335, 321, 'THEME_DETACHABLE', 'http://files.spip.org/spip-zone/theme_Detachable1-0.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me v�g�tal, lumineux et frais en trois colonnes pour blog', 'a:2:{i:0;a:3:{s:3:"nom";s:16:"freecsstemplates";s:3:"url";s:31:"http://www.freecsstemplates.org";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:34:"adapt� pour Zpip par Yves Costiou";s:3:"url";s:0:"";s:4:"mail";s:22:"yves.costiou@gmail.com";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Detachable-1-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_Detachable1-0.zip', 352972, '2011-10-11 12:00:34', '_themes_/zpip-1/Detachable1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '5f1fc55b7374a2c985f5edd0a3733e3e'),
(336, 322, 'THEME_EASYBREEZE', 'http://files.spip.org/spip-zone/theme_easybreeze.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me large sur 2 colonnes fixes, gris et bleu. [Easy Breeze->http://www.freelayouts.com/templates/EasyBreeze]', 'a:3:{i:0;a:3:{s:3:"nom";s:10:"Igor Jovic";s:3:"url";s:26:"http://www.spinz.se/om.htm";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:18:"Free CSS Templates";s:3:"url";s:32:"http://www.freecsstemplates.org/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:31:"adapt� par Matthieu Marcillaud";s:3:"url";s:29:"http://marcimat.magraine.net/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/EasyBreeze', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_easybreeze.zip', 48158, '2011-10-11 12:00:36', '_themes_/zpip-1/Easybreeze', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '2ad87a43029d80eec02514d48df03119'),
(337, 323, 'THEME_ELEGANT_GRUNGE', 'http://files.spip.org/spip-zone/theme_Elegant_Grunge.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Deux colonnes, largeur fixe 800 pixels, noir et blanc.', 'a:1:{i:0;a:3:{s:3:"nom";s:28:"Michael Tyson pour Wordpress";s:3:"url";s:60:"http://atastypixel.com/blog/wordpress/themes/elegant-grunge/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 2";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-2.0.html";}}', '', 'http://www.spip-contrib.net/3936', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-17 21:11:09', '2011-10-17 21:11:09', 1, 'theme_Elegant_Grunge.zip', 179583, '2011-10-17 22:00:12', '_themes_/zpip-1/ElegantGrunge', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '57bd26aef32736a1f4e75d0767b52bb8');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(338, 324, 'THEME_ENVISION', 'http://files.spip.org/spip-zone/theme_Envision1-1.jpg', '001.001.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[en]A 2-column, fixed width, W3C-compliant layout. Features a clean, modern theme design. Uses a blue/green color scheme.\r\n	[fr]Un th�me 2 colonnes en largeur fixe. Design clair et moderne. Repose sur une combinaison de bleu et de vert.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"styleshout";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Envision-1-1', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_Envision1-1.zip', 30278, '2011-10-11 12:00:36', '_themes_/zpip-1/Envision1-1', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '1885c035385dd41525a23dd7412e7dfa'),
(339, 325, 'THEME_FRESHMEDIA', 'http://files.spip.org/spip-zone/theme_FreshMedia1-0.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[fr]Ce th�me propose un design simple et clair, en deux colonnes, avec une combinaison de couleurs pastels.\r\n	[en]This website template features a simple and clean design. Has a two column layout and uses a combination of cool and muted colors.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"styleshout";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/FreshMedia-1-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_FreshMedia1-0.zip', 90700, '2011-10-11 12:00:38', '_themes_/zpip-1/FreshMedia1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'cfcc80bdcd24f49b0e39646af5dd2e83'),
(340, 326, 'THEME_GREENY', 'http://files.spip.org/spip-zone/theme_greeny.jpg', '001.000.001', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Greeny est vert, largeur fixe, en 2 colonnes', 'a:3:{i:0;a:3:{s:3:"nom";s:6:"Greeny";s:3:"url";s:55:"http://www.templatemo.com/preview/templatemo_218_greeny";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:18:"Free CSS Templates";s:3:"url";s:32:"http://www.freecsstemplates.org/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:31:"adapt� par Matthieu Marcillaud";s:3:"url";s:29:"http://marcimat.magraine.net/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Greeny', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_greeny.zip', 89527, '2011-10-11 12:00:42', '_themes_/zpip-1/Greeny', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'dcc6ae12dc3d0bf67d8db411e85a171d'),
(341, 327, 'THEME_GUMAMELA', 'http://files.spip.org/spip-zone/theme_gumamela.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me 2 colonnes, gris avec une jolie fleur !', 'a:3:{i:0;a:3:{s:3:"nom";s:8:"Gumamela";s:3:"url";s:45:"http://www.freelayouts.com/templates/Gumamela";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:18:"Free CSS Templates";s:3:"url";s:32:"http://www.freecsstemplates.org/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:29:"http://marcimat.magraine.net/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Gumamela', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_gumamela.zip', 61526, '2011-10-11 12:00:42', '_themes_/zpip-1/Gumamela', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '1fe41fd25d26b704f545b49f1ef46406'),
(342, 328, 'THEME_HARVESTFIELD', 'http://files.spip.org/spip-zone/theme_HarvestField1-0.jpg', '001.001.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[en]A fixed width, two column, W3C compliant layout. Has a nice-looking design that uses natural earthy colors.\r\n		[fr]Un th�me �  2 colonnes en largeur fixe. Design agr�able qui repose sur une gamme naturelle de couleurs terreuses.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"styleshout";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/HarvestField-1-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_HarvestField1-0.zip', 35382, '2011-10-11 12:00:44', '_themes_/zpip-1/HarvestField1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'e2f1ca6075c908d709718bfea70a2dfd'),
(343, 329, 'THEME_HIGHERGROUND', 'http://files.spip.org/spip-zone/theme_HigherGround1-1.jpg', '001.001.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[en]A fixed width, 2 column layout. Uses a  combination of cool and neutral colors, has a simple and clean design with a customizable header photo.\r\n		[fr]Un th�me �  2 colonnes en largeur fixe. Des couleurs froides et neutres, avec un design simple et clair, et un bandeau photo personnalisable.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"styleshout";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/HigherGround-1-1', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_HigherGround1-1.zip', 53781, '2011-10-11 12:00:44', '_themes_/zpip-1/HigherGround1-1', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '35fba658b35166b425fbde15d2991e94'),
(344, 330, 'THEME_JUNGLELAND', 'http://files.spip.org/spip-zone/theme_JungleLand1-0.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[fr]Un th�me marron chaud pour des sites environnementaux ou nature.\r\n		[en]A stylish warm brown design suitable for environmental community and nature business website.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"styleshout";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:42:"adapt� pour Zpip par Phil (parimedia.org)";s:3:"url";s:24:"http://www.parimedia.org";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/JungleLand1-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_JungleLand1-0.zip', 147996, '2011-10-11 12:00:46', '_themes_/zpip-1/JungleLand1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '5714bde287a2b7f0d5cb78f6e00566aa'),
(345, 331, 'THEME_KARLITO', 'http://files.spip.org/spip-zone/theme_Karlito.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me rouge et noir en deux colonnes.', 'a:1:{i:0;a:3:{s:3:"nom";s:38:"Alfred H sur une base de Component-1-0";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Karlito', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2012-02-28 14:00:15', '2012-02-28 14:00:15', 1, 'theme_Karlito.zip', 110592, '2012-02-28 14:00:16', '_themes_/zpip-1/Karlito', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '3ab2b2e8bff02023f283b895882cc74b'),
(346, 332, 'THEME_KEEPITSIMPLE', 'http://files.spip.org/spip-zone/theme_KeepItSimple.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[en]A grid-based, minimalist website template. Ideal for news websites and blogs with lots of contents.\r\n	[fr]Un th�me minimaliste. Id�al pour un site de news ou un blog avec assez de contenu.\r\n	</multi>', 'a:3:{i:0;a:3:{s:3:"nom";s:14:"Styleshout.com";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:35:"adapt� pour Zpip par C�dric Morin";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:11:"yterium.com";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/KeepItSimple', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_KeepItSimple.zip', 52640, '2011-10-11 12:00:46', '_themes_/zpip-1/KeepItSimple', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd9640d10ee2740097997a31763417896'),
(347, 333, 'THEME_LEADESCENT', 'http://files.spip.org/spip-zone/theme_leadescent.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Th�me en deux colonnes, largeur fixe.', 'a:3:{i:0;a:3:{s:3:"nom";s:33:"Romaric Buisson-Ramey(OpenStudio)";s:3:"url";s:25:"http://www.openstudio.fr/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:29:"d\'apr�s le th�me leadescent";s:3:"url";s:57:"http://www.paddsolutions.com/wordpress-theme-leadescent//";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:14:"Padd Solutions";s:3:"url";s:29:"http://www.paddsolutions.com/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2012-04-30 13:00:03', '2012-04-30 13:00:03', 1, 'theme_leadescent.zip', 202829, '2012-04-30 13:00:04', '_themes_/zpip-1/Leadescent', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'bff3d4e54fe4c62d86ae8b1030fb0bc6'),
(348, 334, 'THEME_LESS_IS_MORE', 'http://files.spip.org/spip-zone/theme_less-is-more.jpg', '003.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[fr]Un th�me blanc et gris minimaliste avec une mise en page �  2 colonnes.\r\n	[en]A minimalist white and grey template with a 2-columns layout.\r\n	</multi>', 'a:1:{i:0;a:3:{s:3:"nom";s:6:"StephK";s:3:"url";s:20:"http://iensp.free.fr";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:28:"Creative Commons Attribution";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Less-is-more', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_less-is-more.zip', 26866, '2011-10-11 12:00:48', '_themes_/zpip-1/Less-is-more', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c0b4de6af53f0bf8e0eb787df84f971a'),
(349, 335, 'THEME_LIQUORICE', 'http://files.spip.org/spip-zone/theme_liquorice.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Liquorice est un th�me vintage en deux colonnes.', 'a:2:{i:0;a:3:{s:3:"nom";s:27:"Mathieu RECCHIA(OpenStudio)";s:3:"url";s:25:"http://www.openstudio.fr/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:28:"d\'apr�s le th�me liquorice";s:3:"url";s:44:"http://theme.wordpress.com/themes/liquorice/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Liquorice', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2012-02-02 15:00:02', '2012-02-02 15:00:02', 1, 'theme_liquorice.zip', 143709, '2012-02-02 15:00:04', '_themes_/zpip-1/Liquorice', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '212844835c40a029e69d302aee092602'),
(350, 336, 'THEME_LOGISTIX', 'http://files.spip.org/spip-zone/theme_logistix.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me sur orange et gris, largeur fixe sur 2 colonnes.', 'a:3:{i:0;a:3:{s:3:"nom";s:8:"Logistix";s:3:"url";s:45:"http://www.freelayouts.com/templates/Logistix";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:18:"Free CSS Templates";s:3:"url";s:32:"http://www.freecsstemplates.org/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:31:"adapt� par Matthieu Marcillaud";s:3:"url";s:29:"http://marcimat.magraine.net/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Logistix', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_logistix.zip', 45382, '2011-10-11 12:00:48', '_themes_/zpip-1/Logistix', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '78216af90a251b0f98a1ce9575007a0c'),
(351, 337, 'THEME_MAPARAAN', 'http://files.spip.org/spip-zone/theme_maparaan.jpg', '001.000.001', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me gris et rouge. Largeur fixe. Menu horizontal, et pied de page important.', 'a:3:{i:0;a:3:{s:3:"nom";s:30:"Guillaume Michard (OpenStudio)";s:3:"url";s:25:"http://www.openstudio.fr/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:27:"d\'apr�s le th�me Maparaan";s:3:"url";s:54:"http://www.paddsolutions.com/wordpress-theme-maparaan/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:19:"chez Padd Solutions";s:3:"url";s:29:"http://www.paddsolutions.com/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Maparaan-Theme', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-12-15 14:00:13', '2011-12-15 14:00:13', 1, 'theme_maparaan.zip', 97408, '2011-12-15 14:00:14', '_themes_/zpip-1/Maparaan', 'a:1:{s:8:"maparaan";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:2:{s:2:"en";a:0:{}s:2:"es";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '158dbbce19f4229e492ce5de4da1ece0'),
(352, 338, 'MARYLOU', 'http://files.spip.org/spip-zone/theme_marylou.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me CSS3', 'a:1:{i:0;a:3:{s:3:"nom";s:12:"Yves Costiou";s:3:"url";s:0:"";s:4:"mail";s:22:"yves.costiou@gmail.com";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2012-05-06 00:00:02', '2012-05-06 00:00:02', 1, 'theme_marylou.zip', 546311, '2012-05-06 00:00:04', '_themes_/zpip-1/marylou', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '91b1fd8f13af3efe13579a4a164deefd'),
(353, 339, 'THEME_MERCURABLE', 'http://files.spip.org/spip-zone/theme_mercurable.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Mercurable est un th�me gris �  deux colonnes.', 'a:3:{i:0;a:3:{s:3:"nom";s:26:"Arnault Pachot(OpenStudio)";s:3:"url";s:25:"http://www.openstudio.fr/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:29:"d\'apr�s le th�me mercurable";s:3:"url";s:57:"http://www.paddsolutions.com/wordpress-theme-mercurable//";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:14:"Padd Solutions";s:3:"url";s:29:"http://www.paddsolutions.com/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Mercurable', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2012-08-20 10:00:16', '2012-08-20 10:00:16', 1, 'theme_mercurable.zip', 49966, '2012-08-20 10:00:16', '_themes_/zpip-1/Mercurable', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c2bd4592cafe118ec8918e5ed277e977'),
(354, 340, 'THEME_MARKETPLACE', 'http://files.spip.org/spip-zone/theme_MarketPlace1-0.jpg', '001.001.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[en]A simple, clean, corporate theme website template. Available in 2 and 3 columns layout.\r\n		[fr]Un th�me corporate, simple et clair. En 3 colonnes.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"styleshout";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/MarketPlace-1-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_MarketPlace1-0.zip', 42486, '2011-10-11 12:00:52', '_themes_/zpip-1/MarketPlace1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ddcc50e03135903aabb9ece2ae9ecc68'),
(355, 341, 'THEME_MOZAIC', 'http://files.spip.org/spip-zone/theme_mozaic.png', '002.000.001', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me en 2 colonnes et largeur fixe, piment� de couleurs. Il poss�de quelques variantes de couleurs activables pour l''instant avec le plugin CFG.', 'a:1:{i:0;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Mozaic', '', '', 'stable stable', 0, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}i:1;a:4:{s:3:"nom";s:3:"cfg";s:2:"id";s:3:"cfg";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_mozaic.zip', 901630, '2011-10-11 12:00:52', '_themes_/zpip-1/Mozaic', 'a:1:{s:6:"themes";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '06b32b90b7cf5eea5a693e5a03ba82ad'),
(356, 342, 'THEME_NUAGE', 'http://files.spip.org/spip-zone/theme_nuage.jpg', '002.005.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[fr]Un th�me ciel nuageux avec une mise en page �  2 colonnes.\r\n		[en]A cloudy sky template with a 2-columns layout.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:6:"StephK";s:3:"url";s:20:"http://iensp.free.fr";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:16:"adapt� de Pixel";s:3:"url";s:40:"http://wordpress.org/extend/themes/pixel";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:28:"Creative Commons Attribution";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Nuages', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_nuage.zip', 136563, '2011-10-11 12:00:56', '_themes_/zpip-1/Nuage', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '6bb15564b3457247514cfd77fe19227e'),
(357, 343, 'THEME_NEWHORIZON', 'http://files.spip.org/spip-zone/theme_NewHorizon1-0.jpg', '001.001.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[en]Fixed width, 2-column website template. A light on dark theme design with a nice colorful image header.\r\n		[fr]Un th�me en largeur fixe et 2 colonnes. Sur fond noir, avec un bandeau haut color�\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"styleshout";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/New-Horizon-1-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_NewHorizon1-0.zip', 92595, '2011-10-11 12:00:54', '_themes_/zpip-1/NewHorizon1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '225a5af07817067cfdd49e00b10d6a7f'),
(358, 344, 'THEME_OUTDOOR', 'http://files.spip.org/spip-zone/theme_Outdoor1-0.jpg', '001.001.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[en]A nature based theme design. Has a fixed width, 2 columns layout with a header photo that can be easily changed by one of your own.\r\n		[fr]Un th�me champ�ªtre. En largeur fixe et 2 colonnes avec un bandeau photo facilement modifiable.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"styleshout";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/OutDoor-1-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2012-07-10 17:00:33', '2012-07-10 17:00:33', 1, 'theme_Outdoor1-0.zip', 94994, '2012-07-10 17:00:34', '_themes_/zpip-1/Outdoor1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '9d121d7a505132ca42660274e01bc793'),
(359, 345, 'THEME_PIXEL', 'http://files.spip.org/spip-zone/theme_pixel.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[fr]Un th�me de couleur sombre avec une mise en page �  2 colonnes.\r\n		[en]A dark template with a 2-columns layout.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:5:"pixel";s:3:"url";s:40:"http://wordpress.org/extend/themes/pixel";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:33:"adapt� pour Zpip par Teddy Payet";s:3:"url";s:25:"http://www.teddypayet.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Pixel-1-9-8', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_pixel.zip', 141170, '2011-10-11 12:00:58', '_themes_/zpip-1/Pixel_1_9_8', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '05e6020420ed02ab00de72af6095a553'),
(360, 346, 'THEME_RIAM', 'http://files.spip.org/spip-zone/theme_riam.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Th�me bichrome �  2 colonnes sur fond de trame al�atoire', 'a:2:{i:0;a:3:{s:3:"nom";s:9:"erational";s:3:"url";s:24:"http://www.erational.org";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:36:"d\'apr�s de le site du festival RIAM";s:3:"url";s:20:"http://www.riam.info";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Riam', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_riam.zip', 61600, '2011-10-11 12:01:00', '_themes_/zpip-1/Riam', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '17068ab15ffe5dd87540c76fb7a47bbf'),
(361, 347, 'THEME_ROCK', 'http://files.spip.org/spip-zone/theme_rock.jpg', '002.005.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[fr]Un th�me sombre sur fond de guitare �lectrique avec une mise en page �  2 colonnes.\r\n		[en]A dark template with electric guitar in the background and with a 2-columns layout.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:6:"StephK";s:3:"url";s:20:"http://iensp.free.fr";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:16:"adapt� de Pixel";s:3:"url";s:40:"http://wordpress.org/extend/themes/pixel";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:28:"Creative Commons Attribution";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Rock', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_rock.zip', 196966, '2011-10-11 12:01:00', '_themes_/zpip-1/Rock', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '9cb6673b0f921025e8a1c53c14000112'),
(362, 348, 'THEME_THEMORNINGAFTER', 'http://files.spip.org/spip-zone/theme_TheMorningAfter.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[fr]The Morning After est un th�me de style magazine adapt� pour SPIP �  partir de la version 1.3.2 du th�me Wordpress. Lire README.txt (en anglais) pour les d�tails de la licence. Merci de laisser les cr�dits en pied de page.\r\n		[en]''The Morning After'' is a magazine-style theme, adapted to SPIP from the 1.3.2 version of the Wordpress theme. Read README.txt for the licence details. Please keep the credits in the footer.\r\n	</multi>', 'a:3:{i:0;a:3:{s:3:"nom";s:21:"Arun Kale (cr�ation)";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:14:"The Masterplan";s:3:"url";s:23:"http://themasterplan.in";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:42:"adapt� pour Zpip par Val�ry-Xavier Lentz";s:3:"url";s:31:"http://www.valeryxavierlentz.eu";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:3:"MIT";s:3:"url";s:46:"http://opensource.org/licenses/mit-license.php";}}', '', 'http://www.spip-contrib.net/The-Morning-After-theme', '', '', 'test', 3, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_TheMorningAfter.zip', 273037, '2011-10-11 12:01:06', '_themes_/zpip-1/TheMorningAfter', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '2ceb4ecf52568d5caf4c16e30419eae7'),
(363, 349, 'THEME_TECHJUNKIE', 'http://files.spip.org/spip-zone/theme_TechJunkie.jpg', '001.001.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n  		[en]Features a clean and modern design. Ideal for blogs and small websites. It has a 2 columns, fixed-width layout and uses a combination of blue, light green and muted colors.\r\n		[fr]Un design clair et moderne, id�al pour un blog ou un site simple. En largeur fixe et 2 colonnes, sur une combinaison de bleu et de vert clair.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"styleshout";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/TechJunkie', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_TechJunkie.zip', 61083, '2011-10-11 12:01:06', '_themes_/zpip-1/TechJunkie', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '781d208dd56e56fe2e518f28525bc7d5'),
(364, 350, 'THEME_SANDY', 'http://files.spip.org/spip-zone/theme_sandy.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me �l�gant, "bois et fleurs", ideal pour un blog', 'a:1:{i:0;a:3:{s:3:"nom";s:10:"templatemo";s:3:"url";s:25:"http://www.templatemo.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Sandy', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:9:"[1.7.15;]";s:13:"compatibilite";s:9:"[1.7.15;]";}}}}', '2012-01-11 11:00:02', '2012-01-11 11:00:02', 1, 'theme_sandy.zip', 623489, '2012-01-11 11:00:02', '_themes_/zpip-1/sandy', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd6ed52aeb2c780f899b7dbd3656199cb'),
(365, 351, 'THEME_SLEEK', 'http://files.spip.org/spip-zone/theme_sleek.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me 2 colonnes, gris et blanc', 'a:3:{i:0;a:3:{s:3:"nom";s:5:"Sleek";s:3:"url";s:42:"http://www.freelayouts.com/templates/Sleek";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:18:"Free CSS Templates";s:3:"url";s:32:"http://www.freecsstemplates.org/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:31:"adapt� par Matthieu Marcillaud";s:3:"url";s:29:"http://marcimat.magraine.net/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Sleek', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-11-27 14:00:03', '2011-11-27 14:00:03', 1, 'theme_sleek.zip', 85805, '2011-11-27 14:00:04', '_themes_/zpip-1/Sleek', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '49da7d35ce2fe2a120a619ba5db9472f'),
(366, 352, 'THEME_SNOWBLIND800', 'http://files.spip.org/spip-zone/theme_Snowblind.png', '000.009.002', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me sur une base blanc et noir, avec un peu de bleu. Menu de navigation anim�, largeur fixe, extra en bas de page', 'a:3:{i:0;a:3:{s:3:"nom";s:9:"[c.bavota";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:44:"Juan Gordillo->http://themes.bavotasan.com/]";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:41:"adapt� pour Zpip par Denis Chenu (GsiLL)";s:3:"url";s:20:"http://www.gsill.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Snowblind', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-09 01:48:41', '2011-10-09 01:48:41', 1, 'theme_Snowblind.zip', 91056, '2011-10-09 02:01:04', '_themes_/zpip-1/Snowblind/Snowblind-800px', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '41b158688ff56a5d3ac060c56296bd75'),
(367, 353, 'THEME_SNOWBLIND1024', 'http://files.spip.org/spip-zone/theme_Snowblind-1024.png', '000.009.002', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me sur une base blanc et noir, avec un peu de bleu. Menu de navigation anim�, largeur fixe, extra en bas de page', 'a:3:{i:0;a:3:{s:3:"nom";s:9:"[c.bavota";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:44:"Juan Gordillo->http://themes.bavotasan.com/]";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:41:"adapt� pour Zpip par Denis Chenu (GsiLL)";s:3:"url";s:20:"http://www.gsill.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Snowblind', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_Snowblind-1024.zip', 91291, '2011-10-11 12:01:02', '_themes_/zpip-1/Snowblind/Snowblind-1024px', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '757967940f53b94667c50eb02f288461'),
(368, 354, 'THEME_SURREAL', 'http://files.spip.org/spip-zone/theme_surreal.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me surr�aliste, sur 2 colonnes fixes et un grand pied de page.', 'a:3:{i:0;a:3:{s:3:"nom";s:7:"Surreal";s:3:"url";s:44:"http://www.freelayouts.com/templates/Surreal";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:18:"Free CSS Templates";s:3:"url";s:32:"http://www.freecsstemplates.org/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:31:"adapt� par Matthieu Marcillaud";s:3:"url";s:29:"http://marcimat.magraine.net/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Surreal', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_surreal.zip', 103169, '2011-10-11 12:01:04', '_themes_/zpip-1/Surreal', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'ee6ec53e6d24174f9a38b68121236f71'),
(369, 355, 'THEME_TINCREDIBLE', 'http://files.spip.org/spip-zone/theme_tincredible.jpg', '001.000.002', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Tincredible est un th�me bleu, sobre et �l�gant �  deux colonnes utilisant CSS 3 et se d�gradant correctement lorsque CSS 3 n''est pas support� par le navigateur.', 'a:3:{i:0;a:3:{s:3:"nom";s:26:"Arnault Pachot(OpenStudio)";s:3:"url";s:25:"http://www.openstudio.fr/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:30:"d\'apr�s le th�me Tincredible";s:3:"url";s:57:"http://www.paddsolutions.com/wordpress-theme-tincredible/";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:14:"Padd Solutions";s:3:"url";s:29:"http://www.paddsolutions.com/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Tincredible', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2012-05-31 14:00:02', '2012-05-31 14:00:02', 1, 'theme_tincredible.zip', 532486, '2012-05-31 14:00:04', '_themes_/zpip-1/tincredible', 'a:1:{s:11:"tincredible";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '055902b9787a073d984ef5aca589c2c7'),
(370, 356, 'THEME_TREFLE', 'http://files.spip.org/spip-zone/theme_trefle.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[fr]Un th�me simple, avec un tr�fle �  3 feuilles, en largeur fixe et 1 colonne principale et une colonne des rubriques.\r\n		[en]A simple theme with a 3 leaf clover, in fixed width and a main column and a column for sections.\r\n	</multi>', 'a:1:{i:0;a:3:{s:3:"nom";s:4:"Phil";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:13:"chocolat ware";s:3:"url";s:0:"";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_trefle.zip', 84436, '2011-10-11 12:01:08', '_themes_/zpip-1/Trefle', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'f2d55a6595596b4f163bbe9545cf9e0e'),
(371, 357, 'THEME_VECTORLOVER11', 'http://files.spip.org/spip-zone/theme_vectorlover11.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un design simple et sympa. Le th�me utilise une combinaison de brun, vert et gris ; \r\n	il a une largeur fixe et deux colonnes.', 'a:1:{i:0;a:3:{s:3:"nom";s:10:"styleshout";s:3:"url";s:26:"http://www.styleshout.com/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:30:"Creative Commons Attribution 3";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.9.9;]";s:13:"compatibilite";s:8:"[1.9.9;]";}}}}', '2012-02-10 11:00:18', '2012-02-10 11:00:18', 1, 'theme_vectorlover11.zip', 95028, '2012-02-10 11:00:18', '_themes_/zpip-1/VectorLover11', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '7b11750d6759a1447b9cb69535d4948c'),
(372, 358, 'THEME_VERSATILITY', 'http://files.spip.org/spip-zone/theme_Versatility.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me simple de couleur bleu et gris, en largeur fixe, constitu� de 2 colonnes avec une en-t�ªte facilement personnalisable. Si vous utilisez le plugin Menus, une navigation principale avec sous-menus est pr�vue et mise en page dans ce th�me.', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"openstudio";s:3:"url";s:24:"http://www.openstudio.fr";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:35:"adapt� pour Zpip par Xavier Besson";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Versatility', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_Versatility.zip', 200727, '2011-10-11 12:01:10', '_themes_/zpip-1/Versatility', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '019a3918992d3641568d2ced01130ed9'),
(373, 359, 'THEME_UNBOUND', 'http://files.spip.org/spip-zone/theme_UnBound1-0.jpg', '001.001.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n  		[en]A three-columns, fixed width CSS template suitable for blogs and news sites. It features a nice, clean design with an image header that can be easily replaced or modified.\r\n		[fr]Th�me en 3 colonnes et largeur fixe, adapt� pour un blog ou un site d\'actualit�s. Un joli design clair, avec un bandeau photo facilement modifiable.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"styleshout";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_UnBound1-0.zip', 75978, '2011-10-11 12:01:08', '_themes_/zpip-1/UnBound1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '1cc8e43952c2bf619163b8eb2cfc35f3'),
(374, 360, 'THEME_URBANARTIST', 'http://files.spip.org/spip-zone/theme_UrbanArtist1-0.jpg', '001.001.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[en]A light on dark template. Has a fixed width, two columns layout. The design is a combination of a dark background and bright colored text and headers.\r\n		[fr]Un th�me sur fond noir. Largeur fixe et 2 colonnes. Le design est une combinaison de fond noir et de textes et titres vif et color�s.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"styleshout";s:3:"url";s:25:"http://www.styleshout.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Urban-Artist-1-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_UrbanArtist1-0.zip', 66207, '2011-10-11 12:01:10', '_themes_/zpip-1/UrbanArtist1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '96aff0650af7965d6e8292ce776bd214'),
(375, 361, 'THEME_WELSH2_2COL', 'http://files.spip.org/spip-zone/theme_Welsh2-0_2col.jpg', '002.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Welsh 2.0 est un th�me sur fond clair, de largeur fluide et disposant d\'un menu par onglets', 'a:2:{i:0;a:3:{s:3:"nom";s:7:"Kozlika";s:3:"url";s:57:"http://themes.dotaddict.org/galerie-dc2/details/Welsh-2-0";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:20:"Val�ry-Xavier Lentz";s:3:"url";s:31:"http://www.valeryxavierlentz.eu";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Welsh-2-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_Welsh2-0_2col.zip', 61015, '2011-10-11 12:01:12', '_themes_/zpip-1/Welsh2-0/Welsh2-0_2-col', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '20ffba8a526bb47f4ed3659d107fe7e3'),
(376, 362, 'THEME_WELSH2_3COL', 'http://files.spip.org/spip-zone/theme_Welsh2-0_3col.jpg', '002.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Welsh 2.0 est un th�me sur fond clair, de largeur fluide et disposant d\'un menu par onglets', 'a:2:{i:0;a:3:{s:3:"nom";s:7:"Kozlika";s:3:"url";s:57:"http://themes.dotaddict.org/galerie-dc2/details/Welsh-2-0";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:20:"Val�ry-Xavier Lentz";s:3:"url";s:31:"http://www.valeryxavierlentz.eu";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Welsh-2-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-09 01:48:41', '2011-10-09 01:48:41', 1, 'theme_Welsh2-0_3col.zip', 62705, '2011-10-09 02:01:14', '_themes_/zpip-1/Welsh2-0/Welsh2-0_3-col', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'eb4fe005da8a304dc8ac6efbf3faf5f3'),
(377, 363, 'THEME_WP2010', 'http://files.spip.org/spip-zone/theme_wp2010.png', '001.000.004', '', '', '', '', 'a:1:{i:0;a:3:{s:3:"nom";s:17:"Ma�¯eul Rouquette";s:3:"url";s:21:"http://www.maieul.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:0:"";s:13:"compatibilite";s:0:"";}}}}', '2012-09-03 20:00:02', '2012-09-03 20:00:02', 1, 'theme_wp2010.zip', 36837, '2012-09-03 20:00:02', '_themes_/zpip-1/wp2010', 'a:1:{s:12:"theme_wp2010";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c6f71343a99eaa43d5f0c915dd499fc2'),
(378, 364, 'THEME_WUWEI', 'http://files.spip.org/spip-zone/theme_wu-wei.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[en]A clean, minimalist, grid-based theme, with high contrast and multiple colour schemes.\r\n		[fr]Un th�me sobre et minimaliste, bas� sur une grille, avec un fort contraste.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:9:"Jeff Ngan";s:3:"url";s:23:"http://equivocality.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Wu-Wei', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_wu-wei.zip', 28097, '2011-10-11 12:01:14', '_themes_/zpip-1/Wu-wei', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'bffbb91aca6bdc8bac6648bd81910bc6'),
(379, 365, 'THEME_WUWEI_BLACK', 'http://files.spip.org/spip-zone/theme_wu-wei-black.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[en]A clean, minimalist, grid-based theme, with high contrast and multiple colour schemes. Black version.\r\n		[fr]Un th�me sobre et minimaliste, bas� sur une grille, avec un fort contraste. Version noire.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:9:"Jeff Ngan";s:3:"url";s:23:"http://equivocality.com";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Wu-Wei-Noir', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_wu-wei-black.zip', 36477, '2011-10-11 12:01:14', '_themes_/zpip-1/Wu-wei-black', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '3897fa543c289709fbaa33c12564a759');
INSERT INTO `spip_paquets` (`id_paquet`, `id_plugin`, `prefixe`, `logo`, `version`, `version_base`, `compatibilite_spip`, `branches_spip`, `description`, `auteur`, `credit`, `licence`, `copyright`, `lien_doc`, `lien_demo`, `lien_dev`, `etat`, `etatnum`, `dependances`, `date_crea`, `date_modif`, `id_depot`, `nom_archive`, `nbo_archive`, `maj_archive`, `src_archive`, `traductions`, `actif`, `installe`, `recent`, `maj_version`, `superieur`, `obsolete`, `attente`, `constante`, `signature`) VALUES
(380, 366, 'XAYONA', 'http://files.spip.org/spip-zone/theme_xayona.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me standard Open Studio', 'a:2:{i:0;a:3:{s:3:"nom";s:29:"Dimitri EXBRAYAT (OpenStudio)";s:3:"url";s:25:"http://www.openstudio.fr/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:27:"chez Free Website Templates";s:3:"url";s:36:"http://www.freewebsitetemplates.com/";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Xayona-Theme', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2012-04-23 12:00:13', '2012-04-23 12:00:13', 1, 'theme_xayona.zip', 617088, '2012-04-23 12:00:14', '_themes_/zpip-1/xayona', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '90ffdcb96dd438d80779feba7ce587f2'),
(381, 367, 'THEME_ZPRESSE', 'http://files.spip.org/spip-zone/theme_zpresse.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[fr]Un th�me de presse basique.\r\n		[en]A press basic template.\r\n		[es]Un tema b�¡sico de prensa.\r\n	</multi>', 'a:1:{i:0;a:3:{s:3:"nom";s:8:"speciale";s:3:"url";s:28:"http://www.luis-speciale.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Zpresse', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_zpresse.zip', 512874, '2011-10-11 12:01:16', '_themes_/zpip-1/Zpresse', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '09bde102ffee80e09f46c0cc663f15dd'),
(382, 368, 'THEME_ZFUSION', 'http://files.spip.org/spip-zone/theme_z-fusion1-0.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me tir� du squelette [Fusion->http://www.spip-contrib.net/Fusion]', 'a:2:{i:0;a:3:{s:3:"nom";s:6:"Fusion";s:3:"url";s:34:"http://www.spip-contrib.net/Fusion";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:54:"adapt� du squelette fusion pour Zpip par Yves Costiou";s:3:"url";s:0:"";s:4:"mail";s:22:"yves.costiou@gmail.com";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Fusion-pour-Z', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-09 12:10:46', '2011-10-09 12:10:46', 1, 'theme_z-fusion1-0.zip', 162973, '2011-10-09 13:00:36', '_themes_/zpip-1/Z-fusion1-0', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '9d4993729d8c3c1b672d2d25a38edc99'),
(383, 369, 'THEME_IPAD_CSSLAYOUT', 'http://files.spip.org/spip-zone/theme_ipadcss.png', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[fr]Un th�me minimal en css pour l''iPad (ou n''importe quelle autre tablette avec un navigateur ÿ« webkit ÿ»).\r\n	[en]iPad CSS Layout with Landscape/Portrait Modes\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:10:"ipadlayout";s:3:"url";s:22:"http://j.mp/ipadlayout";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:42:"adapt� pour Zpip par Mathieu Drouet (izo)";s:3:"url";s:23:"http://www.takeasip.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:32:"Creative Commons Attribution 2.5";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Ipad-CSS-Layout', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 12:00:13', '2011-10-11 12:00:13', 1, 'theme_ipadcss.zip', 18714, '2011-10-11 12:01:18', '_themes_/zpip-1/ipad-css-layout', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '8bd7be39547554830fde2f27bcc71a5c'),
(384, 370, 'THEME_JQTOUCH', 'http://files.spip.org/spip-zone/theme_jqtouch.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Un th�me de base fond� sur [Jqtouch->http://www.jqtouch.com/] pour d�velopper un site mobile. Ce th�me n''est pas pr�ªt �  �ªtre utilis� en l''�tat, mais pose les �l�ments de base pour construire un habillage complet.', 'a:2:{i:0;a:3:{s:3:"nom";s:7:"Jqtouch";s:3:"url";s:23:"http://www.jqtouch.com/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:53:"adapt� pour Zpip par Mathieu Drouet (izo) take a sip";s:3:"url";s:23:"http://www.takeasip.net";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:3:"MIT";s:3:"url";s:46:"http://opensource.org/licenses/mit-license.php";}}', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_jqtouch.zip', 115202, '2011-10-11 12:01:20', '_themes_/zpip-1/jqtouch', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '68762dfdedbbcce0c91f1e8fc5d884bf'),
(385, 371, 'THEME_OOCSS', 'http://files.spip.org/spip-zone/theme_ooCSS.jpg', '000.002.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[fr]Un th�me de base fond� sur [ooCSS->http://wiki.github.com/stubbornella/oocss] pour d�velopper un site. Ce th�me n''est pas pr�ªt �  �ªtre utilis� en l''�tat, mais pose les �l�ments de base pour construire un habillage complet. Voir la documentation sur les pages :\r\n	[en]Theme based on [ooCSS->http://wiki.github.com/stubbornella/oocss] to use as a foundation for website development. This theme is not ready to use, but it settles basic elements in order to build a skin on. More documentation on public pages :\r\n	</multi>\r\n-* <code>spip.php?page=demo/template</code>\r\n-* <code>spip.php?page=demo/template_docs</code>\r\n-* <code>spip.php?page=demo/grids_docs</code>\r\n-* <code>spip.php?page=demo/grids_all</code>\r\n-* <code>spip.php?page=demo/module</code>\r\n-* <code>spip.php?page=demo/library</code>', 'a:2:{i:0;a:3:{s:3:"nom";s:15:"Nicole Sullivan";s:3:"url";s:41:"http://wiki.github.com/stubbornella/oocss";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:35:"adapt� pour Zpip par C�dric Morin";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:3:"BSD";s:3:"url";s:45:"http://www.freebsd.org/copyright/license.html";}}', '', 'http://www.spip-contrib.net/Framework-ooCSS', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-11-03 17:07:56', '2011-11-03 17:07:56', 1, 'theme_ooCSS.zip', 751349, '2011-11-03 18:00:06', '_themes_/zpip-1/ooCSS', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'd14d36e47f0d8dca84f60538f6c55ed3'),
(386, 372, 'THEME_BLUEPRINT', 'http://files.spip.org/spip-zone/theme_blueprint.jpg', '000.009.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n	[fr]Un th�me de base fond� sur [BluePrint->http://www.blueprintcss.org/] pour d�velopper un site. Ce th�me n''est pas pr�ªt �  �ªtre utilis� en l''�tat, mais pose les �l�ments de base pour construire un habillage complet. Documentation : <code>spip.php?page=demo/blueprint</code>\r\n	[en]Theme based on [BluePrint->http://www.blueprintcss.org/] to use as a foundation for website development This theme is not ready	to use, but it settles basic elements in order to build a skin on. Documentation : <code>spip.php?page=demo/blueprint</code>\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:19:"Blueprint community";s:3:"url";s:28:"http://www.blueprintcss.org/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:47:"C�dric Morin pour l''adaptation Z (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Framework-BluePrint', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-11-03 17:11:46', '2011-11-03 17:11:46', 1, 'theme_blueprint.zip', 256694, '2011-11-03 18:00:12', '_themes_/zpip-1/blueprint', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'dcbb94f9232050480bc4fb198b223fb9'),
(387, 373, 'THEME_TRIPOLI', 'http://files.spip.org/spip-zone/theme_tripoli.jpg', '001.000.000', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', '<multi>\r\n		[fr]Un th�me de base fond� sur [Tripoli->http://devkick.com/lab/tripoli/] pour d�velopper un site. Ce th�me n''est pas pr�ªt �  �ªtre utilis� en l''�tat, mais pose les �l�ments de base pour construire un habillage complet.\r\n		[en]Theme based on [Tripoli->http://devkick.com/lab/tripoli/] to use as a foundation for website development. This theme is not ready to use, but it settles basic elements in order to build a skin on.\r\n	</multi>', 'a:2:{i:0;a:3:{s:3:"nom";s:7:"DevKick";s:3:"url";s:31:"http://devkick.com/lab/tripoli/";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:49:"adapt� pour Zpip par C�dric Morin (yterium.com)";s:3:"url";s:22:"http://www.yterium.com";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:3:"BSD";s:3:"url";s:45:"http://www.freebsd.org/copyright/license.html";}}', '', 'http://www.spip-contrib.net/Framework-Tripoli', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:1:{i:0;a:4:{s:3:"nom";s:1:"Z";s:2:"id";s:1:"Z";s:7:"version";s:8:"[1.2.0;]";s:13:"compatibilite";s:8:"[1.2.0;]";}}}}', '2011-10-11 11:10:59', '2011-10-11 11:10:59', 1, 'theme_tripoli.zip', 14580, '2011-10-11 12:01:26', '_themes_/zpip-1/tripoli', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '198eb92999b44e1caa92505d1a5a6fa8'),
(388, 374, 'THEME_BROWNIE', 'http://files.spip.org/spip-zone/theme_brownie.png', '002.000.000', '', '[3.0.0;3.0.*]', '3.0', '<multi>\n[fr]Brownie est un th�me responsive pour SPIP 3 qui fonctionne tr�s bien pour la cr�ation d\'un blog\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:10:"Christophe";s:3:"url";s:25:"http://www.openstudio.fr/";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:22:"eGrappler.com (Design)";s:3:"url";s:84:"http://www.egrappler.com/free-responsive-html5-portfolio-business-template/blog.html";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:4:"2012";}', 'http://www.spip-contrib.net/Brownie', 'http://brownie.openstudio.fr/', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:5:"zcore";a:2:{s:3:"nom";s:5:"zcore";s:13:"compatibilite";s:12:"[2.0.0-dev;[";}s:9:"zengarden";a:2:{s:3:"nom";s:9:"zengarden";s:13:"compatibilite";s:8:"[2.4.2;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:10:"socialtags";a:2:{s:3:"nom";s:10:"socialtags";s:13:"compatibilite";s:9:"[0.9.16;]";}s:5:"menus";a:2:{s:3:"nom";s:5:"menus";s:13:"compatibilite";s:8:"[1.2.1;]";}}}}', '2012-06-20 21:00:15', '2012-06-20 21:00:15', 1, 'theme_brownie.zip', 91088, '2012-06-20 21:00:16', '_themes_/zpip-2/Brownie', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'fdf46911f05d4d2fefce84e6d0ff825d'),
(442, 450, 'ABOMAILMANS', 'http://files.spip.org/spip-zone/abomailmans.png', '001.001.002', '0.34', '[3.0.0;3.0.*]', '3.0', '<multi>\n[de]Dieses Plugin ermöglich mit dem TAG #FORMULAIRE_ABOMAILMAN das Abnonnieren von Mailinglisten.\n			Dem Adminstrator steht ein Interface zur Verwaltung dieser Listen zur Verfügung.\n[en]This plugin adds a registration form to mailing lists and newsletters services as [Mailman->http://www.gnu.org/software/mailman/], [Ezmlm->http://www.ezmlm.org/] or [Sympa->http://www.sympa.org].\n\nThe administrator can manage the lists from the private space via a dedicated interface.\n[fr]Ce plugin permet via une balise #FORMULAIRE_ABOMAILMAN d\'afficher un formulaire d\'abonnement à l''ensemble des listes [Mailman->http://www.gnu.org/software/mailman/], [Ezmlm->http://www.ezmlm.org/] ou [Sympa->http://www.sympa.org] renseign�es.\n_ Cette inscription se fait via l''interface priv�e de SPIP par le menu "Edition Abomailmans les listes de diffusions mailman".\n_ Ensuite il vous est possible de s�lectionner des articles de votre SPIP, par des crit�res de date, de rubrique et/ou de mot-cl� et envoyer leurs contenus à ces listes, en utilisant des squelettes de mise en page du contenu.\n_ Le lien avec les listes Mailman, Ezmlm et Sympa se fait par des envois d\'e-mail.\n[sk]Tento zásuvný modul umožſuje pomocou tagu #FORMULAIRE_ABOMAILMAN zobraziť formulár na prihlásenie sa na odoberanie príspevkov cel�ho radu typov skupín (resp. konferencií)  [Mailman,->http://www.gnu.org/software/mailman/] [Ezmlm->http://www.ezmlm.org/] alebo [Sympa.->http://www.sympa.org] \n_ Registrácia sa vykonáva cez súkromnú zónu SPIPu pomocou menu "ÿprava skupín typu mailman".\n_ Potom si zo svojej stránky v SPIPe m�žete vybrať články  podľa dátumu, rubriky a/lebo kľúčov�ho slova a poslať ich do týchto skupín (resp. konferencií, mailing listov) pomocou šablón na úpravu vzhľadu textu.\n_ Odkaz na skupiny Mailman, Ezmlm a Sympa získate odoslaním e-mailu.\n</multi>', 'a:4:{i:1;a:3:{s:3:"nom";s:8:"NetAktiv";s:3:"url";s:23:"http://www.netaktiv.com";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:18:"Anne-lise Martenot";s:3:"url";s:23:"http://www.elastick.net";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:5:"Yffic";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:4;a:3:{s:3:"nom";s:5:"kent1";s:3:"url";s:21:"http://www.kent1.info";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:6:"GPL v3";s:3:"url";s:0:"";}}', '', 'http://www.spip-contrib.net/Abomailmans-pour-s-abonner-a-des-listes-de-diffusion', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:7:"facteur";a:2:{s:3:"nom";s:7:"facteur";s:13:"compatibilite";s:8:"[2.0.0;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-04 15:00:02', '2012-09-04 15:00:02', 1, 'abomailmans.zip', 58856, '2012-09-04 15:00:04', '_plugins_/abomailmans/trunk', 'a:2:{s:11:"abomailmans";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"de";a:0:{}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}s:18:"paquet-abomailmans";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:9:"salvatore";s:7:"langues";a:4:{s:2:"de";a:0:{}s:2:"en";a:1:{i:0;a:2:{s:3:"nom";s:5:"kent1";s:4:"lien";s:33:"http://trad.spip.net/auteur/kent1";}}s:2:"fr";a:0:{}s:2:"sk";a:1:{i:0;a:2:{s:3:"nom";s:4:"jaro";s:4:"lien";s:32:"http://trad.spip.net/auteur/jaro";}}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'bff4e3b481614528107c35b9a62824ec'),
(430, 26, 'ACCESRESTREINT', 'prive/themes/spip/images/zone-32.png', '003.006.002', '0.4.1', '[3.0.0;3.0.*]', '3.0', '<multi>[de]_ Jeder Bereich enthält Rubriken.\r\n_ Einzelnen Autoren können Zugangsrechte für Bereiche zugeordnet werden.\r\n_ ALle Standardschleifen (Abfragen) von SPIP werden überladen, und um die ÿberprüfung der Rechte des jeweiligen Sitebesuchers ergänzt.[en]_ Each area contains sections.\r\n_ Authors can be associated with these areas to gain access to them.\r\n_ All SPIP''s loops are loaded with the necessary tools to filter the results according to the visitors'' access priviliges.[es]_ Cada zona contiene secciones.\r\n_ Los autores podrán ser asociados a ciertas zonas restringidas para tener derechos de acceso a ellas.\r\n_ Todos los bucles nativos de SPIP quedan modificados para filtrar los resultados en función de los derechos del visitante.[fr]_ Chaque zone contient des rubriques.\r\n\r\n_ Les auteurs peuvent etre associ�s à des zones pour avoir le droit d\'y acc�der.\r\n\r\n_ Toutes les boucles natives de SPIP sont surcharg�es pour en filtrer les r�sultats en fonction des droits du visiteur.</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:12:"Cedric Morin";s:3:"url";s:22:"http://www.yterium.net";s:4:"mail";s:27:"cedric.morin AT yterium.com";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2007-2008";}', 'http://www.spip-contrib.net/Acces-Restreint-3-0', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'auto/accesrestreint_3_5', '', 'oui', 'oui', 0, '', 'non', 'non', 'non', '_DIR_PLUGINS', '847dc87ae7efdeaf2bc4bf13b653527b'),
(532, 449, 'EOLECAS', './eolecas.gif', '001.000', '', '[3.0.0;3.0.*]', '3.0', '', 'a:1:{i:1;a:3:{s:3:"nom";s:11:"Equipe EOLE";s:3:"url";s:27:"http://dev-eole.ac-dijon.fr";s:4:"mail";s:0:"";}}', '', '', '', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:4:"spip";a:2:{s:3:"nom";s:4:"SPIP";s:13:"compatibilite";s:14:"[3.0.0 ;3.0.*]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'eolecas', '', 'oui', 'non', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '0c26b2d614351b7937b3e88e76cf00a6'),
(531, 81, 'COUTEAU_SUISSE', 'img/couteau-50.gif', '001.008.098', '1.8', '[1.9.2;3.0.99]', '1.9,2.0,2.1,3.0', '<multi>[en]Combines in one plugin a list of small and useful new features improving the management of your SPIP site.\n\nEach of these tools can be enabled or disabled by the user on [the plugin administration page->./?exec=admin_couteau_suisse] and manage a number of variables: click {{Configuration}}, then select the tab Couteau Suisse.\n\nThe categories are: Administration, Security, Private interface, text enhancements, Typographical shortcuts, Display public, Tags, filters, criteria.\n\nCheck out this plugin in your favorite tools: {Removes the number}, {URLs Format}, {Typographical superscript}, {Smart Quotes}, {Beautiful bullets}, {Fight against SPAM}, {Mailcrypt}, {Beautiful URLs} , {SPIP and external links...}, {Smileys}, {A summary for your articles}, {cut in pages and tabs}, etc.., etc..\n\nFeel free to consult the articles of plugin documentation that are published on: [spip-contrib.net->http://www.spip-contrib.net/Le-Couteau-Suisse].\n\nCompatibility: SPIP v1.92x, v2.x.x and v3.0[fr]R�unit en un seul plugin une liste de petites fonctionnalit�s nouvelles et utiles am�liorant la gestion de votre site SPIP.\n\nChacun de ces outils peut �tre activ� ou non par l''utilisateur sur [la page d\'administration du plugin->./?exec=admin_couteau_suisse] et g�rer un certain nombre de variables : cliquer sur {{Configuration}}, puis choisir l''onglet {{Le Couteau Suisse}}.\n\nLes cat�gories disponibles sont : Administration, S�curit�, Interface priv�e, Am�liorations des textes, Raccourcis typographiques, Affichage public, Balises, filtres, crit�res.\n\nD�couvrez dans ce plugin vos outils favoris : {Supprime le num�ro}, {Format des URLs}, {Exposants typographiques}, {Guillemets typographiques}, {Belles puces}, {Lutte contre le SPAM}, {Mailcrypt}, {Belles URLs}, {SPIP et les liens... externes}, {Smileys}, {Un sommaire pour vos articles}, {D�coupe en pages et onglets}, etc., etc.\n\nN''h�sitez pas � consulter les articles de documentation du plugin publi�s sur : [spip-contrib.net->http://www.spip-contrib.net/Le-Couteau-Suisse].\n\nCompatibilit� : SPIP v1.92x, v2.x.x et v3.0[sk]V�jednom z�suvnom module sp�ja ve�a mal�ch nov�ch a u�ito�n�ch funkci� zlep�uj�cich riadenie va�ej str�nky v�SPIPe.\n\nKa�d� z�t�chto n�strojov m��e pou��vate� aktivova� alebo deaktivova� [na riadiacej str�nke z�suvn�ho modulu->./?exec=admin_couteau_suisse] a vybera� si z�ur�it�ho po�tu premenn�ch: kliknite na {{Konfigur�ciu,}} potom vyberte kartu {{Vreckov� no��k.}}\n\nK�dispoz�cii s� tieto kateg�rie: Riadenie, Zabezpe�enie, S�kromn� rozhranie, Vylep�enie textov, Kl�vesov� skratky, Zobrazenie na verejne pr�stupnej str�nke, Tagy, filtre, krit�ri�.\n\nObjavte svoje ob��ben� n�stroje v�tomto z�suvnom module: {vymazanie ��sla}, {form�t internetov�ch adries}, {kl�vesov� indexy}, {inteligentn� �vodzovky}, {pekn� odr�ky}, {boj proti SPAMU}, {�ifrovanie po�ty}, {pekn� internetov� adresy}, {SPIP a�extern� odkazy...}, {smajl�ky}, {zhrnutie �l�nku}, {vystrihovanie na str�nkach a�kart�ch} a�tak �alej, a�tak �alej.\n\nPokojne si pre��tajte dokument�ciu k�z�suvn�mu modulu publikovan� na str�nke: [spip-contrib.net.->http://www.spip-contrib.net/Le-Couteau-Suisse]\n\nKompatibilita: SPIP v1.92x, v2.x.x a�v3.0</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:33:"Patrice Vanneufville~�~2007-2012";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:301:"Collectif SPIP, Vincent Ramos, Ma�eul Rouquette, Fil, Arnaud Ventre, Joseph Larmarange, Cerdic, Pierre Andrews (Mortimer), IZO, Phil, J�r�me Combaz, Bertrand Marne, T�tue, Aur�lien Pierard, FredoMkb, Sylvain, BoOz, Alexis Roussel, Paolo, PatV, Yohann(potter64), Nicolas Hoizey, Piero Wbmstr, etc.";s:3:"url";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2007-2012";}', 'http://www.spip-contrib.net/Le-Couteau-Suisse', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'couteau_suisse', '', 'oui', 'oui', 1, '001.008.100', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', '04be585fab957069aeff1a5653a88383'),
(434, 278, 'EVA_AGENDA', 'prive/themes/spip/images/logo_eva3_fb.png', '004.002.001', '', '[2.9.9;3.0.99]', '', '<multi>[fr]La rubrique s⿿affiche sous forme d⿿agenda lorsqu⿿on lui joint le mot cl� {{agenda}}.\r\nLes articles sont inscrits dans l⿿agenda en leurs attribuant une date de r�daction ant�rieure correspondant à la date de l⿿�v�nement concern�.</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:49:"Olivier Gautier,�quipe de d�veloppement EVA-web";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://spip.ac-rouen.fr/?Agenda-calendrier-et-mini', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:13:"evasquelettes";a:2:{s:3:"nom";s:13:"evasquelettes";s:13:"compatibilite";s:6:"[4.2;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'auto/eva_agenda_pour_spip_3_0', '', 'oui', 'oui', 0, '', 'non', 'non', 'non', '_DIR_PLUGINS', 'd0bd5e04cccfbe771294eb09ce9ea313'),
(435, 280, 'EVA_CALENDRIER', 'prive/themes/spip/images/logo_eva3_fb.png', '004.002.001', '', '[2.9.9;3.0.99]', '', '<multi>[fr]Affichage d⿿une rubrique sous forme de calendrier mensuel avec syst�me de navigation vers les mois pr�c�dents et suivants.\r\nLa rubrique s⿿affiche sous forme de calendrier d�s lors qu⿿on lui joint le mot cl� {{calendrier}}.\r\nLes articles sont inscrits dans le calendrier en leurs attribuant une date de r�daction ant�rieure correspondant à la date de l⿿�v�nement concern�.</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:49:"Olivier Gautier,�quipe de d�veloppement EVA-web";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://spip.ac-rouen.fr/?Agenda-calendrier-et-mini', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:13:"evasquelettes";a:2:{s:3:"nom";s:13:"evasquelettes";s:13:"compatibilite";s:6:"[4.2;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'auto/eva_calendrier_pour_spip_3_0', '', 'oui', 'oui', 0, '', 'non', 'non', 'non', '_DIR_PLUGINS', '0d257001ddb9aa9e926cafff378e82f3'),
(436, 281, 'EVA_HABILLAGE', 'prive/themes/spip/images/logo_eva3_fb.png', '004.002', '2012.1.1', '[2.9.9;3.0.99]', '', '<multi>[fr]Gestion automatique des habillages d⿿EVA-web 4.2 par un administrateur du site.</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:181:"Olivier Gautier, Samuel Bocharel,�quipe de d�veloppement EVA-web.\nThomas Delhomenie pour l⿿am�lioration de la page des r�gles CSS.\n Mise à jour pour SPIP 3 : Olivier Gautier.";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://evaweb.fr', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:13:"evasquelettes";a:2:{s:3:"nom";s:13:"evasquelettes";s:13:"compatibilite";s:6:"[4.2;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'auto/eva_habillage_pour_spip_3_0', '', 'oui', 'oui', 0, '', 'non', 'non', 'non', '_DIR_PLUGINS', '18c9c00b1829078ef32258b6dd09022b'),
(437, 282, 'EVA_INSTALL', 'prive/themes/spip/images/logo_eva3_fb.png', '004.002', '', '[2.9.9;3.0.99]', '', '<multi>[fr]Permet de cr�er les mots cl�s n�cessaires à l⿿utilisation du squelette eva-web\r\net de g�rer les informations li�es à la page de mentions l�gales.\r\n\r\nCe plugin cr�� d⿿abord les groupes puis les mots cl�s tout en v�rifiant que ceux-ci n⿿existe pas avant. L⿿utilisation de chaque mot cl� est pr�cis� dans chaque descriptif.\r\n\r\nUne fois activ�e et les mots cl�s cr��s, ce plugin peut être d�sinstall�.</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:113:"Samuel Bocharel, Olivier Gautier,�quipe de d�veloppement Eva-WEB. Mise à jour pour SPIP 3 par Olivier Gautier.";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://evaweb.fr', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:1:{s:13:"evasquelettes";a:2:{s:3:"nom";s:13:"evasquelettes";s:13:"compatibilite";s:6:"[4.2;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'auto/eva_install_pour_spip_3_0', '', 'oui', 'oui', 0, '', 'non', 'non', 'non', '_DIR_PLUGINS', 'd8b7e0d940d3f0adf6857f1948823416'),
(438, 284, 'EVAMENTIONS', 'prive/themes/spip/images/evamentions-32.png', '004.002.000', '', '[2.9.9;3.0.99]', '', '<multi>[fr]Le contenu des mentions l�gales sera affich� en page mentions (et �ventuellement dans le pied de page).</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:38:"Olivier Gautier, d�veloppeur EVA-web.";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:49:"Samuel Bocharel,�quipe de d�veloppement Eva-WEB";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:13:"Johan Pustoch";s:3:"url";s:39:"http://www.spip-contrib.net/?auteur7949";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://evaweb.fr', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'auto/eva_mentions_pour_spip_3_0', '', 'oui', 'oui', 0, '', 'non', 'non', 'non', '_DIR_PLUGINS', '4b6655344cab8dfa51f3b457dc3279eb'),
(439, 286, 'EVASQUELETTES', 'images/logo_eva3_fb.png', '004.002', '', '[2.9.9;3.0.99]', '', '<multi>[fr]Un squelette de portail d⿿Etablissement, destin�e à une �cole, un �tablissement du second degr�, mais aussi une association, un individuel afin de mettre en place un site web collaboratif proposant diff�rents mod�les de publication (article, livre-album, portfolio, activit�s, fichiers ...).</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:95:"Equipe Eva-dev, Aideà la traduction : Eric Le Jan. Mise à jour pour SPIP 3 : Olivier Gautier.";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.evaweb.fr', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'auto/eva_squelettes_pour_spip_3_0', '', 'oui', 'oui', 0, '', 'non', 'non', 'non', '_DIR_PLUGINS', 'f4ff9aee1e13fd34639cb6a0cf00caec'),
(440, 149, 'PLAYER', 'prive/themes/spip/images/player-32.png', '002.001.001', '0.2.4', '[3.0.0;3.0.*]', '3.0', '<multi>[en]This plugin allows to read and display sounds and videos.\nIt adds flash player suitable the formats .mp3.\nIt works on all <code><docXX|player></code> inserted in the texts, as well as in the templates.\n\n-* In a text, <code><docXX|player></code>, displays a flash audio player (several players to choose from);\n-* In a template <code>#MODELE{playliste}</code> displays a playlist of the latest mp3[fa]??? ?????? ?? ??? ????? ?????? ??? ? ????? ?? ??????? ? ????? ????. \n?????? ???? ?????? ????? ???? ??.??.3 (.mp3) ?? ????? ??????. \n\n??? ?????? ??? ???? <code><docXX|player></code> ?? ?? ?????? ? ??? ?? ????????? ?????? ??? ????? ??? ?????? \n-* ?? ????  <code><docXX|player></code>,  ?? ???? ????? ?????? (??? ?????? ???? ?????? ?? ???? ?????) ?? ???? ???????\n-* ?? ?? ??????? <code>#MODELE{playliste}</code> ?? ????? ???  ?? ????? ???.??.3 ?? ???? ??????[fr]Ce plugin permet la lecture et l''affichage de sons ou de vid�os.\nIl ajoute des lecteurs flash adapt�s aux formats .mp3.\nIl agit sur tous les <code><docXX|player></code> ins�r�s dans les textes, aussi bien que dans les squelettes.\n\n-* Dans un texte <code><docXX|player></code> affiche un lecteur flash audio (plusieurs lecteurs au choix);\n-* Dans un squelette <code>#MODELE{playliste}</code> permet d\'afficher une playliste des derniers mp3[ru]?????? ????????? ??????????? ????? ? ????? ????? ?? ?????. ?? ????????? ???? ????? ?????????????? ?????? mp3.\n\n????? ????????? ??? ?????? ????????? ????? <code><docXX|player></code> ??? ? ??????, ??? ? ? ???????.\n\n-* ? ?????? ?? ????? <code><docXX|player></code> ????????? ??? flash ????? (???? ????????? ????????? ????? ?? ?????);\n-* ? ??????? <code>#MODELE{playliste}</code> ?????????? ?????? ????????? mp3 ??????[sk]Tento zásuvný modul umož?uje prehrávanie a zobrazenie zvukov alebo videí.\nPridáva údaje zo zariadení USB vo formáte .mp3.\nFunguje na všetkých <code><docXX|player></code> vložených v texte, ako aj v šablónach.\n\n-* v texte <code><docXX|player></code> zobrazí údaje zo zariadení USB (m�žete si vybra? z viacerých zariadení),\n-* v šablóne <code>#MODELE{playliste}</code> umož?uje zobrazi? zoznam skladieb z posledných mp3</multi>', 'a:4:{i:1;a:3:{s:3:"nom";s:4:"BoOz";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:7:"C�dric";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:9:"erational";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:4;a:3:{s:3:"nom";s:3:"CP.";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', '', '', 'http://www.spip-contrib.net/Lecteur-Multimedia', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'auto/lecteur_multimedia-2', '', 'oui', 'oui', 0, '', 'non', 'non', 'non', '_DIR_PLUGINS', '717afa68d95482abfbc97ae5b0df9ed0'),
(441, 234, 'SPIP_BONUX', 'img_pack/spip-bonux.png', '003.000.002', '', '[3.0.0-dev;3.1.*]', '3.0,3.1', '<multi>[ar]?????? ???? ???? SPIP ???? ?????? ?? SPIP? ????? ????? ?????!\n?????? ??????? ???.[en]The plugin that make SPIP better than SPIP, with nice gifts inside !\n	arrays, counter, etc.[fr]Le plugin qui lave plus SPIP que SPIP, avec des chouettes cadeaux dedans !\n	Tableaux, compteur, etc.[ru]SPIP Bonux ????????? ??? ?????? ?????? ?????? ????????. ?? ??????????? ????????? ??????????? SPIP, ????? ??? ????? ??? SPIP :)))[sk]Zásuvný modul, ktorý pre?istí SPIP ako SPIP s peknými dar?ekmi vnútri!\n	Tabu?ky, po?ítadlo, a i.</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:12:"Cedric Morin";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:14:"romy.tetue.net";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2008-2011";}', 'http://www.spip-contrib.net/SPIP-Bonux', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'auto/spip-bonux-3', '', 'oui', 'non', 0, '003.000.003', 'non', 'non', 'non', '_DIR_PLUGINS', '87ec63abf1c30046326ff63fe0698f68'),
(492, 493, 'SCOLASPIP', 'http://files.spip.org/spip-zone/scolaspip_3_0.png', '003.000.020', '', '[3.0.0-beta2;3.1.*[', '3.0,3.1', '<multi>\n[fr]ScolaSPIP est destin� aux webmestres d�butants et permet facilement de personnaliser un site SPIP : à partir du menu « Squelettes » une interface permet de choisir ses couleurs, options d⿿affichage de la page d⿿accueil et des contenus. Des mots-cl�s permettent ensuite de personnaliser les menus et contenus.\n</multi>', 'a:3:{i:1;a:3:{s:3:"nom";s:13:"Johan Pustoch";s:3:"url";s:35:"http://contrib.spip.net/?auteur7949";s:4:"mail";s:38:"johan.pustoch AT crdp.ac-versailles.fr";}i:2;a:3:{s:3:"nom";s:3:"JSB";s:3:"url";s:33:"http://contrib.spip.net/?auteur93";s:4:"mail";s:33:"barboteu AT crdp.ac-versailles.fr";}i:3;a:3:{s:3:"nom";s:13:"Philippe Roca";s:3:"url";s:0:"";s:4:"mail";s:38:"philippe.roca AT crdp.ac-versailles.fr";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:69:"Wahid Mendil pour le logo ScolaSPIP (plac� sous licence CC BY-NC-SA)";s:3:"url";s:0:"";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2008-2012";}', 'http://contrib.spip.net/?article4128', 'http://www.tice.ac-versailles.fr/scolaspip/', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:1:"Z";a:2:{s:3:"nom";s:1:"Z";s:13:"compatibilite";s:14:"[1.7.17;1.7.*]";}s:11:"evamentions";a:2:{s:3:"nom";s:11:"evamentions";s:13:"compatibilite";s:13:"[4.2.0;4.2.*]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:2:{s:6:"Agenda";a:2:{s:3:"nom";s:6:"Agenda";s:13:"compatibilite";s:13:"[3.6.0;3.9.*]";}s:13:"onglets_texte";a:2:{s:3:"nom";s:13:"onglets_texte";s:13:"compatibilite";s:9:"[1.0;1.*]";}}}}', '2012-09-19 11:00:02', '2012-09-19 11:00:02', 1, 'scolaspip_3_0.zip', 162552, '2012-09-19 11:00:02', '_squelettes_/scolaspip/trunk', 'a:1:{s:9:"scolaspip";a:2:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '349c99f3ccdc56bb3bfa5bfcf554de3f'),
(493, 494, 'Z', 'http://files.spip.org/spip-zone/zpip_v1.png', '001.007.021', '', '[2.0.10;3.0.99]', '2.0,2.1,3.0', 'Zpip est issu d\'une fusion des projets Zesty et SPIP-Zen. Zpip-dist est la version de base de ce mod�le de squelette, que vous pouvez utiliser telle quelle ou personnaliser et enrichir selon vos besoins.\n\nPlus qu''un squelette, Zpip est un exemple d\'un syst�me de squelette qui met en application les id�es expos�es dans [Mod�le de squelette r�utilisable->http://www.spip-contrib.net/Modele-de-squelette-reutilisable]. Il propose une organisation des squelettes visant à le rendre :\n-* {{habillable}} par des th�mes ind�pendants du squelette\n-* {{maintenable}} dans le temps, par une duplication minimale du code\n-* {{rapidement d�ployable}}, au prix d\'un petit apprentissage initial sur son organisation\n\nZpip s''adresse aussi bien aux d�butants qui veulent profiter d\'une galerie de th�mes prêts à l''emploi, qu''aux webmestres avanc�s auxquels il propose un fonctionnement et des m�canismes productifs.\n\nToute l''organisation et le fonctionnement de Zpip peuvent être r�utilis�s pour construire de nouveaux squelettes qui b�n�ficieront des mêmes avantages.', 'a:4:{i:0;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:1;a:3:{s:3:"nom";s:13:"C�dric Morin";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:11:"Romy Têtue";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:3;a:3:{s:3:"nom";s:14:"Collectif SPIP";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:0;a:2:{s:3:"nom";s:5:"GPL 3";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://www.spip-contrib.net/Le-Squelette-Zpip-dist', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-06 13:00:03', '2012-09-06 13:00:03', 1, 'zpip_v1.zip', 76416, '2012-09-06 13:00:04', '_squelettes_/zpip-dist/branches/zpip_v1', 'a:1:{s:4:"zpip";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:6:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"es";a:0:{}s:2:"nl";a:0:{}s:2:"pt";a:0:{}s:2:"sv";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'fd906c87923f60bf6917f016202a062b'),
(494, 495, 'INITIALIZR', 'http://files.spip.org/spip-zone/theme_initializr.png', '001.001.001', '', '[v3;]', '1.9,2.0,2.1,3.0,3.1', '', 'a:1:{i:1;a:3:{s:3:"nom";s:18:"Anne-lise Martenot";s:3:"url";s:23:"http://www.elastick.net";s:4:"mail";s:23:"contact AT elastick.net";}}', 'a:1:{i:1;a:2:{s:3:"nom";s:14:"initializr.com";s:3:"url";s:21:"http://initializr.com";}}', '', '', 'http://contrib.spip.net/4221', 'http://initializr.com', '', 'test', 3, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:5:"Zcore";a:2:{s:3:"nom";s:5:"Zcore";s:13:"compatibilite";s:8:"[2.0.0;]";}s:2:"Z5";a:2:{s:3:"nom";s:2:"Z5";s:13:"compatibilite";s:8:"[2.0.0;]";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '2012-09-17 12:00:27', '2012-09-17 12:00:27', 1, 'theme_initializr.zip', 39491, '2012-09-17 12:00:28', '_themes_/zpip-2/Initializr', 'a:0:{}', 'non', 'non', 0, '', 'non', 'non', 'non', '', '1a9d9ddc16d8406c6baf1f119103a55c'),
(530, 57, 'CFG', 'prive/themes/spip/images/cfg-128.png', '003.000.000', '', '[3.0.0-beta;3.0.*]', '3.0', '<multi>[fr]Augmente les possibilit�s de gestion de configuration pour d\'autres plugins\n		en fournissant un mode de stockage PHP.\n\n		Attention : une partie du fonctionnement de CFG pour SPIP 2 a �t� int�gr�e dans SPIP 3 de fa�on\n		l�g�rement diff�rente. Il est n�cessaire de migrer les plugins qui utilisaient CFG pour SPIP 2.\n		La plupart n''auront plus besoin de ce plugin pour g�rer leur configurations.</multi>', 'a:2:{i:1;a:3:{s:3:"nom";s:15:"Bertrand Gugger";s:3:"url";s:0:"";s:4:"mail";s:0:"";}i:2;a:3:{s:3:"nom";s:19:"Matthieu Marcillaud";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:3:"GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', 'a:1:{i:1;s:9:"2008-2011";}', '', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'cfg', '', 'oui', 'non', 1, '', 'non', 'non', 'non', '_DIR_PLUGINS_DIST', 'b893ce1472495381296cdfb2f4701134'),
(496, 279, 'EVABONUS', 'prive/themes/spip/images/logo_eva_bonus.png', '004.002', '', '[2.9.9;3.0.99]', '', '<multi>[fr]Noisettes suppl�mentaires pour les squelettes EVA-web,...</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:38:"Olivier Gautier, d�veloppeur EVA-web.";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://evaweb.fr', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:1:{i:0;a:2:{s:13:"evasquelettes";a:2:{s:3:"nom";s:13:"evasquelettes";s:13:"compatibilite";s:6:"[4.2;[";}s:13:"eva_habillage";a:2:{s:3:"nom";s:13:"eva_habillage";s:13:"compatibilite";s:6:"[4.2;[";}}}s:9:"librairie";a:0:{}s:7:"utilise";a:0:{}}', '0000-00-00 00:00:00', '0000-00-00 00:00:00', 0, '', 0, '0000-00-00 00:00:00', 'auto/eva_bonus_pour_spip_3_0', '', 'oui', 'oui', 29, '', 'non', 'non', 'non', '_DIR_PLUGINS', 'c7bd7522d67c84b214d391c51238c2f3'),
(529, 277, 'ESCAL', 'http://files.spip.org/spip-zone/escal_V3.png', '003.054.008', '', '[2.10.0;[', '2.1,3.0,3.1', '<multi>\n[fr]Adapt� pour la version 3 de SPIP, il propose :\r\n-* une configuration pouss�e dans l''espace priv�\r\n-* une mise en page param�trable en 2 ou 3 colonnes par le choix d\'une feuille de style\r\n-* une gestion du multilinguisme\r\n-* un forum simple style phpBB\r\n-* un large choix de noisettes � garder ou pas, certaines �tant redondantes : identification, menu horizontal et/ou vertical.\r\n-* place, couleur et contenu des blocs lat�raux faciles � changer\r\n-* un menu horizontal et/ou vertical (2 au choix) d�roulants avec mise en valeur de la rubrique courante\r\n-* une redirection automatique vers l''article s''il est seul dans sa rubrique\r\n-* une navigation par mots-cl�s\r\n-* un calendrier et/ou une liste d''�v�nements\r\n-* un affichage des derniers articles ou des articles dans la m�me rubrique\r\n-* un affichage des sous-rubriques et des articles dans chaque page rubrique\r\n-* un affichage des forums des articles\r\n-* un formulaire de contact des auteurs s''ils ont indiqu� leur e-mail\r\n-* une page contact �labor�e\r\n-* un plan du site\r\n-* un fichier backend pour la syndication du site\r\n-* une feuille de style sp�ciale pour l''impression des articles\r\n-* une zone de connexion en page d\'accueil (2 choix possibles d\'affichage)\r\n-* un ensemble valide XHTML Strict 1.0\n</multi>', 'a:1:{i:1;a:3:{s:3:"nom";s:26:"Jean-Christophe Villeneuve";s:3:"url";s:0:"";s:4:"mail";s:0:"";}}', '', 'a:1:{i:1;a:2:{s:3:"nom";s:7:"GNU/GPL";s:3:"url";s:40:"http://www.gnu.org/licenses/gpl-3.0.html";}}', '', 'http://projetice.crdp.ac-lyon.fr/escal/', '', '', 'stable', 4, 'a:3:{s:9:"necessite";a:0:{}s:9:"librairie";a:0:{}s:7:"utilise";a:1:{i:0;a:4:{s:7:"palette";a:2:{s:3:"nom";s:7:"palette";s:13:"compatibilite";s:8:"[2.0.0;[";}s:8:"shoutbox";a:1:{s:3:"nom";s:8:"shoutbox";}s:14:"calendriermini";a:1:{s:3:"nom";s:14:"calendriermini";}s:8:"spip_400";a:1:{s:3:"nom";s:8:"spip_400";}}}}', '2012-09-25 21:00:09', '2012-09-25 21:00:09', 1, 'escal_V3.zip', 764861, '2012-09-25 21:00:12', '_squelettes_/escal/branche_V3', 'a:1:{s:5:"escal";a:3:{s:9:"reference";s:2:"fr";s:12:"gestionnaire";s:0:"";s:7:"langues";a:7:{s:2:"de";a:0:{}s:2:"en";a:0:{}s:2:"eo";a:0:{}s:2:"es";a:0:{}s:2:"it";a:0:{}s:2:"lv";a:0:{}s:2:"nl";a:0:{}}}}', 'non', 'non', 0, '', 'non', 'non', 'non', '', 'c31bc71f8564946e3e3177d24d84f480');
 

		-- Table spip_petitions
		ALTER TABLE `spip_petitions`
		AUTO_INCREMENT = 1;
		ALTER TABLE `spip_petitions`
		DROP PRIMARY KEY,
		ADD `id_petition` bigint(21) NOT NULL auto_increment,
		ADD PRIMARY KEY  (`id_petition`),
		ADD  UNIQUE KEY `id_article` (`id_article`);


		-- Table spip_plugins
		CREATE TABLE IF NOT EXISTS `spip_plugins` (
		  `id_plugin` bigint(21) NOT NULL auto_increment,
		  `prefixe` varchar(30) NOT NULL default '',
		  `nom` text NOT NULL,
		  `slogan` text NOT NULL,
		  `categorie` varchar(100) NOT NULL default '',
		  `tags` text NOT NULL,
		  `vmax` varchar(24) NOT NULL default '',
		  `date_crea` datetime NOT NULL default '0000-00-00 00:00:00',
		  `date_modif` datetime NOT NULL default '0000-00-00 00:00:00',
		  `compatibilite_spip` varchar(24) NOT NULL default '',
		  `branches_spip` varchar(255) NOT NULL default '',
		  PRIMARY KEY  (`id_plugin`),
		  KEY `prefixe` (`prefixe`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=403 ;

		INSERT INTO `spip_plugins` (`id_plugin`, `prefixe`, `nom`, `slogan`, `categorie`, `tags`, `vmax`, `date_crea`, `date_modif`, `compatibilite_spip`, `branches_spip`) VALUES
(396, 'TW', 'TextWheel pour SPIP', '<multi>[ar]ÿ¥ÿ¯ÿ§ÿ±ÿ© ÿ§ÿ⿿ÿƿÿªÿ§ÿ¨ÿ© ÿÿŠ SPIP ÿ¨ÿ˿ÿ§ÿ³ÿ·ÿ© TextWheel[de]Typographie in SPIP mit TextWheel steuern[en]Management of SPIP typography with TextWheel[es]Administraci�³n de la tipograf�­a SPIP con TextWheel[fa]ÿ⿦ÿ¯ÿŠÿ±ÿŠÿª ÿ­ÿ±ÿ˿ÿâ⿬ſÿ⿠ÿ¯ÿ§ÿ±ÿŠ ÿ¯ÿ± ÿ§ÿ³ÿ¾ÿŠÿ¾ ÿ¨ÿ§ ÿ⿠ÿ±ÿ®â⿬ſÿ⿠ÿ˿ÿŠÿ³[fr]Gestion de la typographie SPIP avec TextWheel[it]Gestione della tipografia di SPIP con TextWheel[ru]Ð£Ð¿ÿ⿬Ð°Ð²Ð»ÿÿ⿿ÿſ Ð¾ÿ⿿Ð¾ÿ⿬Ð¼Ð»ÐµÐ½Ð¸ÐµÐ¼ SPIP c Ð¿Ð¾Ð¼Ð¾ÿ⿰ÿſÿŽ TextWheel[sk]Spr�¡va typografie SPIPu sÿ modulom TextWheel</multi>', 'edition', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(397, 'URLS', 'Urls Etendues', '<multi>[ar]ÿ¥ÿ¯ÿ§ÿ±ÿ© ÿªÿ⿠ÿ˿ÿ¹ÿ§ÿª ÿ¹ÿ⿠ÿ§ÿ˿ÿŠÿ⿠ URL ÿ°ÿ§ÿª ÿ§ÿ⿿ÿ⿦ÿ¹ÿ⿠ÿ⿰ ÿ§ÿ⿦ ÿ⿿ÿ§[de]Verwaltung von URL-Varianten[en]Management of the URL variants, meaningful or not[fa]ÿ⿦ÿ¯ÿŠÿ±ÿŠÿª ÿŠÿ˿.ÿ¢ÿ±.ÿ§ÿ⿿â⿬ſÿ⿡ÿ§ÿŠ ÿ⿦ÿ⿡ÿ⿦ ÿŠÿ§ ÿºÿŠÿ±ÿ⿦ÿ⿡ÿ⿦[fr]Gestion des variantes d\'URL signifiantes ou non[it]Gestione delle varianti significative URL, o non[pt_br]Gerenciamento das variantes de URLs significantes ou n�£o[ru]SEO-friendly URLs (Ð§ÐŸÐ£ ÿÿÿ⿹Ð»ÐºÐ¸)[sk]Riadenie variantov URL, ÿi uÿ¾ s�mantick�½ch, alebo nie</multi>', 'statistique', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(395, 'SVP', 'SVP', '<multi>[ar]ÿ®ÿ§ÿ¯ÿ⿦ ÿ⿦ÿ¹ÿ⿿ÿ˿ÿ⿦ÿ§ÿª ÿ§ÿ⿿ÿ⿦ÿ⿿ÿ­ÿ⿿ÿ§ÿª ÿ˿ÿªÿ­ÿ⿦ÿŠÿ⿿ÿ⿡ÿ§[de]Informations- und Download-SerVer f�¼r Plugins[en]Information and download server of plugins[es]Servidor de informaci�³n y descarga de plugins[fa]ÿ³ÿ±ÿ˿ÿ± ÿ§ÿ·ÿ⿿ÿ§ÿ¹ÿ§ÿª ÿ˿ ÿ¨ÿ§ÿ±ÿ¯ÿ°ÿ§ÿ±ÿŠ ÿ¾ÿ⿿ÿ§ÿ¯ÿŠÿ⿠â⿬ſÿ⿡ÿ§[fr]SerVeur d\'information et de t�l�chargement des Plugins[it]Informazioni e server per il download dei plugin[ru]Ð£Ð¿ÿ⿬Ð°Ð²Ð»ÐµÐ½Ð¸Ðµ Ð¿Ð»Ð°Ð³Ð¸Ð½Ð°Ð¼Ð¸[sk]Server na zisÿ¥ovanie inform�¡ci�­ oÿ z�¡suvn�½ch moduloch aÿ ich sÿ¥ahovanie</multi>', 'maintenance', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(394, 'STATS', '<multi>[ar]ÿ§ÿ⿿ÿ¥ÿ­ÿµÿ§ÿ¡ÿ§ÿª[de]Estad�­sticas[en]Statistics[es]Estad�­sticas[fa]ÿ¢ÿ⿦ÿ§ÿ±ÿ⿡ÿ§[fr]Statistiques[it]Statistiche[pt_br]Estat�­sticas[ru]Ð¡ÿ⿿Ð°ÿ⿿Ð¸ÿÿ⿿Ð¸ÐºÐ° Ð¿Ð¾ÿÐµÿ⿰ÐµÐ½Ð¸Ð¹ ÿÐ°Ð¹ÿ⿿Ð°[sk]ÿ tatistiky</multi>', '<multi>[ar]ÿ¥ÿ¯ÿ§ÿ±ÿ© ÿ§ÿ⿿ÿ¥ÿ­ÿµÿ§ÿ¡ÿ§ÿª ÿÿŠ SPIP[de]Administraci�³n de las estad�­sticas de SPIP[en]Statistics management in SPIP[es]Administraci�³n de las estad�­sticas de SPIP[fa]ÿ⿦ÿ¯ÿŠÿ±ÿŠÿª ÿ¢ÿ⿦ÿ§ÿ±ÿ⿡ÿ§ ÿ¯ÿ± ÿ§ÿ³ÿ¾ÿŠÿ¾[fr]Gestion des statistiques dans SPIP[it]Gestione delle statistiche di SPIP[pt_br]Gerenciamento das estat�­sticas do SPIP[ru]ÐŸÐ»Ð°Ð³Ð¸Ð½ Ð¿Ð¾ ÿƿÿ⿡Ðµÿ⿿ÿƿ ÿÿ⿿Ð°ÿ⿿Ð¸ÿÿ⿿Ð¸ÐºÐ¸ Ð¿Ð¾ÿÐµÿ⿰ÐµÐ½Ð¸Ð¹ Ð²Ð°ÿ˿ÐµÐ³Ð¾ ÿÐ°Ð¹ÿ⿿Ð°[sk]Spr�¡va ÿ¡tatist�­k v SPIPe</multi>', 'statistique', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(393, 'SQUELETTES_PAR_RUBRIQUE', 'Squelettes par Rubrique', '<multi>[ar]ÿ¯ÿ¹ÿ⿦ ÿ§ÿ⿿ÿµÿÿ­ÿ§ÿª ÿ§ÿ⿿ÿ⿠ÿ⿦ÿ˿ÿ°ÿ¬ÿŠÿ© ÿ°ÿ§ÿª ÿ§ÿ⿿ÿ⿿ÿ˿ÿ§ÿ­ÿ⿿ ÿÿŠ SPIP[de]Unterst�¼tzung von Skeletten mit Namenszusatz in SPIP[en]Support of suffixed templates in SPIP[fa]ÿ¾ÿ´ÿªÿŠÿ¨ÿ§ÿ⿠ÿŠ ÿ§ÿ² ÿ§ÿ³ÿƿÿ⿿ÿŠÿªâ⿬ſÿ⿡ÿ§ÿŠ  ÿ¾ÿ³ÿ˿ÿ⿠ÿ¯ÿŠ ÿ¯ÿ± ÿ§ÿ³ÿ¾ÿŠÿ¾[fr]Support des squelettes suffix�s dans SPIP[it]Supporto di modelli con suffisso in SPIP[pt_br]Suporte aos gabaritos com sufixo do SPIP[ru]ÐÐ¾Ð¼Ðµÿ⿬Ð½ÿ⿹Ðµ ÿ˿Ð°Ð±Ð»Ð¾Ð½ÿ⿹ Ð´Ð»ÿ SPIP[sk]Podpora pripojen�½ch ÿ¡abl�³n vÿ SPIPe</multi>', 'outil', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(391, 'SAFEHTML', 'SafeHTML', '<multi>[fr]Protection des forums contre le cross-site scripting</multi>', 'performance', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(392, 'SITES', 'Sites', '<multi>[ar]ÿ¥ÿ¯ÿ§ÿ±ÿ© ÿ§ÿ⿿ÿ⿦ÿ˿ÿ§ÿ⿿ÿ¹ ÿ˿ÿ§ÿ⿿ÿªÿ±ÿ®ÿŠÿµ ÿÿŠ SPIP[de]Verwaltung verlinkter und syndizierter Websites mit  SPIP[en]Management of sites and syndication in SPIP[es]Administraci�³n de los sitios y de la sindicaci�³n en SPIP[fa]ÿ⿦ÿ¯ÿŠÿ±ÿŠÿª ÿ³ÿ§ÿŠÿªâ⿬ſÿ⿡ÿ§ ÿ˿ ÿ⿦ÿ´ÿªÿ±ÿƿâ⿬ſÿ³ÿ§ÿ²ÿŠ ÿ¯ÿ± ÿ§ÿ³ÿ¾ÿŠÿ¾[fr]Gestion des sites et de la syndication dans SPIP[it]Gestione dei siti e syndication in SPIP[pt_br]Gerenciamento de sites e da sindica�§�£o do SPIP[ru]ÐŸÐ¾Ð´ÐºÐ»ÿŽÿ⿡ÐµÐ½Ð¸Ðµ Ð´ÿ⿬ÿƿÐ³Ð¸ÿ⿦ ÿÐ°Ð¹ÿ⿿Ð¾Ð² Ð¿Ð¾ RSS[sk]Riadenie str�¡nok a syndik�¡cie v SPIPe</multi>', 'edition', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(390, 'REVISIONS', 'R�visions', '<multi>[ar]ÿ⿦ÿªÿ§ÿ¨ÿ¹ÿ© ÿ§ÿ⿿ÿªÿºÿŠÿŠÿ±ÿ§ÿª ÿÿŠ ÿ§ÿ⿿ÿ¹ÿ⿠ÿ§ÿµÿ± ÿ§ÿ⿿ÿªÿ­ÿ±ÿŠÿ±ÿŠÿ©[de]�⿿nderungen von redaktionellen Inhalten nachvollziehen[en]Tracking changes of editorial objects[es]Seguimiento de las modificaciones de los objetos editoriales[fa]ÿ¾ÿŠÿ¯ÿŠÿ±ÿŠ ÿ§ÿµÿ⿿ÿ§ÿ­ÿ§ÿª ÿ⿦ÿ˿ÿ¶ÿ˿ÿ¹â⿬ſÿ⿡ÿ§ÿŠ ÿ³ÿ±ÿ¯ÿ¨ÿŠÿ±ÿŠ[fr]Suivi des modifications des objets �ditoriaux[it]Il rilevamento delle revisioni sugli oggetti editoriali[pt_br]Acompanhamento das altera�§�µes dos objetos editoriais[ru]Ð˿ÿÿ⿿Ð¾ÿ⿬Ð¸ÿ Ð¸Ð·Ð¼ÐµÐ½ÐµÐ½Ð¸Ð¹[sk]Sledovanie zmien redakÿn�½ch objektov</multi>', 'edition', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(389, 'PORTE_PLUME', '<multi>[ar]ÿ§ÿ⿿ÿ±ÿŠÿ´ÿ©[de]Federhalter[en]Quill[fa]ÿ⿠ÿ˿ÿ¨ ÿ⿿ÿ⿿ÿ⿦[fr]Porte plume[it]Portapenne[ru]Porte plume[sk]Porte plume</multi>', '<multi>[ar]ÿ´ÿ±ÿŠÿ· ÿ£ÿ¯ÿ˿ÿ§ÿª ÿ⿿ÿªÿ­ÿ³ÿŠÿ⿠ ÿ§ÿ⿿ÿƿÿªÿ§ÿ¨ÿ©[de]Eine Men�¼leiste zum Formatieren der Texte[en]A toolbar to enhance your texts[fa]ÿ⿠ÿ˿ÿ§ÿ± ÿ§ÿ¨ÿ²ÿ§ÿ±ÿŠ ÿ¨ÿ±ÿ§ÿŠ ÿ¨ÿ⿡ÿªÿ±ÿ⿠ÿ˿ÿŠÿ³ÿŠ[fr]Une barre d\'outil pour bien �crire[it]Una barra degli strumenti per scrivere bene[ru]Ð⿝Ð¾Ð¿Ð¾Ð»Ð½Ð¸ÿ⿿ÐµÐ»ÿſÐ½ÿ⿹Ðµ Ð²Ð¾Ð·Ð¼Ð¾Ð¶Ð½Ð¾ÿÿ⿿Ð¸ Ð´Ð»ÿ ÿ⿿ÐµÐºÿÿ⿿Ð¾Ð²Ð¾Ð³Ð¾ ÿ⿬ÐµÐ´Ð°Ðºÿ⿿Ð¾ÿ⿬Ð°[sk]Panel s n�¡strojmi, vÿaka ktor�mu m�´ÿ¾ete vylepÿ¡iÿ¥ svoje texty</multi>', 'edition', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(387, 'ORGANISEUR', 'Organiseur', '<multi>[ar]ÿ£ÿ¯ÿ˿ÿ§ÿª ÿ¹ÿ⿦ÿ⿿ ÿªÿ­ÿ±ÿŠÿ±ÿŠ ÿ¬ÿ⿦ÿ§ÿ¹ÿŠ[de]Werkzeuge f�¼r eine Online-Redaktion[en]Collaborative editorial working tools[es]Herramientas de trabajo editorial en grupo[fa]ÿ§ÿ¨ÿ²ÿ§ÿ±ÿ⿡ÿ§ÿŠ ÿƿÿ§ÿ± ÿ¯ÿ±ÿ˿ÿ⿡ ÿ³ÿ±ÿ¯ÿ¨ÿŠÿ±ÿŠ[fr]Outils de travail �ditorial en groupe[it]Strumenti per il lavoro editoriale in gruppo[ru]Ðžÿ⿬Ð³Ð°Ð½Ð¸Ð·Ð°ÿ⿠Ð¸ÿ ÿÐ¾Ð²Ð¼Ðµÿÿ⿿Ð½Ð¾Ð¹ ÿ⿬Ð°Ð±Ð¾ÿ⿿ÿ⿹[sk]N�¡stroje na redakÿn�º pr�¡cu vÿ skupine</multi>', 'date', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(388, 'PETITIONS', 'P�titions', '<multi>[ar]ÿ¥ÿ¯ÿ§ÿ±ÿ© ÿ§ÿ⿿ÿ¹ÿ±ÿ§ÿ¦ÿ¶ ÿÿŠ SPIP[de]Verwaltung von Petitionen mit SPIP[en]Petitions management in SPIP[es]Administraci�³n de las peticiones en SPIP[fa]ÿ⿦ÿ¯ÿŠÿ±ÿŠÿª ÿ·ÿ˿ÿ⿦ÿ§ÿ±ÿ⿡ÿ§ ÿ¯ÿ± ÿ§ÿ³ÿ¾ÿŠÿ¾[fr]Gestion des p�titions dans SPIP[it]Gestione delle petizioni di SPIP[pt_br]Gerenciamento de peti�§�µes do SPIP[sk]Spr�¡va pet�­ci�­ v SPIPe</multi>', 'communication', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(386, 'MSIE_COMPAT', '<multi>[ar]ÿ¯ÿ¹ÿ⿦ ÿ¨ÿ±ÿ§ÿ⿦ÿ¬ ÿ§ÿ⿿ÿªÿµÿÿ­ ÿ§ÿ⿿ÿ⿿ÿ¯ÿŠÿ⿦ÿ©[de]Unterst�¼tzung �¤lterer Webbrowser[en]Support of older browsers[es]Soporte para navegadores antiguos[fa]ÿ¾ÿ´ÿªÿŠÿ¨ÿ§ÿ⿠ÿŠ ÿ§ÿ² ÿ⿦ÿ±ÿ˿ÿ±ÿ¯ÿ±â⿬ſÿ⿡ÿ§ÿŠ ÿ⿿ÿ¯ÿŠÿ⿦ÿŠ[fr]Support vieux navigateurs[it]Supporto ai vecchi browser[pt_br]Suporte a navegadores antigos[ru]ÐŸÐ¾Ð´Ð´Ðµÿ⿬Ð¶ÐºÐ° ÿÿ⿿Ð°ÿ⿬ÿ⿹ÿ⿦ Ð±ÿ⿬Ð¾ÿƿÐ·Ðµÿ⿬Ð¾Ð²[sk]Podpora starÿ¡�­ch prehliadaÿov</multi>', '<multi>[ar]ÿ⿦ÿ⿿ÿÿ§ÿª PNG ÿ˿ÿ¹ÿ⿿ÿ§ÿ⿦ÿ§ÿª ÿ£ÿ˿ÿ±ÿ§ÿ⿿ ÿ§ÿ⿿ÿ£ÿ⿠ÿ⿦ÿ§ÿ· ÿÿŠ ÿ¨ÿ±ÿ§ÿ⿦ÿ¬ ÿ§ÿ⿿ÿªÿµÿÿ­ ÿ§ÿ⿿ÿ⿿ÿ¯ÿŠÿ⿦ÿ©[de]PNG und CSS-Selektoren f�¼r alte Browser[en]PNG files and various CSS selectors for old browsers[es]PNG y selectores CSS para los navegadores antiguos[fa]ÿ¾ÿŠ.ÿ§ÿ⿠.ÿ¬ÿŠ ÿ˿ ÿ¯ÿ²ÿŠÿ⿠ÿ´ÿ¯ÿ±â⿬ſÿ⿡ÿ§ÿŠ ÿ³ÿŠ.ÿ§ÿ³.ÿ§ÿ³ ÿ¨ÿ±ÿ§ÿŠ ÿ⿦ÿ±ÿ˿ÿ±ÿ¯ÿ±ÿ⿡ÿ§ÿŠ ÿ⿿ÿ¯ÿŠÿ⿦ÿŠ[fr]PNG et s�lecteurs CSS pour les vieux navigateurs[it]Immagini in formato PNG e selettori CSS per i vecchi browser[pt_br]PNG e seletores CSS para os navegadores antigos[ru]ÐŸÐ¾Ð´Ð´Ðµÿ⿬Ð¶ÐºÐ° Ð¿ÿ⿬Ð¾Ð·ÿ⿬Ð°ÿ⿡Ð½Ð¾ÿÿ⿿Ð¸ PNG Ð¸ ÿ⿬Ð°ÿÿ˿Ð¸ÿ⿬ÐµÐ½Ð½Ð°ÿ Ð¿Ð¾Ð´Ð´Ðµÿ⿬Ð¶ÐºÐ° ÿÐµÐ»ÐµÐºÿ⿿Ð¾ÿ⿬Ð¾Ð² CSS Ð´Ð»ÿ ÿÿ⿿Ð°ÿ⿬ÿ⿹ÿ⿦ Ð±ÿ⿬Ð¾ÿƿÐ·Ðµÿ⿬Ð¾Ð²[sk]PNG a voliÿe CSS pre starÿ¡ie prehliadaÿe</multi>', 'outil', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(385, 'MOTS', 'Mots', '<multi>[ar]ÿ¥ÿ¯ÿ§ÿ±ÿ© ÿ§ÿ⿿ÿ⿦ÿÿ§ÿªÿŠÿ­ ÿ˿ÿ⿦ÿ¬ÿ⿦ÿ˿ÿ¹ÿ§ÿª ÿ§ÿ⿿ÿ⿦ÿÿ§ÿªÿŠÿ­ ÿÿŠ SPIP[de]Verwaltung von Schlagworten und Schlagwortgruppen mit  SPIP[en]Management of keywords and keywords groups in SPIP[es]Administraci�³n de las palabras clave y los grupos de palabras clave en SPIP[fa]ÿ⿦ÿ¯ÿŠÿ±ÿŠÿª ÿ˿ÿ§ÿ˿ÿ⿡â⿬ſÿ⿡ÿ§ ÿ˿ ÿ¯ÿ±ÿ˿ÿ⿡â⿬ſÿ˿ÿ§ÿ˿ÿ⿡â⿬ſÿ⿡ÿ§ ÿ¯ÿ± ÿ§ÿ³ÿ¾ÿŠÿ¾[fr]Gestion des mots et groupes de mots dans SPIP[it]Gestione delle parole e dei gruppi di parole di SPIP[pt_br]Gerenciamento de palavras-chave e grupos de palavras chave do SPIP[ru]ÐÐ°ÿÿ⿿ÿ⿬Ð¾Ð¹ÐºÐ° Ð³ÿ⿬ÿƿÐ¿Ð¿ ÐºÐ»ÿŽÿ⿡ÐµÐ¹ Ð¸ ÐºÐ»ÿŽÿ⿡ÐµÐ¹ Ð² SPIP[sk]Riadenie kÿ¾�ºÿov�½ch slov aÿ skup�­n kÿ¾�ºÿov�½ch slov vÿ SPIPe</multi>', 'edition', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(384, 'MEDIAS', 'Medias', '<multi>[ar]ÿ£ÿ¯ÿ§ÿ±ÿ© ÿ§ÿ⿿ÿ˿ÿ³ÿ§ÿ¦ÿ· ÿ§ÿ⿿ÿ⿦ÿªÿ¹ÿ¯ÿ¯ÿ© ÿÿŠ SPIP[de]Medienverwaltung in  SPIP[en]SPIP''s media management[fa]ÿ⿦ÿ¯ÿŠÿ±ÿŠÿª ÿ±ÿ³ÿ§ÿ⿠ÿ⿡â⿬ſÿ⿡ÿ§ ÿ¯ÿ±ÿ§ÿ³ÿ¾ÿŠÿ¾[fr]Gestion des m�dias dans SPIP[it]Gestione dei media di SPIP[pt_br]Gerenciamento de m�­dias do SPIP[ru]Ð£Ð¿ÿ⿬Ð°Ð²Ð»ÐµÐ½Ð¸Ðµ Ð¼ÐµÐ´Ð¸Ð° ÿ⿿Ð°Ð¹Ð»Ð°Ð¼Ð¸[sk]Spr�¡va multim�di�­ v SPIPe</multi>', 'multimedia', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(382, 'JQUERYUI', 'jQuery UI', '<multi>[ar]ÿ¥ÿ⿠ÿªÿ§ÿ¬ ÿ§ÿ⿿ÿ­ÿ±ÿƿÿ© ÿ˿ÿ§ÿ⿿ÿ⿦ÿ¤ÿ«ÿ±ÿ§ÿª ÿ˿ÿªÿ˿ÿ³ÿŠÿ¹ ÿ£ÿ¯ÿ˿ÿ§ÿ© jQuery[de]Animationen, Effekte und Widgets f�¼r jQuery[en]Animations, effects and jQuery widgets[fr]Animations, effets et widgets jQuery[it]Animazioni, effetti e widget jQuery[sk]Anim�¡cie, efekty aÿ widgety jQuery</multi>', 'outil', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(383, 'MEDIABOX', '<multi>[ar]ÿµÿ⿠ÿ¯ÿ˿ÿ⿿ ÿ§ÿ⿿ÿÿ±ÿ¬ÿ©[de]MediaBox[en]MediaBox[es]MediaBox[fa]ÿ⿦ÿ¯ÿŠÿ§ÿ¨ÿ§ÿƿÿ³[fr]MediaBox[it]MediaBox[ru]MediaBox[sk]Multimedi�¡lny box</multi>', '<multi>[ar]ÿµÿ⿠ÿ¯ÿ˿ÿ⿿ ÿ§ÿ⿿ÿÿ±ÿ¬ÿ©[de]Multimedia-Box[en]Media box[es]Caja multimedia[fa]ÿµÿ⿠ÿ¯ÿ˿ÿ⿿ ÿ⿠ÿ⿠ÿ¯ÿ±ÿ³ÿ§ÿ⿠ÿ⿡â⿬ſÿ§ÿŠ[fr]Bo�®te multim�dia[it]Media box[ru]ÐſÐµÐ´Ð¸Ð°Ð±Ð¾Ðºÿ[sk]Multimedi�¡lny box</multi>', 'multimedia', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(381, 'FORUM', 'Forum', '<multi>[ar]ÿ¥ÿ¯ÿ§ÿ±ÿ© ÿ§ÿ⿿ÿ⿦ÿ⿠ÿªÿ¯ÿŠÿ§ÿª ÿ§ÿ⿿ÿ®ÿ§ÿµÿ© ÿ˿ÿ§ÿ⿿ÿ¹ÿ⿦ÿ˿ÿ⿦ÿŠ ÿÿŠ SPIP[de]Verwaltung der privaten und �¶ffentlichen SPIP-Foren[en]Management of private and public forums in SPIP[es]Administraci�³n de los foros privados y p�ºblicos en SPIP[fa]ÿ⿦ÿ¯ÿŠÿ±ÿŠÿª ÿ³ÿ®ÿ⿠ÿ¯ÿ§ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ ÿ®ÿµÿ˿ÿµÿŠ ÿ˿ ÿ⿡ÿ⿦ÿ¯ÿ§ÿ⿠ÿŠ ÿ¯ÿ± ÿ§ÿ³ÿ¾ÿŠÿ¾[fr]Gestion des forums priv�s et publics dans SPIP[it]Gestione dei forum privati e pubblici di SPIP[pt_br]Gerenciamento dos f�³runs privados e p�ºblicos do SPIP[ru]Ð£Ð¿ÿ⿬Ð°Ð²Ð»ÐµÐ½Ð¸Ðµ ÿ⿿Ð¾ÿ⿬ÿƿÐ¼Ð°Ð¼Ð¸ Ð¸ ÐºÐ¾Ð¼Ð¼ÐµÐ½ÿ⿿Ð°ÿ⿬Ð¸ÿÐ¼Ð¸[sk]Riadenie s�ºkromn�½ch ajÿ verejn�½ch diskusn�½ch f�³r vÿ SPIPe</multi>', 'communication', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(380, 'IMAGES', 'Images', '<multi>[ar]ÿ⿦ÿ±ÿ´ÿ­ÿ§ÿª ÿ⿦ÿ¹ÿ§ÿ⿿ÿ¬ÿ© ÿ§ÿ⿿ÿµÿ˿ÿ± ÿ˿ÿ§ÿ⿿ÿ£ÿ⿿ÿ˿ÿ§ÿ⿠[de]Bild- und Farbfilter[en]Images processing and colors filters[fa]ÿÿŠÿ⿿ÿªÿ±ÿ⿡ÿ§ÿŠ ÿ¾ÿ±ÿ¯ÿ§ÿ²ÿ´ ÿªÿµÿ˿ÿŠÿ±â⿬ſÿ⿡ÿ§ ÿ˿ ÿ±ÿ⿠ÿ¯â⿬ſÿ⿡ÿ§[fr]Filtres de transformation d\'images et de couleurs[it]Filtri di trasformazione delle immagini e dei colori[pt_br]Filtros de transforma�§�£o de imagens e de cores[ru]ÐÐ°Ð±Ð¾ÿ⿬ ÿ⿿Ð¸Ð»ÿſÿ⿿ÿ⿬Ð¾Ð² Ð¿Ð¾ ÿ⿬Ð°Ð±Ð¾ÿ⿿Ðµ ÿ Ð¸Ð·Ð¾Ð±ÿ⿬Ð°Ð¶ÐµÐ½Ð¸ÿÐ¼Ð¸[sk]Filtre na transform�¡ciu obr�¡zkov a farieb</multi>', 'multimedia', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(379, 'DUMP', 'Dump', '<multi>[ar]ÿ⿠ÿ³ÿ® ÿ§ÿ­ÿªÿŠÿ§ÿ·ÿŠ ÿ⿿ÿ⿿ÿ§ÿ¹ÿ¯ÿ© ÿ¨ÿŠÿ§ÿ⿠ÿ§ÿª SPIP ÿ˿ÿ§ÿ³ÿªÿ±ÿ¬ÿ§ÿ¹ÿ⿡ÿ§[de]Sicherung und Wiederherstellung der  SPIP-Datenbank[en]Backup and restore database SPIP[es]Copia de seguridad y recuperaci�³n de la base de datos de SPIP[fa]ÿ¨ÿƿâ⿬ſÿ¢ÿ¾ ÿ˿ ÿ°ÿ®ÿŠÿ±ÿ⿡ ÿ³ÿ§ÿ²ÿŠ ÿ¾ÿ§ÿŠÿ¯ÿ§ÿ⿡ ÿ¯ÿ§ÿ¯ÿ⿡â⿬ſâ⿬ſÿ⿡ÿ§ÿŠ ÿ§ÿ³ÿ¾ÿŠÿ¾[fr]Sauvegarde et restauration de la base SPIP[it]Backup e ripristino del database di SPIP[pt_br]C�³pia de seguran�§a e restauro da base SPIP[ru]Ð ÐµÐ·Ðµÿ⿬Ð²Ð½Ð¾Ðµ ÐºÐ¾Ð¿Ð¸ÿ⿬Ð¾Ð²Ð°Ð½Ð¸Ðµ[sk]Z�¡loha a obnovenie datab�¡zy SPIPu</multi>', 'maintenance', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(378, 'COMPRESSEUR', 'Compresseur', '<multi>[ar]ÿ¶ÿºÿ· ÿ£ÿ˿ÿ±ÿ§ÿ⿿ ÿ§ÿ⿿ÿ£ÿ⿠ÿ⿦ÿ§ÿ· ÿ˿ÿ±ÿ⿦ÿ˿ÿ² ÿ¬ÿ§ÿÿ§ÿ³ÿƿÿ±ÿŠÿ¨ÿª[de]Kompression von CSS und Javascript-Code[en]CSS and javascript compression[es]Compresi�³n de css y javascript[fa]ÿÿ´ÿ±ÿ¯ÿ⿡ ÿ³ÿ§ÿ²ÿŠ ÿ³ÿŠ.ÿ§ÿ³.ÿ§ÿ³â⿬ſÿ⿡ÿ§ ÿ˿ ÿ¬ÿ§ÿ˿ÿ§ÿ§ÿ³ÿƿÿ±ÿŠÿ¨ÿª[fr]Compression des css et javascript[it]Compressione di CSS e javascript[pt_br]Compress�£o dos css e javascript[ru]ÐŸÐ»Ð°Ð³Ð¸Ð½ Ð´Ð»ÿ ÿÐ¶Ð°ÿ⿿Ð¸ÿ CSS Ð¸ Javascript ÿ⿿Ð°Ð¹Ð»Ð¾Ð²[sk]Kompresia css a javascriptu</multi>', 'performance', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(377, 'COMPAGNON', '<multi>[ar]ÿ§ÿ⿿ÿ±ÿÿŠÿ⿿[de]Begleiter[en]Companion[es]Compa�±ero[fa]ÿ⿡ÿ⿦ÿ±ÿ§ÿ⿡[fr]Compagnon[it]Assistente[pt_br]Companheiro[ru]ÐŸÐ¾Ð¼Ð¾ÿ⿰Ð½Ð¸Ðº[sk]Compagnon</multi>', '<multi>[ar]Assistant de premiers pas avec SPIP[de]Assistent f�¼r die ersten Schritte mit SPIP[en]First steps wizard with SPIP[es]Asistente para dar los primeros pasos con SPIP[fa]ÿ⿡ÿ⿦ÿ±ÿ§ÿ⿡ ÿ§ÿ˿ÿ⿿ ÿ¨ÿ§ ÿ§ÿ³ÿ¾ÿŠÿ¾ ÿ⿠ÿŠÿ³ÿª[fr]Assistant de premiers pas avec SPIP[it]Assistente per il primo utilizzo di SPIP[pt_br]Assistente de primeiros passos do SPIP[ru]ÐÐ°ÿ⿡Ð°Ð»ÿſÐ½Ð°ÿ Ð¿Ð¾Ð¼Ð¾ÿ⿰ÿſ Ð¿ÿ⿬Ð¸ ÿ⿬Ð°Ð±Ð¾ÿ⿿Ðµ ÿÐ¾ SPIP[sk]Sprievodca pri prv�½ch krokoch soÿ SPIPom</multi>', 'divers', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(376, 'BREVES', 'Br�ves', '<multi>[ar]ÿ¥ÿ¯ÿ§ÿ±ÿ© ÿ§ÿ⿿ÿ£ÿ®ÿ¨ÿ§ÿ± ÿÿŠ SPIP[de]Meldungen in  SPIP verwalten[en]Management of news items in SPIP[es]Gesti�³n de las breves en SPIP[fa]ÿ⿦ÿ¯ÿŠÿ±ÿŠÿª ÿ®ÿ¨ÿ±ÿ⿡ÿ§ ÿ¯ÿ± ÿ§ÿ³ÿ¾ÿŠÿ¾[fr]Gestion des br�ves dans SPIP[fr_tu]Gestion des br�ves dans SPIP[it]Gestione delle brevi in SPIP[pt_br]Gerenciamento de notas no SPIP[ru]ÐÐ°ÿÿ⿿ÿ⿬Ð¾Ð¹ÐºÐ¸ Ð»ÐµÐ½ÿ⿿ÿ⿹ Ð½Ð¾Ð²Ð¾ÿÿ⿿ÐµÐ¹[sk]Spr�¡va noviniek v SPIPe</multi>', 'edition', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(24, 'A2A', 'A2A', '<multi>\n[en]Link articles together\n[fr]Pour lier des articles\n[sk]Na prep�¡janie ÿl�¡nkov\n</multi>', 'navigation', '', '001.003.006', '2012-08-31 00:00:09', '2012-09-01 21:00:23', '[3.0.0-dev;3.0.*]', '3.0'),
(26, 'ACCESRESTREINT', '<multi>[de]Zugangskontrolle[en]Restricted Access[es]Acceso restringido[fr]Acc�s Restreint</multi>', '<multi>[de]Verwaltung von Bereichen mit Zugangskontrolle[es]Gestión de zonas de acceso restringido[fr]Gestion de zones d\'acc�s restreint</multi>', 'auteur', '', '003.006.002', '2012-07-26 13:06:55', '2012-07-26 13:06:55', '[3.0.0;3.0.*]', '3.0'),
(27, 'ACS', 'ACS', '', 'edition', '', '003.000.000', '2012-08-05 07:00:03', '2012-08-05 07:00:03', '[3.0.0;*]', ''),
(28, 'ACTIVITE_EDITORIALE', 'Activit� �ditoriale', '<multi>\n[fr]Un site, c''est bien ! Un site �  jour, c''est mieux !\n</multi>', 'edition', '', '002.000.001', '2012-05-23 17:01:27', '2012-05-23 17:01:27', '[3.0.0;3.0.*]', '3.0'),
(29, 'JABBERID', 'Adresse Jabber (JID)', '<multi>\n[fr]Une adresse Jabber pour les auteurs\n</multi>', 'auteur', '', '002.000.000', '2011-11-25 21:00:02', '2011-11-25 21:00:02', '[3.0.0-dev;3.0.*]', '3.0'),
(30, 'ADXMENU', '<multi>\n[en]ADX Menu\n[fr]ADX Menu\n</multi>', '<multi>\n[en]Multilevel opening menu type ''fly-out'' in CSS/Javacript\n[fr]Menu ouvrant multi-niveaux type ''fly-out'' en CSS/javascript\n</multi>', 'navigation', '', '001.023.002', '2012-09-02 12:00:18', '2012-09-02 12:00:18', '[2.0;[', '2.0,2.1,3.0,3.1'),
(31, 'COMMHTML', 'Afficher les commentaires HTML', '<multi>\n[fr]Affiche les commentaires HTML dans l''espace priv�\n</multi>', 'edition', '', '001.000.000', '2012-06-27 18:00:03', '2012-06-27 18:00:03', '[2.1.0;3.0.99]', '2.1,3.0'),
(32, 'PB_PAGERANK', 'PageRank', 'Afficher le PageRank Google', 'statistique', '', '000.002.000', '2012-03-01 19:00:10', '2012-03-01 19:00:10', '[3.0.0-dev;3.0.*]', '3.0'),
(494, 'Z', 'Zpip-dist v1', 'Squelette r�utilisable, modulaire et th�mable', 'squelette', '', '001.007.021', '2012-09-06 13:00:03', '2012-09-06 13:00:03', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(495, 'INITIALIZR', 'initializr', '', 'theme', '', '001.001.001', '2012-09-17 12:00:27', '2012-09-17 12:00:27', '[v3;]', '1.9,2.0,2.1,3.0,3.1'),
(34, 'ALBUMS', '<multi>\n[fr]Albums\n</multi>', '<multi>\n[fr]Grouper vos documents sous forme d\'albums\n</multi>', 'multimedia', '', '002.000.009', '2012-03-01 01:00:02', '2012-09-25 20:00:02', '[2.0.0;3.0.*]', '2.0,2.1,3.0'),
(35, 'ALIAS', '<multi>\n[en]Articles Alias\n[fr]Alias Articles\n[ru]Ð¡ÿÿ⿹Ð»ÐºÐ¸ Ð½Ð° ÿÿ⿿Ð°ÿ⿿ÿſÐ¸\n</multi>', '<multi>\n[en]Allow to create aliases for articles\n[fr]Creer des Alias d\'articles\n[ru]ÐŸÐ¾Ð·Ð²Ð¾Ð»ÿÐµÿ⿿ ÿÐ¾Ð·Ð´Ð°Ð²Ð°ÿ⿿ÿſ ÿÿÿ⿹Ð»ÐºÐ¸ Ð¸Ð»Ð¸ ÿÿ⿬Ð»ÿ⿹ÐºÐ¸ Ð½Ð° ÿÿ⿿Ð°ÿ⿿ÿſÐ¸\n</multi>', 'navigation', '', '000.001.001', '2012-03-24 17:00:01', '2012-03-24 17:00:01', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(36, 'AMIS', 'Amis', 'Gestion des amis', 'communication', '', '000.001.000', '2012-08-02 18:00:09', '2012-08-02 18:00:09', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(37, 'ANCRESDOUCES', '<multi>\n[en]Sweet anchors\n[fa]Ancres Douces\n[fr]Ancres Douces\n[nl]Zachte ankers\n[sk]Jednoduch� kotvy\n</multi>', '<multi>\n[en]Smooth anchors\n[fa]ÿ⿿ÿ⿠ÿ¯ÿ±â⿬ſâ⿬ſÿ⿡ÿ§ÿŠ ÿ⿠ÿ±ÿ⿦\n[fr]Des ancres en douceur\n[nl]Zachte scrol naar de ankers\n[sk]Kotvy s ÿ¾ahkosÿ¥ou\n</multi>', 'navigation', '', '001.004.002', '2012-08-30 22:00:02', '2012-08-30 22:00:02', '[3.0.0-dev;3.0.*]', '3.0'),
(38, 'AP', 'Annonces Publiques', 'Annonces pour la messagerie de l''espace priv�', 'divers', '', '001.003.000', '2012-05-12 14:00:11', '2012-05-12 14:00:11', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(39, 'APROPOS', '�⿬ propos des Plugins actifs', '<multi>\n[en]Lists the active plugins and displays a brief description of them\n[fr]Liste les plugins actifs et affiche une description sommaire de ceux-ci\n</multi>', 'divers', '', '000.003.007', '2012-06-13 21:01:44', '2012-06-13 21:01:44', '[3.0.0-rc;3.0.*]', '3.0'),
(40, 'ARTICLE_ACCUEIL', '<multi>\n[en]Home article\n[es]Articles d\'accueil\n[fr]Articles d\'accueil\n[ru]Ð⿿Ð»Ð°Ð²Ð½Ð°ÿ ÿÿ⿿Ð°ÿ⿿ÿſÿ\n[sk]Tituln� ÿl�¡nky\n</multi>', '<multi>\n[en]Assign a home article to a section\n[es]Atribuir un art�­culo de inicio a las secciones\n[fr]Attribuer un article d\'accueil aux rubriques\n[ru]ÐŸÿ⿬Ð¸Ð¼ÐµÐ½Ð¸ÿ⿿ÿſ Ð³Ð»Ð°Ð²Ð½ÿƿÿŽ ÿÿ⿿Ð°ÿ⿿ÿſÿŽ Ðº ÿ⿬Ð°Ð·Ð´ÐµÐ»ÿƿ\n[sk]Urÿte tituln� ÿl�¡nky rubr�­k\n</multi>', 'outil', '', '001.001.000', '2012-07-26 13:07:38', '2012-07-26 13:07:38', '[3.0.0-dev;3.0.99]', '3.0'),
(41, 'ARTICLE_PDF', '<multi>\r\n		[fr]Article PDF\r\n		[de]PDF Artikel\r\n		</multi>', 'Convertir l''article affich� au format pdf', 'edition', '', '000.004.005', '2011-12-21 19:00:54', '2011-12-21 19:00:54', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(42, 'ARTICLES_VERS_RUBRIQUES', 'Articles vers Rubriques', 'Convertir des articles en rubriques', 'maintenance', '', '000.000.002', '2012-06-01 16:01:03', '2012-06-01 16:01:03', '[2.1.0;]', '2.1,3.0,3.1'),
(43, 'AUTEURS_SYNDIC', '<multi>\n[en]Authors for Web site\n[es]Autores para los sitios sindicados\n[fr]Auteurs pour les sites syndiqu�s\n[sk]Autori na syndikovan� str�¡nky\n</multi>', '<multi>\n[en]Adds the ability to add authors to syndicated sites\n[es]A�±ade la posibilidad de agregar autores a los sitios sindicados\n[fr]Ajoute la possibilit� d\'ajouter des auteurs aux sites syndiqu�s\n[sk]Umoÿ¾ÿ˿uje kÿ syndikovan�½m str�¡nkam prid�¡vaÿ¥ autorov\n</multi>', 'auteur', '', '000.002.000', '2012-08-15 04:01:36', '2012-08-15 04:01:36', '[3.0.0;3.0.99]', '3.0'),
(44, 'OPENID', 'OpenID', '<multi>\n[fr]Authentification des auteurs et visiteurs �  l''aide de leur OpenID\n[en]Authenticates users with their OpenID\n		</multi>', 'auteur', '', '001.001.011', '2012-07-26 13:18:39', '2012-07-26 13:18:39', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(497, 'CEXTRAS', '<multi>\n[de]Zusatzfelder\n[en]Extra fields\n[es]Campos Extras\n[fr]Champs Extras\n[it]Campi Extra\n[sk]Doplnkov� polia\n</multi>', '<multi>\n[de]Zus�tzliche Felder f�r die Standardobjekte von SPIP anlegen\n[en]Create new edit fields for SPIP objects\n[es]Crear nuevos campos para los objetos editoriales dee SPIP\n[fr]API de gestion de nouveaux champs dans les objets �ditoriaux.\n[it]Crea nuovi campi per gli oggetti editoriali di SPIP\n[sk]Aplik�cia na riadenie nov�ch pol� v�redak�n�ch objektoch\n</multi>', 'outil', '', '003.002.002', '2012-09-22 19:00:03', '2012-09-22 19:00:03', '[3.0.0;3.0.*]', '3.0'),
(496, 'AGENDA', '<multi>\n[en]Agenda\n[fr]Agenda\n[sk]Di�r\n</multi>', '<multi>\n[en]Events agenda\n[fr]Agenda Ev�nementiel\n[sk]Kalend�r udalost�\n</multi>', 'date', '', '003.009.003', '2012-09-27 10:00:11', '2012-09-27 10:00:11', '[3.0.0;3.0.*]', '3.0'),
(492, 'Z5', 'Zpip-dist HTML5', '<multi>[fr]Zpip-dist HTML 5 pour SPIP 3 + Z-core[en]Zpip-dist HTML 5 for SPIP 3 + Z-core</multi>', 'squelette', '', '002.000.000', '2012-09-17 12:00:07', '2012-09-17 12:00:07', '[3.0-dev;]', '3.0,3.1'),
(493, 'SCOLASPIP', 'ScolaSPIP', '<multi>\n[fr]Un squelette personnalisable pour �tablissements scolaires\n</multi>', 'squelette', '', '003.000.020', '2012-09-19 11:00:02', '2012-09-19 11:00:02', '[3.0.0-beta2;3.1.*[', '3.0,3.1'),
(46, 'BADGE_DON', 'Badge pour dons', 'Un badge pour appeler au don', 'communication', '', '000.001.002', '2012-08-16 23:00:02', '2012-08-16 23:00:02', '[2.0;3.0.99]', '2.0,2.1,3.0'),
(47, 'BASICONE', '<multi>\n[fr]Basic�´ne\n</multi>', '<multi>\n[fr]Des ic�´nes pour l''interface priv� de SPIP\n</multi>', 'theme', '', '000.000.091', '2012-08-08 18:00:03', '2012-08-08 18:00:03', '[3.0.0-beta;3.0.*]', '3.0'),
(48, 'BELLESPUCES', 'Belles puces', 'De vraies listes �  puces avec ÿ«ÿ <code>-</code>ÿ ÿ», comme ÿ«ÿ <code>-*</code>ÿ ÿ» !', 'edition', '', '000.001.001', '2011-11-10 12:00:03', '2011-11-10 12:00:03', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(49, 'BISOUS', 'SPIP Bisous !', '', 'communication', '', '000.002.001', '2012-03-19 16:00:41', '2012-03-19 16:00:41', '[3.0.0-dev;3.0.99]', '3.0'),
(50, 'BOLO', '<multi>\n[en]Bolo\n[fr]Bolo\n</multi>', '<multi>\n[en]Tools to create fake text\n[fr]Outils pour cr�er du faux texte\n</multi>', 'edition', '', '000.002.002', '2011-11-01 21:06:53', '2011-11-01 21:06:53', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(51, 'BOUSSOLE', '<multi>\n[en]Compass\n[fr]Boussole\n[sk]Kompas\n</multi>', '<multi>\n[en]The favorite places of the SPIP galaxy or out there!\n[fr]Les bonnes adresses de la galaxie SPIP ou d\'ailleurs !\n[sk]Obÿ¾�ºben� adresy v galaxii SPIPu alebo inde!\n</multi>', 'navigation', '', '001.000.001', '2012-06-01 23:00:12', '2012-07-26 13:08:16', '[2.0.0;3.0.*]', '2.0,2.1,3.0'),
(52, 'BOUTONSTEXTE', '<multi>\n[ar]ÿªÿƿÿ¨ÿŠÿ± ÿ˿ÿªÿµÿºÿŠÿ±\n[de]Textschaltfl�¤chen\n[en]Buttons in the text\n[fa]ÿ¯ÿƿÿ⿦ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ ÿ¯ÿ§ÿ®ÿ⿿ ÿ⿦ÿªÿ⿠\n[fr]Boutons dans le Texte\n[sk]Tlaÿidl�¡ v texte\n</multi>', '<multi>\n[ar]ÿ£ÿ²ÿ±ÿ§ÿ± ÿ⿿ÿ⿿ÿªÿ­ÿƿÿ⿦ ÿ¨ÿ­ÿ¬ÿ⿦ ÿ§ÿ⿿ÿ­ÿ±ÿ˿ÿ\n[de]Schaltfl�¤chen zum Vergr�¶�Ÿern und Verkleinern von Text\n[en]Buttons to manage the font size\n[fa]ÿ¯ÿƿÿ⿦ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ ÿ⿦ÿ¯ÿŠÿ±ÿŠÿª ÿ§ÿ⿠ÿ¯ÿ§ÿ²ÿ⿡â⿬ſÿŠ ÿ⿿ÿ⿿ÿ⿦\n[fr]Des boutons pour g�rer la taille des caract�res\n[sk]Tlaÿidl�¡ na zmenu veÿ¾kosti p�­sma\n</multi>', 'edition', '', '002.000.000', '2012-07-26 13:08:29', '2012-07-26 13:08:29', '[3.0.0-dev;3.0.*]', '3.0'),
(53, 'BREVES_VERS_ARTICLES', 'Br�ves vers articles', 'Convertir des br�ves en articles', 'maintenance', '', '001.003.000', '2012-01-06 16:00:02', '2012-01-06 16:00:02', '[2.1.0;3.0.99]', '2.1,3.0'),
(54, 'CACHE_COOL', 'Cache Cool', 'Servir les pages au plus vite !', 'performance', '', '000.002.005', '2012-06-21 10:00:19', '2012-06-21 10:00:19', '[2.1.0;3.0.99]', '2.1,3.0'),
(55, 'CALENDRIERMINI', '<multi>\n[en]Mini Calendar\n[fr]Mini Calendrier\n[sk]Minikalend�¡r\n</multi>', '<multi>\n[en]Allow to use a #CALENDRIER_MINI tag\n[fr]Permet l''utilisation d\'une balise #CALENDRIER_MINI\n[sk]Umoÿ¾ÿ˿uje pouÿ¾�­vaÿ¥ tag #CALENDRIER_MINI\n</multi>', 'date', '', '002.003.003', '2012-04-02 17:00:22', '2012-09-27 10:00:04', '[3.0.0-beta;3.0.99]', '3.0'),
(56, 'PB_CESURE', 'C�sure', 'G�rer les c�sures sur l''affichage public', 'edition', '', '001.001.000', '2011-10-19 14:10:46', '2011-10-19 14:10:46', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(57, 'CFG', 'CFG', '<multi>[fr]Gestion de configurations.</multi>', 'maintenance', '', '003.000.000', '2011-12-21 19:00:46', '2011-12-21 19:00:46', '[3.0.0-beta;3.0.*]', '3.0'),
(58, 'CITE', 'Cite', '<multi>\n[fr]Ins�rer des r�f�rences bibliographiques\n</multi>', 'edition', '', '000.005.001', '2012-07-19 17:00:04', '2012-07-19 17:00:04', '[2.1.0;3.0.*]', '2.1,3.0'),
(59, 'CRUD', 'C(R)UD Interface', '<multi>\n[en]Interface to create, update and delete an object\n[fr]Interface de cr�ation, mise �  jour et suppression d\'un objet\n[sk]Rozhranie na vytv�¡ranie, aktualizovanie aÿ vymaz�¡vanie objektu\n</multi>', 'outil', '', '000.004.000', '2012-07-26 13:11:36', '2012-07-26 13:11:36', '[2.1.0;3.0.*]', '2.1,3.0'),
(489, 'TRAD_RUB', 'Traductions de rubriques autrement', '<multi>\n[fr]Naviguer entre les rubriques traduites.\n[sk]Prechádzanie medzi preloženými rubrikami.\n</multi>', 'edition', '', '001.002.002', '2012-09-14 13:00:16', '2012-09-14 13:00:16', '[3.0.0-alpha2;3.0.*]', '3.0'),
(487, 'TIPAFRIEND', '<multi>\n[en]Tip A Friend : Send a page by e-mail\n[fr]Tip A Friend\n[sk]Odporučiť priateľom\n</multi>', '<multi>\n[fr]Envoyer une page d\'un site SPIP à une liste d\'adresses e-mail\n[sk]Pošlite stránku v SPIPe priateľom v zozname e-mailových adries\n</multi>', 'communication', '', '001.006.002', '2012-09-15 04:01:04', '2012-09-15 04:01:04', '[3.0.0-beta;[', '3.0,3.1'),
(488, 'TRADRUB', '<multi>\n[en]Translations between sections\n[fr]Traduction entre rubriques\n[nl]Vertaling voor de rubrieken\n[ru]Сисѿема пеѿеводов для ѿаздела (TradRub)\n[sk]Preklad medzi rubrikami\n</multi>', '<multi>\n[en]Management of translation links between sections\n[fr]Gestion de liens de traduction entre les rubriques\n[nl]Beheer van vertalingen tussen de rubrieken\n[ru]пѿганизаѿия пеѿеводов ѿазделов сайѿа\n[sk]Riadenie odkazov na preklad medzi rubrikami\n</multi>', 'edition', '', '003.001.000', '2012-09-09 12:00:03', '2012-09-09 12:00:03', '[3.0.0-alpha2;[', '3.0,3.1'),
(62, 'CHANGESTATUT', 'Change Statut', '<multi>\n[fr]Modifier, le temps d\'un test, son statut de webmestre\n</multi>', 'outil', '', '000.003.000', '2012-02-08 17:00:14', '2012-02-08 17:00:14', '[2.1.0;3.0.99]', '2.1,3.0'),
(63, 'CHANTS', '<multi>\n[fr]Chants\n</multi>', '<multi>\n[fr]R�pertoire de chants\n</multi>', 'edition', '', '000.009', '2012-03-13 22:00:49', '2012-03-13 22:00:49', '[3.0.0-dev;[', '3.0,3.1'),
(64, 'CHESS', 'Chess (Echecs)', '<multi>\n[en]Allow to display chess games with PGN files\n[fr]Pour afficher des parties d''�checs au format PGN\n</multi>', 'divers', '', '000.009.004', '2012-08-27 05:00:02', '2012-08-27 05:00:02', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(65, 'CHOSEN', '<multi>\n[en]Chosen\n[fr]Chosen\n</multi>', '<multi>\n[en]Integrate the Chosen library in SPIP\n[fr]Int�grer la librairie Chosen dans SPIP\n</multi>', 'navigation', '', '001.000.004', '2012-08-25 00:00:44', '2012-08-25 00:00:44', '[3.0.0;3.0.*]', '3.0'),
(66, 'CLOUDZOOM', 'CloudZoom', '', 'multimedia', '', '002.000.001', '2012-04-14 11:00:03', '2012-04-14 11:00:03', '[2.0.9;3.0.*]', '2.0,2.1,3.0'),
(67, 'COLORATION_CODE', '<multi>\n[en]Code higlighting\n[fr]Coloration Code\n[it]Colorazione del codice\n[sk]K�³d zv�½raznenia\n</multi>', '<multi>\n[en]Syntax higlighting of code placed in articles\n[fr]Coloration syntaxique du code source dans les articles\n[it]Colorazione sintattica del codice utilizzato nel testo\n[sk]Zv�½raznenie syntaxe zdrojov�ho k�³du vÿ ÿl�¡nkoch\n</multi>', 'edition', '', '000.006.006', '2012-08-12 21:01:04', '2012-08-12 21:01:04', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(68, 'COLORIAGEDIST', 'Coloriage du squelette dist', 'Changer simplement les couleurs du squelette par d�faut', 'maintenance', '', '000.005.001', '2011-12-19 11:00:06', '2011-12-19 11:00:06', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(69, 'COLORSCOPE', 'Colorscope', '<multi>\r\n		[fr]Colorer les codes hexa\r\n		[en]Give colours to hex codes\r\n		</multi>', 'edition', '', '000.004.002', '2011-12-22 14:00:03', '2011-12-22 14:00:03', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(498, 'COMMENTS', 'Comments', '<multi>\n[fr]Des commentaires, tout simplement\n</multi>', 'communication', '', '003.002.000', '2012-09-20 16:00:09', '2012-09-20 16:00:09', '[3.0.0;3.0.*]', '3.0'),
(499, 'COMPOSITIONS', '<multi>\n[en]Compositions\n[fr]Compositions\n[ru]������� ������� (Compositions)\n[sk]Rozmiestnenia\n</multi>', '<multi>\n[en]Differ page layouts according to sections, articles...\n[fr]Varier les mises en page selon les rubriques, les articles...\n[ru]����������� �������� ������������ ������ ��� ������ ������, ������� � �.�.\n[sk]Me�te rozmiestnenie pod�a rubr�k, �l�nkov, at�.\n</multi>', 'outil', '', '003.003.000', '2012-09-22 21:00:03', '2012-09-22 21:00:03', '[3.0.0-dev;3.0.*]', '3.0'),
(500, 'CONTACT_LIBRE', 'Contact libre', 'Formulaire de contact libre', 'communication', '', '000.001.004', '2012-09-19 13:00:28', '2012-09-19 13:00:28', '[2.0.6;3.0.99]', '2.0,2.1,3.0'),
(501, 'CONTACTS', '<multi>\n[en]Contacts & Organizations\n[fr]Contacts & Organisations\n</multi>', '<multi>\n[en]Enhance SPIP with a contact management system\n[fr]Ajouter un gestionnaire de contacts � SPIP\n</multi>', 'auteur', '', '002.001.002', '2012-09-23 23:00:18', '2012-09-23 23:00:18', '[3.0.0-dev;3.0.*]', '3.0'),
(502, 'DICTIONNAIRES', '<multi>\n[fr]Dictionnaires\n</multi>', '<multi>\n[fr]Cr�er des dictionnaires\n</multi>', 'divers', '', '000.005.001', '2012-09-25 17:00:10', '2012-09-25 17:00:10', '[3.0.0;3.0.*]', '3.0'),
(503, 'EDITION_DIRECTE', 'Edition directe', '<multi>\n[de]Erm�glicht es Spip Objekete direkt auf von deren Seite her zu bearbeiten\n[en]Permits direct editing of the spip objects from their page\n[es]Posibilita editar directamente los objetos spip en el espacio privado\n[fr]Editer directement les objets spip depuis leur page\n[sk]Priama �prava objektov spipu z�ich str�nky\n</multi>', 'edition', '', '003.002.006', '2012-09-20 19:00:07', '2012-09-20 19:00:07', '[3.0.0;3.0.*]', '3.0'),
(484, 'SEO', '<multi>\n[en]SEO\n[fr]SEO\n[sk]SEO\n</multi>', '<multi>\n[en]Search Engine Optimisation\n[fr]Search Engine Optimisation\n[sk]Optimalizácia pre vyhľadávače\n</multi>', 'statistique', '', '001.007.002', '2012-09-10 21:00:02', '2012-09-10 21:00:02', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(485, 'BIBLE', 'Spip-Bible', '<multi>\n[fr]Pour faire rapidement des citations de la Bible\n</multi>', 'divers', '', '004.000.000', '2012-09-07 11:00:16', '2012-09-07 11:00:16', '[3.0.0;3.0.*]', '3.0'),
(74, 'CONVERTISSEUR', '<multi>\n[en]Format convertor\n[fr]Convertisseur de formats\n</multi>', '<multi>\n[en]Convert wiki, phpBB and quark xpress texts into SPIP\n[fr]Convertir les textes wiki, phpBB et quark xpress en SPIP\n</multi>', 'edition', '', '000.004.003', '2012-02-24 03:00:02', '2012-02-24 03:00:02', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(75, 'SPIPIRIS', 'Cooliris', '<multi>\n[fr]Cooliris, un mur d\'images 3D \n</multi>', 'multimedia', '', '002.000.000', '2012-07-21 19:00:14', '2012-07-21 19:00:14', '[3.0.0;3.0.*]', '3.0'),
(76, 'CORBEILLE', '<multi>\n[ar]ÿ³ÿ⿿ÿ© ÿ§ÿ⿿ÿ⿦ÿ⿡ÿ⿦ÿ⿿ÿ§ÿª\n[de]Papierkorb\n[en]Recycle bin\n[es]Papelera\n[fr]Corbeille\n[it]Cestino\n</multi>', '<multi>\n[ar]ÿ¥ÿ¯ÿ§ÿ±ÿ© ÿ§ÿ⿿ÿ⿦ÿ³ÿªÿ⿠ÿ¯ÿ§ÿª ÿ§ÿ⿿ÿ⿦ÿ˿ÿ¬ÿ˿ÿ¯ÿ© ÿÿŠ ÿ³ÿ⿿ÿ© ÿ§ÿ⿿ÿ⿦ÿ⿡ÿ⿦ÿ⿿ÿ§ÿª\n[de]Verwaltung der Elemente im Papierkorb\n[en]Managing documents chucked in the recycle bin.\n[es]Gesti�³n de los documentos enviados a la papelera.\n[fr]Gestion des documents mis �  la corbeille\n[it]Gestione dei documenti nel cestino.\n</multi>', 'maintenance', '', '003.000.001', '2011-11-04 11:44:04', '2011-11-04 11:44:04', '[3.0.0-beta;3.0.*]', '3.0'),
(482, 'PLUGONET', 'PlugOnet', '<multi>\n[en]Migrate from the plugin DTD to the the paquet DTD\n[fr]Migrer de la DTD plugin à celle de paquet\n[sk]Prechod zo zásuvn�ho modulu DTD na tento balík\n</multi>', 'outil', '', '000.006.009', '2012-09-15 12:00:19', '2012-09-15 12:00:19', '[3.0.0;3.0.*]', '3.0'),
(78, 'COULEURS_SPIP', 'Couleurs Spip', '<multi>\n[fr]Des textes en couleur\n</multi>', 'edition', '', '003.000.000', '2012-07-11 14:00:02', '2012-07-11 14:00:02', '[3.0.0;3.0.*]', '3.0'),
(79, 'COURTCIRCUIT', '<multi>\n[en]Short-circuit\n[fr]Court-circuit\n[sk]Kr�¡tke prepojenie\n</multi>', '<multi>\n[en]Direct access to articles\n[fr]Acc�s direct aux articles\n[sk]Priamy pr�­stup kÿ ÿl�¡nkom\n</multi>', 'outil', '', '002.003.003', '2012-07-26 13:10:37', '2012-07-26 13:10:37', '[2.1.0;3.0.99]', '2.1,3.0'),
(80, 'CK', '<multi>\n[ast]La Navaya KISS\n[br]Ar Gontell KISS\n[ca]El Ganivet KISS\n[de]KISS Taschenmesser\n[en]KISS Knife\n[es]La Navaja KISS\n[fr]Couteau KISS\n[gl]A navalla KISS\n[it]Coltellino KISS\n[nl]Het KISS Mes\n[pt_br]Canivete KISS\n[sk]Couteau KISS\n</multi>', '<multi>\n[ast]Simplifier certains r�glages SPIP\n[br]Simplifier certains r�glages SPIP\n[ca]Simplifier certains r�glages SPIP\n[de]Simplifier certains r�glages SPIP\n[en]Simplifier certains r�glages SPIP\n[es]Simplifier certains r�glages SPIP\n[fr]Simplifier certains r�glages SPIP\n[gl]Simplifier certains r�glages SPIP\n[it]Simplifier certains r�glages SPIP\n[nl]Enkele afstellingen va SPIP vereenvoudigen\n[pt_br]Simplifier certains r�glages SPIP\n[sk]zjednoduÿ¡�­ niektor� nastavenia SPIPu\n</multi>', 'maintenance', '', '001.001.009', '2012-08-17 04:01:03', '2012-08-17 04:01:03', '[2.0.0;3.0.*]', '2.0,2.1,3.0'),
(81, 'COUTEAU_SUISSE', '<multi>[en]Swiss Knife[fr]Le Couteau Suisse[ca]El Ganivet Suís[ar]???? ?????[nl]Het Zwitserland Mes[gl]A navalla suíza[es]La Navaja Suiza[de]Schweizer Taschenmesser[tr]?sviçre ÿak?s?[br]Ar Gontell Suis[pt_br]Canivete Suíço[ast]La Navaya Suiza[gl]A navalla suíza[ro]Cu?itul Elve?ian[it]Coltellino Svizzero</multi>', '<multi>[en]Lots of new and useful features for your site![fr]Plein de petites fonctionnalit�s nouvelles et utiles à votre site ![sk]Ve?a malých nových a užito?ných funkcií pre vašu stránku!</multi>', 'maintenance', '', '001.008.100', '2012-09-27 00:00:03', '2012-09-27 00:00:03', '[1.9.2;3.0.99]', '1.9,2.0,2.1,3.0');
INSERT INTO `spip_plugins` (`id_plugin`, `prefixe`, `nom`, `slogan`, `categorie`, `tags`, `vmax`, `date_crea`, `date_modif`, `compatibilite_spip`, `branches_spip`) VALUES
(82, 'CRAYONS', '<multi>\n[ar]ÿ§ÿ⿿ÿ⿿ÿ⿿ÿ⿦\n[de]Der Stift\n[en]Pencils\n[fr]Crayons\n[it]Pennarelli\n[nl]Potloden\n[ru]ÐšÐ°ÿ⿬Ð°Ð½Ð´Ð°ÿ˿ (Crayons)\n[sk]Farbiÿky\n</multi>', '<multi>\n[ar]ÿ⿡ÿ°ÿ§ ÿ§ÿ⿿ÿ⿦ÿ⿿ÿ­ÿ⿿ÿſ {{ÿ§ÿ⿿ÿ⿦ÿªÿ˿ÿ§ÿÿ± ÿ⿿ÿ⿿ÿ§ÿµÿ¯ÿ§ÿ± ÿ¡\n[de]�⿿nderungen in �¶ffentlichen Seiten direkt erledigen, Vorausetzung f�¼r Wikis mit SPIP\n[en]Quick editing from the public pages of the site\n[fr]�⿰dition rapide depuis les pages publiques du site\n[it]Modifica rapida dalle pagine pubbliche del sito\n[nl]Snel bewerken van de publieke pagina''s van de site.\n[ru]ÐŸÐ¾Ð·Ð²Ð¾Ð»ÿÐµÿ⿿ ÿ⿬ÐµÐ´Ð°Ðºÿ⿿Ð¸ÿ⿬Ð¾Ð²Ð°ÿ⿿ÿſ Ð¸Ð½ÿ⿿Ð¾ÿ⿬Ð¼Ð°ÿ⿠Ð¸ÿŽ Ð¿ÿ⿬ÿÐ¼Ð¾ Ð½Ð° ÿÐ°Ð¹ÿ⿿Ðµ, Ð½Ðµ Ð·Ð°ÿ⿦Ð¾Ð´ÿ Ð² Ð°Ð´Ð¼Ð¸Ð½Ð¸ÿÿ⿿ÿ⿬Ð°ÿ⿿Ð¸Ð²Ð½ÿƿÿŽ ÿ⿡Ð°ÿÿ⿿ÿſ\n[sk]R�½chle �ºpravy zÿ verejne pr�­stupnej str�¡nky.\n</multi>', 'edition', '', '001.013.008', '2012-08-17 04:01:14', '2012-08-17 04:01:14', '[1.9.0;*]', ''),
(83, 'CRITERE_MOTS', 'Crit�re mots', '<multi>\n[fr]S�lectionner des objets ayant des mots cl�s en communs\n</multi>', 'navigation', '', '002.000.000', '2012-08-01 14:00:11', '2012-08-01 14:00:11', '[3.0.0-dev;3.0.99]', '3.0'),
(84, 'SUIVANT_PRECEDENT', '<multi>\n[en]Next / Previous criteria\n[fr]Crit�res Suivant / Pr�c�dent\n</multi>', '<multi>\n[en]Adds loops criteria <code>{suivant}</code> and <code>{precedent}</code>\n[fr]Ajoute des crit�res de boucles <code>{suivant}</code> et <code>{precedent}</code>\n</multi>', 'navigation', '', '001.003.002', '2012-08-27 04:00:17', '2012-08-27 04:00:17', '[2.1;3.0.99]', '2.1,3.0'),
(85, 'CSS_IMBRIQUES', 'CSS imbriqu�s', '', 'outil', '', '003.000.001', '2012-08-22 13:00:03', '2012-08-22 13:00:03', '[3.0.0;3.*]', ''),
(504, 'FIL_ARIANE', 'Fil d\'Ariane', '', 'divers', '', '000.001.006', '2012-09-24 20:00:02', '2012-09-24 20:00:02', '[2.1.0;3.0.*]', '2.1,3.0'),
(481, 'PAGES_MOBILES', '<multi>\n[fr]Pages pour mobiles\n</multi>', '<multi>\n[fr]Redirigez vers la meilleure page disponible pour les mobiles\n</multi>', 'navigation', '', '001.000.001', '2012-09-16 17:00:02', '2012-09-16 17:00:02', '[3.0.4;3.0.*]', '3.0'),
(87, 'DATE_INSCRIPTION', '<multi>[fr]Date d\'inscription [en]Registration date [es]Fecha de inscripci�³n</multi>', '<multi>\n	[fr] Une date d\'inscription pour les auteurs\n	[en] A registration date for authors\n	[es] Una fecha de inscripci�³n para los autores\n	</multi>', 'auteur', '', '000.001.001', '2012-07-27 12:00:02', '2012-07-27 12:00:02', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(88, 'DEBUT_FIN', 'Date de d�but, date de fin', '', 'date', '', '001.000', '2012-01-12 05:00:02', '2012-01-12 05:00:02', '[2.1.0;]', '2.1,3.0,3.1'),
(90, 'DIDA', 'Didaspip', 'Int�grer un projet Didapages dans SPIP', 'divers', '', '002.009.001', '2012-06-18 12:00:03', '2012-06-18 12:00:03', '', '1.9,2.0,2.1,3.0,3.1'),
(91, 'DOCUMENTATION', '<multi>\n[en]Documentation template\n[fr]Squelette Documentation\n[sk]ÿ abl�³na Dokument�¡cia\n</multi>', '<multi>\n[en]Documentation template\n[fr]Squelette Documentation\n[sk]ÿ abl�³na Dokument�¡cia\n</multi>', 'squelette', '', '003.000.002', '2012-02-17 11:00:07', '2012-08-13 15:00:03', '[3.0.0-beta;3.0.*]', '3.0'),
(92, 'DOCUMENTATION2LATEX', 'Documentation vers LaTeX', '<multi>\n[fr]Permettre de convertir le squelette documentation du HTML vers le LaTeX\n</multi>', 'edition', '', '001.000.000', '2012-04-02 00:00:02', '2012-04-02 00:00:02', '[3.0.0-beta;3.0.*]', '3.0'),
(93, 'DUPLICATOR', 'Duplicator', '<multi>\n[fr]Dupliquer une rubrique et son contenu\n</multi>', 'edition', '', '000.002.000', '2012-07-19 03:00:46', '2012-07-19 03:00:46', '[3.0.0;3.0.*]', '3.0'),
(505, 'FORMIDABLE', 'Formidable', '<multi>\n[fr]G�n�rateur de formulaires\n</multi>', 'communication', '', '001.003.003', '2012-09-20 15:00:04', '2012-09-20 15:00:04', '[3.0.0-dev;3.0.99]', '3.0'),
(506, 'FORMULAIREUPLOAD', '<multi>\n[fr]Formulaire Upload\n</multi>', '<multi>\n[fr]Upload de fichiers depuis l''espace public\n</multi>', 'outil', '', '001.000.003', '2012-09-21 11:00:02', '2012-09-21 11:00:02', '[3.0.0;3.0.*]', '3.0'),
(95, 'ENTRAVAUX', '<multi>\n[en]Under construction\n[fr]En travaux\n[sk]Rekonÿ¡truuje sa\n</multi>', '<multi>\n[en]Indicate a maintenance phase\n[fr]Indiquer une phase de maintenance\n[sk]Nastaviÿ¥ str�¡nku rekonÿ¡trukcie\n</multi>', 'maintenance', '', '003.001.007', '2012-07-26 13:12:04', '2012-07-26 13:12:04', '[3.0.0-dev;3.0.*]', '3.0'),
(96, 'EUDOCK', '<multi>\n[fr]EU Dock\n</multi>', '<multi>\n[fr]Effet ''Dock'' �  la mode ''Apple'' en javascript\n</multi>', 'multimedia', '', '001.022.000', '2012-05-08 10:00:16', '2012-05-08 10:00:16', '[2.0;[', '2.0,2.1,3.0,3.1'),
(97, 'EXCLURE_SECT', 'Exclure secteur', '<multi>\n[fr]Exclure automatiquement des boucles certains secteurs\n</multi>', 'outil', '', '002.000.004', '2012-07-13 01:00:04', '2012-07-13 01:00:04', '[3.0.0-beta;3.0.99]', '3.0'),
(478, 'NOTATION', '<multi>\n[en]Rating\n[fa]رتبٿ بٿدٿ\n[fr]Notation\n[ru]полосование (Notation)\n[sk]Hodnotenie\n</multi>', '<multi>\n[en]Assign a rating to SPIP elements\n[fa]اختصاص ٿٿ رتبٿ⿿بٿدٿ بٿ عٿاصرٿ از اسپٿپ\n[fr]Attribuer une note aux �l�ments de SPIP\n[ru]Усѿанавливаеѿ ѿейѿинг элеменѿов\n[sk]Priradiť prvkom SPIPu hodnotenie\n</multi>', 'communication', '', '002.000.004', '2012-09-09 11:00:01', '2012-09-09 11:00:01', '[3.0.0-beta;3.0.*]', '3.0'),
(476, 'NOIE', 'Changez de navigateur !', 'Changez de navigateur pour mieux voir le Web !', 'performance', '', '001.003.000', '2012-09-15 04:00:46', '2012-09-15 04:00:46', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(477, 'NOSPAM', 'NoSPAM', '<multi>\n		[fr]Limiter le risque de spams dans les forums\n		[en]Reduce the risk of spams in the forums\n		</multi>', 'performance', '', '001.000.003', '2012-09-16 04:00:39', '2012-09-16 04:00:39', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(100, 'FACD', 'FACD', '<multi>\n[en]Conversion queue management for documents\n[fr]Gestion de file d\'attente pour la conversion de documents\n[sk]Riadenie radu dokumentov, ktor� ÿakaj�º na konverziu\n</multi>', 'outil', '', '000.001.002', '2012-08-16 12:00:23', '2012-08-16 12:00:23', '[3.0.0;3.0.99]', '3.0'),
(475, 'MULTIDOMAINES', 'Multidomaines', '<multi>\n[fr]Associer un secteur à un domaine\n</multi>', 'maintenance', '', '002.001.002', '2012-09-06 15:00:28', '2012-09-06 15:00:28', '[3.0.0;3.0.*]', '3.0'),
(102, 'FEEDBURNER', 'FeedBurner', '<multi>\n[fr]Utilisez FeedBurner sur votre site\n</multi>', 'communication', '', '001.000.000', '2011-11-10 11:56:38', '2011-11-10 11:56:38', '[2.0.0;3.0.*]', '2.0,2.1,3.0'),
(103, 'FLATTR', 'Flattr', '<multi>\n			[fr]Donnez avec Flattr\n			[en]Donate with Flattr\n		</multi>', 'divers', '', '000.002.003', '2012-03-05 18:00:02', '2012-03-05 18:00:02', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(104, 'FONCTIONS_IMAGES', '<multi>\n[en]Images functions\n[fr]Fonctions d\'images\n</multi>', '<multi>\n[en]Filters for images functions\n[fr]Filtres pour le traitement des images\n</multi>', 'multimedia', '', '000.006.001', '2012-06-25 09:00:16', '2012-06-25 09:00:16', '[3.0.0;3.0.99]', '3.0'),
(105, 'FMP3', 'Fond MP3', '', 'multimedia', '', '003.000.000', '2012-08-07 19:00:14', '2012-08-07 19:00:14', '[3.0.0-alpha2;[', '3.0,3.1'),
(474, 'MESSAGERIE', 'Messagerie', '<multi>\n[fr]une messagerie interne\n</multi>', 'communication', '', '003.000.001', '2012-09-04 15:00:25', '2012-09-04 15:00:25', '[3.0.0;3.0.*]', '3.0'),
(107, 'FORUMSECTORISE', 'Forum Sectoris�', '<multi>\n[fr]Autoriser les forums sur un secteur particulier\n</multi>', 'communication', '', '000.006.000', '2012-04-15 16:00:01', '2012-04-15 16:00:01', '[2.1.0;3.0.99]', '2.1,3.0'),
(108, 'FPDF', 'FPDF', 'Librairie FPDF pour fabriquer des pdfs.', 'divers', '', '000.000.002', '2012-07-28 15:00:09', '2012-07-28 15:00:09', '', '1.9,2.0,2.1,3.0,3.1'),
(109, 'FRIMOUSSES', 'Frimousses', 'Mettre des smileys dans le texte', 'edition', '', '001.002.002', '2011-12-23 15:00:26', '2011-12-23 15:00:26', '[1.9.2;3.0.99]', '1.9,2.0,2.1,3.0'),
(110, 'FULLTEXT', 'Fulltext', '<multi>\n[en]FULLTEXT indexation to speed up searches\n[fr]Indexation FULLTEXT pour acc�l�rer les recherches\n[sk]Indexovanie CEL�⿰HO TEXTU na zr�½chlenie vyhÿ¾ad�¡van�­\n</multi>', 'navigation', '', '000.007.000', '2012-07-27 04:00:18', '2012-07-27 04:00:18', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(111, 'FUSIONMOTS', 'Fusion de mots-cl�s', '<multi>\n[fr]Vous avez trop de mots ? Fusionnez les !\n</multi>', 'navigation', '', '001.000.000', '2011-11-19 11:34:40', '2011-11-19 11:34:40', '[3.0.0-beta;3.0.*]', '3.0'),
(523, 'ZCORE', 'Z-core', '<multi>\n[en]Z framework for SPIP (Zpip)\n[fr]Z Framework pour SPIP (Zpip)\n</multi>', 'squelette', '', '002.000.000', '2012-09-27 04:00:22', '2012-09-27 04:00:22', '[3.0.0;3.0.*]', '3.0'),
(113, 'GALCARO', 'Galerie Caro', 'Galerie d\'images carr�es', 'multimedia', '', '001.000.000', '2012-02-29 04:00:21', '2012-02-29 04:00:21', '[2.0.0;]', '2.0,2.1,3.0,3.1'),
(114, 'GCALENDAR', 'GCalendar', 'Utiliser Google Calendar', 'aucune', '', '001.000.010', '2012-06-26 09:00:12', '2012-06-26 09:00:12', '[1.9.2;3.1.99]', '1.9,2.0,2.1,3.0,3.1'),
(115, 'GDATA', 'GData: boucles Google', '', 'outil', '', '000.001', '2012-01-15 17:00:49', '2012-01-15 17:00:49', '[2.1.0;]', '2.1,3.0,3.1'),
(116, 'GEOGRAPHIE', 'Geographie', '', 'divers', '', '000.003.000', '2012-09-04 11:00:09', '2012-09-04 11:00:09', '[2.1.0;]', '2.1,3.0,3.1'),
(117, 'GESTIONML', 'Gestion ML avec SOAP', '<multi>\n[fr]G�rer les mailing lists chez votre h�bergeur avec le protocole SOAP\n</multi>', 'communication', '', '001.000.000', '2012-07-23 13:00:10', '2012-07-23 13:00:10', '[3.0.0;3.0.*]', '3.0'),
(118, 'GETID3', 'GetId3', '<multi>\n[en]Read and write audio tags\n[fr]Lire et �crire les tags audio\n[sk]ÿſ�­tanie aÿ z�¡pis audio znaÿiek\n</multi>', 'multimedia', '', '001.002.001', '2012-08-16 18:00:16', '2012-08-16 18:00:16', '[3.0.2;3.0.99]', '3.0'),
(120, 'GLOSSAIRE', 'Glossaire interne', 'Gestion automatique d\'un glossaire interne au site', 'edition', '', '001.000.000', '2011-10-09 16:00:17', '2011-10-09 16:00:17', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(121, 'GOOGLEAJAXSEARCH', 'Google Ajax Search', '', 'multimedia', '', '000.001.002', '2012-03-27 04:00:06', '2012-03-27 04:00:06', '[3.0.0-dev;[', '3.0,3.1'),
(122, 'GOOGLEANALYTICS', 'Google Analytics', '<multi>\n[fr]Utiliser le service Google Analytics\n</multi>', 'statistique', '', '000.004.001', '2012-05-15 21:00:29', '2012-05-15 21:00:29', '[1.9.2;3.0.*]', '1.9,2.0,2.1,3.0'),
(123, 'GVIEWER', 'Google Viewer', '<multi>\n[fr]Mod�les dinsertion de documents utilisant le lecteur de documents de Google\n</multi>', 'edition', '', '000.003.000', '2012-05-28 19:00:08', '2012-05-28 19:00:08', '[2.1.0;3.0.99]', '2.1,3.0'),
(124, 'GOOGLEPLUS1', 'Google +1', '<multi>\n[en]Add a Google +1 button\n[fr]Ajoute un bouton Google +1\n</multi>', 'communication', '', '000.004.001', '2011-11-03 21:25:53', '2011-11-03 21:25:53', '[2.0.10;3.0.*]', '2.0,2.1,3.0'),
(125, 'GRAVATAR', 'Gravatar', '<multi>\n		[fr]Afficher le Gravatar d\'un auteur ou d\'un contributeur de forum\n		[en]Display Gravatar for author or forum poster\n		</multi>', 'communication', '', '001.003.002', '2012-07-26 13:13:48', '2012-07-26 13:13:48', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(126, 'GREVES', 'En gr�ve', '<multi>\n[fr]Ce n''est qu''un d�but, continuons le combat !\n</multi>', 'communication', '', '000.002.000', '2012-01-17 00:00:02', '2012-01-17 00:00:02', '[2.1.0;3.0.*]', '2.1,3.0'),
(127, 'GMA', '<multi>\n[fr]Groupes arborescents de mots cl�s\n</multi>', '<multi>\n[fr]Permet de d�finir des sous groupes de mots cl�s\n</multi>', 'navigation', '', '001.001.002', '2012-07-13 20:00:14', '2012-07-13 20:00:14', '[3.0.0;3.1.*]', '3.0,3.1'),
(522, 'TAA', 'Traduction d\'articles autrement', '<multi>\n[fr]Rendre la traduction des articles plus ais�e.\n[sk]U�ah�ite si prekladanie �l�nkov.\n</multi>', 'edition', '', '001.003.004', '2012-09-26 16:00:03', '2012-09-26 16:00:03', '[3.0.0;3.0.*]', '3.0'),
(129, 'ICONES_SEMANTIQUES', '<multi>\r\n		[fr]Ic�´nes s�mantiques\r\n		[en]Semantic Icons\r\n		</multi>', '<multi>\r\n		[fr]Des ic�´nes s�mantiques pour le Porte plume\r\n		[en]Semantic Icons for the Quill\r\n		</multi>', 'edition', '', '000.001.001', '2011-10-07 20:08:40', '2011-10-07 20:08:40', '[2.0.2;3.0.99]', '2.0,2.1,3.0'),
(472, 'MEMOIZATION', 'Memoization', '<multi>\r\n		[fr]Gestion du cache de SPIP par diverses m�thodes.\r\n		[en]Various methods to process SPIP''s cache.\r\n		</multi>', 'performance', '', '001.002.001', '2012-09-12 11:00:03', '2012-09-12 11:00:03', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(473, 'MESFAVORIS', 'Mes Favoris 2', '<multi>\n[en]Select favorites\n[fr]S�lection de favoris\n[ru]побавление маѿеѿиалов в избѿанное на сайѿе\n[sk]Výber obľúbených objektov\n</multi>', 'navigation', '', '002.003.002', '2012-09-14 15:00:02', '2012-09-14 15:00:02', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(131, 'IMAPDEPART', 'Image map des d�partements', 'Mod�le pour afficher une imagemap des d�partements fran�§ais', 'divers', '', '000.002.000', '2012-04-12 13:00:02', '2012-04-12 13:00:02', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(132, 'IMAGESACTIVES', 'Images Actives', '', 'squelette', '', '001.000.000', '2012-06-07 10:00:03', '2012-06-07 10:00:03', '[2.0.0;3.1.*[', '2.0,2.1,3.0,3.1'),
(133, 'INCLUREAJAXLOAD', 'AjaxLoad pour #INCLURE', 'Ajoute une option <code>{ajaxload}</code> �  la balise <code>#INCLURE</code>', 'outil', '', '001.002.000', '2012-03-28 20:00:18', '2012-03-28 20:00:18', '[2.1.0;3.0.99]', '2.1,3.0'),
(134, 'INSERER_MODELES', 'Ins�rer Mod�les', '<multi>\n[fr]Une aide �  l''insertion des mod�les dans vos textes\n</multi>', 'edition', '', '001.001.001', '2012-07-19 18:00:07', '2012-07-19 18:00:07', '[3.0.0-beta;3.0.*]', '3.0'),
(135, 'INTERTITRESTDM', 'Intertitres hi�rarchis�s et table des mati�res', 'G�n�rer automatiquement une table des mati�res', 'edition', '', '000.009.005', '2012-08-01 12:00:08', '2012-08-01 12:00:08', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(136, 'JAPPIX_MINI', 'Jappix Mini', '<multi>\n[fr]Un chat dans votre spip\n</multi>', 'communication', '', '001.000.000', '2012-09-03 16:00:15', '2012-09-03 16:00:15', '[3.0.0;3.*]', ''),
(137, 'JS_SCROLLER', '<multi>\n[fr]Javascript Scroller\n</multi>', '<multi>\n[fr]Un scroller javascript de donn�es XML\n</multi>', 'squelette', '', '001.044.001', '2012-05-09 01:45:15', '2012-05-09 01:45:15', '[2.0.0;[', '2.0,2.1,3.0,3.1'),
(138, 'JEUX', 'Des jeux dans vos articles', '<multi>\n[fr]Cr�ez des jeux ou des exercices de toute sorte.\n</multi>', 'divers', '', '003.001.005', '2012-08-17 16:00:32', '2012-09-14 12:00:06', '[3.0.0;3.0.99]', '3.0'),
(139, 'JAZ', 'JAZ', '', 'divers', '', '001.001.000', '2012-08-02 16:00:03', '2012-08-02 16:00:03', '[2.1.0;*]', ''),
(140, 'JOOMLA2SPIP', 'Joomla2SPIP', '', 'maintenance', '', '000.002.002', '2012-06-17 13:00:13', '2012-06-17 13:00:13', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(141, 'JPGRAPH', 'JpGraph', 'Biblioth�que graphique pour g�n�rer des graphes', 'multimedia', '', '000.003.001', '2012-07-31 10:00:09', '2012-07-31 10:00:09', '[2.0.0;3.1.99[', '2.0,2.1,3.0,3.1'),
(142, 'JQUERYCORNER', 'jQuery Corner', '<multi>\n[fr]Le plugin qui arrondit les angles\n</multi>', 'multimedia', '', '000.004.002', '2012-07-04 20:00:02', '2012-07-04 20:00:02', '[2.1.0;3.0.99]', '2.1,3.0'),
(143, 'JQUERYMASONRY', 'jQuery Masonry', '<multi>\n[fr]Le plugin qui range vos blocs\n</multi>', 'multimedia', '', '000.004.001', '2012-04-17 18:00:25', '2012-04-17 18:00:25', '[2.1.0;3.0.99]', '2.1,3.0'),
(144, 'JQUERYSUPERFISH', 'Menu jQuery Superfish', '<multi>\n[fr]Affiche un menu d�roulant\n</multi>', 'navigation', '', '000.005.003', '2012-05-20 19:00:03', '2012-05-20 19:00:03', '[2.1.0;3.0.99]', '2.1,3.0'),
(145, 'KAYE', '<multi>\n[fr]kaye\n</multi>', '<multi>\n[fr]Un cahier de texte �lectronique pour l\'�cole primaire.\n</multi>', 'divers', '', '003.000.005', '2012-07-21 10:00:02', '2012-07-21 10:00:02', '[3.0.0-rc;3.0.*]', '3.0'),
(146, 'LANGONET', 'LangOnet', 'V�rifier, g�n�rer, rechercher ou afficher les items de langue', 'outil', '', '000.007.004', '2012-08-16 04:00:45', '2012-08-16 04:00:45', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(147, 'LANGUEPREFEREE', 'Langue pr�f�r�e', 'Diriger l''internaute vers le secteur de sa langue', 'navigation', '', '000.004.002', '2012-08-10 00:00:11', '2012-08-10 00:00:11', '[1.9.2;3.0.99]', '1.9,2.0,2.1,3.0'),
(148, 'LATEXWHEEL', 'LaTeXWheel', '', 'edition', '', '001.000.000', '2012-03-27 22:00:56', '2012-03-27 22:00:56', '[3.0.0 ;[', '3.0,3.1'),
(149, 'PLAYER', 'Lecteur Multim�dia', '<multi>[en]Read sounds and videos[fa]?????? ??? ? ?????[fr]Lire des sons et des vid�os[ru]????? ? ????? ?????[sk]Prehrávanie zvukov a videí</multi>', 'multimedia', '', '002.001.001', '2012-08-20 04:00:21', '2012-08-20 04:00:21', '[3.0.0;3.0.*]', '3.0'),
(150, 'LEGENDES', '<multi>\n[en]Captions\n[fr]L�gendes\n</multi>', '<multi>\n[en]Add captions on photos\n[fr]L�gender ses photos\n</multi>', 'multimedia', '', '001.000.002', '2012-07-03 16:00:32', '2012-07-03 16:00:32', '[3.0.0;3.0.*]', '3.0'),
(151, 'LICENCE', '<multi>\n[en]License\n[fr]Licence\n[sk]Licencia\n</multi>', '<multi>\n[en]A license for articles and documents\n[fr]Une Licence pour articles et documents\n[sk]Licencia pre ÿl�¡nky aÿ dokumenty\n</multi>', 'divers', '', '000.004.003', '2012-08-08 20:00:06', '2012-08-08 20:00:06', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(152, 'LINKS', 'Liens explicites', 'Styles et pictos explicitant les liens du site', 'navigation', '', '002.003.005', '2012-02-22 12:00:02', '2012-02-22 12:00:02', '[2.0.0;3.0.*]', '2.0,2.1,3.0'),
(153, 'LOGAHOLIC', 'Logaholic', '<multi>\n[fr]Utiliser le service Logaholic\n</multi>', 'statistique', '', '000.000.002', '2012-06-24 17:00:02', '2012-06-24 17:00:02', '[1.9.2;3.0.*]', '1.9,2.0,2.1,3.0'),
(154, 'MALETTRE', 'Ma lettre', '<multi>\n[fr]Compose une lettre d\'information  sur mesure\n</multi>', 'communication', '', '003.000.002', '2012-06-11 11:00:08', '2012-06-11 11:00:08', '[3.0.0-dev;3.0.*]', '3.0'),
(155, 'MAILCRYPT', 'MailCrypt 2', '<multi>\n[fr]Prot�ger les liens de courriels\n</multi>', 'edition', '', '002.003.000', '2012-06-20 18:00:13', '2012-06-20 18:00:13', '[2.1.0;3.0.99]', '2.1,3.0'),
(156, 'MANUELSITE', '<multi>\n[en]Website Editor Manual\n[fr]Manuel de r�daction du site\n[sk]Manu�¡l na publikovanie str�¡nky\n</multi>', '<multi>\n[en]A manual specific to your site for your editors\n[fr]Un manuel sp�cifique �  votre site pour vos r�dacteurs\n[sk]ÿ peci�¡lny manu�¡l na vaÿ¡u str�¡nku pre vaÿ¡ich redaktorov\n</multi>', 'edition', '', '000.008.001', '2012-07-28 04:00:33', '2012-07-28 04:00:33', '[2.1.0;3.0.99]', '2.1,3.0'),
(157, 'MASQUER', 'Masquer', 'Cacher des contenus sur le site public', 'navigation', '', '000.005.000', '2012-06-04 04:00:08', '2012-06-04 04:00:08', '[2.0.0;3.99.99]', '2.0,2.1,3.0,3.1'),
(470, 'IMGCOMPARE', 'Images compare', 'Comparer des images', 'multimedia', '', '000.000.002', '2012-09-06 12:00:47', '2012-09-06 12:00:47', '[2.1;3.0.99]', '2.1,3.0'),
(471, 'TIMEPICKER', 'TimePicker', '', 'outil', '', '001.000.000', '2012-09-16 22:00:02', '2012-09-16 22:00:02', '[3.0.1;3.0.*]', '3.0'),
(159, 'ACCORDEON', 'Menu accord�on', '<multi>\n[fr]Animer un menu avec effet d\'accord�on\n</multi>', 'navigation', '', '003.001.000', '2012-08-14 13:00:25', '2012-08-14 13:00:25', '[3.0.0;3.0.99]', '3.0'),
(160, 'BABBI', 'Menu babbibel', '', 'navigation', '', '003.000', '2012-07-30 22:00:01', '2012-07-30 22:00:01', '[1.9.2;3.0.99)', '1.9,2.0,2.1,3.0'),
(161, 'MLL', '<multi>\n[en]Language menu as links\n[fr]Menu de langues avec liens\n[sk]Jazykov� menu sÿ odkazmi\n</multi>', '<multi>\n[en]View languages â⿬⿹â⿬⿹as clickable links\n[fr]Afficher les langues sous forme de liens cliquables\n[sk]Zobraziÿ¥ jazyky voÿ forme klikateÿ¾n�½ch odkazov\n</multi>', 'navigation', '', '001.001.007', '2012-07-26 13:15:37', '2012-07-26 13:15:37', '[2.0.10;3.0.*]', '2.0,2.1,3.0'),
(162, 'MENUS', '<multi>\n[ar]ÿ§ÿ⿿ÿ⿿ÿ˿ÿ§ÿ¦ÿ⿦\n[de]Menus\n[en]Menus\n[fr]Menus\n[it]Menus\n[sk]Ponuky menu\n</multi>', '<multi>\n[ar]ÿ¥ÿ⿠ÿ´ÿ§ÿ¡ ÿ⿿ÿ˿ÿ§ÿ¦ÿ⿦ ÿ´ÿ®ÿµÿŠÿ©\n[de]Men�¼s bequem im Redaktionssystem gestalten.\n[en]Create your own custom menus.\n[fr]Cr�ez vos menus personnalis�s.\n[it]Crea i tuoi men�¹ in redazione.\n[sk]Vytvorte svoje vlastn� ponuky menu.\n</multi>', 'navigation', '', '001.002.004', '2012-08-25 05:00:02', '2012-09-22 22:00:51', '[2.0.9;3.0.*]', '2.0,2.1,3.0'),
(163, 'MENUDER', 'Menu d�roulant', 'Menu d�roulant en CSS sans limitation de profondeur', 'navigation', '', '002.001.004', '2012-05-22 12:00:03', '2012-05-22 12:00:03', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(164, 'MESABONNES', 'Mes abonn�s', 'Gestion d\'abonnement pour logiciels de publipostages', 'communication', '', '000.004.000', '2012-08-02 07:00:02', '2012-08-02 07:00:02', '[2.1.0;3.0.99]', '2.1,3.0'),
(165, 'MES_PREFERENCES', '<multi>\n[fr]Mes pr�f�rences\n</multi>', '<multi>\n[fr]Ajouter des pr�f�rences utilisateur\n</multi>', 'theme', '', '000.001.002', '2012-09-04 12:00:44', '2012-09-04 12:00:44', '[3.0.0-rc;3.0.*]', '3.0'),
(468, 'GIS', 'GIS', '<multi>\n[en]Geographic Information System\n[es]Sistema de información geográfica\n[fr]Syst�me d\'information g�ographique\n[sk]Geografický informačný syst�m\n</multi>', 'divers', '', '004.001.007', '2012-09-10 01:00:03', '2012-09-10 01:00:10', '[3.0.0;3.0.*]', '3.0'),
(507, 'FORMS', 'Formulaires et Tables', '', 'outil', '', '000.005.000', '2012-09-17 19:04:10', '2012-09-17 19:04:10', '[v3 ;[', '1.9,2.0,2.1,3.0,3.1'),
(508, 'GALLERIA', 'Galleria plugin pour SPIP', '', 'multimedia', '', '001.002.001', '2012-09-20 18:00:49', '2012-09-20 18:00:49', '[1.9.2;3.0.*]', '1.9,2.0,2.1,3.0'),
(509, 'HASHER', 'Hash documents', '<multi>\n[en]Save documents in <code>IMG/mp3/a/b/c/file.mp3</code>\n[fr]Enregistrer les documents dans <code>IMG/mp3/a/b/c/fichier.mp3</code>\n</multi>', 'performance', '', '002.000.001', '2012-09-19 22:00:02', '2012-09-19 22:00:02', '[3.0.0;3.0.99]', '3.0'),
(168, 'PHOTO_INFOS', '<multi>\n[en]Photo metadata\n[fr]Metadonn�es photo\n</multi>', '<multi>\n[en]Display EXIF, IPTC and GPS data from a JPEG file\n[fr]Afficher les infos EXIF, GPS et IPTC d\'un fichier JPEG\n</multi>', 'multimedia', '', '002.000.001', '2011-11-14 13:02:46', '2011-11-14 13:02:46', '[3.0.0-beta;3.0.*]', '3.0'),
(520, 'GEOPORTAIL', 'SPIP-G�oportail', 'Afficher des objets SPIP sur une carte', 'divers', '', '002.000', '2012-09-23 14:00:05', '2012-09-23 14:00:05', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(521, 'THUMBSITES', 'Thumbsites', '<multi>\n[fr]Une vignette pour les objets sites\n</multi>', 'multimedia', '', '001.000.000', '2012-09-24 04:00:33', '2012-09-24 04:00:33', '[3.0.0;3.0.*]', '3.0'),
(170, 'MINIBANDO', 'minibando', '<multi>\n[ar]ÿ´ÿ±ÿŠÿ· ÿ£ÿ¯ÿ˿ÿ§ÿª ÿµÿºÿŠÿ± ÿ⿿ÿ⿿ÿƿÿ«ÿŠÿ± ÿ⿦ÿ⿠ ÿ§ÿ⿿ÿ˿ÿ¸ÿ§ÿ¦ÿ!\n[en]A minibando for a maximum of functionalities!\n[fr]Un minibando pour un maximum de fonctionnalit�s !\n</multi>', 'navigation', '', '001.001.000', '2012-08-27 04:00:27', '2012-08-27 04:00:27', '[3.0.0-dev;3.0.99]', '3.0'),
(171, 'MINIGRISPIP', '<multi>\n[fr]MiniGriSpip\n</multi>', '<multi>\n[fr]Un squelette simple pour d�buter avec SPIP\n</multi>', 'squelette', '', '002.000.008', '2012-03-31 19:00:03', '2012-03-31 19:00:03', '[2.0.0;3.0.*]', '2.0,2.1,3.0'),
(172, 'FB_MODELES', '<multi>\n[fr]Facebook Models\n[sk]ÿ abl�³ny Facebooku\n</multi>', '<multi>\n[fr]Mod�les pour inclure les modules sociaux Facebook\n[sk]ÿ abl�³ny na vloÿ¾enie modulov soci�¡lnej siete Facebook\n</multi>', 'navigation', '', '000.020.000', '2012-05-08 01:15:11', '2012-09-16 04:00:33', '[2.1.0;3.1.99]', '2.1,3.0,3.1'),
(173, 'MEDIA', 'Mod�les media', '<multi>\n[fr]Mod�les alternatifs pour l''insertion des documents\n</multi>', 'edition', '', '001.000.000', '2012-07-03 19:00:04', '2012-07-03 19:00:04', '[3.0.0;3.0.99]', '3.0'),
(174, 'MOTS_TECHNIQUES', 'Mots techniques', '<multi>\n[en]Adds a "technical" specialization to the keywords groups\n[fa]ÿ§ÿÿ²ÿ˿ÿ¯ÿ⿠ ÿ«ÿÿ⿠ÿ» ÿ˿ÿŠÿ˿ÿ⿡â⿬ſÿ³ÿ§ÿ²ÿŠ ÿ¨ÿ⿡ ÿŠÿƿ ÿ¯ÿ±ÿ˿ÿ⿡ ÿ§ÿ² ÿƿÿ⿿ÿŠÿ¯ÿ˿ÿ§ÿ˿ÿ⿡â⿬ſÿ⿡ÿ§.\n[fr]Ajoute une sp�cialisation ÿ«techniqueÿ» aux groupes de mots cl�s.\n[ru]ÐŸÐ¾Ð·Ð²Ð¾Ð»ÿÐµÿ⿿ Ð²ÿ⿹Ð´ÐµÐ»ÿÿ⿿ÿſ Ð³ÿ⿬ÿƿÐ¿Ð¿ÿƿ ÐºÐ»ÿŽÿ⿡ÐµÐ¹ Ð´Ð»ÿ ÿÐ»ÿƿÐ¶ÐµÐ±Ð½ÿ⿹ÿ⿦ ÿ⿠ÐµÐ»ÐµÐ¹\n[sk]Skupine kÿ¾�ºÿov�½ch slov prid�¡ spresnenie "technick�"\n</multi>', 'outil', '', '001.000.000', '2012-08-20 04:00:32', '2012-08-20 04:00:32', '[3.0.0-beta;3.0.*]', '3.0'),
(175, 'MOTUS', 'Motus', '<multi>\n[fr]Groupes de mots par rubrique\n</multi>', 'maintenance', '', '001.001.001', '2012-07-13 16:00:03', '2012-07-13 16:00:03', '[3.0.0-beta;3.0.*]', '3.0'),
(465, 'FAQ', 'D�finitions et FAQ', 'FAQ d�pliable', 'navigation', '', '002.001.021', '2012-09-06 16:00:25', '2012-09-06 16:00:25', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(510, 'IECONFIG', 'Import-Export', '<multi>\n[fr]Importer, exporter des configurations de plugins\n[sk]Nahra�, exportova� nastavenia z�suvn�ch modulov\n</multi>', 'maintenance', '', '001.001.002', '2012-09-25 18:01:08', '2012-09-25 18:01:08', '[3.0.0;3.0.99]', '3.0'),
(177, 'MULTILINGUE', '<multi>\n[fr]Site multilingue facile\n[sk]Jednoduch�¡ viacjazyÿn�¡ str�¡nka\n</multi>', '<multi>\n[fr]Cr�er facilement un site multilingue\n[sk]Vytvorte jednoduch�º viacjazyÿn�º str�¡nku\n</multi>', 'edition', '', '000.002.001', '2012-08-09 09:00:09', '2012-08-09 09:00:09', '[2.0.0;3.0.*]', '2.0,2.1,3.0'),
(178, 'MULTILANG', 'Multilang', '<multi>\n[en]Control the display of the contents of multi tags with a language menu\n[fr]G�rer l''affichage du contenu des tags multi par un menu\n[it]G�rer l''affichage du contenu des tags multi par un menu\n[ru]Ð£Ð¿ÿ⿬Ð°Ð²Ð»ÿÐµÿ⿿ Ð¾ÿ⿿Ð¾Ð±ÿ⿬Ð°Ð¶ÐµÐ½Ð¸ÐµÐ¼ ÿÐ¾Ð´Ðµÿ⿬Ð¶Ð¸Ð¼Ð¾Ð³Ð¾ Ð½ÐµÿÐºÐ¾Ð»ÿſÐºÐ¸ÿ⿦ ÿ⿿ÐµÐ³Ð¾Ð² ÿÐ·ÿ⿹ÐºÐ¾Ð²Ð¾Ð³Ð¾ Ð¼ÐµÐ½ÿŽ\n[sk]Riadiÿ¥ zobrazenie obsahu kombinovan�½ch tagov podÿ¾a menu\n</multi>', 'edition', '', '000.007.000', '2012-08-03 11:00:13', '2012-08-03 11:00:13', '[2.1;3.0.99]', '2.1,3.0'),
(179, 'MUTUALISATION', '<multi>\r\n			[fr]Mutualisation facile\r\n			[es]Mutualizaci�³n f�¡cil\r\n			[en]Easy mutualisation\r\n		</multi>', 'Cr�er une ferme �  Spip', 'maintenance', '', '000.009.001', '2012-04-02 05:00:04', '2012-04-02 05:00:04', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(180, 'NIVOSLIDER', 'NivoSlider', '<multi>\n[en]JQuery slideshow with nice transitions!\n[fr]Diaporama jQuery avec de belles transitions !\n</multi>', 'multimedia', '', '002.000.000', '2012-08-07 18:00:03', '2012-08-07 18:00:03', '[3.0.0-dev;3.0.*]', '3.0'),
(181, 'NO_BR', 'Interdire les retours-chariot', 'No <br> !', 'edition', '', '001.000.000', '2011-10-29 15:00:06', '2011-10-29 15:00:06', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(463, 'FABRIQUE', 'Fabrique', '<multi>\n[fr]Outil pour cr�er des plugins SPIP.\n</multi>', 'outil', '', '001.017.000', '2012-09-13 15:00:05', '2012-09-13 15:00:05', '[3.0.0-rc;3.0.*]', '3.0'),
(464, 'FACTEUR', '<multi>\n[en]Postman\n[fr]Facteur\n[sk]Poštár\n</multi>', '<multi>\n[en]He delivers emails\n[fr]Il distribue vos courriels\n[sk]Posiela vašu poštu\n</multi>', 'communication', '', '002.002.006', '2012-09-13 11:00:03', '2012-09-13 11:00:03', '[3.0.0;3.0.*]', '3.0'),
(461, 'ELEMENTS', '<multi>\n[fr]El�ments\n</multi>', '<multi>\n[fr]G�rer des �l�ments sur des pages\n</multi>', 'navigation', '', '001.001.001', '2012-09-12 00:00:02', '2012-09-12 00:00:02', '[3.0.0;3.0.*]', '3.0'),
(462, 'CELEMENTS', '<multi>\n[fr]El�ments, le catalogue\n</multi>', '<multi>\n[fr]Fournit une liste d''�l�ments\n</multi>', 'navigation', '', '001.000.000', '2012-09-11 17:00:22', '2012-09-11 17:00:22', '[3.0.0;3.0.*]', '3.0'),
(513, 'MOSAIQUE', 'Mosa�que', '<multi>\n[fr]Tri intuitif du portfolio.\n</multi>', 'multimedia', '', '000.003.003', '2012-09-20 11:00:13', '2012-09-20 11:00:13', '[3.0.0-rc;3.0.*]', '3.0'),
(514, 'NOTIFICATIONS', 'Notifications', '<multi>\n[en]Report changes by mail \n[fa]������ �� ������� �� �����\n[fr]Signaler par mail des modifications\n[sk]Ozn�mi� zmeny e-mailom\n</multi>', 'communication', '', '002.002.001', '2012-09-24 04:00:19', '2012-09-24 04:00:19', '[3.0.0;3.0.*]', '3.0'),
(511, 'LESSCSS', 'LESS CSS', 'Int�gration de l''impl�mentation php de LESS', 'outil', '', '000.007.001', '2012-09-27 11:00:04', '2012-09-27 11:00:04', '[2.1.0;3.0.99]', '2.1,3.0'),
(512, 'MICROBLOG', 'Microblog', 'Envoyer des micro-messages sur les sites de microblog (compatibles Twitter)', 'communication', '', '000.007.005', '2012-09-26 18:00:15', '2012-09-26 18:00:15', '[2.1.0;3.0.99]', '2.1,3.0'),
(186, 'NUAGE', 'Nuage', '<multi>\n[en]Display the keywords changing their font size\n[fa]ÿ⿠ÿ⿦ÿ§ÿŠÿ´ ÿƿÿ⿿ÿŠÿ¯ÿ˿ÿ§ÿ˿ÿ⿡â⿬ſÿ⿡ ÿ¨ÿ§ ÿªÿºÿŠÿŠÿ± ÿ§ÿ⿠ÿ¯ÿ§ÿ²ÿ⿡â⿬ſÿŠ ÿ⿿ÿ⿿ÿ⿦\n[fr]Afficher les mots-cl�s en faisant varier la taille de la police\n[sk]Zobraz�­ kÿ¾�ºÿov� slov�¡ s r�´znou veÿ¾kosÿ¥ou p�­sma\n</multi>', 'navigation', '', '004.000.000', '2012-07-26 13:18:23', '2012-07-26 13:18:23', '[3.0.0-dev;3.0.99]', '3.0'),
(187, 'NUMERO', 'Num�rotation Rapide', '<multi>\n[fr]G�rer facilement la num�rotation des articles et rubriques\n</multi>', 'navigation', '', '001.000.001', '2012-07-05 13:00:15', '2012-07-05 13:00:15', '[3.0.0;3.0.*]', '3.0'),
(188, 'OPENSEARCH', 'OpenSearch', 'Votre site comme moteur de recherche', 'navigation', '', '000.001.001', '2012-07-26 13:18:53', '2012-07-26 13:18:53', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(189, 'ORIENTATION', 'Orientation', 'Choisir l''orientation des images, portrait ou paysage', 'outil', '', '000.002.000', '2011-10-06 12:00:36', '2011-10-06 12:00:36', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(190, 'ORTHO', 'Correcteur d\'orthographe', '', 'edition', '', '000.001', '2012-08-26 04:00:41', '2012-08-26 04:00:41', '[1.9.2;]', '1.9,2.0,2.1,3.0,3.1'),
(191, 'OUTILS_ARTICLE', '<multi>\n[es]Caja de herramientas\n[fr]Boite �  outils\n</multi>', '<multi>\n[es]Colecci�²n de herramientas a los artculos\n[fr]Collection d\'outils pour articles\n</multi>', 'navigation', '', '001.000.001', '2012-06-20 11:00:22', '2012-06-20 11:00:22', '[3.0.0;3.0.99]', '3.0'),
(192, 'PAGES', 'Pages', '<multi>\n[ar] \n[en]Unlinked pages\n[fa]ÿµÿÿ­ÿ⿡â⿬ſÿ⿡ÿ§ÿŠ ÿ¨ÿ¯ÿ˿ÿ⿠ ÿ¨ÿ®ÿ´\n[fr]Des pages sans rubrique\n[ru]Ðžÿ⿿Ð´ÐµÐ»ÿſÐ½ÿ⿹Ðµ ÿÿ⿿ÿ⿬Ð°Ð½Ð¸ÿ⿠ÿ⿹\n[sk]Str�¡nky bez rubriky\n</multi>', 'divers', '', '001.000.001', '2012-08-20 17:00:12', '2012-08-20 17:00:12', '[3.0.0-dev;3.0.*]', '3.0'),
(193, 'PALETTE', 'Palette', '<multi>\n[en]Color picker\n[fr]S�lecteur de couleurs\n</multi>', 'outil', '', '003.000.001', '2012-07-26 13:19:10', '2012-07-26 13:19:10', '[3.0.0;3.*]', ''),
(194, 'PAYS', '<multi>\n[en]Countries ISO 3166-1\n[fr]Pays ISO 3166-1\n</multi>', '<multi>\n[en]Official country names and codes list\n[fr]Liste officielle des pays\n</multi>', 'divers', '', '002.001.001', '2012-02-16 12:00:35', '2012-04-12 22:00:02', '[2.0.9;3.0.99]', '2.0,2.1,3.0'),
(195, 'PDFJS', 'pdf.js', '', 'multimedia', '', '000.001.000', '2012-02-20 01:45:06', '2012-02-20 01:45:06', '[3.0.0-dev;[', '3.0,3.1'),
(196, 'PHOTOSPIP', 'PhotoSPIP', '<multi>\n[en]Picture edition in SPIP\n[fr]Modification d\'images dans SPIP\n[sk]�šprava obr�¡zkov vÿ SPIPe\n</multi>', 'multimedia', '', '001.000.002', '2012-07-26 13:20:01', '2012-07-26 13:20:01', '[3.0.0;3.0.99]', '3.0'),
(197, 'SPIP_THELIA', 'Interface Th�lia', '', 'divers', '', '001.005', '2012-08-01 16:00:03', '2012-08-01 16:00:03', '[1.9.0;]', '1.9,2.0,2.1,3.0,3.1'),
(458, 'DEV', 'D�veloppement', '<multi>\n[ar]أدٿات اٿتطٿٿر\n[en]Development tools\n[fa]ابزارٿاٿ تٿسعٿ\n[fr]Outils de d�veloppement\n[it]Strumenti di sviluppo\n[ru]Сѿедсѿва ѿазѿабоѿки\n[sk]Nástroje na vývoj\n</multi>', 'outil', '', '000.002.001', '2012-09-18 20:00:02', '2012-09-18 20:00:02', '[3.0.0;3.1.*]', '3.0,3.1'),
(199, 'POLYHIER', '<multi>\n[en]PolyHierarchy\n[fr]PolyHi�rarchie\n</multi>', '<multi>\n[en]Attach an article or a section on several parent sections.\n[fr]Rattacher un article ou une rubrique �  plusieurs rubriques parentes\n</multi>', 'navigation', '', '002.000.004', '2012-06-21 16:00:18', '2012-06-21 16:00:18', '[3.0.0-beta;3.0.*]', '3.0'),
(200, 'SPIPOPUP', 'Balise#POPUP', '<multi>\n[fr]Gestion d\'une fen�ªtre popup unique en squelette SPIP\n[sk]Ovl�¡danie jedineÿnej ÿ¡abl�³ny SPIPu pre vyskakovacie okno\n</multi>', 'squelette', '', '001.004.001', '2012-07-26 13:21:36', '2012-07-26 13:21:36', '[3.0.0-alpha2;[', '3.0,3.1'),
(201, 'TYPOENLUMINEE', 'Enluminures typographiques', '<multi>\n[fr]Plein de raccourcis pour la mise en forme !\n</multi>', 'edition', '', '003.003.001', '2012-05-23 13:00:12', '2012-05-23 13:00:12', '[2.0.3;3.0.99]', '2.0,2.1,3.0'),
(202, 'PP_CHGT_LG', 'Changement de langue', 'Extension changement de langue pour Porte-Plume', 'edition', '', '000.003.000', '2011-10-21 09:16:51', '2011-10-21 09:16:51', '[2.0.3;3.0.99]', '2.0,2.1,3.0'),
(203, 'PP_LOREMIPSUM', 'Lorem Ipsum pour Porte Plume', 'Des boutons pour cr�er du texte factice', 'edition', '', '001.001.000', '2011-10-18 14:57:11', '2011-10-18 14:57:11', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(204, 'PPP', '<multi>\n[en]Quill everywhere\n[fr]Porte Plume Partout\n[ru]ÐŸÐ°Ð½ÐµÐ»ÿſ Ð¸Ð½ÿÿ⿿ÿ⿬ÿƿÐ¼ÐµÐ½ÿ⿿Ð¾Ð² Ð´Ð»ÿ Ð²ÿÐµÿ⿦ Ð¿Ð¾Ð»ÐµÐ¹ ÿÐ°Ð¹ÿ⿿Ð° (Porte Plume Partout)\n[sk]Porte Plume vÿ¡ade\n</multi>', '<multi>\n[en]Display Quill on most input fields\n[fr]Afficher le Porte Plume sur la plupart des champs de saisie\n[ru]Ð⿝Ð¾Ð±Ð°Ð²Ð»ÐµÐ½Ð¸Ðµ Ð¿Ð°Ð½ÐµÐ»Ð¸ Ð¸Ð½ÿÿ⿿ÿ⿬ÿƿÐ¼ÐµÐ½ÿ⿿Ð¾Ð² Ð´Ð»ÿ ÿ⿿Ð¾ÿ⿬Ð¼Ð°ÿ⿿Ð¸ÿ⿬Ð¾Ð²Ð°Ð½Ð¸ÿ ÿ⿿ÐµÐºÿÿ⿿Ð° Ð½Ð° Ð²ÿÐµ Ð¾ÿÐ½Ð¾Ð²Ð½ÿ⿹Ðµ Ð¿Ð¾Ð»ÿ ÿÐ°Ð¹ÿ⿿Ð°.\n[sk]Zobraziÿ¥ Porte Plume pri v�¤ÿÿ¡ine textov�½ch pol�­\n</multi>', 'edition', '', '001.000.005', '2012-08-25 00:01:21', '2012-08-25 00:01:21', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(205, 'ICONESPEDAGO', 'Ic�´nes p�dagogiques', 'Des ic�´nes p�dagogiques pour le Porte Plume', 'edition', '', '000.001.000', '2011-12-22 14:00:20', '2011-12-22 14:00:20', '[2.0.3;3.0.99]', '2.0,2.1,3.0'),
(206, 'PP_LATEX', 'Porte Plume Equation', 'Extension LaTeX pour Porte-Plume', 'edition', '', '000.003.001', '2012-06-11 20:00:02', '2012-06-11 20:00:02', '[2.0.3;3.1.99]', '2.0,2.1,3.0,3.1'),
(207, 'PRIX', 'API Prix', 'API pour conna�®tre le prix d\'un objet', 'outil', '', '000.001.005', '2012-07-26 13:21:17', '2012-07-26 13:21:17', '[2.1.8;3.0.99]', '2.1,3.0'),
(209, 'PUBBAN', 'Pub Banner', '<multi>\n[fr]Gestionnaire de banni�res publicitaires\n[sk]Ovl�¡danie reklamn�½ch p�ºtaÿov\n</multi>', 'multimedia', '', '001.030.002', '2012-09-02 12:00:03', '2012-09-02 12:00:03', '[3.0.0-beta;[', '3.0,3.1'),
(210, 'QUERYPATH', '<multi>\n[fr]Query Path\n</multi>', '<multi>\n[fr]Du jQuery en PHP, et bien plus encore\n</multi>', 'outil', '', '001.000.000', '2012-07-12 16:00:33', '2012-07-12 16:00:33', '[3.0.0-dev;3.1.*]', '3.0,3.1'),
(211, 'RAINETTE', 'Rainette', 'La m�t�o au quotidien', 'divers', '', '001.004.001', '2012-08-16 04:00:50', '2012-08-16 04:00:50', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(212, 'READABILITY', 'Readability', 'Extraire le contenu pertinent d\'une page Web', 'outil', '', '000.002.000', '2011-11-19 16:13:11', '2011-11-19 16:13:11', '[2.1.0;3.0.99]', '2.1,3.0'),
(213, 'RECOMMANDER', '<multi>\n[en]Recommend to a friend\n[fr]Recommander �  un ami\n</multi>', '<multi>\n[en]"Recommend a page to a friend" functionnality\n[fr]Fonction recommander une page �  un ami\n</multi>', 'communication', '', '001.000.002', '2012-08-25 00:01:04', '2012-08-25 00:01:04', '[2.0.12;3.0.*]', '2.0,2.1,3.0'),
(214, 'REDIRHTTPS', '<multi>\n[es]Redireciones HTTPS\n[fr]Redirections HTTPS\n[sk]Presmerovania HTTPS\n</multi>', '<multi>\n[es]S�curiser l''acc�s �  certaines pages du site\n[fr]S�curiser l''acc�s �  certaines pages du site\n[sk]Zabezpeÿiÿ¥ pr�­stup na urÿit� str�¡nky\n</multi>', 'performance', '', '000.001.000', '2012-07-26 13:22:01', '2012-07-26 13:22:01', '[2.1.11;[', '2.1,3.0,3.1'),
(215, 'REFBASE', 'refbase', '<multi>\n[en]Import refbase bibliographic references\n[fr]Importer des r�f�rences bibliographiques refbase\n</multi>', 'edition', '', '002.001.002', '2012-01-26 17:00:32', '2012-01-26 17:00:32', '[3.0.0-dev;3.0.99]', '3.0'),
(216, 'RETOURSIMPLE', 'Alin�asÿ : ÿ«ÿ Retour simpleÿ ÿ»', 'Pour le respect des ÿ«ÿ retours �  la ligneÿ ÿ» simples', 'edition', '', '000.002.000', '2011-10-20 01:00:06', '2011-10-20 01:00:06', '[2.1.0;3.0.99]', '2.1,3.0'),
(217, 'RSSARTICLE', '<multi>\n[fr]Flux RSS en articles\n</multi>', '<multi>\n[fr]Recopie les flux RSS en articles\n</multi>', 'edition', '', '001.001.000', '2012-08-01 10:00:12', '2012-08-01 10:00:12', '[3.0.2;3.0.*]', '3.0'),
(218, 'RSSCONFIG', 'Flux RSS configurable', '<multi>\n[fr]Personnaliser le flux RSS des articles du site\n</multi>', 'squelette', '', '001.004.000', '2012-07-27 11:00:02', '2012-07-27 11:00:02', '[2.1.0;3.0.*]', '2.1,3.0'),
(219, 'RUBRIQUE_A_LINSCRIPTION', 'Rubrique�  l''inscription', '<multi>\n[fr]Cr�er une rubrique �  l''inscription d\'un admin\n</multi>', 'auteur', '', '001.000.000', '2012-04-14 22:01:00', '2012-04-14 22:01:00', '[3.0.0-beta;3.0.99]', '3.0'),
(457, 'PB_COULEUR_RUBRIQUE', 'Couleur de rubrique', '<multi>\n[fr]Une couleur pour chaque rubrique\n</multi>', 'maintenance', '', '002.002.001', '2012-09-07 17:00:02', '2012-09-07 17:00:02', '[3.0.0;3.*]', ''),
(221, 'SAVEAUTO', '<multi>\n[en]Automatic backup\n[fr]sauvegarde automatique\n[it]Salvataggio automatico\n</multi>', '<multi>\n[en]Automatic backup of the database used by SPIP\n[fr]Sauvegarde automatique de la base de donn�es de SPIP\n[it]Salvataggio automatico di la base dati utilizzata da SPIP\n</multi>', 'maintenance', '', '000.008.001', '2012-06-19 12:00:47', '2012-06-19 12:00:47', '[3.0.0;3.0.99]', '3.0'),
(222, 'SCRUT_PROP', 'Scrutin�  la proportionnelle', '<multi>\n[fr]R�partissez les si�ges\n</multi>', 'communication', '', '001.003.000', '2012-05-23 23:00:02', '2012-05-23 23:00:02', '[3.0.0;3.0.99]', '3.0'),
(223, 'SCENARI', 'Scenari', '<multi>\r\n	[fr]Ajouter des archives scenari dans les articles\r\n	[en]Add scenari archives in articles\r\n	</multi>', 'edition', '', '000.000.001', '2011-10-09 21:41:50', '2011-10-09 21:41:50', '[2.1.0;3.0.99]', '2.1,3.0'),
(456, 'CONTACT', '<multi>\n[ar]إستٿارة اٿاتصاٿ اٿٿتٿدٿة\n[en]Advanced Contact Form\n[fr]Formulaire de contact avanc�\n[sk]Rozšírený kontaktný formulár\n</multi>', '<multi>\n[ar]ٿذا اٿتٿدٿد ٿٿفر شٿٿ ٿٿ أشٿاٿ اٿاتصاٿ ٿع خٿارات ٿتعددة\n[en]This extension provides a contact form with multiple options\n[fr]Cette extension propose un formulaire de contact avec de multiples options\n[sk]Toto rozšírenie ponúka kontaktný formulár s viacerými možnosťami\n</multi>', 'communication', '', '000.010.003', '2012-09-14 16:00:11', '2012-09-14 16:00:11', '[3.0.0-dev;3.1.0[', '3.0'),
(225, 'SIMPLOG', '<multi>\n[en]Simples Logs\n[fr]Simples Logs\n[sk]Jednoduch� protokoly\n</multi>', '<multi>\n[en]Analyze SPIP''s logs by administrators\n[fr]Visualisation des logs SPIP par les administrateurs\n[sk]Zobrazenie protokolov SPIPu pre  administr�¡torov\n</multi>', 'outil', '', '000.004.003', '2012-05-14 10:00:14', '2012-07-26 13:23:04', '[2.1.0;3.0.*]', '2.1,3.0'),
(519, 'SPIPICIOUS', 'spip.icio.us', '<multi>\n[en]Tag each objects\n[fr]Tagger tous les objets\n[sk]Ozna�kujte v�etky objekty\n</multi>', 'communication', '', '001.001.000', '2012-09-25 14:00:04', '2012-09-25 14:00:04', '[3.0.0;3.0.99]', '3.0'),
(227, 'SKELEDITOR', 'SkelEditor', '<multi>\n[de]Skeleton Herausgeber\n[en]Template editor\n[es]Redactor esquel�tico\n[fr]Editeur de squelettes\n[it]Redattore di scheletro\n</multi>', 'outil', '', '002.007.002', '2012-04-20 12:00:14', '2012-04-20 12:00:14', '[3.0.0-dev;3.0.*]', '3.0'),
(228, 'SKIPLINK', 'SkipLink', '', 'navigation', '', '001.000.002', '2012-01-10 23:00:10', '2012-01-10 23:00:10', '[1.9.0;]', '1.9,2.0,2.1,3.0,3.1'),
(229, 'SOCIALTAGS', 'Social tags', '<multi>\n[en]Activate the social link sharing network buttons.\n[fr]Activer des boutons de partage de liens sur les r�seaux sociaux.\n</multi>', 'communication', '', '001.000.002', '2012-08-02 23:00:40', '2012-08-02 23:00:40', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(230, 'SPIPDF', 'SpiPDF', 'Conversion d\'article en Pdf', 'edition', '', '000.002.002', '2012-09-03 18:00:07', '2012-09-03 18:00:07', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(231, 'SPIP_PROPRIO', 'SPIP Mentions L�gales', '<multi>\n[fr]Mentions L�gales, Conditions d\'Utilisation et Copyright automatiques\n[sk]Automatick� vytvorenie inform�¡ci�­ pr�¡vneho charakteru, podmienok pouÿ¾�­vania str�¡nky aÿ pozn�¡mky oÿ autorsk�½ch pr�¡vach\n</multi>', 'communication', '', '001.070.000', '2012-08-25 20:00:08', '2012-08-25 20:00:08', '[3.0.0-beta;[', '3.0,3.1'),
(232, 'PIWIK', 'Piwik', '<multi>\n[en]Link [SPIP->http://www.spip.net] and [Piwik->http://www.piwik.org]\n[fa]ÿ¾ÿŠÿ˿ÿ⿠ÿ¯ [ÿ§ÿ³ÿ¾ÿŠÿ¾->http://www.spip.net] ÿ˿ [ÿ¾ÿŠÿ˿ÿŠÿƿ->http://www.piwik.org]\n[fr]Interfacer Spip et Piwik\n[ru]ÐžÐ±ÿŠÐµÐ´Ð¸Ð½ÿÐµÿ⿿ [SPIP->http://www.spip.net] Ð¸ [Piwik->http://www.piwik.org]\n[sk]Rozhranie Spip a Piwik\n</multi>', 'statistique', '', '000.005.001', '2012-08-20 04:00:38', '2012-08-20 04:00:38', '[2.0.8;3.0.99]', '2.0,2.1,3.0'),
(234, 'SPIP_BONUX', 'SPIP Bonux', '<multi>[ar]?????? ???? ???? SPIP ???? ?????? ??.[en]The plugin that make SPIP better than SPIP.[fr]Le plugin qui lave plus SPIP que SPIP.[ru]SPIP Bonux ??????????? ????????? ??????????? SPIP, ????? ??? ????? ??? SPIP :)))[sk]Zásuvný modul, ktorý pre?istí SPIP ako SPIP.</multi>', 'outil', '', '003.000.003', '2012-09-06 12:00:43', '2012-09-06 12:00:43', '[3.0.0-dev;3.1.*]', '3.0,3.1'),
(235, 'SPIPLISTES', '<multi>\n[ar]ÿ⿿ÿ˿ÿ§ÿ¦ÿ­\n[de]SPIP-Lists\n[en]SPIP-Lists\n[es]SPIP-Listes\n[fr]SPIP-Listes\n</multi>', '<multi>\n[ar]ÿ⿠ÿ´ÿ±ÿ© ÿ¨ÿ±ÿŠÿ¯ÿŠÿ©\n[de]Newsletter by e-mail\n[en]Newsletter by e-mail\n[es]Listas para informar por email (emails y boletines informativos)\n[fr]Listes d\'informations par email\n</multi>', 'communication', '', '003.000.005', '2012-08-24 10:00:06', '2012-08-24 10:00:06', '[3.0.0-alpha2;[', '3.0,3.1'),
(236, 'SPIPCLEAR', 'SpipClear', '<multi>\n[fr]Un site �  la dotclear en Spip\n</multi>', 'squelette', '', '000.002.001', '2012-07-27 21:00:42', '2012-07-27 21:00:42', '[2.0.6;3.0.99]', '2.0,2.1,3.0'),
(518, 'SJCYCLE', 'jQuery Cycle', '<multi>\n[en]A configurable slideshow for Spip\n[fr]Un diaporama param�trable pour Spip\n</multi>', 'multimedia', '', '002.002.003', '2012-09-25 14:00:54', '2012-09-25 14:00:54', '[3.0.0;3.1.*]', '3.0,3.1'),
(239, 'SPIPMOTION', 'SPIPMotion', '<multi>\n[en]Encoding media documents\n[fr]Encodage de documents multimedia\n[sk]Zak�³dovanie multimedi�¡lnych s�ºborov\n</multi>', 'multimedia', '', '001.001.005', '2012-08-16 12:00:15', '2012-08-16 12:00:15', '[3.0.0;3.0.99]', '3.0'),
(240, 'SPIPSERVICE', 'SpipService', '', 'communication', '', '002.000.000', '2012-05-14 19:00:02', '2012-05-14 19:00:02', '[3.0.0 ;3.0.*]', '3.0'),
(241, 'SPIP_400', '<multi>\n[en]SPIP 400\n[fr]SPIP 400\n[sk]SPIP 400\n</multi>', '<multi>\n[en]Advanced management of HTTP errors (401, 404) for SPIP\n[fr]Gestion pouss�e des erreurs HTTP (401, 404) pour SPIP\n[sk]Ovl�¡danie vyn�ºten�½ch chybov�½ch str�¡nok (401, 404) pre SPIP\n</multi>', 'navigation', '', '000.022.002', '2012-05-04 20:00:12', '2012-07-26 13:24:05', '[2.0.0;3.1.99]', '2.0,2.1,3.0,3.1'),
(242, 'SPLICKR', 'Splickrbox', 'Afficher des photos �  la Flickr', 'multimedia', '', '000.004.005', '2012-04-15 14:00:02', '2012-04-15 14:00:02', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(243, 'SQUELETTESMOTS', '<multi>\n[en]Template by keyword\n[fr]Squelette par mot clef\n[it]Modello mediante una parola chiave\n</multi>', '<multi>\n[en]Provides selection of template using keywords\n[fr]Permet de choisir le squelette en fonction d\'un mot clef\n[it]Scegliere un modello mediante una parola chiave\n</multi>', 'outil', '', '003.001.000', '2012-06-27 12:00:05', '2012-06-27 12:00:05', '[3.0.0;3.0.*]', '3.0'),
(244, 'SQUIRREL_CHIMP', '<multi>\n[fr]Squirrels Love Chimps\n</multi>', '<multi>\n[fr]Connecter SPIP avec Mailchimp\n</multi>', 'communication', '', '002.000.003', '2012-08-06 11:00:23', '2012-08-06 11:00:23', '[2.0.15;3.0.*]', '2.0,2.1,3.0');
INSERT INTO `spip_plugins` (`id_plugin`, `prefixe`, `nom`, `slogan`, `categorie`, `tags`, `vmax`, `date_crea`, `date_modif`, `compatibilite_spip`, `branches_spip`) VALUES
(245, 'SQUIRREL_CHIMP_LISTS', '<multi>\n[fr]Squirrels Love Chimps Lists\n</multi>', '<multi>\n[fr]Gestion de mailing listes de Mailchimp\n</multi>', 'communication', '', '002.000.000', '2012-08-06 11:00:46', '2012-08-06 11:00:46', '[2.0.15;3.0.*]', '2.0,2.1,3.0'),
(246, 'SCLP', '<multi>\n[fr]Squirrels Love Chimps Plus\n</multi>', '<multi>\n[fr]Gestion avanc� de mailing listes de Spip et de Mailchimp\n</multi>', 'communication', '', '001.000.003', '2012-08-06 11:00:56', '2012-08-06 11:00:56', '[2.0.15;3.0.*]', '2.0,2.1,3.0'),
(247, 'SQUIRREL_CHIMP_CAMPAIGNS', '<multi>\n[fr]Squirrels Love Chimps Campaigns\n</multi>', '<multi>\n[fr]Gestion des campagnes de Mailchimp\n</multi>', 'communication', '', '002.000.000', '2012-08-06 11:00:38', '2012-08-06 11:00:38', '[2.0.15;3.0.*]', '2.0,2.1,3.0'),
(248, 'SVPSTATS', 'SVP Statistiques', '<multi>\n[en]SVP module to manage the usage statistics of the plugins\n[fr]Module SVP de gestion des statistiques d\'utilisation des plugins\n[sk]Modul SVP na spr�¡vu ÿ¡tatist�­k vyuÿ¾�­vania z�¡suvn�½ch modulov\n</multi>', 'statistique', '', '000.001.003', '2012-07-26 13:25:29', '2012-07-26 13:25:29', '[3.0.0-beta;3.0.*]', '3.0'),
(249, 'TABLEMATIERES', '<multi>\r\n			[fr]Table des Mati�res\r\n			[en]Table of contents\r\n		</multi>', '<multi>\r\n			[fr]Cr�er le sommaire d\'un article\r\n			[en]Create the summary of an article\r\n		</multi>', 'edition', '', '002.000.002', '2012-07-26 13:25:35', '2012-07-26 13:25:35', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(250, 'TABLESORTER', 'Tablesorter', '<multi>\n[en]With tableSorter, the sort will be wonderfull!\n[fr]Avec tableSorter, le tri sera top !\n[sk]S tableSorterom bude triedenie najlepÿ¡ie!\n</multi>', 'navigation', '', '001.003.001', '2012-08-12 14:00:21', '2012-08-12 14:00:21', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(251, 'TAGSPHERE', 'Plugin TagSph�re', 'Nuage de mots cl�s en 3D', 'navigation', '', '000.004.000', '2012-08-05 14:00:17', '2012-08-05 14:00:17', '[1.9.2;3.0.99]', '1.9,2.0,2.1,3.0'),
(252, 'TB', 'Test Builder', 'Construire des tests syst�matiques', 'outil', '', '000.003.002', '2012-04-04 15:00:14', '2012-04-04 15:00:14', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(454, 'IEXTRAS', '<multi>\n[en]Extra fields (Interface)\n[fr]Champs Extras (Interface)\n[it]Campi Extra (Interfaccia)\n[sk]Ŀalšie polia (rozhranie)\n</multi>', '<multi>\n[en]Interface to manage the extra fields on SPIP objects\n[fr]Offre une interface graphique pour g�rer des champs extras\n[it]Interfaccia per gestire i campi extra\n[sk]Ponúka grafick� rozhranie na riadenie ďalších polí\n</multi>', 'outil', '', '003.001.000', '2012-09-16 04:00:21', '2012-09-16 04:00:21', '[3.0.0;3.0.*]', '3.0'),
(254, 'TITRES_TYPOGRAPHIES', 'Titres typographi�s', '<multi>\n[fr]Typographiez vos titres !\n</multi>', 'edition', '', '001.000.001', '2012-08-09 03:00:06', '2012-08-09 03:00:06', '[3.0;3.0.99]', '3.0'),
(515, 'ORESOURCE', '<multi>\n[fr]ORR\n</multi>', '<multi>\n[fr]Organisation de r�servations de ressources\n</multi>', 'divers', '', '001.000.001', '2012-09-19 22:00:14', '2012-09-19 22:00:14', '[3.0.1;3.0.*]', '3.0'),
(516, 'PGN4SPIP', 'pgn4spip', '<multi>\n[en][pgn prm1=value1 ...] 1. e4 Nf6 [/pgn] in your articles.\n[fr][pgn prm1=valeur1 ...] 1. e4 Nf6 [/pgn] dans vos articles.\n</multi>', 'divers', '', '002.061.000', '2012-09-23 01:00:03', '2012-09-23 01:00:03', '[3.0.0;3.*.*]', ''),
(517, 'SAISIES', '<multi>\n[en]Entries for forms\n[fr]Saisies pour formulaires\n[ru]����������� ����\n[sk]Vstupy pre formul�re\n</multi>', '<multi>\n[en]Create easily forms fields.\n[fr]�crire facilement des champs de formulaires.\n[ru]��������� ������ �� �������� ����\n[sk]Jednoduch� z�pis pol� formul�rov.\n</multi>', 'outil', '', '001.026.007', '2012-09-25 18:00:17', '2012-09-25 18:00:17', '[2.0.0;3.0.*]', '2.0,2.1,3.0'),
(452, 'AUTORITE', '<multi>\n[ar]اٿسٿطة\n[de]Autorität\n[en]Authority\n[fa]اختٿار\n[fr]Autorit�\n[it]Autorità\n[sk]Autorita\n</multi>', '<multi>\n[ar]بعض إعدادات اٿأذٿٿات\n[de]Feineinstellungen der Benutzerrechte (füge eigene hinzu!)\n[en]Some tweaks permissions (add yours!)\n[fa]تعدادٿ از تٿظٿٿ⿿ٿاٿ ٿجٿزٿا (ٿا خٿدتاٿ را اضافٿ ٿٿٿد!)\n[fr]Quelques r�glages d\'autorisations (ajoutez les v�tres !)\n[it]Qualche esempio di impostazioni d\'autorizzazione (aggiungete le vostre!)\n[sk]Niektor� nastavenia povolení (pridajte svoje!)\n</multi>', 'auteur', '', '000.009.012', '2012-09-05 15:00:17', '2012-09-05 15:00:17', '[1.9.2;3.0.*]', '1.9,2.0,2.1,3.0'),
(258, 'TRANSACTION', 'Transaction', 'Module de paiement pour Formidable', 'communication', '', '000.003.001', '2012-08-08 18:00:13', '2012-08-08 18:00:13', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(259, 'TYPOMANIAC', 'Typomaniac', '<multi>\n[fr]Un squelette minimal, responsive et typographique\n</multi>', 'squelette', '', '001.001.001', '2012-08-26 20:00:09', '2012-08-26 20:00:09', '[v3;]', '1.9,2.0,2.1,3.0,3.1'),
(260, 'TYPO_GUILLEMETS', 'Guillemets typographiques', 'Correction automatique des guillemets, selon la langue', 'edition', '', '001.005.000', '2012-01-14 01:45:02', '2012-01-14 01:45:02', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(261, 'VARICELLE', 'Varicelle', 'De jolis boutonsÿ !', 'outil', '', '000.002.001', '2011-12-29 22:00:07', '2011-12-29 22:00:07', '[1.9.1;3.0.99]', '1.9,2.0,2.1,3.0'),
(262, 'VERIFIER', '<multi>\n[en]Control API\n[fr]API de v�rification\n[sk]Aplik�¡cia na overenie\n</multi>', '<multi>\n[en]A generic API to control a value\n[fr]Une API g�n�rique pour v�rifier une valeur\n[sk]Spoloÿn�¡ aplik�¡cia na overenie hodnoty\n</multi>', 'outil', '', '000.001.016', '2012-08-30 04:00:09', '2012-08-30 04:00:09', '[2.0.10;3.0.*]', '2.0,2.1,3.0'),
(263, 'VIDEOS', '<multi>\n[en]Video(s)\n[fr]Vid�o(s)\n[sk]Vide�¡\n</multi>', '<multi>\n[en]Management interface and integration models of videos\n[fr]Interface de gestion et mod�les d\'insertion de vid�os\n[sk]Rozhranie na riadenie vide�­ aÿ ÿ¡abl�³ny na ich vkladanie\n</multi>', 'multimedia', '', '000.009.008', '2012-08-13 21:00:26', '2012-08-13 21:00:26', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(264, 'VIGNETTES_OXYGEN', 'Vignettes Oxygen (128)', '<multi>\n[fr]Collection d\'ic�´nes pour les documents\n</multi>', 'multimedia', '', '001.000.000', '2012-04-26 20:00:05', '2012-04-26 20:00:05', '[3.0.0-alpha2;3.0.99]', '3.0'),
(265, 'VIGNETTES_OXYGEN52', 'Vignettes Oxygen (52)', '', 'multimedia', '', '001.000.000', '2012-04-26 20:00:29', '2012-04-26 20:00:29', '[3.0.0-alpha2;3.0.99]', '3.0'),
(266, 'VISITEURS_CONNECTES', '<multi>\r\n	[fr]Nombres de visiteurs connect�s\r\n	[ar]ÿ¹ÿ¯ÿ¯ ÿ§ÿ⿿ÿ²ÿ˿ÿ§ÿ± ÿ§ÿ⿿ÿ⿦ÿªÿµÿ⿿ÿ˿ÿ⿠\r\n	[en]Number of visitors connected\r\n	[es]N�ºmero de visitantes conectados\r\n	[it]Numero di visitatori collegati\r\n	[de]Anzahl der Besucher verbunden\r\n	</multi>', 'Affiche le nombre de visiteurs connect�s sur le site', 'statistique', '', '000.002.000', '2011-10-06 23:23:31', '2011-10-06 23:23:31', '[1.9.0;3.0.99]', '1.9,2.0,2.1,3.0'),
(267, 'VITTORY', 'Squelette JQuery Vittori''s', '<multi>\n		[fr] Squelette Vittori''s pour SPIP.\n		[en] Vittori''s skeleton for SPIP.\n		</multi>', 'squelette', '', '000.000.001', '2011-10-17 02:36:48', '2011-10-17 02:36:48', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(268, 'WEBFONTS', 'WebFonts', 'Utiliser facilement les WebFonts', 'outil', '', '000.001.000', '2012-02-02 17:00:27', '2012-02-02 17:00:27', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(269, 'YAML', 'YAML', '<multi>\n[en]A simple file format for editing lists of data\n[fa]ÿÿ±ÿ⿦ÿªÿŠ ÿ¨ÿ±ÿ§ÿŠ ÿ¾ÿ±ÿ˿ÿ⿠ÿ¯â⿬ſÿ⿡ ÿ³ÿ§ÿ¯ÿ⿡ ÿ¨ÿ±ÿ§ÿŠ ÿ˿ÿŠÿ±ÿ§ÿŠÿ´ ÿÿ⿡ÿ±ÿ³ÿªâ⿬ſÿ⿡ÿ§ÿŠ ÿ¯ÿ§ÿ¯ÿ⿡â⿬ſÿ⿡ÿ§\n[fr]Un format de fichier simple pour �diter des listes de donn�es\n[ru]Ð¤Ð¾ÿ⿬Ð¼Ð°ÿ⿿ ÿ⿿Ð°Ð¹Ð»Ð° Ð´Ð»ÿ ÿ⿬ÐµÐ´Ð°Ðºÿ⿿Ð¸ÿ⿬Ð¾Ð²Ð°Ð½Ð¸ÿ ÿÐ¿Ð¸ÿÐºÐ¾Ð² Ð´Ð°Ð½Ð½ÿ⿹ÿ⿦\n[sk]Jednoduch�½ form�¡t s�ºborov na upravovanie zoznamov d�¡t\n</multi>', 'outil', '', '001.005.000', '2012-07-26 13:27:42', '2012-07-26 13:27:42', '[2.1.0;3.0.*]', '2.1,3.0'),
(271, 'ZENGARDEN', 'Zen-Garden', '<multi>\n[en]A Zen garden for Zpip\n[fa]ÿ¨ÿ§ÿº ÿ°ÿ⿠ ÿ¨ÿ±ÿ§ÿŠ ÿ§ÿ³ÿ¾ÿŠÿ¾ \n[fr]Un jardin Zen pour Zpip\n[nl]Een Zen tuintje voor Zpip\n[ru]ÐŸÐ»Ð°Ð³Ð¸Ð½ "Zengarden" Ð´Ð»ÿ SPIP\n[sk]Zenov�¡ z�¡hrada pre Zpip\n</multi>', 'maintenance', '', '002.004.002', '2012-08-25 04:00:30', '2012-08-25 04:00:30', '[3.0.0;3.0.*]', '3.0'),
(272, 'ZIPPEUR', 'Zippeur', 'Zippez facilement vos fichiers', 'multimedia', '', '003.000.003', '2012-08-15 17:00:08', '2012-08-15 17:00:08', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(273, 'ZIPTEX', 'ZipTeX', '<multi>\n[fr]Empaqueter vos .tex !\n</multi>', 'outil', '', '000.003.003', '2012-03-28 11:00:03', '2012-03-28 11:00:03', '[3.0.0 ;[', '3.0,3.1'),
(274, 'ZOOMER', 'Image zoom', '', 'multimedia', '', '000.001', '2010-12-23 20:00:02', '2010-12-23 20:00:02', '', '1.9,2.0,2.1,3.0,3.1'),
(276, 'AHUNTSIC', 'Squelette Ahuntsic', 'Un jeu de squelettes multilingues �  caract�re g�n�rique', 'squelette', '', '002.000.001', '2012-07-24 19:00:32', '2012-07-24 19:00:32', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(277, 'ESCAL', 'Escal', '<multi>\n[fr]Squelette 2 ou 3 colonnes compos� de nombreuses noisettes\n</multi>', 'squelette', '', '003.054.008', '2012-08-31 23:00:13', '2012-09-25 21:00:09', '[2.0.0;3.1.99]', '2.0,2.1,3.0,3.1'),
(278, 'EVA_AGENDA', 'Affichage d⿿une rubrique sous forme d⿿agenda.', '<multi>[fr]Affichage d⿿une rubrique sous forme d⿿agenda.</multi>', 'squelette', '', '004.002.001', '2012-06-22 13:00:02', '2012-06-22 13:00:02', '[2.9.9;3.0.99]', ''),
(279, 'EVABONUS', 'EVA-bonus pour EVA-web 4.2, version alpha', '<multi>[fr]Des ajouts bonus pour EVA-web</multi>', 'squelette', '', '004.002', '2012-08-22 12:00:26', '2012-08-22 12:00:26', '[2.9.9;3.0.99]', ''),
(280, 'EVA_CALENDRIER', 'Rubrique calendrier pour EVA-web', '<multi>[fr]Affichage d⿿une rubrique sous forme de calendrier</multi>', 'squelette', '', '004.002.001', '2012-06-05 10:00:04', '2012-06-05 10:00:04', '[2.9.9;3.0.99]', ''),
(281, 'EVA_HABILLAGE', 'Gestion des habillages pour EVA-Web 4.2', '<multi>[fr]G�rer les habillages d⿿EVA</multi>', 'squelette', '', '004.002', '2012-06-28 17:00:31', '2012-06-28 17:00:31', '[2.9.9;3.0.99]', ''),
(282, 'EVA_INSTALL', 'Cr�ation des mots cl�s d⿿eva-web', '<multi>[fr]Les mots-cl� n�cessaires à l⿿utilisation d⿿eva-web</multi>', 'squelette', '', '004.002', '2012-06-25 16:00:22', '2012-06-25 16:00:22', '[2.9.9;3.0.99]', ''),
(283, 'LIVRE_2', 'Eva livre 2 pour EVA-web 4.2', '<multi>\n[fr]Publication d\'une s�rie d\'articles sous forme de livre\n</multi>', 'squelette', '', '004.002', '2012-06-25 17:00:09', '2012-06-25 17:00:09', '[2.9.9;3.0.99]', ''),
(284, 'EVAMENTIONS', 'Gestion des mentions l�gales', '<multi>[fr]G�rer la page des mentions l�gales du site</multi>', 'squelette', '', '004.002.000', '2012-06-25 17:00:34', '2012-06-25 17:00:34', '[2.9.9;3.0.99]', ''),
(285, 'MINI_CALENDRIER', 'Mini calendrier mensuel pour EVA', '', 'squelette', '', '004.002', '2012-06-25 17:00:34', '2012-06-25 17:00:34', '[2.9.9;3.0.99]', ''),
(286, 'EVASQUELETTES', 'EVA-WEB 4.2', '<multi>[fr]Distribution des squelettes EVA-WEB 4.2 pour SPIP 3</multi>', 'squelette', '', '004.002', '2012-08-21 12:00:13', '2012-08-21 12:00:13', '[2.9.9;3.0.99]', ''),
(287, 'ISPIP', 'iSPIP', '<multi>\n		[fr]Squelette optimis�; pour iPhone et iPod Touch bas� sur iUI\n		</multi>', 'squelette', '', '001.000.000', '2011-10-08 18:39:14', '2011-10-08 18:39:14', '', '1.9,2.0,2.1,3.0,3.1'),
(288, 'SQUELETTE_MAPARAAN', 'Squelette Maparaan', 'Pour les sites de type blog', 'squelette', '', '001.000.000', '2012-08-12 21:00:57', '2012-08-12 21:00:57', '[2.0.0;3.0.99]', '2.0,2.1,3.0'),
(290, 'SPIP_RESET', 'Squelette SPIP Reset', '', 'squelette', '', '001.000', '2011-06-29 00:00:46', '2011-06-29 00:00:46', '', '1.9,2.0,2.1,3.0,3.1'),
(291, 'SVPSKEL', 'SVP Squelettes', '<multi>\n[fr]Jeu de squelettes Z pour SVP\n</multi>', 'squelette', '', '000.002.004', '2012-01-22 21:00:19', '2012-01-22 21:00:19', '[3.0.0-beta;3.0.*]', '3.0'),
(292, 'TOOLTIP', '<multi>\n[en]Tooltips\n[fr]Tooltips\n[sk]Bublinkov�¡ n�¡poveda\n</multi>', '<multi>\n[en]jQuery tooltips\n[fr]Infobulles jQuery\n[sk]Bublinkov�¡ n�¡poveda vÿ jQuery\n</multi>', 'navigation', '', '001.003.003', '2012-08-12 14:00:16', '2012-08-12 14:00:16', '[3.0.0-dev;3.0.99]', '3.0'),
(294, 'THEME_ANDREAS09_BLACK', '<multi>\r\n		[en]Andreas09 Black\r\n		[fr]Andreas09 Noir\r\n	</multi>', '<multi>\r\n	[en]A colorful and shiny Z template. Black version\r\n	[fr]Un th�me Z color� et brillant. Version en noir\r\n	</multi>', 'theme', '', '000.009.002', '2011-10-09 11:59:14', '2011-10-09 11:59:14', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(295, 'THEME_ANDREAS09_BLUE', '<multi>\r\n		[en]Andreas09 Blue\r\n		[fr]Andreas09 Bleu\r\n	</multi>', '<multi>\r\n	[en]A colorful and shiny Z template. Blue version\r\n	[fr]Un th�me Z color� et brillant. Version en bleu\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-09 11:59:14', '2011-10-09 11:59:14', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(296, 'THEME_ANDREAS09_GREEN', '<multi>\r\n		[en]Andreas09 Green\r\n		[fr]Andreas09 Vert\r\n	</multi>', '<multi>\r\n	[en]A colorful and shiny Z template. Green version\r\n	[fr]Un th�me Z color� et brillant. Version en vert\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-09 11:59:14', '2011-10-09 11:59:14', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(297, 'THEME_ANDREAS09_ORANGE', '<multi>\r\n		[en]Andreas09 Orange\r\n		[fr]Andreas09 Orange\r\n	</multi>', '<multi>\r\n	[en]A colorful and shiny template. Orange version\r\n	[fr]Un th�me Z color� et brillant. Version en orange\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-09 11:59:14', '2011-10-09 11:59:14', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(298, 'THEME_ANDREAS09_PURPLE', '<multi>\r\n		[en]Andreas09 Purple\r\n		[fr]Andreas09 Violet\r\n	</multi>', '<multi>\r\n	[en]A colorful and shiny Z template. Purple version\r\n	[fr]Un th�me Z color� et brillant. Version en violet\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-09 11:59:14', '2011-10-09 11:59:14', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(299, 'THEME_ANDREAS09_RED', '<multi>\r\n		[en]Andreas09 Red\r\n		[fr]Andreas09 Rouge\r\n	</multi>', '<multi>\r\n	[en]A colorful and shiny Z template. Red version\r\n	[fr]Un th�me Z color� et brillant. Version en rouge\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-09 11:59:14', '2011-10-09 11:59:14', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(300, 'THEME_ANDREAS1024', 'Andreas1024', '<multi>\r\n	[en]A colorful and shiny Z template for 1024px screen width\r\n	[fr]Un th�me Z color� et brillant en 1024 pixels de large\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-09 11:59:14', '2011-10-09 11:59:14', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(301, 'THEME_ARCLITE_BROWN', '<multi>\r\n		[en]Arclite Brown\r\n		[fr]Arclite Brun\r\n	</multi>', '<multi>\r\n		[en]Clean/light style Z theme. Brown version\r\n		[fr]Th�me Z propre et l�ger. Version en brun\r\n	</multi>', 'theme', '', '000.009.002', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(302, 'THEME_ARCLITE_BLUE', '<multi>\r\n		[en]Arclite Blue\r\n		[fr]Arclite Bleu\r\n	</multi>', '<multi>\r\n		[en]Clean/light style Z theme. Blue version\r\n		[fr]Th�me Z propre et l�ger. Version en bleu\r\n	</multi>', 'theme', '', '000.009.002', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(303, 'THEME_ARCLITE_GREEN', '<multi>\r\n		[en]Arclite Green\r\n		[fr]Arclite Vert\r\n	</multi>', '<multi>\r\n		[en]Clean/light style Z theme. Green version\r\n		[fr]Th�me Z propre et l�ger. Version en vert\r\n	</multi>', 'theme', '', '000.009.002', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(304, 'THEME_ARCLITE_RED', '<multi>\r\n		[en]Arclite Red\r\n		[fr]Arclite Rouge\r\n	</multi>', '<multi>\r\n		[en]Clean/light Z style theme. Red version\r\n		[fr]Th�me Z propre et l�ger. Version en rouge\r\n	</multi>', 'theme', '', '000.009.002', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(305, 'THEME_BLACK', 'Black', 'Th�me noir, 2 colonnes', 'theme', '', '001.000.000', '2012-02-19 12:00:32', '2012-02-19 12:00:32', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(306, 'THEME_BLUEBUSINESS', 'bluebusiness01', 'Th�me Z Corporate en 2 colonnes', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(307, 'THEME_BLUEPIGMENT', 'BluePigment', '<multi>\r\n	[fr]Th�me Z bleu, web 2.0\r\n	[en]Web 2.0 blue template Z\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(308, 'THEME_BROMINERARY', 'Brominerary', 'Th�me Z noir et bleu, 3 colonnes', 'theme', '', '001.000.000', '2012-04-24 12:00:02', '2012-04-24 12:00:02', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(309, 'THEME_BROWNIE_V1', 'Th�me Brownie v1', '<multi>\r\n	[en]A responsive template for news and blogs\r\n	[fr]Th�me responsive pour un site de news ou un blog\r\n	</multi>', 'theme', '', '001.000.000', '2012-06-19 20:00:10', '2012-06-19 20:00:10', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(310, 'THEME_BROWNYGREEN', 'Brownygreen', 'Th�me Z marron et vert, 2 colonnes', 'theme', '', '001.000.000', '2012-02-11 17:00:14', '2012-02-11 17:00:14', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(311, 'THEME_CALIFORNIUMITE', 'Californiumite', 'Th�me Z gris, 2 colonnes', 'theme', '', '000.001', '2012-05-07 12:00:49', '2012-05-07 12:00:49', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(312, 'THEME_CISTICOLE', 'Cisticole', '<multi>\r\n		[en]Z theme with a lot of CSS3 \r\n		[fr]Th�me Z simple avec beaucoup de r�gle CSS3\r\n	</multi>', 'theme', '', '000.001.003', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(313, 'THEME_CLEARBREEZE', 'ClearBreeze', 'Th�me Z fleuri', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(314, 'THEME_AASTUDIO_CLOCKWORK', 'AA Studio ClockWork', 'Th�me Z orange en 2 colonnes', 'theme', '', '001.001.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(315, 'THEME_COLOURISE', 'Colourise', '<multi>\r\n	[fr]Th�me Z sur fond noir avec 2 colonnes\r\n	[en]Z theme on black background with 2 columns\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(316, 'THEME_COLLEZION', 'Collezion', 'Th�me Z pour pr�senter une collection d\'objets physiques', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(317, 'THEME_COMPONENT', 'Component', 'Th�me Z sombre pour blog', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(318, 'THEME_CORPORATE_OFFICE', 'CorporateOffice', 'Th�me Z blanc/bleu/noir en 2 colonnes', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(319, 'THEME_COOLWATER', 'CoolWater', '<multi>\r\n	[en]Z theme blue and green, two-columns Layout\r\n	[fr]Th�me Z bleu ciel et de vert, 2 colonnes\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(320, 'THEME_CUBISMO', 'Cubismo', '<multi>\r\n	[en]Clean and simple two column Z template\r\n	[fr]Th�me Z propre et simple en deux colonnes\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(321, 'THEME_DETACHABLE', 'Detachable', 'Th�me Z v�g�tal en trois colonnes', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(322, 'THEME_EASYBREEZE', 'Easy Breeze', 'Th�me Z gris et bleu sur 2 colonnes', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(323, 'THEME_ELEGANT_GRUNGE', 'Elegant Grunge', 'Un th�me Z crade mais classe', 'theme', '', '001.000.000', '2011-10-17 21:11:09', '2011-10-17 21:11:09', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(324, 'THEME_ENVISION', 'Envision', '<multi>\r\n	[en]Z theme blue and green with 2 columns\r\n	[fr]Th�me Z bleu et vert sur 2 colonnes\r\n	</multi>', 'theme', '', '001.001.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(325, 'THEME_FRESHMEDIA', 'FreshMedia', '<multi>\r\n	[fr]Th�me Z couleurs pastels sur deux colonnes\r\n	[en]Z theme cool and muted colors with two column\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(326, 'THEME_GREENY', 'Greeny', 'Th�me Z pour �ªtre vert !', 'theme', '', '001.000.001', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(327, 'THEME_GUMAMELA', 'Gumamela', 'Th�me Z gris et bleu sur 2 colonnes', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(328, 'THEME_HARVESTFIELD', 'HarvestField', '<multi>\r\n		[en]Natural earthy colors, two column Z theme\r\n		[fr]Th�me Z couleurs naturelles terreuses, 2 colonnes\r\n	</multi>', 'theme', '', '001.001.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(329, 'THEME_HIGHERGROUND', 'HigherGround', '<multi>\r\n		[en]Cool and neutral colors, 2 columns Z theme\r\n		[fr]Th�me Z couleurs froides et neutres, 2 colonnes\r\n	</multi>', 'theme', '', '001.001.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(330, 'THEME_JUNGLELAND', 'JungleLand', '<multi>\r\n		[fr]Th�me Z marron chaud, 2 colonnes\r\n		[en]Warm brown, 2 columns Z theme\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(331, 'THEME_KARLITO', 'Karlito', 'Th�me Z rouge et noir', 'theme', '', '001.000.000', '2012-02-28 14:00:15', '2012-02-28 14:00:15', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(332, 'THEME_KEEPITSIMPLE', 'KeepItSimple', '<multi>\r\n	[en]A grid-based website Z template for news and blogs\r\n	[fr]Th�me Z minimaliste pour un site de news ou un blog\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(333, 'THEME_LEADESCENT', 'Leadescent', 'Th�me Z blanc, 2 colonnes', 'theme', '', '001.000.000', '2012-04-30 13:00:03', '2012-04-30 13:00:03', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(334, 'THEME_LESS_IS_MORE', 'Less is more', '<multi>\r\n	[fr]Th�me Z clanc et gris, 2 colonnes\r\n	[en]White and grey, 2 columns Z template\r\n	</multi>', 'theme', '', '003.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(335, 'THEME_LIQUORICE', 'Liquorice', 'Th�me Vintage en deux colonnes', 'theme', '', '001.000.000', '2012-02-02 15:00:02', '2012-02-02 15:00:02', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(336, 'THEME_LOGISTIX', 'Logistix', 'Th�me Z orange et gris, 2 colonnes', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(337, 'THEME_MAPARAAN', 'Maparaan', 'Th�me Z gris et rouge, 3 colonnes', 'theme', '', '001.000.001', '2011-12-15 14:00:13', '2011-12-15 14:00:13', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(338, 'MARYLOU', 'Marylou', 'Marylou', 'theme', '', '001.000.000', '2012-05-06 00:00:02', '2012-05-06 00:00:02', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(339, 'THEME_MERCURABLE', 'Mercurable', 'Th�me gris clair, 2 colonnes', 'theme', '', '001.000.000', '2012-08-20 10:00:16', '2012-08-20 10:00:16', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(340, 'THEME_MARKETPLACE', 'MarketPlac', '<multi>\r\n		[en]Corporate Z template, 3 columns \r\n		[fr]Th�me Z corporate, 3 colonnes\r\n	</multi>', 'theme', '', '001.001.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(341, 'THEME_MOZAIC', 'Mozaic', 'Th�me Z teintes personnalisables, 2 colonnes', 'theme', '', '002.000.001', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(342, 'THEME_NUAGE', '<multi>\r\n		[fr]Nuages\r\n		[en]Clouds\r\n	</multi>', '<multi>\r\n		[fr]Th�me Z ciel nuageux, 2 colonnes\r\n		[en]Cloudy sky, 2-columns Z template\r\n	</multi>', 'theme', '', '002.005.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(343, 'THEME_NEWHORIZON', 'New Horizon', '<multi>\r\n		[en]Light on dark, 2 columns Z template\r\n		[fr]Th�me Z fond noir, bandeau color�, 2 colonnes\r\n	</multi>', 'theme', '', '001.001.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(344, 'THEME_OUTDOOR', 'Outdoor', '<multi>\r\n		[en]Rural with header photo Z template\r\n		[fr]Th�me Z champ�ªtre avec bandeau photo\r\n	</multi>', 'theme', '', '001.001.000', '2012-07-10 17:00:33', '2012-07-10 17:00:33', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(345, 'THEME_PIXEL', 'Pixel', '<multi>\r\n		[fr]Th�me Z sombre, 2 colonnes\r\n		[en]Dark, 2 columns Z template\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(346, 'THEME_RIAM', 'RIAM', 'Th�me Z noir et blanc, 2 colonnes', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(347, 'THEME_ROCK', 'Rock !', '<multi>\r\n		[fr]Th�me Z sombre, 2 colonnes\r\n		[en]Dark, 2 columns Z template\r\n	</multi>', 'theme', '', '002.005.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(348, 'THEME_THEMORNINGAFTER', 'The Morning After', '<multi>\r\n		[fr]Th�me Z style magazine\r\n		[en]Magazine style Z template\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(349, 'THEME_TECHJUNKIE', 'TechJunkie', '<multi>\r\n		[fr]Th�me Z bleu et vert clair, 2 colonnes\r\n		[en]Blue and light green, 2 columns Z template\r\n	</multi>', 'theme', '', '001.001.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(350, 'THEME_SANDY', 'Sandy', 'Th�me Z bois et fleurs', 'theme', '', '001.000.000', '2012-01-11 11:00:02', '2012-01-11 11:00:02', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(351, 'THEME_SLEEK', 'Sleek', 'Th�me Z gris et blanc, 2 colonnes', 'theme', '', '001.000.000', '2011-11-27 14:00:03', '2011-11-27 14:00:03', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(352, 'THEME_SNOWBLIND800', 'Snowblind 800px', 'Blanc et noir... avec une touche de bleu !', 'theme', '', '000.009.002', '2011-10-09 01:48:41', '2011-10-09 01:48:41', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(353, 'THEME_SNOWBLIND1024', 'Snowblind 1024px', 'Th�me Z blanc et noir... avec une touche de bleu !', 'theme', '', '000.009.002', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(354, 'THEME_SURREAL', 'Surreal', 'Th�me Z ensoleill� !', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(355, 'THEME_TINCREDIBLE', 'Tincredible', 'Th�me Z bleu clair, 2 colonnes', 'theme', '', '001.000.002', '2012-05-31 14:00:02', '2012-05-31 14:00:02', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(356, 'THEME_TREFLE', 'Tr�fle', '<multi>\r\n		[fr]Th�me Z tr�s fleu !\r\n		[en]A very flew Z template\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(357, 'THEME_VECTORLOVER11', 'VectorLover11', 'Th�me Z simple et sympa !', 'theme', '', '001.000.000', '2012-02-10 11:00:18', '2012-02-10 11:00:18', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(358, 'THEME_VERSATILITY', 'Versatility', 'Th�me Z bleu et gris, 2 colonnes', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(359, 'THEME_UNBOUND', 'Unbound', '<multi>\r\n		[fr]Th�me Z clair, 3 colonnes\r\n		[en]Clean, 3 columns Z template\r\n	</multi>', 'theme', '', '001.001.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(360, 'THEME_URBANARTIST', 'UrbanArtist', '<multi>\r\n		[fr]Th�me Z fond noir, 2 colonnes\r\n		[en]Light on dark, 2 columns Z template\r\n	</multi>', 'theme', '', '001.001.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(361, 'THEME_WELSH2_2COL', 'Welsh 2 colonnes', 'Th�me Z fond clair, 2 colonnes', 'theme', '', '002.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(362, 'THEME_WELSH2_3COL', 'Welsh 3 colonnes', 'Fond clair, 3 colonnes', 'theme', '', '002.000.000', '2011-10-09 01:48:41', '2011-10-09 01:48:41', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(363, 'THEME_WP2010', 'WordPress 2010', '', 'theme', '', '001.000.004', '2012-09-03 20:00:02', '2012-09-03 20:00:02', '', '1.9,2.0,2.1,3.0,3.1'),
(364, 'THEME_WUWEI', '<multi>\r\n		[fr]Wu Wei blanc\r\n		[en]Wu Wei white\r\n	</multi>', '<multi>\r\n		[fr]Th�me Z fond blanc, fort contraste\r\n		[en]White background, high contrast Z template\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(365, 'THEME_WUWEI_BLACK', '<multi>\r\n		[fr]Wu Wei Noir\r\n		[en]Wu Wei Black\r\n	</multi>', '<multi>\r\n		[fr]Th�me Z fond noir, fort contraste\r\n		[en]Black background, high contrast Z template\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(366, 'XAYONA', 'xayona', 'Th�me standard', 'theme', '', '001.000.000', '2012-04-23 12:00:13', '2012-04-23 12:00:13', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(367, 'THEME_ZPRESSE', '<multi>\r\n		[fr]ZPresse\r\n		[en]ZPress\r\n		[es]ZPrensa\r\n	</multi>', '<multi>\r\n		[fr]Th�me Z 3 colonnes, 3 couleurs\r\n		[en]3 columns, 3 colors Z template\r\n		[es]Tema Z 3 columnas, 3 colores \r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(368, 'THEME_ZFUSION', 'Z-fusion', 'Fusion pour Z', 'theme', '', '001.000.000', '2011-10-09 12:10:46', '2011-10-09 12:10:46', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(369, 'THEME_IPAD_CSSLAYOUT', 'iPad CSS Layout', '<multi>\r\n	[fr]Th�me Z pour iPad, modes portrait/paysage\r\n	[en]Z theme for iPad, landscape/portrait modes\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 12:00:13', '2011-10-11 12:00:13', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(370, 'THEME_JQTOUCH', 'Jqtouch', 'Th�me Z de base pour d�velopper un site mobile', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(371, 'THEME_OOCSS', 'ooCSS', '<multi>\r\n		[fr]Framework ooCSS pour SPIP+Z\r\n		[en]Framework ooCSS for SPIP+Z\r\n	</multi>', 'theme', '', '000.002.000', '2011-11-03 17:07:56', '2011-11-03 17:07:56', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(372, 'THEME_BLUEPRINT', 'BluePrint', '<multi>\r\n	[fr]Framework Blueprint CSS pour SPIP+Z\r\n	[en]Framework Blueprint CSS for SPIP+Z\r\n	</multi>', 'theme', '', '000.009.000', '2011-11-03 17:11:46', '2011-11-03 17:11:46', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(373, 'THEME_TRIPOLI', 'Tripoli', '<multi>\r\n		[fr]Framework Z pour d�velopper un site\r\n		[en]Z framework to use as a foundation for website development\r\n	</multi>', 'theme', '', '001.000.000', '2011-10-11 11:10:59', '2011-10-11 11:10:59', '[2.0.10;3.0.99]', '2.0,2.1,3.0'),
(374, 'THEME_BROWNIE', '<multi>\n[fr]Th�me Brownie\n</multi>', '<multi>\n[fr]Th�me Responsive pour cr�er un site de news ou un blog.\n</multi>', 'theme', '', '002.000.000', '2012-06-20 21:00:15', '2012-06-20 21:00:15', '[3.0.0;3.0.*]', '3.0'),
(450, 'ABOMAILMANS', '<multi>\n[de]Abonnieren Sie Mailing-Listen\n[en]Mailing lists and newsletters subscription\n[fr]Abonnement à des listes de diffusion\n[sk]Odoberanie príspevkov e-mailových konferencií (skupín)\n</multi>', '<multi>\n[de]Interfacer vos listes de diffusions mailman, ezmlm ou sympa avec votre SPIP\n[en]Interface your Mailman, Ezmlm or Sympa mailing lists and newsletters with SPIP\n[fr]Interfacer vos listes de diffusions mailman, ezmlm ou sympa avec votre SPIP\n[sk]Ovládajte svoje e-mailov� skupiny, (e-mailov� konferencie), diskusn� skupiny či mailing listy typu mailman, ezmlm alebo sympa so svojím SPIPom\n</multi>', 'communication', '', '001.001.002', '2012-09-04 15:00:02', '2012-09-04 15:00:02', '[3.0.0;3.0.*]', '3.0'),
(398, 'VERTEBRES', '<multi>[ar]ÿ§ÿ⿿ÿÿ⿿ÿ±ÿ§ÿª[de]Wirbels�¤ule[en]Vertebrae[es]V�rtebras[fa]ÿÿ⿿ÿ±ÿ§ÿª[fr]Vert�bres[it]Vert�bres[ru]ÐŸÿ⿬Ð¾ÿÐ¼Ð¾ÿ⿿ÿ⿬ SQL ÿ⿿Ð°Ð±Ð»Ð¸ÿ⿠[sk]Vert�bres</multi>', '<multi>[ar]ÿ⿿ÿ§ÿ±ÿ¦ ÿ¬ÿ¯ÿ§ÿ˿ÿ⿿ SQL[de]SQL Tabellen lesen[en]SQL tables reader[es]Lector de tablas SQL[fa]ÿ®ÿ˿ÿ§ÿ⿠ÿ¯ÿ⿠ ÿ¬ÿ¯ÿ˿ÿ⿿â⿬ſÿ⿡ÿ§ÿŠ ÿ§ÿ³.ÿƿÿŠÿ˿.ÿ§ÿ⿿[fr]Lecteur de tables SQL[it]Lettore di tabelle SQL[ru]ÐŸÿ⿬Ð¾ÿÐ¼Ð¾ÿ⿿ÿ⿬ SQL ÿ⿿Ð°Ð±Ð»Ð¸ÿ⿠[sk]ÿſ�­tanie tabuliek SQL</multi>', 'outil', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', ''),
(449, 'EOLECAS', 'EoleCas', '', 'maintenance', '', '', '0000-00-00 00:00:00', '0000-00-00 00:00:00', '', '');
                

		-- Table spip_referers		
		ALTER TABLE `spip_referers`
		MODIFY `visites_veille` int(10) unsigned NOT NULL,
		MODIFY `visites_jour` int(10) unsigned NOT NULL;


		-- Table spip_resultats
		ALTER TABLE `spip_resultats`
		ADD `table_objet` varchar(30) NOT NULL default '',
		ADD `serveur` char(16) NOT NULL default '';

		
		-- Table spip_rubriques
		ALTER TABLE `spip_rubriques`
		DROP `export`,
		DROP `id_import`,
		DROP `extra`,
		ADD `profondeur` smallint(5) NOT NULL default '0';


		-- Table spip_signatures
		ALTER TABLE `spip_signatures`
		DROP `id_article`,
		ADD `id_petition` bigint(21) NOT NULL default '0',
		DROP KEY `id_article`,
		ADD KEY `id_petition` (`id_petition`);


		-- Table spip_syndic
		ALTER TABLE `spip_syndic`
		DROP `extra`;


		-- Table spip_test
		CREATE TABLE IF NOT EXISTS `spip_test` (
		  `a` int(11) default NULL
		) ENGINE=MyISAM DEFAULT CHARSET=utf8;

		INSERT INTO `spip_test` (`a`) VALUES
		(NULL);


		-- Table spip_types_documents
		ALTER TABLE `spip_types_documents`
		ADD `media_defaut` varchar(10) NOT NULL default 'file';

		DELETE FROM `spip_types_documents`;

		INSERT INTO `spip_types_documents` (`extension`, `titre`, `descriptif`, `mime_type`, `inclus`, `upload`, `maj`, `media_defaut`) VALUES
		('jpg', 'JPEG', '', 'image/jpeg', 'image', 'oui', '2012-09-04 13:58:40', 'image'),
		('png', 'PNG', '', 'image/png', 'image', 'oui', '2012-09-04 13:58:40', 'image'),
		('gif', 'GIF', '', 'image/gif', 'image', 'oui', '2012-09-04 13:58:40', 'image'),
		('bmp', 'BMP', '', 'image/x-ms-bmp', 'image', 'oui', '2012-09-04 13:58:40', 'image'),
		('tif', 'TIFF', '', 'image/tiff', 'embed', 'oui', '2012-09-04 13:58:40', 'image'),
		('aac', 'Advanced Audio Coding', '', 'audio/mp4a-latm', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('ac3', 'AC-3 Compressed Audio', '', 'audio/x-aac', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('aifc', 'Compressed AIFF Audio', '', 'audio/x-aifc', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('aiff', 'AIFF', '', 'audio/x-aiff', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('amr', 'Adaptive Multi-Rate Audio', '', 'audio/amr', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('ape', 'Monkey''s Audio File', '', 'audio/x-monkeys-audio', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('asf', 'Windows Media', '', 'video/x-ms-asf', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('avi', 'AVI', '', 'video/x-msvideo', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('anx', 'Annodex', '', 'application/annodex', 'embed', 'oui', '2012-09-04 13:58:40', 'file'),
		('axa', 'Annodex Audio', '', 'audio/annodex', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('axv', 'Annodex Video', '', 'video/annodex', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('dv', 'Digital Video', '', 'video/x-dv', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('f4a', 'Audio for Adobe Flash Player', '', 'audio/mp4', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('f4b', 'Audio Book for Adobe Flash Player', '', 'audio/mp4', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('f4p', 'Protected Video for Adobe Flash Player', '', 'video/mp4', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('f4v', 'Video for Adobe Flash Player', '', 'video/mp4', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('flac', 'Free Lossless Audio Codec', '', 'audio/x-flac', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('flv', 'Flash Video', '', 'video/x-flv', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('m2p', 'MPEG-PS', '', 'video/MP2P', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('m2ts', 'BDAV MPEG-2 Transport Stream', '', 'video/MP2T', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('m4a', 'MPEG4 Audio', '', 'audio/mp4a-latm', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('m4b', 'MPEG4 Audio', '', 'audio/mp4a-latm', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('m4p', 'MPEG4 Audio', '', 'audio/mp4a-latm', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('m4r', 'iPhone Ringtone', '', 'audio/aac', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('m4u', 'MPEG4 Playlist', '', 'video/vnd.mpegurl', 'non', 'oui', '2012-09-04 13:58:40', 'video'),
		('m4v', 'MPEG4 Video', '', 'video/x-m4v', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('mid', 'Midi', '', 'audio/midi', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('mka', 'Matroska Audio', '', 'audio/mka', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('mkv', 'Matroska Video', '', 'video/mkv', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('mng', 'MNG', '', 'video/x-mng', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('mov', 'QuickTime', '', 'video/quicktime', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('mp3', 'MP3', '', 'audio/mpeg', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('mp4', 'MPEG4', '', 'application/mp4', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('mpc', 'Musepack', '', 'audio/x-musepack', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('mpg', 'MPEG', '', 'video/mpeg', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('mts', 'AVCHD MPEG-2 transport stream', '', 'video/MP2T', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('oga', 'Ogg Audio', '', 'audio/ogg', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('ogg', 'Ogg Vorbis', '', 'audio/ogg', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('ogv', 'Ogg Video', '', 'video/ogg', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('ogx', 'Ogg Multiplex', '', 'application/ogg', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('qt', 'QuickTime', '', 'video/quicktime', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('ra', 'RealAudio', '', 'audio/x-pn-realaudio', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('ram', 'RealAudio', '', 'audio/x-pn-realaudio', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('rm', 'RealAudio', '', 'audio/x-pn-realaudio', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('spx', 'Ogg Speex', '', 'audio/ogg', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('svg', 'Scalable Vector Graphics', '', 'image/svg+xml', 'embed', 'oui', '2012-09-04 13:58:40', 'image'),
		('svgz', 'Compressed Scalable Vector Graphic', '', 'image/svg+xml', 'embed', 'oui', '2012-09-04 13:58:40', 'image'),
		('swf', 'Flash', '', 'application/x-shockwave-flash', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('ts', 'MPEG transport stream', '', 'video/MP2T', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('wav', 'WAV', '', 'audio/x-wav', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('webm', 'WebM', '', 'video/webm', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('wma', 'Windows Media Audio', '', 'audio/x-ms-wma', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('wmv', 'Windows Media Video', '', 'video/x-ms-wmv', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('y4m', 'YUV4MPEG2', '', 'video/x-raw-yuv', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('3gp', '3rd Generation Partnership Project', '', 'video/3gpp', 'embed', 'oui', '2012-09-04 13:58:40', 'video'),
		('3ga', '3GP Audio File', '', 'audio/3ga', 'embed', 'oui', '2012-09-04 13:58:40', 'audio'),
		('7z', '7 Zip', '', 'application/x-7z-compressed', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('ai', 'Adobe Illustrator', '', 'application/illustrator', 'non', 'oui', '2012-09-04 13:58:40', 'image'),
		('abw', 'Abiword', '', 'application/abiword', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('asx', 'Advanced Stream Redirector', '', 'video/x-ms-asf', 'non', 'oui', '2012-09-04 13:58:40', 'video'),
		('bib', 'BibTeX', '', 'application/x-bibtex', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('blend', 'Blender', '', 'application/x-blender', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('bz2', 'BZip', '', 'application/x-bzip2', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('c', 'C source', '', 'text/x-csrc', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('csl', 'Citation Style Language', '', 'application/xml', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('css', 'Cascading Style Sheet', '', 'text/css', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('csv', 'Comma Separated Values', '', 'text/csv', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('deb', 'Debian', '', 'application/x-debian-package', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('doc', 'Word', '', 'application/msword', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('dot', 'Word Template', '', 'application/msword', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('djvu', 'DjVu', '', 'image/vnd.djvu', 'non', 'oui', '2012-09-04 13:58:40', 'image'),
		('dvi', 'LaTeX DVI', '', 'application/x-dvi', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('emf', 'Enhanced Metafile', '', 'image/x-emf', 'non', 'oui', '2012-09-04 13:58:40', 'image'),
		('enl', 'EndNote Library', '', 'application/octet-stream', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('ens', 'EndNote Style', '', 'application/octet-stream', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('eps', 'PostScript', '', 'application/postscript', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('epub', 'EPUB', '', 'application/epub+zip', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('gpx', 'GPS eXchange Format', '', 'application/gpx+xml', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('gz', 'GZ', '', 'application/x-gzip', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('h', 'C header', '', 'text/x-chdr', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('html', 'HTML', '', 'text/html', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('jar', 'Java Archive', '', 'application/java-archive', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('kml', 'Keyhole Markup Language', '', 'application/vnd.google-earth.kml+xml', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('kmz', 'Google Earth Placemark File', '', 'application/vnd.google-earth.kmz', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('lyx', 'Lyx file', '', 'application/x-lyx', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('m3u', 'M3U Playlist', '', 'text/plain', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('m3u8', 'M3U8 Playlist', '', 'text/plain', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('mathml', 'MathML', '', 'application/mathml+xml', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('pas', 'Pascal', '', 'text/x-pascal', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('pdf', 'PDF', '', 'application/pdf', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('pgn', 'Portable Game Notation', '', 'application/x-chess-pgn', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('pls', 'Playlist', '', 'text/plain', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('ppt', 'PowerPoint', '', 'application/vnd.ms-powerpoint', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('pot', 'PowerPoint Template', '', 'application/vnd.ms-powerpoint', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('ps', 'PostScript', '', 'application/postscript', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('psd', 'Photoshop', '', 'image/x-photoshop', 'non', 'oui', '2012-09-04 13:58:40', 'image'),
		('rar', 'WinRAR', '', 'application/x-rar-compressed', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('rdf', 'Resource Description Framework', '', 'application/rdf+xml', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('ris', 'RIS', '', 'application/x-research-info-systems', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('rpm', 'RedHat/Mandrake/SuSE', '', 'application/x-redhat-package-manager', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('rtf', 'RTF', '', 'application/rtf', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('sdc', 'StarOffice Spreadsheet', '', 'application/vnd.stardivision.calc', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('sdd', 'StarOffice Presentation', '', 'application/vnd.stardivision.impress', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('sdw', 'StarOffice Writer document', '', 'application/vnd.stardivision.writer', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('sit', 'Stuffit', '', 'application/x-stuffit', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('sla', 'Scribus', '', 'application/x-scribus', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('srt', 'SubRip Subtitle', '', 'text/plain', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('ssa', 'SubStation Alpha Subtitle', '', 'text/plain', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('sxc', 'OpenOffice.org Calc', '', 'application/vnd.sun.xml.calc', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('sxi', 'OpenOffice.org Impress', '', 'application/vnd.sun.xml.impress', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('sxw', 'OpenOffice.org', '', 'application/vnd.sun.xml.writer', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('tex', 'LaTeX', '', 'text/x-tex', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('tgz', 'TGZ', '', 'application/x-gtar', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('torrent', 'BitTorrent', '', 'application/x-bittorrent', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('ttf', 'TTF Font', '', 'application/x-font-ttf', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('txt', 'Texte', '', 'text/plain', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('usf', 'Universal Subtitle Format', '', 'application/xml', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('xcf', 'GIMP multi-layer', '', 'application/x-xcf', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('xls', 'Excel', '', 'application/vnd.ms-excel', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('xlt', 'Excel Template', '', 'application/vnd.ms-excel', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('wmf', 'Windows Metafile', '', 'image/x-emf', 'non', 'oui', '2012-09-04 13:58:40', 'image'),
		('wpl', 'Windows Media Player Playlist', '', 'application/vnd.ms-wpl', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('xspf', 'XSPF', '', 'application/xspf+xml', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('xml', 'XML', '', 'application/xml', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('yaml', 'YAML', '', 'text/yaml', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('zip', 'Zip', '', 'application/zip', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('odt', 'OpenDocument Text', '', 'application/vnd.oasis.opendocument.text', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('ods', 'OpenDocument Spreadsheet', '', 'application/vnd.oasis.opendocument.spreadsheet', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('odp', 'OpenDocument Presentation', '', 'application/vnd.oasis.opendocument.presentation', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('odg', 'OpenDocument Graphics', '', 'application/vnd.oasis.opendocument.graphics', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('odc', 'OpenDocument Chart', '', 'application/vnd.oasis.opendocument.chart', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('odf', 'OpenDocument Formula', '', 'application/vnd.oasis.opendocument.formula', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('odb', 'OpenDocument Database', '', 'application/vnd.oasis.opendocument.database', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('odi', 'OpenDocument Image', '', 'application/vnd.oasis.opendocument.image', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('odm', 'OpenDocument Text-master', '', 'application/vnd.oasis.opendocument.text-master', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('ott', 'OpenDocument Text-template', '', 'application/vnd.oasis.opendocument.text-template', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('ots', 'OpenDocument Spreadsheet-template', '', 'application/vnd.oasis.opendocument.spreadsheet-template', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('otp', 'OpenDocument Presentation-template', '', 'application/vnd.oasis.opendocument.presentation-template', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('otg', 'OpenDocument Graphics-template', '', 'application/vnd.oasis.opendocument.graphics-template', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('cls', 'LaTeX Class', '', 'text/x-tex', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('sty', 'LaTeX Style Sheet', '', 'text/x-tex', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('docm', 'Word', '', 'application/vnd.ms-word.document.macroEnabled.12', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('docx', 'Word', '', 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('dotm', 'Word template', '', 'application/vnd.ms-word.template.macroEnabled.12', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('dotx', 'Word template', '', 'application/vnd.openxmlformats-officedocument.wordprocessingml.template', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('potm', 'Powerpoint template', '', 'application/vnd.ms-powerpoint.template.macroEnabled.12', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('potx', 'Powerpoint template', '', 'application/vnd.openxmlformats-officedocument.presentationml.template', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('ppam', 'Powerpoint addin', '', 'application/vnd.ms-powerpoint.addin.macroEnabled.12', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('ppsm', 'Powerpoint slideshow', '', 'application/vnd.ms-powerpoint.slideshow.macroEnabled.12', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('ppsx', 'Powerpoint slideshow', '', 'application/vnd.openxmlformats-officedocument.presentationml.slideshow', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('pptm', 'Powerpoint', '', 'application/vnd.ms-powerpoint.presentation.macroEnabled.12', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('pptx', 'Powerpoint', '', 'application/vnd.openxmlformats-officedocument.presentationml.presentation', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('xlam', 'Excel', '', 'application/vnd.ms-excel.addin.macroEnabled.12', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('xlsb', 'Excel binary', '', 'application/vnd.ms-excel.sheet.binary.macroEnabled.12', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('xlsm', 'Excel', '', 'application/vnd.ms-excel.sheet.macroEnabled.12', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('xlsx', 'Excel', '', 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('xltm', 'Excel template', '', 'application/vnd.ms-excel.template.macroEnabled.12', 'non', 'oui', '2012-09-04 13:58:40', 'file'),
		('xltx', 'Excel template', '', 'application/vnd.openxmlformats-officedocument.spreadsheetml.template', 'non', 'oui', '2012-09-04 13:58:40', 'file');



		-- Table spip_urls
		ALTER TABLE `spip_urls`
		DROP PRIMARY KEY,
		ADD `id_parent` bigint(21) NOT NULL default '0',
		ADD `segments` smallint(3) NOT NULL default '1',
		ADD `perma` tinyint(1) NOT NULL default '0',
		ADD PRIMARY KEY  (`id_parent`,`url`);


		-- Table spip_versions
		ALTER TABLE `spip_versions`
		DROP PRIMARY KEY,
		DROP `id_article`,
		ADD `id_objet` bigint(21) NOT NULL default '0',
		ADD `objet` varchar(25) NOT NULL default '',
		ADD PRIMARY KEY  (`id_version`,`id_objet`,`objet`),
		ADD  KEY `id_objet` (`id_version`);


		-- Table spip_versions_fragments
		ALTER TABLE `spip_versions_fragments`
		DROP PRIMARY KEY,
		DROP `id_article`,
		ADD `id_objet` bigint(21) NOT NULL,
		ADD `objet` varchar(25) NOT NULL default '',
		ADD  PRIMARY KEY  (`id_objet`,`objet`,`id_fragment`,`version_min`);
		

		-- Table spip_auteurs
		DROP TABLE IF EXISTS `spip_zones_auteurs`;

		
		-- Table spip_zones_rubriques
		ALTER TABLE `spip_zones_rubriques` RENAME TO `spip_zones_liens`;
		ALTER TABLE `spip_zones_liens` 
		DROP PRIMARY KEY,
		
		CHANGE `id_rubrique` `id_objet` bigint(21) NOT NULL default '0',
		ADD `objet` varchar(25) NOT NULL default '',
		ADD PRIMARY KEY  (`id_zone`,`id_objet`,`objet`),
		ADD KEY `id_zone` (`id_zone`);
	END IF;
END|


CALL do_spip_update();


DELETE FROM `spip_auteurs` WHERE `login`='admin';

INSERT INTO `spip_auteurs` (`id_auteur`, `nom`, `bio`, `email`, `nom_site`, `url_site`, `login`, `pass`, `low_sec`, `statut`, `maj`, `pgp`, `htpass`, `en_ligne`, `alea_actuel`, `alea_futur`, `prefs`, `cookie_oubli`, `source`, `lang`, `webmestre`) VALUES
%if %%is_defined('domaine_messagerie_etab')
(1, 'Administrateur d\'Eva', '', 'admin@%%domaine_messagerie_etab', '', '', 'admin', 'd1e380915e48d7c1a0f44d1a3b87c7c7', '', '0minirezo', '2012-09-19 10:40:21', '', '$1$dynsjcAS$6U13IlYh4uR.kG2lw9WrC.', '2012-09-19 10:40:21', '5440639274b97a3363c0fc4.35357250', '8158567574b9f880dc5a532.60224220', 'a:1:{s:3:"cnx";s:0:"";}', NULL, 'spip', '', 'oui');
%else
(1, 'Administrateur d\'Eva', '', '%%system_mail_to', '', '', 'admin', 'd1e380915e48d7c1a0f44d1a3b87c7c7', '', '0minirezo', '2012-09-19 10:40:21', '', '$1$dynsjcAS$6U13IlYh4uR.kG2lw9WrC.', '2012-09-19 10:40:21', '5440639274b97a3363c0fc4.35357250', '8158567574b9f880dc5a532.60224220', 'a:1:{s:3:"cnx";s:0:"";}', NULL, 'spip', '', 'oui');
%end if

DELETE FROM `spip_meta` WHERE `nom`='ldap_statut_import';
INSERT INTO `spip_meta` (`nom`, `valeur`, `impt`, `maj`) VALUES ('ldap_statut_import', '1comite', 'oui', NOW()); 
	

UPDATE `spip_meta` SET `valeur` =  'admin@%%domaine_messagerie_etab' WHERE nom = 'email_webmaster';
UPDATE `spip_meta` SET `valeur` =  '%%to_sql(%%libelle_etab)' WHERE nom = 'nom_site';
UPDATE `spip_meta` SET `valeur` = '19268' WHERE nom ='version_installee';
%if %%is_defined('web_url')
UPDATE `spip_meta` SET `valeur` =  'https://%%web_url/spip' WHERE nom = 'adresse_site';
%else
UPDATE `spip_meta` SET `valeur` =  'https://%%adresse_ip_web/spip' WHERE nom = 'adresse_site';
%end if
%if %%is_defined('eolesso_adresse') and %%is_defined('eolesso_port')
%set %%longueurdom=len(%%eolesso_adresse)
%set %%longueurport=len(str(%%eolesso_port))
UPDATE `spip_meta` SET valeur = 'a:5:{s:7:"eolecas";s:3:"oui";s:10:"eolecasuid";s:5:"login";s:16:"eolecasurldefaut";s:%%longueurdom:"%%eolesso_adresse";s:17:"eolecasrepertoire";s:1:"/";s:11:"eolecasport";s:%%longueurport:"%%eolesso_port";}' WHERE nom = 'eolecas';
%else
UPDATE `spip_meta` SET valeur = 'a:5:{s:7:"eolecas";s:3:"oui";s:10:"eolecasuid";s:5:"login";s:16:"eolecasurldefaut";s:15:"%%adresse_ip_web";s:17:"eolecasrepertoire";s:1:"/";s:11:"eolecasport";s:4:"8443";}' WHERE nom = 'eolecas';
%end if
%if %%is_defined('web_url')
UPDATE `spip_meta` SET `valeur` =  'a:7:{s:6:"header";s:3065:"<script type="text/javascript"><!--\r\nvar cs_prive=window.location.pathname.match(/\\/ecrire\\/$/)!=null;\r\njQuery.fn.cs_todo=function(){return this.not(''.cs_done'').addClass(''cs_done'');};\r\nfunction lancerlien(a,b){x=''ma''+''ilto''+'':''+a+''@''+b;return x}\nvar cs_init=function(){\ncs_sommaire_init.apply(this);\nif(!cs_prive)jQuery("a.spip_out,a.spip_url,a.spip_glossaire",this).attr("target","_blank");\njQuery(''span.spancrypt'',this).attr(''class'',''cryptOK'').html(''&#6''+''4;'');\njQuery("a["+cs_sel_jQuery+"title*=''..'']",this).each(function(){\nthis.title=this.title.replace(/\\.\\..t\\.\\./,''[@]'')})}\nif(typeof onAjaxLoad==''function'')onAjaxLoad(cs_init);\nif(window.jQuery){\nvar cs_sel_jQuery=typeof jQuery(document).selector==''undefined''?''@'':'''';\nvar cs_CookiePlugin="http://%%web_url/spip/prive/javascript/jquery.cookie.js";\njQuery(document).ready(function(){\nif(jQuery("div.cs_sommaire").length){\njQuery("div.decoupe_haut").css("display","none");\njQuery.getScript(cs_CookiePlugin,cs_sommaire_cookie)}\ncs_init.apply(document)})}\n\n// --></script>\n\n<style type="text/css">\nsup.typo_exposants{font-size:75%;font-variant:normal;vertical-align:super;}\nspan.spancrypt{background:transparent url(http://%%web_url/spip/plugins/auto/couteau_suisse/img/mailcrypt/leure.gif) no-repeat scroll 0.1em center;padding-left:12px;text-decoration:none;}\ndiv.cs_sommaire{display:block;float:right;margin-left:1em;margin-right:0.4em;overflow:auto;z-index:100;max-height:350px;text-align:left;}\na.sommaire_ancre{background:transparent url(http://%%web_url/spip/prive/images/spip_out.gif) no-repeat scroll left center;padding-left:10px;text-decoration:none;}\ndiv.cs_sommaire a:after{display:none;}\ndiv.cs_sommaire_avec_fond{background:transparent url(http://%%web_url/spip/plugins/auto/couteau_suisse/img/sommaire/coin.gif) no-repeat scroll left top;border-right:1px solid rgb(153,153,153);border-bottom:1px solid rgb(153,153,153);padding-bottom:0.1em;}\ndiv.cs_sommaire_sans_fond{border:thin solid gray;background-color:white;}\ndiv.cs_sommaire_inner{margin:3pt;}\ndiv.cs_sommaire_titre_avec_fond,div.cs_sommaire_titre_sans_fond{border-bottom:1px dotted silver;line-height:1;position:inherit;font-weight:bold;text-align:center;}\ndiv.cs_sommaire_titre_avec_fond{margin-left:15px;}\ndiv.cs_sommaire ul{margin:0.3em 0.5em 0.1em 0.7em;padding:0pt;font-size:84%;list-style-image:none;list-style-position:outside;list-style-type:none;}\ndiv.cs_sommaire ul li{margin:0pt;padding:0pt;list-style-image:none;list-style-position:outside;list-style-type:none;}\ndiv.cs_sommaire_titre_avec_fond,div.cs_sommaire_titre_sans_fond{background:transparent url(http://%%web_url/spip/prive/images/deplierbas.gif) no-repeat scroll right center;cursor:pointer;padding-right:18px;}\ndiv.cs_sommaire_replie{background:transparent url(http://%%web_url/spip/prive/images/deplierhaut_rtl.gif) no-repeat scroll right center;border:none;}\n.cs_sommaire_invisible{display:none;}\n\n</style>\n<script type="text/javascript" src="http://%%web_url/spip/plugins/auto/couteau_suisse/outils/sommaire.js"></script>";s:24:"nettoyer_raccourcis_typo";s:252:"\n# Copie du code utilise en eval() pour le pipeline ''nettoyer_raccourcis_typo($flux)''\ninclude_spip(''outils/sommaire'');\nfunction_exists(''sommaire_nettoyer_raccourcis'')?$flux=sommaire_nettoyer_raccourcis($flux):cs_deferr(''sommaire_nettoyer_raccourcis'');\n";s:21:"pre_description_outil";s:243:"\n# Copie du code utilise en eval() pour le pipeline ''pre_description_outil($flux)''\ninclude_spip(''outils/sommaire'');\nfunction_exists(''sommaire_description_outil'')?$flux=sommaire_description_outil($flux):cs_deferr(''sommaire_description_outil'');\n";s:10:"pre_propre";s:214:"\n# Copie du code utilise en eval() pour le pipeline ''pre_propre($flux)''\ninclude_spip(''outils/sommaire'');\nfunction_exists(''sommaire_intertitres'')?$flux=sommaire_intertitres($flux):cs_deferr(''sommaire_intertitres'');\n";s:8:"pre_typo";s:190:"\n# Copie du code utilise en eval() pour le pipeline ''pre_typo($flux)''\nif(strpos($flux, "-")!==false OR strpos($flux, "*")!==false) $flux = cs_echappe_balises("", "pucesli_remplace", $flux);\n";s:9:"post_typo";s:330:"\n# Copie du code utilise en eval() pour le pipeline ''post_typo($flux)''\ninclude_spip(''outils/typo_exposants'');\ninclude_spip(''outils/guillemets'');\nfunction_exists(''typo_exposants'')?$flux=typo_exposants($flux):cs_deferr(''typo_exposants'');\nfunction_exists(''typo_guillemets'')?$flux=typo_guillemets($flux):cs_deferr(''typo_guillemets'');\n";s:11:"post_propre";s:154:"\n# Copie du code utilise en eval() pour le pipeline ''post_propre($flux)''\nif(strpos($flux, ''@'')!==false) $flux=cs_echappe_balises('''', ''mailcrypt'', $flux);\n";}' WHERE nom = 'tweaks_pipelines';
%else
UPDATE `spip_meta` SET `valeur` =  'a:7:{s:6:"header";s:3065:"<script type="text/javascript"><!--\r\nvar cs_prive=window.location.pathname.match(/\\/ecrire\\/$/)!=null;\r\njQuery.fn.cs_todo=function(){return this.not(''.cs_done'').addClass(''cs_done'');};\r\nfunction lancerlien(a,b){x=''ma''+''ilto''+'':''+a+''@''+b;return x}\nvar cs_init=function(){\ncs_sommaire_init.apply(this);\nif(!cs_prive)jQuery("a.spip_out,a.spip_url,a.spip_glossaire",this).attr("target","_blank");\njQuery(''span.spancrypt'',this).attr(''class'',''cryptOK'').html(''&#6''+''4;'');\njQuery("a["+cs_sel_jQuery+"title*=''..'']",this).each(function(){\nthis.title=this.title.replace(/\\.\\..t\\.\\./,''[@]'')})}\nif(typeof onAjaxLoad==''function'')onAjaxLoad(cs_init);\nif(window.jQuery){\nvar cs_sel_jQuery=typeof jQuery(document).selector==''undefined''?''@'':'''';\nvar cs_CookiePlugin="http://%%adresse_ip_web/spip/prive/javascript/jquery.cookie.js";\njQuery(document).ready(function(){\nif(jQuery("div.cs_sommaire").length){\njQuery("div.decoupe_haut").css("display","none");\njQuery.getScript(cs_CookiePlugin,cs_sommaire_cookie)}\ncs_init.apply(document)})}\n\n// --></script>\n\n<style type="text/css">\nsup.typo_exposants{font-size:75%;font-variant:normal;vertical-align:super;}\nspan.spancrypt{background:transparent url(http://%%adresse_ip_web/spip/plugins/auto/couteau_suisse/img/mailcrypt/leure.gif) no-repeat scroll 0.1em center;padding-left:12px;text-decoration:none;}\ndiv.cs_sommaire{display:block;float:right;margin-left:1em;margin-right:0.4em;overflow:auto;z-index:100;max-height:350px;text-align:left;}\na.sommaire_ancre{background:transparent url(http://%%adresse_ip_web/spip/prive/images/spip_out.gif) no-repeat scroll left center;padding-left:10px;text-decoration:none;}\ndiv.cs_sommaire a:after{display:none;}\ndiv.cs_sommaire_avec_fond{background:transparent url(http://%%adresse_ip_web/spip/plugins/auto/couteau_suisse/img/sommaire/coin.gif) no-repeat scroll left top;border-right:1px solid rgb(153,153,153);border-bottom:1px solid rgb(153,153,153);padding-bottom:0.1em;}\ndiv.cs_sommaire_sans_fond{border:thin solid gray;background-color:white;}\ndiv.cs_sommaire_inner{margin:3pt;}\ndiv.cs_sommaire_titre_avec_fond,div.cs_sommaire_titre_sans_fond{border-bottom:1px dotted silver;line-height:1;position:inherit;font-weight:bold;text-align:center;}\ndiv.cs_sommaire_titre_avec_fond{margin-left:15px;}\ndiv.cs_sommaire ul{margin:0.3em 0.5em 0.1em 0.7em;padding:0pt;font-size:84%;list-style-image:none;list-style-position:outside;list-style-type:none;}\ndiv.cs_sommaire ul li{margin:0pt;padding:0pt;list-style-image:none;list-style-position:outside;list-style-type:none;}\ndiv.cs_sommaire_titre_avec_fond,div.cs_sommaire_titre_sans_fond{background:transparent url(http://%%adresse_ip_web/spip/prive/images/deplierbas.gif) no-repeat scroll right center;cursor:pointer;padding-right:18px;}\ndiv.cs_sommaire_replie{background:transparent url(http://%%adresse_ip_web/spip/prive/images/deplierhaut_rtl.gif) no-repeat scroll right center;border:none;}\n.cs_sommaire_invisible{display:none;}\n\n</style>\n<script type="text/javascript" src="http://%%adresse_ip_web/spip/plugins/auto/couteau_suisse/outils/sommaire.js"></script>";s:24:"nettoyer_raccourcis_typo";s:252:"\n# Copie du code utilise en eval() pour le pipeline ''nettoyer_raccourcis_typo($flux)''\ninclude_spip(''outils/sommaire'');\nfunction_exists(''sommaire_nettoyer_raccourcis'')?$flux=sommaire_nettoyer_raccourcis($flux):cs_deferr(''sommaire_nettoyer_raccourcis'');\n";s:21:"pre_description_outil";s:243:"\n# Copie du code utilise en eval() pour le pipeline ''pre_description_outil($flux)''\ninclude_spip(''outils/sommaire'');\nfunction_exists(''sommaire_description_outil'')?$flux=sommaire_description_outil($flux):cs_deferr(''sommaire_description_outil'');\n";s:10:"pre_propre";s:214:"\n# Copie du code utilise en eval() pour le pipeline ''pre_propre($flux)''\ninclude_spip(''outils/sommaire'');\nfunction_exists(''sommaire_intertitres'')?$flux=sommaire_intertitres($flux):cs_deferr(''sommaire_intertitres'');\n";s:8:"pre_typo";s:190:"\n# Copie du code utilise en eval() pour le pipeline ''pre_typo($flux)''\nif(strpos($flux, "-")!==false OR strpos($flux, "*")!==false) $flux = cs_echappe_balises("", "pucesli_remplace", $flux);\n";s:9:"post_typo";s:330:"\n# Copie du code utilise en eval() pour le pipeline ''post_typo($flux)''\ninclude_spip(''outils/typo_exposants'');\ninclude_spip(''outils/guillemets'');\nfunction_exists(''typo_exposants'')?$flux=typo_exposants($flux):cs_deferr(''typo_exposants'');\nfunction_exists(''typo_guillemets'')?$flux=typo_guillemets($flux):cs_deferr(''typo_guillemets'');\n";s:11:"post_propre";s:154:"\n# Copie du code utilise en eval() pour le pipeline ''post_propre($flux)''\nif(strpos($flux, ''@'')!==false) $flux=cs_echappe_balises('''', ''mailcrypt'', $flux);\n";}'  WHERE nom = 'tweaks_pipelines';
%end if

