#!/bin/bash

# Création du fichier .pot et mise à jour des fichiers .po à partir des informations du fichier po_list
if [[ -e po_list ]]; then
    while read p; do
        project=$(echo $p |awk '{print $1}')
        files=$(echo $p |cut -f 1 -d " " --complement)
        if [[ ! -d translation/fr ]]; then
            mkdir -p translation/fr
        fi
        if [[ ! -d translation/en ]]; then
            mkdir -p translation/en
        fi
        # Création des fichiers po minimum (fr et en) si nécessaire.
        xgettext -L Python --keyword=_:1,2 --from-code=UTF-8 --force-po -F --copyright-holder="projet EOLE" --package-name=$project --msgid-bugs-address=eole@ac-dijon.fr --foreign-user -d $project -o translation/$project.pot $files
        sed -i -e 's/\("Content-Type: text\/plain; charset=\).*\(\\n"\)/\1UTF-8\2/g' translation/$project.pot

        # Mise à jour des fichiers po présents sous ./translation
        for po_file in $(find translation -name $project.po); do
            msgmerge -U $po_file translation/$project.pot
        done

        if [[ ! -e translation/fr/${project}.po ]]; then
            msginit -i translation/${project}.pot -o translation/fr/${project}.po -l fr_FR
            sed -i -e "s/\\(\"PO-Revision-Date: \\).*\\(\\\\n\"\\)/\\1$(date '+%Y-%m-%d %H:%M%z')\\2/g" \
                -e 's/\("Language-Team: \).*\(\\n"\)/\1Équipe EOLE <eole@ac-dijon.fr>\2/g' \
                -e 's/\("Content-Type: text\/plain; charset=\).*\(\\n"\)/\1UTF-8\2/g' \
                translation/fr/${project}.po
        fi
        # Le fichier po "en" est écrasé.
        msgen -o translation/en/$project.po translation/$project.pot
        sed -i -e 's/\("Last-Translator: \).*\(\\n"\)/\1Équipe EOLE <eole@ac-dijon.fr>\2/g' \
            -e "s/\\(\"PO-Revision-Date: \\).*\\(\\\\n\"\\)/\\1$(date '+%Y-%m-%d %H:%M%z')\\2/g" \
            -e 's/\("Language-Team: \).*\(\\n"\)/\1Équipe EOLE <eole@ac-dijon.fr>\2/g' \
            -e 's/\("Language: \).*\(\\n"\)/\1en\2/g' \
            -e 's/\("Content-Type: text\/plain; charset=\).*\(\\n"\)/\1UTF-8\2/g' \
            -e '/"Content-Transfer-Encoding: 8bit\\n"/a"Plural-Forms: nplurals=2; plural=(n > 1);\\n"' \
            -e '1,5 d' \
            translation/en/${project}.po

    done < po_list
fi


