# -*- coding: utf-8 -*-
"""
module utiliatire commun aux parties clientes et serveurs
de l'implémentation openid
"""

import socket


class HTMLResponse(object):
    def __init__(self, content='', title=''):
        self.content = content
        self.headers = ['<link type="text/css" href="/css/openid.css" rel="stylesheet">',
                        '<meta content="text/html; charset=UTF-8" http-equiv="content-type"/>']
        self.errors = []
        self.forms = []
        self.messages = []
        self.title = title

    def append(self, content):
        self.content += content
    
    def __str__(self):
        buf = ['<html><head>']
        buf.extend(self.headers)
        buf.append('</head><body>')
        buf.extend('<div class="error">%s</div>' % err for err in self.errors)
        buf.extend('<div class="message">%s</div>' % msg for msg in self.messages)
        buf.extend('<div class="form">%s</div>' % form for form in self.forms)
        buf.append(self.content)
        buf.append('</body></html>')
        return '\n'.join(buf)


def simplifyQuery(args):
    """transforms a query dict as stored in twisted's ctx objects
    in a simple arg / value dict

    (twisted's ctx.args objects map arg to list of values)
    """
    query = {}
    for key, value in args.items():
        if type(value) is list:
            if len(value) == 1:
                query[key] = value[0]
            else:
                raise Exception("ooppppssssssssssssssss")
        else:
            query[key] = value
    return query


def getHostName():
    """returns running host name"""
    try:
        from creole.parsedico import parse_dico
    except ImportError:
        ipAddr = '127.0.0.1'
    else:
        dic = parse_dico()
        ipAddr = dic['adresse_ip_eth0']
    return socket.gethostbyaddr(ipAddr)[0]
      
