# -*- coding: UTF-8 -*-
"eole-sso util tests"
import autopath

from util import *

def test_urljoin():
    urltest = 'http://test/'
    paramjoin = 'a=b'
    newurltest = urljoin(urltest, paramjoin)
    assert newurltest == 'http://test/?a=b'
    paramjoin = 'c=d'
    # can accumulate params
    assert urljoin(newurltest, paramjoin) == 'http://test/?a=b&c=d'

def testunescape():
    urltest = 'http://test/&gt;egg&lt;blur&amp;spam'
    assert unescape(urltest, quote=None) == 'http://test/>egg<blur&spam'
    urltest = 'http://test/&gt;egg&lt;blur&amp;spam&quot;blob'
    assert unescape(urltest, quote=True) == 'http://test/>egg<blur&spam"blob'

def test_gen_random_id():
    "this much more to test that it returns something"
    id_result = gen_random_id(prefix='egg')
    assert id_result.startswith('egg')
    #egg6640f2f3efdade0b88da11f9e251c76262ee86b15a9cb65686d8734c
    assert len(id_result) >= 8

def test_gen_ticket_id():
    ticket_id = gen_ticket_id('ST', 'monetab.ac-acad.fr')
    assert "ST-monetab.ac-acad.fr-" in ticket_id
    assert len(ticket_id) >= 25

def test_get_service_from_url():
    urltest = "https://192.168.230.155:8443/?service=https://192.168.230.165/webshare"
    assert get_service_from_url(urltest) == 'https://192.168.230.155:8443/'


