#! /usr/bin/env python
# -*- coding: utf-8 -*-

###########################################################################
#
# Eole NG - 2011
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# check_certs.py
#
# procédure de vérification de la validité des certificats
#
# compatible avec les versions 1 et 2 de la librairie CAS
# (http://www.ja-sig.org/products/cas/)
#
###########################################################################

# Imports pour la gestion de SSL via M2Crypto
from M2Crypto import SSL, X509
# Imports EoleSSO
from eolesso.libsecure import ClientContextFactory
from eolesso.util import is_dn_in_hostname
import config, socket, sys

try:
    from creole.utils import print_orange
    from creole.cert import cert_file as default_cert
except:
    # librairie Creole non disponible, on ne vérifie pas le certificat
    sys.exit(0)

missing_msg = u"""

Attention, les adresses suivantes ne sont pas définies
comme sujet du certificat {0}: {1}

"""

warn_msg = """Les applications utilisant un client CAS en mode proxy
(webmail, ftp, ...) risquent de ne pas fonctionner correctement.
"""

default_msg = """vous pouvez suivre la méthode suivante :

- dans gen_config (onglet certifs-ssl en mode expert) renseignez si besoin
  les adresses manquantes en tant que sujets alternatifs (dns ou ip selon le cas)
- supprimez le certificat (/etc/ssl/certs/eole.crt)
- lancez la commande reconfigure
"""

def run_check():
    # initialisation d'un contexte client permettant de vérifier la validité
    # des certificat (mode proxy)
    client_ctx = ClientContextFactory(certfile = config.CERTFILE, keyfile = config.KEYFILE,
                               mode = SSL.m2.SSL_VERIFY_PEER|SSL.m2.SSL_VERIFY_FAIL_IF_NO_PEER_CERT,
                               ca_location = config.CA_LOCATION)

    peer_cert = X509.load_cert(config.CERTFILE)
    res_verify = client_ctx._cert_verify(peer_cert)
    addr_err = []
    if res_verify:
        # on détermine les adresses à vérifier
        test_addrs = [config.SERVER_IP_ADDR]
        # on vérifie toujours la connexion sur eth0
        local_fqdn = socket.getfqdn(config.SERVER_IP_ADDR)
        if config.AUTH_SERVER_ADDR != local_fqdn:
            # domaine particulier défini (cas_domainname ?)
            test_addrs.append(config.AUTH_SERVER_ADDR)
        try:
            cas_dom = config.dico.get('revprox_domainname', []) or [config.dico.get('web_url', '')]
        except:
            cas_dom = []
        for cas_dom_addr in cas_dom:
            if cas_dom_addr and cas_dom_addr not in test_addrs:
                test_addrs.insert(0, cas_dom_addr)
        # on vérifie les adresses présentes dans le certificat du serveur
        # subject + subjectAltnames
        for addr in test_addrs:
            if not is_dn_in_hostname(client_ctx.peer_cert_data['subject'], addr):
                addr_err.append(addr)
                res_verify = False
    if len(addr_err) > 0:
        missings = missing_msg.format(config.CERTFILE.decode('utf-8'),
                         u", ".join([unicode(addr) for addr in addr_err]))
        print_orange(missings.encode('utf-8'))
        print warn_msg
        if config.CERTFILE == default_cert:
            print default_msg
    return res_verify

if __name__ == '__main__':
    run_check()
