# -*- coding: utf-8 -*-

import sys
sys.path.append('/usr/share')
from sso import config
import ecs_profil

def calc_info(user_infos):
    """
        calcule des Rne d'un utilisateur
    """

    # Si authentification ACAD, on se base sur le FrEduRne
    FrEduRne = getRneAcad(user_infos)
    if FrEduRne != None:
        rnes=[]
        ecs_profil_log("=>ecs_rne with FrEduRne=%s" % str(FrEduRne))
        for affectation in FrEduRne:
            arr=affectation.split("$")
            if len(arr) > 4:
                rnes.append(arr[4].upper())
            else:
                rnes.append(arr[0].upper())
        ecs_profil_log("=>ecs_rne rnes=%s" % str(rnes))
        return rnes

    # Si authentification LDAP-TS, on se base sur le FrEduVecteur
    if is_ts(user_infos):
        FrEduVecteur = user_infos.get('FrEduVecteur',[])
        rnes=[]
        ecs_profil_log("=>ecs_rne is_ts FrEduRne=%s" % str(FrEduRne))
        for vecteur in FrEduVecteur:
            arr=vecteur.split("|")
            rnes.append(arr[4].upper())
        ecs_profil_log("=>ecs_rne rnes=%s" % str(rnes))
        return rnes
   
    # Sur le dn, peut être ?
    dn=user_infos.get('user_dn')
    if 'ou=education,{0}'.format(config.LDAP_BASE) in dn:
        rne_rattach = dn.split(',ou=')[-3]
        rne_rattach=rne_rattach.upper()
        ecs_profil_log("=>ecs_rne from user_dn=%s rne=%s" % (dn,rne_rattach ) )
        return [rne_rattach]

    # Si un rne existe, on le retourne
    rne = user_infos.get('rne',[])
    if rne != None:
        rne=rne[0].upper()
        ecs_profil_log("=>ecs_rne rne=%s" % str(rne))
        return [rne]

    # Pas de rne trouvé
    return []

    
