# -*- coding: utf-8 -*-

def calc_info(user_infos):
    """calcule secureid : identifiant crypté unique pour chaque utilisateur"""
    # vérification des groupes de l'utilisateur
    if 'eleves' in user_infos['user_groups']:
        return user_infos['Meflcf']
    if 'professeurs' in user_infos['user_groups']:
        niveaux = set()
        for group in user_infos['user_groups']:
            if group.startswith('profs-'):
                classe = user_infos['infos_groups'].get(group[6:], {})
                if 'niveau' in classe:
                    niveaux.add(classe['niveau'][0])
        return list(niveaux)
    # autre : rien
    return []
