# -*- coding: utf-8 -*-

use_cache = True

def calc_info(user_infos):
    """
        récupère la valeur du vecteur de fédération frEfuVecteur pour un utilisateur.
        Le vecteur est calculé en amont et stocké dans une base
    """
    FrEduVecteur = user_infos.get('FrEduVecteur', None)
    if FrEduVecteur:
        return FrEduVecteur

    import shelve
    from os.path import isfile
    fredu_db_path = '/usr/share/sso/integrTeleservice.db'
    values = []
    if not isfile(fredu_db_path):
        return values
    # recherche du dn de l'utilisateur
    user_id = user_infos.get('user_dn', None)
    # récupération de l'identifiant dans la base sqlite
    if user_id:
        db = shelve.open(fredu_db_path, 'r')
        # recherche du vecteur associé dans la base
        values = db.get(user_id, [])
    return values
