#! /usr/bin/env python
# -*- coding: utf-8 -*-

###########################################################################
#
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# authform.py
#
# service web de connexion au service sso Eole
#
# compatible avec les versions 1 et 2 de la librairie CAS
# (http://www.ja-sig.org/products/cas/)
#
###########################################################################

import sys, os
import socket
from twisted.internet import reactor
from twisted.web2 import server, channel

# Imports pour la gestion de SSL via M2Crypto
from M2Crypto import SSL

# Imports EoleSSO
from eolesso.libsecure import ServerContextFactory

import config
from page import log
# Backend (gestion des sessions et tickets)
from authserver import SSOSessionManager
# CAS
from cas_resources import XMLRPCManager, LoginForm
# SAML
import saml_resources, saml_message, saml_utils

# modification pour forcer l'encodage interne de python à utf-8
reload(sys)
sys.setdefaultencoding(config.encoding)

# initialisations pour la localisation
APP = 'eolesso'
import locale, gettext
locale.setlocale(locale.LC_ALL, config.LC_ALL)
gettext.bindtextdomain (APP)
gettext.textdomain (APP)
# installons la fonction _() dans les builtins
gettext.install (APP, unicode=0)
try:
    _ = _
except NameError:
    _ = unicode

# Vérification des certificats serveur
try:
    from creole.cert import gen_certif
except:
    def gen_certif(cert_file):
        print _("Creole library not detected, unable to generate %s") % cert_file

if '--test' in sys.argv:
    import doctest
    doctest.testmod(verbose=True)
else:
    from twisted.application import internet, service
    from M2Crypto.SSL import TwistedProtocolWrapper
    # détection du mode syslog
    if "--syslog" in sys.argv:
        use_syslog = True
        from twisted.python import syslog
    else:
        use_syslog = False
    # modification pour utiliser M2Crypto
    class M2Server(internet.SSLServer):
        def _getPort(self):
            """modifié pour gérer les options de log après initialisation par twistd"""
            if use_syslog:
                old_obs = log.theLogPublisher.observers[0]
                new_obs = syslog.SyslogObserver('eolesso', options=syslog.DEFAULT_OPTIONS, facility=syslog.DEFAULT_FACILITY)
                log.addObserver(new_obs.emit)
                log.removeObserver(old_obs)
            return getattr(TwistedProtocolWrapper, 'listenSSL')(*self.args, **self.kwargs)
    # intialisation du serveur
    socket.setdefaulttimeout(config.SOCK_TIMEOUT)
    log.msg("** %s" % _("Initializing SSO Server"))
    # manager de sessions
    manager = SSOSessionManager()
    # load configuration after logger is initialized
    # otherwise configuration messages may not appear
    reactor.callWhenRunning(manager.load_conf)
    # frontend xmlrpc
    auth_server = XMLRPCManager(manager)
    # serveur openid
    baseurl = "https://%s:%s/oid/" % (config.AUTH_SERVER_ADDR, str(config.EOLESSO_PORT))
    # serveur CAS (racine du site)
    root = LoginForm(manager, auth_server)
    # si le certificat n'existe pas, on le génère
    if not os.path.isfile(config.CERTFILE):
        log.msg("** %s ..." % _("Generating ssl certificate"))
        gen_certif(config.CERTFILE)
    #Définition de la taille du pool de thread
    reactor.suggestThreadPoolSize(config.THREAD_POOL_SIZE)
    if int(config.EOLESSO_PORT) == 443:
        port = 8443
    else:
        port = int(config.EOLESSO_PORT)
    log.msg("** %s %s" % (_("Service running on port"), str(port)))
    application = service.Application("eolesso")
    # création du service
    myService = service.IServiceCollection(application)
    ctx = ServerContextFactory(config.CERTFILE, config.KEYFILE, config.CA_LOCATION)
    sso_server = M2Server(port,
                          channel.HTTPFactory(server.Site(root)),
                          ctx)
    sso_server.setServiceParent(myService)
