# -*- coding: utf-8 -*-

use_cache = True

def calc_info(user_infos):
    """calcule groupes (classes, niveaux, disciplines)

    Regroupement en une passe des trois attributs calculés précédents.
    Les informations sont stockées en cache pour la durée de la session utilisateur

    """
    # vérification des groupes de l'utilisateur
    classes = set()
    niveaux = set()
    disciplines = []
    if 'eleves' in user_infos['user_groups']:
        classes.add(user_infos['Divcod'][0])
        niveaux = set(user_infos['Meflcf'])
    if 'professeurs' in user_infos['user_groups']:
        niveaux = set()
        for group in user_infos['user_groups']:
            if group.startswith('profs-'):
                # classes
                classes.add(group[6:])
                # niveaux
                classe = user_infos['infos_groups'].get(group[6:], {})
                if 'niveau' in classe:
                    niveaux.add(classe['niveau'][0])
            # disciplines
            gr_info = user_infos['infos_groups'].get(group, {})
            #if gr_info.get('description', [''])[0].startswith('Matiere '):
            if gr_info.get('type', [''])[0] == 'Matiere':
                disciplines.extend(gr_info['cn'])

    return {'niveaux':list(niveaux) , 'classes': list(classes), 'disciplines':disciplines }
