/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar;

import java.util.Calendar;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import us.k5n.webcalendar.Utils;
import us.k5n.webcalendar.WebCalendarParseException;

public class ActivityLog
extends Vector {
    public String login = null;
    public String calendar = null;
    public char type = (char)63;
    String date = null;
    Calendar dateCalendar;
    public String time = null;
    public String action = null;
    public int id = -1;
    protected String dateTime = null;

    public ActivityLog(Node node) throws WebCalendarParseException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        block2: for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = node2.getNodeName();
            if ("login".equals(string)) {
                this.login = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("id".equals(string)) {
                String string2 = Utils.xmlNodeGetValue(node2);
                try {
                    this.id = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    System.err.println("[" + this.toString() + "]Invalid value for id '" + string2 + "' (ignoring)");
                }
                continue;
            }
            if ("action".equals(string)) {
                this.action = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("calendar".equals(string)) {
                this.calendar = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("type".equals(string)) {
                String string3 = Utils.xmlNodeGetValue(node2);
                if (string3 == null) continue;
                if (string3.trim().length() != 1) {
                    System.err.println("[" + this.toString() + "]Invalid value for type '" + string3 + "' (ignoring)");
                    continue;
                }
                this.type = string3.trim().charAt(0);
                continue;
            }
            if ("date".equals(string)) {
                this.date = Utils.xmlNodeGetValue(node2);
                this.dateCalendar = Utils.YYYYMMDDToCalendar(this.date);
                continue;
            }
            if ("time".equals(string)) {
                this.time = Utils.xmlNodeGetValue(node2);
                if (this.time == null) continue;
                this.time = this.time.trim();
                for (int j = 0; j < this.time.length(); ++j) {
                    char c = this.time.charAt(j);
                    if (c >= '0' && c <= '9') continue;
                    this.time = null;
                    System.err.println("[" + this.toString() + "] Invalid time '" + this.time + "' (ignoring)");
                    this.time = null;
                    continue block2;
                }
                continue;
            }
            System.err.println("[" + this.toString() + "]Not sure what to do with <" + string + "> tag (ignoring)");
        }
        this.dateTime = this.getDate() + ' ' + this.getTime();
    }

    public String getAction() {
        return this.action == null ? "" : this.action;
    }

    public String getType() {
        switch (this.type) {
            case 'C': {
                return "Event created";
            }
            case 'A': {
                return "Event approved";
            }
            case 'X': {
                return "Event rejected";
            }
            case 'U': {
                return "Event updated";
            }
            case 'D': {
                return "Event deleted";
            }
            case 'N': {
                return "Notification sent";
            }
            case 'R': {
                return "Reminder sent";
            }
            case 'F': {
                return "New user via self-registration";
            }
            case 'E': {
                return "New user via email";
            }
        }
        return "Unknown type";
    }

    public String getDate() {
        if (this.date == null) {
            return "????/??/??";
        }
        return this.date.substring(0, 4) + "-" + this.date.substring(4, 6) + "-" + this.date.substring(6, 8);
    }

    public int size() {
        return 5;
    }

    public Object elementAt(int n) {
        switch (n) {
            case 0: {
                return this.getUser();
            }
            case 1: {
                return this.getCalendarUser();
            }
            case 2: {
                return this.dateTime;
            }
            case 3: {
                return this.getType();
            }
            case 4: {
                return this.getAction();
            }
        }
        return "-";
    }

    public String getUser() {
        return this.login;
    }

    public String getTime() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(8);
        int n2 = Integer.parseInt(this.time);
        if (n2 > 3600) {
            n = n2 / 3600;
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n);
            n2 %= 3600;
        }
        stringBuffer.append(':');
        n = n2 / 60;
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        stringBuffer.append(':');
        if ((n2 %= 60) < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        return stringBuffer.toString();
    }

    public String getCalendarUser() {
        return this.calendar == null ? "n/a" : this.calendar;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.calendar != null) {
            stringBuffer.append(this.calendar);
            if (this.login != null) {
                stringBuffer.append(" (");
                stringBuffer.append(this.login);
                stringBuffer.append(")");
            }
        } else if (this.login != null) {
            stringBuffer.append(this.login);
        }
        if (this.action != null) {
            stringBuffer.append(": ");
            stringBuffer.append(this.action);
        }
        return stringBuffer.toString();
    }
}

