# -*- coding: utf-8 -*-
from pyeole.process import system_out
from json import loads

def get_keys(*args, **kwargs):
    code, stdout, stderr = system_out(['/usr/bin/salt-key', '--out=json'])
    if code != 0:
        print('error:', code, stdout, stderr)
    res = []
    data = loads(stdout)
    for mtype in data:
        for key in data[mtype]:
            if mtype == "minions":
                mtype = "Accepted"
            if mtype == "minions_pre":
                mtype = "Unaccepted"
            if mtype == "minions_rejected":
                mtype = "Rejected"
            if mtype == "minions_denied":
                mtype = "Denied"
            res.append({"minion": key , "type": mtype})
    return res

def accept_keys(*args, **kwargs):
    minions = kwargs['__pub_arg']
    for minion in minions:
        code, stdout, stderr = system_out(['/usr/bin/salt-key', '-a', minion['minion'], '-y'])
        if code != 0:
            print('error:', code, stdout, stderr)
    ret = get_keys()
    return ret

def delete_keys(*args, **kwargs):
    minions = kwargs['__pub_arg']
    for minion in minions:
        code, stdout, stderr = system_out(['/usr/bin/salt-key', '-d', minion['minion'], '-y'])
        if code != 0:
            print('error:', code, stdout, stderr)
    ret = get_keys()
    return ret

def reject_keys(*args, **kwargs):
    minions = kwargs['__pub_arg']
    for minion in minions:
        code, stdout, stderr = system_out(['/usr/bin/salt-key', '-r', minion['minion'], '-y'])
        if code != 0:
            print('error:', code, stdout, stderr)
    ret = get_keys()
    return ret

def update_key(*args, **kwargs):
    minions = kwargs['__pub_arg']
    for minion in minions:
        minion_to_update = minion['orig']
        minion_new = minion['minion']
        pillar = {"old": minion_to_update, "new": minion_new}
        code, stdout, stderr = system_out([
            '/usr/bin/salt-run',
            'state.orchestrate',
            'eole-workstation.orch.minion.rename',
            'pillar={}'.format(pillar).replace("'",'"')
           ])
        if code != 0:
            print('error:', code, stdout, stderr)
    ret = get_keys()
    return ret
