# -*- mode: yaml; coding: utf-8 -*-
## vim: ft=yaml ##

include:
  - eole-workstation.veyon

{% from 'eole-workstation/map.jinja' import ews with context %}
{% from 'eole-workstation/macros.jinja' import files_switch %}

{% set veyon = ews.veyon %}

Download Veyon Configuration:
  file.managed:
    - name: {{ veyon.config_dir | path_join(veyon.config_file) }}
    - source: {{ files_switch('eole-workstation:veyon', ['veyon-config.json']) }}
    - template: jinja
    - context:
        veyon: {{ veyon }}

# Always use "cwd" argument
# This avoid error with space in "Program Files"
Import Veyon configuration:
  cmd.run:
    - name: {{ veyon.veyon_ctl }} config import {{ veyon.config_file }}
    - cwd: {{ veyon.config_dir }}
    - require:
      - file: Download Veyon Configuration
    - unless:
      - {{ veyon.check_ldap }}

# Always use "cwd" argument
# This avoid error with space in "Program Files"
# Hide password by passing it as environment variable
Set LDAP password:
  cmd.run:
    - name: {{ veyon.veyon_ctl }} config set LDAP/BindPassword %VEYON_PASSWORD%
    - cwd: {{ veyon.config_dir }}
    - env:
      - VEYON_PASSWORD: {{ veyon.ldap.password }}
    - require:
      - cmd: Import Veyon configuration
    - unless:
      - {{ veyon.check_ldap }}
    # - watch_in:
    #   - service: Restart Veyon service

# Workaround error on windows service restart
# Always use "cwd" argument
# This avoid error with space in "Program Files"
Restart Veyon Service:
  cmd.run:
    - name: {{ veyon.veyon_ctl }} service restart
    - cwd: {{ veyon.config_dir }}
    - onchanges:
      - cmd: Set LDAP password
