# -*- mode: yaml; coding: utf-8 -*-
## vim: ft=yaml ##

{% from 'eole-workstation/map.jinja' import ews with context %}
{% set veyon = ews.veyon %}

Install Veyon software:
  pkg.installed:
    - name: veyon
    - version: {{ veyon.version }}

Start Veyon service:
  service.running:
    - name: {{ veyon.service }}
    - enable: True
    - require:
      - pkg: Install Veyon software

# Always use "cwd" argument
# This avoid error with space in "Program Files"
Register Veyon service:
  cmd.run:
    - name: {{ veyon.veyon_ctl }} service register
    - cwd: {{ veyon.config_dir }}
    - onfail:
      - service: Start Veyon service

