# -*- mode: salt; coding: utf-8 -*-
# vim: ft=sls

{#- Get the `tplroot` from `tpldir` #}
{%- set tplroot = tpldir.split('/')[0] %}
{%- set sls_is_firefox_managed = tplroot ~ ".firefox.is-managed" %}
{%- from tplroot ~ '/map.jinja' import mapdata as ews with context %}
{%- from tplroot ~ '/libtofs.jinja' import files_switch with context %}

{%- set policies = ews | traverse("firefox:policies", {}) %}
{%- set policies_file = ews | traverse("firefox:policies_file", False) %}

{%- if policies_file %}

include:
  - {{ sls_is_firefox_managed }}

eole-workstation/firefox/policies/deployed/policies.json/file.managed:
  file.managed:
    - name: {{ policies_file }}
    - source: {{ files_switch(["firefox-policies.json.jinja", "firefox-policies.json"],
                 lookup="eole-workstation-firefox-policy-deployed-policies.json-file.managed",
                 use_subpath=True
      ) }}
    - template: jinja
    - context:
        policies: {{ {"policies": policies} | json }}
    - makedirs: True
    - require:
      - sls: {{ sls_is_firefox_managed }}
{%-   endif %}
