# -*- mode: salt; coding: utf-8 -*-
# vim: ft=sls

{#- Get the `tplroot` from `tpldir` #}
{%- set tplroot = tpldir.split('/')[0] %}
{%- from tplroot ~ "/map.jinja" import ews with context %}

{% set system_drive = salt['environ.get']('SYSTEMDRIVE', 'C:') %}
{% set is_joined_sem = system_drive + '\\salt\\var\\ad-domain-joined.sem' %}

eole-workstation/ad/member/windows/clean/sem/file.absent:
  file.absent:
    - name: {{ is_joined_sem }}

eole-workstation/ad/member/windows/clean/module.run:
  module.run:
    - name: system.unjoin_domain
    - domain: {{ ews.ad.domain }}
    - username: {{ ews.ad.join_username }}
    - password: {{ ews.ad.join_password }}
    - restart: False
    - disable: True
    - require:
      - file: eole-workstation/ad/member/windows/clean/sem/file.absent

# Remove the grain to avoid an automatic join at reboot
eole-workstation/ad/member/windows/clean/roles/ad/member/grains.list_absent:
  grains.list_absent:
    - name: roles
    - value: ad/member
    - require:
      - module: eole-workstation/ad/member/windows/clean/module.run

# Manually reboot since we can't set a timeout on system.unjoin_domain
#
# Use "only_on_pending_reboot: False" to workaround missdetection of
# needed reboot after join (Should be solved with 2018.3.4+)
# https://github.com/saltstack/salt/pull/49684
eole-workstation/ad/member/windows/clean/reboot/system.reboot:
  system.reboot:
    - message: Leaving the AD domain {{ ews.ad.domain }}
    - timeout: 5
    - in_seconds: True
    - only_on_pending_reboot: False
    - onchanges_any:
      - module: eole-workstation/ad/member/windows/clean/module.run
