# -*- mode: salt; coding: utf-8 -*-
{% from 'eole-workstation/map.jinja' import ews with context %}

{% set system_drive = salt['environ.get']('SYSTEMDRIVE', 'C:') %}
{% set is_joined_sem = system_drive + '\\salt\\var\\ad-domain-joined.sem' %}

Join the computer to the domain:
  system.join_domain:
    - name: {{ ews.ad.domain }}
    - username: {{ ews.ad.join_username }}
    - password: {{ ews.ad.join_password }}
    - restart: False

# Workaround missdetection of needed reboot after join
# https://github.com/saltstack/salt/pull/49684
# Should be solved with 2018.3.4+
Has JoinDomain registry:
  module.run:
    - name: reg.key_exists
    - hive: HKLM
    - key: SYSTEM\CurrentControlSet\Services\Netlogon\JoinDomain
    - require:
      - system: Join the computer to the domain
    - unless:
      - if exist {{ is_joined_sem }} (exit 0) else (exit 1)

Has AvoidSpnSet registry:
  module.run:
    - name: reg.key_exists
    - hive: HKLM
    - key: SYSTEM\CurrentControlSet\Services\Netlogon\AvoidSpnSet
    - require:
      - system: Join the computer to the domain
    - unless:
      - if exist {{ is_joined_sem }} (exit 0) else (exit 1)

Is system joined to a domain:
  cmd.run:
    - name: if (!(Get-WmiObject -Class Win32_ComputerSystem).PartOfDomain) {exit 1}
    - shell: powershell
    - require:
      - system: Join the computer to the domain

# Avoid the failing the "Has * registry" states when the system is
# joined and rebooted
Set a lock when computer is joined:
  file.managed:
    - name: {{ is_joined_sem }}
    - contents: |
        DO NOT TOUCH: this file is automatically generated by SaltStack
    - require:
      - cmd: Is system joined to a domain

Remove the lock when computer is unjoined:
  file.absent:
    - name: {{ is_joined_sem }}
    - onfail:
      - cmd: Is system joined to a domain

# Prepare grains for future formula versions
Add ad/member to roles:
  grains.list_present:
    - name: roles
    - value: ad/member
    - require:
      - cmd: Is system joined to a domain

# Manually reboot since we can't set a timeout on system.join_domain
#
# Use "only_on_pending_reboot: False" to workaround missdetection of
# needed reboot after join (Should be solved with 2018.3.4+)
# https://github.com/saltstack/salt/pull/49684
Reboot after joining the domain:
  system.reboot:
    - message: Joining the AD domain {{ ews.ad.domain }}
    - timeout: 5
    - in_seconds: True
    - only_on_pending_reboot: False
    - onchanges_any:
      - module: Has JoinDomain registry
      - module: Has AvoidSpnSet registry
