# -*- mode: salt; coding: utf-8 -*-
# vim: ft=sls

{#- Get the `tplroot` from `tpldir` #}
{%- set tplroot = tpldir.split('/')[0] %}
{%- set sls_config_hosts = tplroot ~ ".ad.member.linux.config.hosts" %}
{%- set sls_config_krb5 = tplroot ~ ".ad.member.linux.config.krb5" %}
{%- from tplroot ~ "/map.jinja" import ews with context %}

include:
  - {{ sls_config_hosts }}
  - {{ sls_config_krb5 }}

{%- set test_join_cmd = "realm discover " ~ ews.ad.domain | upper ~ " | grep -qs 'configured. kerberos-member'" %}

eole-workstation/ad/member/linux/join/passwd-file/file.managed:
  file.managed:
    - name: /root/kinit-passwd
    - contents: {{ ews.ad.join_password }}
    - contents_newline: False
    - unless: {{ test_join_cmd }}
    - require:
      - sls: {{ sls_config_hosts }}
      - sls: {{ sls_config_krb5 }}

eole-workstation/ad/member/linux/join/kinit/cmd.run:
  cmd.run:
    - name: kinit --password-file=/root/kinit-passwd {{ ews.ad.join_username }}
    - onchanges:
      - file: eole-workstation/ad/member/linux/join/passwd-file/file.managed

eole-workstation/ad/member/linux/join/join/cmd.run:
  cmd.run:
    - name: realm -v join --unattended "{{ ews.ad.domain }}"
    - onchanges:
      - cmd: eole-workstation/ad/member/linux/join/kinit/cmd.run

eole-workstation/ad/member/linux/join/kdestroy/cmd.run:
  cmd.run:
    - name: kdestroy
    - onchanges:
      - cmd: eole-workstation/ad/member/linux/join/kinit/cmd.run

eole-workstation/ad/member/linux/join/passwd-file/file.absent:
  file.absent:
    - name: /root/kinit-passwd
