# -*- mode: salt; coding: utf-8 -*-
# vim: ft=sls

{#- Get the `tplroot` from `tpldir` #}
{%- set tplroot = tpldir.split('/')[0] %}
{%- set sls_package_install = tplroot ~ ".ad.member.linux.package.install" %}
{%- set sls_sssd_service = tplroot ~ ".ad.member.linux.service.running" %}
{%- from tplroot ~ "/map.jinja" import ews with context %}

include:
  - {{ sls_package_install }}
  - {{ sls_sssd_service }}

eole-workstation/ad/member/linux/mount/config/sssd/use_fully_qualified_names/file.replace:
  file.replace:
    - name: {{ ews.ad.sssd.config }}
    - pattern: '^(use_fully_qualified_names).*'
    - repl: '\1 = {{ ews.ad.mount.use_fully_qualified_names }}'
    - require:
      - sls: {{ sls_package_install }}
    - watch_in:
      - sls: {{ sls_sssd_service }}

eole-workstation/ad/member/linux/mount/config/sssd/fallback_homedir/file.replace:
  file.replace:
    - name: {{ ews.ad.sssd.config }}
    - pattern: '^(fallback_homedir).*'
    - repl: '\1 = {{ ews.ad.mount.fallback_homedir }}'
    - require:
      - sls: {{ sls_package_install }}
    - watch_in:
      - sls: {{ sls_sssd_service }}
