# -*- mode: salt; coding: utf-8 -*-
{% from 'eole-workstation/map.jinja' import ews with context %}

Join the computer to the domain:
  system.join_domain:
    - name: {{ ews.ad.domain }}
    - username: {{ ews.ad.join_username }}
    - password: {{ ews.ad.join_password }}
    - restart: False


# Prepare grains for future formula versions
Add ad/member to roles:
  grains.list_present:
    - name: roles
    - value: ad/member
    - require:
      - system: Join the computer to the domain

# Manually reboot since we can't set a timeout on system.join_domain
# Trigger only `onchanges` to the join since `only_on_pending_reboot`
# could be true for other reasons (like updates)
Reboot after joining the domain:
  system.reboot:
    - message: Joining the AD domain {{ ews.ad.domain }}
    - timeout: 20
    - in_seconds: True
    - only_on_pending_reboot: False
    - order: last
    - onchanges:
      - system: Join the computer to the domain
