Set-PSDebug -Trace 0
Start-Transcript -Path "$env:TEMP\install-minion.log"
try 
{
    Set-ExecutionPolicy Bypass -Scope Process -Force
    
    if ($PSVersionTable.PSVersion.Major -le 4)
    {
        Write-Host "You must use PowerShell 4.0 or above."
        exit -1
    }
    Set-Location $env:TEMP
    
    $isAdmin=([Security.Principal.WindowsPrincipal] [Security.Principal.WindowsIdentity]::GetCurrent()).IsInRole([Security.Principal.WindowsBuiltInRole]::Administrator)
    if ( -Not( $isAdmin ) )
    {
        Write-Host "Vous n'êtes pas 'Administrateur' ou dans une session 'Elevated'"
        exit -2
    }
    
    $testConnection = Test-Connection -Count 1 -ComputerName salt
    if ( $testConnection )
    {
        $ip = $testConnection.IPV4Address
        #Write-Host "ip = $ip"
        $ipSaltMaster = $ip.IPAddressToString
        #Write-Host "ipSaltMaster = $ipSaltMaster"
    }
    else
    {
        Write-Host "La résolution du nom 'salt' n'est pas fonctionnelle. Configurer l'enregistrement DNS sur le serveur DNS."
        exit -3
    }
    
    if( -Not ($ipSaltMaster) )
    {
        Write-Host "L'adresse ip du nom 'salt' n'est pas correcte."
        exit -3
    }
    
    $saltMinionConfFile="$env:TEMP\installMinion.conf"
    #Write-Host "saltMinionConfFile = $saltMinionConfFile"
    $saltMinionConfUrl="http://$ipSaltMaster/joineole/installMinion.conf"
    [System.Net.ServicePointManager]::ServerCertificateValidationCallback = {$true}
    $wc = New-Object System.Net.WebClient
    Write-Host "service salt-minion n'existe pas, je le télécharge depuis $saltMinionConfUrl"
    $wc.DownloadFile($saltMinionConfUrl, $saltMinionConfFile)
    if($LastExitCode)
    { 
        Write-Host "Impossible de télécharger '$saltMinionConfUrl'. Stop!"
        exit -4 
    } 
    
    $context = @{}
    switch -regex -file $saltMinionConfFile {
        "^#.*" {
            #Write-Host "commentaire"
        }
        "^([^=]+)=(.+?)$" {
            $name, $value = $matches[1..2]
            $context[$name] = $value
        }
    }
    
    [string]$debug = $context["debug"]
    if ( $debug -eq "1" )
    {
        Set-PSDebug -Trace 1
    }
    
    # salt-version contient la version + l'architecture
    if( $env:PROCESSOR_ARCHITECTURE -eq 'AMD64' )
    { 
        [string]$saltVersion = $context["salt-version-amd64"]
    }
    else
    { 
        [string]$saltVersion = $context["salt-version-x86"]
    }
    
    #Write-Host "saltVersion= $saltVersion"
    $saltMinionSetupName="Salt-Minion-$saltVersion-Setup.exe"
    $saltMinionSetupUrl="http://$ipSaltMaster/joineole/saltstack/$saltMinionSetupName"
    #Write-Host "saltMinionSetupUrl = $saltMinionSetupUrl"
    $saltMinionSetupFile="$env:TEMP\$saltMinionSetupName"
    #Write-Host "SaltMinionSetupFile = $SaltMinionSetupFile"
    if (!(Test-Path $saltMinionSetupFile))
    {
        Write-Host "service salt-minion n'existe pas, je le télécharge ..."
        $wc.DownloadFile($saltMinionSetupUrl, $saltMinionSetupFile)
        if($LastExitCode)
        { 
            Write-Host "Impossible de télécharger '$saltMinionSetupUrl'. Stop!"
            exit -5 
        } 
        #Unblock-File $saltMinionSetupFile
    }
    
    $installersSalt = ((Get-ChildItem "HKLM:\Software\Microsoft\Windows\CurrentVersion\Uninstall") |
                        Where-Object { $_.GetValue( "DisplayName" ) -like "*Salt Minion*" } );
    if ( $installersSalt.Length -eq 0 )
    {
        if ( $env:PROCESSOR_ARCHITECTURE -eq 'AMD64' )
        {
            $installersSalt = ((Get-ChildItem "HKLM:\Software\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall") |
                                Where-Object { $_.GetValue( "DisplayName" ) -like "*Salt Minion*" } );
        }
    }
    if ( $installersSalt.Length -eq 0 )
    {
        $installedSaltVersion = $null
    }
    else
    {
        $installedSaltVersion = $installersSalt[0].GetValue( "DisplayVersion" )
    }
    
    $pss = Get-Service 'salt-minion' -ErrorAction SilentlyContinue
    if ( $pss -eq $null )
    {
        Write-Host "service salt-minion n'existe pas, je l'installe ..."
        CMD.Exe /C "$saltMinionSetupFile" /S
        $pss = Get-Service 'salt-minion' -ErrorAction SilentlyContinue
        if ( $pss -eq $null )
        {
            Write-Host "Le service salt-minion n'existe pas après l'installation. C'est une erreur grave."
            exit -6
        }
    }
    else
    {
        Write-Debug "service salt-minion existe !"
    }
    
    
    $saltMinionConfName="startup.conf"
    $saltMinionConfUrl="http://$ipSaltMaster/joineole/saltMinion.conf"
    #Write-Host "$saltMinionConfUrl"
    $saltMinionConfFile="$env:TEMP\$saltMinionConfName"
    #Write-Host "$SaltMinionConfFile"
    $wc.DownloadFile($saltMinionConfUrl, $saltMinionConfFile)
    if($LastExitCode)
    { 
        Write-Host "Impossible de télécharger '$saltMinionSetupUrl'. Stop!"
        exit -4 
    } 
    
    if ( Test-Path /salt/conf/minion.d/startup.conf )
    {
        Write-Debug "Le client est déjà initialisé"
    }
    else
    {
        Get-Content $saltMinionConfFile | Set-Content /salt/conf/minion.d/startup.conf
        Write-Host "Le client est arrêté..."
        Stop-Service 'salt-minion' -ErrorAction SilentlyContinue
        Write-Host "Le client est redémarre..."
        Restart-Service 'salt-minion' -ErrorAction SilentlyContinue
        Write-Host "Le client est initialisé"
    }
    
}
Finally
{
    Set-PSDebug -Trace 0
    Stop-Transcript -ErrorAction SilentlyContinue
}
