#!/bin/bash

set -e

# Penser à mettre à jour le lien vers OS supporté en cas de mise à jour dans index.html
VERSION=3004

log() {
    echo $1
}

doDownload() {
    # copy of the function __fetch_url from bootstrap-salt.sh
    curl $_CURL_ARGS -L -s -f -o "$1" "$2" >/dev/null 2>&1     ||
        wget $_WGET_ARGS -q -O "$1" "$2" >/dev/null 2>&1       ||
            fetch $_FETCH_ARGS -q -o "$1" "$2" >/dev/null 2>&1 ||  # FreeBSD
                fetch -q -o "$1" "$2" >/dev/null 2>&1          ||  # Pre FreeBSD 10
                    (log "$2 failed to download to $1"; exit 4)
}

errorGuardian() {
    log "La réponse du serveur n'est pas la bonne"
    log "Vérifier votre configuration de filtrage. exit=4"
    exit 4
}

doInstallMinion() {
    #############################################################################
    # Phase 2 : check Slat dns
    #############################################################################
    log "check 'salt' dns resolution ?"
    SaltMasterHost=$(getent hosts salt 2> /dev/null | awk '{print $2}')
    if [ -z "${SaltMasterHost}" ]
    then
        log "La résolution du nom 'salt' n'est pas fonctionnelle. Configurer l'enregistrement DNS sur le serveur DNS. exit=3"
        exit 3
    fi
    log "La résolution du nom 'salt' est fonctionnelle: ${SaltMasterHost}"
    export no_proxy="salt,${SaltMasterHost}"
    #############################################################################
    # Phase 3 : téléchargement de 'bootstrap-salt' depuis le scribe
    #############################################################################
    saltMinionUrl="http://$SaltMasterHost/joineole/bootstrap-salt/bootstrap-salt.sh"
    saltMinionFile="/tmp/bootstrap-salt.sh"
    doDownload "$saltMinionFile" "$saltMinionUrl"
    doDownload "$saltMinionFile.sha256" "$saltMinionUrl.sha256"
    cd /tmp
    sha256sum -c $saltMinionFile.sha256
    cd -
    grep -q guardian $saltMinionFile && errorGuardian || true
    #############################################################################
    # Phase 7 : install du service ?
    #############################################################################
    if [ ! "$http_proxy" = "" ]; then
        SALT_ARG="-H $http_proxy"
    else
        SALT_ARG=""
    fi
    sudo sh $saltMinionFile $SALT_ARG -x python3 -P stable $VERSION
    #############################################################################
    # Phase 8 : configuration du minion avant re démarrage
    ######### ####################################################################
    if [ ! -f /salt/conf/minion.d/startup.conf ]; then
        log "---"
        log "Ecriture de /salt/conf/minion.d/startup.conf"
        sudo salt-call --local file.write /etc/salt/minion.d/startup.conf 'startup_states: hightstate'
        log "Ajout des rôles ad/member, veyon/master et veyon/client"
        sudo salt-call --local grains.append roles '["ad/member", "veyon/master", "veyon/client"]'

        #############################################################################
        # Phase 9 : redémarrage
        #############################################################################
        log "restart salt-minion..."
        sudo systemctl restart salt-minion.service
    fi
    log "salt-minion ok"
}

doInstallMinion

exit 0
