# -*- coding: utf-8 -*-

%if %%is_defined('smb_workgroup')
# for Scribe 2.7
    %set %%fqdn_domain = %%ad_domain
    %set %%workgroup = %%smb_workgroup
    %set %%dc_domain = 'addc.' + %%fqdn_domain
    %set %%mount_extra_dirs = True
    %set %%mount_server = %%nom_domaine_machine
%else
# for Seth
    %set %%fqdn_domain = %%ad_realm
    %set %%workgroup = %%ad_domain
    %set %%dc_domain = %%nom_domaine_machine
    %set %%mount_extra_dirs = False
    %if %%activer_ad_homes_share == 'oui'
        %set %%mount_server = %%nom_domaine_machine
    %else
        %set %%mount_server = %%ad_homes_share_host + '.' + %%ad_realm
    %end if
%end if

%set %%basedn = 'dc=' + %%custom_join(%%fqdn_domain.split('.'), ',dc=')
%set %%boolean = {'oui': True, 'non': False}

eole-workstation:

  ad:

    dc: %%dc_domain
    domain: %%fqdn_domain
    join_username: eole-workstation-manager
    join_password: %include '/etc/eole/private/eole-workstation-manager.password'

    mount:
      shares:
        "~":
          server: "%%mount_server"
          path: "%(USER)/"
          groups:
            - "domain users"

%if %%mount_extra_dirs
        "~/commun":
          server: "%%mount_server"
          path: "commun/"
          groups:
            - "domain users"

        "~/professeurs":
          server: "%%mount_server"
          path: "professeurs/"
          groups:
            - "domain users"
            - "professeurs"
%end if

  veyon:

    enable: %%boolean[%%eole_workstation_enable_veyon]
    ldap:

      server: %%dc_domain
      port: 389
      base_dn: %%basedn
      username: cn=eole-workstation-reader,cn=Users,%%basedn
      password: %include '/etc/eole/private/eole-workstation-reader.password'
