# -*- coding: utf-8 -*-
{%- load_yaml as veyon_authorized_user_groups %}
{%-   include "/var/lib/eole/config/veyon.yaml" ignore missing %}
{%- endload -%}

%if %%getVar('smb_workgroup', False)
# for Scribe 2.7
    %set %%fqdn_domain = %%ad_domain
    %set %%workgroup = %%smb_workgroup
    %set %%dc_domain = 'addc.' + %%fqdn_domain
    %set %%mount_extra_dirs = True
    %set %%mount_server = %%nom_domaine_machine
%else
# for Seth
    %set %%fqdn_domain = %%ad_realm
    %set %%workgroup = %%ad_domain
    %set %%dc_domain = %%nom_domaine_machine
    %set %%mount_extra_dirs = False
    %if %%activer_ad_homes_share == 'oui'
        %set %%mount_server = %%nom_domaine_machine
    %else
        %set %%mount_server = %%ad_homes_share_host + '.' + %%ad_realm
    %end if
%end if

%set %%basedn = 'dc=' + %%custom_join(%%fqdn_domain.split('.'), ',dc=')
%set %%boolean = {'oui': True, 'non': False}

eole-workstation:
  veyon:

    enable: %%boolean[%%eole_workstation_enable_veyon]
    authorized_user_groups: {{ veyon_authorized_user_groups
                               | traverse(
                                   "veyon:authorized_user_groups",
                                   [
                                     "CN=Domain Admins,CN=Users",
                                     "CN=professeurs,CN=Users",
                                   ],
                               )
                            }}

%if %%veyon_allow_adding_hidden_locations == 'oui'
    allow_adding_hidden_locations: True
%else
    allow_adding_hidden_locations: False
%end if
    ldap:

      server: %%dc_domain
      port: 389
      base_dn: %%basedn
      username: cn=eole-workstation-reader,cn=Users,%%basedn
      password: %include '/etc/eole/private/eole-workstation-reader.password'
