# -*- coding: utf-8 -*-
{%- load_yaml as veyon_authorized_user_groups %}
{%-   include "/var/lib/eole/config/veyon.yaml" ignore missing %}
{%- endload -%}

%if %%getVar('smb_workgroup', False)
# for Scribe 2.7
    %set %%fqdn_domain = %%ad_domain
    %set %%workgroup = %%smb_workgroup
    %set %%dc_domain = 'addc.' + %%fqdn_domain
    %set %%password_file = '/etc/eole/private/eole-workstation-reader.password'
%else
# for Seth
    %set %%fqdn_domain = %%ad_realm
    %set %%workgroup = %%ad_domain
    %if %%getVar('ad_calc_dc_domainname', False)
        %set %%dc_domain = %%ad_calc_dc_domainname
    %else
        %set %%dc_domain = %%nom_domaine_machine
    %end if
    %set %%password_file = %%container_path_domaine + '/etc/eole/private/eole-workstation-reader.password'
%end if

%set %%basedn = 'dc=' + %%custom_join(%%fqdn_domain.split('.'), ',dc=')
%set %%boolean = {'oui': True, 'non': False}

eole-workstation:
  veyon:

    enable: %%boolean[%%eole_workstation_enable_veyon]
    authorized_user_groups: {{ veyon_authorized_user_groups
                               | traverse(
                                   "veyon:authorized_user_groups",
                                   [
                                     "CN=Domain Admins,CN=Users",
                                     "CN=professeurs,CN=Users",
                                   ],
                               )
                            }}

%if %%veyon_allow_adding_hidden_locations == 'oui'
    allow_adding_hidden_locations: True
%else
    allow_adding_hidden_locations: False
%end if
    ldap:

      server: %%dc_domain
      port: 389
      base_dn: %%basedn
      username: cn=eole-workstation-reader,cn=Users,%%basedn
      password: %include %%password_file
