# -*- mode: salt; coding: utf-8 -*-
# vim ft=sls

%if %%getVar('smb_workgroup', False)
# for Scribe 2.7
    %set %%fqdn_domain = %%ad_domain
    %set %%mount_extra_dirs = True
    %set %%mount_server = %%nom_domaine_machine
%else
# for Seth
    %set %%fqdn_domain = %%ad_realm
    %set %%mount_extra_dirs = False
    %if %%getVar('ad_server_netbios_name_member', False)
        %set %%mount_server = %%ad_server_netbios_name_member + '.' + %%ad_realm
    %else
        %if %%activer_ad_homes_share == 'oui'
            %set %%mount_server = %%nom_domaine_machine
        %else
            %set %%mount_server = %%ad_homes_share_host + '.' + %%ad_realm
        %end if
    %end if
%end if

pam-mount:
  pkg:
    dependencies:
      # SMB with sec=krb5
      - cifs-utils
      - keyutils
  volumes:
    "~":
      parameters:
        fstype: cifs
        server: "%%mount_server"
        path: "%(USER)/"
        options:
          username: "%(USER)"
          domain: "%%fqdn_domain"
          uid: "%(USERUID)"
          sec: "krb5"
          cruid: "%(USERUID)"
          file_mode: "0600"
          dir_mode: "0700"
          cifsacl: true
      user_control:
        - sgrp: domain users

%if %%mount_extra_dirs
    "~/commun":
      parameters:
        fstype: cifs
        server: "%%mount_server"
        path: "commun/"
        options:
          username: "%(USER)"
          domain: "%%fqdn_domain"
          uid: "%(USERUID)"
          sec: "krb5"
          cruid: "%(USERUID)"
          file_mode: "0600"
          dir_mode: "0700"
          cifsacl: true
      user_control:
        - sgrp: domain users

    "~/professeurs":
      parameters:
        fstype: cifs
        server: "%%mount_server"
        path: "professeurs/"
        options:
          username: "%(USER)"
          domain: "%%fqdn_domain"
          uid: "%(USERUID)"
          sec: "krb5"
          cruid: "%(USERUID)"
          file_mode: "0600"
          dir_mode: "0700"
          cifsacl: true
      user_control:
        - and:
            - sgrp: domain users
            - sgrp: professeurs
%end if
