SALT_VERSION      := 3007.5

SALT_AMD64_BIN    := Salt-Minion-$(SALT_VERSION)-Py3-AMD64-Setup.exe
SALT_AMD64_SHA256 := Salt-Minion-$(SALT_VERSION)-Py3-AMD64-Setup.exe.sha256

SALT_X86_BIN      := Salt-Minion-$(SALT_VERSION)-Py3-x86-Setup.exe
SALT_X86_SHA256   := Salt-Minion-$(SALT_VERSION)-Py3-x86-Setup.exe.sha256

DOWNLOAD_FILES    := $(SALT_AMD64_BIN) $(SALT_X86_BIN)

salt_DIR := $(DESTDIR)/usr/share/eole/workstation/saltstack

clean::
	rm -f *.exe

$(DOWNLOAD_FILES):
	wget -N --progress=dot:mega http://eole.ac-dijon.fr/workstation/saltstack/$@
	sha256sum -c $@.sha256

install-dirs::
	$(INSTALL_DIRECTORY) $(salt_DIR)

install-files:: $(DOWNLOAD_FILES)
	$(INSTALL_DATA) $(SALT_AMD64_BIN) $(salt_DIR)
	$(INSTALL_DATA) $(SALT_AMD64_SHA256) $(salt_DIR)
	$(INSTALL_DATA) $(SALT_X86_BIN) $(salt_DIR)
	$(INSTALL_DATA) $(SALT_X86_SHA256) $(salt_DIR)
