# -*- coding: utf-8 -*-

def is_dn_elements_list(data):
    """Raise ValueError if data can not be split with given separator.
    """
    import re
    separator = u', ' #fixed value used in templates
    ldap_forbidden_characters = re.compile(r"((?<!\\)[,+<>;\n\r=])|(\\(?![,+\\<>;\n\r=]))")
    sep_re = re.compile(r"(?<!\\){}".format(separator))
    elements = sep_re.split(data)
    forbidden_characters = [ldap_forbidden_characters.findall(el) for el in elements]
    if sum([len(forbidden_character) for forbidden_character in forbidden_characters]) > 0:
            raise ValueError(u'Invalid list given. Check separator or escape reserved characters. Generated list: {0}. Reserved characters: {1}'.format(elements, forbidden_characters))
